/** @type {import('tailwindcss').Config} */
const withMT = require("@material-tailwind/react/utils/withMT");
module.exports = withMT({
  content: [
    "./src/pages/**/*.{js,ts,jsx,tsx,mdx}",
    "./src/components/**/*.{js,ts,jsx,tsx,mdx}",
    "./src/app/**/*.{js,ts,jsx,tsx,mdx}",
  ],
  plugins: [require("flowbite/plugin")],
  theme: {
    extend: {
      screens: {
        xm: "420px",
        sm: "540px",
        md: "768px",
        lg: "1024px",
        xl: "1280px",
        "2xl": "1536px",
      },
      container: {
        center: true,
        padding: "2rem",
      },
      colors: {
        primary: "#B9802A",
        secondary: "#000000",
        black: "#000000",
        golden: "#D8A32B",
        darkgrey: "#555555",
        grey: "#9D9D9D",
        whitegrey: "#F5F5F5",
        white: "#FFFFFF",
        lightredish: "#EFF4FF",
        light_dark_redish: "#E4DDFF",
        purple: "#2525AD",
        light_purple: "#2B59CE",
        darkblue: "#3458a1",
        lightblue: "#92a9d1",
      },

      boxShadow: {
        custom1: "0px 2px 40px 0px rgba(8, 70, 78, 0.08)",
        custom2: "0px 0px 30px 0px rgba(8, 73, 81, 0.06)",
      },

      backgroundImage: {
        "gradient-radial": "radial-gradient(var(--tw-gradient-stops))",
        "gradient-conic":
          "conic-gradient(from 180deg at 50% 50%, var(--tw-gradient-stops))",
        "custom-gradient": "linear-gradient(to right, #C9DCDF, #E4E9E9)",
      },

      gradientColorStops: {
        darkblue: "#3458a1",
        lightblue: "#92a9d1",
      },
    },
  },
  plugins: [require("tailwind-scrollbar")],
});
