import { usePathname, useRouter } from "next/navigation";
import { useEffect } from "react";
import { useSelector } from "react-redux";
import { createAsyncThunk } from "@reduxjs/toolkit";
import { API_END_POINTS } from "@/services/ApiEndpoints";
import { useDispatch } from "react-redux";
import { userLogout } from "@/redux/authSlice";


const ProtectedRoutes = ({ children }) => {
  const auth = useSelector((data) => data?.auth);
  const router = useRouter();
  const pathname = usePathname();
  const dispatch = useDispatch();

  console.log(auth);

  const userLoginFetchCall = createAsyncThunk(
    "userLoginCall/userLoginCall",

    async (id, { getState }) => {
      const token = getState().auth?.token;

      try {
        const res = await fetch(
          `${API_END_POINTS.userTokenLoginCheck}`,
          {
            headers: {
              Authorization: `Bearer ${token}`,
              "Content-Type": "application/json",
            },
            method: "POST",
          }
        );
        
        const data = await res.json();
        if (!data.Ok) throw new Error("Token Not valid");
        return await response.json();
      } catch (error) {
        throw error;
      }
    }
  );

  const userRestrictedPaths = [
    "/coming-soon",
    "/login",
    "/otp",
    "/sign-up",
    "/forgot-password",
    "/new-password",
  ];

  const allowedPathAll = [
    "/login",
    "/otp",
    "/quick-survey",
    "/sign-up",
    "/forgot-password",
    "/new-password",
    "/about",
    "/blog",
    "/certificates",
    "/contact-us",
    "/course",
    "/faq",
  ];

  const adminRestrictedPaths = [
    "/login",
    "/otp",
    "/sign-up",
    "/forgot-password",
    "/new-password",
    "/about",
    "/blog",
    "/certificates",
    "/contact-us",
    "/course",
    "/faq",
    "/quick-survey",
    "/courses",
    "/payment",
    "/certifications",
    "/assignments",
  ];

  useEffect(() => {
    // const isPublicPath = allowedPaths.includes(pathname);
    const isAllowedPathAll = allowedPathAll.includes(pathname);
    const isUserRestrictedPath = userRestrictedPaths.includes(pathname);
    const isAdminRestrictedPath = adminRestrictedPaths.includes(pathname);
    const role = auth?.userDetail?.role?.name;
    
    // if (!auth?.isLoggedIn || !auth?.userDetail) {
    //   if (!isAllowedPathAll) {
    //     router.push("/coming-soon");
    //   }
    //   return;
    // }

    // // Not logged in and trying to access protected route
    // if (!auth?.isLoggedIn && !auth?.userDetail && !isPublicPath) {
    //   router.push("/coming-soon");
    //   return;
    // }
    
    if (auth?.isLoggedIn && role === "admin" && isAdminRestrictedPath) {
      window.location.href = "https://admin-panel.agentambitionacademy.com/dashboard";
      return;
    }

    // Logged in with user or admin role, trying to access a public page
    // if (auth?.isLoggedIn && role === "user" && isUserRestrictedPath) {
    //   router.push("/dashboard"); // Redirect to dashboard or another allowed route
    //   return;
    // }

  }, [auth, pathname, router]);

// useEffect(() => {
//     const isAllowedPath = allowedPaths.includes(pathname);

//     if (!auth?.isLoggedIn && !auth?.userDetail && !isAllowedPath) {
//       router.push("/home");
//       return; // Exit early if the path is not allowed
//     }
    

//     // if (auth?.isLoggedIn && auth?.userDetail && isAllowedPath) {
//     // let loginCheck = dispatch(userLoginFetchCall());
//     // loginCheck.then((action) => {
//     //     console.log(action)
//     //     if (action) {
//     //     } else { }
//     //   }).catch((error) => {
//     //     console.log("Error during login check:", error);
//     //   });
    
//     // }
//   }, [auth, pathname, router, dispatch]);

  return <>{children}</>;
};

export default ProtectedRoutes;
