import { createAsyncThunk, createSlice } from "@reduxjs/toolkit";
import { API_END_POINTS } from "@/services/ApiEndpoints";

const initialState = {
  enrolledCourses: null,
};

export const fetchEnrolledCourses = createAsyncThunk(
  "enrolledCourses/fetchEnrolledCourses",
  async (_, { getState }) => {
    const token = getState().auth?.token;

    try {
      const response = await fetch(API_END_POINTS.getEnrolledCourses, {
        headers: {
          Authorization: `Bearer ${token}`,
          method: "GET",
        },
      });
      if (!response.ok) throw new Error("Failed to fetch enrolled courses");
      return await response.json();
    } catch (error) {
      throw error;
    }
  }
);

export const enrolledCoursesSlice = createSlice({
  name: "enrolledCourses",
  initialState,
  reducers: {
    getEnrolledCourses: (state, action) => {
      state.enrolledCourses = action.payload;
    },
  },
  extraReducers: (builder) => {
    builder.addCase(fetchEnrolledCourses.fulfilled, (state, action) => {
      state.enrolledCourses = action.payload;
    });
  },
});

export const { getEnrolledCourses } = enrolledCoursesSlice.actions;
export default enrolledCoursesSlice.reducer;
