"use client";
import { Montserrat } from "next/font/google";
import { Nunito } from "next/font/google";
import { Toaster } from "react-hot-toast";

const montserrat = Montserrat({
  weight: ["300", "400", "500", "600", "700", "800"],
  subsets: ["latin"],
  variable: "--font-montserrat",
});

const nunito = Nunito({
  weight: ["300", "400", "500", "600", "700", "800"],
  subsets: ["latin"],
  variable: "--font-nunito",
});

import { Providers } from "../redux/providers";
import { Suspense } from "react";
import "./globals.css";
import ScrollToTopButton from "./components/ScrollToTop/ScrollToTopButton";
import ProtectedRoutes from "@/utils/ProtectedRoutes";

export default function RootLayout({ children }) {

  return (
    <html lang="en">
      <head>
        <meta name="title" content="Pay4" />
        <meta name="description" content="Generated by create next app" />
        <title>Agent Ambition Academy</title>
      </head>
      <body className={`${montserrat?.variable} ${nunito?.variable}`}>
        <Providers>
          <Suspense>
            <Toaster />
            <ProtectedRoutes>
              {children}
            </ProtectedRoutes>
            <ScrollToTopButton />
          </Suspense>
        </Providers>
      </body>
    </html>
  );
};