"use client";
import React, { useEffect, useState } from "react";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faImage, faFile, faEnvelope } from "@fortawesome/free-solid-svg-icons";
import { faClock } from "@fortawesome/free-solid-svg-icons";
import { faYoutube } from "@fortawesome/free-brands-svg-icons";
import { faGraduationCap } from "@fortawesome/free-solid-svg-icons";
import image1 from "../../../../public/assets/home/featureVideos/image1.jpg";
import image2 from "../../../../public/assets/home/featureVideos/image2.jpg";
import image3 from "../../../../public/assets/home/featureVideos/image3.png";
import image4 from "../../../../public/assets/home/featureVideos/image4.png";
import image5 from "../../../../public/assets/home/featureVideos/image5.png";
import image6 from "../../../../public/assets/home/featureVideos/image6.png";
import Image from "next/image";
import Link from "next/link";
import { useGetCategoriesQuery } from "@/services/Api";

const Course = () => {
  const [showAll, setShowAll] = useState(false);

  const { data: getCategories, refetch: getCategoriesRefetch } =
    useGetCategoriesQuery();

  const data = [
    {
      title: "Property Management",
      courses: "38 Courses",
      logo: <FontAwesomeIcon icon={faImage} size="lg" />,
    },
    {
      title: "Property Management",
      courses: "38 Courses",
      logo: <FontAwesomeIcon icon={faYoutube} size="lg" />,
    },
    {
      title: "property Management",
      courses: "38 Courses",
      logo: <FontAwesomeIcon icon={faFile} size="lg" />,
    },
    {
      title: "property Management",
      courses: "38 Courses",
      logo: <FontAwesomeIcon icon={faEnvelope} size="lg" />,
    },
    {
      title: "property Management",
      courses: "38 Courses",
      logo: <FontAwesomeIcon icon={faFile} size="lg" />,
    },
    {
      title: "property Management",
      courses: "38 Courses",
      logo: <FontAwesomeIcon icon={faImage} size="lg" />,
    },
    {
      title: "property Management",
      courses: "38 Courses",
      logo: <FontAwesomeIcon icon={faYoutube} size="lg" />,
    },
    {
      title: "property Management",
      courses: "38 Courses",
      logo: <FontAwesomeIcon icon={faImage} size="lg" />,
    },
    {
      title: "property Management",
      courses: "38 Courses",
      logo: <FontAwesomeIcon icon={faYoutube} size="lg" />,
    },
    {
      title: "property Management",
      courses: "38 Courses",
      logo: <FontAwesomeIcon icon={faFile} size="lg" />,
    },
  ];

  const videos = [
    {
      img: image1,
      text: "by Determined-Poitras",
      title: "Bespoke – Add Storytelling to Your Real Estate Videos",
      weeks: "2Weeks",
      students: "156 Students",
    },
    {
      img: image2,
      text: "by Determined-Poitras",
      title: "Brandon Bames – Make It Unique",
      weeks: "2Weeks",
      students: "156 Students",
    },
    {
      img: image3,
      text: "by Determined-Poitras",
      title: "The Corcoran Group – Focus on the Main Attractions",
      weeks: "2Weeks",
      students: "156 Students",
    },
    {
      img: image4,
      text: "by Determined-Poitras",
      title: "MGroup – Appeal to Sellers Too",
      weeks: "2Weeks",
      students: "156 Students",
    },
    {
      img: image5,
      text: "by Determined-Poitras",
      title: "Haus – Educate Your Audience",
      weeks: "2Weeks",
      students: "156 Students",
    },
    {
      img: image6,
      text: "by Determined-Poitras",
      title: "Never Too Small – Give Every House a Shot (Pun Intended)",
      weeks: "2Weeks",
      students: "156 Students",
    },
    {
      img: image1,
      text: "by Determined-Poitras",
      title: "Bespoke – Add Storytelling to Your Real Estate Videos",
      weeks: "2Weeks",
      students: "156 Students",
    },
    {
      img: image2,
      text: "by Determined-Poitras",
      title: "Brandon Bames – Make It Unique",
      weeks: "2Weeks",
      students: "156 Students",
    },
    {
      img: image3,
      text: "by Determined-Poitras",
      title: "The Corcoran Group – Focus on the Main Attractions",
      weeks: "2Weeks",
      students: "156 Students",
    },
    {
      img: image4,
      text: "by Determined-Poitras",
      title: "MGroup – Appeal to Sellers Too",
      weeks: "2Weeks",
      students: "156 Students",
    },
    {
      img: image5,
      text: "by Determined-Poitras",
      title: "Haus – Educate Your Audience",
      weeks: "2Weeks",
      students: "156 Students",
    },
    {
      img: image6,
      text: "by Determined-Poitras",
      title: "Never Too Small – Give Every House a Shot (Pun Intended)",
      weeks: "2Weeks",
      students: "156 Students",
    },
    {
      img: image1,
      text: "by Determined-Poitras",
      title: "Bespoke – Add Storytelling to Your Real Estate Videos",
      weeks: "2Weeks",
      students: "156 Students",
    },
  ];

  const videosToShow = showAll ? videos : videos.slice(0, 6);

  useEffect(() => {
    getCategoriesRefetch();
  }, []);

  return (
    <div>
      <div className="relative">
        <img
          src="/assets/home/homeCard.png"
          alt="Home-Card"
          className="w-full max-h-[500px] bg-cover"
        />
        <div className="absolute top-0 left-0 h-full w-full flex justify-center items-center bg-black opacity-60">
          <p className="text-white font-medium text-3xl">Courses</p>
        </div>
      </div>
      <div className="max-w-7xl p-8 mx-auto">
        <div className="flex justify-center py-6">
          <div className="text-center">
            <h1 className="font-bold text-3xl">Top Categories</h1>
            <p className="text-darkgrey font-normal text-[18px]">
              Explore our Popular Categories
            </p>
          </div>
        </div>
        <div className="grid lg:grid-cols-5 md:grid-cols-3 sm:grid-cols-2 grid-cols-1 gap-x-6 gap-y-6 my-6 py-2">
          {getCategories?.categories?.map((data, index) => (
            <div
              key={index}
              className="rounded-2xl px-2 border-4 border-whitegrey shadow"
            >
              <div className="flex flex-col justify-center items-center gap-4 py-4">
                <div className="text-golden">
                  <FontAwesomeIcon
                    icon={faYoutube}
                    size="lg"
                    className="text-[40px]"
                  />
                </div>
                <h3 className="text-black font-bold text-lg text-center">
                  {data?.title}
                </h3>
                <p>1 course(s)</p>
              </div>
            </div>
          ))}
        </div>
      </div>
      <div>
        <div className="flex justify-center py-6">
          <div className="text-center">
            <h1 className="font-bold text-3xl">Featured Videos</h1>
            <p className="text-darkgrey font-normal text-[18px]">
              Explore our Popular Videos
            </p>
          </div>
        </div>
        <div className="flex justify-center items-center">
          <div className="grid justify-center grid-cols-1 md:grid-cols-2 xl:grid-cols-3 gap-y-5 lg:gap-x-6 md:gap-x-4">
            {videosToShow?.map((video, index) => (
              <div
                key={index}
                className="group transform transition-transform hover:-translate-y-6 hover:shadow-2xl hover:scale-105 max-w-sm bg-white border border-gray-200 rounded-[20px] shadow"
              >
                <div className="relative">
                  <Image
                    className="rounded-t-[20px] object-cover"
                    src={video?.img}
                    alt="image"
                    objectFit="cover"
                    width={500}
                    height={200}
                  />
                  <button className="absolute top-4 left-4 bg-black text-white py-2 px-3 rounded-xl">
                    Realtor Promotion
                  </button>
                </div>
                <div>
                  <div className="px-5">
                    <p className="mb-3 mt-3 font-normal text-gray-700 dark:text-gray-400">
                      {video?.text}
                    </p>
                    <h5 className="mb-2 text-2xl font-bold tracking-tight text-gray-900 group-hover:text-golden">
                      {video?.title}
                    </h5>
                  </div>
                  <div className="flex p-5 gap-3">
                    <div className="flex gap-1 justify-center items-center">
                      <FontAwesomeIcon
                        icon={faClock}
                        className="text-[#B9802A]"
                      />
                      <span className="font-normal">{video?.weeks}</span>
                    </div>
                    <div className="flex gap-1 justify-center items-center">
                      <FontAwesomeIcon
                        icon={faGraduationCap}
                        className="text-golden"
                      />
                      <span className="font-normal">{video?.students}</span>
                    </div>
                  </div>
                  <div className="bg-[#EAEAEA] h-[1px] mx-4"></div>
                  <div className="flex justify-end p-2">
                    <Link
                      href=""
                      className="inline-flex items-center px-3 py-2 text-sm font-medium text-center text-[18px]"
                    >
                      View more
                    </Link>
                  </div>
                </div>
              </div>
            ))}
          </div>
        </div>
        <div className="flex justify-center my-10">
          <button
            className="border font-medium border-gray-600 text-black rounded-3xl px-4 py-2"
            onClick={() => setShowAll(!showAll)}
          >
            {showAll ? "Show Less Videos" : "Load More Videos"}
          </button>
        </div>
      </div>
    </div>
  );
};

export default Course;
