import Link from "next/link";
import React, { useEffect } from "react";
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { faChartPie } from '@fortawesome/free-solid-svg-icons';
import { useGetCoursesQuery } from "@/services/Api";
import { useRouter } from "next/navigation";

function CoursesPage() {

  const router = useRouter();

  const {
    data: getCourses,
    refetch: getCoursesRefetch,
    isLoading: getCoursesIsLoading,
  } = useGetCoursesQuery();

  const handleCourseClick = () => {
    router.push("/login");
  };

  useEffect(() => {
    getCoursesRefetch();
  }, []);

  return (
    <div >
      <div className="p-4">
        {getCourses?.course?.length ? getCourses?.course?.map((data, index) => {
          return (
            <div className="group relative flex items-center gap-x-6 rounded-lg p-4 text-sm leading-6 hover:bg-gray-50" key={index} onClick={handleCourseClick}>
              <div className="flex h-11 w-11 flex-none items-center justify-center rounded-lg bg-gray-50 group-hover:bg-white">
                <FontAwesomeIcon icon={faChartPie} />
              </div>
              <div className="flex-auto">
                <Link href="#" className="block font-semibold text-gray-900">
                  {data?.title}
                  <span className="absolute inset-0"></span>
                </Link>
                <p className="mt-1 text-gray-600">
                  {data?.summary}
                </p>
              </div>
            </div>
          )
        }) : <>
          {getCoursesIsLoading ?
            <p className="mt-1 text-gray-600 text-center">
              Loading...
            </p>
            :
            <p className="mt-1 text-gray-600 text-center">
              No course found...
            </p>
          }
        </>}
      </div>
      {/* <div className="grid grid-cols-2 divide-x divide-gray-900/5 bg-gray-50">
        <Link
          href="#"
          className="flex items-center justify-center gap-x-2.5 p-3 text-sm font-semibold leading-6 text-gray-900 hover:bg-gray-100"
        >
          <FontAwesomeIcon icon={faChartPie} />
          View all products
        </Link>
        <Link
          href="#"
          className="flex items-center justify-center gap-x-2.5 p-3 text-sm font-semibold leading-6 text-gray-900 hover:bg-gray-100"
        >
          <FontAwesomeIcon icon={faChartPie} />
          Documentation
        </Link>
      </div> */}
    </div>

  );
}

export default CoursesPage;