"use client";
import React from "react";
import Slider from "react-slick";
import "slick-carousel/slick/slick.css";
import "slick-carousel/slick/slick-theme.css";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faImage, faFile, faEnvelope } from "@fortawesome/free-solid-svg-icons";
import { faYoutube } from "@fortawesome/free-brands-svg-icons";

function TopCategories() {

  <style jsx>
    {`
    .slick-dots {
      bottom: -25px;
    }

    .slick-dots li button:before {
      font-size: 12px;
      color: grey;
    }

    .slick-dots li.slick-active button:before {
      color: black;
    }

    .slick-dots li {
      margin: 0 5px;
    }
  `}
  </style>;

  const data = [
    {
      title: "Property Management",
      courses: "38 Courses",
      logo: <FontAwesomeIcon icon={faImage} size="lg" />,
    },
    {
      title: "Property Management",
      courses: "38 Courses",
      logo: <FontAwesomeIcon icon={faYoutube} size="lg" />,
    },
    {
      title: "property Management",
      courses: "38 Courses",
      logo: <FontAwesomeIcon icon={faFile} size="lg" />,
    },
    {
      title: "property Management",
      courses: "38 Courses",
      logo: <FontAwesomeIcon icon={faEnvelope} size="lg" />,
    },
    {
      title: "property Management",
      courses: "38 Courses",
      logo: <FontAwesomeIcon icon={faFile} size="lg" />,
    },
    {
      title: "property Management",
      courses: "38 Courses",
      logo: <FontAwesomeIcon icon={faImage} size="lg" />,
    },
    {
      title: "property Management",
      courses: "38 Courses",
      logo: <FontAwesomeIcon icon={faYoutube} size="lg" />,
    },
    {
      title: "property Management",
      courses: "38 Courses",
      logo: <FontAwesomeIcon icon={faImage} size="lg" />,
    },
    {
      title: "property Management",
      courses: "38 Courses",
      logo: <FontAwesomeIcon icon={faYoutube} size="lg" />,
    },
  ];

  const settings = {
    dots: true,
    infinite: false,
    speed: 500,
    slidesToShow: 5,
    slidesToScroll: 1,
    initialSlide: 0,
    appendDots: (dots) => (
      <div
        style={{
          marginTop: "10px",
        }}
      >
        <ul
          style={{
            display: "flex",
            justifyContent: "center",
            gap: "10px",
            padding: "0",
          }}
        >
          {dots}
        </ul>
      </div>
    ),
    customPaging: () => (
      <div
        className="custom-dot"
        style={{
          width: "10px",
          height: "10px",
          borderRadius: "10%",
          border: "1px solid grey",
          display: "inline-block",
        }}
      ></div>
    ),
    responsive: [
      {
        breakpoint: 1024,
        settings: {
          slidesToShow: 3,
          slidesToScroll: 3,
          infinite: true,
          dots: true,
        },
      },
      {
        breakpoint: 600,
        settings: {
          slidesToShow: 2,
          slidesToScroll: 2,
          initialSlide: 2,
        },
      },
      {
        breakpoint: 480,
        settings: {
          slidesToShow: 1,
          slidesToScroll: 1,
        },
      },
    ],
  };

  return (
    <div className="max-w-7xl p-8 mx-auto">
      <div className="flex justify-between flex-col gap-4 sm:gap-0 sm:flex-row py-6">
        <div>
          <h1 className="font-bold text-3xl">Top Categories</h1>
          <p className="text-darkgrey font-normal text-[18px]">
            Explore our Popular Categories
          </p>
        </div>
        <div>
          <button className="text-[18px] font-medium border-2 border-grey p-3 rounded-full">
            All Categories
          </button>
        </div>
      </div>

      <div className="slider-container my-6 py-2">
        <Slider {...settings}>
          {data?.length &&
            data?.map((data, index) => (
              <div
                key={index}
                className="slick-slide rounded-2xl hover:bg-whitegrey border-2 border-whitegrey"
              >
                <div className="flex flex-col justify-center items-center gap-4 py-4">
                  <div className="text-golden">{data?.logo}</div>
                  <h3 className="text-black font-bold text-lg text-center">
                    {data?.title}
                  </h3>
                  <p>{data?.courses}</p>
                </div>
              </div>
            ))}
          <div></div>
        </Slider>
      </div>
    </div>
  );
}

export default TopCategories;