import React, { useEffect } from "react";
import 'bootstrap/dist/js/bootstrap.bundle.min.js';
import "../../../../../public/assets/styles/spacers.css"

const AccordionComponent = () => {
  useEffect(() => {
    const accordionItems = document.querySelectorAll(".accordion-item");
    accordionItems.forEach((item) => {
      const collapse = item.querySelector(".accordion-collapse");
      collapse.addEventListener("show.bs.collapse", () =>
        item.classList.remove("collapsed")
      );
      collapse.addEventListener("hide.bs.collapse", () =>
        item.classList.add("collapsed")
      );
    });
  }, []);

  return (
    <div className="container custom-container mt-10 mb-45 w-100 overflow-hidden">
      <div className="faq-section">
        <div className="faq-header mx-auto text-center mb-50">
          <h1 className="aa-heading-03 fw-bold mb-10" data-aos="fade-down" data-aos-delay="200" data-aos-duration="1000">
            Have Questions?
            <br />
            We Have Answers.
          </h1>
          <p className="aa-text-sm" data-aos="fade-up-left" data-aos-delay="250">Explore our Frequently Asked Questions to find information on account setup, security measures, personalized features, and more.</p>
        </div>
        <div className="accordion" id="faqAccordion">
          <div className="row">
            <div className="col-md-6">
              <div className="accordion-item mb-16 collapsed">
                <h2 className="accordion-header" id="heading1">
                  <button
                    className="accordion-button collapsed aa-heading-06 p-24"
                    type="button"
                    data-bs-toggle="collapse"
                    data-bs-target="#collapse1"
                  >
                    How do I open an account with Finnecta?
                  </button>
                </h2>
                <div
                  id="collapse1"
                  className="accordion-collapse collapse"
                  data-bs-parent="#faqAccordion"
                >
                  <div className="accordion-body aa-text-sm fw-medium">
                    Opening an account with Finnecta is quick and easy. Simply
                    click on the 'Open an Account' button, follow the prompts,
                    and provide the required information. We prioritize your
                    security throughout the process.
                  </div>
                </div>
              </div>
              <div className="accordion-item mb-16 collapsed">
                <h2 className="accordion-header" id="heading2">
                  <button
                    className="accordion-button collapsed aa-heading-06 p-24"
                    type="button"
                    data-bs-toggle="collapse"
                    data-bs-target="#collapse2"
                  >
                    What makes Finnecta different from other banks?
                  </button>
                </h2>
                <div
                  id="collapse2"
                  className="accordion-collapse collapse"
                  data-bs-parent="#faqAccordion"
                >
                  <div className="accordion-body aa-text-sm fw-medium">
                    Lorem ipsum dolor sit amet consectetur adipisicing elit.
                    Nostrum sapiente corrupti quasi nulla voluptatum aliquam,
                    ullam cupiditate voluptatem dolorum saepe tempora illum cum
                    incidunt, repellendus consectetur non vero totam at!
                  </div>
                </div>
              </div>
              <div className="accordion-item mb-16 collapsed">
                <h2 className="accordion-header" id="heading3">
                  <button
                    className="accordion-button collapsed aa-heading-06 p-24"
                    type="button"
                    data-bs-toggle="collapse"
                    data-bs-target="#collapse3"
                  >
                    How secure is my information with Finnecta?
                  </button>
                </h2>
                <div
                  id="collapse3"
                  className="accordion-collapse collapse"
                  data-bs-parent="#faqAccordion"
                >
                  <div className="accordion-body aa-text-sm fw-medium">
                    Lorem ipsum dolor sit amet consectetur adipisicing elit.
                    Nostrum sapiente corrupti quasi nulla voluptatum aliquam,
                    ullam cupiditate voluptatem dolorum saepe tempora illum cum
                    incidunt, repellendus consectetur non vero totam at!
                  </div>
                </div>
              </div>
              <div className="accordion-item mb-16 collapsed">
                <h2 className="accordion-header" id="heading4">
                  <button
                    className="accordion-button collapsed aa-heading-06 p-24"
                    type="button"
                    data-bs-toggle="collapse"
                    data-bs-target="#collapse4"
                  >
                    Can I access my account on multiple devices?
                  </button>
                </h2>
                <div
                  id="collapse4"
                  className="accordion-collapse collapse"
                  data-bs-parent="#faqAccordion"
                >
                  <div className="accordion-body aa-text-sm fw-medium">
                    Lorem ipsum dolor sit amet consectetur adipisicing elit.
                    Nostrum sapiente corrupti quasi nulla voluptatum aliquam,
                    ullam cupiditate voluptatem dolorum saepe tempora illum cum
                    incidunt, repellendus consectetur non vero totam at!
                  </div>
                </div>
              </div>
            </div>
            <div className="col-md-6">
              <div className="accordion-item mb-16 collapsed">
                <h2 className="accordion-header" id="heading5">
                  <button
                    className="accordion-button collapsed aa-heading-06 p-24"
                    type="button"
                    data-bs-toggle="collapse"
                    data-bs-target="#collapse5"
                  >
                    What kind of support does Finnecta offer?
                  </button>
                </h2>
                <div
                  id="collapse5"
                  className="accordion-collapse collapse"
                  data-bs-parent="#faqAccordion"
                >
                  <div className="accordion-body aa-text-sm fw-medium">
                    Lorem, ipsum dolor sit amet consectetur adipisicing elit.
                    Dolores commodi aliquid quae quidem alias odit quisquam
                    officiis ratione optio facere, porro debitis corporis cum
                    dolor explicabo. Quos commodi quia voluptatibus!
                  </div>
                </div>
              </div>
              <div className="accordion-item mb-16 collapsed">
                <h2 className="accordion-header" id="heading6">
                  <button
                    className="accordion-button collapsed aa-heading-06 p-24"
                    type="button"
                    data-bs-toggle="collapse"
                    data-bs-target="#collapse6"
                  >
                    Are there any fees associated with Finnecta accounts?
                  </button>
                </h2>
                <div
                  id="collapse6"
                  className="accordion-collapse collapse"
                  data-bs-parent="#faqAccordion"
                >
                  <div className="accordion-body aa-text-sm fw-medium">
                    Lorem, ipsum dolor sit amet consectetur adipisicing elit.
                    Dolores commodi aliquid quae quidem alias odit quisquam
                    officiis ratione optio facere, porro debitis corporis cum
                    dolor explicabo. Quos commodi quia voluptatibus!
                  </div>
                </div>
              </div>
              <div className="accordion-item mb-16 collapsed">
                <h2 className="accordion-header" id="heading7">
                  <button
                    className="accordion-button collapsed aa-heading-06 p-24"
                    type="button"
                    data-bs-toggle="collapse"
                    data-bs-target="#collapse7"
                  >
                    How can I set up alerts and notifications for my account?
                  </button>
                </h2>
                <div
                  id="collapse7"
                  className="accordion-collapse collapse"
                  data-bs-parent="#faqAccordion"
                >
                  <div className="accordion-body aa-text-sm fw-medium">
                    Lorem, ipsum dolor sit amet consectetur adipisicing elit.
                    Dolores commodi aliquid quae quidem alias odit quisquam
                    officiis ratione optio facere, porro debitis corporis cum
                    dolor explicabo. Quos commodi quia voluptatibus!
                  </div>
                </div>
              </div>
              <div className="accordion-item mb-16 collapsed">
                <h2 className="accordion-header" id="heading8">
                  <button
                    className="accordion-button collapsed aa-heading-06 p-24"
                    type="button"
                    data-bs-toggle="collapse"
                    data-bs-target="#collapse8"
                  >
                    Can I link external accounts to Finnecta for a comprehensive
                    financial overview?
                  </button>
                </h2>
                <div
                  id="collapse8"
                  className="accordion-collapse collapse"
                  data-bs-parent="#faqAccordion"
                >
                  <div className="accordion-body aa-text-sm fw-medium">
                    Lorem, ipsum dolor sit amet consectetur adipisicing elit.
                    Dolores commodi aliquid quae quidem alias odit quisquam
                    officiis ratione optio facere, porro debitis corporis cum
                    dolor explicabo. Quos commodi quia voluptatibus!
                  </div>
                </div>
              </div>
            </div>
          </div>

          {/* Add more items as needed */}
        </div>
      </div>
    </div>
  );
};

export default AccordionComponent;
