import React from "react";
import FooterLogo from "../../../../public/assets/homeNew/Images/footer-logo.png";
import Image from "next/image";
import Link from "next/link";
import CustomButton from "../CustomButton/CustomBUtton";
import "../../../../public/assets/styles/spacers.css"

const FooterComponent = () => {
  return (
    <footer className="footer pt-50 pb-16 w-100 overflow-hidden">
      <div className="footer-container">
        <div className="container custom-container">
          <div className="footer-row d-flex flex-wrap">
            <div className="footer-section logo-section">
              <div className="logo mb-18">
                <Image
                  src={FooterLogo}
                  alt="Logo"
                  placeholder="blur"
                  width={"104"}
                />
              </div>
              <p className="description aa-text-base">
                Lorem ipsum is simply dummy text of the printing and typesetting
                industry. Lorem Ipsum has been the industry's standard dummy
                text ever since the 1500s
              </p>
            </div>
            <div className="footer-section links-section">
              <h3 className="aa-heading-06 fw-bold mb-21">About Link</h3>
              <ul className="list-unstyled p-0">
                <li className="mb-12">
                  <Link
                    href={""}
                    className="aa-text-base fw-medium text-decoration-none"
                  >
                    Home
                  </Link>
                </li>
                <li className="mb-12">
                  <Link
                    href={""}
                    className="aa-text-base fw-medium text-decoration-none"
                  >
                    About Us
                  </Link>
                </li>
                <li className="mb-12 dropdown">
                  <Link
                    className="aa-text-base fw-medium text-decoration-none dropdown-toggle"
                    href="#"
                    role="button"
                    id="coursesDropdown"
                    data-bs-toggle="dropdown"
                    aria-expanded="false"
                  >
                    Courses
                  </Link>
                  <ul
                    className="dropdown-menu"
                    aria-labelledby="coursesDropdown"
                  >
                    <li>
                      <Link href={""} className="dropdown-item">
                        Real Estate Basics
                      </Link>
                    </li>
                    <li>
                      <Link href={""} className="dropdown-item">
                        Advanced Licensing
                      </Link>
                    </li>
                    <li>
                      <Link href={""} className="dropdown-item">
                        Property Management
                      </Link>
                    </li>
                  </ul>
                </li>
                <li className="mb-12">
                  <Link
                    href={""}
                    className="aa-text-base fw-medium text-decoration-none"
                  >
                    Certifications
                  </Link>
                </li>
                <li className="mb-12">
                  <Link
                    href={""}
                    className="aa-text-base fw-medium text-decoration-none"
                  >
                    Blogs
                  </Link>
                </li>
              </ul>
            </div>
            <div className="footer-section contact-section">
              <h3 className="aa-heading-06 fw-bold mb-21">Get in Touch</h3>
              <ul className="list-unstyled p-0">
                <li className="d-flex align-items-center aa-text-base fw-medium mb-18">
                  <span className="icon me-9">
                    <svg
                      width="24"
                      height="25"
                      viewBox="0 0 24 25"
                      fill="none"
                      xmlns="http://www.w3.org/2000/svg"
                    >
                      <g clipPath="url(#clip0_3473_2926)">
                        <path
                          d="M15.5512 13.4961L13.5412 15.5129C12.7261 16.3309 11.2919 16.3485 10.4591 15.5129L8.44899 13.4961L1.22949 20.739C1.49823 20.8633 1.79452 20.9375 2.10952 20.9375H21.8908C22.2058 20.9375 22.502 20.8634 22.7706 20.7391L15.5512 13.4961Z"
                          fill="black"
                        />
                        <path
                          d="M21.8907 4.0625H2.10943C1.79443 4.0625 1.49813 4.13666 1.22949 4.26092L8.94404 12.0011C8.94455 12.0016 8.94516 12.0017 8.94568 12.0022C8.9462 12.0027 8.94629 12.0034 8.94629 12.0034L11.4547 14.5201C11.7211 14.7866 12.2791 14.7866 12.5455 14.5201L15.0534 12.0038C15.0534 12.0038 15.054 12.0027 15.0545 12.0022C15.0545 12.0022 15.0556 12.0016 15.0562 12.0011L22.7705 4.26088C22.5019 4.13656 22.2057 4.0625 21.8907 4.0625Z"
                          fill="black"
                        />
                        <path
                          d="M0.224344 5.24414C0.0853125 5.5253 0 5.83739 0 6.1717V18.828C0 19.1623 0.0852187 19.4744 0.224297 19.7555L7.45631 12.5001L0.224344 5.24414Z"
                          fill="black"
                        />
                        <path
                          d="M23.7759 5.24463L16.5439 12.5006L23.7759 19.7562C23.9149 19.475 24.0002 19.1629 24.0002 18.8285V6.17229C24.0002 5.83788 23.9149 5.52579 23.7759 5.24463Z"
                          fill="black"
                        />
                      </g>
                      <defs>
                        <clipPath id="clip0_3473_2926">
                          <rect
                            width="24"
                            height="24"
                            fill="white"
                            transform="translate(0 0.5)"
                          />
                        </clipPath>
                      </defs>
                    </svg>
                  </span>
                  support@agentambitionacademy.com
                </li>
                <li className="d-flex align-items-start aa-text-base fw-medium mb-18">
                  <span className="icon me-9">
                    <svg
                      width="24"
                      height="24"
                      viewBox="0 0 24 24"
                      fill="none"
                      xmlns="http://www.w3.org/2000/svg"
                    >
                      <g clipPath="url(#clip0_3473_2941)">
                        <path
                          d="M12 0C7.78289 0 4.26562 3.39703 4.26562 7.73438C4.26562 9.38447 4.76147 10.8559 5.71308 12.2347L11.4081 21.1212C11.6844 21.5532 12.3162 21.5524 12.5919 21.1212L18.3116 12.2044C19.2428 10.8881 19.7344 9.34252 19.7344 7.73438C19.7344 3.46964 16.2647 0 12 0ZM12 11.25C10.0616 11.25 8.48438 9.6728 8.48438 7.73438C8.48438 5.79595 10.0616 4.21875 12 4.21875C13.9384 4.21875 15.5156 5.79595 15.5156 7.73438C15.5156 9.6728 13.9384 11.25 12 11.25Z"
                          fill="black"
                        />
                        <path
                          d="M17.4967 16.1582L13.9562 21.6935C13.0398 23.1224 10.9551 23.1177 10.0431 21.6949L6.49678 16.1597C3.37659 16.8811 1.45312 18.2026 1.45312 19.7819C1.45312 22.5223 6.88725 24.0006 12 24.0006C17.1128 24.0006 22.5469 22.5223 22.5469 19.7819C22.5469 18.2015 20.6207 16.8792 17.4967 16.1582Z"
                          fill="black"
                        />
                      </g>
                      <defs>
                        <clipPath id="clip0_3473_2941">
                          <rect width="24" height="24" fill="white" />
                        </clipPath>
                      </defs>
                    </svg>
                  </span>
                  Address: 2321 New Design Str, Lorem Ipsum10 Hudson Yards, USA
                </li>
                <li className="d-flex align-items-center aa-text-base fw-medium mb-18">
                  <span className="icon me-9">
                    <svg
                      width="24"
                      height="25"
                      viewBox="0 0 24 25"
                      fill="none"
                      xmlns="http://www.w3.org/2000/svg"
                    >
                      <path
                        d="M22.0448 18.02C21.3892 17.4703 17.5448 15.0358 16.9058 15.1475C16.6058 15.2008 16.3763 15.4565 15.762 16.1893C15.4779 16.5499 15.166 16.8877 14.829 17.1995C14.2116 17.0504 13.614 16.8288 13.0485 16.5395C10.831 15.4599 9.03947 13.6679 7.9605 11.45C7.67118 10.8846 7.44964 10.2869 7.3005 9.6695C7.6123 9.33252 7.95009 9.02056 8.31075 8.7365C9.04275 8.12225 9.29925 7.89425 9.3525 7.59275C9.46425 6.95225 7.0275 3.10925 6.48 2.45375C6.2505 2.18225 6.042 2 5.775 2C5.001 2 1.5 6.329 1.5 6.89C1.5 6.93575 1.575 11.4425 7.26675 17.2333C13.0575 22.925 17.5642 23 17.61 23C18.171 23 22.5 19.499 22.5 18.725C22.5 18.458 22.3177 18.2495 22.0448 18.02Z"
                        fill="black"
                      />
                      <path
                        d="M17.25 11.75H18.75C18.7482 10.1592 18.1155 8.63416 16.9907 7.50933C15.8658 6.3845 14.3408 5.75179 12.75 5.75V7.25C13.9431 7.25119 15.087 7.72568 15.9307 8.56933C16.7743 9.41299 17.2488 10.5569 17.25 11.75Z"
                        fill="black"
                      />
                      <path
                        d="M21 11.75H22.5C22.497 9.16505 21.4688 6.68683 19.641 4.859C17.8132 3.03116 15.3349 2.00298 12.75 2V3.5C14.9372 3.50258 17.0342 4.3726 18.5808 5.91922C20.1274 7.46584 20.9974 9.56276 21 11.75Z"
                        fill="black"
                      />
                    </svg>
                  </span>
                  +1 (234) 567-8910
                </li>
              </ul>
            </div>
            <div className="footer-section newsletter-section">
              <h3 className="aa-heading-06 fw-bold mb-21">
                Subscribe Our Newsletter
              </h3>
              <div className="input-group">
                <input
                  type="email"
                  className="form-control"
                  placeholder="ENTER YOUR EMAIL"
                />
                <CustomButton
                  classes="btn btn-primary"
                  label="Submit"
                  type="button"
                />
              </div>
            </div>
          </div>
          <div className="footer-bottom mt-30 pt-20">
            <div className="footer-bottom-row">
              <div className="footer-bottom-left">
                <p>Copyright © 2025 Agent Ambition Academy</p>
              </div>
              <div className="footer-bottom-right">
                <div className="social-icons d-flex justify-content-center justify-content-md-end gap-3">
                  <Link href={""} >
                    <span className="icon">
                      <svg
                        width="10"
                        height="17"
                        viewBox="0 0 10 17"
                        fill="none"
                        xmlns="http://www.w3.org/2000/svg"
                      >
                        <path
                          d="M6.86087 4.28746C6.85054 4.89072 6.8587 5.49344 6.8587 6.11792C6.94464 6.12173 7.0159 6.12825 7.08771 6.12825C7.79324 6.1288 8.49931 6.12771 9.20538 6.1288C9.63294 6.12989 9.73847 6.23487 9.73902 6.65482C9.7401 7.46261 9.74065 8.27041 9.73902 9.0782C9.73793 9.45245 9.64491 9.5471 9.26848 9.54874C8.54881 9.552 7.82968 9.54982 7.11001 9.54982H6.85978V16.1765C6.85978 16.7754 6.80103 16.833 6.19233 16.833C5.41826 16.833 4.64474 16.8336 3.87121 16.8325C3.44148 16.8319 3.34193 16.7335 3.34139 16.307C3.34084 14.1556 3.34139 12.0037 3.34139 9.85173V9.58736C3.2587 9.58246 3.18744 9.57485 3.11618 9.57485C2.52598 9.57376 1.93523 9.57539 1.34502 9.57376C0.93541 9.57213 0.836407 9.47693 0.83532 9.07113C0.832056 8.27694 0.8326 7.48274 0.834776 6.68854C0.835864 6.26642 0.93269 6.17177 1.34992 6.17123C1.93359 6.17069 2.51727 6.17123 3.10095 6.17123H3.34139C3.34139 6.07059 3.3403 5.99118 3.34139 5.91176C3.35553 5.13823 3.32779 4.36144 3.39306 3.59281C3.55843 1.65791 5.04619 0.25719 6.99034 0.184298C7.80357 0.153836 8.61844 0.171243 9.4333 0.173419C9.70257 0.174507 9.81789 0.290916 9.81952 0.561813C9.82387 1.36961 9.82387 2.1774 9.81952 2.9852C9.81789 3.2599 9.70475 3.3687 9.40991 3.37577C8.8605 3.38882 8.31055 3.38937 7.76114 3.39753C7.12361 3.40732 6.87229 3.6483 6.86087 4.28746Z"
                          fill="#D8A32B"
                        />
                      </svg>
                    </span>
                  </Link>
                  <Link href={""}>
                    <span className="icon">
                      <svg
                        width="14"
                        height="17"
                        viewBox="0 0 14 17"
                        fill="none"
                        xmlns="http://www.w3.org/2000/svg"
                      >
                        <path
                          d="M13.4365 5.77943C13.4412 7.05307 13.2117 8.28284 12.6495 9.43363C12.0386 10.683 11.1335 11.6428 9.8079 12.1281C8.79817 12.4986 7.76616 12.5897 6.75643 12.1065C6.4905 11.9796 6.24954 11.8014 5.98495 11.6387C5.89923 11.9681 5.80542 12.3096 5.7224 12.6538C5.49696 13.5927 5.22563 14.516 4.80716 15.3908C4.60062 15.8221 4.37856 16.2446 4.02219 16.576C3.95537 16.6381 3.8791 16.6921 3.80013 16.7393C3.49707 16.9196 3.19604 16.8359 3.03203 16.5254C2.86531 16.2095 2.83292 15.8639 2.82347 15.5157C2.79242 14.3237 3.00908 13.1655 3.29188 12.014C3.61114 10.7154 3.91217 9.41136 4.21522 8.1087C4.23547 8.02095 4.22535 7.91633 4.19767 7.82927C3.8683 6.78916 3.84265 5.7693 4.41028 4.79737C4.72279 4.2628 5.17231 3.90103 5.80339 3.80181C6.69366 3.66142 7.4793 4.3033 7.54478 5.20234C7.5927 5.85232 7.40911 6.45776 7.23834 7.06792C7.07973 7.63083 6.90762 8.18969 6.74968 8.7526C6.66193 9.06511 6.67003 9.37694 6.83675 9.66649C7.1209 10.1579 7.57582 10.3178 8.10836 10.2699C8.73337 10.2146 9.19031 9.85683 9.55816 9.37559C10.0286 8.76003 10.2891 8.05133 10.4457 7.30145C10.6037 6.54348 10.6867 5.77875 10.5746 5.00728C10.3944 3.76199 9.69923 2.91762 8.50996 2.53155C7.30989 2.1421 6.1105 2.19744 4.96847 2.76508C3.7846 3.35297 3.08467 4.333 2.79647 5.60934C2.65068 6.25797 2.62368 6.91403 2.89096 7.54309C2.98478 7.7638 3.12247 7.97168 3.26894 8.16404C3.44375 8.39285 3.51462 8.62706 3.437 8.90717C3.37153 9.14205 3.31956 9.38031 3.25206 9.61452C3.11977 10.0775 2.78904 10.2294 2.35167 10.0343C1.48368 9.64759 0.943717 8.96251 0.644712 8.0871C0.157395 6.66227 0.24244 5.25229 0.893096 3.89765C1.84951 1.90789 3.47007 0.768564 5.60765 0.329843C5.94041 0.261673 6.28328 0.238724 6.62144 0.193502C6.65788 0.188777 6.69366 0.175953 6.72943 0.166504H7.64129C7.82353 0.188102 8.00577 0.207676 8.18801 0.231975C9.74108 0.434461 11.0741 1.07567 12.1068 2.26764C12.9748 3.26995 13.4324 4.44572 13.4365 5.77943Z"
                          fill="#D8A32B"
                        />
                      </svg>
                    </span>
                  </Link>
                  <Link href={""}>
                    <span className="icon">
                      <svg
                        width="17"
                        height="17"
                        viewBox="0 0 17 17"
                        fill="none"
                        xmlns="http://www.w3.org/2000/svg"
                      >
                        <path
                          d="M15.9864 15.4613C14.1309 12.7539 12.2738 10.0473 10.4174 7.34044C10.3932 7.30518 10.3709 7.26847 10.3407 7.22163C10.6659 6.84258 10.9894 6.46515 11.3133 6.08791C12.9966 4.12737 14.6801 2.16665 16.3634 0.205928C16.3739 0.193631 16.3822 0.179706 16.3916 0.166504H14.9621C13.2149 2.20101 11.4676 4.2357 9.6926 6.30257C9.67126 6.26405 9.65607 6.23096 9.63581 6.20148C8.27279 4.21327 6.9094 2.22542 5.54637 0.237214C5.53136 0.215151 5.52069 0.190195 5.50785 0.166504H0.666992C0.708948 0.235225 0.747649 0.306116 0.793041 0.372305C2.83894 3.35661 4.88538 6.34055 6.93182 9.32467C6.95316 9.35578 6.9736 9.38761 7.00344 9.43264C6.83724 9.62759 6.67014 9.82453 6.50177 10.0206C4.59928 12.2361 2.69661 14.4514 0.794307 16.6672C0.749096 16.72 0.70931 16.7777 0.666992 16.8332H2.09657C2.744 16.0756 3.39015 15.317 4.03885 14.5605C5.19209 13.2156 6.34697 11.8717 7.50112 10.5277C7.54326 10.4785 7.58666 10.4305 7.63694 10.3732C7.66949 10.4126 7.69842 10.443 7.72193 10.4772C9.15278 12.5632 10.5833 14.6495 12.0136 16.7361C12.0347 16.767 12.0517 16.8008 12.0707 16.8332H16.9114C16.6032 16.3758 16.2981 15.9163 15.9864 15.4613ZM14.768 15.7971C14.151 15.7977 13.5339 15.7944 12.9169 15.8002C12.802 15.8011 12.7313 15.7684 12.6642 15.6723C9.35008 10.9176 6.0332 6.16441 2.71687 1.41108C2.68631 1.36731 2.65846 1.32156 2.60963 1.24669C3.21492 1.24669 3.78856 1.26948 4.3593 1.23801C4.69694 1.21938 4.88303 1.3382 5.07418 1.61344C8.31257 6.27581 11.5638 10.9293 14.8121 15.5848C14.8543 15.6452 14.895 15.7065 14.9503 15.7875C14.8709 15.7919 14.8196 15.7969 14.768 15.7971Z"
                          fill="#D8A32B"
                        />
                      </svg>
                    </span>
                  </Link>
                  <Link href={""}>
                    <span className="icon">
                      <svg
                        width="18"
                        height="17"
                        viewBox="0 0 18 17"
                        fill="none"
                        xmlns="http://www.w3.org/2000/svg"
                      >
                        <path
                          d="M17.3303 4.80963C17.3189 3.01331 16.5179 1.65028 14.9682 0.742952C14.2863 0.343499 13.5326 0.170675 12.7423 0.170267C10.2473 0.168229 7.7524 0.162115 5.25744 0.171897C3.22675 0.179642 1.5303 1.41917 0.887914 3.35489C0.79335 3.64021 0.758703 3.94591 0.696747 4.24224C0.685742 4.29482 0.676775 4.34781 0.666992 4.40039V12.6022C0.711829 12.8517 0.736285 13.1068 0.804355 13.3498C1.3212 15.1946 2.51997 16.3277 4.38884 16.75C4.55636 16.7879 4.72878 16.8059 4.89875 16.8332H13.1022C13.3521 16.7883 13.6072 16.7639 13.8506 16.6958C15.6934 16.1798 16.8298 14.9831 17.2455 13.1162C17.3124 12.8174 17.3295 12.5028 17.3303 12.1954C17.3368 9.7335 17.3458 7.27157 17.3303 4.80963ZM9.00782 13.0685C6.4986 13.0828 4.43123 11.0187 4.43245 8.5005C4.43367 5.98476 6.46722 3.94836 8.99315 3.93409C11.5024 3.91983 13.5697 5.98353 13.5685 8.50172C13.5673 11.0175 11.5338 13.0539 9.00782 13.0685ZM13.8441 5.04645C13.09 5.044 12.4558 4.40895 12.4562 3.65651C12.4562 2.90163 13.0884 2.27229 13.8461 2.2731C14.6079 2.27351 15.232 2.89837 15.2299 3.65896C15.2283 4.41711 14.5973 5.04889 13.8441 5.04645Z"
                          fill="#D8A32B"
                        />
                        <path
                          d="M12.5841 8.50914C12.5776 10.4909 10.9602 12.0973 8.98495 12.0842C7.00643 12.0712 5.41025 10.4652 5.41677 8.49365C5.42329 6.51228 7.04107 4.90509 9.01633 4.91854C10.9948 4.93158 12.5906 6.53755 12.5841 8.50914Z"
                          fill="#D8A32B"
                        />
                        <path
                          d="M14.2452 3.65542C14.2461 3.87472 14.0606 4.0614 13.8438 4.06018C13.6289 4.05895 13.4394 3.86575 13.4427 3.65135C13.4463 3.44062 13.6273 3.26046 13.8393 3.2576C14.0614 3.25475 14.2444 3.4341 14.2452 3.65542Z"
                          fill="#D8A32B"
                        />
                      </svg>
                    </span>
                  </Link>
                  <Link href={""}>
                    <span className="icon">
                      <svg
                        width="20"
                        height="14"
                        viewBox="0 0 20 14"
                        fill="none"
                        xmlns="http://www.w3.org/2000/svg"
                      >
                        <path
                          d="M18.8681 3.22938C18.6677 2.12192 17.9908 1.41099 16.9326 1.21745C16.4959 1.13728 16.0513 1.07887 15.6078 1.05883C13.727 0.973791 11.8453 0.907079 9.96395 0.833496C9.96337 0.852966 9.9628 0.872435 9.96223 0.891904C9.52961 0.891904 9.0967 0.885606 8.66436 0.89305C6.87059 0.923113 5.07654 0.942869 3.29222 1.16562C2.18246 1.30391 1.41371 1.96387 1.18265 3.06103C1.05352 3.67375 0.983089 4.30192 0.932125 4.92695C0.823039 6.26375 0.796125 7.60486 0.891182 8.94367C0.950163 9.77169 1.02575 10.6023 1.16347 11.4203C1.34413 12.4917 2.08254 13.2 3.12215 13.3544C3.73773 13.4457 4.35932 13.5236 4.98063 13.5439C6.88777 13.6057 8.79607 13.663 10.7041 13.6725C12.6061 13.6822 14.5089 13.637 16.4035 13.438C16.8919 13.3864 17.3732 13.3085 17.8001 13.0351C18.5062 12.583 18.8274 11.9036 18.9044 11.1056C19.0084 10.0259 19.1137 8.94367 19.1492 7.86054C19.2005 6.31071 19.1449 4.76146 18.8681 3.22938ZM8.18679 10.0185V4.54558C9.77526 5.45864 11.3471 6.36225 12.9468 7.28189C11.3494 8.20039 9.77784 9.10372 8.18679 10.0185Z"
                          fill="#D8A32B"
                        />
                      </svg>
                    </span>
                  </Link>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </footer>
  );
};

export default FooterComponent;