"use client";
import React, {
  useEffect,
  useRef,
  useState,
  useMemo,
  useCallback,
} from "react";
import { useRouter } from "next/navigation";
import { useSelector, useDispatch } from "react-redux";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import Image from "next/image";
import {
  faCirclePlay,
  faReply,
  faTrashCan,
} from "@fortawesome/free-solid-svg-icons";
import { faCircleCheck } from "@fortawesome/free-regular-svg-icons";
import { MdAssignmentAdd } from "react-icons/md";
import toast from "react-hot-toast";
import { Spinner } from "@material-tailwind/react";
import {
  useCourseVideoMutation,
  useGetCommentsQuery,
  useGetCourseVideosQuery,
} from "@/services/Api";
import { watchTimeVideo } from "@/redux/videoSlice";
import Profile from "../../../../../../public/assets/dashboard/profile.png";
import { PostRequest, DeleteRequest } from "../../../axiosConfig/axiosConfig";
import ReplyModal from "./ReplyModal";
import Header from "../../header/header";
import { BASE_URL } from "@/services/ApiEndpoints";
import UpComingVideos from "./UpComingVideos";

// Utility to get video URL
const getVideoUrl = (video) => {
  const media = video?.video?.media;
  return media?.[0]?.collection_name === "course_image"
    ? media?.[1]?.original_url
    : media?.[0]?.original_url;
};

const CourseVideos = ({ id }) => {
  const router = useRouter();
  const dispatch = useDispatch();
  const videoRef = useRef(null);
  const auth = useSelector((state) => state?.auth);
  const [activeTab, setActiveTab] = useState("description");
  const [subscriptionModal, setSubscriptionModal] = useState(false);
  const [enrollModal, setEnrollModal] = useState(false);
  const [enrollError, setEnrollError] = useState("");
  const [courseId, setCourseId] = useState("");
  const [videoId, setVideoId] = useState(null);
  const [videoDetail, setVideoDetail] = useState({
    videoUrl: "",
    summary: "",
    content: "",
    title: "",
  });
  const [watchTime, setWatchTime] = useState(0);
  const [seeMore, setSeeMore] = useState(false);
  const [isModalOpen, setModalOpen] = useState(false);
  const [selectedComment, setSelectedComment] = useState(null);
  const [nextVideoVisible, setNextVideoVisible] = useState({
    visible: false,
    videoId: null,
  });
  const [getVideoCommentId, setGetVideoCommentId] = useState(0);
  const [commentText, setCommentText] = useState("");
  const [commentUploading, setCommentUploading] = useState(false);

  const { data: courseVideos, refetch: refetchCourseVideos } =
    useGetCourseVideosQuery({ id });
  const { data: comments, refetch: refetchComments } = useGetCommentsQuery({
    id: getVideoCommentId || 1,
  });
  const [courseVideo] = useCourseVideoMutation();

  const data = useSelector(item => console.log(item));

  // Initialize video details
  useEffect(() => {
    if (courseVideos?.course_videos?.length) {
      const videos = courseVideos.course_videos;
      const lastCompleted = videos.filter(
        (item) => item.is_video_completed === 1
      );
      const targetVideo = lastCompleted.length
        ? lastCompleted[lastCompleted.length - 1]
        : videos.find((item) => item.is_video_completed === 0) || videos[0];

      setVideoDetail({
        videoUrl: getVideoUrl(targetVideo) || "No Video available.",
        summary: targetVideo?.video?.summary || "No description available.",
        content: targetVideo?.video?.content || "No content available.",
        title: targetVideo?.video?.title || "No title available.",
      });
      setCourseId(targetVideo?.course_id);
      setVideoId(targetVideo?.video_id);
      setGetVideoCommentId(targetVideo?.id);

      // lastCompleted;
      console.log(lastCompleted[lastCompleted.length - 1]?.assignment?.user_assignment_status !== 0);
      if(lastCompleted.length === 0){
        setNextVideoVisible({
            visible: true,
            videoId: videos[0].id,
          });
      } 
      if(lastCompleted.length > 0 && lastCompleted[lastCompleted.length - 1]?.assignment?.user_assignment_status !== 0){
        let nextVideo = videos.indexOf(lastCompleted[lastCompleted.length - 1]) + 1;
        setNextVideoVisible({
            visible: true,
            videoId: videos[nextVideo].id,
          });
      }
    }
  }, [courseVideos]);

  // Handle video watch time
  useEffect(() => {
    const videoElement = videoRef.current;
    if (!videoElement) return;

    const handleTimeUpdate = () => {
      const currentTime = Math.floor(videoElement.currentTime);
      if (currentTime > watchTime) {
        setWatchTime(currentTime);
        dispatch(
          watchTimeVideo({ video_id: videoId, watch_time: currentTime })
        );
      }
    };

    videoElement.addEventListener("timeupdate", handleTimeUpdate);
    videoElement.addEventListener("ended", () => {
      refetchCourseVideos().then((res)=>{
        let videos = res.data.course_videos;
        const lastCompleted = videos.filter(
          (item) => item.is_video_completed === 1
        );
        let indexItem = lastCompleted.length;
        
        if(videos[videos.indexOf(lastCompleted[indexItem - 1])].assignment?.user_assignment_status === 0){
          console.log("if")
          setNextVideoVisible({
            visible: lastCompleted[indexItem - 1]?.assignment?.user_assignment_status === 0 ? false : true,
            videoId: lastCompleted[indexItem - 1]?.id,
          });
        } else if(videos[videos.indexOf(lastCompleted[indexItem - 1])].assignment !== null) {
          console.log("else if");
          setNextVideoVisible({
            visible: lastCompleted[indexItem - 1 + 1]?.assignment?.user_assignment_status === 0 ? false : true,
            videoId: lastCompleted[indexItem - 1 + 1]?.id,
          });
        } else{
          console.log("else");
          setNextVideoVisible({
            visible: true,
            videoId: lastCompleted[indexItem - 1 + 1]?.id,
          });
        }
        // let nextVideo = videos[videos.indexOf(lastCompleted[indexItem - 1]) + 1];
  
        // setNextVideoVisible({
        //   visible: lastCompleted[indexItem - 1]?.assignment?.user_assignment_status === 0 ? false : true,
        //   videoId: lastCompleted[indexItem - 1]?.id,
        // });
      });
    });

    return () => {
      videoElement.removeEventListener("timeupdate", handleTimeUpdate);
      videoElement.removeEventListener("ended", () => {

      });
    };
  }, [watchTime, videoId, dispatch, refetchCourseVideos]);

  const handleVideoSelection = useCallback(
    async (video) => {
      if (video.is_subscribe === 0) {
        setSubscriptionModal(true);
        return;
      }

      setWatchTime(0);
      setVideoDetail({
        videoUrl: getVideoUrl(video) || "No Video available.",
        summary: video?.video?.summary || "No description available.",
        content: video?.video?.content || "No content available.",
        title: video?.video?.title || "No title available.",
      });
      setVideoId(video.video_id);
      setGetVideoCommentId(video.id);
      await courseVideo({ data: { interaction_type: "video" }, id: video.id });
      refetchCourseVideos();

    },
    [courseVideo, refetchCourseVideos]
  );

  const handleAddComment = async (e) => {
    e.preventDefault();
    if (!commentText.trim()) return;

    try {
      setCommentUploading(true);
      const authToken = localStorage.getItem("authToken");
      await PostRequest(
        `/course-videos/${getVideoCommentId}/comments`,
        { body: commentText },
        authToken
      );
      toast.success("Comment added successfully!");
      setCommentText("");
      refetchComments();
    } catch (error) {
      toast.error("Failed to add comment.");
    } finally {
      setCommentUploading(false);
    }
  };

  const handleDeleteComment = async (id) => {
    try {
      const authToken = localStorage.getItem("authToken");
      await DeleteRequest(`/comment/${id}`, authToken);
      toast.success("Comment deleted successfully!");
      refetchComments();
    } catch (error) {
      toast.error("Failed to delete comment.");
    }
  };

  const handleEnroll = async () => {
    try {
      const authToken = localStorage.getItem("authToken");
      await PostRequest(`/enroll/${courseId}/enroll`, {}, authToken);
      toast.success("Successfully enrolled in the course!");
      setEnrollModal(false);
      refetchCourseVideos();
    } catch (error) {
      setEnrollError(error.response?.data?.message || "Enrollment failed.");
    }
  };

  const groupedVideos = useMemo(() => {
    const groups = {};
    let currentChapter = "";
    courseVideos?.course_videos?.forEach((video) => {
      currentChapter = video.chapter_name || currentChapter;
      groups[currentChapter] = groups[currentChapter] || [];
      groups[currentChapter].push(video);
    });
    return groups;
  }, [courseVideos]);

  const handleNavigate = (assignment_id, video_id) => {
    router.push(
      `/fill-assignment?assignment_id=${assignment_id}&video_id=${video_id}`
    );
  };

  return (
    <div className="min-h-screen md:px-7 px-3 pb-8">
      <Header />
      {courseVideos?.course_videos?.length ? (
        <div className="md:bg-white min-h-[80vh] rounded-xl md:p-8 mt-6">
          <div className="flex flex-col md:flex-row md:gap-10">
            <div className="w-full">
              <div className="bg-white md:p-0 p-5 rounded-xl">
                <h1 className="font-bold lg:text-3xl md:text-2xl text-lg mb-4">
                  {videoDetail.title}
                </h1>
                <video
                  ref={videoRef}
                  src={videoDetail.videoUrl}
                  autoPlay
                  controls
                  className="w-full h-auto rounded-3xl"
                />
              </div>
              <div className="bg-white rounded-xl">
                <div className="md:hidden border-b border-[#d8a32b] flex justify-evenly rounded-t-xl mt-7">
                  {["description", "comments", "videos"].map((tab) => (
                    <button
                      key={tab}
                      className={`text-lg py-3 ${
                        activeTab === tab
                          ? "font-bold border-b-2 border-[#d8a32b]"
                          : ""
                      }`}
                      onClick={() => setActiveTab(tab)}
                    >
                      {tab.charAt(0).toUpperCase() + tab.slice(1)}
                    </button>
                  ))}
                </div>
                {/* {activeTab === "description" && ( */}
                <div className="mt-6 md:block">
                  <h2 className="hidden md:block text-xl font-bold">
                    Description
                  </h2>
                  <div className="bg-white md:py-4 p-4 rounded-2xl mt-4">
                    <p>{seeMore ? videoDetail.content : videoDetail.summary}</p>
                    <button
                      className="font-semibold"
                      onClick={() => setSeeMore(!seeMore)}
                    >
                      {seeMore ? "See Less" : "See More"}
                    </button>
                  </div>
                </div>
                {/* )} */}
                {/* {activeTab === "comments" && ( */}
                <div className="mt-6 md:block">
                  <h2 className="hidden md:block text-xl font-bold my-6">
                    Comments
                  </h2>
                  <div className="bg-white md:py-4 p-4 rounded-2xl mt-4">
                    <form onSubmit={handleAddComment}>
                      <textarea
                        value={commentText}
                        onChange={(e) => setCommentText(e.target.value)}
                        className="bg-[#F9F5F5] w-full p-4 rounded-xl border border-gray-300 focus:outline-none focus:border-[#d8a32b]"
                        rows="4"
                        placeholder="Write your comment..."
                      />
                      <button
                        type="submit"
                        className="px-6 bg-[#d8a32b] py-3 rounded-lg text-white font-bold"
                        disabled={commentUploading}
                      >
                        {commentUploading ? "Submitting..." : "Submit"}
                      </button>
                    </form>
                    <div className="mt-4 flex flex-col gap-3">
                      {comments?.map((comment) => (
                        <div
                          key={comment.id}
                          className="p-4 rounded-lg border border-gray-400"
                        >
                          <div className="flex justify-between">
                            <div className="flex items-center gap-2">
                              {/* <img
                                  className="w-8 h-8 rounded-full"
                                  src={Profile}
                                  alt={comment.user?.name}
                                /> */}
                              <Image
                                src={Profile}
                                alt="profile"
                                className="w-8 h-8 rounded-full cursor-pointer"
                              />
                              <p className="font-bold text-sm">
                                {comment.user?.name}
                              </p>
                            </div>
                            {comment.user_id === auth?.userDetail?.id && (
                              <button
                                onClick={() => handleDeleteComment(comment.id)}
                                className="p-1 bg-[#d8a32b] rounded-md"
                              >
                                <FontAwesomeIcon
                                  icon={faTrashCan}
                                  className="h-4 w-4 text-white"
                                />
                              </button>
                            )}
                          </div>
                          <p className="text-gray-600 ml-8">{comment.body}</p>
                          {comment.replies?.map((reply) => (
                            <div key={reply.id} className="ml-10 mt-3">
                              <div className="flex items-center gap-2">
                                <Image
                                  src={Profile}
                                  alt="profile"
                                  className="w-8 h-8 rounded-full cursor-pointer"
                                />
                                <p className="font-bold text-sm">
                                  {reply.user?.name}
                                </p>
                              </div>
                              <p className="text-gray-600 ml-8">{reply.body}</p>
                            </div>
                          ))}
                          <button
                            className="text-[#d8a32b] flex items-center mt-2"
                            onClick={() => {
                              setSelectedComment(comment);
                              setModalOpen(true);
                            }}
                          >
                            <FontAwesomeIcon
                              icon={faReply}
                              className="h-3 w-4 mr-1"
                            />
                            Reply
                          </button>
                        </div>
                      ))}
                    </div>
                  </div>
                </div>
                {/* )} */}
              </div>
            </div>
            <UpComingVideos groupedVideos={groupedVideos} handleVideoSelection={handleVideoSelection} handleNavigate={handleNavigate} nextVideoVisible={nextVideoVisible} />
          </div>
          <ReplyModal
            isOpen={isModalOpen}
            onClose={() => setModalOpen(false)}
            comment={selectedComment}
            videoId={getVideoCommentId}
            commented={() => refetchComments()}
          />
        </div>
      ) : (
        <div className="min-h-[90vh] flex justify-center items-center">
          <Spinner color="warning" />
        </div>
      )}
      {subscriptionModal && (
        <div className="fixed inset-0 flex items-center justify-center bg-black bg-opacity-50">
          <div className="bg-white p-6 rounded-lg max-w-sm w-full text-center">
            <p className="mb-4">
              Subscribe to watch more videos.{" "}
              <button
                onClick={() => router.push(`/payment?course=${id}`)}
                className="text-blue-500 underline"
              >
                Click to subscribe
              </button>
            </p>
            <button
              onClick={() => setSubscriptionModal(false)}
              className="bg-red-500 text-white px-4 py-2 rounded"
            >
              Close
            </button>
          </div>
        </div>
      )}
      {enrollModal && (
        <div className="fixed inset-0 flex items-center justify-center bg-black bg-opacity-70">
          <div className="bg-white p-6 rounded-lg max-w-md w-full text-center">
            <p className="mb-4 text-xl font-medium text-[#d8a32b]">
              Enroll to watch more videos
            </p>
            {enrollError && <p className="text-red-500">{enrollError}</p>}
            <div className="flex gap-4 justify-center">
              <button
                onClick={() => setEnrollModal(false)}
                className="bg-gray-500 text-white px-4 py-2 rounded"
              >
                Close
              </button>
              <button
                onClick={handleEnroll}
                className="bg-[#d8a32b] text-white px-4 py-2 rounded"
              >
                Enroll
              </button>
            </div>
          </div>
        </div>
      )}
    </div>
  );
};

export default CourseVideos;
