import Image from "next/image";
import cardImage from "../../../../../public/assets/dashboard/courses/course-01.jpg";
import { faClock } from "@fortawesome/free-solid-svg-icons";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import Link from "next/link";
import { useState } from "react";
import { BASE_IMAGE_URL } from "@/services/ApiEndpoints";
import { useDispatch } from "react-redux";
import { courseToEnroll } from "@/newStore/features/courseToEnrolled";
import { getAllCourses } from "@/newStore/features/getAllCourseSlice";

export default function CourseCardItem({ course, buttonOverylay }) {
  const [loading, setLoading] = useState(false);
  const dispatch = useDispatch();

  return (
    <div
      key={course?.id}
      className="bg-white border border-[#c7c7c7] rounded-3xl overflow-hidden relative"
    >
      <div className="w-full overflow-hidden relative">
        {course?.image === null ? (
          <Image
            className="object-cover h-auto w-full max-h-[208px] min-h-[208px]"
            src={cardImage}
            alt="image"
            layout="responsive"
          />
        ) : (
          <img
            className="object-cover h-auto w-full max-h-[208px] min-h-[208px]"
            src={BASE_IMAGE_URL + course?.image}
            alt="image"
            loading="lazy"
          />
        )}
      </div>

      <div className="p-4">
        <div className="flex justify-between items-center mt-2">
          <div className="gap-2 items-center">
            <h5 className="text font-bold tracking-tight text-[#3D3C3C]">
              {course?.title || course?.course?.title}
            </h5>
            <div className="flex gap-2 items-center">
              <FontAwesomeIcon
                icon={faClock}
                className="text-golden text-[16px]"
              />
              <span className="text-[16px] font-normal">
                {course?.course_duration ? (
                  <span>{course?.course_duration}</span>
                ) : (
                  <span>1 Week</span>
                )}
              </span>
            </div>
          </div>
          {course?.enrolled === 0 ? (
            <button
              type="button"
              className="bg-golden text-white px-4 py-2 rounded-md inline-flex items-center gap-2 text-sm"
              onClick={() => {
                setLoading(true); // Activate loading
                dispatch(courseToEnroll(course?.id)).then(() => {
                  dispatch(getAllCourses());
                  setLoading(false); // Deactivate loading after completion
                });
              }}
              disabled={loading} // Disable button while loading
            >
              {loading ? "Enrolling..." : "Enroll Now"}
            </button>
          ) : (
            <Link
              href={`/courses/${course.id}`}
              onClick={() => setLoading(true)} // Activate loading
              className="bg-golden text-white px-4 py-2 rounded-md inline-flex items-center gap-2 text-sm"
            >
              {loading ? "Loading..." : "Watch"}
            </Link>
          )}
        </div>
      </div>
    </div>
  );
}