import Image from "next/image";
import React from "react";
import certificate1 from "../../../../../../public/assets/dashboard/certification/image1.png";
import certificate2 from "../../../../../../public/assets/dashboard/certification/image2.png";
import certificate3 from "../../../../../../public/assets/dashboard/certification/image3.png";
import certificate4 from "../../../../../../public/assets/dashboard/certification/image4.png";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faDownload } from "@fortawesome/free-solid-svg-icons";
import Notifications from "@/app/components/notifications/Notifications";
import SearchBox from "@/app/components/searchBox/SearchBox";

const AllCertifications = () => {

  const allCertificates = [
    {
      title: "Certification 1",
      image: certificate1,
      link: "",
    },
    {
      title: "Certification 2",
      image: certificate2,
      link: "",
    },
    {
      title: "Certification 3",
      image: certificate3,
      link: "",
    },
    {
      title: "Certification 4",
      image: certificate4,
      link: "",
    },
  ];

  return (
    <div className="md:px-[28px] px-3 pb-8 min-h-screen">
      <h1 className="py-2 text-[34px] font-bold">Dashboard</h1>
      <div className="flex items-center justify-between gap-8 ">
        <div>
          <SearchBox />
        </div>
        <div className="flex items-center gap-2 text-darkgrey">
          <Notifications />
        </div>
      </div>
      <div className=" bg-[#FFFAFA] mt-3 p-4 rounded-xl">
        <div className="flex justify-between items-center mt-4">
          <p className="text-[20px] font-bold">
            Here is your achievements (Completed Courses)
          </p>
        </div>
        <div className="mt-4 grid lg:grid-cols-4 place-items-center md:grid-cols-3 sm:grid-cols-2 grid-cols-1 min-h-[314px] xl:gap-x-10 gap-x-4 gap-y-4">
          {allCertificates?.length &&
            allCertificates?.map((certificate) => (
              <div className="max-w-[214px]">
                <div>
                  <Image src={certificate?.image} alt="" />
                  <div className="flex justify-between mt-3">
                    <p className="text-[#363636] font-bold">
                      {certificate?.title}
                    </p>
                    <button className="text-blue-800">
                      <FontAwesomeIcon icon={faDownload} />
                    </button>
                  </div>
                </div>
              </div>
            ))}
        </div>
      </div>
    </div>
  );
};

export default AllCertifications;