"use client";
import React, { useEffect } from "react";
import studentProfile from "../../../../../public/assets/dashboard/profile.png";
import certificate1 from "../../../../../public/assets/dashboard/certification/image1.png";
import certificate2 from "../../../../../public/assets/dashboard/certification/image2.png";
import certificate3 from "../../../../../public/assets/dashboard/certification/image3.png";
import certificate4 from "../../../../../public/assets/dashboard/certification/image4.png";
import Image from "next/image";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faDownload } from "@fortawesome/free-solid-svg-icons";
import Slider from "react-slick";
import "slick-carousel/slick/slick.css";
import "slick-carousel/slick/slick-theme.css";
import { faArrowRightLong } from "@fortawesome/free-solid-svg-icons";
import { faArrowLeftLong } from "@fortawesome/free-solid-svg-icons";
import { faFileImport } from "@fortawesome/free-solid-svg-icons";
import { Pie } from "react-chartjs-2";
import {
  faGraduationCap,
  faEllipsisVertical,
} from "@fortawesome/free-solid-svg-icons";
import { Chart as ChartJS, ArcElement, Tooltip, Legend } from "chart.js";
import Link from "next/link";
import Header from "../header/header";
import { useSelector, useDispatch } from "react-redux";
// import { fetchCourseProgress } from "@/newStore/features/courseProgresSlice";
import { fetchEnrolledCourses } from "@/newStore/features/enrolledCoursesSlice";
import LoaderCircle from "../../loaderCircle/loaderCircle";
ChartJS.register(ArcElement, Tooltip, Legend);

const Certifications = () => {
  const dispatch = useDispatch();
  const courseProgress = useSelector((state) => state.courseProgress);
  const enrolledCourses = useSelector(
    (state) => state.enrolledCourses.enrolledCourses
  );
  const enrolledCoursesLoader = useSelector(
    (state) => state.enrolledCourses.isLoading
  );

  useEffect(() => {
    // dispatch(fetchCourseProgress(1));
    dispatch(fetchEnrolledCourses());
  }, []);

  const pieChartData = [
    {
      datasets: [
        {
          data: [courseProgress?.progress_percentage, 100],
          backgroundColor: ["#B9802A", "#E1BD6B"],
          borderColor: ["transparent", "transparent"],
        },
      ],
    },
    {
      datasets: [
        {
          data: [40, 60],
          backgroundColor: ["#89B6F1", "#BFD9F1"],
          borderColor: ["transparent", "transparent"],
        },
      ],
    },
    {
      datasets: [
        {
          data: [40, 80],
          backgroundColor: ["#87CEEB", "#C8E7F5"],
          borderColor: ["transparent", "transparent"],
        },
      ],
    },
  ];

  const options = {
    responsive: true,
    plugins: {
      legend: {
        position: "top",
      },
      tooltip: {
        enabled: null,
      },
      hover: {
        mode: null,
        animation: false,
      },
      interaction: {
        mode: null,
      },
    },
  };

  const allCertificates = [
    {
      title: "Certification 1",
      image: certificate1,
      link: "",
    },
    {
      title: "Certification 2",
      image: certificate2,
      link: "",
    },
    {
      title: "Certification 3",
      image: certificate3,
      link: "",
    },
    {
      title: "Certification 4",
      image: certificate4,
      link: "",
    },
  ];

  const settings = {
    infinite: false,
    speed: 500,
    arrows: true,
    slidesToShow: 4,
    slidesToScroll: 1,
    prevArrow: <FontAwesomeIcon icon={faArrowLeftLong} />,
    nextArrow: <FontAwesomeIcon icon={faArrowRightLong} />,
    responsive: [
      {
        breakpoint: 1440,
        settings: {
          slidesToShow: 3,
        },
      },
      {
        breakpoint: 767,
        settings: {
          slidesToShow: 2,
        },
      },
      {
        breakpoint: 539,
        settings: {
          slidesToShow: 1,
        },
      },
    ],
  };

  return (
    <div className="md:px-[28px] px-3 pb-8 min-h-screen">
      <Header title="Certifications" />
      {enrolledCourses?.courses?.length > 0 && (
        <div className="bg-white mt-6 rounded-2xl w-full max-h-full p-6 mb-4">
          <div className="mb-4">
            <p className="text-[22px] font-bold">Courses Progress</p>
          </div>
          {enrolledCoursesLoader ? (
            <div className="pr-2 h-[280px] flex justify-center items-center">
              <LoaderCircle />
            </div>
          ) : (
            <div>
              {enrolledCourses === null ? (
                <div className="flex justify-center items-center min-h-[377px] min-w-full">
                  <LoaderCircle />
                </div>
              ) : enrolledCourses?.courses?.length > 0 ? (
                <Slider slideCount={enrolledCourses?.courses?.length} {...settings} className="course-progress-slider">
                  {enrolledCourses?.courses?.map((course, index) => (
                    <div key={index}>
                      {/* w-[220px] sm:w-[250px] md:w-[300px] */}
                      <div className=" border border-[#c7c7c7] rounded-xl overflow-hidden">
                        <div className="flex justify-between mb-3 relative">
                          <Image
                            src={course?.media[0]?.url || certificate1}
                            alt="student-profile"
                            className="h-[220px] w-full object-cover"
                          />
                          <p
                            className={
                              course?.status === "completed"
                                ? "border-[#0EAD71] text-[#0EAD71] text-[14px] font-medium absolute top-2 right-2 border rounded-full px-2 py-1 bg-white "
                                : "border-[#00CED1] text-[#00CED1] text-[14px] font-medium absolute top-2 right-2 border rounded-full px-2 py-1 bg-white"
                            }
                            style={{
                              color:
                                course?.status === "completed"
                                  ? "#0EAD71"
                                  : "#00CED1",
                            }}
                          >
                            {course?.status === "completed"
                              ? "Done"
                              : "Ongoing"}
                          </p>
                        </div>
                        <div className="p-4">
                          <h3 className="text-[18px] font-bold -mt-2 mb-2">
                            {course?.title}
                          </h3>
                          <div className="w-full h-[6px] bg-[#D9D9D9] rounded-3xl mb-3">
                            <div
                              className="bg-golden rounded-3xl h-[6px]"
                              style={{
                                width: `${course?.progress_percentage}%`,
                              }}
                            ></div>
                          </div>

                          <div className="flex justify-between">
                            <div className="flex items-center gap-2">
                              <Image
                                src={
                                  course?.user?.profile_photo_path ||
                                  studentProfile
                                }
                                alt="student-profile"
                                className="w-[30px] max-h-[30px] object-cover"
                              />
                              <span className="text-[12px]">
                                {course?.user?.name}
                              </span>
                            </div>
                            {/* <div className="flex items-center gap-2">
                              <FontAwesomeIcon icon={faFileImport} />
                            </div> */}
                            <Link
                              href={`/courses/${course.id}`}
                              className=" bg-golden text-white px-4 py-2 rounded-md inline-flex items-center gap-2 text-sm"
                            >
                              Watch
                            </Link>
                          </div>
                        </div>
                      </div>
                    </div>
                  ))}
                </Slider>
              ) : (
                <div className="flex justify-center items-center min-h-[377px] min-w-full">
                  No Courses Available
                </div>
              )}
            </div>
          )}
        </div>
      )}
      <div className="bg-white rounded-2xl w-full max-h-full p-6">
        <div className="flex justify-between items-center mb-8">
          <p className="text-[20px] font-bold">Here Are Your Certifications</p>
          <Link href="certifications/all" className="text-[18px] font-bold">
            See all
          </Link>
        </div>
        <div className="mt-4 grid lg:grid-cols-4 place-items-center md:grid-cols-3 sm:grid-cols-2 grid-cols-1 min-h-[314px] xl:gap-x-10 gap-x-4 gap-y-4">
          {allCertificates?.length &&
            allCertificates?.map((certificate, index) => (
              <div className="w-full" key={index}>
                <Image
                  src={certificate?.image}
                  alt=""
                  className="w-full rounded-lg"
                />
                <div className="flex justify-between mt-3">
                  <p className="text-[#363636] font-bold">
                    {certificate?.title}
                  </p>
                  <button className="text-blue-800">
                    <FontAwesomeIcon icon={faDownload} />
                  </button>
                </div>
              </div>
            ))}
        </div>
      </div>
    </div>
  );
};

export default Certifications;
