import React, { useEffect } from "react";
import { assignmentTask as assignmentTaskSlice } from "@/newStore/features/assignmentTaskSlice";
import { useSelector, useDispatch } from "react-redux";
import LoaderCircle from "../../loaderCircle/loaderCircle";
import Image from "next/image";
import image1 from "../../../../../public/assets/dashboard/video.png";


const AssignTasks = () => {
  const dispatch = useDispatch();
  const assignmentTask = useSelector(
    (state) => state.assignmentTask.assignmentTask
  );

  useEffect(() => {
    dispatch(assignmentTaskSlice());
  }, [dispatch]);

  return (
    <>
      {assignmentTask === null ? (
        <div className="pr-2 h-[280px] flex justify-center items-center">
          <LoaderCircle />
        </div>
      ) : (
        <div className="overflow-y-auto pr-2 h-[280px] customScrollbar">
          <table className="min-w-full">
            <thead>
              <tr className={`border-b border-[#c7c7c7]`}>
                <th className="text-[14px] p-2 text-left font-bold">No</th>
                <th className="text-[14px] p-2 text-left font-bold">About</th>
                <th className="text-[14px] p-2 text-center font-bold">
                  Due Date
                </th>
                <th className="text-[14px] p-2 text-center font-bold">
                  Status
                </th>
              </tr>
            </thead>
            <tbody>
              {assignmentTask?.assignments?.length &&
                assignmentTask?.assignments?.map((task, index) => (
                  <tr
                    key={task?.id}
                    className={`border-b ${
                      index === task?.length - 1 ? "" : "border-[#c7c7c7]"
                    } hover:bg-[#eee] transition-colors duration-200`}
                  >
                    <td className="p-2">{index + 1}</td>
                    <td className="p-2">
                      <div className="flex gap-2">
                        <div>
                          <Image
                            src={image1}
                            alt="video"
                            className="w-[40px] h-[40px] rounded-full object-cover"
                          />
                        </div>
                        <div className="flex flex-col gap-1">
                          <p className="text-sm font-bold">{task?.title}</p>
                          <p className="text-xs">{task?.description}</p>
                        </div>
                      </div>
                    </td>
                    <td className="p-2 text-center">
                      <p className="text-sm font-bold">
                        {new Date(task?.due_date).toLocaleDateString("en-US", {
                          day: "2-digit",
                          month: "short",
                          year: "numeric",
                        })}
                      </p>
                    </td>
                    <td className="p-2 text-center">
                      <span
                        className={`text-[14px] capitalize px-6 d-inline-block w-auto mx-auto rounded-full py-[8px] ${
                          task?.status.toLowerCase() === "completed"
                            ? "bg-[#0EAD71] text-white"
                            : "bg-golden text-[#3C4963]"
                        }`}
                      >
                        {task?.status}
                      </span>
                    </td>
                  </tr>
                ))}
            </tbody>
          </table>
        </div>
      )}
    </>
  );
};

export default AssignTasks;
