import { createAsyncThunk, createSlice } from "@reduxjs/toolkit";
import { API_END_POINTS } from "../../services/ApiEndpoints";

const initialState = {
  inProgressCourses: null,
  isLoading: false,
};

// fetch calls
export const inProgress = createAsyncThunk(
  "inProgress/inProgress",
  async (_, { getState }) => {
    const token = getState().auth?.token;

    try {
      const response = await fetch(API_END_POINTS.getCourseInProgress, {
        headers: {
          Authorization: `Bearer ${token}`,
        },
      });

      if (!response.ok) throw new Error("Failed to fetch course progress");
      return await response.json();
    } catch (error) {
      throw error;
    }
  }
);

const inProgressSlice = createSlice({
  name: "inProgress",
  initialState,
  reducers: {
    getInProgress: (state, action) => {
      state.inProgressCourses = action.payload.courses;
    },
  },
  extraReducers: (builder) => {
    builder.addCase(inProgress.fulfilled, (state, action) => {
      state.inProgressCourses = action.payload.courses;
      state.isLoading = false;
    });
    builder.addCase(inProgress.pending, (state, action) => {
      state.isLoading = true;
    });
  },
});

export default inProgressSlice.reducer;
