import { createSlice, createAsyncThunk } from "@reduxjs/toolkit";
import { API_END_POINTS } from "../../services/ApiEndpoints";

// initial state
const initialState = {
  course_id: null,
  course_title: null,
  total_videos: null,
  total_assignments: null,
  watched_videos: null,
  attempted_assignments: null,
  progress_percentage: null,
};

// fetch calls
export const fetchCourseProgress = createAsyncThunk(
  "courseProgress/fetchCourseProgress",
  async (id, { getState }) => {
    const token = getState().auth?.token;

    try {
      const response = await fetch(
        `${API_END_POINTS.getCoursess}/${id}/progress`,
        {
          headers: {
            Authorization: `Bearer ${token}`,
          },
        }
      );
      if (!response.ok) throw new Error("Failed to fetch course progress");
      return await response.json();
    } catch (error) {
      throw error;
    }
  }
);

// create slice
const courseProgressSlice = createSlice({
  name: "courseProgress",

  initialState,
  reducers: {
    getCourseProgress: (state, action) => {
      state.courseProgress = action.payload;
    },
  },
  extraReducers: (builder) => {
    builder.addCase(fetchCourseProgress.fulfilled, (state, action) => {
      state.course_id = action.payload.course_id;
      state.course_title = action.payload.course_title;
      state.total_videos = action.payload.total_videos;
      state.total_assignments = action.payload.total_assignments;
      state.watched_videos = action.payload.watched_videos;
      state.attempted_assignments = action.payload.attempted_assignments;
      state.progress_percentage = action.payload.progress_percentage;
    });
  },
});

export const { getCourseProgress } = courseProgressSlice.actions;
export default courseProgressSlice.reducer;
