import { createAsyncThunk, createSlice } from "@reduxjs/toolkit";
import { API_END_POINTS } from "../../services/ApiEndpoints";

const initialState = {
  courseCompleted: null,
};


// fetch calls
export const courseCompleted = createAsyncThunk(
  "courseCompleted/courseCompleted",
  async (_, { getState }) => {
    const token = getState().auth?.token;

    try {
      const response = await fetch(API_END_POINTS.getCourseCompleted, {
        headers: {
          Authorization: `Bearer ${token}`,
        },
      });

      if (!response.ok) throw new Error("Failed to fetch course completed");
      return await response.json();

    } catch (error) {
      throw error;
    }
  }
);

const courseCompletedSlice = createSlice({
  name: "courseCompleted",
  initialState,
  reducers: {
    getCourseCompleted: (state, action) => {
      state.courseCompleted = action.payload.courses;
    },

  },
  extraReducers: (builder) => {
    builder.addCase(courseCompleted.fulfilled, (state, action) => {
      state.courseCompleted = action.payload.courses;
    });
  },

});

export default courseCompletedSlice.reducer;
