"use client";
import React, { useEffect, useRef, useState } from "react";
import {
  faTrash,
  faBell as fasBell,
  faBellSlash,
} from "@fortawesome/free-solid-svg-icons";
import { faComment } from "@fortawesome/free-solid-svg-icons";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import notification from "../../../../public/assets/dashboard/notification.png";
import Image from "next/image";
import {
  useGetNotificationsQuery,
  useNotificationActionMutation,
} from "@/services/Api";
import toast from "react-hot-toast";
import { faBell } from "@fortawesome/free-regular-svg-icons";

const Notifications = () => {
  const [isOpen, setIsOpen] = useState(false);
  const [isCallApi, setIsCallApi] = useState(false);
  const dropdownRef = useRef(null);

  const {
    data: getNotifications,
    isLoading: getNotificationsLoading,
    refetch: getNotificationsRefetch,
  } = useGetNotificationsQuery();

  const [notificationAction] = useNotificationActionMutation();

  const handleNotificationAction = (id, type) => {
    const data = {
      type: type,
    };

    if (id != undefined) {
      data.id = id;
    }

    notificationAction({ data: data })
      .unwrap()
      .then(() => {
        getNotificationsRefetch();
        toast.success("Action done succesfully", {
          position: "top-center",
        });
      })
      .catch((error) => {});
  };

  const toggleDropdown = () => {
    setIsOpen((prev) => !prev);
    setIsCallApi(true);
  };

  const handleClickOutside = (event) => {
    if (dropdownRef.current && !dropdownRef.current.contains(event.target)) {
      setIsOpen(false);
    }
  };

  useEffect(() => {
    document.addEventListener("mousedown", handleClickOutside);
    return () => {
      document.removeEventListener("mousedown", handleClickOutside);
    };
  }, []);

  useEffect(() => {
    getNotificationsRefetch();
  }, []);

  useEffect(() => {
    if (isCallApi) {
      getNotificationsRefetch();
    }
  }, [isCallApi]);

  return (
    <div className="relative">
      <button onClick={toggleDropdown} className="mt-2 relative notIcon">
        {/* <Image src={notification} className="h-6 w-5" /> */}
        <FontAwesomeIcon icon={faBell} className="text-[#3C4963] text-[20px]" />
        {getNotifications?.notification?.length ? <span></span> : null}
      </button>
      {isOpen && (
        <div
          className="absolute right-0 w-96 bg-white shadow-lg mt-2 rounded-md p-2 z-10"
          ref={dropdownRef}
        >
          {getNotifications?.notification?.length ? (
            <button
              onClick={() => handleNotificationAction(undefined, 3)}
              className="text-xs mb-2 font-bold text-end w-full"
            >
              Mark all as Read
            </button>
          ) : null}
          <ul className="max-h-60 overflow-y-auto rounded-md">
            {getNotifications?.notification?.length ? (
              getNotifications?.notification?.map((data, index) => (
                <li
                  key={index}
                  className={`flex justify-between border-b px-4 py-2 hover:bg-gray-100 ${
                    data.read ? "bg-gray-100" : ""
                  }`}
                >
                  <div className="flex gap-1">
                    <FontAwesomeIcon icon={faComment} className="text-golden text-md mt-1" />
                    <div className="flex items-center text-sm">
                      <span
                        className={` ${
                          data.read ? "text-gray-500" : "font-bold"
                        }`}
                      >
                        {data?.data?.message}
                      </span>
                    </div>
                  </div>
                  {/* <button onClick={() => handleNotificationAction(data?.id, 4)} className="m-3">
                                    <FontAwesomeIcon icon={faTrash} className="text-red-500 hover:text-red-700" />
                                </button> */}
                  <button
                    onClick={() => handleNotificationAction(data?.id, 1)}
                    className="text-xs ml-2"
                  >
                    {data?.read_at ? "Mark as Unread" : "Read"}
                  </button>
                </li>
              ))
            ) : (
              <>
                {getNotificationsLoading ? (
                  <p className="mt-1 text-gray-600 text-center">Loading...</p>
                ) : (
                  <p className="m-2 text-gray-600 text-center">
                    No new notifications...
                  </p>
                )}
              </>
            )}
          </ul>
        </div>
      )}
    </div>
  );
};

export default Notifications;
