"use client";

import React, { useState } from "react";
import { Nav, Navbar, NavDropdown } from "react-bootstrap";
import { usePathname } from "next/navigation";
import Link from "next/link";
import logo from "../../../../public/assets/homeNew/Images/logo.png";
import "../../../../public/assets/styles/spacers.css"
import Image from "next/image";

const Topbar = () => {
  const currentPath = usePathname();
  const [isSidebarOpen, setIsSidebarOpen] = useState(false);
  const [isDropdownOpen, setIsDropdownOpen] = useState(false);

  // Array of course links for the dropdown
  const courses = [
    { name: "Course 1", path: "/courses/course-1" },
    { name: "Course 2", path: "/courses/course-2" },
    { name: "Course 3", path: "/courses/course-3" },
  ];

  // Toggle sidebar visibility
  const toggleSidebar = () => {
    setIsSidebarOpen(!isSidebarOpen);
  };

  // Close sidebar
  const closeSidebar = () => {
    setIsSidebarOpen(false);
    setIsDropdownOpen(false); // Close dropdown when sidebar closes
  };

  // Toggle dropdown
  const toggleDropdown = () => {
    setIsDropdownOpen(!isDropdownOpen);
  };

  return (
    <div className="top-bar mx-auto w-100 overflow-hidden">
      <Navbar
        bg="transparent"
        data-bs-theme="dark"
        className="py-13 px-26 d-flex justify-content-between"
        expand="lg"
      >
        <Navbar.Brand as={Link} href="/" className="logo">
          <Image src={logo} alt="EGWB Logo" placeholder="blur" width="104" />
        </Navbar.Brand>
        {/* Hamburger Toggle */}
        <Navbar.Toggle
          aria-controls="responsive-navbar-nav"
          onClick={toggleSidebar}
        />

        {/* Sidebar for Mobile View */}
        <div
          className={`sidebar ${isSidebarOpen ? "open" : ""}`}
          onClick={closeSidebar}
        >
          <div className="sidebar-content" onClick={(e) => e.stopPropagation()}>
            <button className="sidebar-close-btn" onClick={closeSidebar}>
              <svg
                xmlns="http://www.w3.org/2000/svg"
                width="24"
                height="24"
                viewBox="0 0 24 24"
                fill="none"
                stroke="white"
                strokeWidth="2"
                strokeLinecap="round"
                strokeLinejoin="round"
              >
                <line x1="18" y1="6" x2="6" y2="18" />
                <line x1="6" y1="6" x2="18" y2="18" />
              </svg>
            </button>
            <Nav className="flex-column">
              <Nav.Link
                as={Link}
                href="/"
                className={`aa-text-base fw-semibold py-10 px-18 d-flex align-items-center ${
                  currentPath === "/" ? "active" : ""
                }`}
                onClick={closeSidebar}
              >
                Home
              </Nav.Link>
              <Nav.Link
                as={Link}
                href="/about"
                className={`aa-text-base fw-semibold py-10 px-18 d-flex align-items-center ${
                  currentPath === "/about" ? "active" : ""
                }`}
                onClick={closeSidebar}
              >
                About Us
              </Nav.Link>
              <Nav.Link
              as={Link}
              href="/course"
              className={`aa-text-base fw-semibold py-10 px-18 d-flex align-items-center ${
                currentPath === "/course" ? "active" : ""
              }`}
            >
              courses
            </Nav.Link>
              {/* <div className="sidebar-dropdown">
                <div
                  className={`aa-text-base fw-semibold py-10 dropdown-toggle ${
                    courses.some((course) => currentPath === course.path)
                      ? "active"
                      : ""
                  }`}
                  onClick={toggleDropdown}
                >
                  Courses
                </div>
                {isDropdownOpen && (
                  <div className="sidebar-dropdown-menu">
                    {courses.map((course) => (
                      <Nav.Link
                        key={course.path}
                        as={Link}
                        href={course.path}
                        className={`aa-text-base ${
                          currentPath === course.path ? "active" : ""
                        }`}
                        onClick={closeSidebar}
                      >
                        {course.name}
                      </Nav.Link>
                    ))}
                  </div>
                )}
              </div> */}
              <Nav.Link
                as={Link}
                href="/certificates"
                className={`aa-text-base fw-semibold py-10 px-18 d-flex align-items-center ${
                  currentPath === "/certificates" ? "active" : ""
                }`}
                onClick={closeSidebar}
              >
                Certifications
              </Nav.Link>
              <Nav.Link
                as={Link}
                href="/blog"
                className={`aa-text-base fw-semibold py-10 px-18 d-flex align-items-center ${
                  currentPath === "/blog" ? "active" : ""
                }`}
                onClick={closeSidebar}
              >
                Blogs
              </Nav.Link>
              <div className="sidebar-buttons d-flex flex-column align-items-start">
                <Link
                  href="/"
                  className="btn me-21 aa-text-base fw-semibold"
                  onClick={closeSidebar}
                >
                  Signup/Login
                </Link>
                <Link
                  href="/"
                  className="btn btn-primary"
                  onClick={closeSidebar}
                >
                  Get Started
                </Link>
              </div>
            </Nav>
          </div>
        </div>

        {/* Default Navbar for Desktop */}
        <Navbar.Collapse id="responsive-navbar-nav" className="desktop-nav d-none">
          <Nav className="ms-auto me-auto">
            <Nav.Link
              as={Link}
              href="/"
              className={`aa-text-base fw-semibold py-10 px-18 d-flex align-items-center ${
                currentPath === "/" ? "active" : ""
              }`}
            >
              Home
            </Nav.Link>
            <Nav.Link
              as={Link}
              href="/about"
              className={`aa-text-base fw-semibold py-10 px-18 d-flex align-items-center ${
                currentPath === "/about" ? "active" : ""
              }`}
            >
              About Us
            </Nav.Link>
            <Nav.Link
              as={Link}
              href="/course"
              className={`aa-text-base fw-semibold py-10 px-18 d-flex align-items-center ${
                currentPath === "/course" ? "active" : ""
              }`}
            >
              courses
            </Nav.Link>
            {/* <NavDropdown
              title="Courses"
              id="courses-nav-dropdown"
              className="aa-text-base fw-semibold py-2 px-18"
              active={courses.some((course) => currentPath === course.path)}
            >
              {courses.map((course) => (
                <NavDropdown.Item
                  key={course.path}
                  as={Link}
                  href={course.path}
                  className={`aa-text-base ${
                    currentPath === course.path ? "active" : ""
                  }`}
                >
                  {course.name}
                </NavDropdown.Item>
              ))}
            </NavDropdown> */}
            <Nav.Link
              as={Link}
              href="/certificates"
              className={`aa-text-base fw-semibold py-10 px-18 d-flex align-items-center ${
                currentPath === "/certificates" ? "active" : ""
              }`}
            >
              Certifications
            </Nav.Link>
            <Nav.Link
              as={Link}
              href="/blog"
              className={`aa-text-base fw-semibold py-10 px-18 d-flex align-items-center ${
                currentPath === "/blog" ? "active" : ""
              }`}
            >
              Blogs
            </Nav.Link>
          </Nav>
          <div className="d-flex align-items-center">
            <Link
              href="/login"
              className="btn me-21 aa-text-base fw-semibold"
            >
              Signup/Login
            </Link>
            <Link href="/sign-up" className="btn btn-primary">
              Get Started
            </Link>
          </div>
        </Navbar.Collapse>
      </Navbar>
    </div>
  );
};

export default Topbar;