import React from "react";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faPlay } from "@fortawesome/free-solid-svg-icons";

const WhyChooseUs = () => {

  const data = [
    {
      title: "Daily Video Update",
      text: "Mountains in just switching city steps Might rung line what Was or between towards the have phase.",
    },
    {
      title: "Videos from Experts",
      text: "Mountains in just switching city steps Might rung line what Was or between towards the have phase.",
    },
    {
      title: "Category Options",
      text: "Mountains in just switching city steps Might rung line what Was or between towards the have phase.",
    },
    {
      title: "   500+ High Quality Videos",
      text: "Mountains in just switching city steps Might rung line what Was or between towards the have phase.",
    },
    {
      title: "Earn a Certificate",
      text: "Mountains in just switching city steps Might rung line what Was or between towards the have phase.",
    },
  ];

  return (
    <div className="max-w-7xl p-8 mx-auto">
      <div className="max-w-7xl px-8 py-8 mx-auto">
        <div className="flex justify-center items-center">
          <div className="grid justify-center  grid-cols-1 md:grid-cols-2 xl:grid-cols-3 gap-y-10 lg:gap-x-8 md:gap-x-4">
            <div className="group transform transition-transform hover:-translate-y-6 hover:shadow-2xl hover:scale-105 max-w-sm bg-white">
              <div>
                <div className="p-5">
                  <h5 className="mb-2 text-4xl font-bold tracking-tight text-gray-900 group-hover:text-golden">
                    Why
                    <br />
                    choose Us
                  </h5>

                  <p className="mb-3 font-normal text-gray-700 dark:text-gray-400">
                    Comfort reached gay perhaps chamber his six detract besides
                    add. Moonlight newspaper up its enjoyment agreeable
                    depending.
                  </p>
                </div>
              </div>
            </div>
            {data?.length &&
              data?.map((data, index) => (
                <div
                  key={index}
                  className="group transform transition-transform hover:-translate-y-6 hover:shadow-2xl hover:scale-105 max-w-sm bg-[#EFF4FF] border border-gray-200 rounded-lg shadow"
                >
                  <div className="">
                    <div className="p-5">
                      <FontAwesomeIcon
                        icon={faPlay}
                        className="text-[#B9802A]"
                        size="2xl"
                      />
                      <h5 className="my-5 text-2xl font-bold tracking-tight text-gray-900 group-hover:text-golden">
                        {data?.title}
                      </h5>

                      <p className="mb-3 font-normal text-gray-700">
                        {data?.text}
                      </p>
                    </div>
                  </div>
                </div>
              ))}
          </div>
        </div>
      </div>
    </div>
  );
};

export default WhyChooseUs;