import React from "react";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faSlash } from "@fortawesome/free-solid-svg-icons";
import Image from "next/image";
import bgimage2 from "../../../../public/assets/home/studenFeedback/bgimage2.png";
import bgimage1 from "../../../../public/assets/home/studenFeedback/bgimage1.png";
import student from "../../../../public/assets/home/studenFeedback/student.png";
import comma from "../../../../public/assets/comma.png";

const StudentFeedback = () => {

  const userData = [
    {
      name: "Roe Smith",
      role: "Designer",
      text: "I must explain to you how all this mistaken . Tdea of denouncing pleasure and praising pain was born and I will give you a complete account of the system and expound",
    },
    {
      name: "Roe Smith",
      role: "Designer",
      text: "I must explain to you how all this mistaken . Tdea of denouncing pleasure and praising pain was born and I will give you a complete account of the system and expound",
    },
    {
      name: "Roe Smith",
      role: "Designer",
      text: "I must explain to you how all this mistaken . Tdea of denouncing pleasure and praising pain was born and I will give you a complete account of the system and expound",
    },
    {
      name: "Roe Smith",
      role: "Designer",
      text: "I must explain to you how all this mistaken . Tdea of denouncing pleasure and praising pain was born and I will give you a complete account of the system and expound",
    },
  ];

  return (
    <div className="max-w-7xl px-8 mx-auto">
      <div className="">
        <div className="">
          <h1 className="text-4xl font-bold text-black">Student feedbacks</h1>
          <p className="text-darkgrey font-normal">
            What Students Say About Academy LMS
          </p>
        </div>
        <div className="flex justify-center items-center mt-8">
          <div className="grid justify-center items-center place-items-center grid-cols-1 md:grid-cols-2 xl:grid-cols-4 gap-y-5 lg:gap-x-10 gap-x-4">
            {userData?.length &&
              userData?.map((data, index) => (
                <div
                  key={index}
                  className="flex flex-col justify-start gap-4 p-8 border border-whitegrey rounded-[30px] shadow min-w-[150px] sm:min-w-[200px] md:min-w-[250px] max-w-[300px]"
                >
                  <div className="flex justify-start items-start">
                    <Image src={comma} alt="" />
                  </div>
                  <div className="flex flex-col gap-2 justify-center w-[100%]">
                    <p className="text-black font-medium text-[18px]">
                      {data?.text}
                    </p>
                    <p className="text-black font-semibold text-[20px]">
                      {data?.name}
                    </p>
                    <p className="text-darkgrey font-normal text-[18px]">
                      {data?.role}
                    </p>
                  </div>
                </div>
              ))}
          </div>
        </div>
      </div>
      <div className="relative bg-gradient-to-r from-darkblue to-lightblue min-h-[180px] rounded-2xl p-4 sm:px-5 sm:py-4 md:py-0 mt-8 flex items-center lg:px-16">
        <Image src={bgimage2} className=" absolute top-0 right-0 z-0" alt="bgImage2" />
        <Image src={bgimage1} className="absolute bottom-0 left-0 z-0" alt="bgImage1" />

        <div className="flex flex-col md:flex-row items-center justify-between gap-4 h-full w-full">
          <div className="flex items-center gap-3">
            <Image src={student} alt="student" />
            <p className="text-[#D9D9D9] font-normal">
              Let’s Start With Agent Ambiant academy
            </p>
          </div>
          <div className="flex justify-center items-center h-full">
            <button className=" bg-golden text-white py-3 px-4 rounded-xl text-[18px] font-medium">
              Explorer course
            </button>
          </div>
        </div>
      </div>
    </div>
  );
};

export default StudentFeedback;