'use client';

import React, { useRef, useEffect } from "react";
import { Swiper, SwiperSlide } from "swiper/react";
import img from "../../../../../public/assets/homeNew/Images/user-img.png";
import 'swiper/swiper-bundle.css';
import "swiper/css/free-mode";
import { FreeMode, Navigation } from "swiper/modules";
import Image from "next/image";
import StarRating from "../../StarRating/StarRating";

const testimonials = [
  {
    id: 1,
    text: "“Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged.”",
    user: "Carter Springall",
    role: "Student",
    img: img,
    rating: 4,
  },
  {
    id: 2,
    text: "“Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged.”",
    user: "Emily Johnson",
    role: "Developer",
    img: img,
    rating: 5,
  },
  {
    id: 3,
    text: "“Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged.”",
    user: "Michael Brown",
    role: "Designer",
    img: img,
    rating: 3,
  },
  {
    id: 4,
    text: "“Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged.”",
    user: "Sophia Lee",
    role: "Marketing Manager",
    img: img,
    rating: 4,
  },
  {
    id: 5,
    text: "“Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged.”",
    user: "William Davis",
    role: "Product Manager",
    img: img,
    rating: 5,
  },
  {
    id: 6,
    text: "“Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged.”",
    user: "Olivia Wilson",
    role: "CEO",
    img: img,
    rating: 4,
  },
];

const TestimonialSlider = () => {
  const prevRef = useRef(null);
  const nextRef = useRef(null);
  const swiperRef = useRef(null);

  useEffect(() => {
    if (swiperRef.current && prevRef.current && nextRef.current) {
      swiperRef.current.navigation.update();
    }
  }, []);

  return (
    <div className="testimonial-slider-container">
      <div>
        <Swiper
          spaceBetween={30}
          freeMode={true}
          pagination={false}
          navigation={{
            prevEl: ".testimonial-prev",
            nextEl: ".testimonial-next",
            disabledClass: "swiper-button-disabled",
          }}
          onSwiper={(swiper) => {
            swiperRef.current = swiper;
          }}
          onInit={(swiper) => {
            if (prevRef.current && nextRef.current) {
              swiper.navigation.init();
              swiper.navigation.update();
            }
          }}
          modules={[FreeMode, Navigation]}
          breakpoints={{
            320: { slidesPerView: 1, spaceBetween: 20 },
            640: { slidesPerView: 2, spaceBetween: 20 },
            1024: { slidesPerView: 3, spaceBetween: 30 },
            1440: { slidesPerView: 4, spaceBetween: 30 },
          }}
          className="mySwiper testimonial-slider"
        >
          {testimonials.map((item) => (
            <SwiperSlide
              key={item.id}
              className="testimonial-card d-flex flex-column"
            >
              <span className="mb-24 d-inline-block">
                <svg
                  width="35"
                  height="32"
                  viewBox="0 0 35 32"
                  fill="none"
                  xmlns="http://www.w3.org/2000/svg"
                >
                  <path
                    opacity="0.5"
                    d="M12.8524 18.0466V31.9644H0V20.9766C0 15.0277 0.71032 10.7214 2.13096 8.0577C3.99555 4.50609 6.94782 1.8202 10.9878 0L13.9178 4.66148C11.4761 5.68256 9.67811 7.21419 8.52384 9.25636C7.36957 11.2541 6.72585 14.1842 6.59266 18.0466H12.8524ZM33.496 18.0466V31.9644H20.6437V20.9766C20.6437 15.0277 21.354 10.7214 22.7746 8.0577C24.6392 4.50609 27.5915 1.8202 31.6315 0L34.5615 4.66148C32.1198 5.68256 30.3218 7.21419 29.1675 9.25636C28.0133 11.2541 27.3695 14.1842 27.2363 18.0466H33.496Z"
                    fill="#D8A32B"
                  />
                </svg>
              </span>
              <p className="aa-text-md text-black mb-24">“{item.text}”</p>
              <div className="rating-star mb-24">
                <StarRating count={item.rating} />
              </div>
              <div className="testimonial-user-detail d-flex align-items-center">
                <Image
                  src={item.img}
                  alt={item.user}
                  placeholder="blur"
                  className="testimonial-user-img rounded-circle object-fit-cover me-20"
                />
                <div>
                  <h3 className="aa-heading-06 fw-bold mb-8">{item.user}</h3>
                  <p className="text-theme aa-text-base mb-0">{item.role}</p>
                </div>
              </div>
            </SwiperSlide>
          ))}
        </Swiper>
      </div>

      {/* Custom Navigation Buttons */}
      <div className="testimonial-buttons d-flex justify-content-center">
        <div
          ref={prevRef}
          className="swiper-button-prev testimonial-prev custom-nav-btn d-flex justify-content-center align-items-center"
        >
          <svg
            width="7"
            height="10"
            viewBox="0 0 7 10"
            fill="none"
            xmlns="http://www.w3.org/2000/svg"
          >
            <path
              d="M0.875 4.8208C0.765625 4.93018 0.683594 5.09424 0.683594 5.28564C0.683594 5.44971 0.765625 5.61377 0.875 5.75049L4.59375 9.46924C4.73047 9.57861 4.89453 9.66064 5.05859 9.66064C5.25 9.66064 5.41406 9.57861 5.52344 9.46924L6.125 8.84033C6.26172 8.70361 6.31641 8.53955 6.31641 8.37549C6.31641 8.18408 6.26172 8.02002 6.125 7.91064L3.5 5.28564L6.125 2.66064C6.26172 2.52393 6.31641 2.35986 6.31641 2.1958C6.31641 2.00439 6.26172 1.84033 6.125 1.73096L5.52344 1.10205C5.41406 0.965332 5.25 0.910645 5.05859 0.910645C4.89453 0.910645 4.73047 0.965332 4.59375 1.10205L0.875 4.8208Z"
              fill="#D8A32B"
            />
          </svg>
        </div>
        <div
          ref={nextRef}
          className="swiper-button-next testimonial-next custom-nav-btn d-flex justify-content-center align-items-center"
        >
          <svg
            width="7"
            height="10"
            viewBox="0 0 7 10"
            fill="none"
            xmlns="http://www.w3.org/2000/svg"
          >
            <path
              d="M6.125 5.1792C6.23438 5.06982 6.31641 4.90576 6.31641 4.71436C6.31641 4.55029 6.23438 4.38623 6.125 4.24951L2.40625 0.530762C2.26953 0.421387 2.10547 0.339355 1.94141 0.339355C1.75 0.339355 1.58594 0.421387 1.47656 0.530762L0.875 1.15967C0.738281 1.29639 0.683594 1.46045 0.683594 1.62451C0.683594 1.81592 0.738281 1.97998 0.875 2.08936L3.5 4.71436L0.875 7.33936C0.738281 7.47607 0.683594 7.64014 0.683594 7.8042C0.683594 7.99561 0.738281 8.15967 0.875 8.26904L1.47656 8.89795C1.58594 9.03467 1.75 9.08936 1.94141 9.08936C2.10547 9.08936 2.26953 9.03467 2.40625 8.89795L6.125 5.1792Z"
              fill="#D8A32B"
            />
          </svg>
        </div>
      </div>
    </div>
  );
};

export default TestimonialSlider;
