import React, { useRef, useEffect } from "react";
import { Swiper, SwiperSlide } from "swiper/react";
import 'swiper/swiper-bundle.css';
import "swiper/css/free-mode";
import { FreeMode, Navigation } from "swiper/modules";
import BlogImg from "../../../../../public/assets/homeNew/Images/blog-img.jpg";
import CustomButton from "../../CustomButton/CustomBUtton";
import Image from "next/image";

const truncateText = (text, maxWords) => {
  const words = text.split(" ");
  if (words.length > maxWords) {
    return words.slice(0, maxWords).join(" ") + "...";
  }
  return text;
};

const BlogSlider = () => {
  const prevRef = useRef(null);
  const nextRef = useRef(null);
  const swiperRef = useRef(null);

  useEffect(() => {
    // Ensure navigation is updated after refs are set
    if (swiperRef.current && prevRef.current && nextRef.current) {
      swiperRef.current.navigation.update();
    }
  }, []);

  const maxWords = 6;

  // Array of objects for blog card content
  const blogData = [
    {
      id: 1,
      title: "Title of Blog One or Something",
      description:
        "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard.",
      image: BlogImg,
    },
    {
      id: 2,
      title: "Title of Blog Two or Else",
      description:
        "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard.",
      image: BlogImg,
    },
    {
      id: 3,
      title: "Title of Blog Three or More",
      description:
        "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard.",
      image: BlogImg,
    },
    {
      id: 4,
      title: "Title of Blog Three or More",
      description:
        "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard.",
      image: BlogImg,
    },
    {
      id: 5,
      title: "Title of Blog Three or More",
      description:
        "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard.",
      image: BlogImg,
    },
  ];

  return (
    <div className="blog-slider-container position-relative">
      <div className="row">
        <div className="col-12 col-lg-6">
          <span className="text-theme aa-text-md fw-semibold d-inline-block mb-11" data-aos="fade-up" data-aos-delay="200">
            Our <span className="bg-theme badge">Blogs</span>
          </span>
          <h1 className="aa-heading-02 fw-bold text-black-200" data-aos="fade-right" data-aos-delay="400">
            Agent Ambition Academy Blogs
          </h1>
        </div>
        <div className="col-lg-6">
          <div className="position-absolute blog-buttons ">
            <div
              ref={prevRef}
              className="swiper-button-prev blog-prev custom-nav-btn-for-blog"
            >
              <svg
                width="7"
                height="10"
                viewBox="0 0 7 10"
                fill="none"
                xmlns="http://www.w3.org/2000/svg"
              >
                <path
                  d="M0.875 4.8208C0.765625 4.93018 0.683594 5.09424 0.683594 5.28564C0.683594 5.44971 0.765625 5.61377 0.875 5.75049L4.59375 9.46924C4.73047 9.57861 4.89453 9.66064 5.05859 9.66064C5.25 9.66064 5.41406 9.57861 5.52344 9.46924L6.125 8.84033C6.26172 8.70361 6.31641 8.53955 6.31641 8.37549C6.31641 8.18408 6.26172 8.02002 6.125 7.91064L3.5 5.28564L6.125 2.66064C6.26172 2.52393 6.31641 2.35986 6.31641 2.1958C6.31641 2.00439 6.26172 1.84033 6.125 1.73096L5.52344 1.10205C5.41406 0.965332 5.25 0.910645 5.05859 0.910645C4.89453 0.910645 4.73047 0.965332 4.59375 1.10205L0.875 4.8208Z"
                  fill="#000"
                />
              </svg>
            </div>
            <div
              ref={nextRef}
              className="swiper-button-next blog-next custom-nav-btn-for-blog"
            >
              <svg
                width="7"
                height="10"
                viewBox="0 0 7 10"
                fill="none"
                xmlns="http://www.w3.org/2000/svg"
              >
                <path
                  d="M6.125 5.1792C6.23438 5.06982 6.31641 4.90576 6.31641 4.71436C6.31641 4.55029 6.23438 4.38623 6.125 4.24951L2.40625 0.530762C2.26953 0.421387 2.10547 0.339355 1.94141 0.339355C1.75 0.339355 1.58594 0.421387 1.47656 0.530762L0.875 1.15967C0.738281 1.29639 0.683594 1.46045 0.683594 1.62451C0.683594 1.81592 0.738281 1.97998 0.875 2.08936L3.5 4.71436L0.875 7.33936C0.738281 7.47607 0.683594 7.64014 0.683594 7.8042C0.683594 7.99561 0.738281 8.15967 0.875 8.26904L1.47656 8.89795C1.58594 9.03467 1.75 9.08936 1.94141 9.08936C2.10547 9.08936 2.26953 9.03467 2.40625 8.89795L6.125 5.1792Z"
                  fill="#000"
                />
              </svg>
            </div>
          </div>
        </div>
      </div>
      <Swiper
        spaceBetween={30}
        freeMode={true}
        pagination={false}
        navigation={{
          prevEl: ".blog-prev",
          nextEl: ".blog-next",
          disabledClass: "swiper-button-disabled",
        }}
        onSwiper={(swiper) => {
          swiperRef.current = swiper;
        }}
        modules={[FreeMode, Navigation]}
        breakpoints={{
          320: { slidesPerView: 1, spaceBetween: 20 },
          640: { slidesPerView: 2, spaceBetween: 20 },
          1024: { slidesPerView: 3, spaceBetween: 30 },
        }}
        className="mySwiper "
      >
        {blogData.map((blog) => (
          <SwiperSlide key={blog.id}>
            <div className="blog-card p-10 p-sm-15 p-lg-23 my-10">
              <Image src={blog.image} alt="Blog" className="blog-img mb-7" placeholder="blur"/>
              <h3 className="aa-heading-05 fw-bold">
                {truncateText(blog.title, maxWords)}
              </h3>
              <p className="aa-text-md fw-medium mb-32">{blog.description}</p>
              <CustomButton classes="btn btn-soft-primary" label="Learn more" />
            </div>
          </SwiperSlide>
        ))}
      </Swiper>
    </div>
  );
};

export default BlogSlider;
