"use client";

import React from "react";
import Image from "next/image";
import AboutUsImg from "../../../../../public/assets/homeNew/Images/about-us-img.jpg";  // Image from public folder
import CustomButton from "../../CustomButton/CustomBUtton";
import "../../../../../public/assets/styles/spacers.css"

const AboutUs = () => {
  return (
    <div className="container custom-container w-100 overflow-hidden">
      <div className="d-flex about-us-container align-items-center flex-column flex-md-row mx-auto">
        <div data-aos="fade-right">
          <Image
            src={AboutUsImg}
            alt="About Us Image"
            className="section-image"
            placeholder="blur"
          />
        </div>
        <div className="content-section">
          <span className="about-badge text-theme aa-text-md fw-semibold mb-10 mb-sm-13 mb-md-18 mb-lg-24 d-inline-block" data-aos="fade-top">
            <span className="badge bg-theme text-white">About</span> Us
          </span>
          <h1 className="aa-heading-02 fw-bold mb-10 mb-sm-13 mb-md-18 mb-lg-24" data-aos="fade-left" data-aos-delay="500">
            Grow your skills with Agent Ambition Academy
          </h1>
          <p className="description aa-text-sm text-gray fw-medium mb-10 mb-sm-20 mb-md-30 mb-lg-40" data-aos="fade-left" data-aos-delay="800">
            We denounce with righteous indignation and dislike men who are so
            beguiled and demoralized that they cannot trouble.
          </p>
          {/* Certificate Sections */}
          <div className="d-flex gap-2 mb-10 mb-sm-15 mb-md-24 mb-lg-32" data-aos="fade-left" data-aos-delay="1200">
            <span className="certificate-icon">
              {/* SVG Icon */}
              {/* Copy SVG as is */}
            </span>
            <div>
              <h4 className="aa-heading-04 fw-bold mb-8">Certificate</h4>
              <p className="aa-text-sm text-gray fw-medium mb-0">
                Have all your clients under one roof and shift between client
                profiles with just one click.
              </p>
            </div>
          </div>
          <div className="d-flex gap-2 mb-10 mb-sm-20 mb-md-30 mb-lg-40" data-aos="fade-left" data-aos-delay="1400">
            <span className="certificate-icon">
              {/* SVG Icon */}
              {/* Copy SVG as is */}
            </span>
            <div>
              <h4 className="aa-heading-04 fw-bold mb-8">Certificate</h4>
              <p className="aa-text-sm text-gray fw-medium mb-0">
                Ready to send more volume? Just add an inbox (or five) to your
                existing campaign and we'll start sending.
              </p>
            </div>
          </div>
          <CustomButton
            classes="btn btn-primary"
            label="Explore More"
            type="button"
          />
        </div>
      </div>
    </div>
  );
};

export default AboutUs;
