import React from "react";
import Image from "next/image";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faCalendar } from "@fortawesome/free-solid-svg-icons";
import image1 from "../../../../public/assets/home/featureVideos/image1.jpg";
import image2 from "../../../../public/assets/home/featureVideos/image2.jpg";
import image3 from "../../../../public/assets/home/featureVideos/image3.png";

const LatestArticles = () => {

  const data = [
    {
      img: image1,
      text: "Looking for an amazing & informative videos...",
      title: "Bespoke – Add Storytelling to Your Real Estate Videos",
      date: "Jan 24, 2024",
    },
    {
      img: image2,
      text: "Looking for an amazing & informative videos...",
      title: "Brandon Bames – Make It Unique",
      date: "Jan 24, 2024",
    },
    {
      img: image3,
      text: "Looking for an amazing & informative videos...",
      title: "The Corcoran Group – Focus on the Main Attractions",
      date: "Jan 24, 2024",
    },
  ];

  return (
    <div className="max-w-7xl px-8 py-8 mx-auto">
      <div className="flex justify-between flex-col gap-4 sm:gap-0 sm:flex-row py-6">
        <div>
          <h1 className="font-bold text-3xl">Latest articles</h1>
          <p className="text-darkgrey font-normal text-[18px]">
            Explore our Free Acticles
          </p>
        </div>
        <div>
          <button className="text-[18px] font-medium border-2 border-grey p-3 rounded-full">
            All Articles
          </button>
        </div>
      </div>
      <div className="flex justify-center items-center">
        <div className="grid justify-center grid-cols-1 md:grid-cols-2 xl:grid-cols-3 gap-y-5 lg:gap-x-6 md:gap-x-4">
          {data?.length &&
            data?.map((data, index) => (
              <div
                key={index}
                className="group transform transition-transform hover:-translate-y-6 hover:shadow-2xl hover:scale-105 max-w-sm bg-white border border-gray-200 rounded-[30px] shadow"
              >
                <div>
                  <Image
                    className="rounded-t-[30px] object-cover"
                    src={data?.img}
                    alt="image"
                    layout="responsive"
                    width={500}
                    height={200}
                  />
                </div>
                <div>
                  <div className="p-5">
                    <h5 className="mb-2 text-2xl font-bold tracking-tight text-gray-900 group-hover:text-golden">
                      {data?.title}
                    </h5>
                    <div className="flex gap-1 py-2 items-center">
                      <FontAwesomeIcon
                        icon={faCalendar}
                        className="text-[#B9802A]"
                      />

                      <span className="font-normal">{data?.date}</span>
                    </div>
                    <p className="mb-3 font-normal text-gray-700 dark:text-gray-400">
                      {data?.text}
                    </p>
                  </div>
                </div>
              </div>
            ))}
        </div>
      </div>
    </div>
  );
};

export default LatestArticles;