"use client";
import Image from "next/image";
import React, { useState } from "react";
import bgimg from "../../../../public/assets/login/bgimg.png";
import image from "../../../../public/assets//foget-password/image.png";
import Link from "next/link";
import { PostLoginAndSignup } from "../axiosConfig/axiosConfig";
import { useFormik } from "formik";
import * as Yup from "yup";
import toast from "react-hot-toast";

const ForgetPassword = () => {

  const [loading, setLoading] = useState(false);
  const [success, setSuccess] = useState("");
  const [error, setError] = useState("");

  const formik = useFormik({
    initialValues: {
      email: "",
    },

    validationSchema: Yup.object({
      email: Yup.string()
        .email("Invalid email address")
        .required("Email is required"),
    }),

    onSubmit: async (values, { setSubmitting }) => {
      try {
        const res = await PostLoginAndSignup("/forgot-password", values);

        if (res) {
          setSuccess("Forgot Password Email Sent Successfully!");
          setError("");
          setLoading(false);
        }

        toast.success("Forgot Password Email Send Successful!", {
          position: "top-center",
        });
      } catch (error) {
        const errorMessage =
          error.response?.data?.message || error.message || "An error occurred";

        console.error("Login error:", errorMessage);
        toast.error("Unable to send password reset link", {
          position: "top-center",
        });
        setError(errorMessage);
      } finally {
        setSubmitting(false);
        setLoading(false);
      }
    },
  });

  return (
    <div className="w-full max-h-[900px] flex justify-between relative">
      <div className="absolute z-10  h-full lg:left-[20%] md:left-[10%] sm:left-[25%] left-[15%] sm:min-w-[383px] w-[300px]">
        {success ? (
          <div className="flex flex-col gap-2 mt-8 md:mt-4 lg:mt-12 min-h-screen">
            <div className="flex flex-col justify-center min-h-screen">
              <p className="">{success}</p>
              <Link
                href="gmail.com"
                target="_blank"
                className="text-golden underline"
              >
                Click here to Check Email
              </Link>
            </div>
          </div>
        ) : (
          <div className={`flex flex-col justify-around h-full w-full`}>
            <Image
              src="/assets/navbar/logo1.svg"
              alt="logo"
              className="ml-20 w-40 h-40 lg:w-52 lg:h-40 mb-6 md:mb-4"
              width={100}
              height={100}
            />
            <form
              className="flex flex-col md:gap-4 gap-4"
              onSubmit={formik.handleSubmit}
            >
              <div className="flex flex-col md:gap-4 gap-3 md:bg-transparent bg-whitegrey p-5 rounded-2xl">
                <div className="flex flex-col gap-3">
                  <h1 className="text-black text-3xl font-bold">
                    Forgot Password
                  </h1>
                  <p className="text-[#828282] font-normal">
                    Enter your email for the verification proccess,we will send
                    you a forget password email.
                  </p>
                </div>
                <div className="flex flex-col gap-2">
                  <label>Email:</label>
                  <input
                    type="email"
                    className={`outline-none py-2 px-3 border rounded-xl ${
                      formik.touched.email && formik.errors.email
                        ? "border-red-500"
                        : "border-grey"
                    }`}
                    placeholder="Enter your email address"
                    name="email"
                    value={formik.values.email}
                    onChange={formik.handleChange}
                    onBlur={formik.handleBlur}
                  />
                  {formik.touched.email && formik.errors.email ? (
                    <div className="text-red-500">{formik.errors.email}</div>
                  ) : null}
                </div>
                {error && (
                  <div className="text-red-500 text-sm mt-2">{error}</div>
                )}
                <button
                  onClick={() => {
                    setLoading(true);
                  }}
                  type="submit"
                  className="bg-golden mt-10 text-white py-2 px-3 rounded-xl"
                >
                  {loading ? "Loading..." : "Submit"}
                </button>
              </div>
            </form>
            <div className="flex flex-col gap-2 mt-8 md:mt-4 lg:mt-12">
              <div className="flex flex-col text-center">
                Already have an account?
                <Link href="/login" className="text-golden underline">
                  Login
                </Link>
              </div>
            </div>
          </div>
        )}
      </div>
      <div></div>
      <div className="min-h-screen relative flex justify-end w-full md:w-2/3 lg:w-1/2">
        <Image src={bgimg} alt="bgimg" className="z-0 w-full min-h-full" />
        <div className="absolute hidden md:flex justify-center items-center h-full w-full">
          <Image
            src={image}
            alt="bgimg"
            className="lg:min-h-[360px] min-h-[300px] xl:max-w-[500px] lg:max-w-[300px] md:max-w-[300px]"
          />
        </div>
      </div>
    </div>
  );
};

export default ForgetPassword;