"use client";
import React from "react";
import Image from "next/image";
import Link from "next/link";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import {
  faFacebookF,
  faPinterestP,
  faTwitter,
  faInstagram,
  faYoutube,
} from "@fortawesome/free-brands-svg-icons";

const Footer = () => {

  const currentDate = new Date();
  const currentYear = currentDate.getFullYear();

  return (
    <div className="bg-[#EFF4FF] min-h-[450px] relative">
      <div className="max-w-7xl min-h-[450px] px-8 mx-auto flex flex-col justify-between">
        <div className="flex justify-center gap-8 pt-16">
          <div className="max-w-[410px]">
            <Image
              src="/assets/navbar/logo1.svg"
              alt="footer-logo"
              className="h-[96px] w-[117px]"
              height={96}
              width={117}
            />
            <p className="mt-10 max-w-[310px]">
              Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do
              eiusmod tempor incididunt ut labore et dolore magna aliqua.
            </p>
            <div className="mt-5 lg:hidden flex gap-2">
              <FontAwesomeIcon
                icon={faFacebookF}
                className="text-darkgrey"
                size="lg"
              />
              <FontAwesomeIcon
                icon={faPinterestP}
                className="text-golden"
                size="lg"
              />
              <FontAwesomeIcon
                icon={faTwitter}
                className="text-darkgrey"
                size="lg"
              />
              1
              <FontAwesomeIcon
                icon={faInstagram}
                className="text-darkgrey"
                size="lg"
              />
              <FontAwesomeIcon
                icon={faYoutube}
                className="text-darkgrey"
                size="lg"
              />
            </div>
          </div>
          <div className="w-full justify-between gap-4 hidden lg:flex">
            <div className="flex flex-col gap-5">
              <p className="text-black font-bold text-[20px]">GET HELP</p>
              <Link
                className="text-darkgrey font-medium text-[18px]"
                href="/contact-us"
              >
                Contact Us
              </Link>
              <Link className="text-darkgrey font-medium text-[18px]" href="">
                Latest Articles
              </Link>
              <Link
                href="/faq"
                className="text-darkgrey font-medium text-[18px]"
              >
                FAQ
              </Link>
            </div>
            <div className="flex flex-col gap-5">
              <p className="text-black font-bold text-[20px]">CATEGORIES</p>
              <Link className="text-darkgrey font-medium text-[18px]" href="">
                Property Listings
              </Link>
              <Link className="text-darkgrey font-medium text-[18px]" href="">
                Realtor Promotions
              </Link>
              <Link className="text-darkgrey font-medium text-[18px]" href="">
                Sales
              </Link>
              <Link className="text-darkgrey font-medium text-[18px]" href="">
                Videography
              </Link>
              <Link className="text-darkgrey font-medium text-[18px]" href="">
                Photography
              </Link>
            </div>
            <div className="flex flex-col gap-5">
              <p className="text-black font-bold text-[20px]">CONTACT US</p>
              <p className="text-darkgrey font-medium text-[18px]">
                Address: 2321 New Design Str, Lorem Ipsum10 Hudson Yards, USA
              </p>
              <p className="text-darkgrey font-medium text-[18px]">
                Tel: + (1) 2345-567-8910
              </p>
              <span className="text-darkgrey font-medium text-[18px]">
                Mail: <a href="mailto:mailto:support@agentambitionacademy.com"> support@agentambitionacademy.com</a>
              </span>
              <div className="flex gap-2">
                <FontAwesomeIcon
                  icon={faFacebookF}
                  className="text-darkgrey"
                  size="lg"
                />
                <FontAwesomeIcon
                  icon={faPinterestP}
                  className="text-golden"
                  size="lg"
                />
                <FontAwesomeIcon
                  icon={faTwitter}
                  className="text-darkgrey"
                  size="lg"
                />
                <FontAwesomeIcon
                  icon={faInstagram}
                  className="text-darkgrey"
                  size="lg"
                />
                <FontAwesomeIcon
                  icon={faYoutube}
                  className="text-darkgrey"
                  size="lg"
                />
              </div>
            </div>
          </div>
        </div>
        <div className="flex justify-center items-center border-t border-[#EAEAEA]">
          <span className="my-4">Copyright © {currentYear} Agent Ambition Academy</span>
        </div>
      </div>
    </div>
  );
};

export default Footer;