import React, { useEffect } from "react";
import { upComingVideo as upComingVideoSlice } from "@/newStore/features/upComingVideoSlice";
import { useSelector, useDispatch } from "react-redux";
import LoaderCircle from "../../loaderCircle/loaderCircle";
import Image from "next/image";
import Link from "next/link";
import image1 from "../../../../../public/assets/dashboard/video.png";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faClock } from "@fortawesome/free-regular-svg-icons";

const UpComingVideos = () => {
  const dispatch = useDispatch();
  const upComingVideo = useSelector(
    (state) => state.upComingVideo.upComingVideo
  );

  useEffect(() => {
    dispatch(upComingVideoSlice());
  }, [dispatch]);

  return (
    <>
      {upComingVideo?.data?.length > 0 && (
        <div className="bg-[#FFFFFF] rounded-2xl w-full max-h-full p-6 transition-all duration-300 hover:shadow-[0px_6px_17px_rgba(0,0,0,0.3)]">
          <h1 className="text-[20px] font-bold mb-4">Upcoming Videos</h1>
          <div className="overflow-y-auto pr-2 h-[280px] customScrollbar">
            <table className="min-w-full">
              <tbody>
                {upComingVideo?.data?.map((course, index) => (
                    <tr
                      key={index}
                      className={`border-b ${
                        index === upComingVideo?.upcoming_videos?.length - 1
                          ? ""
                          : "border-[#c7c7c7]"
                      } hover:bg-[#eee] transition-colors duration-200`}
                    >
                      <td className="p-2 w-20">
                        {course?.thumbnail_url === "" ? 
                        <Image
                          src={image1}
                          alt="video"
                          className="rounded-full h-[60px] w-[60px] object-cover"
                        /> : 
                        <img src={course?.thumbnail_url} alt="video" className="rounded-full h-[60px] w-[60px] object-cover"  />}
                      </td>
                      <td className="p-2">
                        <h1 className="text-[16px] font-bold">
                          <Link href={`/courses/${course?.id}`}>
                            {" "}
                            {course?.title}
                          </Link>
                        </h1>
                        {/* <p className="text-[12px] font-normal">
                      <FontAwesomeIcon
                        icon={faClock}
                        className="text-[#B9802A] text-[14px] mr-1"
                      />
                      Upcoming
                    </p> */}
                      </td>
                    </tr>
                  ))}
              </tbody>
            </table>
          </div>
        </div>
      )}
    </>
  );
};

export default UpComingVideos;
