import React, { useEffect } from "react";
import { topVideos as topVideosSlice } from "@/newStore/features/topVideosSlice";
import { useSelector, useDispatch } from "react-redux";
import LoaderCircle from "../../loaderCircle/loaderCircle";
import Image from "next/image";
import image1 from "../../../../../public/assets/dashboard/video.png";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faClock } from "@fortawesome/free-regular-svg-icons";
import { faEye } from "@fortawesome/free-solid-svg-icons";
import Link from "next/link";

const TopVideos = () => {
  const dispatch = useDispatch();
  const topVideos = useSelector((state) => state.topVideos.topVideos);

  useEffect(() => {
    dispatch(topVideosSlice());
  }, [dispatch]);

  function secondsToReadableTime(seconds) {
    const hours = Math.floor(seconds / 3600);
    const minutes = Math.floor((seconds % 3600) / 60);
    const remainingSeconds = seconds % 60;

    let result = "";

    if (hours > 0) {
      result += `${hours} hour${hours > 1 ? "s" : ""}`;
    }
    if (minutes > 0) {
      if (result) result += " ";
      result += `${minutes} minute${minutes > 1 ? "s" : ""}`;
    }
    if (remainingSeconds > 0) {
      if (result) result += " and ";
      result += `${remainingSeconds} second${remainingSeconds > 1 ? "s" : ""}`;
    }

    return result || "0 seconds"; // If the input seconds are 0
  }

  return (
    <>
      {topVideos?.top_videos?.length > 0 && (
        <div className="bg-[#FFFFFF] rounded-2xl w-full max-h-full p-6 transition-all duration-300 hover:shadow-[0px_6px_17px_rgba(0,0,0,0.3)]">
          <h1 className="text-[20px] font-bold mb-4">Top Videos</h1>
          <div className="overflow-y-auto pr-2 h-[280px] customScrollbar">
            <table className="min-w-full">
              <tbody>
                {topVideos?.top_videos?.map((video, index) => (
                  <tr
                    key={video?.id}
                    className={`border-b ${
                      index === topVideos?.top_videos?.length - 1
                        ? ""
                        : "border-[#c7c7c7]"
                    } hover:bg-[#eee] transition-colors duration-200`}
                  >
                    <td className="p-2 w-20">
                      <Link href={`/courses/${video?.course_id}`}>
                      {video?.thumbnail_url === "" ? 
                        <Image
                          src={image1}
                          alt="video"
                          className="rounded-full h-[60px] w-[60px] object-cover"
                        /> : 
                        <img src={video?.thumbnail_url} alt="video" className="rounded-full h-[60px] w-[60px] object-cover"  />}
                      </Link>
                    </td>
                    <td className="p-2">
                      <h1 className="text-[16px] font-bold">
                        <Link href={`/courses/${video?.course_id}`}>
                          {video?.title}
                        </Link>
                      </h1>
                      <p className="text-[12px] font-normal">
                        <FontAwesomeIcon
                          icon={faClock}
                          className="text-[#B9802A] text-[14px] mr-1"
                        />
                        {secondsToReadableTime(video?.duration)}
                      </p>
                    </td>
                    <td className="p-2 text-right">
                      <div className="flex items-center justify-end">
                        <FontAwesomeIcon
                          icon={faEye}
                          className="text-[#B9802A] text-[14px] mr-1"
                        />
                        <p className="text-[12px] font-semibold font-normal">
                          {video?.views}
                        </p>
                      </div>
                    </td>
                  </tr>
                ))}
              </tbody>
            </table>
          </div>
        </div>
      )}
    </>
  );
};

export default TopVideos;
