"use client";
import React, { useEffect, useState } from "react";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import {
  faPen,
  faCirclePlus,
  faTrash,
  faPlus,
} from "@fortawesome/free-solid-svg-icons";
import { DeleteRequest, PostRequest } from "../../axiosConfig/axiosConfig";
import Link from "next/link";
import toast from "react-hot-toast";
import ExperienceModal from "./ExperienceModal";
import EducationModal from "./EducationModal";
import Header from "../header/header";
import {
  useGetEducationQuery,
  useGetExperienceQuery,
  useGetUserDetailQuery,
} from "@/services/Api";
import Image from "next/image";
import ProfileImage from "../../../../../public/assets/dashboard/profile.png";
import LoaderCircle from "../../loaderCircle/loaderCircle";

const Profile = () => {
  const [allEducation, setAllEducation] = useState([]);
  const [allExperience, setAllExperience] = useState([]);
  const [userDetails, setUserDetails] = useState(null);
  const [isExperienceModalOpen, setIsExperienceModalOpen] = useState(false);
  const [selectedExperience, setSelectedExperience] = useState(null);
  const [isEducationModalOpen, setIsEducationModalOpen] = useState(false);
  const [selectedEducation, setSelectedEducation] = useState(null);

  const { data: getUserDetail, refetch: getUserDetailRefetch } =
    useGetUserDetailQuery();

  const { data: getExperience, refetch: getExperienceRefetch } =
    useGetExperienceQuery();

  const { data: getEducation, refetch: getEducationRefetch } =
    useGetEducationQuery();

  useEffect(() => {
    setUserDetails(getUserDetail?.user);
    setAllExperience(getExperience?.experiance);
    setAllEducation(getEducation?.education);
  }, [getExperience, getUserDetail, getEducation]);

  useEffect(() => {
    getUserDetailRefetch();
    getExperienceRefetch();
    getEducationRefetch();
  }, []);

  const handleDeleteExperience = async (id) => {
    const confirmDelete = window.confirm(
      "Are you sure you want to delete this experience?"
    );

    if (confirmDelete) {
      const authToken = localStorage.getItem("authToken");
      try {
        const res = await DeleteRequest(`/experiance/${id}`, authToken);

        toast.success("Experience deleted successfully!", {
          position: "top-center",
        });

        getExperienceRefetch();
      } catch (error) {
        console.error("Failed to delete experience:", error);
        toast.error("Failed to delete experience", {
          position: "top-center",
        });
      }
    }
  };

  const handleDeleteEducation = async (id) => {
    const confirmDelete = window.confirm(
      "Are you sure you want to delete this Education?"
    );

    if (confirmDelete) {
      const authToken = localStorage.getItem("authToken");
      try {
        const res = await DeleteRequest(`/education/${id}`, authToken);

        toast.success("Education deleted successfully!", {
          position: "top-center",
        });

        getEducationRefetch();
      } catch (error) {
        toast.error("Failed to delete Education", {
          position: "top-center",
        });
      }
    }
  };

  const handleEditExperience = (experience) => {
    setSelectedExperience(experience);
    setIsExperienceModalOpen(true);
  };

  const handleExperienceModalSubmit = async (updatedExperience) => {
    const authToken = localStorage.getItem("authToken");
    try {
      await PostRequest(
        `/experiance/${selectedExperience.id}`,
        updatedExperience,
        authToken
      );
      toast.success("Experience updated successfully!", {
        position: "top-center",
      });
      getExperienceRefetch();
      setIsExperienceModalOpen(false);
    } catch (error) {
      toast.error("Failed to update Experience.", { position: "top-center" });
    } finally {
    }
  };

  const handleEditEducation = (education) => {
    setSelectedEducation(education);
    setIsEducationModalOpen(true);
  };

  const handleEducationModalSubmit = async (updatedEducation) => {
    const authToken = localStorage.getItem("authToken");
    try {
      await PostRequest(
        `/education/${selectedEducation.id}`,
        updatedEducation,
        authToken
      );
      toast.success("Education updated successfully!", {
        position: "top-center",
      });
      getEducationRefetch();
      setIsEducationModalOpen(false);
    } catch (error) {
      toast.error("Failed to update Education.", { position: "top-center" });
    } finally {
    }
  };

  return (
    <div className="md:px-10 px-6 min-h-screen">
      <Header title="Profile" />
      <div className="bg-white my-6 rounded-2xl p-4 flex flex-col gap-8 lg:p-10">
        {userDetails && userDetails?.user !== null ? (
          <>
            <div>
              <h1 className="text-2xl font-bold leading-normal">
                Personal Information
              </h1>
              <div className="mt-6 mt-md-10 mt-xl-14 xl:flex md:flex-row flex-col gap-14 items-top xl:px-10">
                <div className="pb-4 xl:pt-5">
                  {/* {userDetails && userDetails?.media[0]?.original_url ? ( */}
                  <div className="w-[110px] h-[110px] xl:h-36 xl:w-36">
                    {userDetails?.media.length > 0 ? (
                      <img
                        src={userDetails?.media?.[0]?.original_url}
                        alt="profile"
                        width={100}
                        height={100}
                        className="bg-gray-500 rounded-full h-full w-full"
                      />
                    ) : (
                      <Image
                        src={ProfileImage}
                        alt="profile"
                        width={100}
                        height={100}
                        className="bg-gray-500 rounded-full h-full w-full"
                      />
                    )}
                    {/* <img
                      src={
                        userDetails?.media.length > 0
                          ? userDetails?.media?.[0]?.original_url
                          : ProfileImage
                      }
                      alt=" "
                      className="bg-gray-500 rounded-full h-full w-full"
                    /> */}
                  </div>
                  {/* ) : (
                    <div className="rounded-full h-36 w-36 bg-golden text-white text-5xl font-bold flex items-center justify-center">
                      {userDetails && userDetails?.email ? (
                        userDetails?.email.charAt(0).toUpperCase()
                      ) : (
                        <div className="text-xl">No Image</div>
                      )}
                    </div>
                  )} */}
                </div>
                <div className=" w-full flex flex-col gap-4">
                  <div className="flex flex-col gap-3">
                    <div className="flex flex-wrap gap-y-6 justify-between">
                      <div className="w-full  sm:w-1/2 md:w-1/3 xl:w-1/4">
                        <p className="text-base font-bold">First Name:</p>
                        <p className="text-base text-[#0000005C] font-medium break-all">
                          {userDetails && userDetails?.user_detail?.firstname
                            ? userDetails?.user_detail?.firstname
                            : "null"}
                        </p>
                      </div>
                      <div className="w-full  sm:w-1/2 md:w-1/3 xl:w-1/4">
                        <p className="text-base font-bold">Last Name:</p>
                        <p className="text-base text-[#0000005C] font-medium break-all">
                          {userDetails && userDetails?.user_detail?.lastname
                            ? userDetails?.user_detail?.lastname
                            : "null"}
                        </p>
                      </div>
                      <div className="w-full  sm:w-1/2 md:w-1/3 xl:w-1/4">
                        <p className="text-base font-bold"> User Name:</p>
                        <p className="text-base text-[#0000005C] font-medium break-all">
                          {userDetails && userDetails?.name
                            ? userDetails?.name
                            : "null"}
                        </p>
                      </div>
                      <div className="w-full  sm:w-1/2 md:w-1/3 xl:w-1/4">
                        <p className="text-base font-bold">Email Address:</p>
                        <p className="text-base text-[#0000005C] font-medium break-all">
                          {userDetails && userDetails?.email
                            ? userDetails?.email
                            : "null"}
                        </p>
                      </div>
                      <div className="w-full  sm:w-1/2 md:w-1/3 xl:w-1/4">
                        <p className="text-base font-bold">Address:</p>
                        <p className="text-base text-[#0000005C] font-medium break-all">
                          {userDetails && userDetails?.user_detail?.address
                            ? userDetails?.user_detail?.address
                            : "null"}
                        </p>
                      </div>
                      <div className="w-full  sm:w-1/2 md:w-1/3 xl:w-1/4">
                        <p className="text-base font-bold">City:</p>
                        <p className="text-base text-[#0000005C] font-medium break-all">
                          {userDetails && userDetails?.user_detail?.city
                            ? userDetails?.user_detail?.city
                            : "null"}
                        </p>
                      </div>
                      <div className="w-full  sm:w-1/2 md:w-1/3 xl:w-1/4">
                        <p className="text-base font-bold">Country:</p>
                        <p className="text-base text-[#0000005C] font-medium break-all">
                          {userDetails && userDetails?.user_detail?.country
                            ? userDetails?.user_detail?.country
                            : "null"}
                        </p>
                      </div>
                      <div className="w-full  sm:w-1/2 md:w-1/3 xl:w-1/4">
                        <p className="text-base font-bold">Phone Number:</p>
                        <p className="text-base text-[#0000005C] font-medium break-all">
                          {userDetails && userDetails?.user_detail?.phoneno
                            ? userDetails?.user_detail?.phoneno
                            : "null"}
                        </p>
                      </div>
                      <div className="w-full  sm:w-1/2 md:w-1/3 xl:w-1/4">
                        <p className="text-base font-bold">Postal Code:</p>
                        <p className="text-base text-[#0000005C] font-medium break-all">
                          {userDetails && userDetails?.user_detail?.postalcode
                            ? userDetails?.user_detail?.postalcode
                            : "null"}
                        </p>
                      </div>
                    </div>
                  </div>
                  <div className="flex flex-col gap-3">
                    <div className="grid md:grid-cols-4 grid-cols-2 gap-x-3 gap-y-6"></div>

                    <div className="flex justify-end">
                      <Link
                        href="/profile/information-contact-detail"
                        className=" bg-golden text-white px-4 py-2 rounded-md flex items-center gap-2 text-sm"
                      >
                        <FontAwesomeIcon icon={faPen} className="font-small" />
                        <span className="font-medium">Edit Information</span>
                      </Link>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div className="bg-gray-400 h-[1px]"></div>
            <div className="flex flex-col md:flex-row gap-6 lg:gap-16 ">
              <div className="md:w-1/2">
                <div className="text-2xl font-bold text-black leading-normal">
                  Education
                </div>
                <div>
                  <div>
                    {allEducation?.length ? (
                      <div>
                        {allEducation?.map((item, index) => (
                          <div key={index} className="flex flex-col gap-4 mb-8">
                            <div className="flex justify-end gap-4 items-center">
                              <button
                                onClick={() => handleDeleteEducation(item?.id)}
                              >
                                <FontAwesomeIcon
                                  icon={faTrash}
                                  className="text-golden w-4 h-4"
                                />
                              </button>
                              <button onClick={() => handleEditEducation(item)}>
                                <FontAwesomeIcon
                                  icon={faPen}
                                  className="text-golden w-4 h-4"
                                />
                              </button>
                            </div>
                            <div className="flex gap-2 justify-between">
                              <div className="flex gap-1 flex-col items-start">
                                <span className="text-lg font-bold">
                                  Institute Name
                                </span>
                                <span className="text-base text-[#0000005C] font-medium">
                                  {item?.institute_name}
                                </span>
                              </div>
                              <div className="min-w-36 flex gap-1 items-start flex-col">
                                <span className="text-lg font-bold">
                                  Field of Study
                                </span>
                                <span className="text-base text-[#0000005C] font-medium">
                                  {item?.field_of_study}
                                </span>
                              </div>
                            </div>
                            <div className="flex gap-2 justify-between">
                              <div className="flex gap-1 items-start flex-col">
                                <span className="text-lg font-bold">
                                  Start Date
                                </span>
                                <span className="text-base text-[#0000005C] font-medium">
                                  {item?.start_date}
                                </span>
                              </div>
                              <div className="min-w-36 flex gap-1 items-start  flex-col">
                                <span className="text-lg font-bold">
                                  End Date
                                </span>
                                <span className="text-base text-[#0000005C] font-medium">
                                  {item?.end_date}
                                </span>
                              </div>
                            </div>
                          </div>
                        ))}
                      </div>
                    ) : (
                      <div>No education data available.</div>
                    )}
                  </div>
                  <div className="mt-4">
                    <Link
                      href="/profile/education"
                      className=" bg-golden text-white px-4 py-2 rounded-md inline-flex items-center gap-2 text-sm"
                    >
                      <FontAwesomeIcon icon={faPlus} className="h-4 w-4" />
                      Add New
                    </Link>
                  </div>
                </div>
              </div>
              <div className="md:w-1/2">
                <div className="text-2xl font-bold text-black leading-normal">
                  Experience
                </div>
                <div>
                  <div>
                    {allExperience?.length ? (
                      <div>
                        {allExperience?.map((item, index) => (
                          <div key={index} className="flex flex-col gap-4 mb-8">
                            <div className="flex justify-end gap-4 items-center">
                              <button
                                onClick={() => handleDeleteExperience(item?.id)}
                              >
                                <FontAwesomeIcon
                                  icon={faTrash}
                                  className="text-golden w-4 h-4"
                                />
                              </button>
                              <button
                                onClick={() => handleEditExperience(item)}
                              >
                                <FontAwesomeIcon
                                  icon={faPen}
                                  className="text-golden w-4 h-4"
                                />
                              </button>
                            </div>
                            <div className="flex gap-2 justify-between">
                              <div className="flex gap-1 flex-col items-start">
                                <span className="text-lg font-bold">
                                  Company Name
                                </span>
                                <span className="text-base text-[#0000005C] font-medium">
                                  {item?.company_name}
                                </span>
                              </div>
                              <div className="min-w-36 flex gap-1 items-start flex-col">
                                <span className="text-lg font-bold">
                                  Designation
                                </span>
                                <span className="text-base text-[#0000005C] font-medium">
                                  {item?.designation}
                                </span>
                              </div>
                            </div>
                            <div className="flex gap-2 justify-between">
                              <div className="flex gap-1 items-start flex-col">
                                <span className="text-lg font-bold">
                                  Start Date
                                </span>
                                <span className="text-base text-[#0000005C] font-medium">
                                  {item?.start_date}
                                </span>
                              </div>
                              <div className="min-w-36 flex gap-1 items-start  flex-col">
                                <span className="text-lg font-bold">
                                  End Date
                                </span>
                                <span className="text-base text-[#0000005C] font-medium">
                                  {item?.end_date}
                                </span>
                              </div>
                            </div>
                          </div>
                        ))}
                      </div>
                    ) : (
                      <div>No experience data available.</div>
                    )}
                  </div>
                  <div className="mt-4">
                    <Link
                      href="/profile/experience"
                      className=" bg-golden text-white px-4 py-2 rounded-md inline-flex items-center gap-2 text-sm"
                    >
                      <FontAwesomeIcon icon={faPlus} className="h-4 w-4" />
                      Add New
                    </Link>
                  </div>
                </div>
              </div>
            </div>
          </>
        ) : (
          <div className="flex justify-center items-center ">
            <LoaderCircle />
          </div>
        )}
      </div>
      {isExperienceModalOpen && (
        <div>
          <ExperienceModal
            isOpen={isExperienceModalOpen}
            onClose={() => setIsExperienceModalOpen(false)}
            onSubmit={handleExperienceModalSubmit}
            selectedExperience={selectedExperience}
          />
        </div>
      )}
      {isEducationModalOpen && (
        <div>
          <EducationModal
            isOpen={isEducationModalOpen}
            onClose={() => setIsEducationModalOpen(false)}
            onSubmit={handleEducationModalSubmit}
            selectedEducation={selectedEducation}
          />
        </div>
      )}
    </div>
  );
};

export default Profile;
