"use client";
import Image from "next/image";
import React, { useState } from "react";
import image1 from "../../../../../public/assets/dashboard/up1.png";
import image2 from "../../../../../public/assets/dashboard/up2.png";
import image3 from "../../../../../public/assets/dashboard/up3.png";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import {
  faChevronDown,
  faChevronLeft,
  faChevronRight,
} from "@fortawesome/free-solid-svg-icons";
import { startOfWeek, addDays, subDays, format } from "date-fns";
import { useSelector, useDispatch } from "react-redux";
import { inProgress as inProgressSlice } from "@/newStore/features/inProgressSlice";
import { useEffect } from "react";  
import { upComingVideo as upComingVideoSlice } from "@/newStore/features/upComingVideoSlice";

const WeeklyCalendar = ({ startDate, nextWeek, prevWeek, days }) => (
  <div className="md:mt-4 mb-4">
    <div className="flex justify-between mb-6">
      <div className="text-[20px] font-bold">
        {format(startDate, "MMMM yyyy")}
      </div>
      <div>
        <button onClick={prevWeek} className="mr-2">
          <FontAwesomeIcon icon={faChevronLeft} />
        </button>
        <button onClick={nextWeek}>
          <FontAwesomeIcon icon={faChevronRight} />
        </button>
      </div>
    </div>
    <div className="flex justify-between">
      {days.map((day, index) => (
        <div
          key={index}
          className="text-center bg-[#D9D9D9] min-w-[38px] p-1 rounded-lg"
        >
          <p className="text-[12px] font-normal">{format(day, "EEE")}</p>
          <p className="text-[12px] font-normal">{format(day, "d")}</p>
        </div>
      ))}
    </div>
  </div>
);

const LeftPart = () => {

  const [startDate, setStartDate] = useState(
    startOfWeek(new Date(), { weekStartsOn: 0 })
  );

  const auth = useSelector((data) => data?.auth);

  const nextWeek = () => {
    setStartDate(addDays(startDate, 7));
  };

  const prevWeek = () => {
    setStartDate(subDays(startDate, 7));
  };

  const days = Array.from({ length: 7 }, (_, i) => addDays(startDate, i));

  // const scheduleCourses = [
  //   {
  //     id: 1,
  //     courseName: "Introduction to Python",
  //     courseDuration: "17.00-18.00",
  //     courseVideos: "12 Videos",
  //   },
  //   {
  //     id: 2,
  //     courseName: "Web Development",
  //     courseDuration: "12.00-13.00",
  //     courseVideos: "8 Videos",
  //   },
  //   {
  //     id: 3,
  //     courseName: "Data Analysis",
  //     courseDuration: "14.00-15.00",
  //     courseVideos: "10 Videos",
  //   },
  //   {
  //     id: 4,
  //     courseName: "Machine Learning",
  //     courseDuration: "16.00-17.00",
  //     courseVideos: "15 Videos",
  //   },
  //   {
  //     id: 5,
  //     courseName: "Artificial Intelligence",
  //     courseDuration: "18.00-19.00",
  //     courseVideos: "18 Videos",
  //   },
  // ];

  const upcomingCourses = [
    {
      id: 1,
      courseName: "Introduction to Python",
      courseImage: image1,
      courseStatus: "Upcoming",
    },
    {
      id: 2,
      courseName: "Web Development",
      courseImage: image2,
      courseStatus: "Upcoming",
    },
    {
      id: 3,
      courseName: "Data Analysis",
      courseImage: image3,
      courseStatus: "Upcoming",
    },
  ];

  const today = new Date();

  const formattedDate = today.toLocaleDateString('en-US', {
    year: 'numeric',
    month: 'long',
    day: 'numeric'
  });

  const dispatch = useDispatch();

  useEffect(() => {
    dispatch(inProgressSlice());
    dispatch(upComingVideoSlice());
  }, [dispatch]);

  const inProgressCourses = useSelector((state) => state.inProgress.inProgressCourses);
  const upComingVideo = useSelector((state) => state.upComingVideo.upComingVideo);

  return (
    <div>
      <div className="hidden md:flex justify-center items-center">
        <div className="flex items-center gap-3">
          {(auth?.userDetail?.media &&
            auth?.userDetail?.media[0]?.original_url && (
              <img
                src={auth?.userDetail?.media[0]?.original_url}
                alt="profile"
                className="h-16 w-16 rounded-full object-cover"
              />
            )) || (
              <div className="h-16 w-16 rounded-full bg-golden flex items-center justify-center">
                <span className="text-2xl font-bold text-white capitalize">
                  {auth?.userDetail?.name?.charAt(0).toUpperCase()}
                </span>
              </div>
            )}

          <div>
            <p className="text-[14px] font-bold capitalize">{auth?.userDetail?.name}</p>
            <p className="text-[12px] font-normal capitalize">
              {auth?.userDetail?.role?.name}
            </p>
          </div>
        </div>
        {/* <div>
          <FontAwesomeIcon icon={faChevronDown} />
        </div> */}
      </div>
      <div className="mt-5 mb-5">
        <h1 className="text-[20px] font-bold">{formattedDate}</h1>
        {/* <WeeklyCalendar
          startDate={startDate}
          nextWeek={nextWeek}
          prevWeek={prevWeek}
          days={days}
        /> */}
      </div>
      <div className="py-2">
        <div className="flex justify-between items-center">
          <p className="text-[20px] font-bold text-black">Enrolled Courses</p>
          <button className="text-[#3E3E3E] text-[14px] font-normal">
            See all
          </button>
        </div>
        <div className="flex flex-col gap-4 mt-6">
          {inProgressCourses?.map((course, index) => (
            <div
              key={index}
              className="bg-[#EBEBEB] p-2 flex justify-between items-center h-[56px] rounded-md"
            >
              <div className="flex items-center gap-2">
                <p className="text-[20px] font-bold">{index + 1}</p>
                <div className="border-l border-[#3E3E3E] h-[40px]"></div>
                <div>
                  <p className="text-[14px] font-bold">{course?.course?.title}</p>
                  <p className="text-[12px] font-normal">
                    {course?.course?.total_videos}
                  </p>
                </div>
              </div>
              <div>
                <p className="text-[12px] font-normal">
                  {course?.course?.time_duration}
                </p>
              </div>
            </div>
          ))}
        </div>
      </div>
      <div className="py-2">
        <div className="flex justify-between items-center">
          <p className="text-[20px] font-bold text-black">Upcoming Videos</p>
          <button className="text-[#3E3E3E] text-[14px] font-normal">
            See all
          </button>
        </div>
        <div className="flex flex-col gap-4 mt-6">
          {upComingVideo?.upcoming_videos?.map((course, index) => (
            <div key={course?.index} className="flex items-center gap-4 rounded-md">
              <Image
                src={image1}
                alt="image"
                className="w-20 h-16"
              />
              <div>
                <p className="text-black text-[14px] font-bold">
                  {course?.title}
                </p>
                <p className="text-[#3E3E3E] text-[14px] font-normal">
                  Upcoming
                </p>
              </div>
            </div>
          ))}
        </div>
      </div>
    </div>
  );
};

export default LeftPart;