import React from "react";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faCircleCheck, faCirclePlay } from "@fortawesome/free-solid-svg-icons";
import { MdAssignmentAdd } from "react-icons/md";
import { useRouter } from "next/navigation";

export default function UpComingVideos({
  videoId,
  groupedVideos,
  handleVideoSelection,
  nextVideoVisible,
}) {
  const router = useRouter();

  // Log props for debugging
  console.log("nextVideoVisible:", nextVideoVisible);
  console.log("groupedVideos:", JSON.stringify(groupedVideos, null, 2));

  const handleNavigate = (assignment_id, video_id) => {
    router.push(`/fill-assignment?assignment_id=${assignment_id}&video_id=${video_id}`);
  };

  const allVideos = Object.values(groupedVideos).flat();

  // Find the first incomplete video
  const firstIncompleteIndex = allVideos.findIndex((v) => v.is_video_completed === 0);
  const nextIncompleteVideoId = firstIncompleteIndex !== -1 ? allVideos[firstIncompleteIndex].id : null;

  return (
    <div className="md:w-[300px] bg-white p-4 md:pt-0">
      <h2 className="hidden md:block text-xl font-bold mb-3">Upcoming Videos</h2>
      <div className="max-h-[700px] overflow-y-auto pr-2 flex flex-col gap-3">
        {Object.entries(groupedVideos).map(([chapter, videos]) => (
          <div key={chapter} className="mb-4">
            <h3 className="text-xl font-semibold mb-2">{chapter}</h3>
            {videos.map((video, index) => {
              // Check if all previous videos are completed
              const videoIndex = allVideos.findIndex((v) => v.id === video.id);
              const isPreviousCompleted =
                videoIndex === 0 || allVideos.slice(0, videoIndex).every((v) => v.is_video_completed === 1);

              // Video is visible if completed or it's the next incomplete video
              const isVisible =
                video.is_video_completed === 1 ||
                (isPreviousCompleted && video.id === nextIncompleteVideoId);


              return (
                <div
                  key={`${chapter}-${index}`}
                  className={`relative flex gap-4 px-2 py-3 mb-2 border rounded-lg ${
                    isVisible
                      ? videoId === video.video_id
                        ? "border-golden cursor-pointer"
                        : video.is_video_completed
                        ? "border-green-500 cursor-pointer"
                        : "border-gray-500 cursor-pointer"
                      : "border-gray-300 opacity-50 pointer-events-none"
                  }`}
                  onClick={() => isVisible && handleVideoSelection(video)}
                >
                  <div className="flex items-center gap-2 pt-2">
                    <FontAwesomeIcon
                      icon={video.is_video_completed ? faCircleCheck : faCirclePlay}
                      className={`h-4 w-4 ${
                        videoId === video.video_id
                          ? "text-golden"
                          : video.is_video_completed
                          ? "text-green-500"
                          : "text-gray-700"
                      }`}
                    />
                    <div
                      className={`text-sm font-normal ${
                        videoId === video.video_id
                          ? "text-golden"
                          : video.is_video_completed
                          ? "text-green-500"
                          : "text-gray-700"
                      }`}
                    >
                      {video.video.title}
                    </div>
                    {isVisible && video?.assignment?.user_assignment_status === 0 && (
                      <div
                        className="absolute top-5 right-1 h-4 w-4 cursor-pointer"
                        onClick={(e) => {
                          e.stopPropagation();
                          handleNavigate(video?.assignment?.id, video.id);
                        }}
                      >
                        <MdAssignmentAdd
                          className={video.is_video_completed ? "text-green-500" : "text-gray-700"}
                        />
                      </div>
                    )}
                  </div>
                </div>
              );
            })}
          </div>
        ))}
      </div>
    </div>
  );
}