"use client";
import { useRouter } from "next/navigation";
import React from "react";
import { IoMdClose } from "react-icons/io";

const ResultModal = ({ result, isVisible, onClose }) => {

  const router = useRouter();

  const handleClose = () => {
    onClose();
    router.back()
  };

  if (!isVisible) return null;

  return (
    <div className="fixed inset-0 bg-gray-600 bg-opacity-50 flex justify-center items-center z-50">
      <div className="relative bg-white p-4 rounded-lg shadow-lg w-[350px]">
        <h2 className="text-xl font-semibold text-center">
          {result
            ? " Congrats, yor are passed...!"
            : "Sorry, you are failed...!"}
        </h2>

        <div className="flex justify-center items-center py-5">
          <img
            src={result ? "/assets/success.gif" : "/assets/failed.gif"}
            alt=""
          />
        </div>
        <button
          onClick={handleClose}
          className="absolute top-3 right-3 text-black"
        >
          <IoMdClose className="h-5 w-5" />
        </button>
      </div>
    </div>
  );
};

export default ResultModal;