"use client";
import React, { useEffect, useState } from "react";
import { useGetAssignmentByCourseQuery } from "@/services/Api";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import {
  faPlus,
  faMinus,
  faListCheck,
} from "@fortawesome/free-solid-svg-icons";

import { useRouter } from "next/navigation";
import { LuLoader2 } from "react-icons/lu";
import Header from "../header/header";

const CourseAssignment = () => {
  const router = useRouter();
  const [activeIndex, setActiveIndex] = useState(null);
  const [assignment, setAssignment] = useState(null);

  const {
    data: getAssignmentByCourse,
    refetch: getAssignmentByCourseRefetch,
    isLoading: getAssignmentByCourseIsLoading,
  } = useGetAssignmentByCourseQuery();

  const toggleAssignments = (index) => {
    setActiveIndex(index === activeIndex ? null : index);
  };

  // const handleNavigate = (vid, id) => {
  //   router.push(`/fill-assignment?vid=${vid}&id=${id}`);
  // };
  const handleNavigate = (assignment_id, video_id) => {
    router.push(
      `/fill-assignment?assignment_id=${assignment_id}&video_id=${video_id}`
    );
  };

  useEffect(() => {
    getAssignmentByCourseRefetch().then((res) => {
      setAssignment(res.data.assignments);
    });
  }, []);

  return (
    <div className="md:px-[28px] px-3 pb-8 min-h-screen">
      <Header title="Course Assignments" />
      <div className="py-12">
        <>
          {getAssignmentByCourseIsLoading ? (
            <div className="grid grid-cols-2 gap-5">
              <div className=" w-full flex justify-center items-center py-40">
                <LuLoader2 className="animate-spin text-black h-6 w-6" />
              </div>
            </div>
          ) : (
            <>
              <div className="bg-white mt-6 rounded-2xl w-full max-h-full p-6 mb-4">
                <div className="mb-4">
                  <p className="text-[22px] font-bold">Assignment Lists</p>
                </div>

                {/* <li class="flex justify-between items-center border-b border-gray-200 py-2">
                    <div class="flex items-center">
                      <div class="mr-2.5 flex items-center justify-center w-10 h-10 bg-golden text-yellow-600 rounded">
                        <FontAwesomeIcon
                          icon={faListCheck}
                          className={"text-white"}
                        />
                      </div>
                      <div>
                        <div class="font-bold">Tuesday, 20 February 2024</div>
                        <div>Assignment 1: Rajmala Test Course 1</div>
                      </div>
                    </div>
                    <button class="bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700">
                      Add submission
                    </button>
                  </li>
                  <li class="flex justify-between items-center border-b border-gray-200 py-2">
                    <div class="flex items-center">
                      <div class="mr-2.5 flex items-center justify-center w-10 h-10 bg-golden text-yellow-600 rounded">
                        <FontAwesomeIcon
                          icon={faListCheck}
                          className={"text-white"}
                        />
                      </div>
                      <div>
                        <div class="font-bold">Thursday, 22 February 2024</div>
                        <div>Assignment 1: Rajmala Test Course</div>
                      </div>
                    </div>
                    <button class="bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700">
                      Add submission
                    </button>
                  </li> */}
                {assignment?.length > 0 ? (
                  <ul class="list-none p-0">
                    {assignment?.map((course) => (
                      <li
                        key={course?.id}
                        class="flex justify-between items-center border-b border-gray-200 py-2"
                      >
                        
                        <div class="flex items-center">
                          <div class="mr-2.5 flex items-center justify-center w-10 h-10 bg-golden text-yellow-600 rounded">
                            <FontAwesomeIcon
                              icon={faListCheck}
                              className={"text-white"}
                            />
                          </div>
                          <div>
                            <div class="font-bold capitalize">{course?.course?.title}</div>
                            <div className="capitalize">{course?.title}</div>
                          </div>
                        </div>
                        <button
                          onClick={() =>
                            handleNavigate(course?.id, course?.course_video?.id)
                          }
                          class="bg-golden border border-golden text-white px-4 py-2 rounded hover:bg-transparent hover:text-golden"
                        >
                          Add submission
                        </button>
                      </li>
                      // <div className=" w-1/2 mb-4">
                      //   <div className="px-2">
                      //     <div
                      //       key={course?.id}
                      //       className={`flex flex-col gap-2 rounded-md ${
                      //         activeIndex === course?.id
                      //           ? "bg-golden"
                      //           : "  bg-white"
                      //       }`}
                      //     >
                      //       <div
                      //         className="flex justify-between pb-1 px-4 pt-4  cursor-pointer"
                      //         onClick={() => toggleAssignments(course?.id)}
                      //       >
                      //         <h2
                      //           className={`font-medium text-xl ${
                      //             activeIndex === course?.id
                      //               ? "text-white"
                      //               : "text-black"
                      //           }`}
                      //         >
                      //           {course?.course?.title}
                      //         </h2>
                      //         <FontAwesomeIcon
                      //           icon={
                      //             activeIndex === course?.id ? faMinus : faPlus
                      //           }
                      //           className={`h-5 w-5 ${
                      //             activeIndex === course?.id
                      //               ? "text-white"
                      //               : "text-black"
                      //           }`}
                      //         />
                      //       </div>
                      //       {/* //  {activeIndex === course?.id &&
                      //   // course?.videos?.map((data) => {
                      //       // return (  */}
                      //       <div
                      //         className={`bg-white ${
                      //           activeIndex === course?.id
                      //             ? ""
                      //             : "max-h-0 overflow-hidden"
                      //         }`}
                      //         onClick={() =>
                      //           handleNavigate(
                      //             course?.id,
                      //             course?.course_video?.id
                      //           )
                      //         }
                      //       >
                      //         <div className={`px-4 py-4  `}>
                      //           <p className="text-darkgrey font-normal text-lg cursor-pointer inline-block">
                      //             {course?.title}
                      //           </p>
                      //         </div>
                      //       </div>
                      //       {/* );
                      //   })}  */}
                      //     </div>
                      //   </div>
                      // </div>
                    ))}
                  </ul>
                ) : (
                  <div className="bg-white rounded-2xl w-full max-h-full p-6">
                    <div className="flex justify-center items-center text-xl font-semibold min-h-[50vh] min-w-full">
                      No course assignments available at the moment
                    </div>
                  </div>
                )}
              </div>
            </>
          )}
        </>
      </div>
    </div>
  );
};

export default CourseAssignment;
