import React from "react";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faPlay, faCheck } from "@fortawesome/free-solid-svg-icons";

const About = () => {

  const data = [
    {
      title: "Daily Video Update",
      text: "Mountains in just switching city steps Might rung line what Was or between towards the have phase.",
    },
    {
      title: "Videos from Experts",
      text: "Mountains in just switching city steps Might rung line what Was or between towards the have phase.",
    },
    {
      title: "Category Options",
      text: "Mountains in just switching city steps Might rung line what Was or between towards the have phase.",
    },
    {
      title: "500+ High Quality Videos",
      text: "Mountains in just switching city steps Might rung line what Was or between towards the have phase.",
    },
    {
      title: "Earn a Certificate",
      text: "Mountains in just switching city steps Might rung line what Was or between towards the have phase.",
    },
  ];

  const userData = [
    {
      num: "25K+",
      text: "Active Users",
    },
    {
      num: "899",
      text: "Total Videos",
    },
    {
      num: "158",
      text: "Instructor",
    },
    {
      num: "100%",
      text: "Satisfaction rate",
    },
  ];

  return (
    <div>
      <div className="relative">
        <img
          src="/assets/home/homeCard.png"
          alt="Home-Card"
          className="w-full max-h-[500px] bg-cover"
        />
        <div className="absolute top-0 left-0 h-full w-full flex justify-center items-center bg-black opacity-60">
          <p className="text-white font-medium text-3xl">About Us</p>
        </div>
      </div>
      <div className="max-w-7xl px-8 py-8 mx-auto grid md:grid-cols-2 grid-cols-1 gap-x-6 gap-y-6">
        <div className="flex flex-col justify-center">
          <h1 className="text-3xl font-semibold text-black mb-4">
            Brandon Bames – Make It Unique
          </h1>
          <p className="text-xl">
            Lorem Ipsum is simply dummy text of the printing and typesetting
            industry. Lorem Ipsum has been the industry's standard dummy text
            ever since the 1500s, when an unknown printer took a galley of type
            and scrambled it to make a type specimen book. It has survived not
            only five centuries, but also the leap into electronic typesetting,
            remaining essentially unchanged. It was popularised in the 1960s
            with the release of Letraset sheets containing Lorem Ipsum passages,
            and more recently with desktop publishing software like Aldus
            PageMaker including versions of Lorem Ipsum.
          </p>
        </div>
        <div>
          <img
            src="/assets/aboutus/aboutframe.png"
            alt="Home-Card"
            className="w-full max-h-[500px] bg-cover"
          />
        </div>
      </div>
      <div className="max-w-7xl px-8 py-8 mx-auto">
        <div className="flex justify-center items-center">
          <div className="grid justify-center grid-cols-1 md:grid-cols-2 xl:grid-cols-3 gap-y-10 lg:gap-x-8 md:gap-x-4">
            <div className="group transform transition-transform hover:-translate-y-6 hover:shadow-2xl hover:scale-105 max-w-sm bg-white">
              <div className="p-5">
                <h5 className="mb-2 text-4xl font-bold tracking-tight text-gray-900 group-hover:text-golden">
                  Why
                  <br />
                  choose Us
                </h5>

                <p className="mb-3 font-normal text-gray-700 dark:text-gray-400">
                  Comfort reached gay perhaps chamber his six detract besides
                  add. Moonlight newspaper up its enjoyment agreeable
                  depending.
                </p>
              </div>
            </div>
            {data?.length &&
              data?.map((data, index) => (
                <div
                  key={index}
                  className="group transform transition-transform hover:-translate-y-6 hover:shadow-2xl hover:scale-105 max-w-sm bg-[#EFF4FF] border border-gray-200 rounded-lg shadow"
                >
                  <div className="p-5">
                    <FontAwesomeIcon
                      icon={faPlay}
                      className="text-[#B9802A]"
                      size="2xl"
                    />
                    <h5 className="my-5 text-2xl font-bold tracking-tight text-gray-900 group-hover:text-golden">
                      {data?.title}
                    </h5>

                    <p className="mb-3 font-normal text-gray-700">
                      {data?.text}
                    </p>
                  </div>
                </div>
              ))}
          </div>
        </div>
      </div>
      <div className="max-w-7xl px-8 py-8 mx-auto grid md:grid-cols-2 grid-cols-1 gap-x-6 gap-y-6">
        <div>
          <img
            src="/assets/aboutus/aboutframe.png"
            alt="Home-Card"
            className="w-full max-h-[500px] bg-cover"
          />
        </div>
        <div className="flex flex-col justify-center">
          <h1 className="text-3xl font-semibold text-black mb-4">
            Brandon Bames – Make It Unique
          </h1>
          <p className="text-xl">
            Lorem Ipsum is simply dummy text of the printing and typesetting
            industry. Lorem Ipsum has been the industry's standard dummy text
            ever since the 1500s, when an unknown printer took a galley of type
            and scrambled it to make a type specimen book. It has survived not
            only five centuries, but also the leap into electronic typesetting,
            remaining essentially unchanged. It was popularised in the 1960s
            with the release of Letraset sheets containing Lorem Ipsum passages,
            and more recently with desktop publishing software like Aldus
            PageMaker including versions of Lorem Ipsum.
          </p>
        </div>
      </div>
      <div className="max-w-7xl mx-auto flex flex-col lg:flex-row justify-between gap-4 my-10">
        <div className="flex justify-center items-center">
          <img
            src="/assets/home/featureVideos/grow.png"
            className="object-cover"
            alt="grow-skills"
          />
        </div>
        <div className="flex justify-center">
          <div className="max-w-[520px]">
            <h1 className="text-[32px] font-bold">Grow Us Your Skill </h1>
            <h1 className="text-[32px] font-bold">
              With Agent Ambition Academy
            </h1>
            <p className="my-2">
              We denounce with righteous indignation and dislike men who are so
              beguiled and demoralized that cannot trouble.
            </p>
            <div className="flex flex-col gap-2">
              <div className="flex items-center gap-2">
                <FontAwesomeIcon
                  icon={faCheck}
                  className="text-lightblue text-[16px]"
                />
                <span>Certification</span>
              </div>
              <div className="flex items-center gap-2">
                <FontAwesomeIcon
                  icon={faCheck}
                  className="text-lightblue text-[16px]"
                />
                <span>Certification</span>
              </div>
              <div className="flex items-center gap-2">
                <FontAwesomeIcon
                  icon={faCheck}
                  className="text-lightblue text-[16px]"
                />
                <span>Certification</span>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div className="py-10 flex justify-center items-center">
        <div className="grid justify-center items-center place-items-center grid-cols-2 md:grid-cols-2 xl:grid-cols-4 gap-y-5 l:gap-x-6 gap-x-4">
          {userData?.length &&
            userData?.map((userData, index) => (
              <div
                key={index}
                className="flex gap-4 items-center p-3 bg-whitegrey rounded-md shadow min-w-[150px] sm:min-w-[200px] md:min-w-[250px] max-w-[300px] h-[180px]"
              >
                <div className="flex flex-col gap-2 justify-center items-center w-[100%]">
                  <p className="text-golden font-semibold text-3xl">
                    {userData?.num}
                  </p>
                  <p className="text-black font-medium text-[18px]">
                    {userData?.text}
                  </p>
                </div>
              </div>
            ))}
        </div>
      </div>
    </div>
  );
};

export default About;