"use strict";
/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
exports.id = "vendor-chunks/libphonenumber-js";
exports.ids = ["vendor-chunks/libphonenumber-js"];
exports.modules = {

/***/ "(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/AsYouType.js":
/*!***********************************************************************************************************!*\
  !*** ../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/AsYouType.js ***!
  \***********************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ AsYouType)\n/* harmony export */ });\n/* harmony import */ var _metadata_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./metadata.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/metadata.js\");\n/* harmony import */ var _PhoneNumber_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./PhoneNumber.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/PhoneNumber.js\");\n/* harmony import */ var _AsYouTypeState_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./AsYouTypeState.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/AsYouTypeState.js\");\n/* harmony import */ var _AsYouTypeFormatter_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./AsYouTypeFormatter.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/AsYouTypeFormatter.js\");\n/* harmony import */ var _AsYouTypeFormatter_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./AsYouTypeFormatter.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/AsYouTypeFormatter.util.js\");\n/* harmony import */ var _AsYouTypeParser_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./AsYouTypeParser.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/AsYouTypeParser.js\");\n/* harmony import */ var _helpers_getCountryByCallingCode_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./helpers/getCountryByCallingCode.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/getCountryByCallingCode.js\");\n/* harmony import */ var _helpers_getCountryByNationalNumber_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./helpers/getCountryByNationalNumber.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/getCountryByNationalNumber.js\");\n/* harmony import */ var _helpers_isObject_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./helpers/isObject.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/isObject.js\");\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\n\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\n\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }\n\nfunction _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== \"undefined\" && arr[Symbol.iterator] || arr[\"@@iterator\"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, \"prototype\", { writable: false }); return Constructor; }\n\n\n\n\n\n\n\n\n\nvar USE_NON_GEOGRAPHIC_COUNTRY_CODE = false;\n\nvar AsYouType = /*#__PURE__*/function () {\n  /**\r\n   * @param {(string|object)?} [optionsOrDefaultCountry] - The default country used for parsing non-international phone numbers. Can also be an `options` object.\r\n   * @param {Object} metadata\r\n   */\n  function AsYouType(optionsOrDefaultCountry, metadata) {\n    _classCallCheck(this, AsYouType);\n\n    this.metadata = new _metadata_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"](metadata);\n\n    var _this$getCountryAndCa = this.getCountryAndCallingCode(optionsOrDefaultCountry),\n        _this$getCountryAndCa2 = _slicedToArray(_this$getCountryAndCa, 2),\n        defaultCountry = _this$getCountryAndCa2[0],\n        defaultCallingCode = _this$getCountryAndCa2[1]; // `this.defaultCountry` and `this.defaultCallingCode` aren't required to be in sync.\n    // For example, `this.defaultCountry` could be `\"AR\"` and `this.defaultCallingCode` could be `undefined`.\n    // So `this.defaultCountry` and `this.defaultCallingCode` are totally independent.\n\n\n    this.defaultCountry = defaultCountry;\n    this.defaultCallingCode = defaultCallingCode;\n    this.reset();\n  }\n\n  _createClass(AsYouType, [{\n    key: \"getCountryAndCallingCode\",\n    value: function getCountryAndCallingCode(optionsOrDefaultCountry) {\n      // Set `defaultCountry` and `defaultCallingCode` options.\n      var defaultCountry;\n      var defaultCallingCode; // Turns out `null` also has type \"object\". Weird.\n\n      if (optionsOrDefaultCountry) {\n        if ((0,_helpers_isObject_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(optionsOrDefaultCountry)) {\n          defaultCountry = optionsOrDefaultCountry.defaultCountry;\n          defaultCallingCode = optionsOrDefaultCountry.defaultCallingCode;\n        } else {\n          defaultCountry = optionsOrDefaultCountry;\n        }\n      }\n\n      if (defaultCountry && !this.metadata.hasCountry(defaultCountry)) {\n        defaultCountry = undefined;\n      }\n\n      if (defaultCallingCode) {\n        /* istanbul ignore if */\n        if (USE_NON_GEOGRAPHIC_COUNTRY_CODE) {\n          if (this.metadata.isNonGeographicCallingCode(defaultCallingCode)) {\n            defaultCountry = '001';\n          }\n        }\n      }\n\n      return [defaultCountry, defaultCallingCode];\n    }\n    /**\r\n     * Inputs \"next\" phone number characters.\r\n     * @param  {string} text\r\n     * @return {string} Formatted phone number characters that have been input so far.\r\n     */\n\n  }, {\n    key: \"input\",\n    value: function input(text) {\n      var _this$parser$input = this.parser.input(text, this.state),\n          digits = _this$parser$input.digits,\n          justLeadingPlus = _this$parser$input.justLeadingPlus;\n\n      if (justLeadingPlus) {\n        this.formattedOutput = '+';\n      } else if (digits) {\n        this.determineTheCountryIfNeeded(); // Match the available formats by the currently available leading digits.\n\n        if (this.state.nationalSignificantNumber) {\n          this.formatter.narrowDownMatchingFormats(this.state);\n        }\n\n        var formattedNationalNumber;\n\n        if (this.metadata.hasSelectedNumberingPlan()) {\n          formattedNationalNumber = this.formatter.format(digits, this.state);\n        }\n\n        if (formattedNationalNumber === undefined) {\n          // See if another national (significant) number could be re-extracted.\n          if (this.parser.reExtractNationalSignificantNumber(this.state)) {\n            this.determineTheCountryIfNeeded(); // If it could, then re-try formatting the new national (significant) number.\n\n            var nationalDigits = this.state.getNationalDigits();\n\n            if (nationalDigits) {\n              formattedNationalNumber = this.formatter.format(nationalDigits, this.state);\n            }\n          }\n        }\n\n        this.formattedOutput = formattedNationalNumber ? this.getFullNumber(formattedNationalNumber) : this.getNonFormattedNumber();\n      }\n\n      return this.formattedOutput;\n    }\n  }, {\n    key: \"reset\",\n    value: function reset() {\n      var _this = this;\n\n      this.state = new _AsYouTypeState_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"]({\n        onCountryChange: function onCountryChange(country) {\n          // Before version `1.6.0`, the official `AsYouType` formatter API\n          // included the `.country` property of an `AsYouType` instance.\n          // Since that property (along with the others) have been moved to\n          // `this.state`, `this.country` property is emulated for compatibility\n          // with the old versions.\n          _this.country = country;\n        },\n        onCallingCodeChange: function onCallingCodeChange(callingCode, country) {\n          _this.metadata.selectNumberingPlan(country, callingCode);\n\n          _this.formatter.reset(_this.metadata.numberingPlan, _this.state);\n\n          _this.parser.reset(_this.metadata.numberingPlan);\n        }\n      });\n      this.formatter = new _AsYouTypeFormatter_js__WEBPACK_IMPORTED_MODULE_3__[\"default\"]({\n        state: this.state,\n        metadata: this.metadata\n      });\n      this.parser = new _AsYouTypeParser_js__WEBPACK_IMPORTED_MODULE_4__[\"default\"]({\n        defaultCountry: this.defaultCountry,\n        defaultCallingCode: this.defaultCallingCode,\n        metadata: this.metadata,\n        state: this.state,\n        onNationalSignificantNumberChange: function onNationalSignificantNumberChange() {\n          _this.determineTheCountryIfNeeded();\n\n          _this.formatter.reset(_this.metadata.numberingPlan, _this.state);\n        }\n      });\n      this.state.reset({\n        country: this.defaultCountry,\n        callingCode: this.defaultCallingCode\n      });\n      this.formattedOutput = '';\n      return this;\n    }\n    /**\r\n     * Returns `true` if the phone number is being input in international format.\r\n     * In other words, returns `true` if and only if the parsed phone number starts with a `\"+\"`.\r\n     * @return {boolean}\r\n     */\n\n  }, {\n    key: \"isInternational\",\n    value: function isInternational() {\n      return this.state.international;\n    }\n    /**\r\n     * Returns the \"calling code\" part of the phone number when it's being input\r\n     * in an international format.\r\n     * If no valid calling code has been entered so far, returns `undefined`.\r\n     * @return {string} [callingCode]\r\n     */\n\n  }, {\n    key: \"getCallingCode\",\n    value: function getCallingCode() {\n      // If the number is being input in national format and some \"default calling code\"\n      // has been passed to `AsYouType` constructor, then `this.state.callingCode`\n      // is equal to that \"default calling code\".\n      //\n      // If the number is being input in national format and no \"default calling code\"\n      // has been passed to `AsYouType` constructor, then returns `undefined`,\n      // even if a \"default country\" has been passed to `AsYouType` constructor.\n      //\n      if (this.isInternational()) {\n        return this.state.callingCode;\n      }\n    } // A legacy alias.\n\n  }, {\n    key: \"getCountryCallingCode\",\n    value: function getCountryCallingCode() {\n      return this.getCallingCode();\n    }\n    /**\r\n     * Returns a two-letter country code of the phone number.\r\n     * Returns `undefined` for \"non-geographic\" phone numbering plans.\r\n     * Returns `undefined` if no phone number has been input yet.\r\n     * @return {string} [country]\r\n     */\n\n  }, {\n    key: \"getCountry\",\n    value: function getCountry() {\n      var digits = this.state.digits; // Return `undefined` if no digits have been input yet.\n\n      if (digits) {\n        return this._getCountry();\n      }\n    }\n    /**\r\n     * Returns a two-letter country code of the phone number.\r\n     * Returns `undefined` for \"non-geographic\" phone numbering plans.\r\n     * @return {string} [country]\r\n     */\n\n  }, {\n    key: \"_getCountry\",\n    value: function _getCountry() {\n      var country = this.state.country;\n      /* istanbul ignore if */\n\n      if (USE_NON_GEOGRAPHIC_COUNTRY_CODE) {\n        // `AsYouType.getCountry()` returns `undefined`\n        // for \"non-geographic\" phone numbering plans.\n        if (country === '001') {\n          return;\n        }\n      }\n\n      return country;\n    }\n  }, {\n    key: \"determineTheCountryIfNeeded\",\n    value: function determineTheCountryIfNeeded() {\n      // Suppose a user enters a phone number in international format,\n      // and there're several countries corresponding to that country calling code,\n      // and a country has been derived from the number, and then\n      // a user enters one more digit and the number is no longer\n      // valid for the derived country, so the country should be re-derived\n      // on every new digit in those cases.\n      //\n      // If the phone number is being input in national format,\n      // then it could be a case when `defaultCountry` wasn't specified\n      // when creating `AsYouType` instance, and just `defaultCallingCode` was specified,\n      // and that \"calling code\" could correspond to a \"non-geographic entity\",\n      // or there could be several countries corresponding to that country calling code.\n      // In those cases, `this.country` is `undefined` and should be derived\n      // from the number. Again, if country calling code is ambiguous, then\n      // `this.country` should be re-derived with each new digit.\n      //\n      if (!this.state.country || this.isCountryCallingCodeAmbiguous()) {\n        this.determineTheCountry();\n      }\n    } // Prepends `+CountryCode ` in case of an international phone number\n\n  }, {\n    key: \"getFullNumber\",\n    value: function getFullNumber(formattedNationalNumber) {\n      var _this2 = this;\n\n      if (this.isInternational()) {\n        var prefix = function prefix(text) {\n          return _this2.formatter.getInternationalPrefixBeforeCountryCallingCode(_this2.state, {\n            spacing: text ? true : false\n          }) + text;\n        };\n\n        var callingCode = this.state.callingCode;\n\n        if (!callingCode) {\n          return prefix(\"\".concat(this.state.getDigitsWithoutInternationalPrefix()));\n        }\n\n        if (!formattedNationalNumber) {\n          return prefix(callingCode);\n        }\n\n        return prefix(\"\".concat(callingCode, \" \").concat(formattedNationalNumber));\n      }\n\n      return formattedNationalNumber;\n    }\n  }, {\n    key: \"getNonFormattedNationalNumberWithPrefix\",\n    value: function getNonFormattedNationalNumberWithPrefix() {\n      var _this$state = this.state,\n          nationalSignificantNumber = _this$state.nationalSignificantNumber,\n          complexPrefixBeforeNationalSignificantNumber = _this$state.complexPrefixBeforeNationalSignificantNumber,\n          nationalPrefix = _this$state.nationalPrefix;\n      var number = nationalSignificantNumber;\n      var prefix = complexPrefixBeforeNationalSignificantNumber || nationalPrefix;\n\n      if (prefix) {\n        number = prefix + number;\n      }\n\n      return number;\n    }\n  }, {\n    key: \"getNonFormattedNumber\",\n    value: function getNonFormattedNumber() {\n      var nationalSignificantNumberMatchesInput = this.state.nationalSignificantNumberMatchesInput;\n      return this.getFullNumber(nationalSignificantNumberMatchesInput ? this.getNonFormattedNationalNumberWithPrefix() : this.state.getNationalDigits());\n    }\n  }, {\n    key: \"getNonFormattedTemplate\",\n    value: function getNonFormattedTemplate() {\n      var number = this.getNonFormattedNumber();\n\n      if (number) {\n        return number.replace(/[\\+\\d]/g, _AsYouTypeFormatter_js__WEBPACK_IMPORTED_MODULE_5__.DIGIT_PLACEHOLDER);\n      }\n    }\n  }, {\n    key: \"isCountryCallingCodeAmbiguous\",\n    value: function isCountryCallingCodeAmbiguous() {\n      var callingCode = this.state.callingCode;\n      var countryCodes = this.metadata.getCountryCodesForCallingCode(callingCode);\n      return countryCodes && countryCodes.length > 1;\n    } // Determines the country of the phone number\n    // entered so far based on the country phone code\n    // and the national phone number.\n\n  }, {\n    key: \"determineTheCountry\",\n    value: function determineTheCountry() {\n      this.state.setCountry((0,_helpers_getCountryByCallingCode_js__WEBPACK_IMPORTED_MODULE_6__[\"default\"])(this.isInternational() ? this.state.callingCode : this.defaultCallingCode, {\n        nationalNumber: this.state.nationalSignificantNumber,\n        defaultCountry: this.defaultCountry,\n        metadata: this.metadata\n      }));\n    }\n    /**\r\n     * Returns a E.164 phone number value for the user's input.\r\n     *\r\n     * For example, for country `\"US\"` and input `\"(222) 333-4444\"`\r\n     * it will return `\"+12223334444\"`.\r\n     *\r\n     * For international phone number input, it will also auto-correct\r\n     * some minor errors such as using a national prefix when writing\r\n     * an international phone number. For example, if the user inputs\r\n     * `\"+44 0 7400 000000\"` then it will return an auto-corrected\r\n     * `\"+447400000000\"` phone number value.\r\n     *\r\n     * Will return `undefined` if no digits have been input,\r\n     * or when inputting a phone number in national format and no\r\n     * default country or default \"country calling code\" have been set.\r\n     *\r\n     * @return {string} [value]\r\n     */\n\n  }, {\n    key: \"getNumberValue\",\n    value: function getNumberValue() {\n      var _this$state2 = this.state,\n          digits = _this$state2.digits,\n          callingCode = _this$state2.callingCode,\n          country = _this$state2.country,\n          nationalSignificantNumber = _this$state2.nationalSignificantNumber; // Will return `undefined` if no digits have been input.\n\n      if (!digits) {\n        return;\n      }\n\n      if (this.isInternational()) {\n        if (callingCode) {\n          return '+' + callingCode + nationalSignificantNumber;\n        } else {\n          return '+' + digits;\n        }\n      } else {\n        if (country || callingCode) {\n          var callingCode_ = country ? this.metadata.countryCallingCode() : callingCode;\n          return '+' + callingCode_ + nationalSignificantNumber;\n        }\n      }\n    }\n    /**\r\n     * Returns an instance of `PhoneNumber` class.\r\n     * Will return `undefined` if no national (significant) number\r\n     * digits have been entered so far, or if no `defaultCountry` has been\r\n     * set and the user enters a phone number not in international format.\r\n     */\n\n  }, {\n    key: \"getNumber\",\n    value: function getNumber() {\n      var _this$state3 = this.state,\n          nationalSignificantNumber = _this$state3.nationalSignificantNumber,\n          carrierCode = _this$state3.carrierCode,\n          callingCode = _this$state3.callingCode; // `this._getCountry()` is basically same as `this.state.country`\n      // with the only change that it return `undefined` in case of a\n      // \"non-geographic\" numbering plan instead of `\"001\"` \"internal use\" value.\n\n      var country = this._getCountry();\n\n      if (!nationalSignificantNumber) {\n        return;\n      } // `state.country` and `state.callingCode` aren't required to be in sync.\n      // For example, `country` could be `\"AR\"` and `callingCode` could be `undefined`.\n      // So `country` and `callingCode` are totally independent.\n\n\n      if (!country && !callingCode) {\n        return;\n      } // By default, if `defaultCountry` parameter was passed when\n      // creating `AsYouType` instance, `state.country` is gonna be\n      // that `defaultCountry`, which doesn't entirely conform with\n      // `parsePhoneNumber()`'s behavior where it attempts to determine\n      // the country more precisely in cases when multiple countries\n      // could correspond to the same `countryCallingCode`.\n      // https://gitlab.com/catamphetamine/libphonenumber-js/-/issues/103#note_1417192969\n      //\n      // Because `AsYouType.getNumber()` method is supposed to be a 1:1\n      // equivalent for `parsePhoneNumber(AsYouType.getNumberValue())`,\n      // then it should also behave accordingly in cases of `country` ambiguity.\n      // That's how users of this library would expect it to behave anyway.\n      //\n\n\n      if (country) {\n        if (country === this.defaultCountry) {\n          // `state.country` and `state.callingCode` aren't required to be in sync.\n          // For example, `state.country` could be `\"AR\"` and `state.callingCode` could be `undefined`.\n          // So `state.country` and `state.callingCode` are totally independent.\n          var metadata = new _metadata_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"](this.metadata.metadata);\n          metadata.selectNumberingPlan(country);\n\n          var _callingCode = metadata.numberingPlan.callingCode();\n\n          var ambiguousCountries = this.metadata.getCountryCodesForCallingCode(_callingCode);\n\n          if (ambiguousCountries.length > 1) {\n            var exactCountry = (0,_helpers_getCountryByNationalNumber_js__WEBPACK_IMPORTED_MODULE_7__[\"default\"])(nationalSignificantNumber, {\n              countries: ambiguousCountries,\n              defaultCountry: this.defaultCountry,\n              metadata: this.metadata.metadata\n            });\n\n            if (exactCountry) {\n              country = exactCountry;\n            }\n          }\n        }\n      }\n\n      var phoneNumber = new _PhoneNumber_js__WEBPACK_IMPORTED_MODULE_8__[\"default\"](country || callingCode, nationalSignificantNumber, this.metadata.metadata);\n\n      if (carrierCode) {\n        phoneNumber.carrierCode = carrierCode;\n      } // Phone number extensions are not supported by \"As You Type\" formatter.\n\n\n      return phoneNumber;\n    }\n    /**\r\n     * Returns `true` if the phone number is \"possible\".\r\n     * Is just a shortcut for `PhoneNumber.isPossible()`.\r\n     * @return {boolean}\r\n     */\n\n  }, {\n    key: \"isPossible\",\n    value: function isPossible() {\n      var phoneNumber = this.getNumber();\n\n      if (!phoneNumber) {\n        return false;\n      }\n\n      return phoneNumber.isPossible();\n    }\n    /**\r\n     * Returns `true` if the phone number is \"valid\".\r\n     * Is just a shortcut for `PhoneNumber.isValid()`.\r\n     * @return {boolean}\r\n     */\n\n  }, {\n    key: \"isValid\",\n    value: function isValid() {\n      var phoneNumber = this.getNumber();\n\n      if (!phoneNumber) {\n        return false;\n      }\n\n      return phoneNumber.isValid();\n    }\n    /**\r\n     * @deprecated\r\n     * This method is used in `react-phone-number-input/source/input-control.js`\r\n     * in versions before `3.0.16`.\r\n     */\n\n  }, {\n    key: \"getNationalNumber\",\n    value: function getNationalNumber() {\n      return this.state.nationalSignificantNumber;\n    }\n    /**\r\n     * Returns the phone number characters entered by the user.\r\n     * @return {string}\r\n     */\n\n  }, {\n    key: \"getChars\",\n    value: function getChars() {\n      return (this.state.international ? '+' : '') + this.state.digits;\n    }\n    /**\r\n     * Returns the template for the formatted phone number.\r\n     * @return {string}\r\n     */\n\n  }, {\n    key: \"getTemplate\",\n    value: function getTemplate() {\n      return this.formatter.getTemplate(this.state) || this.getNonFormattedTemplate() || '';\n    }\n  }]);\n\n  return AsYouType;\n}();\n\n\n//# sourceMappingURL=AsYouType.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/AsYouType.js\n");

/***/ }),

/***/ "(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/AsYouTypeFormatter.PatternMatcher.js":
/*!***********************************************************************************************************************************!*\
  !*** ../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/AsYouTypeFormatter.PatternMatcher.js ***!
  \***********************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ PatternMatcher)\n/* harmony export */ });\n/* harmony import */ var _AsYouTypeFormatter_PatternParser_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./AsYouTypeFormatter.PatternParser.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/AsYouTypeFormatter.PatternParser.js\");\nfunction _createForOfIteratorHelperLoose(o, allowArrayLike) { var it = typeof Symbol !== \"undefined\" && o[Symbol.iterator] || o[\"@@iterator\"]; if (it) return (it = it.call(o)).next.bind(it); if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === \"number\") { if (it) o = it; var i = 0; return function () { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }; } throw new TypeError(\"Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\n\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\n\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }\n\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, \"prototype\", { writable: false }); return Constructor; }\n\n\n\nvar PatternMatcher = /*#__PURE__*/function () {\n  function PatternMatcher(pattern) {\n    _classCallCheck(this, PatternMatcher);\n\n    this.matchTree = new _AsYouTypeFormatter_PatternParser_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"]().parse(pattern);\n  }\n\n  _createClass(PatternMatcher, [{\n    key: \"match\",\n    value: function match(string) {\n      var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},\n          allowOverflow = _ref.allowOverflow;\n\n      if (!string) {\n        throw new Error('String is required');\n      }\n\n      var result = _match(string.split(''), this.matchTree, true);\n\n      if (result && result.match) {\n        delete result.matchedChars;\n      }\n\n      if (result && result.overflow) {\n        if (!allowOverflow) {\n          return;\n        }\n      }\n\n      return result;\n    }\n  }]);\n\n  return PatternMatcher;\n}();\n/**\r\n * Matches `characters` against a pattern compiled into a `tree`.\r\n * @param  {string[]} characters\r\n * @param  {Tree} tree — A pattern compiled into a `tree`. See the `*.d.ts` file for the description of the `tree` structure.\r\n * @param  {boolean} last — Whether it's the last (rightmost) subtree on its level of the match tree.\r\n * @return {object} See the `*.d.ts` file for the description of the result object.\r\n */\n\n\n\n\nfunction _match(characters, tree, last) {\n  // If `tree` is a string, then `tree` is a single character.\n  // That's because when a pattern is parsed, multi-character-string parts\n  // of a pattern are compiled into arrays of single characters.\n  // I still wrote this piece of code for a \"general\" hypothetical case\n  // when `tree` could be a string of several characters, even though\n  // such case is not possible with the current implementation.\n  if (typeof tree === 'string') {\n    var characterString = characters.join('');\n\n    if (tree.indexOf(characterString) === 0) {\n      // `tree` is always a single character.\n      // If `tree.indexOf(characterString) === 0`\n      // then `characters.length === tree.length`.\n\n      /* istanbul ignore else */\n      if (characters.length === tree.length) {\n        return {\n          match: true,\n          matchedChars: characters\n        };\n      } // `tree` is always a single character.\n      // If `tree.indexOf(characterString) === 0`\n      // then `characters.length === tree.length`.\n\n      /* istanbul ignore next */\n\n\n      return {\n        partialMatch: true // matchedChars: characters\n\n      };\n    }\n\n    if (characterString.indexOf(tree) === 0) {\n      if (last) {\n        // The `else` path is not possible because `tree` is always a single character.\n        // The `else` case for `characters.length > tree.length` would be\n        // `characters.length <= tree.length` which means `characters.length <= 1`.\n        // `characters` array can't be empty, so that means `characters === [tree]`,\n        // which would also mean `tree.indexOf(characterString) === 0` and that'd mean\n        // that the `if (tree.indexOf(characterString) === 0)` condition before this\n        // `if` condition would be entered, and returned from there, not reaching this code.\n\n        /* istanbul ignore else */\n        if (characters.length > tree.length) {\n          return {\n            overflow: true\n          };\n        }\n      }\n\n      return {\n        match: true,\n        matchedChars: characters.slice(0, tree.length)\n      };\n    }\n\n    return;\n  }\n\n  if (Array.isArray(tree)) {\n    var restCharacters = characters.slice();\n    var i = 0;\n\n    while (i < tree.length) {\n      var subtree = tree[i];\n\n      var result = _match(restCharacters, subtree, last && i === tree.length - 1);\n\n      if (!result) {\n        return;\n      } else if (result.overflow) {\n        return result;\n      } else if (result.match) {\n        // Continue with the next subtree with the rest of the characters.\n        restCharacters = restCharacters.slice(result.matchedChars.length);\n\n        if (restCharacters.length === 0) {\n          if (i === tree.length - 1) {\n            return {\n              match: true,\n              matchedChars: characters\n            };\n          } else {\n            return {\n              partialMatch: true // matchedChars: characters\n\n            };\n          }\n        }\n      } else {\n        /* istanbul ignore else */\n        if (result.partialMatch) {\n          return {\n            partialMatch: true // matchedChars: characters\n\n          };\n        } else {\n          throw new Error(\"Unsupported match result:\\n\".concat(JSON.stringify(result, null, 2)));\n        }\n      }\n\n      i++;\n    } // If `last` then overflow has already been checked\n    // by the last element of the `tree` array.\n\n    /* istanbul ignore if */\n\n\n    if (last) {\n      return {\n        overflow: true\n      };\n    }\n\n    return {\n      match: true,\n      matchedChars: characters.slice(0, characters.length - restCharacters.length)\n    };\n  }\n\n  switch (tree.op) {\n    case '|':\n      var partialMatch;\n\n      for (var _iterator = _createForOfIteratorHelperLoose(tree.args), _step; !(_step = _iterator()).done;) {\n        var branch = _step.value;\n\n        var _result = _match(characters, branch, last);\n\n        if (_result) {\n          if (_result.overflow) {\n            return _result;\n          } else if (_result.match) {\n            return {\n              match: true,\n              matchedChars: _result.matchedChars\n            };\n          } else {\n            /* istanbul ignore else */\n            if (_result.partialMatch) {\n              partialMatch = true;\n            } else {\n              throw new Error(\"Unsupported match result:\\n\".concat(JSON.stringify(_result, null, 2)));\n            }\n          }\n        }\n      }\n\n      if (partialMatch) {\n        return {\n          partialMatch: true // matchedChars: ...\n\n        };\n      } // Not even a partial match.\n\n\n      return;\n\n    case '[]':\n      for (var _iterator2 = _createForOfIteratorHelperLoose(tree.args), _step2; !(_step2 = _iterator2()).done;) {\n        var _char = _step2.value;\n\n        if (characters[0] === _char) {\n          if (characters.length === 1) {\n            return {\n              match: true,\n              matchedChars: characters\n            };\n          }\n\n          if (last) {\n            return {\n              overflow: true\n            };\n          }\n\n          return {\n            match: true,\n            matchedChars: [_char]\n          };\n        }\n      } // No character matches.\n\n\n      return;\n\n    /* istanbul ignore next */\n\n    default:\n      throw new Error(\"Unsupported instruction tree: \".concat(tree));\n  }\n}\n//# sourceMappingURL=AsYouTypeFormatter.PatternMatcher.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/AsYouTypeFormatter.PatternMatcher.js\n");

/***/ }),

/***/ "(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/AsYouTypeFormatter.PatternParser.js":
/*!**********************************************************************************************************************************!*\
  !*** ../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/AsYouTypeFormatter.PatternParser.js ***!
  \**********************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ PatternParser)\n/* harmony export */ });\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, \"prototype\", { writable: false }); return Constructor; }\n\nvar PatternParser = /*#__PURE__*/function () {\n  function PatternParser() {\n    _classCallCheck(this, PatternParser);\n  }\n\n  _createClass(PatternParser, [{\n    key: \"parse\",\n    value: function parse(pattern) {\n      this.context = [{\n        or: true,\n        instructions: []\n      }];\n      this.parsePattern(pattern);\n\n      if (this.context.length !== 1) {\n        throw new Error('Non-finalized contexts left when pattern parse ended');\n      }\n\n      var _this$context$ = this.context[0],\n          branches = _this$context$.branches,\n          instructions = _this$context$.instructions;\n\n      if (branches) {\n        return {\n          op: '|',\n          args: branches.concat([expandSingleElementArray(instructions)])\n        };\n      }\n      /* istanbul ignore if */\n\n\n      if (instructions.length === 0) {\n        throw new Error('Pattern is required');\n      }\n\n      if (instructions.length === 1) {\n        return instructions[0];\n      }\n\n      return instructions;\n    }\n  }, {\n    key: \"startContext\",\n    value: function startContext(context) {\n      this.context.push(context);\n    }\n  }, {\n    key: \"endContext\",\n    value: function endContext() {\n      this.context.pop();\n    }\n  }, {\n    key: \"getContext\",\n    value: function getContext() {\n      return this.context[this.context.length - 1];\n    }\n  }, {\n    key: \"parsePattern\",\n    value: function parsePattern(pattern) {\n      if (!pattern) {\n        throw new Error('Pattern is required');\n      }\n\n      var match = pattern.match(OPERATOR);\n\n      if (!match) {\n        if (ILLEGAL_CHARACTER_REGEXP.test(pattern)) {\n          throw new Error(\"Illegal characters found in a pattern: \".concat(pattern));\n        }\n\n        this.getContext().instructions = this.getContext().instructions.concat(pattern.split(''));\n        return;\n      }\n\n      var operator = match[1];\n      var before = pattern.slice(0, match.index);\n      var rightPart = pattern.slice(match.index + operator.length);\n\n      switch (operator) {\n        case '(?:':\n          if (before) {\n            this.parsePattern(before);\n          }\n\n          this.startContext({\n            or: true,\n            instructions: [],\n            branches: []\n          });\n          break;\n\n        case ')':\n          if (!this.getContext().or) {\n            throw new Error('\")\" operator must be preceded by \"(?:\" operator');\n          }\n\n          if (before) {\n            this.parsePattern(before);\n          }\n\n          if (this.getContext().instructions.length === 0) {\n            throw new Error('No instructions found after \"|\" operator in an \"or\" group');\n          }\n\n          var _this$getContext = this.getContext(),\n              branches = _this$getContext.branches;\n\n          branches.push(expandSingleElementArray(this.getContext().instructions));\n          this.endContext();\n          this.getContext().instructions.push({\n            op: '|',\n            args: branches\n          });\n          break;\n\n        case '|':\n          if (!this.getContext().or) {\n            throw new Error('\"|\" operator can only be used inside \"or\" groups');\n          }\n\n          if (before) {\n            this.parsePattern(before);\n          } // The top-level is an implicit \"or\" group, if required.\n\n\n          if (!this.getContext().branches) {\n            // `branches` are not defined only for the root implicit \"or\" operator.\n\n            /* istanbul ignore else */\n            if (this.context.length === 1) {\n              this.getContext().branches = [];\n            } else {\n              throw new Error('\"branches\" not found in an \"or\" group context');\n            }\n          }\n\n          this.getContext().branches.push(expandSingleElementArray(this.getContext().instructions));\n          this.getContext().instructions = [];\n          break;\n\n        case '[':\n          if (before) {\n            this.parsePattern(before);\n          }\n\n          this.startContext({\n            oneOfSet: true\n          });\n          break;\n\n        case ']':\n          if (!this.getContext().oneOfSet) {\n            throw new Error('\"]\" operator must be preceded by \"[\" operator');\n          }\n\n          this.endContext();\n          this.getContext().instructions.push({\n            op: '[]',\n            args: parseOneOfSet(before)\n          });\n          break;\n\n        /* istanbul ignore next */\n\n        default:\n          throw new Error(\"Unknown operator: \".concat(operator));\n      }\n\n      if (rightPart) {\n        this.parsePattern(rightPart);\n      }\n    }\n  }]);\n\n  return PatternParser;\n}();\n\n\n\nfunction parseOneOfSet(pattern) {\n  var values = [];\n  var i = 0;\n\n  while (i < pattern.length) {\n    if (pattern[i] === '-') {\n      if (i === 0 || i === pattern.length - 1) {\n        throw new Error(\"Couldn't parse a one-of set pattern: \".concat(pattern));\n      }\n\n      var prevValue = pattern[i - 1].charCodeAt(0) + 1;\n      var nextValue = pattern[i + 1].charCodeAt(0) - 1;\n      var value = prevValue;\n\n      while (value <= nextValue) {\n        values.push(String.fromCharCode(value));\n        value++;\n      }\n    } else {\n      values.push(pattern[i]);\n    }\n\n    i++;\n  }\n\n  return values;\n}\n\nvar ILLEGAL_CHARACTER_REGEXP = /[\\(\\)\\[\\]\\?\\:\\|]/;\nvar OPERATOR = new RegExp( // any of:\n'(' + // or operator\n'\\\\|' + // or\n'|' + // or group start\n'\\\\(\\\\?\\\\:' + // or\n'|' + // or group end\n'\\\\)' + // or\n'|' + // one-of set start\n'\\\\[' + // or\n'|' + // one-of set end\n'\\\\]' + ')');\n\nfunction expandSingleElementArray(array) {\n  if (array.length === 1) {\n    return array[0];\n  }\n\n  return array;\n}\n//# sourceMappingURL=AsYouTypeFormatter.PatternParser.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/AsYouTypeFormatter.PatternParser.js\n");

/***/ }),

/***/ "(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/AsYouTypeFormatter.complete.js":
/*!*****************************************************************************************************************************!*\
  !*** ../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/AsYouTypeFormatter.complete.js ***!
  \*****************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   canFormatCompleteNumber: () => (/* binding */ canFormatCompleteNumber),\n/* harmony export */   \"default\": () => (/* binding */ formatCompleteNumber)\n/* harmony export */ });\n/* harmony import */ var _helpers_checkNumberLength_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./helpers/checkNumberLength.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/checkNumberLength.js\");\n/* harmony import */ var _helpers_parseDigits_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./helpers/parseDigits.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/parseDigits.js\");\n/* harmony import */ var _helpers_formatNationalNumberUsingFormat_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./helpers/formatNationalNumberUsingFormat.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/formatNationalNumberUsingFormat.js\");\n\n\n\nfunction formatCompleteNumber(state, format, _ref) {\n  var metadata = _ref.metadata,\n      shouldTryNationalPrefixFormattingRule = _ref.shouldTryNationalPrefixFormattingRule,\n      getSeparatorAfterNationalPrefix = _ref.getSeparatorAfterNationalPrefix;\n  var matcher = new RegExp(\"^(?:\".concat(format.pattern(), \")$\"));\n\n  if (matcher.test(state.nationalSignificantNumber)) {\n    return formatNationalNumberWithAndWithoutNationalPrefixFormattingRule(state, format, {\n      metadata: metadata,\n      shouldTryNationalPrefixFormattingRule: shouldTryNationalPrefixFormattingRule,\n      getSeparatorAfterNationalPrefix: getSeparatorAfterNationalPrefix\n    });\n  }\n}\nfunction canFormatCompleteNumber(nationalSignificantNumber, metadata) {\n  return (0,_helpers_checkNumberLength_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(nationalSignificantNumber, metadata) === 'IS_POSSIBLE';\n}\n\nfunction formatNationalNumberWithAndWithoutNationalPrefixFormattingRule(state, format, _ref2) {\n  var metadata = _ref2.metadata,\n      shouldTryNationalPrefixFormattingRule = _ref2.shouldTryNationalPrefixFormattingRule,\n      getSeparatorAfterNationalPrefix = _ref2.getSeparatorAfterNationalPrefix;\n  // `format` has already been checked for `nationalPrefix` requirement.\n  var nationalSignificantNumber = state.nationalSignificantNumber,\n      international = state.international,\n      nationalPrefix = state.nationalPrefix,\n      carrierCode = state.carrierCode; // Format the number with using `national_prefix_formatting_rule`.\n  // If the resulting formatted number is a valid formatted number, then return it.\n  //\n  // Google's AsYouType formatter is different in a way that it doesn't try\n  // to format using the \"national prefix formatting rule\", and instead it\n  // simply prepends a national prefix followed by a \" \" character.\n  // This code does that too, but as a fallback.\n  // The reason is that \"national prefix formatting rule\" may use parentheses,\n  // which wouldn't be included has it used the simpler Google's way.\n  //\n\n  if (shouldTryNationalPrefixFormattingRule(format)) {\n    var formattedNumber = formatNationalNumber(state, format, {\n      useNationalPrefixFormattingRule: true,\n      getSeparatorAfterNationalPrefix: getSeparatorAfterNationalPrefix,\n      metadata: metadata\n    });\n\n    if (formattedNumber) {\n      return formattedNumber;\n    }\n  } // Format the number without using `national_prefix_formatting_rule`.\n\n\n  return formatNationalNumber(state, format, {\n    useNationalPrefixFormattingRule: false,\n    getSeparatorAfterNationalPrefix: getSeparatorAfterNationalPrefix,\n    metadata: metadata\n  });\n}\n\nfunction formatNationalNumber(state, format, _ref3) {\n  var metadata = _ref3.metadata,\n      useNationalPrefixFormattingRule = _ref3.useNationalPrefixFormattingRule,\n      getSeparatorAfterNationalPrefix = _ref3.getSeparatorAfterNationalPrefix;\n  var formattedNationalNumber = (0,_helpers_formatNationalNumberUsingFormat_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(state.nationalSignificantNumber, format, {\n    carrierCode: state.carrierCode,\n    useInternationalFormat: state.international,\n    withNationalPrefix: useNationalPrefixFormattingRule,\n    metadata: metadata\n  });\n\n  if (!useNationalPrefixFormattingRule) {\n    if (state.nationalPrefix) {\n      // If a national prefix was extracted, then just prepend it,\n      // followed by a \" \" character.\n      formattedNationalNumber = state.nationalPrefix + getSeparatorAfterNationalPrefix(format) + formattedNationalNumber;\n    } else if (state.complexPrefixBeforeNationalSignificantNumber) {\n      formattedNationalNumber = state.complexPrefixBeforeNationalSignificantNumber + ' ' + formattedNationalNumber;\n    }\n  }\n\n  if (isValidFormattedNationalNumber(formattedNationalNumber, state)) {\n    return formattedNationalNumber;\n  }\n} // Check that the formatted phone number contains exactly\n// the same digits that have been input by the user.\n// For example, when \"0111523456789\" is input for `AR` country,\n// the extracted `this.nationalSignificantNumber` is \"91123456789\",\n// which means that the national part of `this.digits` isn't simply equal to\n// `this.nationalPrefix` + `this.nationalSignificantNumber`.\n//\n// Also, a `format` can add extra digits to the `this.nationalSignificantNumber`\n// being formatted via `metadata[country].national_prefix_transform_rule`.\n// For example, for `VI` country, it prepends `340` to the national number,\n// and if this check hasn't been implemented, then there would be a bug\n// when `340` \"area coude\" is \"duplicated\" during input for `VI` country:\n// https://github.com/catamphetamine/libphonenumber-js/issues/318\n//\n// So, all these \"gotchas\" are filtered out.\n//\n// In the original Google's code, the comments say:\n// \"Check that we didn't remove nor add any extra digits when we matched\n// this formatting pattern. This usually happens after we entered the last\n// digit during AYTF. Eg: In case of MX, we swallow mobile token (1) when\n// formatted but AYTF should retain all the number entered and not change\n// in order to match a format (of same leading digits and length) display\n// in that way.\"\n// \"If it's the same (i.e entered number and format is same), then it's\n// safe to return this in formatted number as nothing is lost / added.\"\n// Otherwise, don't use this format.\n// https://github.com/google/libphonenumber/commit/3e7c1f04f5e7200f87fb131e6f85c6e99d60f510#diff-9149457fa9f5d608a11bb975c6ef4bc5\n// https://github.com/google/libphonenumber/commit/3ac88c7106e7dcb553bcc794b15f19185928a1c6#diff-2dcb77e833422ee304da348b905cde0b\n//\n\n\nfunction isValidFormattedNationalNumber(formattedNationalNumber, state) {\n  return (0,_helpers_parseDigits_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"])(formattedNationalNumber) === state.getNationalDigits();\n}\n//# sourceMappingURL=AsYouTypeFormatter.complete.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/AsYouTypeFormatter.complete.js\n");

/***/ }),

/***/ "(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/AsYouTypeFormatter.js":
/*!********************************************************************************************************************!*\
  !*** ../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/AsYouTypeFormatter.js ***!
  \********************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   DIGIT_PLACEHOLDER: () => (/* reexport safe */ _AsYouTypeFormatter_util_js__WEBPACK_IMPORTED_MODULE_0__.DIGIT_PLACEHOLDER),\n/* harmony export */   \"default\": () => (/* binding */ AsYouTypeFormatter)\n/* harmony export */ });\n/* harmony import */ var _AsYouTypeFormatter_util_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./AsYouTypeFormatter.util.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/AsYouTypeFormatter.util.js\");\n/* harmony import */ var _AsYouTypeFormatter_complete_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./AsYouTypeFormatter.complete.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/AsYouTypeFormatter.complete.js\");\n/* harmony import */ var _AsYouTypeFormatter_PatternMatcher_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./AsYouTypeFormatter.PatternMatcher.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/AsYouTypeFormatter.PatternMatcher.js\");\n/* harmony import */ var _helpers_parseDigits_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./helpers/parseDigits.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/parseDigits.js\");\n/* harmony import */ var _helpers_formatNationalNumberUsingFormat_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./helpers/formatNationalNumberUsingFormat.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/formatNationalNumberUsingFormat.js\");\n/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/constants.js\");\n/* harmony import */ var _helpers_applyInternationalSeparatorStyle_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./helpers/applyInternationalSeparatorStyle.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/applyInternationalSeparatorStyle.js\");\nfunction _createForOfIteratorHelperLoose(o, allowArrayLike) { var it = typeof Symbol !== \"undefined\" && o[Symbol.iterator] || o[\"@@iterator\"]; if (it) return (it = it.call(o)).next.bind(it); if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === \"number\") { if (it) o = it; var i = 0; return function () { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }; } throw new TypeError(\"Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\n\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\n\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }\n\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, \"prototype\", { writable: false }); return Constructor; }\n\n\n\n\n\n\n\n\n // Used in phone number format template creation.\n// Could be any digit, I guess.\n\nvar DUMMY_DIGIT = '9'; // I don't know why is it exactly `15`\n\nvar LONGEST_NATIONAL_PHONE_NUMBER_LENGTH = 15; // Create a phone number consisting only of the digit 9 that matches the\n// `number_pattern` by applying the pattern to the \"longest phone number\" string.\n\nvar LONGEST_DUMMY_PHONE_NUMBER = (0,_AsYouTypeFormatter_util_js__WEBPACK_IMPORTED_MODULE_0__.repeat)(DUMMY_DIGIT, LONGEST_NATIONAL_PHONE_NUMBER_LENGTH); // A set of characters that, if found in a national prefix formatting rules, are an indicator to\n// us that we should separate the national prefix from the number when formatting.\n\nvar NATIONAL_PREFIX_SEPARATORS_PATTERN = /[- ]/; // Deprecated: Google has removed some formatting pattern related code from their repo.\n// https://github.com/googlei18n/libphonenumber/commit/a395b4fef3caf57c4bc5f082e1152a4d2bd0ba4c\n// \"We no longer have numbers in formatting matching patterns, only \\d.\"\n// Because this library supports generating custom metadata\n// some users may still be using old metadata so the relevant\n// code seems to stay until some next major version update.\n\nvar SUPPORT_LEGACY_FORMATTING_PATTERNS = true; // A pattern that is used to match character classes in regular expressions.\n// An example of a character class is \"[1-4]\".\n\nvar CREATE_CHARACTER_CLASS_PATTERN = SUPPORT_LEGACY_FORMATTING_PATTERNS && function () {\n  return /\\[([^\\[\\]])*\\]/g;\n}; // Any digit in a regular expression that actually denotes a digit. For\n// example, in the regular expression \"80[0-2]\\d{6,10}\", the first 2 digits\n// (8 and 0) are standalone digits, but the rest are not.\n// Two look-aheads are needed because the number following \\\\d could be a\n// two-digit number, since the phone number can be as long as 15 digits.\n\n\nvar CREATE_STANDALONE_DIGIT_PATTERN = SUPPORT_LEGACY_FORMATTING_PATTERNS && function () {\n  return /\\d(?=[^,}][^,}])/g;\n}; // A regular expression that is used to determine if a `format` is\n// suitable to be used in the \"as you type formatter\".\n// A `format` is suitable when the resulting formatted number has\n// the same digits as the user has entered.\n//\n// In the simplest case, that would mean that the format\n// doesn't add any additional digits when formatting a number.\n// Google says that it also shouldn't add \"star\" (`*`) characters,\n// like it does in some Israeli formats.\n// Such basic format would only contain \"valid punctuation\"\n// and \"captured group\" identifiers ($1, $2, etc).\n//\n// An example of a format that adds additional digits:\n//\n// Country: `AR` (Argentina).\n// Format:\n// {\n//    \"pattern\": \"(\\\\d)(\\\\d{2})(\\\\d{4})(\\\\d{4})\",\n//    \"leading_digits_patterns\": [\"91\"],\n//    \"national_prefix_formatting_rule\": \"0$1\",\n//    \"format\": \"$2 15-$3-$4\",\n//    \"international_format\": \"$1 $2 $3-$4\"\n// }\n//\n// In the format above, the `format` adds `15` to the digits when formatting a number.\n// A sidenote: this format actually is suitable because `national_prefix_for_parsing`\n// has previously removed `15` from a national number, so re-adding `15` in `format`\n// doesn't actually result in any extra digits added to user's input.\n// But verifying that would be a complex procedure, so the code chooses a simpler path:\n// it simply filters out all `format`s that contain anything but \"captured group\" ids.\n//\n// This regular expression is called `ELIGIBLE_FORMAT_PATTERN` in Google's\n// `libphonenumber` code.\n//\n\n\nvar NON_ALTERING_FORMAT_REG_EXP = new RegExp('[' + _constants_js__WEBPACK_IMPORTED_MODULE_1__.VALID_PUNCTUATION + ']*' + // Google developers say:\n// \"We require that the first matching group is present in the\n//  output pattern to ensure no data is lost while formatting.\"\n'\\\\$1' + '[' + _constants_js__WEBPACK_IMPORTED_MODULE_1__.VALID_PUNCTUATION + ']*' + '(\\\\$\\\\d[' + _constants_js__WEBPACK_IMPORTED_MODULE_1__.VALID_PUNCTUATION + ']*)*' + '$'); // This is the minimum length of the leading digits of a phone number\n// to guarantee the first \"leading digits pattern\" for a phone number format\n// to be preemptive.\n\nvar MIN_LEADING_DIGITS_LENGTH = 3;\n\nvar AsYouTypeFormatter = /*#__PURE__*/function () {\n  function AsYouTypeFormatter(_ref) {\n    var state = _ref.state,\n        metadata = _ref.metadata;\n\n    _classCallCheck(this, AsYouTypeFormatter);\n\n    this.metadata = metadata;\n    this.resetFormat();\n  }\n\n  _createClass(AsYouTypeFormatter, [{\n    key: \"resetFormat\",\n    value: function resetFormat() {\n      this.chosenFormat = undefined;\n      this.template = undefined;\n      this.nationalNumberTemplate = undefined;\n      this.populatedNationalNumberTemplate = undefined;\n      this.populatedNationalNumberTemplatePosition = -1;\n    }\n  }, {\n    key: \"reset\",\n    value: function reset(numberingPlan, state) {\n      this.resetFormat();\n\n      if (numberingPlan) {\n        this.isNANP = numberingPlan.callingCode() === '1';\n        this.matchingFormats = numberingPlan.formats();\n\n        if (state.nationalSignificantNumber) {\n          this.narrowDownMatchingFormats(state);\n        }\n      } else {\n        this.isNANP = undefined;\n        this.matchingFormats = [];\n      }\n    }\n    /**\r\n     * Formats an updated phone number.\r\n     * @param  {string} nextDigits — Additional phone number digits.\r\n     * @param  {object} state — `AsYouType` state.\r\n     * @return {[string]} Returns undefined if the updated phone number can't be formatted using any of the available formats.\r\n     */\n\n  }, {\n    key: \"format\",\n    value: function format(nextDigits, state) {\n      var _this = this;\n\n      // See if the phone number digits can be formatted as a complete phone number.\n      // If not, use the results from `formatNationalNumberWithNextDigits()`,\n      // which formats based on the chosen formatting pattern.\n      //\n      // Attempting to format complete phone number first is how it's done\n      // in Google's `libphonenumber`, so this library just follows it.\n      // Google's `libphonenumber` code doesn't explain in detail why does it\n      // attempt to format digits as a complete phone number\n      // instead of just going with a previoulsy (or newly) chosen `format`:\n      //\n      // \"Checks to see if there is an exact pattern match for these digits.\n      //  If so, we should use this instead of any other formatting template\n      //  whose leadingDigitsPattern also matches the input.\"\n      //\n      if ((0,_AsYouTypeFormatter_complete_js__WEBPACK_IMPORTED_MODULE_2__.canFormatCompleteNumber)(state.nationalSignificantNumber, this.metadata)) {\n        for (var _iterator = _createForOfIteratorHelperLoose(this.matchingFormats), _step; !(_step = _iterator()).done;) {\n          var format = _step.value;\n          var formattedCompleteNumber = (0,_AsYouTypeFormatter_complete_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"])(state, format, {\n            metadata: this.metadata,\n            shouldTryNationalPrefixFormattingRule: function shouldTryNationalPrefixFormattingRule(format) {\n              return _this.shouldTryNationalPrefixFormattingRule(format, {\n                international: state.international,\n                nationalPrefix: state.nationalPrefix\n              });\n            },\n            getSeparatorAfterNationalPrefix: function getSeparatorAfterNationalPrefix(format) {\n              return _this.getSeparatorAfterNationalPrefix(format);\n            }\n          });\n\n          if (formattedCompleteNumber) {\n            this.resetFormat();\n            this.chosenFormat = format;\n            this.setNationalNumberTemplate(formattedCompleteNumber.replace(/\\d/g, _AsYouTypeFormatter_util_js__WEBPACK_IMPORTED_MODULE_0__.DIGIT_PLACEHOLDER), state);\n            this.populatedNationalNumberTemplate = formattedCompleteNumber; // With a new formatting template, the matched position\n            // using the old template needs to be reset.\n\n            this.populatedNationalNumberTemplatePosition = this.template.lastIndexOf(_AsYouTypeFormatter_util_js__WEBPACK_IMPORTED_MODULE_0__.DIGIT_PLACEHOLDER);\n            return formattedCompleteNumber;\n          }\n        }\n      } // Format the digits as a partial (incomplete) phone number\n      // using the previously chosen formatting pattern (or a newly chosen one).\n\n\n      return this.formatNationalNumberWithNextDigits(nextDigits, state);\n    } // Formats the next phone number digits.\n\n  }, {\n    key: \"formatNationalNumberWithNextDigits\",\n    value: function formatNationalNumberWithNextDigits(nextDigits, state) {\n      var previouslyChosenFormat = this.chosenFormat; // Choose a format from the list of matching ones.\n\n      var newlyChosenFormat = this.chooseFormat(state);\n\n      if (newlyChosenFormat) {\n        if (newlyChosenFormat === previouslyChosenFormat) {\n          // If it can format the next (current) digits\n          // using the previously chosen phone number format\n          // then return the updated formatted number.\n          return this.formatNextNationalNumberDigits(nextDigits);\n        } else {\n          // If a more appropriate phone number format\n          // has been chosen for these \"leading digits\",\n          // then re-format the national phone number part\n          // using the newly selected format.\n          return this.formatNextNationalNumberDigits(state.getNationalDigits());\n        }\n      }\n    }\n  }, {\n    key: \"narrowDownMatchingFormats\",\n    value: function narrowDownMatchingFormats(_ref2) {\n      var _this2 = this;\n\n      var nationalSignificantNumber = _ref2.nationalSignificantNumber,\n          nationalPrefix = _ref2.nationalPrefix,\n          international = _ref2.international;\n      var leadingDigits = nationalSignificantNumber; // \"leading digits\" pattern list starts with a\n      // \"leading digits\" pattern fitting a maximum of 3 leading digits.\n      // So, after a user inputs 3 digits of a national (significant) phone number\n      // this national (significant) number can already be formatted.\n      // The next \"leading digits\" pattern is for 4 leading digits max,\n      // and the \"leading digits\" pattern after it is for 5 leading digits max, etc.\n      // This implementation is different from Google's\n      // in that it searches for a fitting format\n      // even if the user has entered less than\n      // `MIN_LEADING_DIGITS_LENGTH` digits of a national number.\n      // Because some leading digit patterns already match for a single first digit.\n\n      var leadingDigitsPatternIndex = leadingDigits.length - MIN_LEADING_DIGITS_LENGTH;\n\n      if (leadingDigitsPatternIndex < 0) {\n        leadingDigitsPatternIndex = 0;\n      }\n\n      this.matchingFormats = this.matchingFormats.filter(function (format) {\n        return _this2.formatSuits(format, international, nationalPrefix) && _this2.formatMatches(format, leadingDigits, leadingDigitsPatternIndex);\n      }); // If there was a phone number format chosen\n      // and it no longer holds given the new leading digits then reset it.\n      // The test for this `if` condition is marked as:\n      // \"Reset a chosen format when it no longer holds given the new leading digits\".\n      // To construct a valid test case for this one can find a country\n      // in `PhoneNumberMetadata.xml` yielding one format for 3 `<leadingDigits>`\n      // and yielding another format for 4 `<leadingDigits>` (Australia in this case).\n\n      if (this.chosenFormat && this.matchingFormats.indexOf(this.chosenFormat) === -1) {\n        this.resetFormat();\n      }\n    }\n  }, {\n    key: \"formatSuits\",\n    value: function formatSuits(format, international, nationalPrefix) {\n      // When a prefix before a national (significant) number is\n      // simply a national prefix, then it's parsed as `this.nationalPrefix`.\n      // In more complex cases, a prefix before national (significant) number\n      // could include a national prefix as well as some \"capturing groups\",\n      // and in that case there's no info whether a national prefix has been parsed.\n      // If national prefix is not used when formatting a phone number\n      // using this format, but a national prefix has been entered by the user,\n      // and was extracted, then discard such phone number format.\n      // In Google's \"AsYouType\" formatter code, the equivalent would be this part:\n      // https://github.com/google/libphonenumber/blob/0a45cfd96e71cad8edb0e162a70fcc8bd9728933/java/libphonenumber/src/com/google/i18n/phonenumbers/AsYouTypeFormatter.java#L175-L184\n      if (nationalPrefix && !format.usesNationalPrefix() && // !format.domesticCarrierCodeFormattingRule() &&\n      !format.nationalPrefixIsOptionalWhenFormattingInNationalFormat()) {\n        return false;\n      } // If national prefix is mandatory for this phone number format\n      // and there're no guarantees that a national prefix is present in user input\n      // then discard this phone number format as not suitable.\n      // In Google's \"AsYouType\" formatter code, the equivalent would be this part:\n      // https://github.com/google/libphonenumber/blob/0a45cfd96e71cad8edb0e162a70fcc8bd9728933/java/libphonenumber/src/com/google/i18n/phonenumbers/AsYouTypeFormatter.java#L185-L193\n\n\n      if (!international && !nationalPrefix && format.nationalPrefixIsMandatoryWhenFormattingInNationalFormat()) {\n        return false;\n      }\n\n      return true;\n    }\n  }, {\n    key: \"formatMatches\",\n    value: function formatMatches(format, leadingDigits, leadingDigitsPatternIndex) {\n      var leadingDigitsPatternsCount = format.leadingDigitsPatterns().length; // If this format is not restricted to a certain\n      // leading digits pattern then it fits.\n      // The test case could be found by searching for \"leadingDigitsPatternsCount === 0\".\n\n      if (leadingDigitsPatternsCount === 0) {\n        return true;\n      } // Start narrowing down the list of possible formats based on the leading digits.\n      // (only previously matched formats take part in the narrowing down process)\n      // `leading_digits_patterns` start with 3 digits min\n      // and then go up from there one digit at a time.\n\n\n      leadingDigitsPatternIndex = Math.min(leadingDigitsPatternIndex, leadingDigitsPatternsCount - 1);\n      var leadingDigitsPattern = format.leadingDigitsPatterns()[leadingDigitsPatternIndex]; // Google imposes a requirement on the leading digits\n      // to be minimum 3 digits long in order to be eligible\n      // for checking those with a leading digits pattern.\n      //\n      // Since `leading_digits_patterns` start with 3 digits min,\n      // Google's original `libphonenumber` library only starts\n      // excluding any non-matching formats only when the\n      // national number entered so far is at least 3 digits long,\n      // otherwise format matching would give false negatives.\n      //\n      // For example, when the digits entered so far are `2`\n      // and the leading digits pattern is `21` –\n      // it's quite obvious in this case that the format could be the one\n      // but due to the absence of further digits it would give false negative.\n      //\n      // Also, `leading_digits_patterns` doesn't always correspond to a single\n      // digits count. For example, `60|8` pattern would already match `8`\n      // but the `60` part would require having at least two leading digits,\n      // so the whole pattern would require inputting two digits first in order to\n      // decide on whether it matches the input, even when the input is \"80\".\n      //\n      // This library — `libphonenumber-js` — allows filtering by `leading_digits_patterns`\n      // even when there's only 1 or 2 digits of the national (significant) number.\n      // To do that, it uses a non-strict pattern matcher written specifically for that.\n      //\n\n      if (leadingDigits.length < MIN_LEADING_DIGITS_LENGTH) {\n        // Before leading digits < 3 matching was implemented:\n        // return true\n        //\n        // After leading digits < 3 matching was implemented:\n        try {\n          return new _AsYouTypeFormatter_PatternMatcher_js__WEBPACK_IMPORTED_MODULE_3__[\"default\"](leadingDigitsPattern).match(leadingDigits, {\n            allowOverflow: true\n          }) !== undefined;\n        } catch (error)\n        /* istanbul ignore next */\n        {\n          // There's a slight possibility that there could be some undiscovered bug\n          // in the pattern matcher code. Since the \"leading digits < 3 matching\"\n          // feature is not \"essential\" for operation, it can fall back to the old way\n          // in case of any issues rather than halting the application's execution.\n          console.error(error);\n          return true;\n        }\n      } // If at least `MIN_LEADING_DIGITS_LENGTH` digits of a national number are\n      // available then use the usual regular expression matching.\n      //\n      // The whole pattern is wrapped in round brackets (`()`) because\n      // the pattern can use \"or\" operator (`|`) at the top level of the pattern.\n      //\n\n\n      return new RegExp(\"^(\".concat(leadingDigitsPattern, \")\")).test(leadingDigits);\n    }\n  }, {\n    key: \"getFormatFormat\",\n    value: function getFormatFormat(format, international) {\n      return international ? format.internationalFormat() : format.format();\n    }\n  }, {\n    key: \"chooseFormat\",\n    value: function chooseFormat(state) {\n      var _this3 = this;\n\n      var _loop = function _loop() {\n        var format = _step2.value;\n\n        // If this format is currently being used\n        // and is still suitable, then stick to it.\n        if (_this3.chosenFormat === format) {\n          return \"break\";\n        } // Sometimes, a formatting rule inserts additional digits in a phone number,\n        // and \"as you type\" formatter can't do that: it should only use the digits\n        // that the user has input.\n        //\n        // For example, in Argentina, there's a format for mobile phone numbers:\n        //\n        // {\n        //    \"pattern\": \"(\\\\d)(\\\\d{2})(\\\\d{4})(\\\\d{4})\",\n        //    \"leading_digits_patterns\": [\"91\"],\n        //    \"national_prefix_formatting_rule\": \"0$1\",\n        //    \"format\": \"$2 15-$3-$4\",\n        //    \"international_format\": \"$1 $2 $3-$4\"\n        // }\n        //\n        // In that format, `international_format` is used instead of `format`\n        // because `format` inserts `15` in the formatted number,\n        // and `AsYouType` formatter should only use the digits\n        // the user has actually input, without adding any extra digits.\n        // In this case, it wouldn't make a difference, because the `15`\n        // is first stripped when applying `national_prefix_for_parsing`\n        // and then re-added when using `format`, so in reality it doesn't\n        // add any new digits to the number, but to detect that, the code\n        // would have to be more complex: it would have to try formatting\n        // the digits using the format and then see if any digits have\n        // actually been added or removed, and then, every time a new digit\n        // is input, it should re-check whether the chosen format doesn't\n        // alter the digits.\n        //\n        // Google's code doesn't go that far, and so does this library:\n        // it simply requires that a `format` doesn't add any additonal\n        // digits to user's input.\n        //\n        // Also, people in general should move from inputting phone numbers\n        // in national format (possibly with national prefixes)\n        // and use international phone number format instead:\n        // it's a logical thing in the modern age of mobile phones,\n        // globalization and the internet.\n        //\n\n        /* istanbul ignore if */\n\n\n        if (!NON_ALTERING_FORMAT_REG_EXP.test(_this3.getFormatFormat(format, state.international))) {\n          return \"continue\";\n        }\n\n        if (!_this3.createTemplateForFormat(format, state)) {\n          // Remove the format if it can't generate a template.\n          _this3.matchingFormats = _this3.matchingFormats.filter(function (_) {\n            return _ !== format;\n          });\n          return \"continue\";\n        }\n\n        _this3.chosenFormat = format;\n        return \"break\";\n      };\n\n      // When there are multiple available formats, the formatter uses the first\n      // format where a formatting template could be created.\n      //\n      // For some weird reason, `istanbul` says \"else path not taken\"\n      // for the `for of` line below. Supposedly that means that\n      // the loop doesn't ever go over the last element in the list.\n      // That's true because there always is `this.chosenFormat`\n      // when `this.matchingFormats` is non-empty.\n      // And, for some weird reason, it doesn't think that the case\n      // with empty `this.matchingFormats` qualifies for a valid \"else\" path.\n      // So simply muting this `istanbul` warning.\n      // It doesn't skip the contents of the `for of` loop,\n      // it just skips the `for of` line.\n      //\n\n      /* istanbul ignore next */\n      for (var _iterator2 = _createForOfIteratorHelperLoose(this.matchingFormats.slice()), _step2; !(_step2 = _iterator2()).done;) {\n        var _ret = _loop();\n\n        if (_ret === \"break\") break;\n        if (_ret === \"continue\") continue;\n      }\n\n      if (!this.chosenFormat) {\n        // No format matches the national (significant) phone number.\n        this.resetFormat();\n      }\n\n      return this.chosenFormat;\n    }\n  }, {\n    key: \"createTemplateForFormat\",\n    value: function createTemplateForFormat(format, state) {\n      // The formatter doesn't format numbers when numberPattern contains '|', e.g.\n      // (20|3)\\d{4}. In those cases we quickly return.\n      // (Though there's no such format in current metadata)\n\n      /* istanbul ignore if */\n      if (SUPPORT_LEGACY_FORMATTING_PATTERNS && format.pattern().indexOf('|') >= 0) {\n        return;\n      } // Get formatting template for this phone number format\n\n\n      var template = this.getTemplateForFormat(format, state); // If the national number entered is too long\n      // for any phone number format, then abort.\n\n      if (template) {\n        this.setNationalNumberTemplate(template, state);\n        return true;\n      }\n    }\n  }, {\n    key: \"getSeparatorAfterNationalPrefix\",\n    value: function getSeparatorAfterNationalPrefix(format) {\n      // `US` metadata doesn't have a `national_prefix_formatting_rule`,\n      // so the `if` condition below doesn't apply to `US`,\n      // but in reality there shoudl be a separator\n      // between a national prefix and a national (significant) number.\n      // So `US` national prefix separator is a \"special\" \"hardcoded\" case.\n      if (this.isNANP) {\n        return ' ';\n      } // If a `format` has a `national_prefix_formatting_rule`\n      // and that rule has a separator after a national prefix,\n      // then it means that there should be a separator\n      // between a national prefix and a national (significant) number.\n\n\n      if (format && format.nationalPrefixFormattingRule() && NATIONAL_PREFIX_SEPARATORS_PATTERN.test(format.nationalPrefixFormattingRule())) {\n        return ' ';\n      } // At this point, there seems to be no clear evidence that\n      // there should be a separator between a national prefix\n      // and a national (significant) number. So don't insert one.\n\n\n      return '';\n    }\n  }, {\n    key: \"getInternationalPrefixBeforeCountryCallingCode\",\n    value: function getInternationalPrefixBeforeCountryCallingCode(_ref3, options) {\n      var IDDPrefix = _ref3.IDDPrefix,\n          missingPlus = _ref3.missingPlus;\n\n      if (IDDPrefix) {\n        return options && options.spacing === false ? IDDPrefix : IDDPrefix + ' ';\n      }\n\n      if (missingPlus) {\n        return '';\n      }\n\n      return '+';\n    }\n  }, {\n    key: \"getTemplate\",\n    value: function getTemplate(state) {\n      if (!this.template) {\n        return;\n      } // `this.template` holds the template for a \"complete\" phone number.\n      // The currently entered phone number is most likely not \"complete\",\n      // so trim all non-populated digits.\n\n\n      var index = -1;\n      var i = 0;\n      var internationalPrefix = state.international ? this.getInternationalPrefixBeforeCountryCallingCode(state, {\n        spacing: false\n      }) : '';\n\n      while (i < internationalPrefix.length + state.getDigitsWithoutInternationalPrefix().length) {\n        index = this.template.indexOf(_AsYouTypeFormatter_util_js__WEBPACK_IMPORTED_MODULE_0__.DIGIT_PLACEHOLDER, index + 1);\n        i++;\n      }\n\n      return (0,_AsYouTypeFormatter_util_js__WEBPACK_IMPORTED_MODULE_0__.cutAndStripNonPairedParens)(this.template, index + 1);\n    }\n  }, {\n    key: \"setNationalNumberTemplate\",\n    value: function setNationalNumberTemplate(template, state) {\n      this.nationalNumberTemplate = template;\n      this.populatedNationalNumberTemplate = template; // With a new formatting template, the matched position\n      // using the old template needs to be reset.\n\n      this.populatedNationalNumberTemplatePosition = -1; // For convenience, the public `.template` property\n      // contains the whole international number\n      // if the phone number being input is international:\n      // 'x' for the '+' sign, 'x'es for the country phone code,\n      // a spacebar and then the template for the formatted national number.\n\n      if (state.international) {\n        this.template = this.getInternationalPrefixBeforeCountryCallingCode(state).replace(/[\\d\\+]/g, _AsYouTypeFormatter_util_js__WEBPACK_IMPORTED_MODULE_0__.DIGIT_PLACEHOLDER) + (0,_AsYouTypeFormatter_util_js__WEBPACK_IMPORTED_MODULE_0__.repeat)(_AsYouTypeFormatter_util_js__WEBPACK_IMPORTED_MODULE_0__.DIGIT_PLACEHOLDER, state.callingCode.length) + ' ' + template;\n      } else {\n        this.template = template;\n      }\n    }\n    /**\r\n     * Generates formatting template for a national phone number,\r\n     * optionally containing a national prefix, for a format.\r\n     * @param  {Format} format\r\n     * @param  {string} nationalPrefix\r\n     * @return {string}\r\n     */\n\n  }, {\n    key: \"getTemplateForFormat\",\n    value: function getTemplateForFormat(format, _ref4) {\n      var nationalSignificantNumber = _ref4.nationalSignificantNumber,\n          international = _ref4.international,\n          nationalPrefix = _ref4.nationalPrefix,\n          complexPrefixBeforeNationalSignificantNumber = _ref4.complexPrefixBeforeNationalSignificantNumber;\n      var pattern = format.pattern();\n      /* istanbul ignore else */\n\n      if (SUPPORT_LEGACY_FORMATTING_PATTERNS) {\n        pattern = pattern // Replace anything in the form of [..] with \\d\n        .replace(CREATE_CHARACTER_CLASS_PATTERN(), '\\\\d') // Replace any standalone digit (not the one in `{}`) with \\d\n        .replace(CREATE_STANDALONE_DIGIT_PATTERN(), '\\\\d');\n      } // Generate a dummy national number (consisting of `9`s)\n      // that fits this format's `pattern`.\n      //\n      // This match will always succeed,\n      // because the \"longest dummy phone number\"\n      // has enough length to accomodate any possible\n      // national phone number format pattern.\n      //\n\n\n      var digits = LONGEST_DUMMY_PHONE_NUMBER.match(pattern)[0]; // If the national number entered is too long\n      // for any phone number format, then abort.\n\n      if (nationalSignificantNumber.length > digits.length) {\n        return;\n      } // Get a formatting template which can be used to efficiently format\n      // a partial number where digits are added one by one.\n      // Below `strictPattern` is used for the\n      // regular expression (with `^` and `$`).\n      // This wasn't originally in Google's `libphonenumber`\n      // and I guess they don't really need it\n      // because they're not using \"templates\" to format phone numbers\n      // but I added `strictPattern` after encountering\n      // South Korean phone number formatting bug.\n      //\n      // Non-strict regular expression bug demonstration:\n      //\n      // this.nationalSignificantNumber : `111111111` (9 digits)\n      //\n      // pattern : (\\d{2})(\\d{3,4})(\\d{4})\n      // format : `$1 $2 $3`\n      // digits : `9999999999` (10 digits)\n      //\n      // '9999999999'.replace(new RegExp(/(\\d{2})(\\d{3,4})(\\d{4})/g), '$1 $2 $3') = \"99 9999 9999\"\n      //\n      // template : xx xxxx xxxx\n      //\n      // But the correct template in this case is `xx xxx xxxx`.\n      // The template was generated incorrectly because of the\n      // `{3,4}` variability in the `pattern`.\n      //\n      // The fix is, if `this.nationalSignificantNumber` has already sufficient length\n      // to satisfy the `pattern` completely then `this.nationalSignificantNumber`\n      // is used instead of `digits`.\n\n\n      var strictPattern = new RegExp('^' + pattern + '$');\n      var nationalNumberDummyDigits = nationalSignificantNumber.replace(/\\d/g, DUMMY_DIGIT); // If `this.nationalSignificantNumber` has already sufficient length\n      // to satisfy the `pattern` completely then use it\n      // instead of `digits`.\n\n      if (strictPattern.test(nationalNumberDummyDigits)) {\n        digits = nationalNumberDummyDigits;\n      }\n\n      var numberFormat = this.getFormatFormat(format, international);\n      var nationalPrefixIncludedInTemplate; // If a user did input a national prefix (and that's guaranteed),\n      // and if a `format` does have a national prefix formatting rule,\n      // then see if that national prefix formatting rule\n      // prepends exactly the same national prefix the user has input.\n      // If that's the case, then use the `format` with the national prefix formatting rule.\n      // Otherwise, use  the `format` without the national prefix formatting rule,\n      // and prepend a national prefix manually to it.\n\n      if (this.shouldTryNationalPrefixFormattingRule(format, {\n        international: international,\n        nationalPrefix: nationalPrefix\n      })) {\n        var numberFormatWithNationalPrefix = numberFormat.replace(_helpers_formatNationalNumberUsingFormat_js__WEBPACK_IMPORTED_MODULE_4__.FIRST_GROUP_PATTERN, format.nationalPrefixFormattingRule()); // If `national_prefix_formatting_rule` of a `format` simply prepends\n        // national prefix at the start of a national (significant) number,\n        // then such formatting can be used with `AsYouType` formatter.\n        // There seems to be no `else` case: everywhere in metadata,\n        // national prefix formatting rule is national prefix + $1,\n        // or `($1)`, in which case such format isn't even considered\n        // when the user has input a national prefix.\n\n        /* istanbul ignore else */\n\n        if ((0,_helpers_parseDigits_js__WEBPACK_IMPORTED_MODULE_5__[\"default\"])(format.nationalPrefixFormattingRule()) === (nationalPrefix || '') + (0,_helpers_parseDigits_js__WEBPACK_IMPORTED_MODULE_5__[\"default\"])('$1')) {\n          numberFormat = numberFormatWithNationalPrefix;\n          nationalPrefixIncludedInTemplate = true; // Replace all digits of the national prefix in the formatting template\n          // with `DIGIT_PLACEHOLDER`s.\n\n          if (nationalPrefix) {\n            var i = nationalPrefix.length;\n\n            while (i > 0) {\n              numberFormat = numberFormat.replace(/\\d/, _AsYouTypeFormatter_util_js__WEBPACK_IMPORTED_MODULE_0__.DIGIT_PLACEHOLDER);\n              i--;\n            }\n          }\n        }\n      } // Generate formatting template for this phone number format.\n\n\n      var template = digits // Format the dummy phone number according to the format.\n      .replace(new RegExp(pattern), numberFormat) // Replace each dummy digit with a DIGIT_PLACEHOLDER.\n      .replace(new RegExp(DUMMY_DIGIT, 'g'), _AsYouTypeFormatter_util_js__WEBPACK_IMPORTED_MODULE_0__.DIGIT_PLACEHOLDER); // If a prefix of a national (significant) number is not as simple\n      // as just a basic national prefix, then just prepend such prefix\n      // before the national (significant) number, optionally spacing\n      // the two with a whitespace.\n\n      if (!nationalPrefixIncludedInTemplate) {\n        if (complexPrefixBeforeNationalSignificantNumber) {\n          // Prepend the prefix to the template manually.\n          template = (0,_AsYouTypeFormatter_util_js__WEBPACK_IMPORTED_MODULE_0__.repeat)(_AsYouTypeFormatter_util_js__WEBPACK_IMPORTED_MODULE_0__.DIGIT_PLACEHOLDER, complexPrefixBeforeNationalSignificantNumber.length) + ' ' + template;\n        } else if (nationalPrefix) {\n          // Prepend national prefix to the template manually.\n          template = (0,_AsYouTypeFormatter_util_js__WEBPACK_IMPORTED_MODULE_0__.repeat)(_AsYouTypeFormatter_util_js__WEBPACK_IMPORTED_MODULE_0__.DIGIT_PLACEHOLDER, nationalPrefix.length) + this.getSeparatorAfterNationalPrefix(format) + template;\n        }\n      }\n\n      if (international) {\n        template = (0,_helpers_applyInternationalSeparatorStyle_js__WEBPACK_IMPORTED_MODULE_6__[\"default\"])(template);\n      }\n\n      return template;\n    }\n  }, {\n    key: \"formatNextNationalNumberDigits\",\n    value: function formatNextNationalNumberDigits(digits) {\n      var result = (0,_AsYouTypeFormatter_util_js__WEBPACK_IMPORTED_MODULE_0__.populateTemplateWithDigits)(this.populatedNationalNumberTemplate, this.populatedNationalNumberTemplatePosition, digits);\n\n      if (!result) {\n        // Reset the format.\n        this.resetFormat();\n        return;\n      }\n\n      this.populatedNationalNumberTemplate = result[0];\n      this.populatedNationalNumberTemplatePosition = result[1]; // Return the formatted phone number so far.\n\n      return (0,_AsYouTypeFormatter_util_js__WEBPACK_IMPORTED_MODULE_0__.cutAndStripNonPairedParens)(this.populatedNationalNumberTemplate, this.populatedNationalNumberTemplatePosition + 1); // The old way which was good for `input-format` but is not so good\n      // for `react-phone-number-input`'s default input (`InputBasic`).\n      // return closeNonPairedParens(this.populatedNationalNumberTemplate, this.populatedNationalNumberTemplatePosition + 1)\n      // \t.replace(new RegExp(DIGIT_PLACEHOLDER, 'g'), ' ')\n    }\n  }, {\n    key: \"shouldTryNationalPrefixFormattingRule\",\n    value: function shouldTryNationalPrefixFormattingRule(format, _ref5) {\n      var international = _ref5.international,\n          nationalPrefix = _ref5.nationalPrefix;\n\n      if (format.nationalPrefixFormattingRule()) {\n        // In some countries, `national_prefix_formatting_rule` is `($1)`,\n        // so it applies even if the user hasn't input a national prefix.\n        // `format.usesNationalPrefix()` detects such cases.\n        var usesNationalPrefix = format.usesNationalPrefix();\n\n        if (usesNationalPrefix && nationalPrefix || !usesNationalPrefix && !international) {\n          return true;\n        }\n      }\n    }\n  }]);\n\n  return AsYouTypeFormatter;\n}();\n\n\n//# sourceMappingURL=AsYouTypeFormatter.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/AsYouTypeFormatter.js\n");

/***/ }),

/***/ "(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/AsYouTypeFormatter.util.js":
/*!*************************************************************************************************************************!*\
  !*** ../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/AsYouTypeFormatter.util.js ***!
  \*************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   DIGIT_PLACEHOLDER: () => (/* binding */ DIGIT_PLACEHOLDER),\n/* harmony export */   closeNonPairedParens: () => (/* binding */ closeNonPairedParens),\n/* harmony export */   countOccurences: () => (/* binding */ countOccurences),\n/* harmony export */   cutAndStripNonPairedParens: () => (/* binding */ cutAndStripNonPairedParens),\n/* harmony export */   populateTemplateWithDigits: () => (/* binding */ populateTemplateWithDigits),\n/* harmony export */   repeat: () => (/* binding */ repeat),\n/* harmony export */   stripNonPairedParens: () => (/* binding */ stripNonPairedParens)\n/* harmony export */ });\nfunction _createForOfIteratorHelperLoose(o, allowArrayLike) { var it = typeof Symbol !== \"undefined\" && o[Symbol.iterator] || o[\"@@iterator\"]; if (it) return (it = it.call(o)).next.bind(it); if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === \"number\") { if (it) o = it; var i = 0; return function () { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }; } throw new TypeError(\"Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\n\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\n\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }\n\n// Should be the same as `DIGIT_PLACEHOLDER` in `libphonenumber-metadata-generator`.\nvar DIGIT_PLACEHOLDER = 'x'; // '\\u2008' (punctuation space)\n\nvar DIGIT_PLACEHOLDER_MATCHER = new RegExp(DIGIT_PLACEHOLDER); // Counts all occurences of a symbol in a string.\n// Unicode-unsafe (because using `.split()`).\n\nfunction countOccurences(symbol, string) {\n  var count = 0; // Using `.split('')` to iterate through a string here\n  // to avoid requiring `Symbol.iterator` polyfill.\n  // `.split('')` is generally not safe for Unicode,\n  // but in this particular case for counting brackets it is safe.\n  // for (const character of string)\n\n  for (var _iterator = _createForOfIteratorHelperLoose(string.split('')), _step; !(_step = _iterator()).done;) {\n    var character = _step.value;\n\n    if (character === symbol) {\n      count++;\n    }\n  }\n\n  return count;\n} // Repeats a string (or a symbol) N times.\n// http://stackoverflow.com/questions/202605/repeat-string-javascript\n\nfunction repeat(string, times) {\n  if (times < 1) {\n    return '';\n  }\n\n  var result = '';\n\n  while (times > 1) {\n    if (times & 1) {\n      result += string;\n    }\n\n    times >>= 1;\n    string += string;\n  }\n\n  return result + string;\n}\nfunction cutAndStripNonPairedParens(string, cutBeforeIndex) {\n  if (string[cutBeforeIndex] === ')') {\n    cutBeforeIndex++;\n  }\n\n  return stripNonPairedParens(string.slice(0, cutBeforeIndex));\n}\nfunction closeNonPairedParens(template, cut_before) {\n  var retained_template = template.slice(0, cut_before);\n  var opening_braces = countOccurences('(', retained_template);\n  var closing_braces = countOccurences(')', retained_template);\n  var dangling_braces = opening_braces - closing_braces;\n\n  while (dangling_braces > 0 && cut_before < template.length) {\n    if (template[cut_before] === ')') {\n      dangling_braces--;\n    }\n\n    cut_before++;\n  }\n\n  return template.slice(0, cut_before);\n}\nfunction stripNonPairedParens(string) {\n  var dangling_braces = [];\n  var i = 0;\n\n  while (i < string.length) {\n    if (string[i] === '(') {\n      dangling_braces.push(i);\n    } else if (string[i] === ')') {\n      dangling_braces.pop();\n    }\n\n    i++;\n  }\n\n  var start = 0;\n  var cleared_string = '';\n  dangling_braces.push(string.length);\n\n  for (var _i = 0, _dangling_braces = dangling_braces; _i < _dangling_braces.length; _i++) {\n    var index = _dangling_braces[_i];\n    cleared_string += string.slice(start, index);\n    start = index + 1;\n  }\n\n  return cleared_string;\n}\nfunction populateTemplateWithDigits(template, position, digits) {\n  // Using `.split('')` to iterate through a string here\n  // to avoid requiring `Symbol.iterator` polyfill.\n  // `.split('')` is generally not safe for Unicode,\n  // but in this particular case for `digits` it is safe.\n  // for (const digit of digits)\n  for (var _iterator2 = _createForOfIteratorHelperLoose(digits.split('')), _step2; !(_step2 = _iterator2()).done;) {\n    var digit = _step2.value;\n\n    // If there is room for more digits in current `template`,\n    // then set the next digit in the `template`,\n    // and return the formatted digits so far.\n    // If more digits are entered than the current format could handle.\n    if (template.slice(position + 1).search(DIGIT_PLACEHOLDER_MATCHER) < 0) {\n      return;\n    }\n\n    position = template.search(DIGIT_PLACEHOLDER_MATCHER);\n    template = template.replace(DIGIT_PLACEHOLDER_MATCHER, digit);\n  }\n\n  return [template, position];\n}\n//# sourceMappingURL=AsYouTypeFormatter.util.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/AsYouTypeFormatter.util.js\n");

/***/ }),

/***/ "(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/AsYouTypeParser.js":
/*!*****************************************************************************************************************!*\
  !*** ../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/AsYouTypeParser.js ***!
  \*****************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ AsYouTypeParser),\n/* harmony export */   extractFormattedDigitsAndPlus: () => (/* binding */ extractFormattedDigitsAndPlus)\n/* harmony export */ });\n/* harmony import */ var _helpers_extractCountryCallingCode_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./helpers/extractCountryCallingCode.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/extractCountryCallingCode.js\");\n/* harmony import */ var _helpers_extractCountryCallingCodeFromInternationalNumberWithoutPlusSign_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./helpers/extractCountryCallingCodeFromInternationalNumberWithoutPlusSign.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/extractCountryCallingCodeFromInternationalNumberWithoutPlusSign.js\");\n/* harmony import */ var _helpers_extractNationalNumberFromPossiblyIncompleteNumber_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./helpers/extractNationalNumberFromPossiblyIncompleteNumber.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/extractNationalNumberFromPossiblyIncompleteNumber.js\");\n/* harmony import */ var _helpers_stripIddPrefix_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./helpers/stripIddPrefix.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/stripIddPrefix.js\");\n/* harmony import */ var _helpers_parseDigits_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./helpers/parseDigits.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/parseDigits.js\");\n/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./constants.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/constants.js\");\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\n\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\n\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }\n\nfunction _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== \"undefined\" && arr[Symbol.iterator] || arr[\"@@iterator\"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, \"prototype\", { writable: false }); return Constructor; }\n\n\n\n\n\n\n\nvar VALID_FORMATTED_PHONE_NUMBER_DIGITS_PART = '[' + _constants_js__WEBPACK_IMPORTED_MODULE_0__.VALID_PUNCTUATION + _constants_js__WEBPACK_IMPORTED_MODULE_0__.VALID_DIGITS + ']+';\nvar VALID_FORMATTED_PHONE_NUMBER_DIGITS_PART_PATTERN = new RegExp('^' + VALID_FORMATTED_PHONE_NUMBER_DIGITS_PART + '$', 'i');\nvar VALID_FORMATTED_PHONE_NUMBER_PART = '(?:' + '[' + _constants_js__WEBPACK_IMPORTED_MODULE_0__.PLUS_CHARS + ']' + '[' + _constants_js__WEBPACK_IMPORTED_MODULE_0__.VALID_PUNCTUATION + _constants_js__WEBPACK_IMPORTED_MODULE_0__.VALID_DIGITS + ']*' + '|' + '[' + _constants_js__WEBPACK_IMPORTED_MODULE_0__.VALID_PUNCTUATION + _constants_js__WEBPACK_IMPORTED_MODULE_0__.VALID_DIGITS + ']+' + ')';\nvar AFTER_PHONE_NUMBER_DIGITS_END_PATTERN = new RegExp('[^' + _constants_js__WEBPACK_IMPORTED_MODULE_0__.VALID_PUNCTUATION + _constants_js__WEBPACK_IMPORTED_MODULE_0__.VALID_DIGITS + ']+' + '.*' + '$'); // Tests whether `national_prefix_for_parsing` could match\n// different national prefixes.\n// Matches anything that's not a digit or a square bracket.\n\nvar COMPLEX_NATIONAL_PREFIX = /[^\\d\\[\\]]/;\n\nvar AsYouTypeParser = /*#__PURE__*/function () {\n  function AsYouTypeParser(_ref) {\n    var defaultCountry = _ref.defaultCountry,\n        defaultCallingCode = _ref.defaultCallingCode,\n        metadata = _ref.metadata,\n        onNationalSignificantNumberChange = _ref.onNationalSignificantNumberChange;\n\n    _classCallCheck(this, AsYouTypeParser);\n\n    this.defaultCountry = defaultCountry;\n    this.defaultCallingCode = defaultCallingCode;\n    this.metadata = metadata;\n    this.onNationalSignificantNumberChange = onNationalSignificantNumberChange;\n  }\n\n  _createClass(AsYouTypeParser, [{\n    key: \"input\",\n    value: function input(text, state) {\n      var _extractFormattedDigi = extractFormattedDigitsAndPlus(text),\n          _extractFormattedDigi2 = _slicedToArray(_extractFormattedDigi, 2),\n          formattedDigits = _extractFormattedDigi2[0],\n          hasPlus = _extractFormattedDigi2[1];\n\n      var digits = (0,_helpers_parseDigits_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(formattedDigits); // Checks for a special case: just a leading `+` has been entered.\n\n      var justLeadingPlus;\n\n      if (hasPlus) {\n        if (!state.digits) {\n          state.startInternationalNumber();\n\n          if (!digits) {\n            justLeadingPlus = true;\n          }\n        }\n      }\n\n      if (digits) {\n        this.inputDigits(digits, state);\n      }\n\n      return {\n        digits: digits,\n        justLeadingPlus: justLeadingPlus\n      };\n    }\n    /**\r\n     * Inputs \"next\" phone number digits.\r\n     * @param  {string} digits\r\n     * @return {string} [formattedNumber] Formatted national phone number (if it can be formatted at this stage). Returning `undefined` means \"don't format the national phone number at this stage\".\r\n     */\n\n  }, {\n    key: \"inputDigits\",\n    value: function inputDigits(nextDigits, state) {\n      var digits = state.digits;\n      var hasReceivedThreeLeadingDigits = digits.length < 3 && digits.length + nextDigits.length >= 3; // Append phone number digits.\n\n      state.appendDigits(nextDigits); // Attempt to extract IDD prefix:\n      // Some users input their phone number in international format,\n      // but in an \"out-of-country\" dialing format instead of using the leading `+`.\n      // https://github.com/catamphetamine/libphonenumber-js/issues/185\n      // Detect such numbers as soon as there're at least 3 digits.\n      // Google's library attempts to extract IDD prefix at 3 digits,\n      // so this library just copies that behavior.\n      // I guess that's because the most commot IDD prefixes are\n      // `00` (Europe) and `011` (US).\n      // There exist really long IDD prefixes too:\n      // for example, in Australia the default IDD prefix is `0011`,\n      // and it could even be as long as `14880011`.\n      // An IDD prefix is extracted here, and then every time when\n      // there's a new digit and the number couldn't be formatted.\n\n      if (hasReceivedThreeLeadingDigits) {\n        this.extractIddPrefix(state);\n      }\n\n      if (this.isWaitingForCountryCallingCode(state)) {\n        if (!this.extractCountryCallingCode(state)) {\n          return;\n        }\n      } else {\n        state.appendNationalSignificantNumberDigits(nextDigits);\n      } // If a phone number is being input in international format,\n      // then it's not valid for it to have a national prefix.\n      // Still, some people incorrectly input such numbers with a national prefix.\n      // In such cases, only attempt to strip a national prefix if the number becomes too long.\n      // (but that is done later, not here)\n\n\n      if (!state.international) {\n        if (!this.hasExtractedNationalSignificantNumber) {\n          this.extractNationalSignificantNumber(state.getNationalDigits(), function (stateUpdate) {\n            return state.update(stateUpdate);\n          });\n        }\n      }\n    }\n  }, {\n    key: \"isWaitingForCountryCallingCode\",\n    value: function isWaitingForCountryCallingCode(_ref2) {\n      var international = _ref2.international,\n          callingCode = _ref2.callingCode;\n      return international && !callingCode;\n    } // Extracts a country calling code from a number\n    // being entered in internatonal format.\n\n  }, {\n    key: \"extractCountryCallingCode\",\n    value: function extractCountryCallingCode(state) {\n      var _extractCountryCallin = (0,_helpers_extractCountryCallingCode_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"])('+' + state.getDigitsWithoutInternationalPrefix(), this.defaultCountry, this.defaultCallingCode, this.metadata.metadata),\n          countryCallingCode = _extractCountryCallin.countryCallingCode,\n          number = _extractCountryCallin.number;\n\n      if (countryCallingCode) {\n        state.setCallingCode(countryCallingCode);\n        state.update({\n          nationalSignificantNumber: number\n        });\n        return true;\n      }\n    }\n  }, {\n    key: \"reset\",\n    value: function reset(numberingPlan) {\n      if (numberingPlan) {\n        this.hasSelectedNumberingPlan = true;\n\n        var nationalPrefixForParsing = numberingPlan._nationalPrefixForParsing();\n\n        this.couldPossiblyExtractAnotherNationalSignificantNumber = nationalPrefixForParsing && COMPLEX_NATIONAL_PREFIX.test(nationalPrefixForParsing);\n      } else {\n        this.hasSelectedNumberingPlan = undefined;\n        this.couldPossiblyExtractAnotherNationalSignificantNumber = undefined;\n      }\n    }\n    /**\r\n     * Extracts a national (significant) number from user input.\r\n     * Google's library is different in that it only applies `national_prefix_for_parsing`\r\n     * and doesn't apply `national_prefix_transform_rule` after that.\r\n     * https://github.com/google/libphonenumber/blob/a3d70b0487875475e6ad659af404943211d26456/java/libphonenumber/src/com/google/i18n/phonenumbers/AsYouTypeFormatter.java#L539\r\n     * @return {boolean} [extracted]\r\n     */\n\n  }, {\n    key: \"extractNationalSignificantNumber\",\n    value: function extractNationalSignificantNumber(nationalDigits, setState) {\n      if (!this.hasSelectedNumberingPlan) {\n        return;\n      }\n\n      var _extractNationalNumbe = (0,_helpers_extractNationalNumberFromPossiblyIncompleteNumber_js__WEBPACK_IMPORTED_MODULE_3__[\"default\"])(nationalDigits, this.metadata),\n          nationalPrefix = _extractNationalNumbe.nationalPrefix,\n          nationalNumber = _extractNationalNumbe.nationalNumber,\n          carrierCode = _extractNationalNumbe.carrierCode;\n\n      if (nationalNumber === nationalDigits) {\n        return;\n      }\n\n      this.onExtractedNationalNumber(nationalPrefix, carrierCode, nationalNumber, nationalDigits, setState);\n      return true;\n    }\n    /**\r\n     * In Google's code this function is called \"attempt to extract longer NDD\".\r\n     * \"Some national prefixes are a substring of others\", they say.\r\n     * @return {boolean} [result] — Returns `true` if extracting a national prefix produced different results from what they were.\r\n     */\n\n  }, {\n    key: \"extractAnotherNationalSignificantNumber\",\n    value: function extractAnotherNationalSignificantNumber(nationalDigits, prevNationalSignificantNumber, setState) {\n      if (!this.hasExtractedNationalSignificantNumber) {\n        return this.extractNationalSignificantNumber(nationalDigits, setState);\n      }\n\n      if (!this.couldPossiblyExtractAnotherNationalSignificantNumber) {\n        return;\n      }\n\n      var _extractNationalNumbe2 = (0,_helpers_extractNationalNumberFromPossiblyIncompleteNumber_js__WEBPACK_IMPORTED_MODULE_3__[\"default\"])(nationalDigits, this.metadata),\n          nationalPrefix = _extractNationalNumbe2.nationalPrefix,\n          nationalNumber = _extractNationalNumbe2.nationalNumber,\n          carrierCode = _extractNationalNumbe2.carrierCode; // If a national prefix has been extracted previously,\n      // then it's always extracted as additional digits are added.\n      // That's assuming `extractNationalNumberFromPossiblyIncompleteNumber()`\n      // doesn't do anything different from what it currently does.\n      // So, just in case, here's this check, though it doesn't occur.\n\n      /* istanbul ignore if */\n\n\n      if (nationalNumber === prevNationalSignificantNumber) {\n        return;\n      }\n\n      this.onExtractedNationalNumber(nationalPrefix, carrierCode, nationalNumber, nationalDigits, setState);\n      return true;\n    }\n  }, {\n    key: \"onExtractedNationalNumber\",\n    value: function onExtractedNationalNumber(nationalPrefix, carrierCode, nationalSignificantNumber, nationalDigits, setState) {\n      var complexPrefixBeforeNationalSignificantNumber;\n      var nationalSignificantNumberMatchesInput; // This check also works with empty `this.nationalSignificantNumber`.\n\n      var nationalSignificantNumberIndex = nationalDigits.lastIndexOf(nationalSignificantNumber); // If the extracted national (significant) number is the\n      // last substring of the `digits`, then it means that it hasn't been altered:\n      // no digits have been removed from the national (significant) number\n      // while applying `national_prefix_transform_rule`.\n      // https://gitlab.com/catamphetamine/libphonenumber-js/-/blob/master/METADATA.md#national_prefix_for_parsing--national_prefix_transform_rule\n\n      if (nationalSignificantNumberIndex >= 0 && nationalSignificantNumberIndex === nationalDigits.length - nationalSignificantNumber.length) {\n        nationalSignificantNumberMatchesInput = true; // If a prefix of a national (significant) number is not as simple\n        // as just a basic national prefix, then such prefix is stored in\n        // `this.complexPrefixBeforeNationalSignificantNumber` property and will be\n        // prepended \"as is\" to the national (significant) number to produce\n        // a formatted result.\n\n        var prefixBeforeNationalNumber = nationalDigits.slice(0, nationalSignificantNumberIndex); // `prefixBeforeNationalNumber` is always non-empty,\n        // because `onExtractedNationalNumber()` isn't called\n        // when a national (significant) number hasn't been actually \"extracted\":\n        // when a national (significant) number is equal to the national part of `digits`,\n        // then `onExtractedNationalNumber()` doesn't get called.\n\n        if (prefixBeforeNationalNumber !== nationalPrefix) {\n          complexPrefixBeforeNationalSignificantNumber = prefixBeforeNationalNumber;\n        }\n      }\n\n      setState({\n        nationalPrefix: nationalPrefix,\n        carrierCode: carrierCode,\n        nationalSignificantNumber: nationalSignificantNumber,\n        nationalSignificantNumberMatchesInput: nationalSignificantNumberMatchesInput,\n        complexPrefixBeforeNationalSignificantNumber: complexPrefixBeforeNationalSignificantNumber\n      }); // `onExtractedNationalNumber()` is only called when\n      // the national (significant) number actually did change.\n\n      this.hasExtractedNationalSignificantNumber = true;\n      this.onNationalSignificantNumberChange();\n    }\n  }, {\n    key: \"reExtractNationalSignificantNumber\",\n    value: function reExtractNationalSignificantNumber(state) {\n      // Attempt to extract a national prefix.\n      //\n      // Some people incorrectly input national prefix\n      // in an international phone number.\n      // For example, some people write British phone numbers as `+44(0)...`.\n      //\n      // Also, in some rare cases, it is valid for a national prefix\n      // to be a part of an international phone number.\n      // For example, mobile phone numbers in Mexico are supposed to be\n      // dialled internationally using a `1` national prefix,\n      // so the national prefix will be part of an international number.\n      //\n      // Quote from:\n      // https://www.mexperience.com/dialing-cell-phones-in-mexico/\n      //\n      // \"Dialing a Mexican cell phone from abroad\n      // When you are calling a cell phone number in Mexico from outside Mexico,\n      // it’s necessary to dial an additional “1” after Mexico’s country code\n      // (which is “52”) and before the area code.\n      // You also ignore the 045, and simply dial the area code and the\n      // cell phone’s number.\n      //\n      // If you don’t add the “1”, you’ll receive a recorded announcement\n      // asking you to redial using it.\n      //\n      // For example, if you are calling from the USA to a cell phone\n      // in Mexico City, you would dial +52 – 1 – 55 – 1234 5678.\n      // (Note that this is different to calling a land line in Mexico City\n      // from abroad, where the number dialed would be +52 – 55 – 1234 5678)\".\n      //\n      // Google's demo output:\n      // https://libphonenumber.appspot.com/phonenumberparser?number=%2b5215512345678&country=MX\n      //\n      if (this.extractAnotherNationalSignificantNumber(state.getNationalDigits(), state.nationalSignificantNumber, function (stateUpdate) {\n        return state.update(stateUpdate);\n      })) {\n        return true;\n      } // If no format matches the phone number, then it could be\n      // \"a really long IDD\" (quote from a comment in Google's library).\n      // An IDD prefix is first extracted when the user has entered at least 3 digits,\n      // and then here — every time when there's a new digit and the number\n      // couldn't be formatted.\n      // For example, in Australia the default IDD prefix is `0011`,\n      // and it could even be as long as `14880011`.\n      //\n      // Could also check `!hasReceivedThreeLeadingDigits` here\n      // to filter out the case when this check duplicates the one\n      // already performed when there're 3 leading digits,\n      // but it's not a big deal, and in most cases there\n      // will be a suitable `format` when there're 3 leading digits.\n      //\n\n\n      if (this.extractIddPrefix(state)) {\n        this.extractCallingCodeAndNationalSignificantNumber(state);\n        return true;\n      } // Google's AsYouType formatter supports sort of an \"autocorrection\" feature\n      // when it \"autocorrects\" numbers that have been input for a country\n      // with that country's calling code.\n      // Such \"autocorrection\" feature looks weird, but different people have been requesting it:\n      // https://github.com/catamphetamine/libphonenumber-js/issues/376\n      // https://github.com/catamphetamine/libphonenumber-js/issues/375\n      // https://github.com/catamphetamine/libphonenumber-js/issues/316\n\n\n      if (this.fixMissingPlus(state)) {\n        this.extractCallingCodeAndNationalSignificantNumber(state);\n        return true;\n      }\n    }\n  }, {\n    key: \"extractIddPrefix\",\n    value: function extractIddPrefix(state) {\n      // An IDD prefix can't be present in a number written with a `+`.\n      // Also, don't re-extract an IDD prefix if has already been extracted.\n      var international = state.international,\n          IDDPrefix = state.IDDPrefix,\n          digits = state.digits,\n          nationalSignificantNumber = state.nationalSignificantNumber;\n\n      if (international || IDDPrefix) {\n        return;\n      } // Some users input their phone number in \"out-of-country\"\n      // dialing format instead of using the leading `+`.\n      // https://github.com/catamphetamine/libphonenumber-js/issues/185\n      // Detect such numbers.\n\n\n      var numberWithoutIDD = (0,_helpers_stripIddPrefix_js__WEBPACK_IMPORTED_MODULE_4__[\"default\"])(digits, this.defaultCountry, this.defaultCallingCode, this.metadata.metadata);\n\n      if (numberWithoutIDD !== undefined && numberWithoutIDD !== digits) {\n        // If an IDD prefix was stripped then convert the IDD-prefixed number\n        // to international number for subsequent parsing.\n        state.update({\n          IDDPrefix: digits.slice(0, digits.length - numberWithoutIDD.length)\n        });\n        this.startInternationalNumber(state, {\n          country: undefined,\n          callingCode: undefined\n        });\n        return true;\n      }\n    }\n  }, {\n    key: \"fixMissingPlus\",\n    value: function fixMissingPlus(state) {\n      if (!state.international) {\n        var _extractCountryCallin2 = (0,_helpers_extractCountryCallingCodeFromInternationalNumberWithoutPlusSign_js__WEBPACK_IMPORTED_MODULE_5__[\"default\"])(state.digits, this.defaultCountry, this.defaultCallingCode, this.metadata.metadata),\n            newCallingCode = _extractCountryCallin2.countryCallingCode,\n            number = _extractCountryCallin2.number;\n\n        if (newCallingCode) {\n          state.update({\n            missingPlus: true\n          });\n          this.startInternationalNumber(state, {\n            country: state.country,\n            callingCode: newCallingCode\n          });\n          return true;\n        }\n      }\n    }\n  }, {\n    key: \"startInternationalNumber\",\n    value: function startInternationalNumber(state, _ref3) {\n      var country = _ref3.country,\n          callingCode = _ref3.callingCode;\n      state.startInternationalNumber(country, callingCode); // If a national (significant) number has been extracted before, reset it.\n\n      if (state.nationalSignificantNumber) {\n        state.resetNationalSignificantNumber();\n        this.onNationalSignificantNumberChange();\n        this.hasExtractedNationalSignificantNumber = undefined;\n      }\n    }\n  }, {\n    key: \"extractCallingCodeAndNationalSignificantNumber\",\n    value: function extractCallingCodeAndNationalSignificantNumber(state) {\n      if (this.extractCountryCallingCode(state)) {\n        // `this.extractCallingCode()` is currently called when the number\n        // couldn't be formatted during the standard procedure.\n        // Normally, the national prefix would be re-extracted\n        // for an international number if such number couldn't be formatted,\n        // but since it's already not able to be formatted,\n        // there won't be yet another retry, so also extract national prefix here.\n        this.extractNationalSignificantNumber(state.getNationalDigits(), function (stateUpdate) {\n          return state.update(stateUpdate);\n        });\n      }\n    }\n  }]);\n\n  return AsYouTypeParser;\n}();\n/**\r\n * Extracts formatted phone number from text (if there's any).\r\n * @param  {string} text\r\n * @return {string} [formattedPhoneNumber]\r\n */\n\n\n\n\nfunction extractFormattedPhoneNumber(text) {\n  // Attempt to extract a possible number from the string passed in.\n  var startsAt = text.search(VALID_FORMATTED_PHONE_NUMBER_PART);\n\n  if (startsAt < 0) {\n    return;\n  } // Trim everything to the left of the phone number.\n\n\n  text = text.slice(startsAt); // Trim the `+`.\n\n  var hasPlus;\n\n  if (text[0] === '+') {\n    hasPlus = true;\n    text = text.slice('+'.length);\n  } // Trim everything to the right of the phone number.\n\n\n  text = text.replace(AFTER_PHONE_NUMBER_DIGITS_END_PATTERN, ''); // Re-add the previously trimmed `+`.\n\n  if (hasPlus) {\n    text = '+' + text;\n  }\n\n  return text;\n}\n/**\r\n * Extracts formatted phone number digits (and a `+`) from text (if there're any).\r\n * @param  {string} text\r\n * @return {any[]}\r\n */\n\n\nfunction _extractFormattedDigitsAndPlus(text) {\n  // Extract a formatted phone number part from text.\n  var extractedNumber = extractFormattedPhoneNumber(text) || ''; // Trim a `+`.\n\n  if (extractedNumber[0] === '+') {\n    return [extractedNumber.slice('+'.length), true];\n  }\n\n  return [extractedNumber];\n}\n/**\r\n * Extracts formatted phone number digits (and a `+`) from text (if there're any).\r\n * @param  {string} text\r\n * @return {any[]}\r\n */\n\n\nfunction extractFormattedDigitsAndPlus(text) {\n  var _extractFormattedDigi3 = _extractFormattedDigitsAndPlus(text),\n      _extractFormattedDigi4 = _slicedToArray(_extractFormattedDigi3, 2),\n      formattedDigits = _extractFormattedDigi4[0],\n      hasPlus = _extractFormattedDigi4[1]; // If the extracted phone number part\n  // can possibly be a part of some valid phone number\n  // then parse phone number characters from a formatted phone number.\n\n\n  if (!VALID_FORMATTED_PHONE_NUMBER_DIGITS_PART_PATTERN.test(formattedDigits)) {\n    formattedDigits = '';\n  }\n\n  return [formattedDigits, hasPlus];\n}\n//# sourceMappingURL=AsYouTypeParser.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/AsYouTypeParser.js\n");

/***/ }),

/***/ "(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/AsYouTypeState.js":
/*!****************************************************************************************************************!*\
  !*** ../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/AsYouTypeState.js ***!
  \****************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ AsYouTypeState)\n/* harmony export */ });\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, \"prototype\", { writable: false }); return Constructor; }\n\n// This \"state\" object simply holds the state of the \"AsYouType\" parser:\n//\n// * `country?: string`\n// * `callingCode?: string`\n// * `digits: string`\n// * `international: boolean`\n// * `missingPlus: boolean`\n// * `IDDPrefix?: string`\n// * `carrierCode?: string`\n// * `nationalPrefix?: string`\n// * `nationalSignificantNumber?: string`\n// * `nationalSignificantNumberMatchesInput: boolean`\n// * `complexPrefixBeforeNationalSignificantNumber?: string`\n//\n// `state.country` and `state.callingCode` aren't required to be in sync.\n// For example, `state.country` could be `\"AR\"` and `state.callingCode` could be `undefined`.\n// So `state.country` and `state.callingCode` are totally independent.\n//\nvar AsYouTypeState = /*#__PURE__*/function () {\n  function AsYouTypeState(_ref) {\n    var onCountryChange = _ref.onCountryChange,\n        onCallingCodeChange = _ref.onCallingCodeChange;\n\n    _classCallCheck(this, AsYouTypeState);\n\n    this.onCountryChange = onCountryChange;\n    this.onCallingCodeChange = onCallingCodeChange;\n  }\n\n  _createClass(AsYouTypeState, [{\n    key: \"reset\",\n    value: function reset(_ref2) {\n      var country = _ref2.country,\n          callingCode = _ref2.callingCode;\n      this.international = false;\n      this.missingPlus = false;\n      this.IDDPrefix = undefined;\n      this.callingCode = undefined;\n      this.digits = '';\n      this.resetNationalSignificantNumber();\n      this.initCountryAndCallingCode(country, callingCode);\n    }\n  }, {\n    key: \"resetNationalSignificantNumber\",\n    value: function resetNationalSignificantNumber() {\n      this.nationalSignificantNumber = this.getNationalDigits();\n      this.nationalSignificantNumberMatchesInput = true;\n      this.nationalPrefix = undefined;\n      this.carrierCode = undefined;\n      this.complexPrefixBeforeNationalSignificantNumber = undefined;\n    }\n  }, {\n    key: \"update\",\n    value: function update(properties) {\n      for (var _i = 0, _Object$keys = Object.keys(properties); _i < _Object$keys.length; _i++) {\n        var key = _Object$keys[_i];\n        this[key] = properties[key];\n      }\n    }\n  }, {\n    key: \"initCountryAndCallingCode\",\n    value: function initCountryAndCallingCode(country, callingCode) {\n      this.setCountry(country);\n      this.setCallingCode(callingCode);\n    }\n  }, {\n    key: \"setCountry\",\n    value: function setCountry(country) {\n      this.country = country;\n      this.onCountryChange(country);\n    }\n  }, {\n    key: \"setCallingCode\",\n    value: function setCallingCode(callingCode) {\n      this.callingCode = callingCode;\n      this.onCallingCodeChange(callingCode, this.country);\n    }\n  }, {\n    key: \"startInternationalNumber\",\n    value: function startInternationalNumber(country, callingCode) {\n      // Prepend the `+` to parsed input.\n      this.international = true; // If a default country was set then reset it\n      // because an explicitly international phone\n      // number is being entered.\n\n      this.initCountryAndCallingCode(country, callingCode);\n    }\n  }, {\n    key: \"appendDigits\",\n    value: function appendDigits(nextDigits) {\n      this.digits += nextDigits;\n    }\n  }, {\n    key: \"appendNationalSignificantNumberDigits\",\n    value: function appendNationalSignificantNumberDigits(nextDigits) {\n      this.nationalSignificantNumber += nextDigits;\n    }\n    /**\r\n     * Returns the part of `this.digits` that corresponds to the national number.\r\n     * Basically, all digits that have been input by the user, except for the\r\n     * international prefix and the country calling code part\r\n     * (if the number is an international one).\r\n     * @return {string}\r\n     */\n\n  }, {\n    key: \"getNationalDigits\",\n    value: function getNationalDigits() {\n      if (this.international) {\n        return this.digits.slice((this.IDDPrefix ? this.IDDPrefix.length : 0) + (this.callingCode ? this.callingCode.length : 0));\n      }\n\n      return this.digits;\n    }\n  }, {\n    key: \"getDigitsWithoutInternationalPrefix\",\n    value: function getDigitsWithoutInternationalPrefix() {\n      if (this.international) {\n        if (this.IDDPrefix) {\n          return this.digits.slice(this.IDDPrefix.length);\n        }\n      }\n\n      return this.digits;\n    }\n  }]);\n\n  return AsYouTypeState;\n}();\n\n\n//# sourceMappingURL=AsYouTypeState.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/AsYouTypeState.js\n");

/***/ }),

/***/ "(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/ParseError.js":
/*!************************************************************************************************************!*\
  !*** ../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/ParseError.js ***!
  \************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ ParseError)\n/* harmony export */ });\nfunction _typeof(obj) { \"@babel/helpers - typeof\"; return _typeof = \"function\" == typeof Symbol && \"symbol\" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && \"function\" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }, _typeof(obj); }\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, \"prototype\", { writable: false }); return Constructor; }\n\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _inherits(subClass, superClass) { if (typeof superClass !== \"function\" && superClass !== null) { throw new TypeError(\"Super expression must either be null or a function\"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, \"prototype\", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }\n\nfunction _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }\n\nfunction _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === \"object\" || typeof call === \"function\")) { return call; } else if (call !== void 0) { throw new TypeError(\"Derived constructors may only return object or undefined\"); } return _assertThisInitialized(self); }\n\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\n\nfunction _wrapNativeSuper(Class) { var _cache = typeof Map === \"function\" ? new Map() : undefined; _wrapNativeSuper = function _wrapNativeSuper(Class) { if (Class === null || !_isNativeFunction(Class)) return Class; if (typeof Class !== \"function\") { throw new TypeError(\"Super expression must either be null or a function\"); } if (typeof _cache !== \"undefined\") { if (_cache.has(Class)) return _cache.get(Class); _cache.set(Class, Wrapper); } function Wrapper() { return _construct(Class, arguments, _getPrototypeOf(this).constructor); } Wrapper.prototype = Object.create(Class.prototype, { constructor: { value: Wrapper, enumerable: false, writable: true, configurable: true } }); return _setPrototypeOf(Wrapper, Class); }; return _wrapNativeSuper(Class); }\n\nfunction _construct(Parent, args, Class) { if (_isNativeReflectConstruct()) { _construct = Reflect.construct; } else { _construct = function _construct(Parent, args, Class) { var a = [null]; a.push.apply(a, args); var Constructor = Function.bind.apply(Parent, a); var instance = new Constructor(); if (Class) _setPrototypeOf(instance, Class.prototype); return instance; }; } return _construct.apply(null, arguments); }\n\nfunction _isNativeReflectConstruct() { if (typeof Reflect === \"undefined\" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === \"function\") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }\n\nfunction _isNativeFunction(fn) { return Function.toString.call(fn).indexOf(\"[native code]\") !== -1; }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\nfunction _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }\n\n// https://stackoverflow.com/a/46971044/970769\n// \"Breaking changes in Typescript 2.1\"\n// \"Extending built-ins like Error, Array, and Map may no longer work.\"\n// \"As a recommendation, you can manually adjust the prototype immediately after any super(...) calls.\"\n// https://github.com/Microsoft/TypeScript-wiki/blob/main/Breaking-Changes.md#extending-built-ins-like-error-array-and-map-may-no-longer-work\nvar ParseError = /*#__PURE__*/function (_Error) {\n  _inherits(ParseError, _Error);\n\n  var _super = _createSuper(ParseError);\n\n  function ParseError(code) {\n    var _this;\n\n    _classCallCheck(this, ParseError);\n\n    _this = _super.call(this, code); // Set the prototype explicitly.\n    // Any subclass of FooError will have to manually set the prototype as well.\n\n    Object.setPrototypeOf(_assertThisInitialized(_this), ParseError.prototype);\n    _this.name = _this.constructor.name;\n    return _this;\n  }\n\n  return _createClass(ParseError);\n}( /*#__PURE__*/_wrapNativeSuper(Error));\n\n\n//# sourceMappingURL=ParseError.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/ParseError.js\n");

/***/ }),

/***/ "(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/PhoneNumber.js":
/*!*************************************************************************************************************!*\
  !*** ../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/PhoneNumber.js ***!
  \*************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ PhoneNumber)\n/* harmony export */ });\n/* harmony import */ var _metadata_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./metadata.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/metadata.js\");\n/* harmony import */ var _isPossible_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./isPossible.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/isPossible.js\");\n/* harmony import */ var _isValid_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./isValid.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/isValid.js\");\n/* harmony import */ var _helpers_getNumberType_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./helpers/getNumberType.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/getNumberType.js\");\n/* harmony import */ var _helpers_getPossibleCountriesForNumber_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./helpers/getPossibleCountriesForNumber.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/getPossibleCountriesForNumber.js\");\n/* harmony import */ var _helpers_extractCountryCallingCode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./helpers/extractCountryCallingCode.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/extractCountryCallingCode.js\");\n/* harmony import */ var _helpers_isObject_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./helpers/isObject.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/isObject.js\");\n/* harmony import */ var _format_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./format.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/format.js\");\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }\n\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }\n\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, \"prototype\", { writable: false }); return Constructor; }\n\n\n\n // import checkNumberLength from './helpers/checkNumberLength.js'\n\n\n\n\n\n\nvar USE_NON_GEOGRAPHIC_COUNTRY_CODE = false;\n\nvar PhoneNumber = /*#__PURE__*/function () {\n  /**\r\n   * @param  {string} countryOrCountryCallingCode\r\n   * @param  {string} nationalNumber\r\n   * @param  {object} metadata — Metadata JSON\r\n   * @return {PhoneNumber}\r\n   */\n  function PhoneNumber(countryOrCountryCallingCode, nationalNumber, metadata) {\n    _classCallCheck(this, PhoneNumber);\n\n    // Validate `countryOrCountryCallingCode` argument.\n    if (!countryOrCountryCallingCode) {\n      throw new TypeError('First argument is required');\n    }\n\n    if (typeof countryOrCountryCallingCode !== 'string') {\n      throw new TypeError('First argument must be a string');\n    } // In case of public API use: `constructor(number, metadata)`.\n    // Transform the arguments from `constructor(number, metadata)` to\n    // `constructor(countryOrCountryCallingCode, nationalNumber, metadata)`.\n\n\n    if (typeof countryOrCountryCallingCode === 'string') {\n      if (countryOrCountryCallingCode[0] === '+' && !nationalNumber) {\n        throw new TypeError('`metadata` argument not passed');\n      }\n\n      if ((0,_helpers_isObject_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(nationalNumber) && (0,_helpers_isObject_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(nationalNumber.countries)) {\n        metadata = nationalNumber;\n        var e164Number = countryOrCountryCallingCode;\n\n        if (!E164_NUMBER_REGEXP.test(e164Number)) {\n          throw new Error('Invalid `number` argument passed: must consist of a \"+\" followed by digits');\n        }\n\n        var _extractCountryCallin = (0,_helpers_extractCountryCallingCode_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(e164Number, undefined, undefined, metadata),\n            _countryCallingCode = _extractCountryCallin.countryCallingCode,\n            number = _extractCountryCallin.number;\n\n        nationalNumber = number;\n        countryOrCountryCallingCode = _countryCallingCode;\n\n        if (!nationalNumber) {\n          throw new Error('Invalid `number` argument passed: too short');\n        }\n      }\n    } // Validate `nationalNumber` argument.\n\n\n    if (!nationalNumber) {\n      throw new TypeError('`nationalNumber` argument is required');\n    }\n\n    if (typeof nationalNumber !== 'string') {\n      throw new TypeError('`nationalNumber` argument must be a string');\n    } // Validate `metadata` argument.\n\n\n    (0,_metadata_js__WEBPACK_IMPORTED_MODULE_2__.validateMetadata)(metadata); // Initialize properties.\n\n    var _getCountryAndCountry = getCountryAndCountryCallingCode(countryOrCountryCallingCode, metadata),\n        country = _getCountryAndCountry.country,\n        countryCallingCode = _getCountryAndCountry.countryCallingCode;\n\n    this.country = country;\n    this.countryCallingCode = countryCallingCode;\n    this.nationalNumber = nationalNumber;\n    this.number = '+' + this.countryCallingCode + this.nationalNumber; // Exclude `metadata` property output from `PhoneNumber.toString()`\n    // so that it doesn't clutter the console output of Node.js.\n    // Previously, when Node.js did `console.log(new PhoneNumber(...))`,\n    // it would output the whole internal structure of the `metadata` object.\n\n    this.getMetadata = function () {\n      return metadata;\n    };\n  }\n\n  _createClass(PhoneNumber, [{\n    key: \"setExt\",\n    value: function setExt(ext) {\n      this.ext = ext;\n    }\n  }, {\n    key: \"getPossibleCountries\",\n    value: function getPossibleCountries() {\n      if (this.country) {\n        return [this.country];\n      }\n\n      return (0,_helpers_getPossibleCountriesForNumber_js__WEBPACK_IMPORTED_MODULE_3__[\"default\"])(this.countryCallingCode, this.nationalNumber, this.getMetadata());\n    }\n  }, {\n    key: \"isPossible\",\n    value: function isPossible() {\n      return (0,_isPossible_js__WEBPACK_IMPORTED_MODULE_4__[\"default\"])(this, {\n        v2: true\n      }, this.getMetadata());\n    }\n  }, {\n    key: \"isValid\",\n    value: function isValid() {\n      return (0,_isValid_js__WEBPACK_IMPORTED_MODULE_5__[\"default\"])(this, {\n        v2: true\n      }, this.getMetadata());\n    }\n  }, {\n    key: \"isNonGeographic\",\n    value: function isNonGeographic() {\n      var metadata = new _metadata_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"](this.getMetadata());\n      return metadata.isNonGeographicCallingCode(this.countryCallingCode);\n    }\n  }, {\n    key: \"isEqual\",\n    value: function isEqual(phoneNumber) {\n      return this.number === phoneNumber.number && this.ext === phoneNumber.ext;\n    } // This function was originally meant to be an equivalent for `validatePhoneNumberLength()`,\n    // but later it was found out that it doesn't include the possible `TOO_SHORT` result\n    // returned from `parsePhoneNumberWithError()` in the original `validatePhoneNumberLength()`,\n    // so eventually I simply commented out this method from the `PhoneNumber` class\n    // and just left the `validatePhoneNumberLength()` function, even though that one would require\n    // and additional step to also validate the actual country / calling code of the phone number.\n    // validateLength() {\n    // \tconst metadata = new Metadata(this.getMetadata())\n    // \tmetadata.selectNumberingPlan(this.countryCallingCode)\n    // \tconst result = checkNumberLength(this.nationalNumber, metadata)\n    // \tif (result !== 'IS_POSSIBLE') {\n    // \t\treturn result\n    // \t}\n    // }\n\n  }, {\n    key: \"getType\",\n    value: function getType() {\n      return (0,_helpers_getNumberType_js__WEBPACK_IMPORTED_MODULE_6__[\"default\"])(this, {\n        v2: true\n      }, this.getMetadata());\n    }\n  }, {\n    key: \"format\",\n    value: function format(_format, options) {\n      return (0,_format_js__WEBPACK_IMPORTED_MODULE_7__[\"default\"])(this, _format, options ? _objectSpread(_objectSpread({}, options), {}, {\n        v2: true\n      }) : {\n        v2: true\n      }, this.getMetadata());\n    }\n  }, {\n    key: \"formatNational\",\n    value: function formatNational(options) {\n      return this.format('NATIONAL', options);\n    }\n  }, {\n    key: \"formatInternational\",\n    value: function formatInternational(options) {\n      return this.format('INTERNATIONAL', options);\n    }\n  }, {\n    key: \"getURI\",\n    value: function getURI(options) {\n      return this.format('RFC3966', options);\n    }\n  }]);\n\n  return PhoneNumber;\n}();\n\n\n\nvar isCountryCode = function isCountryCode(value) {\n  return /^[A-Z]{2}$/.test(value);\n};\n\nfunction getCountryAndCountryCallingCode(countryOrCountryCallingCode, metadataJson) {\n  var country;\n  var countryCallingCode;\n  var metadata = new _metadata_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"](metadataJson); // If country code is passed then derive `countryCallingCode` from it.\n  // Also store the country code as `.country`.\n\n  if (isCountryCode(countryOrCountryCallingCode)) {\n    country = countryOrCountryCallingCode;\n    metadata.selectNumberingPlan(country);\n    countryCallingCode = metadata.countryCallingCode();\n  } else {\n    countryCallingCode = countryOrCountryCallingCode;\n    /* istanbul ignore if */\n\n    if (USE_NON_GEOGRAPHIC_COUNTRY_CODE) {\n      if (metadata.isNonGeographicCallingCode(countryCallingCode)) {\n        country = '001';\n      }\n    }\n  }\n\n  return {\n    country: country,\n    countryCallingCode: countryCallingCode\n  };\n}\n\nvar E164_NUMBER_REGEXP = /^\\+\\d+$/;\n//# sourceMappingURL=PhoneNumber.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/PhoneNumber.js\n");

/***/ }),

/***/ "(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/constants.js":
/*!***********************************************************************************************************!*\
  !*** ../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/constants.js ***!
  \***********************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   MAX_LENGTH_COUNTRY_CODE: () => (/* binding */ MAX_LENGTH_COUNTRY_CODE),\n/* harmony export */   MAX_LENGTH_FOR_NSN: () => (/* binding */ MAX_LENGTH_FOR_NSN),\n/* harmony export */   MIN_LENGTH_FOR_NSN: () => (/* binding */ MIN_LENGTH_FOR_NSN),\n/* harmony export */   PLUS_CHARS: () => (/* binding */ PLUS_CHARS),\n/* harmony export */   VALID_DIGITS: () => (/* binding */ VALID_DIGITS),\n/* harmony export */   VALID_PUNCTUATION: () => (/* binding */ VALID_PUNCTUATION),\n/* harmony export */   WHITESPACE: () => (/* binding */ WHITESPACE)\n/* harmony export */ });\n// The minimum length of the national significant number.\nvar MIN_LENGTH_FOR_NSN = 2; // The ITU says the maximum length should be 15,\n// but one can find longer numbers in Germany.\n\nvar MAX_LENGTH_FOR_NSN = 17; // The maximum length of the country calling code.\n\nvar MAX_LENGTH_COUNTRY_CODE = 3; // Digits accepted in phone numbers\n// (ascii, fullwidth, arabic-indic, and eastern arabic digits).\n\nvar VALID_DIGITS = \"0-9\\uFF10-\\uFF19\\u0660-\\u0669\\u06F0-\\u06F9\"; // `DASHES` will be right after the opening square bracket of the \"character class\"\n\nvar DASHES = \"-\\u2010-\\u2015\\u2212\\u30FC\\uFF0D\";\nvar SLASHES = \"\\uFF0F/\";\nvar DOTS = \"\\uFF0E.\";\nvar WHITESPACE = \" \\xA0\\xAD\\u200B\\u2060\\u3000\";\nvar BRACKETS = \"()\\uFF08\\uFF09\\uFF3B\\uFF3D\\\\[\\\\]\"; // export const OPENING_BRACKETS = '(\\uFF08\\uFF3B\\\\\\['\n\nvar TILDES = \"~\\u2053\\u223C\\uFF5E\"; // Regular expression of acceptable punctuation found in phone numbers. This\n// excludes punctuation found as a leading character only. This consists of dash\n// characters, white space characters, full stops, slashes, square brackets,\n// parentheses and tildes. Full-width variants are also present.\n\nvar VALID_PUNCTUATION = \"\".concat(DASHES).concat(SLASHES).concat(DOTS).concat(WHITESPACE).concat(BRACKETS).concat(TILDES);\nvar PLUS_CHARS = \"+\\uFF0B\"; // const LEADING_PLUS_CHARS_PATTERN = new RegExp('^[' + PLUS_CHARS + ']+')\n//# sourceMappingURL=constants.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/constants.js\n");

/***/ }),

/***/ "(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/format.js":
/*!********************************************************************************************************!*\
  !*** ../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/format.js ***!
  \********************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   chooseFormatForNumber: () => (/* binding */ chooseFormatForNumber),\n/* harmony export */   \"default\": () => (/* binding */ formatNumber)\n/* harmony export */ });\n/* harmony import */ var _helpers_matchesEntirely_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./helpers/matchesEntirely.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/matchesEntirely.js\");\n/* harmony import */ var _helpers_formatNationalNumberUsingFormat_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./helpers/formatNationalNumberUsingFormat.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/formatNationalNumberUsingFormat.js\");\n/* harmony import */ var _metadata_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./metadata.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/metadata.js\");\n/* harmony import */ var _helpers_getIddPrefix_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./helpers/getIddPrefix.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/getIddPrefix.js\");\n/* harmony import */ var _helpers_RFC3966_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./helpers/RFC3966.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/RFC3966.js\");\nfunction _createForOfIteratorHelperLoose(o, allowArrayLike) { var it = typeof Symbol !== \"undefined\" && o[Symbol.iterator] || o[\"@@iterator\"]; if (it) return (it = it.call(o)).next.bind(it); if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === \"number\") { if (it) o = it; var i = 0; return function () { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }; } throw new TypeError(\"Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\n\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\n\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }\n\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }\n\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }\n\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\n// This is a port of Google Android `libphonenumber`'s\n// `phonenumberutil.js` of December 31th, 2018.\n//\n// https://github.com/googlei18n/libphonenumber/commits/master/javascript/i18n/phonenumbers/phonenumberutil.js\n\n\n\n\n\nvar DEFAULT_OPTIONS = {\n  formatExtension: function formatExtension(formattedNumber, extension, metadata) {\n    return \"\".concat(formattedNumber).concat(metadata.ext()).concat(extension);\n  }\n};\n/**\r\n * Formats a phone number.\r\n *\r\n * format(phoneNumberInstance, 'INTERNATIONAL', { ..., v2: true }, metadata)\r\n * format(phoneNumberInstance, 'NATIONAL', { ..., v2: true }, metadata)\r\n *\r\n * format({ phone: '8005553535', country: 'RU' }, 'INTERNATIONAL', { ... }, metadata)\r\n * format({ phone: '8005553535', country: 'RU' }, 'NATIONAL', undefined, metadata)\r\n *\r\n * @param  {object|PhoneNumber} input — If `options.v2: true` flag is passed, the `input` should be a `PhoneNumber` instance. Otherwise, it should be an object of shape `{ phone: '...', country: '...' }`.\r\n * @param  {string} format\r\n * @param  {object} [options]\r\n * @param  {object} metadata\r\n * @return {string}\r\n */\n\nfunction formatNumber(input, format, options, metadata) {\n  // Apply default options.\n  if (options) {\n    options = _objectSpread(_objectSpread({}, DEFAULT_OPTIONS), options);\n  } else {\n    options = DEFAULT_OPTIONS;\n  }\n\n  metadata = new _metadata_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"](metadata);\n\n  if (input.country && input.country !== '001') {\n    // Validate `input.country`.\n    if (!metadata.hasCountry(input.country)) {\n      throw new Error(\"Unknown country: \".concat(input.country));\n    }\n\n    metadata.country(input.country);\n  } else if (input.countryCallingCode) {\n    metadata.selectNumberingPlan(input.countryCallingCode);\n  } else return input.phone || '';\n\n  var countryCallingCode = metadata.countryCallingCode();\n  var nationalNumber = options.v2 ? input.nationalNumber : input.phone; // This variable should have been declared inside `case`s\n  // but Babel has a bug and it says \"duplicate variable declaration\".\n\n  var number;\n\n  switch (format) {\n    case 'NATIONAL':\n      // Legacy argument support.\n      // (`{ country: ..., phone: '' }`)\n      if (!nationalNumber) {\n        return '';\n      }\n\n      number = formatNationalNumber(nationalNumber, input.carrierCode, 'NATIONAL', metadata, options);\n      return addExtension(number, input.ext, metadata, options.formatExtension);\n\n    case 'INTERNATIONAL':\n      // Legacy argument support.\n      // (`{ country: ..., phone: '' }`)\n      if (!nationalNumber) {\n        return \"+\".concat(countryCallingCode);\n      }\n\n      number = formatNationalNumber(nationalNumber, null, 'INTERNATIONAL', metadata, options);\n      number = \"+\".concat(countryCallingCode, \" \").concat(number);\n      return addExtension(number, input.ext, metadata, options.formatExtension);\n\n    case 'E.164':\n      // `E.164` doesn't define \"phone number extensions\".\n      return \"+\".concat(countryCallingCode).concat(nationalNumber);\n\n    case 'RFC3966':\n      return (0,_helpers_RFC3966_js__WEBPACK_IMPORTED_MODULE_1__.formatRFC3966)({\n        number: \"+\".concat(countryCallingCode).concat(nationalNumber),\n        ext: input.ext\n      });\n    // For reference, here's Google's IDD formatter:\n    // https://github.com/google/libphonenumber/blob/32719cf74e68796788d1ca45abc85dcdc63ba5b9/java/libphonenumber/src/com/google/i18n/phonenumbers/PhoneNumberUtil.java#L1546\n    // Not saying that this IDD formatter replicates it 1:1, but it seems to work.\n    // Who would even need to format phone numbers in IDD format anyway?\n\n    case 'IDD':\n      if (!options.fromCountry) {\n        return; // throw new Error('`fromCountry` option not passed for IDD-prefixed formatting.')\n      }\n\n      var formattedNumber = formatIDD(nationalNumber, input.carrierCode, countryCallingCode, options.fromCountry, metadata);\n      return addExtension(formattedNumber, input.ext, metadata, options.formatExtension);\n\n    default:\n      throw new Error(\"Unknown \\\"format\\\" argument passed to \\\"formatNumber()\\\": \\\"\".concat(format, \"\\\"\"));\n  }\n}\n\nfunction formatNationalNumber(number, carrierCode, formatAs, metadata, options) {\n  var format = chooseFormatForNumber(metadata.formats(), number);\n\n  if (!format) {\n    return number;\n  }\n\n  return (0,_helpers_formatNationalNumberUsingFormat_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"])(number, format, {\n    useInternationalFormat: formatAs === 'INTERNATIONAL',\n    withNationalPrefix: format.nationalPrefixIsOptionalWhenFormattingInNationalFormat() && options && options.nationalPrefix === false ? false : true,\n    carrierCode: carrierCode,\n    metadata: metadata\n  });\n}\n\nfunction chooseFormatForNumber(availableFormats, nationalNnumber) {\n  for (var _iterator = _createForOfIteratorHelperLoose(availableFormats), _step; !(_step = _iterator()).done;) {\n    var format = _step.value;\n\n    // Validate leading digits.\n    // The test case for \"else path\" could be found by searching for\n    // \"format.leadingDigitsPatterns().length === 0\".\n    if (format.leadingDigitsPatterns().length > 0) {\n      // The last leading_digits_pattern is used here, as it is the most detailed\n      var lastLeadingDigitsPattern = format.leadingDigitsPatterns()[format.leadingDigitsPatterns().length - 1]; // If leading digits don't match then move on to the next phone number format\n\n      if (nationalNnumber.search(lastLeadingDigitsPattern) !== 0) {\n        continue;\n      }\n    } // Check that the national number matches the phone number format regular expression\n\n\n    if ((0,_helpers_matchesEntirely_js__WEBPACK_IMPORTED_MODULE_3__[\"default\"])(nationalNnumber, format.pattern())) {\n      return format;\n    }\n  }\n}\n\nfunction addExtension(formattedNumber, ext, metadata, formatExtension) {\n  return ext ? formatExtension(formattedNumber, ext, metadata) : formattedNumber;\n}\n\nfunction formatIDD(nationalNumber, carrierCode, countryCallingCode, fromCountry, metadata) {\n  var fromCountryCallingCode = (0,_metadata_js__WEBPACK_IMPORTED_MODULE_0__.getCountryCallingCode)(fromCountry, metadata.metadata); // When calling within the same country calling code.\n\n  if (fromCountryCallingCode === countryCallingCode) {\n    var formattedNumber = formatNationalNumber(nationalNumber, carrierCode, 'NATIONAL', metadata); // For NANPA regions, return the national format for these regions\n    // but prefix it with the country calling code.\n\n    if (countryCallingCode === '1') {\n      return countryCallingCode + ' ' + formattedNumber;\n    } // If regions share a country calling code, the country calling code need\n    // not be dialled. This also applies when dialling within a region, so this\n    // if clause covers both these cases. Technically this is the case for\n    // dialling from La Reunion to other overseas departments of France (French\n    // Guiana, Martinique, Guadeloupe), but not vice versa - so we don't cover\n    // this edge case for now and for those cases return the version including\n    // country calling code. Details here:\n    // http://www.petitfute.com/voyage/225-info-pratiques-reunion\n    //\n\n\n    return formattedNumber;\n  }\n\n  var iddPrefix = (0,_helpers_getIddPrefix_js__WEBPACK_IMPORTED_MODULE_4__[\"default\"])(fromCountry, undefined, metadata.metadata);\n\n  if (iddPrefix) {\n    return \"\".concat(iddPrefix, \" \").concat(countryCallingCode, \" \").concat(formatNationalNumber(nationalNumber, null, 'INTERNATIONAL', metadata));\n  }\n}\n//# sourceMappingURL=format.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/format.js\n");

/***/ }),

/***/ "(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/formatIncompletePhoneNumber.js":
/*!*****************************************************************************************************************************!*\
  !*** ../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/formatIncompletePhoneNumber.js ***!
  \*****************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ formatIncompletePhoneNumber)\n/* harmony export */ });\n/* harmony import */ var _AsYouType_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./AsYouType.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/AsYouType.js\");\n\n/**\r\n * Formats a (possibly incomplete) phone number.\r\n * The phone number can be either in E.164 format\r\n * or in a form of national number digits.\r\n * @param {string} value - A possibly incomplete phone number. Either in E.164 format or in a form of national number digits.\r\n * @param {string|object} [optionsOrDefaultCountry] - A two-letter (\"ISO 3166-1 alpha-2\") country code, or an object of shape `{ defaultCountry?: string, defaultCallingCode?: string }`.\r\n * @return {string} Formatted (possibly incomplete) phone number.\r\n */\n\nfunction formatIncompletePhoneNumber(value, optionsOrDefaultCountry, metadata) {\n  if (!metadata) {\n    metadata = optionsOrDefaultCountry;\n    optionsOrDefaultCountry = undefined;\n  }\n\n  return new _AsYouType_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"](optionsOrDefaultCountry, metadata).input(value);\n}\n//# sourceMappingURL=formatIncompletePhoneNumber.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi4vbm9kZXZlbnYvc3RhZ2luZy5hZ2VudGFtYml0aW9uYWNhZGVteS5jb20vMjAvbGliL25vZGVfbW9kdWxlcy9saWJwaG9uZW51bWJlci1qcy9lczYvZm9ybWF0SW5jb21wbGV0ZVBob25lTnVtYmVyLmpzIiwibWFwcGluZ3MiOiI7Ozs7O0FBQXVDO0FBQ3ZDO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsV0FBVyxRQUFRO0FBQ25CLFdBQVcsZUFBZSx1R0FBdUcsc0RBQXNEO0FBQ3ZMLFlBQVksUUFBUTtBQUNwQjs7QUFFZTtBQUNmO0FBQ0E7QUFDQTtBQUNBOztBQUVBLGFBQWEscURBQVM7QUFDdEI7QUFDQSIsInNvdXJjZXMiOlsiL2hvbWUvYWdlbnRhbWJpdGlvbmFjYS9ub2RldmVudi9zdGFnaW5nLmFnZW50YW1iaXRpb25hY2FkZW15LmNvbS8yMC9saWIvbm9kZV9tb2R1bGVzL2xpYnBob25lbnVtYmVyLWpzL2VzNi9mb3JtYXRJbmNvbXBsZXRlUGhvbmVOdW1iZXIuanMiXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IEFzWW91VHlwZSBmcm9tICcuL0FzWW91VHlwZS5qcyc7XG4vKipcclxuICogRm9ybWF0cyBhIChwb3NzaWJseSBpbmNvbXBsZXRlKSBwaG9uZSBudW1iZXIuXHJcbiAqIFRoZSBwaG9uZSBudW1iZXIgY2FuIGJlIGVpdGhlciBpbiBFLjE2NCBmb3JtYXRcclxuICogb3IgaW4gYSBmb3JtIG9mIG5hdGlvbmFsIG51bWJlciBkaWdpdHMuXHJcbiAqIEBwYXJhbSB7c3RyaW5nfSB2YWx1ZSAtIEEgcG9zc2libHkgaW5jb21wbGV0ZSBwaG9uZSBudW1iZXIuIEVpdGhlciBpbiBFLjE2NCBmb3JtYXQgb3IgaW4gYSBmb3JtIG9mIG5hdGlvbmFsIG51bWJlciBkaWdpdHMuXHJcbiAqIEBwYXJhbSB7c3RyaW5nfG9iamVjdH0gW29wdGlvbnNPckRlZmF1bHRDb3VudHJ5XSAtIEEgdHdvLWxldHRlciAoXCJJU08gMzE2Ni0xIGFscGhhLTJcIikgY291bnRyeSBjb2RlLCBvciBhbiBvYmplY3Qgb2Ygc2hhcGUgYHsgZGVmYXVsdENvdW50cnk/OiBzdHJpbmcsIGRlZmF1bHRDYWxsaW5nQ29kZT86IHN0cmluZyB9YC5cclxuICogQHJldHVybiB7c3RyaW5nfSBGb3JtYXR0ZWQgKHBvc3NpYmx5IGluY29tcGxldGUpIHBob25lIG51bWJlci5cclxuICovXG5cbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIGZvcm1hdEluY29tcGxldGVQaG9uZU51bWJlcih2YWx1ZSwgb3B0aW9uc09yRGVmYXVsdENvdW50cnksIG1ldGFkYXRhKSB7XG4gIGlmICghbWV0YWRhdGEpIHtcbiAgICBtZXRhZGF0YSA9IG9wdGlvbnNPckRlZmF1bHRDb3VudHJ5O1xuICAgIG9wdGlvbnNPckRlZmF1bHRDb3VudHJ5ID0gdW5kZWZpbmVkO1xuICB9XG5cbiAgcmV0dXJuIG5ldyBBc1lvdVR5cGUob3B0aW9uc09yRGVmYXVsdENvdW50cnksIG1ldGFkYXRhKS5pbnB1dCh2YWx1ZSk7XG59XG4vLyMgc291cmNlTWFwcGluZ1VSTD1mb3JtYXRJbmNvbXBsZXRlUGhvbmVOdW1iZXIuanMubWFwIl0sIm5hbWVzIjpbXSwiaWdub3JlTGlzdCI6WzBdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/formatIncompletePhoneNumber.js\n");

/***/ }),

/***/ "(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/getCountries.js":
/*!**************************************************************************************************************!*\
  !*** ../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/getCountries.js ***!
  \**************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ getCountries)\n/* harmony export */ });\n/* harmony import */ var _metadata_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./metadata.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/metadata.js\");\n\nfunction getCountries(metadata) {\n  return new _metadata_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"](metadata).getCountries();\n}\n//# sourceMappingURL=getCountries.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi4vbm9kZXZlbnYvc3RhZ2luZy5hZ2VudGFtYml0aW9uYWNhZGVteS5jb20vMjAvbGliL25vZGVfbW9kdWxlcy9saWJwaG9uZW51bWJlci1qcy9lczYvZ2V0Q291bnRyaWVzLmpzIiwibWFwcGluZ3MiOiI7Ozs7O0FBQXFDO0FBQ3RCO0FBQ2YsYUFBYSxvREFBUTtBQUNyQjtBQUNBIiwic291cmNlcyI6WyIvaG9tZS9hZ2VudGFtYml0aW9uYWNhL25vZGV2ZW52L3N0YWdpbmcuYWdlbnRhbWJpdGlvbmFjYWRlbXkuY29tLzIwL2xpYi9ub2RlX21vZHVsZXMvbGlicGhvbmVudW1iZXItanMvZXM2L2dldENvdW50cmllcy5qcyJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgTWV0YWRhdGEgZnJvbSAnLi9tZXRhZGF0YS5qcyc7XG5leHBvcnQgZGVmYXVsdCBmdW5jdGlvbiBnZXRDb3VudHJpZXMobWV0YWRhdGEpIHtcbiAgcmV0dXJuIG5ldyBNZXRhZGF0YShtZXRhZGF0YSkuZ2V0Q291bnRyaWVzKCk7XG59XG4vLyMgc291cmNlTWFwcGluZ1VSTD1nZXRDb3VudHJpZXMuanMubWFwIl0sIm5hbWVzIjpbXSwiaWdub3JlTGlzdCI6WzBdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/getCountries.js\n");

/***/ }),

/***/ "(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/RFC3966.js":
/*!*****************************************************************************************************************!*\
  !*** ../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/RFC3966.js ***!
  \*****************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   formatRFC3966: () => (/* binding */ formatRFC3966),\n/* harmony export */   parseRFC3966: () => (/* binding */ parseRFC3966)\n/* harmony export */ });\n/* harmony import */ var _isViablePhoneNumber_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./isViablePhoneNumber.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/isViablePhoneNumber.js\");\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\n\nfunction _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== \"undefined\" && arr[Symbol.iterator] || arr[\"@@iterator\"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\nfunction _createForOfIteratorHelperLoose(o, allowArrayLike) { var it = typeof Symbol !== \"undefined\" && o[Symbol.iterator] || o[\"@@iterator\"]; if (it) return (it = it.call(o)).next.bind(it); if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === \"number\") { if (it) o = it; var i = 0; return function () { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }; } throw new TypeError(\"Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\n\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\n\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }\n\n // https://www.ietf.org/rfc/rfc3966.txt\n\n/**\r\n * @param  {string} text - Phone URI (RFC 3966).\r\n * @return {object} `{ ?number, ?ext }`.\r\n */\n\nfunction parseRFC3966(text) {\n  var number;\n  var ext; // Replace \"tel:\" with \"tel=\" for parsing convenience.\n\n  text = text.replace(/^tel:/, 'tel=');\n\n  for (var _iterator = _createForOfIteratorHelperLoose(text.split(';')), _step; !(_step = _iterator()).done;) {\n    var part = _step.value;\n\n    var _part$split = part.split('='),\n        _part$split2 = _slicedToArray(_part$split, 2),\n        name = _part$split2[0],\n        value = _part$split2[1];\n\n    switch (name) {\n      case 'tel':\n        number = value;\n        break;\n\n      case 'ext':\n        ext = value;\n        break;\n\n      case 'phone-context':\n        // Only \"country contexts\" are supported.\n        // \"Domain contexts\" are ignored.\n        if (value[0] === '+') {\n          number = value + number;\n        }\n\n        break;\n    }\n  } // If the phone number is not viable, then abort.\n\n\n  if (!(0,_isViablePhoneNumber_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(number)) {\n    return {};\n  }\n\n  var result = {\n    number: number\n  };\n\n  if (ext) {\n    result.ext = ext;\n  }\n\n  return result;\n}\n/**\r\n * @param  {object} - `{ ?number, ?extension }`.\r\n * @return {string} Phone URI (RFC 3966).\r\n */\n\nfunction formatRFC3966(_ref) {\n  var number = _ref.number,\n      ext = _ref.ext;\n\n  if (!number) {\n    return '';\n  }\n\n  if (number[0] !== '+') {\n    throw new Error(\"\\\"formatRFC3966()\\\" expects \\\"number\\\" to be in E.164 format.\");\n  }\n\n  return \"tel:\".concat(number).concat(ext ? ';ext=' + ext : '');\n}\n//# sourceMappingURL=RFC3966.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi4vbm9kZXZlbnYvc3RhZ2luZy5hZ2VudGFtYml0aW9uYWNhZGVteS5jb20vMjAvbGliL25vZGVfbW9kdWxlcy9saWJwaG9uZW51bWJlci1qcy9lczYvaGVscGVycy9SRkMzOTY2LmpzIiwibWFwcGluZ3MiOiI7Ozs7OztBQUFBLGtDQUFrQzs7QUFFbEMsOEJBQThCOztBQUU5Qix5Q0FBeUMsMEdBQTBHLHdCQUF3QixlQUFlLGVBQWUsZ0JBQWdCLFlBQVksTUFBTSx3QkFBd0IsK0JBQStCLGFBQWEscUJBQXFCLHVDQUF1QyxjQUFjLFdBQVcsWUFBWSxVQUFVLE1BQU0sbURBQW1ELFVBQVUsc0JBQXNCOztBQUVuZixnQ0FBZ0M7O0FBRWhDLDhEQUE4RCxpRkFBaUYsZ0RBQWdELHdIQUF3SCxnQkFBZ0IsV0FBVyxxQkFBcUIsNEJBQTRCLGNBQWMsU0FBUyxtQ0FBbUM7O0FBRTdiLGtEQUFrRCxnQkFBZ0IsZ0VBQWdFLHdEQUF3RCw2REFBNkQsc0RBQXNEOztBQUU3Uyx1Q0FBdUMsdURBQXVELHVDQUF1QyxTQUFTLE9BQU8sb0JBQW9COztBQUU5RyxDQUFDOztBQUU1RDtBQUNBLFlBQVksUUFBUTtBQUNwQixZQUFZLFFBQVEsR0FBRyxlQUFlO0FBQ3RDOztBQUVPO0FBQ1A7QUFDQSxXQUFXOztBQUVYOztBQUVBLG9FQUFvRSxZQUFZLDRCQUE0QjtBQUM1Rzs7QUFFQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQSxJQUFJOzs7QUFHSixPQUFPLG1FQUFtQjtBQUMxQjtBQUNBOztBQUVBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0EsWUFBWSxRQUFRLEtBQUsscUJBQXFCO0FBQzlDLFlBQVksUUFBUTtBQUNwQjs7QUFFTztBQUNQO0FBQ0E7O0FBRUE7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTs7QUFFQSw4Q0FBOEM7QUFDOUM7QUFDQSIsInNvdXJjZXMiOlsiL2hvbWUvYWdlbnRhbWJpdGlvbmFjYS9ub2RldmVudi9zdGFnaW5nLmFnZW50YW1iaXRpb25hY2FkZW15LmNvbS8yMC9saWIvbm9kZV9tb2R1bGVzL2xpYnBob25lbnVtYmVyLWpzL2VzNi9oZWxwZXJzL1JGQzM5NjYuanMiXSwic291cmNlc0NvbnRlbnQiOlsiZnVuY3Rpb24gX3NsaWNlZFRvQXJyYXkoYXJyLCBpKSB7IHJldHVybiBfYXJyYXlXaXRoSG9sZXMoYXJyKSB8fCBfaXRlcmFibGVUb0FycmF5TGltaXQoYXJyLCBpKSB8fCBfdW5zdXBwb3J0ZWRJdGVyYWJsZVRvQXJyYXkoYXJyLCBpKSB8fCBfbm9uSXRlcmFibGVSZXN0KCk7IH1cblxuZnVuY3Rpb24gX25vbkl0ZXJhYmxlUmVzdCgpIHsgdGhyb3cgbmV3IFR5cGVFcnJvcihcIkludmFsaWQgYXR0ZW1wdCB0byBkZXN0cnVjdHVyZSBub24taXRlcmFibGUgaW5zdGFuY2UuXFxuSW4gb3JkZXIgdG8gYmUgaXRlcmFibGUsIG5vbi1hcnJheSBvYmplY3RzIG11c3QgaGF2ZSBhIFtTeW1ib2wuaXRlcmF0b3JdKCkgbWV0aG9kLlwiKTsgfVxuXG5mdW5jdGlvbiBfaXRlcmFibGVUb0FycmF5TGltaXQoYXJyLCBpKSB7IHZhciBfaSA9IGFyciA9PSBudWxsID8gbnVsbCA6IHR5cGVvZiBTeW1ib2wgIT09IFwidW5kZWZpbmVkXCIgJiYgYXJyW1N5bWJvbC5pdGVyYXRvcl0gfHwgYXJyW1wiQEBpdGVyYXRvclwiXTsgaWYgKF9pID09IG51bGwpIHJldHVybjsgdmFyIF9hcnIgPSBbXTsgdmFyIF9uID0gdHJ1ZTsgdmFyIF9kID0gZmFsc2U7IHZhciBfcywgX2U7IHRyeSB7IGZvciAoX2kgPSBfaS5jYWxsKGFycik7ICEoX24gPSAoX3MgPSBfaS5uZXh0KCkpLmRvbmUpOyBfbiA9IHRydWUpIHsgX2Fyci5wdXNoKF9zLnZhbHVlKTsgaWYgKGkgJiYgX2Fyci5sZW5ndGggPT09IGkpIGJyZWFrOyB9IH0gY2F0Y2ggKGVycikgeyBfZCA9IHRydWU7IF9lID0gZXJyOyB9IGZpbmFsbHkgeyB0cnkgeyBpZiAoIV9uICYmIF9pW1wicmV0dXJuXCJdICE9IG51bGwpIF9pW1wicmV0dXJuXCJdKCk7IH0gZmluYWxseSB7IGlmIChfZCkgdGhyb3cgX2U7IH0gfSByZXR1cm4gX2FycjsgfVxuXG5mdW5jdGlvbiBfYXJyYXlXaXRoSG9sZXMoYXJyKSB7IGlmIChBcnJheS5pc0FycmF5KGFycikpIHJldHVybiBhcnI7IH1cblxuZnVuY3Rpb24gX2NyZWF0ZUZvck9mSXRlcmF0b3JIZWxwZXJMb29zZShvLCBhbGxvd0FycmF5TGlrZSkgeyB2YXIgaXQgPSB0eXBlb2YgU3ltYm9sICE9PSBcInVuZGVmaW5lZFwiICYmIG9bU3ltYm9sLml0ZXJhdG9yXSB8fCBvW1wiQEBpdGVyYXRvclwiXTsgaWYgKGl0KSByZXR1cm4gKGl0ID0gaXQuY2FsbChvKSkubmV4dC5iaW5kKGl0KTsgaWYgKEFycmF5LmlzQXJyYXkobykgfHwgKGl0ID0gX3Vuc3VwcG9ydGVkSXRlcmFibGVUb0FycmF5KG8pKSB8fCBhbGxvd0FycmF5TGlrZSAmJiBvICYmIHR5cGVvZiBvLmxlbmd0aCA9PT0gXCJudW1iZXJcIikgeyBpZiAoaXQpIG8gPSBpdDsgdmFyIGkgPSAwOyByZXR1cm4gZnVuY3Rpb24gKCkgeyBpZiAoaSA+PSBvLmxlbmd0aCkgcmV0dXJuIHsgZG9uZTogdHJ1ZSB9OyByZXR1cm4geyBkb25lOiBmYWxzZSwgdmFsdWU6IG9baSsrXSB9OyB9OyB9IHRocm93IG5ldyBUeXBlRXJyb3IoXCJJbnZhbGlkIGF0dGVtcHQgdG8gaXRlcmF0ZSBub24taXRlcmFibGUgaW5zdGFuY2UuXFxuSW4gb3JkZXIgdG8gYmUgaXRlcmFibGUsIG5vbi1hcnJheSBvYmplY3RzIG11c3QgaGF2ZSBhIFtTeW1ib2wuaXRlcmF0b3JdKCkgbWV0aG9kLlwiKTsgfVxuXG5mdW5jdGlvbiBfdW5zdXBwb3J0ZWRJdGVyYWJsZVRvQXJyYXkobywgbWluTGVuKSB7IGlmICghbykgcmV0dXJuOyBpZiAodHlwZW9mIG8gPT09IFwic3RyaW5nXCIpIHJldHVybiBfYXJyYXlMaWtlVG9BcnJheShvLCBtaW5MZW4pOyB2YXIgbiA9IE9iamVjdC5wcm90b3R5cGUudG9TdHJpbmcuY2FsbChvKS5zbGljZSg4LCAtMSk7IGlmIChuID09PSBcIk9iamVjdFwiICYmIG8uY29uc3RydWN0b3IpIG4gPSBvLmNvbnN0cnVjdG9yLm5hbWU7IGlmIChuID09PSBcIk1hcFwiIHx8IG4gPT09IFwiU2V0XCIpIHJldHVybiBBcnJheS5mcm9tKG8pOyBpZiAobiA9PT0gXCJBcmd1bWVudHNcIiB8fCAvXig/OlVpfEkpbnQoPzo4fDE2fDMyKSg/OkNsYW1wZWQpP0FycmF5JC8udGVzdChuKSkgcmV0dXJuIF9hcnJheUxpa2VUb0FycmF5KG8sIG1pbkxlbik7IH1cblxuZnVuY3Rpb24gX2FycmF5TGlrZVRvQXJyYXkoYXJyLCBsZW4pIHsgaWYgKGxlbiA9PSBudWxsIHx8IGxlbiA+IGFyci5sZW5ndGgpIGxlbiA9IGFyci5sZW5ndGg7IGZvciAodmFyIGkgPSAwLCBhcnIyID0gbmV3IEFycmF5KGxlbik7IGkgPCBsZW47IGkrKykgeyBhcnIyW2ldID0gYXJyW2ldOyB9IHJldHVybiBhcnIyOyB9XG5cbmltcG9ydCBpc1ZpYWJsZVBob25lTnVtYmVyIGZyb20gJy4vaXNWaWFibGVQaG9uZU51bWJlci5qcyc7IC8vIGh0dHBzOi8vd3d3LmlldGYub3JnL3JmYy9yZmMzOTY2LnR4dFxuXG4vKipcclxuICogQHBhcmFtICB7c3RyaW5nfSB0ZXh0IC0gUGhvbmUgVVJJIChSRkMgMzk2NikuXHJcbiAqIEByZXR1cm4ge29iamVjdH0gYHsgP251bWJlciwgP2V4dCB9YC5cclxuICovXG5cbmV4cG9ydCBmdW5jdGlvbiBwYXJzZVJGQzM5NjYodGV4dCkge1xuICB2YXIgbnVtYmVyO1xuICB2YXIgZXh0OyAvLyBSZXBsYWNlIFwidGVsOlwiIHdpdGggXCJ0ZWw9XCIgZm9yIHBhcnNpbmcgY29udmVuaWVuY2UuXG5cbiAgdGV4dCA9IHRleHQucmVwbGFjZSgvXnRlbDovLCAndGVsPScpO1xuXG4gIGZvciAodmFyIF9pdGVyYXRvciA9IF9jcmVhdGVGb3JPZkl0ZXJhdG9ySGVscGVyTG9vc2UodGV4dC5zcGxpdCgnOycpKSwgX3N0ZXA7ICEoX3N0ZXAgPSBfaXRlcmF0b3IoKSkuZG9uZTspIHtcbiAgICB2YXIgcGFydCA9IF9zdGVwLnZhbHVlO1xuXG4gICAgdmFyIF9wYXJ0JHNwbGl0ID0gcGFydC5zcGxpdCgnPScpLFxuICAgICAgICBfcGFydCRzcGxpdDIgPSBfc2xpY2VkVG9BcnJheShfcGFydCRzcGxpdCwgMiksXG4gICAgICAgIG5hbWUgPSBfcGFydCRzcGxpdDJbMF0sXG4gICAgICAgIHZhbHVlID0gX3BhcnQkc3BsaXQyWzFdO1xuXG4gICAgc3dpdGNoIChuYW1lKSB7XG4gICAgICBjYXNlICd0ZWwnOlxuICAgICAgICBudW1iZXIgPSB2YWx1ZTtcbiAgICAgICAgYnJlYWs7XG5cbiAgICAgIGNhc2UgJ2V4dCc6XG4gICAgICAgIGV4dCA9IHZhbHVlO1xuICAgICAgICBicmVhaztcblxuICAgICAgY2FzZSAncGhvbmUtY29udGV4dCc6XG4gICAgICAgIC8vIE9ubHkgXCJjb3VudHJ5IGNvbnRleHRzXCIgYXJlIHN1cHBvcnRlZC5cbiAgICAgICAgLy8gXCJEb21haW4gY29udGV4dHNcIiBhcmUgaWdub3JlZC5cbiAgICAgICAgaWYgKHZhbHVlWzBdID09PSAnKycpIHtcbiAgICAgICAgICBudW1iZXIgPSB2YWx1ZSArIG51bWJlcjtcbiAgICAgICAgfVxuXG4gICAgICAgIGJyZWFrO1xuICAgIH1cbiAgfSAvLyBJZiB0aGUgcGhvbmUgbnVtYmVyIGlzIG5vdCB2aWFibGUsIHRoZW4gYWJvcnQuXG5cblxuICBpZiAoIWlzVmlhYmxlUGhvbmVOdW1iZXIobnVtYmVyKSkge1xuICAgIHJldHVybiB7fTtcbiAgfVxuXG4gIHZhciByZXN1bHQgPSB7XG4gICAgbnVtYmVyOiBudW1iZXJcbiAgfTtcblxuICBpZiAoZXh0KSB7XG4gICAgcmVzdWx0LmV4dCA9IGV4dDtcbiAgfVxuXG4gIHJldHVybiByZXN1bHQ7XG59XG4vKipcclxuICogQHBhcmFtICB7b2JqZWN0fSAtIGB7ID9udW1iZXIsID9leHRlbnNpb24gfWAuXHJcbiAqIEByZXR1cm4ge3N0cmluZ30gUGhvbmUgVVJJIChSRkMgMzk2NikuXHJcbiAqL1xuXG5leHBvcnQgZnVuY3Rpb24gZm9ybWF0UkZDMzk2NihfcmVmKSB7XG4gIHZhciBudW1iZXIgPSBfcmVmLm51bWJlcixcbiAgICAgIGV4dCA9IF9yZWYuZXh0O1xuXG4gIGlmICghbnVtYmVyKSB7XG4gICAgcmV0dXJuICcnO1xuICB9XG5cbiAgaWYgKG51bWJlclswXSAhPT0gJysnKSB7XG4gICAgdGhyb3cgbmV3IEVycm9yKFwiXFxcImZvcm1hdFJGQzM5NjYoKVxcXCIgZXhwZWN0cyBcXFwibnVtYmVyXFxcIiB0byBiZSBpbiBFLjE2NCBmb3JtYXQuXCIpO1xuICB9XG5cbiAgcmV0dXJuIFwidGVsOlwiLmNvbmNhdChudW1iZXIpLmNvbmNhdChleHQgPyAnO2V4dD0nICsgZXh0IDogJycpO1xufVxuLy8jIHNvdXJjZU1hcHBpbmdVUkw9UkZDMzk2Ni5qcy5tYXAiXSwibmFtZXMiOltdLCJpZ25vcmVMaXN0IjpbMF0sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/RFC3966.js\n");

/***/ }),

/***/ "(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/applyInternationalSeparatorStyle.js":
/*!******************************************************************************************************************************************!*\
  !*** ../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/applyInternationalSeparatorStyle.js ***!
  \******************************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ applyInternationalSeparatorStyle)\n/* harmony export */ });\n/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../constants.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/constants.js\");\n // Removes brackets and replaces dashes with spaces.\n//\n// E.g. \"(999) 111-22-33\" -> \"999 111 22 33\"\n//\n// For some reason Google's metadata contains `<intlFormat/>`s with brackets and dashes.\n// Meanwhile, there's no single opinion about using punctuation in international phone numbers.\n//\n// For example, Google's `<intlFormat/>` for USA is `+1 213-373-4253`.\n// And here's a quote from WikiPedia's \"North American Numbering Plan\" page:\n// https://en.wikipedia.org/wiki/North_American_Numbering_Plan\n//\n// \"The country calling code for all countries participating in the NANP is 1.\n// In international format, an NANP number should be listed as +1 301 555 01 00,\n// where 301 is an area code (Maryland).\"\n//\n// I personally prefer the international format without any punctuation.\n// For example, brackets are remnants of the old age, meaning that the\n// phone number part in brackets (so called \"area code\") can be omitted\n// if dialing within the same \"area\".\n// And hyphens were clearly introduced for splitting local numbers into memorizable groups.\n// For example, remembering \"5553535\" is difficult but \"555-35-35\" is much simpler.\n// Imagine a man taking a bus from home to work and seeing an ad with a phone number.\n// He has a couple of seconds to memorize that number until it passes by.\n// If it were spaces instead of hyphens the man wouldn't necessarily get it,\n// but with hyphens instead of spaces the grouping is more explicit.\n// I personally think that hyphens introduce visual clutter,\n// so I prefer replacing them with spaces in international numbers.\n// In the modern age all output is done on displays where spaces are clearly distinguishable\n// so hyphens can be safely replaced with spaces without losing any legibility.\n//\n\nfunction applyInternationalSeparatorStyle(formattedNumber) {\n  return formattedNumber.replace(new RegExp(\"[\".concat(_constants_js__WEBPACK_IMPORTED_MODULE_0__.VALID_PUNCTUATION, \"]+\"), 'g'), ' ').trim();\n}\n//# sourceMappingURL=applyInternationalSeparatorStyle.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/applyInternationalSeparatorStyle.js\n");

/***/ }),

/***/ "(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/checkNumberLength.js":
/*!***************************************************************************************************************************!*\
  !*** ../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/checkNumberLength.js ***!
  \***************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   checkNumberLengthForType: () => (/* binding */ checkNumberLengthForType),\n/* harmony export */   \"default\": () => (/* binding */ checkNumberLength)\n/* harmony export */ });\n/* harmony import */ var _mergeArrays_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./mergeArrays.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/mergeArrays.js\");\n\nfunction checkNumberLength(nationalNumber, metadata) {\n  return checkNumberLengthForType(nationalNumber, undefined, metadata);\n} // Checks whether a number is possible for the country based on its length.\n// Should only be called for the \"new\" metadata which has \"possible lengths\".\n\nfunction checkNumberLengthForType(nationalNumber, type, metadata) {\n  var type_info = metadata.type(type); // There should always be \"<possiblePengths/>\" set for every type element.\n  // This is declared in the XML schema.\n  // For size efficiency, where a sub-description (e.g. fixed-line)\n  // has the same \"<possiblePengths/>\" as the \"general description\", this is missing,\n  // so we fall back to the \"general description\". Where no numbers of the type\n  // exist at all, there is one possible length (-1) which is guaranteed\n  // not to match the length of any real phone number.\n\n  var possible_lengths = type_info && type_info.possibleLengths() || metadata.possibleLengths(); // let local_lengths    = type_info && type.possibleLengthsLocal() || metadata.possibleLengthsLocal()\n  // Metadata before version `1.0.18` didn't contain `possible_lengths`.\n\n  if (!possible_lengths) {\n    return 'IS_POSSIBLE';\n  }\n\n  if (type === 'FIXED_LINE_OR_MOBILE') {\n    // No such country in metadata.\n\n    /* istanbul ignore next */\n    if (!metadata.type('FIXED_LINE')) {\n      // The rare case has been encountered where no fixedLine data is available\n      // (true for some non-geographic entities), so we just check mobile.\n      return checkNumberLengthForType(nationalNumber, 'MOBILE', metadata);\n    }\n\n    var mobile_type = metadata.type('MOBILE');\n\n    if (mobile_type) {\n      // Merge the mobile data in if there was any. \"Concat\" creates a new\n      // array, it doesn't edit possible_lengths in place, so we don't need a copy.\n      // Note that when adding the possible lengths from mobile, we have\n      // to again check they aren't empty since if they are this indicates\n      // they are the same as the general desc and should be obtained from there.\n      possible_lengths = (0,_mergeArrays_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(possible_lengths, mobile_type.possibleLengths()); // The current list is sorted; we need to merge in the new list and\n      // re-sort (duplicates are okay). Sorting isn't so expensive because\n      // the lists are very small.\n      // if (local_lengths) {\n      // \tlocal_lengths = mergeArrays(local_lengths, mobile_type.possibleLengthsLocal())\n      // } else {\n      // \tlocal_lengths = mobile_type.possibleLengthsLocal()\n      // }\n    }\n  } // If the type doesn't exist then return 'INVALID_LENGTH'.\n  else if (type && !type_info) {\n    return 'INVALID_LENGTH';\n  }\n\n  var actual_length = nationalNumber.length; // In `libphonenumber-js` all \"local-only\" formats are dropped for simplicity.\n  // // This is safe because there is never an overlap beween the possible lengths\n  // // and the local-only lengths; this is checked at build time.\n  // if (local_lengths && local_lengths.indexOf(nationalNumber.length) >= 0)\n  // {\n  // \treturn 'IS_POSSIBLE_LOCAL_ONLY'\n  // }\n\n  var minimum_length = possible_lengths[0];\n\n  if (minimum_length === actual_length) {\n    return 'IS_POSSIBLE';\n  }\n\n  if (minimum_length > actual_length) {\n    return 'TOO_SHORT';\n  }\n\n  if (possible_lengths[possible_lengths.length - 1] < actual_length) {\n    return 'TOO_LONG';\n  } // We skip the first element since we've already checked it.\n\n\n  return possible_lengths.indexOf(actual_length, 1) >= 0 ? 'IS_POSSIBLE' : 'INVALID_LENGTH';\n}\n//# sourceMappingURL=checkNumberLength.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/checkNumberLength.js\n");

/***/ }),

/***/ "(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/extension/createExtensionPattern.js":
/*!******************************************************************************************************************************************!*\
  !*** ../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/extension/createExtensionPattern.js ***!
  \******************************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ createExtensionPattern)\n/* harmony export */ });\n/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../constants.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/constants.js\");\n // The RFC 3966 format for extensions.\n\nvar RFC3966_EXTN_PREFIX = ';ext=';\n/**\r\n * Helper method for constructing regular expressions for parsing. Creates\r\n * an expression that captures up to max_length digits.\r\n * @return {string} RegEx pattern to capture extension digits.\r\n */\n\nvar getExtensionDigitsPattern = function getExtensionDigitsPattern(maxLength) {\n  return \"([\".concat(_constants_js__WEBPACK_IMPORTED_MODULE_0__.VALID_DIGITS, \"]{1,\").concat(maxLength, \"})\");\n};\n/**\r\n * Helper initialiser method to create the regular-expression pattern to match\r\n * extensions.\r\n * Copy-pasted from Google's `libphonenumber`:\r\n * https://github.com/google/libphonenumber/blob/55b2646ec9393f4d3d6661b9c82ef9e258e8b829/javascript/i18n/phonenumbers/phonenumberutil.js#L759-L766\r\n * @return {string} RegEx pattern to capture extensions.\r\n */\n\n\nfunction createExtensionPattern(purpose) {\n  // We cap the maximum length of an extension based on the ambiguity of the way\n  // the extension is prefixed. As per ITU, the officially allowed length for\n  // extensions is actually 40, but we don't support this since we haven't seen real\n  // examples and this introduces many false interpretations as the extension labels\n  // are not standardized.\n\n  /** @type {string} */\n  var extLimitAfterExplicitLabel = '20';\n  /** @type {string} */\n\n  var extLimitAfterLikelyLabel = '15';\n  /** @type {string} */\n\n  var extLimitAfterAmbiguousChar = '9';\n  /** @type {string} */\n\n  var extLimitWhenNotSure = '6';\n  /** @type {string} */\n\n  var possibleSeparatorsBetweenNumberAndExtLabel = \"[ \\xA0\\\\t,]*\"; // Optional full stop (.) or colon, followed by zero or more spaces/tabs/commas.\n\n  /** @type {string} */\n\n  var possibleCharsAfterExtLabel = \"[:\\\\.\\uFF0E]?[ \\xA0\\\\t,-]*\";\n  /** @type {string} */\n\n  var optionalExtnSuffix = \"#?\"; // Here the extension is called out in more explicit way, i.e mentioning it obvious\n  // patterns like \"ext.\".\n\n  /** @type {string} */\n\n  var explicitExtLabels = \"(?:e?xt(?:ensi(?:o\\u0301?|\\xF3))?n?|\\uFF45?\\uFF58\\uFF54\\uFF4E?|\\u0434\\u043E\\u0431|anexo)\"; // One-character symbols that can be used to indicate an extension, and less\n  // commonly used or more ambiguous extension labels.\n\n  /** @type {string} */\n\n  var ambiguousExtLabels = \"(?:[x\\uFF58#\\uFF03~\\uFF5E]|int|\\uFF49\\uFF4E\\uFF54)\"; // When extension is not separated clearly.\n\n  /** @type {string} */\n\n  var ambiguousSeparator = \"[- ]+\"; // This is the same as possibleSeparatorsBetweenNumberAndExtLabel, but not matching\n  // comma as extension label may have it.\n\n  /** @type {string} */\n\n  var possibleSeparatorsNumberExtLabelNoComma = \"[ \\xA0\\\\t]*\"; // \",,\" is commonly used for auto dialling the extension when connected. First\n  // comma is matched through possibleSeparatorsBetweenNumberAndExtLabel, so we do\n  // not repeat it here. Semi-colon works in Iphone and Android also to pop up a\n  // button with the extension number following.\n\n  /** @type {string} */\n\n  var autoDiallingAndExtLabelsFound = \"(?:,{2}|;)\";\n  /** @type {string} */\n\n  var rfcExtn = RFC3966_EXTN_PREFIX + getExtensionDigitsPattern(extLimitAfterExplicitLabel);\n  /** @type {string} */\n\n  var explicitExtn = possibleSeparatorsBetweenNumberAndExtLabel + explicitExtLabels + possibleCharsAfterExtLabel + getExtensionDigitsPattern(extLimitAfterExplicitLabel) + optionalExtnSuffix;\n  /** @type {string} */\n\n  var ambiguousExtn = possibleSeparatorsBetweenNumberAndExtLabel + ambiguousExtLabels + possibleCharsAfterExtLabel + getExtensionDigitsPattern(extLimitAfterAmbiguousChar) + optionalExtnSuffix;\n  /** @type {string} */\n\n  var americanStyleExtnWithSuffix = ambiguousSeparator + getExtensionDigitsPattern(extLimitWhenNotSure) + \"#\";\n  /** @type {string} */\n\n  var autoDiallingExtn = possibleSeparatorsNumberExtLabelNoComma + autoDiallingAndExtLabelsFound + possibleCharsAfterExtLabel + getExtensionDigitsPattern(extLimitAfterLikelyLabel) + optionalExtnSuffix;\n  /** @type {string} */\n\n  var onlyCommasExtn = possibleSeparatorsNumberExtLabelNoComma + \"(?:,)+\" + possibleCharsAfterExtLabel + getExtensionDigitsPattern(extLimitAfterAmbiguousChar) + optionalExtnSuffix; // The first regular expression covers RFC 3966 format, where the extension is added\n  // using \";ext=\". The second more generic where extension is mentioned with explicit\n  // labels like \"ext:\". In both the above cases we allow more numbers in extension than\n  // any other extension labels. The third one captures when single character extension\n  // labels or less commonly used labels are used. In such cases we capture fewer\n  // extension digits in order to reduce the chance of falsely interpreting two\n  // numbers beside each other as a number + extension. The fourth one covers the\n  // special case of American numbers where the extension is written with a hash\n  // at the end, such as \"- 503#\". The fifth one is exclusively for extension\n  // autodialling formats which are used when dialling and in this case we accept longer\n  // extensions. The last one is more liberal on the number of commas that acts as\n  // extension labels, so we have a strict cap on the number of digits in such extensions.\n\n  return rfcExtn + \"|\" + explicitExtn + \"|\" + ambiguousExtn + \"|\" + americanStyleExtnWithSuffix + \"|\" + autoDiallingExtn + \"|\" + onlyCommasExtn;\n}\n//# sourceMappingURL=createExtensionPattern.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/extension/createExtensionPattern.js\n");

/***/ }),

/***/ "(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/extension/extractExtension.js":
/*!************************************************************************************************************************************!*\
  !*** ../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/extension/extractExtension.js ***!
  \************************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ extractExtension)\n/* harmony export */ });\n/* harmony import */ var _createExtensionPattern_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./createExtensionPattern.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/extension/createExtensionPattern.js\");\n // Regexp of all known extension prefixes used by different regions followed by\n// 1 or more valid digits, for use when parsing.\n\nvar EXTN_PATTERN = new RegExp('(?:' + (0,_createExtensionPattern_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])() + ')$', 'i'); // Strips any extension (as in, the part of the number dialled after the call is\n// connected, usually indicated with extn, ext, x or similar) from the end of\n// the number, and returns it.\n\nfunction extractExtension(number) {\n  var start = number.search(EXTN_PATTERN);\n\n  if (start < 0) {\n    return {};\n  } // If we find a potential extension, and the number preceding this is a viable\n  // number, we assume it is an extension.\n\n\n  var numberWithoutExtension = number.slice(0, start);\n  var matches = number.match(EXTN_PATTERN);\n  var i = 1;\n\n  while (i < matches.length) {\n    if (matches[i]) {\n      return {\n        number: numberWithoutExtension,\n        ext: matches[i]\n      };\n    }\n\n    i++;\n  }\n}\n//# sourceMappingURL=extractExtension.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/extension/extractExtension.js\n");

/***/ }),

/***/ "(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/extractCountryCallingCode.js":
/*!***********************************************************************************************************************************!*\
  !*** ../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/extractCountryCallingCode.js ***!
  \***********************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ extractCountryCallingCode)\n/* harmony export */ });\n/* harmony import */ var _stripIddPrefix_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./stripIddPrefix.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/stripIddPrefix.js\");\n/* harmony import */ var _extractCountryCallingCodeFromInternationalNumberWithoutPlusSign_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./extractCountryCallingCodeFromInternationalNumberWithoutPlusSign.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/extractCountryCallingCodeFromInternationalNumberWithoutPlusSign.js\");\n/* harmony import */ var _metadata_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../metadata.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/metadata.js\");\n/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../constants.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/constants.js\");\n\n\n\n\n/**\r\n * Converts a phone number digits (possibly with a `+`)\r\n * into a calling code and the rest phone number digits.\r\n * The \"rest phone number digits\" could include\r\n * a national prefix, carrier code, and national\r\n * (significant) number.\r\n * @param  {string} number — Phone number digits (possibly with a `+`).\r\n * @param  {string} [country] — Default country.\r\n * @param  {string} [callingCode] — Default calling code (some phone numbering plans are non-geographic).\r\n * @param  {object} metadata\r\n * @return {object} `{ countryCallingCodeSource: string?, countryCallingCode: string?, number: string }`\r\n * @example\r\n * // Returns `{ countryCallingCode: \"1\", number: \"2133734253\" }`.\r\n * extractCountryCallingCode('2133734253', 'US', null, metadata)\r\n * extractCountryCallingCode('2133734253', null, '1', metadata)\r\n * extractCountryCallingCode('+12133734253', null, null, metadata)\r\n * extractCountryCallingCode('+12133734253', 'RU', null, metadata)\r\n */\n\nfunction extractCountryCallingCode(number, country, callingCode, metadata) {\n  if (!number) {\n    return {};\n  }\n\n  var isNumberWithIddPrefix; // If this is not an international phone number,\n  // then either extract an \"IDD\" prefix, or extract a\n  // country calling code from a number by autocorrecting it\n  // by prepending a leading `+` in cases when it starts\n  // with the country calling code.\n  // https://wikitravel.org/en/International_dialling_prefix\n  // https://github.com/catamphetamine/libphonenumber-js/issues/376\n\n  if (number[0] !== '+') {\n    // Convert an \"out-of-country\" dialing phone number\n    // to a proper international phone number.\n    var numberWithoutIDD = (0,_stripIddPrefix_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(number, country, callingCode, metadata); // If an IDD prefix was stripped then\n    // convert the number to international one\n    // for subsequent parsing.\n\n    if (numberWithoutIDD && numberWithoutIDD !== number) {\n      isNumberWithIddPrefix = true;\n      number = '+' + numberWithoutIDD;\n    } else {\n      // Check to see if the number starts with the country calling code\n      // for the default country. If so, we remove the country calling code,\n      // and do some checks on the validity of the number before and after.\n      // https://github.com/catamphetamine/libphonenumber-js/issues/376\n      if (country || callingCode) {\n        var _extractCountryCallin = (0,_extractCountryCallingCodeFromInternationalNumberWithoutPlusSign_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(number, country, callingCode, metadata),\n            countryCallingCode = _extractCountryCallin.countryCallingCode,\n            shorterNumber = _extractCountryCallin.number;\n\n        if (countryCallingCode) {\n          return {\n            countryCallingCodeSource: 'FROM_NUMBER_WITHOUT_PLUS_SIGN',\n            countryCallingCode: countryCallingCode,\n            number: shorterNumber\n          };\n        }\n      }\n\n      return {\n        // No need to set it to `UNSPECIFIED`. It can be just `undefined`.\n        // countryCallingCodeSource: 'UNSPECIFIED',\n        number: number\n      };\n    }\n  } // Fast abortion: country codes do not begin with a '0'\n\n\n  if (number[1] === '0') {\n    return {};\n  }\n\n  metadata = new _metadata_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"](metadata); // The thing with country phone codes\n  // is that they are orthogonal to each other\n  // i.e. there's no such country phone code A\n  // for which country phone code B exists\n  // where B starts with A.\n  // Therefore, while scanning digits,\n  // if a valid country code is found,\n  // that means that it is the country code.\n  //\n\n  var i = 2;\n\n  while (i - 1 <= _constants_js__WEBPACK_IMPORTED_MODULE_3__.MAX_LENGTH_COUNTRY_CODE && i <= number.length) {\n    var _countryCallingCode = number.slice(1, i);\n\n    if (metadata.hasCallingCode(_countryCallingCode)) {\n      metadata.selectNumberingPlan(_countryCallingCode);\n      return {\n        countryCallingCodeSource: isNumberWithIddPrefix ? 'FROM_NUMBER_WITH_IDD' : 'FROM_NUMBER_WITH_PLUS_SIGN',\n        countryCallingCode: _countryCallingCode,\n        number: number.slice(i)\n      };\n    }\n\n    i++;\n  }\n\n  return {};\n} // The possible values for the returned `countryCallingCodeSource` are:\n//\n// Copy-pasted from:\n// https://github.com/google/libphonenumber/blob/master/resources/phonenumber.proto\n//\n// // The source from which the country_code is derived. This is not set in the\n// // general parsing method, but in the method that parses and keeps raw_input.\n// // New fields could be added upon request.\n// enum CountryCodeSource {\n//  // Default value returned if this is not set, because the phone number was\n//  // created using parse, not parseAndKeepRawInput. hasCountryCodeSource will\n//  // return false if this is the case.\n//  UNSPECIFIED = 0;\n//\n//  // The country_code is derived based on a phone number with a leading \"+\",\n//  // e.g. the French number \"+33 1 42 68 53 00\".\n//  FROM_NUMBER_WITH_PLUS_SIGN = 1;\n//\n//  // The country_code is derived based on a phone number with a leading IDD,\n//  // e.g. the French number \"011 33 1 42 68 53 00\", as it is dialled from US.\n//  FROM_NUMBER_WITH_IDD = 5;\n//\n//  // The country_code is derived based on a phone number without a leading\n//  // \"+\", e.g. the French number \"33 1 42 68 53 00\" when defaultCountry is\n//  // supplied as France.\n//  FROM_NUMBER_WITHOUT_PLUS_SIGN = 10;\n//\n//  // The country_code is derived NOT based on the phone number itself, but\n//  // from the defaultCountry parameter provided in the parsing function by the\n//  // clients. This happens mostly for numbers written in the national format\n//  // (without country code). For example, this would be set when parsing the\n//  // French number \"01 42 68 53 00\", when defaultCountry is supplied as\n//  // France.\n//  FROM_DEFAULT_COUNTRY = 20;\n// }\n//# sourceMappingURL=extractCountryCallingCode.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/extractCountryCallingCode.js\n");

/***/ }),

/***/ "(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/extractCountryCallingCodeFromInternationalNumberWithoutPlusSign.js":
/*!*************************************************************************************************************************************************************************!*\
  !*** ../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/extractCountryCallingCodeFromInternationalNumberWithoutPlusSign.js ***!
  \*************************************************************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ extractCountryCallingCodeFromInternationalNumberWithoutPlusSign)\n/* harmony export */ });\n/* harmony import */ var _getCountryCallingCode_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../getCountryCallingCode.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/metadata.js\");\n/* harmony import */ var _matchesEntirely_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./matchesEntirely.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/matchesEntirely.js\");\n/* harmony import */ var _extractNationalNumber_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./extractNationalNumber.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/extractNationalNumber.js\");\n/* harmony import */ var _checkNumberLength_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./checkNumberLength.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/checkNumberLength.js\");\n\n\n\n\n\n/**\r\n * Sometimes some people incorrectly input international phone numbers\r\n * without the leading `+`. This function corrects such input.\r\n * @param  {string} number — Phone number digits.\r\n * @param  {string?} country\r\n * @param  {string?} callingCode\r\n * @param  {object} metadata\r\n * @return {object} `{ countryCallingCode: string?, number: string }`.\r\n */\n\nfunction extractCountryCallingCodeFromInternationalNumberWithoutPlusSign(number, country, callingCode, metadata) {\n  var countryCallingCode = country ? (0,_getCountryCallingCode_js__WEBPACK_IMPORTED_MODULE_0__.getCountryCallingCode)(country, metadata) : callingCode;\n\n  if (number.indexOf(countryCallingCode) === 0) {\n    metadata = new _getCountryCallingCode_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"](metadata);\n    metadata.selectNumberingPlan(country, callingCode);\n    var possibleShorterNumber = number.slice(countryCallingCode.length);\n\n    var _extractNationalNumbe = (0,_extractNationalNumber_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(possibleShorterNumber, metadata),\n        possibleShorterNationalNumber = _extractNationalNumbe.nationalNumber;\n\n    var _extractNationalNumbe2 = (0,_extractNationalNumber_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(number, metadata),\n        nationalNumber = _extractNationalNumbe2.nationalNumber; // If the number was not valid before but is valid now,\n    // or if it was too long before, we consider the number\n    // with the country calling code stripped to be a better result\n    // and keep that instead.\n    // For example, in Germany (+49), `49` is a valid area code,\n    // so if a number starts with `49`, it could be both a valid\n    // national German number or an international number without\n    // a leading `+`.\n\n\n    if (!(0,_matchesEntirely_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"])(nationalNumber, metadata.nationalNumberPattern()) && (0,_matchesEntirely_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"])(possibleShorterNationalNumber, metadata.nationalNumberPattern()) || (0,_checkNumberLength_js__WEBPACK_IMPORTED_MODULE_3__[\"default\"])(nationalNumber, metadata) === 'TOO_LONG') {\n      return {\n        countryCallingCode: countryCallingCode,\n        number: possibleShorterNumber\n      };\n    }\n  }\n\n  return {\n    number: number\n  };\n}\n//# sourceMappingURL=extractCountryCallingCodeFromInternationalNumberWithoutPlusSign.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/extractCountryCallingCodeFromInternationalNumberWithoutPlusSign.js\n");

/***/ }),

/***/ "(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/extractFormattedPhoneNumberFromPossibleRfc3966NumberUri.js":
/*!*****************************************************************************************************************************************************************!*\
  !*** ../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/extractFormattedPhoneNumberFromPossibleRfc3966NumberUri.js ***!
  \*****************************************************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ extractFormattedPhoneNumberFromPossibleRfc3966NumberUri)\n/* harmony export */ });\n/* harmony import */ var _extractPhoneContext_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./extractPhoneContext.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/extractPhoneContext.js\");\n/* harmony import */ var _ParseError_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../ParseError.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/ParseError.js\");\n\n\n/**\r\n * @param  {string} numberToParse\r\n * @param  {string} nationalNumber\r\n * @return {}\r\n */\n\nfunction extractFormattedPhoneNumberFromPossibleRfc3966NumberUri(numberToParse, _ref) {\n  var extractFormattedPhoneNumber = _ref.extractFormattedPhoneNumber;\n  var phoneContext = (0,_extractPhoneContext_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(numberToParse);\n\n  if (!(0,_extractPhoneContext_js__WEBPACK_IMPORTED_MODULE_0__.isPhoneContextValid)(phoneContext)) {\n    throw new _ParseError_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"]('NOT_A_NUMBER');\n  }\n\n  var phoneNumberString;\n\n  if (phoneContext === null) {\n    // Extract a possible number from the string passed in.\n    // (this strips leading characters that could not be the start of a phone number)\n    phoneNumberString = extractFormattedPhoneNumber(numberToParse) || '';\n  } else {\n    phoneNumberString = ''; // If the phone context contains a phone number prefix, we need to capture\n    // it, whereas domains will be ignored.\n\n    if (phoneContext.charAt(0) === _extractPhoneContext_js__WEBPACK_IMPORTED_MODULE_0__.PLUS_SIGN) {\n      phoneNumberString += phoneContext;\n    } // Now append everything between the \"tel:\" prefix and the phone-context.\n    // This should include the national number, an optional extension or\n    // isdn-subaddress component. Note we also handle the case when \"tel:\" is\n    // missing, as we have seen in some of the phone number inputs.\n    // In that case, we append everything from the beginning.\n\n\n    var indexOfRfc3966Prefix = numberToParse.indexOf(_extractPhoneContext_js__WEBPACK_IMPORTED_MODULE_0__.RFC3966_PREFIX_);\n    var indexOfNationalNumber; // RFC 3966 \"tel:\" prefix is preset at this stage because\n    // `isPhoneContextValid()` requires it to be present.\n\n    /* istanbul ignore else */\n\n    if (indexOfRfc3966Prefix >= 0) {\n      indexOfNationalNumber = indexOfRfc3966Prefix + _extractPhoneContext_js__WEBPACK_IMPORTED_MODULE_0__.RFC3966_PREFIX_.length;\n    } else {\n      indexOfNationalNumber = 0;\n    }\n\n    var indexOfPhoneContext = numberToParse.indexOf(_extractPhoneContext_js__WEBPACK_IMPORTED_MODULE_0__.RFC3966_PHONE_CONTEXT_);\n    phoneNumberString += numberToParse.substring(indexOfNationalNumber, indexOfPhoneContext);\n  } // Delete the isdn-subaddress and everything after it if it is present.\n  // Note extension won't appear at the same time with isdn-subaddress\n  // according to paragraph 5.3 of the RFC3966 spec.\n\n\n  var indexOfIsdn = phoneNumberString.indexOf(_extractPhoneContext_js__WEBPACK_IMPORTED_MODULE_0__.RFC3966_ISDN_SUBADDRESS_);\n\n  if (indexOfIsdn > 0) {\n    phoneNumberString = phoneNumberString.substring(0, indexOfIsdn);\n  } // If both phone context and isdn-subaddress are absent but other\n  // parameters are present, the parameters are left in nationalNumber.\n  // This is because we are concerned about deleting content from a potential\n  // number string when there is no strong evidence that the number is\n  // actually written in RFC3966.\n\n\n  if (phoneNumberString !== '') {\n    return phoneNumberString;\n  }\n}\n//# sourceMappingURL=extractFormattedPhoneNumberFromPossibleRfc3966NumberUri.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/extractFormattedPhoneNumberFromPossibleRfc3966NumberUri.js\n");

/***/ }),

/***/ "(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/extractNationalNumber.js":
/*!*******************************************************************************************************************************!*\
  !*** ../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/extractNationalNumber.js ***!
  \*******************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ extractNationalNumber)\n/* harmony export */ });\n/* harmony import */ var _extractNationalNumberFromPossiblyIncompleteNumber_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./extractNationalNumberFromPossiblyIncompleteNumber.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/extractNationalNumberFromPossiblyIncompleteNumber.js\");\n/* harmony import */ var _matchesEntirely_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./matchesEntirely.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/matchesEntirely.js\");\n/* harmony import */ var _checkNumberLength_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./checkNumberLength.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/checkNumberLength.js\");\n\n\n\n/**\r\n * Strips national prefix and carrier code from a complete phone number.\r\n * The difference from the non-\"FromCompleteNumber\" function is that\r\n * it won't extract national prefix if the resultant number is too short\r\n * to be a complete number for the selected phone numbering plan.\r\n * @param  {string} number — Complete phone number digits.\r\n * @param  {Metadata} metadata — Metadata with a phone numbering plan selected.\r\n * @return {object} `{ nationalNumber: string, carrierCode: string? }`.\r\n */\n\nfunction extractNationalNumber(number, metadata) {\n  // Parsing national prefixes and carrier codes\n  // is only required for local phone numbers\n  // but some people don't understand that\n  // and sometimes write international phone numbers\n  // with national prefixes (or maybe even carrier codes).\n  // http://ucken.blogspot.ru/2016/03/trunk-prefixes-in-skype4b.html\n  // Google's original library forgives such mistakes\n  // and so does this library, because it has been requested:\n  // https://github.com/catamphetamine/libphonenumber-js/issues/127\n  var _extractNationalNumbe = (0,_extractNationalNumberFromPossiblyIncompleteNumber_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(number, metadata),\n      carrierCode = _extractNationalNumbe.carrierCode,\n      nationalNumber = _extractNationalNumbe.nationalNumber;\n\n  if (nationalNumber !== number) {\n    if (!shouldHaveExtractedNationalPrefix(number, nationalNumber, metadata)) {\n      // Don't strip the national prefix.\n      return {\n        nationalNumber: number\n      };\n    } // Check the national (significant) number length after extracting national prefix and carrier code.\n    // Legacy generated metadata (before `1.0.18`) didn't support the \"possible lengths\" feature.\n\n\n    if (metadata.possibleLengths()) {\n      // The number remaining after stripping the national prefix and carrier code\n      // should be long enough to have a possible length for the country.\n      // Otherwise, don't strip the national prefix and carrier code,\n      // since the original number could be a valid number.\n      // This check has been copy-pasted \"as is\" from Google's original library:\n      // https://github.com/google/libphonenumber/blob/876268eb1ad6cdc1b7b5bef17fc5e43052702d57/java/libphonenumber/src/com/google/i18n/phonenumbers/PhoneNumberUtil.java#L3236-L3250\n      // It doesn't check for the \"possibility\" of the original `number`.\n      // I guess it's fine not checking that one. It works as is anyway.\n      if (!isPossibleIncompleteNationalNumber(nationalNumber, metadata)) {\n        // Don't strip the national prefix.\n        return {\n          nationalNumber: number\n        };\n      }\n    }\n  }\n\n  return {\n    nationalNumber: nationalNumber,\n    carrierCode: carrierCode\n  };\n} // In some countries, the same digit could be a national prefix\n// or a leading digit of a valid phone number.\n// For example, in Russia, national prefix is `8`,\n// and also `800 555 35 35` is a valid number\n// in which `8` is not a national prefix, but the first digit\n// of a national (significant) number.\n// Same's with Belarus:\n// `82004910060` is a valid national (significant) number,\n// but `2004910060` is not.\n// To support such cases (to prevent the code from always stripping\n// national prefix), a condition is imposed: a national prefix\n// is not extracted when the original number is \"viable\" and the\n// resultant number is not, a \"viable\" national number being the one\n// that matches `national_number_pattern`.\n\nfunction shouldHaveExtractedNationalPrefix(nationalNumberBefore, nationalNumberAfter, metadata) {\n  // The equivalent in Google's code is:\n  // https://github.com/google/libphonenumber/blob/e326fa1fc4283bb05eb35cb3c15c18f98a31af33/java/libphonenumber/src/com/google/i18n/phonenumbers/PhoneNumberUtil.java#L2969-L3004\n  if ((0,_matchesEntirely_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(nationalNumberBefore, metadata.nationalNumberPattern()) && !(0,_matchesEntirely_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(nationalNumberAfter, metadata.nationalNumberPattern())) {\n    return false;\n  } // This \"is possible\" national number (length) check has been commented out\n  // because it's superceded by the (effectively) same check done in the\n  // `extractNationalNumber()` function after it calls `shouldHaveExtractedNationalPrefix()`.\n  // In other words, why run the same check twice if it could only be run once.\n  // // Check the national (significant) number length after extracting national prefix and carrier code.\n  // // Fixes a minor \"weird behavior\" bug: https://gitlab.com/catamphetamine/libphonenumber-js/-/issues/57\n  // // (Legacy generated metadata (before `1.0.18`) didn't support the \"possible lengths\" feature).\n  // if (metadata.possibleLengths()) {\n  // \tif (isPossibleIncompleteNationalNumber(nationalNumberBefore, metadata) &&\n  // \t\t!isPossibleIncompleteNationalNumber(nationalNumberAfter, metadata)) {\n  // \t\treturn false\n  // \t}\n  // }\n\n\n  return true;\n}\n\nfunction isPossibleIncompleteNationalNumber(nationalNumber, metadata) {\n  switch ((0,_checkNumberLength_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"])(nationalNumber, metadata)) {\n    case 'TOO_SHORT':\n    case 'INVALID_LENGTH':\n      // This library ignores \"local-only\" phone numbers (for simplicity).\n      // See the readme for more info on what are \"local-only\" phone numbers.\n      // case 'IS_POSSIBLE_LOCAL_ONLY':\n      return false;\n\n    default:\n      return true;\n  }\n}\n//# sourceMappingURL=extractNationalNumber.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/extractNationalNumber.js\n");

/***/ }),

/***/ "(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/extractNationalNumberFromPossiblyIncompleteNumber.js":
/*!***********************************************************************************************************************************************************!*\
  !*** ../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/extractNationalNumberFromPossiblyIncompleteNumber.js ***!
  \***********************************************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ extractNationalNumberFromPossiblyIncompleteNumber)\n/* harmony export */ });\n/**\r\n * Strips any national prefix (such as 0, 1) present in a\r\n * (possibly incomplete) number provided.\r\n * \"Carrier codes\" are only used  in Colombia and Brazil,\r\n * and only when dialing within those countries from a mobile phone to a fixed line number.\r\n * Sometimes it won't actually strip national prefix\r\n * and will instead prepend some digits to the `number`:\r\n * for example, when number `2345678` is passed with `VI` country selected,\r\n * it will return `{ number: \"3402345678\" }`, because `340` area code is prepended.\r\n * @param {string} number — National number digits.\r\n * @param {object} metadata — Metadata with country selected.\r\n * @return {object} `{ nationalNumber: string, nationalPrefix: string? carrierCode: string? }`. Even if a national prefix was extracted, it's not necessarily present in the returned object, so don't rely on its presence in the returned object in order to find out whether a national prefix has been extracted or not.\r\n */\nfunction extractNationalNumberFromPossiblyIncompleteNumber(number, metadata) {\n  if (number && metadata.numberingPlan.nationalPrefixForParsing()) {\n    // See METADATA.md for the description of\n    // `national_prefix_for_parsing` and `national_prefix_transform_rule`.\n    // Attempt to parse the first digits as a national prefix.\n    var prefixPattern = new RegExp('^(?:' + metadata.numberingPlan.nationalPrefixForParsing() + ')');\n    var prefixMatch = prefixPattern.exec(number);\n\n    if (prefixMatch) {\n      var nationalNumber;\n      var carrierCode; // https://gitlab.com/catamphetamine/libphonenumber-js/-/blob/master/METADATA.md#national_prefix_for_parsing--national_prefix_transform_rule\n      // If a `national_prefix_for_parsing` has any \"capturing groups\"\n      // then it means that the national (significant) number is equal to\n      // those \"capturing groups\" transformed via `national_prefix_transform_rule`,\n      // and nothing could be said about the actual national prefix:\n      // what is it and was it even there.\n      // If a `national_prefix_for_parsing` doesn't have any \"capturing groups\",\n      // then everything it matches is a national prefix.\n      // To determine whether `national_prefix_for_parsing` matched any\n      // \"capturing groups\", the value of the result of calling `.exec()`\n      // is looked at, and if it has non-undefined values where there're\n      // \"capturing groups\" in the regular expression, then it means\n      // that \"capturing groups\" have been matched.\n      // It's not possible to tell whether there'll be any \"capturing gropus\"\n      // before the matching process, because a `national_prefix_for_parsing`\n      // could exhibit both behaviors.\n\n      var capturedGroupsCount = prefixMatch.length - 1;\n      var hasCapturedGroups = capturedGroupsCount > 0 && prefixMatch[capturedGroupsCount];\n\n      if (metadata.nationalPrefixTransformRule() && hasCapturedGroups) {\n        nationalNumber = number.replace(prefixPattern, metadata.nationalPrefixTransformRule()); // If there's more than one captured group,\n        // then carrier code is the second one.\n\n        if (capturedGroupsCount > 1) {\n          carrierCode = prefixMatch[1];\n        }\n      } // If there're no \"capturing groups\",\n      // or if there're \"capturing groups\" but no\n      // `national_prefix_transform_rule`,\n      // then just strip the national prefix from the number,\n      // and possibly a carrier code.\n      // Seems like there could be more.\n      else {\n        // `prefixBeforeNationalNumber` is the whole substring matched by\n        // the `national_prefix_for_parsing` regular expression.\n        // There seem to be no guarantees that it's just a national prefix.\n        // For example, if there's a carrier code, it's gonna be a\n        // part of `prefixBeforeNationalNumber` too.\n        var prefixBeforeNationalNumber = prefixMatch[0];\n        nationalNumber = number.slice(prefixBeforeNationalNumber.length); // If there's at least one captured group,\n        // then carrier code is the first one.\n\n        if (hasCapturedGroups) {\n          carrierCode = prefixMatch[1];\n        }\n      } // Tries to guess whether a national prefix was present in the input.\n      // This is not something copy-pasted from Google's library:\n      // they don't seem to have an equivalent for that.\n      // So this isn't an \"officially approved\" way of doing something like that.\n      // But since there seems no other existing method, this library uses it.\n\n\n      var nationalPrefix;\n\n      if (hasCapturedGroups) {\n        var possiblePositionOfTheFirstCapturedGroup = number.indexOf(prefixMatch[1]);\n        var possibleNationalPrefix = number.slice(0, possiblePositionOfTheFirstCapturedGroup); // Example: an Argentinian (AR) phone number `0111523456789`.\n        // `prefixMatch[0]` is `01115`, and `$1` is `11`,\n        // and the rest of the phone number is `23456789`.\n        // The national number is transformed via `9$1` to `91123456789`.\n        // National prefix `0` is detected being present at the start.\n        // if (possibleNationalPrefix.indexOf(metadata.numberingPlan.nationalPrefix()) === 0) {\n\n        if (possibleNationalPrefix === metadata.numberingPlan.nationalPrefix()) {\n          nationalPrefix = metadata.numberingPlan.nationalPrefix();\n        }\n      } else {\n        nationalPrefix = prefixMatch[0];\n      }\n\n      return {\n        nationalNumber: nationalNumber,\n        nationalPrefix: nationalPrefix,\n        carrierCode: carrierCode\n      };\n    }\n  }\n\n  return {\n    nationalNumber: number\n  };\n}\n//# sourceMappingURL=extractNationalNumberFromPossiblyIncompleteNumber.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/extractNationalNumberFromPossiblyIncompleteNumber.js\n");

/***/ }),

/***/ "(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/extractPhoneContext.js":
/*!*****************************************************************************************************************************!*\
  !*** ../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/extractPhoneContext.js ***!
  \*****************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   PLUS_SIGN: () => (/* binding */ PLUS_SIGN),\n/* harmony export */   RFC3966_ISDN_SUBADDRESS_: () => (/* binding */ RFC3966_ISDN_SUBADDRESS_),\n/* harmony export */   RFC3966_PHONE_CONTEXT_: () => (/* binding */ RFC3966_PHONE_CONTEXT_),\n/* harmony export */   RFC3966_PREFIX_: () => (/* binding */ RFC3966_PREFIX_),\n/* harmony export */   \"default\": () => (/* binding */ extractPhoneContext),\n/* harmony export */   isPhoneContextValid: () => (/* binding */ isPhoneContextValid)\n/* harmony export */ });\n/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../constants.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/constants.js\");\n// When phone numbers are written in `RFC3966` format — `\"tel:+12133734253\"` —\n// they can have their \"calling code\" part written separately in a `phone-context` parameter.\n// Example: `\"tel:12133734253;phone-context=+1\"`.\n// This function parses the full phone number from the local number and the `phone-context`\n// when the `phone-context` contains a `+` sign.\n\nvar PLUS_SIGN = '+';\nvar RFC3966_VISUAL_SEPARATOR_ = '[\\\\-\\\\.\\\\(\\\\)]?';\nvar RFC3966_PHONE_DIGIT_ = '(' + '[' + _constants_js__WEBPACK_IMPORTED_MODULE_0__.VALID_DIGITS + ']' + '|' + RFC3966_VISUAL_SEPARATOR_ + ')';\nvar RFC3966_GLOBAL_NUMBER_DIGITS_ = '^' + '\\\\' + PLUS_SIGN + RFC3966_PHONE_DIGIT_ + '*' + '[' + _constants_js__WEBPACK_IMPORTED_MODULE_0__.VALID_DIGITS + ']' + RFC3966_PHONE_DIGIT_ + '*' + '$';\n/**\r\n * Regular expression of valid global-number-digits for the phone-context\r\n * parameter, following the syntax defined in RFC3966.\r\n */\n\nvar RFC3966_GLOBAL_NUMBER_DIGITS_PATTERN_ = new RegExp(RFC3966_GLOBAL_NUMBER_DIGITS_, 'g'); // In this port of Google's library, we don't accept alpha characters in phone numbers.\n// const ALPHANUM_ = VALID_ALPHA_ + VALID_DIGITS\n\nvar ALPHANUM_ = _constants_js__WEBPACK_IMPORTED_MODULE_0__.VALID_DIGITS;\nvar RFC3966_DOMAINLABEL_ = '[' + ALPHANUM_ + ']+((\\\\-)*[' + ALPHANUM_ + '])*';\nvar VALID_ALPHA_ = 'a-zA-Z';\nvar RFC3966_TOPLABEL_ = '[' + VALID_ALPHA_ + ']+((\\\\-)*[' + ALPHANUM_ + '])*';\nvar RFC3966_DOMAINNAME_ = '^(' + RFC3966_DOMAINLABEL_ + '\\\\.)*' + RFC3966_TOPLABEL_ + '\\\\.?$';\n/**\r\n * Regular expression of valid domainname for the phone-context parameter,\r\n * following the syntax defined in RFC3966.\r\n */\n\nvar RFC3966_DOMAINNAME_PATTERN_ = new RegExp(RFC3966_DOMAINNAME_, 'g');\nvar RFC3966_PREFIX_ = 'tel:';\nvar RFC3966_PHONE_CONTEXT_ = ';phone-context=';\nvar RFC3966_ISDN_SUBADDRESS_ = ';isub=';\n/**\r\n * Extracts the value of the phone-context parameter of `numberToExtractFrom`,\r\n * following the syntax defined in RFC3966.\r\n *\r\n * @param {string} numberToExtractFrom\r\n * @return {string|null} the extracted string (possibly empty), or `null` if no phone-context parameter is found.\r\n */\n\nfunction extractPhoneContext(numberToExtractFrom) {\n  var indexOfPhoneContext = numberToExtractFrom.indexOf(RFC3966_PHONE_CONTEXT_); // If no phone-context parameter is present\n\n  if (indexOfPhoneContext < 0) {\n    return null;\n  }\n\n  var phoneContextStart = indexOfPhoneContext + RFC3966_PHONE_CONTEXT_.length; // If phone-context parameter is empty\n\n  if (phoneContextStart >= numberToExtractFrom.length) {\n    return '';\n  }\n\n  var phoneContextEnd = numberToExtractFrom.indexOf(';', phoneContextStart); // If phone-context is not the last parameter\n\n  if (phoneContextEnd >= 0) {\n    return numberToExtractFrom.substring(phoneContextStart, phoneContextEnd);\n  } else {\n    return numberToExtractFrom.substring(phoneContextStart);\n  }\n}\n/**\r\n * Returns whether the value of phoneContext follows the syntax defined in RFC3966.\r\n *\r\n * @param {string|null} phoneContext\r\n * @return {boolean}\r\n */\n\nfunction isPhoneContextValid(phoneContext) {\n  if (phoneContext === null) {\n    return true;\n  }\n\n  if (phoneContext.length === 0) {\n    return false;\n  } // Does phone-context value match pattern of global-number-digits or domainname.\n\n\n  return RFC3966_GLOBAL_NUMBER_DIGITS_PATTERN_.test(phoneContext) || RFC3966_DOMAINNAME_PATTERN_.test(phoneContext);\n}\n//# sourceMappingURL=extractPhoneContext.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/extractPhoneContext.js\n");

/***/ }),

/***/ "(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/formatNationalNumberUsingFormat.js":
/*!*****************************************************************************************************************************************!*\
  !*** ../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/formatNationalNumberUsingFormat.js ***!
  \*****************************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   FIRST_GROUP_PATTERN: () => (/* binding */ FIRST_GROUP_PATTERN),\n/* harmony export */   \"default\": () => (/* binding */ formatNationalNumberUsingFormat)\n/* harmony export */ });\n/* harmony import */ var _applyInternationalSeparatorStyle_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./applyInternationalSeparatorStyle.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/applyInternationalSeparatorStyle.js\");\n // This was originally set to $1 but there are some countries for which the\n// first group is not used in the national pattern (e.g. Argentina) so the $1\n// group does not match correctly. Therefore, we use `\\d`, so that the first\n// group actually used in the pattern will be matched.\n\nvar FIRST_GROUP_PATTERN = /(\\$\\d)/;\nfunction formatNationalNumberUsingFormat(number, format, _ref) {\n  var useInternationalFormat = _ref.useInternationalFormat,\n      withNationalPrefix = _ref.withNationalPrefix,\n      carrierCode = _ref.carrierCode,\n      metadata = _ref.metadata;\n  var formattedNumber = number.replace(new RegExp(format.pattern()), useInternationalFormat ? format.internationalFormat() : // This library doesn't use `domestic_carrier_code_formatting_rule`,\n  // because that one is only used when formatting phone numbers\n  // for dialing from a mobile phone, and this is not a dialing library.\n  // carrierCode && format.domesticCarrierCodeFormattingRule()\n  // \t// First, replace the $CC in the formatting rule with the desired carrier code.\n  // \t// Then, replace the $FG in the formatting rule with the first group\n  // \t// and the carrier code combined in the appropriate way.\n  // \t? format.format().replace(FIRST_GROUP_PATTERN, format.domesticCarrierCodeFormattingRule().replace('$CC', carrierCode))\n  // \t: (\n  // \t\twithNationalPrefix && format.nationalPrefixFormattingRule()\n  // \t\t\t? format.format().replace(FIRST_GROUP_PATTERN, format.nationalPrefixFormattingRule())\n  // \t\t\t: format.format()\n  // \t)\n  withNationalPrefix && format.nationalPrefixFormattingRule() ? format.format().replace(FIRST_GROUP_PATTERN, format.nationalPrefixFormattingRule()) : format.format());\n\n  if (useInternationalFormat) {\n    return (0,_applyInternationalSeparatorStyle_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(formattedNumber);\n  }\n\n  return formattedNumber;\n}\n//# sourceMappingURL=formatNationalNumberUsingFormat.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/formatNationalNumberUsingFormat.js\n");

/***/ }),

/***/ "(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/getCountryByCallingCode.js":
/*!*********************************************************************************************************************************!*\
  !*** ../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/getCountryByCallingCode.js ***!
  \*********************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ getCountryByCallingCode)\n/* harmony export */ });\n/* harmony import */ var _getCountryByNationalNumber_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getCountryByNationalNumber.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/getCountryByNationalNumber.js\");\n\nvar USE_NON_GEOGRAPHIC_COUNTRY_CODE = false;\nfunction getCountryByCallingCode(callingCode, _ref) {\n  var nationalPhoneNumber = _ref.nationalNumber,\n      defaultCountry = _ref.defaultCountry,\n      metadata = _ref.metadata;\n\n  /* istanbul ignore if */\n  if (USE_NON_GEOGRAPHIC_COUNTRY_CODE) {\n    if (metadata.isNonGeographicCallingCode(callingCode)) {\n      return '001';\n    }\n  }\n\n  var possibleCountries = metadata.getCountryCodesForCallingCode(callingCode);\n\n  if (!possibleCountries) {\n    return;\n  } // If there's just one country corresponding to the country code,\n  // then just return it, without further phone number digits validation.\n\n\n  if (possibleCountries.length === 1) {\n    return possibleCountries[0];\n  }\n\n  return (0,_getCountryByNationalNumber_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(nationalPhoneNumber, {\n    countries: possibleCountries,\n    defaultCountry: defaultCountry,\n    metadata: metadata.metadata\n  });\n}\n//# sourceMappingURL=getCountryByCallingCode.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/getCountryByCallingCode.js\n");

/***/ }),

/***/ "(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/getCountryByNationalNumber.js":
/*!************************************************************************************************************************************!*\
  !*** ../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/getCountryByNationalNumber.js ***!
  \************************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ getCountryByNationalNumber)\n/* harmony export */ });\n/* harmony import */ var _metadata_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../metadata.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/metadata.js\");\n/* harmony import */ var _getNumberType_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./getNumberType.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/getNumberType.js\");\nfunction _createForOfIteratorHelperLoose(o, allowArrayLike) { var it = typeof Symbol !== \"undefined\" && o[Symbol.iterator] || o[\"@@iterator\"]; if (it) return (it = it.call(o)).next.bind(it); if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === \"number\") { if (it) o = it; var i = 0; return function () { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }; } throw new TypeError(\"Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\n\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\n\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }\n\n\n\nfunction getCountryByNationalNumber(nationalPhoneNumber, _ref) {\n  var countries = _ref.countries,\n      defaultCountry = _ref.defaultCountry,\n      metadata = _ref.metadata;\n  // Re-create `metadata` because it will be selecting a `country`.\n  metadata = new _metadata_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"](metadata); // const matchingCountries = []\n\n  for (var _iterator = _createForOfIteratorHelperLoose(countries), _step; !(_step = _iterator()).done;) {\n    var country = _step.value;\n    metadata.country(country); // \"Leading digits\" patterns are only defined for about 20% of all countries.\n    // By definition, matching \"leading digits\" is a sufficient but not a necessary\n    // condition for a phone number to belong to a country.\n    // The point of \"leading digits\" check is that it's the fastest one to get a match.\n    // https://gitlab.com/catamphetamine/libphonenumber-js/blob/master/METADATA.md#leading_digits\n    // I'd suppose that \"leading digits\" patterns are mutually exclusive for different countries\n    // because of the intended use of that feature.\n\n    if (metadata.leadingDigits()) {\n      if (nationalPhoneNumber && nationalPhoneNumber.search(metadata.leadingDigits()) === 0) {\n        return country;\n      }\n    } // Else perform full validation with all of those\n    // fixed-line/mobile/etc regular expressions.\n    else if ((0,_getNumberType_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])({\n      phone: nationalPhoneNumber,\n      country: country\n    }, undefined, metadata.metadata)) {\n      // If both the `defaultCountry` and the \"main\" one match the phone number,\n      // don't prefer the `defaultCountry` over the \"main\" one.\n      // https://gitlab.com/catamphetamine/libphonenumber-js/-/issues/154\n      return country; // // If the `defaultCountry` is among the `matchingCountries` then return it.\n      // if (defaultCountry) {\n      // \tif (country === defaultCountry) {\n      // \t\treturn country\n      // \t}\n      // \tmatchingCountries.push(country)\n      // } else {\n      // \treturn country\n      // }\n    }\n  } // // Return the first (\"main\") one of the `matchingCountries`.\n  // if (matchingCountries.length > 0) {\n  // \treturn matchingCountries[0]\n  // }\n\n}\n//# sourceMappingURL=getCountryByNationalNumber.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/getCountryByNationalNumber.js\n");

/***/ }),

/***/ "(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/getIddPrefix.js":
/*!**********************************************************************************************************************!*\
  !*** ../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/getIddPrefix.js ***!
  \**********************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ getIddPrefix)\n/* harmony export */ });\n/* harmony import */ var _metadata_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../metadata.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/metadata.js\");\n\n/**\r\n * Pattern that makes it easy to distinguish whether a region has a single\r\n * international dialing prefix or not. If a region has a single international\r\n * prefix (e.g. 011 in USA), it will be represented as a string that contains\r\n * a sequence of ASCII digits, and possibly a tilde, which signals waiting for\r\n * the tone. If there are multiple available international prefixes in a\r\n * region, they will be represented as a regex string that always contains one\r\n * or more characters that are not ASCII digits or a tilde.\r\n */\n\nvar SINGLE_IDD_PREFIX_REG_EXP = /^[\\d]+(?:[~\\u2053\\u223C\\uFF5E][\\d]+)?$/; // For regions that have multiple IDD prefixes\n// a preferred IDD prefix is returned.\n\nfunction getIddPrefix(country, callingCode, metadata) {\n  var countryMetadata = new _metadata_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"](metadata);\n  countryMetadata.selectNumberingPlan(country, callingCode);\n\n  if (countryMetadata.defaultIDDPrefix()) {\n    return countryMetadata.defaultIDDPrefix();\n  }\n\n  if (SINGLE_IDD_PREFIX_REG_EXP.test(countryMetadata.IDDPrefix())) {\n    return countryMetadata.IDDPrefix();\n  }\n}\n//# sourceMappingURL=getIddPrefix.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/getIddPrefix.js\n");

/***/ }),

/***/ "(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/getNumberType.js":
/*!***********************************************************************************************************************!*\
  !*** ../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/getNumberType.js ***!
  \***********************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ getNumberType),\n/* harmony export */   isNumberTypeEqualTo: () => (/* binding */ isNumberTypeEqualTo)\n/* harmony export */ });\n/* harmony import */ var _metadata_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../metadata.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/metadata.js\");\n/* harmony import */ var _matchesEntirely_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./matchesEntirely.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/matchesEntirely.js\");\nfunction _createForOfIteratorHelperLoose(o, allowArrayLike) { var it = typeof Symbol !== \"undefined\" && o[Symbol.iterator] || o[\"@@iterator\"]; if (it) return (it = it.call(o)).next.bind(it); if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === \"number\") { if (it) o = it; var i = 0; return function () { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }; } throw new TypeError(\"Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\n\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\n\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }\n\n\n\nvar NON_FIXED_LINE_PHONE_TYPES = ['MOBILE', 'PREMIUM_RATE', 'TOLL_FREE', 'SHARED_COST', 'VOIP', 'PERSONAL_NUMBER', 'PAGER', 'UAN', 'VOICEMAIL']; // Finds out national phone number type (fixed line, mobile, etc)\n\nfunction getNumberType(input, options, metadata) {\n  // If assigning the `{}` default value is moved to the arguments above,\n  // code coverage would decrease for some weird reason.\n  options = options || {}; // When `parse()` returns an empty object — `{}` —\n  // that means that the phone number is malformed,\n  // so it can't possibly be valid.\n\n  if (!input.country && !input.countryCallingCode) {\n    return;\n  }\n\n  metadata = new _metadata_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"](metadata);\n  metadata.selectNumberingPlan(input.country, input.countryCallingCode);\n  var nationalNumber = options.v2 ? input.nationalNumber : input.phone; // The following is copy-pasted from the original function:\n  // https://github.com/googlei18n/libphonenumber/blob/3ea547d4fbaa2d0b67588904dfa5d3f2557c27ff/javascript/i18n/phonenumbers/phonenumberutil.js#L2835\n  // Is this national number even valid for this country\n\n  if (!(0,_matchesEntirely_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(nationalNumber, metadata.nationalNumberPattern())) {\n    return;\n  } // Is it fixed line number\n\n\n  if (isNumberTypeEqualTo(nationalNumber, 'FIXED_LINE', metadata)) {\n    // Because duplicate regular expressions are removed\n    // to reduce metadata size, if \"mobile\" pattern is \"\"\n    // then it means it was removed due to being a duplicate of the fixed-line pattern.\n    //\n    if (metadata.type('MOBILE') && metadata.type('MOBILE').pattern() === '') {\n      return 'FIXED_LINE_OR_MOBILE';\n    } // `MOBILE` type pattern isn't included if it matched `FIXED_LINE` one.\n    // For example, for \"US\" country.\n    // Old metadata (< `1.0.18`) had a specific \"types\" data structure\n    // that happened to be `undefined` for `MOBILE` in that case.\n    // Newer metadata (>= `1.0.18`) has another data structure that is\n    // not `undefined` for `MOBILE` in that case (it's just an empty array).\n    // So this `if` is just for backwards compatibility with old metadata.\n\n\n    if (!metadata.type('MOBILE')) {\n      return 'FIXED_LINE_OR_MOBILE';\n    } // Check if the number happens to qualify as both fixed line and mobile.\n    // (no such country in the minimal metadata set)\n\n    /* istanbul ignore if */\n\n\n    if (isNumberTypeEqualTo(nationalNumber, 'MOBILE', metadata)) {\n      return 'FIXED_LINE_OR_MOBILE';\n    }\n\n    return 'FIXED_LINE';\n  }\n\n  for (var _iterator = _createForOfIteratorHelperLoose(NON_FIXED_LINE_PHONE_TYPES), _step; !(_step = _iterator()).done;) {\n    var type = _step.value;\n\n    if (isNumberTypeEqualTo(nationalNumber, type, metadata)) {\n      return type;\n    }\n  }\n}\nfunction isNumberTypeEqualTo(nationalNumber, type, metadata) {\n  type = metadata.type(type);\n\n  if (!type || !type.pattern()) {\n    return false;\n  } // Check if any possible number lengths are present;\n  // if so, we use them to avoid checking\n  // the validation pattern if they don't match.\n  // If they are absent, this means they match\n  // the general description, which we have\n  // already checked before a specific number type.\n\n\n  if (type.possibleLengths() && type.possibleLengths().indexOf(nationalNumber.length) < 0) {\n    return false;\n  }\n\n  return (0,_matchesEntirely_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(nationalNumber, type.pattern());\n}\n//# sourceMappingURL=getNumberType.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/getNumberType.js\n");

/***/ }),

/***/ "(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/getPossibleCountriesForNumber.js":
/*!***************************************************************************************************************************************!*\
  !*** ../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/getPossibleCountriesForNumber.js ***!
  \***************************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ getPossibleCountriesForNumber)\n/* harmony export */ });\n/* harmony import */ var _metadata_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../metadata.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/metadata.js\");\n\n/**\r\n * Returns a list of countries that the phone number could potentially belong to.\r\n * @param  {string} callingCode — Calling code.\r\n * @param  {string} nationalNumber — National (significant) number.\r\n * @param  {object} metadata — Metadata.\r\n * @return {string[]} A list of possible countries.\r\n */\n\nfunction getPossibleCountriesForNumber(callingCode, nationalNumber, metadata) {\n  var _metadata = new _metadata_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"](metadata);\n\n  var possibleCountries = _metadata.getCountryCodesForCallingCode(callingCode);\n\n  if (!possibleCountries) {\n    return [];\n  }\n\n  return possibleCountries.filter(function (country) {\n    return couldNationalNumberBelongToCountry(nationalNumber, country, metadata);\n  });\n}\n\nfunction couldNationalNumberBelongToCountry(nationalNumber, country, metadata) {\n  var _metadata = new _metadata_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"](metadata);\n\n  _metadata.selectNumberingPlan(country);\n\n  if (_metadata.numberingPlan.possibleLengths().indexOf(nationalNumber.length) >= 0) {\n    return true;\n  }\n\n  return false;\n}\n//# sourceMappingURL=getPossibleCountriesForNumber.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/getPossibleCountriesForNumber.js\n");

/***/ }),

/***/ "(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/isObject.js":
/*!******************************************************************************************************************!*\
  !*** ../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/isObject.js ***!
  \******************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ isObject)\n/* harmony export */ });\nvar objectConstructor = {}.constructor;\nfunction isObject(object) {\n  return object !== undefined && object !== null && object.constructor === objectConstructor;\n}\n//# sourceMappingURL=isObject.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi4vbm9kZXZlbnYvc3RhZ2luZy5hZ2VudGFtYml0aW9uYWNhZGVteS5jb20vMjAvbGliL25vZGVfbW9kdWxlcy9saWJwaG9uZW51bWJlci1qcy9lczYvaGVscGVycy9pc09iamVjdC5qcyIsIm1hcHBpbmdzIjoiOzs7O0FBQUEsMEJBQTBCO0FBQ1g7QUFDZjtBQUNBO0FBQ0EiLCJzb3VyY2VzIjpbIi9ob21lL2FnZW50YW1iaXRpb25hY2Evbm9kZXZlbnYvc3RhZ2luZy5hZ2VudGFtYml0aW9uYWNhZGVteS5jb20vMjAvbGliL25vZGVfbW9kdWxlcy9saWJwaG9uZW51bWJlci1qcy9lczYvaGVscGVycy9pc09iamVjdC5qcyJdLCJzb3VyY2VzQ29udGVudCI6WyJ2YXIgb2JqZWN0Q29uc3RydWN0b3IgPSB7fS5jb25zdHJ1Y3RvcjtcbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIGlzT2JqZWN0KG9iamVjdCkge1xuICByZXR1cm4gb2JqZWN0ICE9PSB1bmRlZmluZWQgJiYgb2JqZWN0ICE9PSBudWxsICYmIG9iamVjdC5jb25zdHJ1Y3RvciA9PT0gb2JqZWN0Q29uc3RydWN0b3I7XG59XG4vLyMgc291cmNlTWFwcGluZ1VSTD1pc09iamVjdC5qcy5tYXAiXSwibmFtZXMiOltdLCJpZ25vcmVMaXN0IjpbMF0sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/isObject.js\n");

/***/ }),

/***/ "(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/isViablePhoneNumber.js":
/*!*****************************************************************************************************************************!*\
  !*** ../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/isViablePhoneNumber.js ***!
  \*****************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   VALID_PHONE_NUMBER: () => (/* binding */ VALID_PHONE_NUMBER),\n/* harmony export */   VALID_PHONE_NUMBER_WITH_EXTENSION: () => (/* binding */ VALID_PHONE_NUMBER_WITH_EXTENSION),\n/* harmony export */   \"default\": () => (/* binding */ isViablePhoneNumber),\n/* harmony export */   isViablePhoneNumberStart: () => (/* binding */ isViablePhoneNumberStart)\n/* harmony export */ });\n/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../constants.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/constants.js\");\n/* harmony import */ var _extension_createExtensionPattern_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./extension/createExtensionPattern.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/extension/createExtensionPattern.js\");\n\n //  Regular expression of viable phone numbers. This is location independent.\n//  Checks we have at least three leading digits, and only valid punctuation,\n//  alpha characters and digits in the phone number. Does not include extension\n//  data. The symbol 'x' is allowed here as valid punctuation since it is often\n//  used as a placeholder for carrier codes, for example in Brazilian phone\n//  numbers. We also allow multiple '+' characters at the start.\n//\n//  Corresponds to the following:\n//  [digits]{minLengthNsn}|\n//  plus_sign*\n//  (([punctuation]|[star])*[digits]){3,}([punctuation]|[star]|[digits]|[alpha])*\n//\n//  The first reg-ex is to allow short numbers (two digits long) to be parsed if\n//  they are entered as \"15\" etc, but only if there is no punctuation in them.\n//  The second expression restricts the number of digits to three or more, but\n//  then allows them to be in international form, and to have alpha-characters\n//  and punctuation. We split up the two reg-exes here and combine them when\n//  creating the reg-ex VALID_PHONE_NUMBER_PATTERN itself so we can prefix it\n//  with ^ and append $ to each branch.\n//\n//  \"Note VALID_PUNCTUATION starts with a -,\n//   so must be the first in the range\" (c) Google devs.\n//  (wtf did they mean by saying that; probably nothing)\n//\n\nvar MIN_LENGTH_PHONE_NUMBER_PATTERN = '[' + _constants_js__WEBPACK_IMPORTED_MODULE_0__.VALID_DIGITS + ']{' + _constants_js__WEBPACK_IMPORTED_MODULE_0__.MIN_LENGTH_FOR_NSN + '}'; //\n// And this is the second reg-exp:\n// (see MIN_LENGTH_PHONE_NUMBER_PATTERN for a full description of this reg-exp)\n//\n\nvar VALID_PHONE_NUMBER = '[' + _constants_js__WEBPACK_IMPORTED_MODULE_0__.PLUS_CHARS + ']{0,1}' + '(?:' + '[' + _constants_js__WEBPACK_IMPORTED_MODULE_0__.VALID_PUNCTUATION + ']*' + '[' + _constants_js__WEBPACK_IMPORTED_MODULE_0__.VALID_DIGITS + ']' + '){3,}' + '[' + _constants_js__WEBPACK_IMPORTED_MODULE_0__.VALID_PUNCTUATION + _constants_js__WEBPACK_IMPORTED_MODULE_0__.VALID_DIGITS + ']*'; // This regular expression isn't present in Google's `libphonenumber`\n// and is only used to determine whether the phone number being input\n// is too short for it to even consider it a \"valid\" number.\n// This is just a way to differentiate between a really invalid phone\n// number like \"abcde\" and a valid phone number that a user has just\n// started inputting, like \"+1\" or \"1\": both these cases would be\n// considered `NOT_A_NUMBER` by Google's `libphonenumber`, but this\n// library can provide a more detailed error message — whether it's\n// really \"not a number\", or is it just a start of a valid phone number.\n\nvar VALID_PHONE_NUMBER_START_REG_EXP = new RegExp('^' + '[' + _constants_js__WEBPACK_IMPORTED_MODULE_0__.PLUS_CHARS + ']{0,1}' + '(?:' + '[' + _constants_js__WEBPACK_IMPORTED_MODULE_0__.VALID_PUNCTUATION + ']*' + '[' + _constants_js__WEBPACK_IMPORTED_MODULE_0__.VALID_DIGITS + ']' + '){1,2}' + '$', 'i');\nvar VALID_PHONE_NUMBER_WITH_EXTENSION = VALID_PHONE_NUMBER + // Phone number extensions\n'(?:' + (0,_extension_createExtensionPattern_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])() + ')?'; // The combined regular expression for valid phone numbers:\n//\n\nvar VALID_PHONE_NUMBER_PATTERN = new RegExp( // Either a short two-digit-only phone number\n'^' + MIN_LENGTH_PHONE_NUMBER_PATTERN + '$' + '|' + // Or a longer fully parsed phone number (min 3 characters)\n'^' + VALID_PHONE_NUMBER_WITH_EXTENSION + '$', 'i'); // Checks to see if the string of characters could possibly be a phone number at\n// all. At the moment, checks to see that the string begins with at least 2\n// digits, ignoring any punctuation commonly found in phone numbers. This method\n// does not require the number to be normalized in advance - but does assume\n// that leading non-number symbols have been removed, such as by the method\n// `extract_possible_number`.\n//\n\nfunction isViablePhoneNumber(number) {\n  return number.length >= _constants_js__WEBPACK_IMPORTED_MODULE_0__.MIN_LENGTH_FOR_NSN && VALID_PHONE_NUMBER_PATTERN.test(number);\n} // This is just a way to differentiate between a really invalid phone\n// number like \"abcde\" and a valid phone number that a user has just\n// started inputting, like \"+1\" or \"1\": both these cases would be\n// considered `NOT_A_NUMBER` by Google's `libphonenumber`, but this\n// library can provide a more detailed error message — whether it's\n// really \"not a number\", or is it just a start of a valid phone number.\n\nfunction isViablePhoneNumberStart(number) {\n  return VALID_PHONE_NUMBER_START_REG_EXP.test(number);\n}\n//# sourceMappingURL=isViablePhoneNumber.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/isViablePhoneNumber.js\n");

/***/ }),

/***/ "(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/matchesEntirely.js":
/*!*************************************************************************************************************************!*\
  !*** ../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/matchesEntirely.js ***!
  \*************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ matchesEntirely)\n/* harmony export */ });\n/**\r\n * Checks whether the entire input sequence can be matched\r\n * against the regular expression.\r\n * @return {boolean}\r\n */\nfunction matchesEntirely(text, regular_expression) {\n  // If assigning the `''` default value is moved to the arguments above,\n  // code coverage would decrease for some weird reason.\n  text = text || '';\n  return new RegExp('^(?:' + regular_expression + ')$').test(text);\n}\n//# sourceMappingURL=matchesEntirely.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi4vbm9kZXZlbnYvc3RhZ2luZy5hZ2VudGFtYml0aW9uYWNhZGVteS5jb20vMjAvbGliL25vZGVfbW9kdWxlcy9saWJwaG9uZW51bWJlci1qcy9lczYvaGVscGVycy9tYXRjaGVzRW50aXJlbHkuanMiLCJtYXBwaW5ncyI6Ijs7OztBQUFBO0FBQ0E7QUFDQTtBQUNBLFlBQVk7QUFDWjtBQUNlO0FBQ2Y7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBIiwic291cmNlcyI6WyIvaG9tZS9hZ2VudGFtYml0aW9uYWNhL25vZGV2ZW52L3N0YWdpbmcuYWdlbnRhbWJpdGlvbmFjYWRlbXkuY29tLzIwL2xpYi9ub2RlX21vZHVsZXMvbGlicGhvbmVudW1iZXItanMvZXM2L2hlbHBlcnMvbWF0Y2hlc0VudGlyZWx5LmpzIl0sInNvdXJjZXNDb250ZW50IjpbIi8qKlxyXG4gKiBDaGVja3Mgd2hldGhlciB0aGUgZW50aXJlIGlucHV0IHNlcXVlbmNlIGNhbiBiZSBtYXRjaGVkXHJcbiAqIGFnYWluc3QgdGhlIHJlZ3VsYXIgZXhwcmVzc2lvbi5cclxuICogQHJldHVybiB7Ym9vbGVhbn1cclxuICovXG5leHBvcnQgZGVmYXVsdCBmdW5jdGlvbiBtYXRjaGVzRW50aXJlbHkodGV4dCwgcmVndWxhcl9leHByZXNzaW9uKSB7XG4gIC8vIElmIGFzc2lnbmluZyB0aGUgYCcnYCBkZWZhdWx0IHZhbHVlIGlzIG1vdmVkIHRvIHRoZSBhcmd1bWVudHMgYWJvdmUsXG4gIC8vIGNvZGUgY292ZXJhZ2Ugd291bGQgZGVjcmVhc2UgZm9yIHNvbWUgd2VpcmQgcmVhc29uLlxuICB0ZXh0ID0gdGV4dCB8fCAnJztcbiAgcmV0dXJuIG5ldyBSZWdFeHAoJ14oPzonICsgcmVndWxhcl9leHByZXNzaW9uICsgJykkJykudGVzdCh0ZXh0KTtcbn1cbi8vIyBzb3VyY2VNYXBwaW5nVVJMPW1hdGNoZXNFbnRpcmVseS5qcy5tYXAiXSwibmFtZXMiOltdLCJpZ25vcmVMaXN0IjpbMF0sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/matchesEntirely.js\n");

/***/ }),

/***/ "(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/mergeArrays.js":
/*!*********************************************************************************************************************!*\
  !*** ../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/mergeArrays.js ***!
  \*********************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ mergeArrays)\n/* harmony export */ });\nfunction _createForOfIteratorHelperLoose(o, allowArrayLike) { var it = typeof Symbol !== \"undefined\" && o[Symbol.iterator] || o[\"@@iterator\"]; if (it) return (it = it.call(o)).next.bind(it); if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === \"number\") { if (it) o = it; var i = 0; return function () { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }; } throw new TypeError(\"Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\n\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\n\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }\n\n/**\r\n * Merges two arrays.\r\n * @param  {*} a\r\n * @param  {*} b\r\n * @return {*}\r\n */\nfunction mergeArrays(a, b) {\n  var merged = a.slice();\n\n  for (var _iterator = _createForOfIteratorHelperLoose(b), _step; !(_step = _iterator()).done;) {\n    var element = _step.value;\n\n    if (a.indexOf(element) < 0) {\n      merged.push(element);\n    }\n  }\n\n  return merged.sort(function (a, b) {\n    return a - b;\n  }); // ES6 version, requires Set polyfill.\n  // let merged = new Set(a)\n  // for (const element of b) {\n  // \tmerged.add(i)\n  // }\n  // return Array.from(merged).sort((a, b) => a - b)\n}\n//# sourceMappingURL=mergeArrays.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/mergeArrays.js\n");

/***/ }),

/***/ "(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/parseDigits.js":
/*!*********************************************************************************************************************!*\
  !*** ../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/parseDigits.js ***!
  \*********************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   DIGITS: () => (/* binding */ DIGITS),\n/* harmony export */   \"default\": () => (/* binding */ parseDigits),\n/* harmony export */   parseDigit: () => (/* binding */ parseDigit)\n/* harmony export */ });\nfunction _createForOfIteratorHelperLoose(o, allowArrayLike) { var it = typeof Symbol !== \"undefined\" && o[Symbol.iterator] || o[\"@@iterator\"]; if (it) return (it = it.call(o)).next.bind(it); if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === \"number\") { if (it) o = it; var i = 0; return function () { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }; } throw new TypeError(\"Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\n\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\n\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }\n\n// These mappings map a character (key) to a specific digit that should\n// replace it for normalization purposes. Non-European digits that\n// may be used in phone numbers are mapped to a European equivalent.\n//\n// E.g. in Iraq they don't write `+442323234` but rather `+٤٤٢٣٢٣٢٣٤`.\n//\nvar DIGITS = {\n  '0': '0',\n  '1': '1',\n  '2': '2',\n  '3': '3',\n  '4': '4',\n  '5': '5',\n  '6': '6',\n  '7': '7',\n  '8': '8',\n  '9': '9',\n  \"\\uFF10\": '0',\n  // Fullwidth digit 0\n  \"\\uFF11\": '1',\n  // Fullwidth digit 1\n  \"\\uFF12\": '2',\n  // Fullwidth digit 2\n  \"\\uFF13\": '3',\n  // Fullwidth digit 3\n  \"\\uFF14\": '4',\n  // Fullwidth digit 4\n  \"\\uFF15\": '5',\n  // Fullwidth digit 5\n  \"\\uFF16\": '6',\n  // Fullwidth digit 6\n  \"\\uFF17\": '7',\n  // Fullwidth digit 7\n  \"\\uFF18\": '8',\n  // Fullwidth digit 8\n  \"\\uFF19\": '9',\n  // Fullwidth digit 9\n  \"\\u0660\": '0',\n  // Arabic-indic digit 0\n  \"\\u0661\": '1',\n  // Arabic-indic digit 1\n  \"\\u0662\": '2',\n  // Arabic-indic digit 2\n  \"\\u0663\": '3',\n  // Arabic-indic digit 3\n  \"\\u0664\": '4',\n  // Arabic-indic digit 4\n  \"\\u0665\": '5',\n  // Arabic-indic digit 5\n  \"\\u0666\": '6',\n  // Arabic-indic digit 6\n  \"\\u0667\": '7',\n  // Arabic-indic digit 7\n  \"\\u0668\": '8',\n  // Arabic-indic digit 8\n  \"\\u0669\": '9',\n  // Arabic-indic digit 9\n  \"\\u06F0\": '0',\n  // Eastern-Arabic digit 0\n  \"\\u06F1\": '1',\n  // Eastern-Arabic digit 1\n  \"\\u06F2\": '2',\n  // Eastern-Arabic digit 2\n  \"\\u06F3\": '3',\n  // Eastern-Arabic digit 3\n  \"\\u06F4\": '4',\n  // Eastern-Arabic digit 4\n  \"\\u06F5\": '5',\n  // Eastern-Arabic digit 5\n  \"\\u06F6\": '6',\n  // Eastern-Arabic digit 6\n  \"\\u06F7\": '7',\n  // Eastern-Arabic digit 7\n  \"\\u06F8\": '8',\n  // Eastern-Arabic digit 8\n  \"\\u06F9\": '9' // Eastern-Arabic digit 9\n\n};\nfunction parseDigit(character) {\n  return DIGITS[character];\n}\n/**\r\n * Parses phone number digits from a string.\r\n * Drops all punctuation leaving only digits.\r\n * Also converts wide-ascii and arabic-indic numerals to conventional numerals.\r\n * E.g. in Iraq they don't write `+442323234` but rather `+٤٤٢٣٢٣٢٣٤`.\r\n * @param  {string} string\r\n * @return {string}\r\n * @example\r\n * ```js\r\n * parseDigits('8 (800) 555')\r\n * // Outputs '8800555'.\r\n * ```\r\n */\n\nfunction parseDigits(string) {\n  var result = ''; // Using `.split('')` here instead of normal `for ... of`\n  // because the importing application doesn't neccessarily include an ES6 polyfill.\n  // The `.split('')` approach discards \"exotic\" UTF-8 characters\n  // (the ones consisting of four bytes) but digits\n  // (including non-European ones) don't fall into that range\n  // so such \"exotic\" characters would be discarded anyway.\n\n  for (var _iterator = _createForOfIteratorHelperLoose(string.split('')), _step; !(_step = _iterator()).done;) {\n    var character = _step.value;\n    var digit = parseDigit(character);\n\n    if (digit) {\n      result += digit;\n    }\n  }\n\n  return result;\n}\n//# sourceMappingURL=parseDigits.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi4vbm9kZXZlbnYvc3RhZ2luZy5hZ2VudGFtYml0aW9uYWNhZGVteS5jb20vMjAvbGliL25vZGVfbW9kdWxlcy9saWJwaG9uZW51bWJlci1qcy9lczYvaGVscGVycy9wYXJzZURpZ2l0cy5qcyIsIm1hcHBpbmdzIjoiOzs7Ozs7QUFBQSw4REFBOEQsaUZBQWlGLGdEQUFnRCx3SEFBd0gsZ0JBQWdCLFdBQVcscUJBQXFCLDRCQUE0QixjQUFjLFNBQVMsbUNBQW1DOztBQUU3YixrREFBa0QsZ0JBQWdCLGdFQUFnRSx3REFBd0QsNkRBQTZELHNEQUFzRDs7QUFFN1MsdUNBQXVDLHVEQUF1RCx1Q0FBdUMsU0FBUyxPQUFPLG9CQUFvQjs7QUFFeks7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ087QUFDUDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDTztBQUNQO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsWUFBWSxRQUFRO0FBQ3BCLFlBQVk7QUFDWjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRWU7QUFDZixtQkFBbUI7QUFDbkI7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQSxpRkFBaUYsNEJBQTRCO0FBQzdHO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBIiwic291cmNlcyI6WyIvaG9tZS9hZ2VudGFtYml0aW9uYWNhL25vZGV2ZW52L3N0YWdpbmcuYWdlbnRhbWJpdGlvbmFjYWRlbXkuY29tLzIwL2xpYi9ub2RlX21vZHVsZXMvbGlicGhvbmVudW1iZXItanMvZXM2L2hlbHBlcnMvcGFyc2VEaWdpdHMuanMiXSwic291cmNlc0NvbnRlbnQiOlsiZnVuY3Rpb24gX2NyZWF0ZUZvck9mSXRlcmF0b3JIZWxwZXJMb29zZShvLCBhbGxvd0FycmF5TGlrZSkgeyB2YXIgaXQgPSB0eXBlb2YgU3ltYm9sICE9PSBcInVuZGVmaW5lZFwiICYmIG9bU3ltYm9sLml0ZXJhdG9yXSB8fCBvW1wiQEBpdGVyYXRvclwiXTsgaWYgKGl0KSByZXR1cm4gKGl0ID0gaXQuY2FsbChvKSkubmV4dC5iaW5kKGl0KTsgaWYgKEFycmF5LmlzQXJyYXkobykgfHwgKGl0ID0gX3Vuc3VwcG9ydGVkSXRlcmFibGVUb0FycmF5KG8pKSB8fCBhbGxvd0FycmF5TGlrZSAmJiBvICYmIHR5cGVvZiBvLmxlbmd0aCA9PT0gXCJudW1iZXJcIikgeyBpZiAoaXQpIG8gPSBpdDsgdmFyIGkgPSAwOyByZXR1cm4gZnVuY3Rpb24gKCkgeyBpZiAoaSA+PSBvLmxlbmd0aCkgcmV0dXJuIHsgZG9uZTogdHJ1ZSB9OyByZXR1cm4geyBkb25lOiBmYWxzZSwgdmFsdWU6IG9baSsrXSB9OyB9OyB9IHRocm93IG5ldyBUeXBlRXJyb3IoXCJJbnZhbGlkIGF0dGVtcHQgdG8gaXRlcmF0ZSBub24taXRlcmFibGUgaW5zdGFuY2UuXFxuSW4gb3JkZXIgdG8gYmUgaXRlcmFibGUsIG5vbi1hcnJheSBvYmplY3RzIG11c3QgaGF2ZSBhIFtTeW1ib2wuaXRlcmF0b3JdKCkgbWV0aG9kLlwiKTsgfVxuXG5mdW5jdGlvbiBfdW5zdXBwb3J0ZWRJdGVyYWJsZVRvQXJyYXkobywgbWluTGVuKSB7IGlmICghbykgcmV0dXJuOyBpZiAodHlwZW9mIG8gPT09IFwic3RyaW5nXCIpIHJldHVybiBfYXJyYXlMaWtlVG9BcnJheShvLCBtaW5MZW4pOyB2YXIgbiA9IE9iamVjdC5wcm90b3R5cGUudG9TdHJpbmcuY2FsbChvKS5zbGljZSg4LCAtMSk7IGlmIChuID09PSBcIk9iamVjdFwiICYmIG8uY29uc3RydWN0b3IpIG4gPSBvLmNvbnN0cnVjdG9yLm5hbWU7IGlmIChuID09PSBcIk1hcFwiIHx8IG4gPT09IFwiU2V0XCIpIHJldHVybiBBcnJheS5mcm9tKG8pOyBpZiAobiA9PT0gXCJBcmd1bWVudHNcIiB8fCAvXig/OlVpfEkpbnQoPzo4fDE2fDMyKSg/OkNsYW1wZWQpP0FycmF5JC8udGVzdChuKSkgcmV0dXJuIF9hcnJheUxpa2VUb0FycmF5KG8sIG1pbkxlbik7IH1cblxuZnVuY3Rpb24gX2FycmF5TGlrZVRvQXJyYXkoYXJyLCBsZW4pIHsgaWYgKGxlbiA9PSBudWxsIHx8IGxlbiA+IGFyci5sZW5ndGgpIGxlbiA9IGFyci5sZW5ndGg7IGZvciAodmFyIGkgPSAwLCBhcnIyID0gbmV3IEFycmF5KGxlbik7IGkgPCBsZW47IGkrKykgeyBhcnIyW2ldID0gYXJyW2ldOyB9IHJldHVybiBhcnIyOyB9XG5cbi8vIFRoZXNlIG1hcHBpbmdzIG1hcCBhIGNoYXJhY3RlciAoa2V5KSB0byBhIHNwZWNpZmljIGRpZ2l0IHRoYXQgc2hvdWxkXG4vLyByZXBsYWNlIGl0IGZvciBub3JtYWxpemF0aW9uIHB1cnBvc2VzLiBOb24tRXVyb3BlYW4gZGlnaXRzIHRoYXRcbi8vIG1heSBiZSB1c2VkIGluIHBob25lIG51bWJlcnMgYXJlIG1hcHBlZCB0byBhIEV1cm9wZWFuIGVxdWl2YWxlbnQuXG4vL1xuLy8gRS5nLiBpbiBJcmFxIHRoZXkgZG9uJ3Qgd3JpdGUgYCs0NDIzMjMyMzRgIGJ1dCByYXRoZXIgYCvZpNmk2aLZo9mi2aPZotmj2aRgLlxuLy9cbmV4cG9ydCB2YXIgRElHSVRTID0ge1xuICAnMCc6ICcwJyxcbiAgJzEnOiAnMScsXG4gICcyJzogJzInLFxuICAnMyc6ICczJyxcbiAgJzQnOiAnNCcsXG4gICc1JzogJzUnLFxuICAnNic6ICc2JyxcbiAgJzcnOiAnNycsXG4gICc4JzogJzgnLFxuICAnOSc6ICc5JyxcbiAgXCJcXHVGRjEwXCI6ICcwJyxcbiAgLy8gRnVsbHdpZHRoIGRpZ2l0IDBcbiAgXCJcXHVGRjExXCI6ICcxJyxcbiAgLy8gRnVsbHdpZHRoIGRpZ2l0IDFcbiAgXCJcXHVGRjEyXCI6ICcyJyxcbiAgLy8gRnVsbHdpZHRoIGRpZ2l0IDJcbiAgXCJcXHVGRjEzXCI6ICczJyxcbiAgLy8gRnVsbHdpZHRoIGRpZ2l0IDNcbiAgXCJcXHVGRjE0XCI6ICc0JyxcbiAgLy8gRnVsbHdpZHRoIGRpZ2l0IDRcbiAgXCJcXHVGRjE1XCI6ICc1JyxcbiAgLy8gRnVsbHdpZHRoIGRpZ2l0IDVcbiAgXCJcXHVGRjE2XCI6ICc2JyxcbiAgLy8gRnVsbHdpZHRoIGRpZ2l0IDZcbiAgXCJcXHVGRjE3XCI6ICc3JyxcbiAgLy8gRnVsbHdpZHRoIGRpZ2l0IDdcbiAgXCJcXHVGRjE4XCI6ICc4JyxcbiAgLy8gRnVsbHdpZHRoIGRpZ2l0IDhcbiAgXCJcXHVGRjE5XCI6ICc5JyxcbiAgLy8gRnVsbHdpZHRoIGRpZ2l0IDlcbiAgXCJcXHUwNjYwXCI6ICcwJyxcbiAgLy8gQXJhYmljLWluZGljIGRpZ2l0IDBcbiAgXCJcXHUwNjYxXCI6ICcxJyxcbiAgLy8gQXJhYmljLWluZGljIGRpZ2l0IDFcbiAgXCJcXHUwNjYyXCI6ICcyJyxcbiAgLy8gQXJhYmljLWluZGljIGRpZ2l0IDJcbiAgXCJcXHUwNjYzXCI6ICczJyxcbiAgLy8gQXJhYmljLWluZGljIGRpZ2l0IDNcbiAgXCJcXHUwNjY0XCI6ICc0JyxcbiAgLy8gQXJhYmljLWluZGljIGRpZ2l0IDRcbiAgXCJcXHUwNjY1XCI6ICc1JyxcbiAgLy8gQXJhYmljLWluZGljIGRpZ2l0IDVcbiAgXCJcXHUwNjY2XCI6ICc2JyxcbiAgLy8gQXJhYmljLWluZGljIGRpZ2l0IDZcbiAgXCJcXHUwNjY3XCI6ICc3JyxcbiAgLy8gQXJhYmljLWluZGljIGRpZ2l0IDdcbiAgXCJcXHUwNjY4XCI6ICc4JyxcbiAgLy8gQXJhYmljLWluZGljIGRpZ2l0IDhcbiAgXCJcXHUwNjY5XCI6ICc5JyxcbiAgLy8gQXJhYmljLWluZGljIGRpZ2l0IDlcbiAgXCJcXHUwNkYwXCI6ICcwJyxcbiAgLy8gRWFzdGVybi1BcmFiaWMgZGlnaXQgMFxuICBcIlxcdTA2RjFcIjogJzEnLFxuICAvLyBFYXN0ZXJuLUFyYWJpYyBkaWdpdCAxXG4gIFwiXFx1MDZGMlwiOiAnMicsXG4gIC8vIEVhc3Rlcm4tQXJhYmljIGRpZ2l0IDJcbiAgXCJcXHUwNkYzXCI6ICczJyxcbiAgLy8gRWFzdGVybi1BcmFiaWMgZGlnaXQgM1xuICBcIlxcdTA2RjRcIjogJzQnLFxuICAvLyBFYXN0ZXJuLUFyYWJpYyBkaWdpdCA0XG4gIFwiXFx1MDZGNVwiOiAnNScsXG4gIC8vIEVhc3Rlcm4tQXJhYmljIGRpZ2l0IDVcbiAgXCJcXHUwNkY2XCI6ICc2JyxcbiAgLy8gRWFzdGVybi1BcmFiaWMgZGlnaXQgNlxuICBcIlxcdTA2RjdcIjogJzcnLFxuICAvLyBFYXN0ZXJuLUFyYWJpYyBkaWdpdCA3XG4gIFwiXFx1MDZGOFwiOiAnOCcsXG4gIC8vIEVhc3Rlcm4tQXJhYmljIGRpZ2l0IDhcbiAgXCJcXHUwNkY5XCI6ICc5JyAvLyBFYXN0ZXJuLUFyYWJpYyBkaWdpdCA5XG5cbn07XG5leHBvcnQgZnVuY3Rpb24gcGFyc2VEaWdpdChjaGFyYWN0ZXIpIHtcbiAgcmV0dXJuIERJR0lUU1tjaGFyYWN0ZXJdO1xufVxuLyoqXHJcbiAqIFBhcnNlcyBwaG9uZSBudW1iZXIgZGlnaXRzIGZyb20gYSBzdHJpbmcuXHJcbiAqIERyb3BzIGFsbCBwdW5jdHVhdGlvbiBsZWF2aW5nIG9ubHkgZGlnaXRzLlxyXG4gKiBBbHNvIGNvbnZlcnRzIHdpZGUtYXNjaWkgYW5kIGFyYWJpYy1pbmRpYyBudW1lcmFscyB0byBjb252ZW50aW9uYWwgbnVtZXJhbHMuXHJcbiAqIEUuZy4gaW4gSXJhcSB0aGV5IGRvbid0IHdyaXRlIGArNDQyMzIzMjM0YCBidXQgcmF0aGVyIGAr2aTZpNmi2aPZotmj2aLZo9mkYC5cclxuICogQHBhcmFtICB7c3RyaW5nfSBzdHJpbmdcclxuICogQHJldHVybiB7c3RyaW5nfVxyXG4gKiBAZXhhbXBsZVxyXG4gKiBgYGBqc1xyXG4gKiBwYXJzZURpZ2l0cygnOCAoODAwKSA1NTUnKVxyXG4gKiAvLyBPdXRwdXRzICc4ODAwNTU1Jy5cclxuICogYGBgXHJcbiAqL1xuXG5leHBvcnQgZGVmYXVsdCBmdW5jdGlvbiBwYXJzZURpZ2l0cyhzdHJpbmcpIHtcbiAgdmFyIHJlc3VsdCA9ICcnOyAvLyBVc2luZyBgLnNwbGl0KCcnKWAgaGVyZSBpbnN0ZWFkIG9mIG5vcm1hbCBgZm9yIC4uLiBvZmBcbiAgLy8gYmVjYXVzZSB0aGUgaW1wb3J0aW5nIGFwcGxpY2F0aW9uIGRvZXNuJ3QgbmVjY2Vzc2FyaWx5IGluY2x1ZGUgYW4gRVM2IHBvbHlmaWxsLlxuICAvLyBUaGUgYC5zcGxpdCgnJylgIGFwcHJvYWNoIGRpc2NhcmRzIFwiZXhvdGljXCIgVVRGLTggY2hhcmFjdGVyc1xuICAvLyAodGhlIG9uZXMgY29uc2lzdGluZyBvZiBmb3VyIGJ5dGVzKSBidXQgZGlnaXRzXG4gIC8vIChpbmNsdWRpbmcgbm9uLUV1cm9wZWFuIG9uZXMpIGRvbid0IGZhbGwgaW50byB0aGF0IHJhbmdlXG4gIC8vIHNvIHN1Y2ggXCJleG90aWNcIiBjaGFyYWN0ZXJzIHdvdWxkIGJlIGRpc2NhcmRlZCBhbnl3YXkuXG5cbiAgZm9yICh2YXIgX2l0ZXJhdG9yID0gX2NyZWF0ZUZvck9mSXRlcmF0b3JIZWxwZXJMb29zZShzdHJpbmcuc3BsaXQoJycpKSwgX3N0ZXA7ICEoX3N0ZXAgPSBfaXRlcmF0b3IoKSkuZG9uZTspIHtcbiAgICB2YXIgY2hhcmFjdGVyID0gX3N0ZXAudmFsdWU7XG4gICAgdmFyIGRpZ2l0ID0gcGFyc2VEaWdpdChjaGFyYWN0ZXIpO1xuXG4gICAgaWYgKGRpZ2l0KSB7XG4gICAgICByZXN1bHQgKz0gZGlnaXQ7XG4gICAgfVxuICB9XG5cbiAgcmV0dXJuIHJlc3VsdDtcbn1cbi8vIyBzb3VyY2VNYXBwaW5nVVJMPXBhcnNlRGlnaXRzLmpzLm1hcCJdLCJuYW1lcyI6W10sImlnbm9yZUxpc3QiOlswXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/parseDigits.js\n");

/***/ }),

/***/ "(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/stripIddPrefix.js":
/*!************************************************************************************************************************!*\
  !*** ../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/stripIddPrefix.js ***!
  \************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ stripIddPrefix)\n/* harmony export */ });\n/* harmony import */ var _metadata_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../metadata.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/metadata.js\");\n/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../constants.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/constants.js\");\n\n\nvar CAPTURING_DIGIT_PATTERN = new RegExp('([' + _constants_js__WEBPACK_IMPORTED_MODULE_0__.VALID_DIGITS + '])');\nfunction stripIddPrefix(number, country, callingCode, metadata) {\n  if (!country) {\n    return;\n  } // Check if the number is IDD-prefixed.\n\n\n  var countryMetadata = new _metadata_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"](metadata);\n  countryMetadata.selectNumberingPlan(country, callingCode);\n  var IDDPrefixPattern = new RegExp(countryMetadata.IDDPrefix());\n\n  if (number.search(IDDPrefixPattern) !== 0) {\n    return;\n  } // Strip IDD prefix.\n\n\n  number = number.slice(number.match(IDDPrefixPattern)[0].length); // If there're any digits after an IDD prefix,\n  // then those digits are a country calling code.\n  // Since no country code starts with a `0`,\n  // the code below validates that the next digit (if present) is not `0`.\n\n  var matchedGroups = number.match(CAPTURING_DIGIT_PATTERN);\n\n  if (matchedGroups && matchedGroups[1] != null && matchedGroups[1].length > 0) {\n    if (matchedGroups[1] === '0') {\n      return;\n    }\n  }\n\n  return number;\n}\n//# sourceMappingURL=stripIddPrefix.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/stripIddPrefix.js\n");

/***/ }),

/***/ "(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/isPossible.js":
/*!************************************************************************************************************!*\
  !*** ../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/isPossible.js ***!
  \************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ isPossiblePhoneNumber),\n/* harmony export */   isPossibleNumber: () => (/* binding */ isPossibleNumber)\n/* harmony export */ });\n/* harmony import */ var _metadata_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./metadata.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/metadata.js\");\n/* harmony import */ var _helpers_checkNumberLength_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./helpers/checkNumberLength.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/checkNumberLength.js\");\n\n\n/**\r\n * Checks if a phone number is \"possible\" (basically just checks its length).\r\n *\r\n * isPossible(phoneNumberInstance, { ..., v2: true }, metadata)\r\n *\r\n * isPossible({ phone: '8005553535', country: 'RU' }, { ... }, metadata)\r\n * isPossible({ phone: '8005553535', country: 'RU' }, undefined, metadata)\r\n *\r\n * @param  {object|PhoneNumber} input — If `options.v2: true` flag is passed, the `input` should be a `PhoneNumber` instance. Otherwise, it should be an object of shape `{ phone: '...', country: '...' }`.\r\n * @param  {object} [options]\r\n * @param  {object} metadata\r\n * @return {string}\r\n */\n\nfunction isPossiblePhoneNumber(input, options, metadata) {\n  /* istanbul ignore if */\n  if (options === undefined) {\n    options = {};\n  }\n\n  metadata = new _metadata_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"](metadata);\n\n  if (options.v2) {\n    if (!input.countryCallingCode) {\n      throw new Error('Invalid phone number object passed');\n    }\n\n    metadata.selectNumberingPlan(input.countryCallingCode);\n  } else {\n    if (!input.phone) {\n      return false;\n    }\n\n    if (input.country) {\n      if (!metadata.hasCountry(input.country)) {\n        throw new Error(\"Unknown country: \".concat(input.country));\n      }\n\n      metadata.country(input.country);\n    } else {\n      if (!input.countryCallingCode) {\n        throw new Error('Invalid phone number object passed');\n      }\n\n      metadata.selectNumberingPlan(input.countryCallingCode);\n    }\n  } // Old metadata (< 1.0.18) had no \"possible length\" data.\n\n\n  if (metadata.possibleLengths()) {\n    return isPossibleNumber(input.phone || input.nationalNumber, metadata);\n  } else {\n    // There was a bug between `1.7.35` and `1.7.37` where \"possible_lengths\"\n    // were missing for \"non-geographical\" numbering plans.\n    // Just assume the number is possible in such cases:\n    // it's unlikely that anyone generated their custom metadata\n    // in that short period of time (one day).\n    // This code can be removed in some future major version update.\n    if (input.countryCallingCode && metadata.isNonGeographicCallingCode(input.countryCallingCode)) {\n      // \"Non-geographic entities\" did't have `possibleLengths`\n      // due to a bug in metadata generation process.\n      return true;\n    } else {\n      throw new Error('Missing \"possibleLengths\" in metadata. Perhaps the metadata has been generated before v1.0.18.');\n    }\n  }\n}\nfunction isPossibleNumber(nationalNumber, metadata) {\n  //, isInternational) {\n  switch ((0,_helpers_checkNumberLength_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(nationalNumber, metadata)) {\n    case 'IS_POSSIBLE':\n      return true;\n    // This library ignores \"local-only\" phone numbers (for simplicity).\n    // See the readme for more info on what are \"local-only\" phone numbers.\n    // case 'IS_POSSIBLE_LOCAL_ONLY':\n    // \treturn !isInternational\n\n    default:\n      return false;\n  }\n}\n//# sourceMappingURL=isPossible.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/isPossible.js\n");

/***/ }),

/***/ "(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/isPossiblePhoneNumber.js":
/*!***********************************************************************************************************************!*\
  !*** ../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/isPossiblePhoneNumber.js ***!
  \***********************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ isPossiblePhoneNumber)\n/* harmony export */ });\n/* harmony import */ var _normalizeArguments_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./normalizeArguments.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/normalizeArguments.js\");\n/* harmony import */ var _parsePhoneNumber_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./parsePhoneNumber_.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/parsePhoneNumber_.js\");\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }\n\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }\n\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\n\n\nfunction isPossiblePhoneNumber() {\n  var _normalizeArguments = (0,_normalizeArguments_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(arguments),\n      text = _normalizeArguments.text,\n      options = _normalizeArguments.options,\n      metadata = _normalizeArguments.metadata;\n\n  options = _objectSpread(_objectSpread({}, options), {}, {\n    extract: false\n  });\n  var phoneNumber = (0,_parsePhoneNumber_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(text, options, metadata);\n  return phoneNumber && phoneNumber.isPossible() || false;\n}\n//# sourceMappingURL=isPossiblePhoneNumber.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/isPossiblePhoneNumber.js\n");

/***/ }),

/***/ "(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/isValid.js":
/*!*********************************************************************************************************!*\
  !*** ../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/isValid.js ***!
  \*********************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ isValidNumber)\n/* harmony export */ });\n/* harmony import */ var _metadata_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./metadata.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/metadata.js\");\n/* harmony import */ var _helpers_matchesEntirely_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./helpers/matchesEntirely.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/matchesEntirely.js\");\n/* harmony import */ var _helpers_getNumberType_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./helpers/getNumberType.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/getNumberType.js\");\n\n\n\n/**\r\n * Checks if a given phone number is valid.\r\n *\r\n * isValid(phoneNumberInstance, { ..., v2: true }, metadata)\r\n *\r\n * isPossible({ phone: '8005553535', country: 'RU' }, { ... }, metadata)\r\n * isPossible({ phone: '8005553535', country: 'RU' }, undefined, metadata)\r\n *\r\n * If the `number` is a string, it will be parsed to an object,\r\n * but only if it contains only valid phone number characters (including punctuation).\r\n * If the `number` is an object, it is used as is.\r\n *\r\n * The optional `defaultCountry` argument is the default country.\r\n * I.e. it does not restrict to just that country,\r\n * e.g. in those cases where several countries share\r\n * the same phone numbering rules (NANPA, Britain, etc).\r\n * For example, even though the number `07624 369230`\r\n * belongs to the Isle of Man (\"IM\" country code)\r\n * calling `isValidNumber('07624369230', 'GB', metadata)`\r\n * still returns `true` because the country is not restricted to `GB`,\r\n * it's just that `GB` is the default one for the phone numbering rules.\r\n * For restricting the country see `isValidNumberForRegion()`\r\n * though restricting a country might not be a good idea.\r\n * https://github.com/googlei18n/libphonenumber/blob/master/FAQ.md#when-should-i-use-isvalidnumberforregion\r\n *\r\n * Examples:\r\n *\r\n * ```js\r\n * isValidNumber('+78005553535', metadata)\r\n * isValidNumber('8005553535', 'RU', metadata)\r\n * isValidNumber('88005553535', 'RU', metadata)\r\n * isValidNumber({ phone: '8005553535', country: 'RU' }, metadata)\r\n * ```\r\n */\n\nfunction isValidNumber(input, options, metadata) {\n  // If assigning the `{}` default value is moved to the arguments above,\n  // code coverage would decrease for some weird reason.\n  options = options || {};\n  metadata = new _metadata_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"](metadata);\n  metadata.selectNumberingPlan(input.country, input.countryCallingCode); // By default, countries only have type regexps when it's required for\n  // distinguishing different countries having the same `countryCallingCode`.\n\n  if (metadata.hasTypes()) {\n    return (0,_helpers_getNumberType_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(input, options, metadata.metadata) !== undefined;\n  } // If there are no type regexps for this country in metadata then use\n  // `nationalNumberPattern` as a \"better than nothing\" replacement.\n\n\n  var nationalNumber = options.v2 ? input.nationalNumber : input.phone;\n  return (0,_helpers_matchesEntirely_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"])(nationalNumber, metadata.nationalNumberPattern());\n}\n//# sourceMappingURL=isValid.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/isValid.js\n");

/***/ }),

/***/ "(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/isValidPhoneNumber.js":
/*!********************************************************************************************************************!*\
  !*** ../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/isValidPhoneNumber.js ***!
  \********************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ isValidPhoneNumber)\n/* harmony export */ });\n/* harmony import */ var _normalizeArguments_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./normalizeArguments.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/normalizeArguments.js\");\n/* harmony import */ var _parsePhoneNumber_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./parsePhoneNumber_.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/parsePhoneNumber_.js\");\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }\n\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }\n\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\n\n\nfunction isValidPhoneNumber() {\n  var _normalizeArguments = (0,_normalizeArguments_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(arguments),\n      text = _normalizeArguments.text,\n      options = _normalizeArguments.options,\n      metadata = _normalizeArguments.metadata;\n\n  options = _objectSpread(_objectSpread({}, options), {}, {\n    extract: false\n  });\n  var phoneNumber = (0,_parsePhoneNumber_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(text, options, metadata);\n  return phoneNumber && phoneNumber.isValid() || false;\n}\n//# sourceMappingURL=isValidPhoneNumber.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/isValidPhoneNumber.js\n");

/***/ }),

/***/ "(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/metadata.js":
/*!**********************************************************************************************************!*\
  !*** ../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/metadata.js ***!
  \**********************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ Metadata),\n/* harmony export */   getCountryCallingCode: () => (/* binding */ getCountryCallingCode),\n/* harmony export */   getExtPrefix: () => (/* binding */ getExtPrefix),\n/* harmony export */   isSupportedCountry: () => (/* binding */ isSupportedCountry),\n/* harmony export */   validateMetadata: () => (/* binding */ validateMetadata)\n/* harmony export */ });\n/* harmony import */ var _tools_semver_compare_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./tools/semver-compare.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/tools/semver-compare.js\");\n/* harmony import */ var _helpers_isObject_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./helpers/isObject.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/isObject.js\");\nfunction _typeof(obj) { \"@babel/helpers - typeof\"; return _typeof = \"function\" == typeof Symbol && \"symbol\" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && \"function\" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }, _typeof(obj); }\n\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, \"prototype\", { writable: false }); return Constructor; }\n\n\n // Added \"possibleLengths\" and renamed\n// \"country_phone_code_to_countries\" to \"country_calling_codes\".\n\nvar V2 = '1.0.18'; // Added \"idd_prefix\" and \"default_idd_prefix\".\n\nvar V3 = '1.2.0'; // Moved `001` country code to \"nonGeographic\" section of metadata.\n\nvar V4 = '1.7.35';\nvar DEFAULT_EXT_PREFIX = ' ext. ';\nvar CALLING_CODE_REG_EXP = /^\\d+$/;\n/**\r\n * See: https://gitlab.com/catamphetamine/libphonenumber-js/blob/master/METADATA.md\r\n */\n\nvar Metadata = /*#__PURE__*/function () {\n  function Metadata(metadata) {\n    _classCallCheck(this, Metadata);\n\n    validateMetadata(metadata);\n    this.metadata = metadata;\n    setVersion.call(this, metadata);\n  }\n\n  _createClass(Metadata, [{\n    key: \"getCountries\",\n    value: function getCountries() {\n      return Object.keys(this.metadata.countries).filter(function (_) {\n        return _ !== '001';\n      });\n    }\n  }, {\n    key: \"getCountryMetadata\",\n    value: function getCountryMetadata(countryCode) {\n      return this.metadata.countries[countryCode];\n    }\n  }, {\n    key: \"nonGeographic\",\n    value: function nonGeographic() {\n      if (this.v1 || this.v2 || this.v3) return; // `nonGeographical` was a typo.\n      // It's present in metadata generated from `1.7.35` to `1.7.37`.\n      // The test case could be found by searching for \"nonGeographical\".\n\n      return this.metadata.nonGeographic || this.metadata.nonGeographical;\n    }\n  }, {\n    key: \"hasCountry\",\n    value: function hasCountry(country) {\n      return this.getCountryMetadata(country) !== undefined;\n    }\n  }, {\n    key: \"hasCallingCode\",\n    value: function hasCallingCode(callingCode) {\n      if (this.getCountryCodesForCallingCode(callingCode)) {\n        return true;\n      }\n\n      if (this.nonGeographic()) {\n        if (this.nonGeographic()[callingCode]) {\n          return true;\n        }\n      } else {\n        // A hacky workaround for old custom metadata (generated before V4).\n        var countryCodes = this.countryCallingCodes()[callingCode];\n\n        if (countryCodes && countryCodes.length === 1 && countryCodes[0] === '001') {\n          return true;\n        }\n      }\n    }\n  }, {\n    key: \"isNonGeographicCallingCode\",\n    value: function isNonGeographicCallingCode(callingCode) {\n      if (this.nonGeographic()) {\n        return this.nonGeographic()[callingCode] ? true : false;\n      } else {\n        return this.getCountryCodesForCallingCode(callingCode) ? false : true;\n      }\n    } // Deprecated.\n\n  }, {\n    key: \"country\",\n    value: function country(countryCode) {\n      return this.selectNumberingPlan(countryCode);\n    }\n  }, {\n    key: \"selectNumberingPlan\",\n    value: function selectNumberingPlan(countryCode, callingCode) {\n      // Supports just passing `callingCode` as the first argument.\n      if (countryCode && CALLING_CODE_REG_EXP.test(countryCode)) {\n        callingCode = countryCode;\n        countryCode = null;\n      }\n\n      if (countryCode && countryCode !== '001') {\n        if (!this.hasCountry(countryCode)) {\n          throw new Error(\"Unknown country: \".concat(countryCode));\n        }\n\n        this.numberingPlan = new NumberingPlan(this.getCountryMetadata(countryCode), this);\n      } else if (callingCode) {\n        if (!this.hasCallingCode(callingCode)) {\n          throw new Error(\"Unknown calling code: \".concat(callingCode));\n        }\n\n        this.numberingPlan = new NumberingPlan(this.getNumberingPlanMetadata(callingCode), this);\n      } else {\n        this.numberingPlan = undefined;\n      }\n\n      return this;\n    }\n  }, {\n    key: \"getCountryCodesForCallingCode\",\n    value: function getCountryCodesForCallingCode(callingCode) {\n      var countryCodes = this.countryCallingCodes()[callingCode];\n\n      if (countryCodes) {\n        // Metadata before V4 included \"non-geographic entity\" calling codes\n        // inside `country_calling_codes` (for example, `\"881\":[\"001\"]`).\n        // Now the semantics of `country_calling_codes` has changed:\n        // it's specifically for \"countries\" now.\n        // Older versions of custom metadata will simply skip parsing\n        // \"non-geographic entity\" phone numbers with new versions\n        // of this library: it's not considered a bug,\n        // because such numbers are extremely rare,\n        // and developers extremely rarely use custom metadata.\n        if (countryCodes.length === 1 && countryCodes[0].length === 3) {\n          return;\n        }\n\n        return countryCodes;\n      }\n    }\n  }, {\n    key: \"getCountryCodeForCallingCode\",\n    value: function getCountryCodeForCallingCode(callingCode) {\n      var countryCodes = this.getCountryCodesForCallingCode(callingCode);\n\n      if (countryCodes) {\n        return countryCodes[0];\n      }\n    }\n  }, {\n    key: \"getNumberingPlanMetadata\",\n    value: function getNumberingPlanMetadata(callingCode) {\n      var countryCode = this.getCountryCodeForCallingCode(callingCode);\n\n      if (countryCode) {\n        return this.getCountryMetadata(countryCode);\n      }\n\n      if (this.nonGeographic()) {\n        var metadata = this.nonGeographic()[callingCode];\n\n        if (metadata) {\n          return metadata;\n        }\n      } else {\n        // A hacky workaround for old custom metadata (generated before V4).\n        // In that metadata, there was no concept of \"non-geographic\" metadata\n        // so metadata for `001` country code was stored along with other countries.\n        // The test case can be found by searching for:\n        // \"should work around `nonGeographic` metadata not existing\".\n        var countryCodes = this.countryCallingCodes()[callingCode];\n\n        if (countryCodes && countryCodes.length === 1 && countryCodes[0] === '001') {\n          return this.metadata.countries['001'];\n        }\n      }\n    } // Deprecated.\n\n  }, {\n    key: \"countryCallingCode\",\n    value: function countryCallingCode() {\n      return this.numberingPlan.callingCode();\n    } // Deprecated.\n\n  }, {\n    key: \"IDDPrefix\",\n    value: function IDDPrefix() {\n      return this.numberingPlan.IDDPrefix();\n    } // Deprecated.\n\n  }, {\n    key: \"defaultIDDPrefix\",\n    value: function defaultIDDPrefix() {\n      return this.numberingPlan.defaultIDDPrefix();\n    } // Deprecated.\n\n  }, {\n    key: \"nationalNumberPattern\",\n    value: function nationalNumberPattern() {\n      return this.numberingPlan.nationalNumberPattern();\n    } // Deprecated.\n\n  }, {\n    key: \"possibleLengths\",\n    value: function possibleLengths() {\n      return this.numberingPlan.possibleLengths();\n    } // Deprecated.\n\n  }, {\n    key: \"formats\",\n    value: function formats() {\n      return this.numberingPlan.formats();\n    } // Deprecated.\n\n  }, {\n    key: \"nationalPrefixForParsing\",\n    value: function nationalPrefixForParsing() {\n      return this.numberingPlan.nationalPrefixForParsing();\n    } // Deprecated.\n\n  }, {\n    key: \"nationalPrefixTransformRule\",\n    value: function nationalPrefixTransformRule() {\n      return this.numberingPlan.nationalPrefixTransformRule();\n    } // Deprecated.\n\n  }, {\n    key: \"leadingDigits\",\n    value: function leadingDigits() {\n      return this.numberingPlan.leadingDigits();\n    } // Deprecated.\n\n  }, {\n    key: \"hasTypes\",\n    value: function hasTypes() {\n      return this.numberingPlan.hasTypes();\n    } // Deprecated.\n\n  }, {\n    key: \"type\",\n    value: function type(_type) {\n      return this.numberingPlan.type(_type);\n    } // Deprecated.\n\n  }, {\n    key: \"ext\",\n    value: function ext() {\n      return this.numberingPlan.ext();\n    }\n  }, {\n    key: \"countryCallingCodes\",\n    value: function countryCallingCodes() {\n      if (this.v1) return this.metadata.country_phone_code_to_countries;\n      return this.metadata.country_calling_codes;\n    } // Deprecated.\n\n  }, {\n    key: \"chooseCountryByCountryCallingCode\",\n    value: function chooseCountryByCountryCallingCode(callingCode) {\n      return this.selectNumberingPlan(callingCode);\n    }\n  }, {\n    key: \"hasSelectedNumberingPlan\",\n    value: function hasSelectedNumberingPlan() {\n      return this.numberingPlan !== undefined;\n    }\n  }]);\n\n  return Metadata;\n}();\n\n\n\nvar NumberingPlan = /*#__PURE__*/function () {\n  function NumberingPlan(metadata, globalMetadataObject) {\n    _classCallCheck(this, NumberingPlan);\n\n    this.globalMetadataObject = globalMetadataObject;\n    this.metadata = metadata;\n    setVersion.call(this, globalMetadataObject.metadata);\n  }\n\n  _createClass(NumberingPlan, [{\n    key: \"callingCode\",\n    value: function callingCode() {\n      return this.metadata[0];\n    } // Formatting information for regions which share\n    // a country calling code is contained by only one region\n    // for performance reasons. For example, for NANPA region\n    // (\"North American Numbering Plan Administration\",\n    //  which includes USA, Canada, Cayman Islands, Bahamas, etc)\n    // it will be contained in the metadata for `US`.\n\n  }, {\n    key: \"getDefaultCountryMetadataForRegion\",\n    value: function getDefaultCountryMetadataForRegion() {\n      return this.globalMetadataObject.getNumberingPlanMetadata(this.callingCode());\n    } // Is always present.\n\n  }, {\n    key: \"IDDPrefix\",\n    value: function IDDPrefix() {\n      if (this.v1 || this.v2) return;\n      return this.metadata[1];\n    } // Is only present when a country supports multiple IDD prefixes.\n\n  }, {\n    key: \"defaultIDDPrefix\",\n    value: function defaultIDDPrefix() {\n      if (this.v1 || this.v2) return;\n      return this.metadata[12];\n    }\n  }, {\n    key: \"nationalNumberPattern\",\n    value: function nationalNumberPattern() {\n      if (this.v1 || this.v2) return this.metadata[1];\n      return this.metadata[2];\n    } // \"possible length\" data is always present in Google's metadata.\n\n  }, {\n    key: \"possibleLengths\",\n    value: function possibleLengths() {\n      if (this.v1) return;\n      return this.metadata[this.v2 ? 2 : 3];\n    }\n  }, {\n    key: \"_getFormats\",\n    value: function _getFormats(metadata) {\n      return metadata[this.v1 ? 2 : this.v2 ? 3 : 4];\n    } // For countries of the same region (e.g. NANPA)\n    // formats are all stored in the \"main\" country for that region.\n    // E.g. \"RU\" and \"KZ\", \"US\" and \"CA\".\n\n  }, {\n    key: \"formats\",\n    value: function formats() {\n      var _this = this;\n\n      var formats = this._getFormats(this.metadata) || this._getFormats(this.getDefaultCountryMetadataForRegion()) || [];\n      return formats.map(function (_) {\n        return new Format(_, _this);\n      });\n    }\n  }, {\n    key: \"nationalPrefix\",\n    value: function nationalPrefix() {\n      return this.metadata[this.v1 ? 3 : this.v2 ? 4 : 5];\n    }\n  }, {\n    key: \"_getNationalPrefixFormattingRule\",\n    value: function _getNationalPrefixFormattingRule(metadata) {\n      return metadata[this.v1 ? 4 : this.v2 ? 5 : 6];\n    } // For countries of the same region (e.g. NANPA)\n    // national prefix formatting rule is stored in the \"main\" country for that region.\n    // E.g. \"RU\" and \"KZ\", \"US\" and \"CA\".\n\n  }, {\n    key: \"nationalPrefixFormattingRule\",\n    value: function nationalPrefixFormattingRule() {\n      return this._getNationalPrefixFormattingRule(this.metadata) || this._getNationalPrefixFormattingRule(this.getDefaultCountryMetadataForRegion());\n    }\n  }, {\n    key: \"_nationalPrefixForParsing\",\n    value: function _nationalPrefixForParsing() {\n      return this.metadata[this.v1 ? 5 : this.v2 ? 6 : 7];\n    }\n  }, {\n    key: \"nationalPrefixForParsing\",\n    value: function nationalPrefixForParsing() {\n      // If `national_prefix_for_parsing` is not set explicitly,\n      // then infer it from `national_prefix` (if any)\n      return this._nationalPrefixForParsing() || this.nationalPrefix();\n    }\n  }, {\n    key: \"nationalPrefixTransformRule\",\n    value: function nationalPrefixTransformRule() {\n      return this.metadata[this.v1 ? 6 : this.v2 ? 7 : 8];\n    }\n  }, {\n    key: \"_getNationalPrefixIsOptionalWhenFormatting\",\n    value: function _getNationalPrefixIsOptionalWhenFormatting() {\n      return !!this.metadata[this.v1 ? 7 : this.v2 ? 8 : 9];\n    } // For countries of the same region (e.g. NANPA)\n    // \"national prefix is optional when formatting\" flag is\n    // stored in the \"main\" country for that region.\n    // E.g. \"RU\" and \"KZ\", \"US\" and \"CA\".\n\n  }, {\n    key: \"nationalPrefixIsOptionalWhenFormattingInNationalFormat\",\n    value: function nationalPrefixIsOptionalWhenFormattingInNationalFormat() {\n      return this._getNationalPrefixIsOptionalWhenFormatting(this.metadata) || this._getNationalPrefixIsOptionalWhenFormatting(this.getDefaultCountryMetadataForRegion());\n    }\n  }, {\n    key: \"leadingDigits\",\n    value: function leadingDigits() {\n      return this.metadata[this.v1 ? 8 : this.v2 ? 9 : 10];\n    }\n  }, {\n    key: \"types\",\n    value: function types() {\n      return this.metadata[this.v1 ? 9 : this.v2 ? 10 : 11];\n    }\n  }, {\n    key: \"hasTypes\",\n    value: function hasTypes() {\n      // Versions 1.2.0 - 1.2.4: can be `[]`.\n\n      /* istanbul ignore next */\n      if (this.types() && this.types().length === 0) {\n        return false;\n      } // Versions <= 1.2.4: can be `undefined`.\n      // Version >= 1.2.5: can be `0`.\n\n\n      return !!this.types();\n    }\n  }, {\n    key: \"type\",\n    value: function type(_type2) {\n      if (this.hasTypes() && getType(this.types(), _type2)) {\n        return new Type(getType(this.types(), _type2), this);\n      }\n    }\n  }, {\n    key: \"ext\",\n    value: function ext() {\n      if (this.v1 || this.v2) return DEFAULT_EXT_PREFIX;\n      return this.metadata[13] || DEFAULT_EXT_PREFIX;\n    }\n  }]);\n\n  return NumberingPlan;\n}();\n\nvar Format = /*#__PURE__*/function () {\n  function Format(format, metadata) {\n    _classCallCheck(this, Format);\n\n    this._format = format;\n    this.metadata = metadata;\n  }\n\n  _createClass(Format, [{\n    key: \"pattern\",\n    value: function pattern() {\n      return this._format[0];\n    }\n  }, {\n    key: \"format\",\n    value: function format() {\n      return this._format[1];\n    }\n  }, {\n    key: \"leadingDigitsPatterns\",\n    value: function leadingDigitsPatterns() {\n      return this._format[2] || [];\n    }\n  }, {\n    key: \"nationalPrefixFormattingRule\",\n    value: function nationalPrefixFormattingRule() {\n      return this._format[3] || this.metadata.nationalPrefixFormattingRule();\n    }\n  }, {\n    key: \"nationalPrefixIsOptionalWhenFormattingInNationalFormat\",\n    value: function nationalPrefixIsOptionalWhenFormattingInNationalFormat() {\n      return !!this._format[4] || this.metadata.nationalPrefixIsOptionalWhenFormattingInNationalFormat();\n    }\n  }, {\n    key: \"nationalPrefixIsMandatoryWhenFormattingInNationalFormat\",\n    value: function nationalPrefixIsMandatoryWhenFormattingInNationalFormat() {\n      // National prefix is omitted if there's no national prefix formatting rule\n      // set for this country, or when the national prefix formatting rule\n      // contains no national prefix itself, or when this rule is set but\n      // national prefix is optional for this phone number format\n      // (and it is not enforced explicitly)\n      return this.usesNationalPrefix() && !this.nationalPrefixIsOptionalWhenFormattingInNationalFormat();\n    } // Checks whether national prefix formatting rule contains national prefix.\n\n  }, {\n    key: \"usesNationalPrefix\",\n    value: function usesNationalPrefix() {\n      return this.nationalPrefixFormattingRule() && // Check that national prefix formatting rule is not a \"dummy\" one.\n      !FIRST_GROUP_ONLY_PREFIX_PATTERN.test(this.nationalPrefixFormattingRule()) // In compressed metadata, `this.nationalPrefixFormattingRule()` is `0`\n      // when `national_prefix_formatting_rule` is not present.\n      // So, `true` or `false` are returned explicitly here, so that\n      // `0` number isn't returned.\n      ? true : false;\n    }\n  }, {\n    key: \"internationalFormat\",\n    value: function internationalFormat() {\n      return this._format[5] || this.format();\n    }\n  }]);\n\n  return Format;\n}();\n/**\r\n * A pattern that is used to determine if the national prefix formatting rule\r\n * has the first group only, i.e., does not start with the national prefix.\r\n * Note that the pattern explicitly allows for unbalanced parentheses.\r\n */\n\n\nvar FIRST_GROUP_ONLY_PREFIX_PATTERN = /^\\(?\\$1\\)?$/;\n\nvar Type = /*#__PURE__*/function () {\n  function Type(type, metadata) {\n    _classCallCheck(this, Type);\n\n    this.type = type;\n    this.metadata = metadata;\n  }\n\n  _createClass(Type, [{\n    key: \"pattern\",\n    value: function pattern() {\n      if (this.metadata.v1) return this.type;\n      return this.type[0];\n    }\n  }, {\n    key: \"possibleLengths\",\n    value: function possibleLengths() {\n      if (this.metadata.v1) return;\n      return this.type[1] || this.metadata.possibleLengths();\n    }\n  }]);\n\n  return Type;\n}();\n\nfunction getType(types, type) {\n  switch (type) {\n    case 'FIXED_LINE':\n      return types[0];\n\n    case 'MOBILE':\n      return types[1];\n\n    case 'TOLL_FREE':\n      return types[2];\n\n    case 'PREMIUM_RATE':\n      return types[3];\n\n    case 'PERSONAL_NUMBER':\n      return types[4];\n\n    case 'VOICEMAIL':\n      return types[5];\n\n    case 'UAN':\n      return types[6];\n\n    case 'PAGER':\n      return types[7];\n\n    case 'VOIP':\n      return types[8];\n\n    case 'SHARED_COST':\n      return types[9];\n  }\n}\n\nfunction validateMetadata(metadata) {\n  if (!metadata) {\n    throw new Error('[libphonenumber-js] `metadata` argument not passed. Check your arguments.');\n  } // `country_phone_code_to_countries` was renamed to `country_calling_codes` in `1.0.18`.\n  // For that reason, it's not used in this detection algorithm.\n  // Instead, it detects by `countries: {}` property existence.\n\n\n  if (!(0,_helpers_isObject_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(metadata) || !(0,_helpers_isObject_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(metadata.countries)) {\n    throw new Error(\"[libphonenumber-js] `metadata` argument was passed but it's not a valid metadata. Must be an object having `.countries` child object property. Got \".concat((0,_helpers_isObject_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(metadata) ? 'an object of shape: { ' + Object.keys(metadata).join(', ') + ' }' : 'a ' + typeOf(metadata) + ': ' + metadata, \".\"));\n  }\n} // Babel transforms `typeof` into some \"branches\"\n// so istanbul will show this as \"branch not covered\".\n\n/* istanbul ignore next */\n\nvar typeOf = function typeOf(_) {\n  return _typeof(_);\n};\n/**\r\n * Returns extension prefix for a country.\r\n * @param  {string} country\r\n * @param  {object} metadata\r\n * @return {string?}\r\n * @example\r\n * // Returns \" ext. \"\r\n * getExtPrefix(\"US\")\r\n */\n\n\nfunction getExtPrefix(country, metadata) {\n  metadata = new Metadata(metadata);\n\n  if (metadata.hasCountry(country)) {\n    return metadata.country(country).ext();\n  }\n\n  return DEFAULT_EXT_PREFIX;\n}\n/**\r\n * Returns \"country calling code\" for a country.\r\n * Throws an error if the country doesn't exist or isn't supported by this library.\r\n * @param  {string} country\r\n * @param  {object} metadata\r\n * @return {string}\r\n * @example\r\n * // Returns \"44\"\r\n * getCountryCallingCode(\"GB\")\r\n */\n\nfunction getCountryCallingCode(country, metadata) {\n  metadata = new Metadata(metadata);\n\n  if (metadata.hasCountry(country)) {\n    return metadata.country(country).countryCallingCode();\n  }\n\n  throw new Error(\"Unknown country: \".concat(country));\n}\nfunction isSupportedCountry(country, metadata) {\n  // metadata = new Metadata(metadata)\n  // return metadata.hasCountry(country)\n  return metadata.countries.hasOwnProperty(country);\n}\n\nfunction setVersion(metadata) {\n  var version = metadata.version;\n\n  if (typeof version === 'number') {\n    this.v1 = version === 1;\n    this.v2 = version === 2;\n    this.v3 = version === 3;\n    this.v4 = version === 4;\n  } else {\n    if (!version) {\n      this.v1 = true;\n    } else if ((0,_tools_semver_compare_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(version, V3) === -1) {\n      this.v2 = true;\n    } else if ((0,_tools_semver_compare_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(version, V4) === -1) {\n      this.v3 = true;\n    } else {\n      this.v4 = true;\n    }\n  }\n} // const ISO_COUNTRY_CODE = /^[A-Z]{2}$/\n// function isCountryCode(countryCode) {\n// \treturn ISO_COUNTRY_CODE.test(countryCodeOrCountryCallingCode)\n// }\n//# sourceMappingURL=metadata.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/metadata.js\n");

/***/ }),

/***/ "(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/normalizeArguments.js":
/*!********************************************************************************************************************!*\
  !*** ../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/normalizeArguments.js ***!
  \********************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ normalizeArguments)\n/* harmony export */ });\n/* harmony import */ var _helpers_isObject_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./helpers/isObject.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/isObject.js\");\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }\n\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }\n\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\n\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\n\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }\n\nfunction _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== \"undefined\" && arr[Symbol.iterator] || arr[\"@@iterator\"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\n // Extracts the following properties from function arguments:\n// * input `text`\n// * `options` object\n// * `metadata` JSON\n\nfunction normalizeArguments(args) {\n  var _Array$prototype$slic = Array.prototype.slice.call(args),\n      _Array$prototype$slic2 = _slicedToArray(_Array$prototype$slic, 4),\n      arg_1 = _Array$prototype$slic2[0],\n      arg_2 = _Array$prototype$slic2[1],\n      arg_3 = _Array$prototype$slic2[2],\n      arg_4 = _Array$prototype$slic2[3];\n\n  var text;\n  var options;\n  var metadata; // If the phone number is passed as a string.\n  // `parsePhoneNumber('88005553535', ...)`.\n\n  if (typeof arg_1 === 'string') {\n    text = arg_1;\n  } else throw new TypeError('A text for parsing must be a string.'); // If \"default country\" argument is being passed then move it to `options`.\n  // `parsePhoneNumber('88005553535', 'RU', [options], metadata)`.\n\n\n  if (!arg_2 || typeof arg_2 === 'string') {\n    if (arg_4) {\n      options = arg_3;\n      metadata = arg_4;\n    } else {\n      options = undefined;\n      metadata = arg_3;\n    }\n\n    if (arg_2) {\n      options = _objectSpread({\n        defaultCountry: arg_2\n      }, options);\n    }\n  } // `defaultCountry` is not passed.\n  // Example: `parsePhoneNumber('+78005553535', [options], metadata)`.\n  else if ((0,_helpers_isObject_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(arg_2)) {\n    if (arg_3) {\n      options = arg_2;\n      metadata = arg_3;\n    } else {\n      metadata = arg_2;\n    }\n  } else throw new Error(\"Invalid second argument: \".concat(arg_2));\n\n  return {\n    text: text,\n    options: options,\n    metadata: metadata\n  };\n}\n//# sourceMappingURL=normalizeArguments.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/normalizeArguments.js\n");

/***/ }),

/***/ "(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/parse.js":
/*!*******************************************************************************************************!*\
  !*** ../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/parse.js ***!
  \*******************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ parse)\n/* harmony export */ });\n/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./constants.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/constants.js\");\n/* harmony import */ var _ParseError_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ParseError.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/ParseError.js\");\n/* harmony import */ var _metadata_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./getCountryCallingCode.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/metadata.js\");\n/* harmony import */ var _helpers_isViablePhoneNumber_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./helpers/isViablePhoneNumber.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/isViablePhoneNumber.js\");\n/* harmony import */ var _helpers_extension_extractExtension_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./helpers/extension/extractExtension.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/extension/extractExtension.js\");\n/* harmony import */ var _parseIncompletePhoneNumber_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./parseIncompletePhoneNumber.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/parseIncompletePhoneNumber.js\");\n/* harmony import */ var _isPossible_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./isPossible.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/isPossible.js\");\n/* harmony import */ var _PhoneNumber_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./PhoneNumber.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/PhoneNumber.js\");\n/* harmony import */ var _helpers_matchesEntirely_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./helpers/matchesEntirely.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/matchesEntirely.js\");\n/* harmony import */ var _helpers_extractCountryCallingCode_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./helpers/extractCountryCallingCode.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/extractCountryCallingCode.js\");\n/* harmony import */ var _helpers_extractNationalNumber_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./helpers/extractNationalNumber.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/extractNationalNumber.js\");\n/* harmony import */ var _helpers_getCountryByCallingCode_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./helpers/getCountryByCallingCode.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/getCountryByCallingCode.js\");\n/* harmony import */ var _helpers_extractFormattedPhoneNumberFromPossibleRfc3966NumberUri_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./helpers/extractFormattedPhoneNumberFromPossibleRfc3966NumberUri.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/extractFormattedPhoneNumberFromPossibleRfc3966NumberUri.js\");\n// This is a port of Google Android `libphonenumber`'s\n// `phonenumberutil.js` of December 31th, 2018.\n//\n// https://github.com/googlei18n/libphonenumber/commits/master/javascript/i18n/phonenumbers/phonenumberutil.js\n\n\n\n\n\n\n\n // import { parseRFC3966 } from './helpers/RFC3966.js'\n\n\n\n\n\n\n\n // We don't allow input strings for parsing to be longer than 250 chars.\n// This prevents malicious input from consuming CPU.\n\nvar MAX_INPUT_STRING_LENGTH = 250; // This consists of the plus symbol, digits, and arabic-indic digits.\n\nvar PHONE_NUMBER_START_PATTERN = new RegExp('[' + _constants_js__WEBPACK_IMPORTED_MODULE_0__.PLUS_CHARS + _constants_js__WEBPACK_IMPORTED_MODULE_0__.VALID_DIGITS + ']'); // Regular expression of trailing characters that we want to remove.\n// A trailing `#` is sometimes used when writing phone numbers with extensions in US.\n// Example: \"+1 (645) 123 1234-910#\" number has extension \"910\".\n\nvar AFTER_PHONE_NUMBER_END_PATTERN = new RegExp('[^' + _constants_js__WEBPACK_IMPORTED_MODULE_0__.VALID_DIGITS + '#' + ']+$');\nvar USE_NON_GEOGRAPHIC_COUNTRY_CODE = false; // Examples:\n//\n// ```js\n// parse('8 (800) 555-35-35', 'RU')\n// parse('8 (800) 555-35-35', 'RU', metadata)\n// parse('8 (800) 555-35-35', { country: { default: 'RU' } })\n// parse('8 (800) 555-35-35', { country: { default: 'RU' } }, metadata)\n// parse('+7 800 555 35 35')\n// parse('+7 800 555 35 35', metadata)\n// ```\n//\n\n/**\r\n * Parses a phone number.\r\n *\r\n * parse('123456789', { defaultCountry: 'RU', v2: true }, metadata)\r\n * parse('123456789', { defaultCountry: 'RU' }, metadata)\r\n * parse('123456789', undefined, metadata)\r\n *\r\n * @param  {string} input\r\n * @param  {object} [options]\r\n * @param  {object} metadata\r\n * @return {object|PhoneNumber?} If `options.v2: true` flag is passed, it returns a `PhoneNumber?` instance. Otherwise, returns an object of shape `{ phone: '...', country: '...' }` (or just `{}` if no phone number was parsed).\r\n */\n\nfunction parse(text, options, metadata) {\n  // If assigning the `{}` default value is moved to the arguments above,\n  // code coverage would decrease for some weird reason.\n  options = options || {};\n  metadata = new _metadata_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"](metadata); // Validate `defaultCountry`.\n\n  if (options.defaultCountry && !metadata.hasCountry(options.defaultCountry)) {\n    if (options.v2) {\n      throw new _ParseError_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"]('INVALID_COUNTRY');\n    }\n\n    throw new Error(\"Unknown country: \".concat(options.defaultCountry));\n  } // Parse the phone number.\n\n\n  var _parseInput = parseInput(text, options.v2, options.extract),\n      formattedPhoneNumber = _parseInput.number,\n      ext = _parseInput.ext,\n      error = _parseInput.error; // If the phone number is not viable then return nothing.\n\n\n  if (!formattedPhoneNumber) {\n    if (options.v2) {\n      if (error === 'TOO_SHORT') {\n        throw new _ParseError_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"]('TOO_SHORT');\n      }\n\n      throw new _ParseError_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"]('NOT_A_NUMBER');\n    }\n\n    return {};\n  }\n\n  var _parsePhoneNumber = parsePhoneNumber(formattedPhoneNumber, options.defaultCountry, options.defaultCallingCode, metadata),\n      country = _parsePhoneNumber.country,\n      nationalNumber = _parsePhoneNumber.nationalNumber,\n      countryCallingCode = _parsePhoneNumber.countryCallingCode,\n      countryCallingCodeSource = _parsePhoneNumber.countryCallingCodeSource,\n      carrierCode = _parsePhoneNumber.carrierCode;\n\n  if (!metadata.hasSelectedNumberingPlan()) {\n    if (options.v2) {\n      throw new _ParseError_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"]('INVALID_COUNTRY');\n    }\n\n    return {};\n  } // Validate national (significant) number length.\n\n\n  if (!nationalNumber || nationalNumber.length < _constants_js__WEBPACK_IMPORTED_MODULE_0__.MIN_LENGTH_FOR_NSN) {\n    // Won't throw here because the regexp already demands length > 1.\n\n    /* istanbul ignore if */\n    if (options.v2) {\n      throw new _ParseError_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"]('TOO_SHORT');\n    } // Google's demo just throws an error in this case.\n\n\n    return {};\n  } // Validate national (significant) number length.\n  //\n  // A sidenote:\n  //\n  // They say that sometimes national (significant) numbers\n  // can be longer than `MAX_LENGTH_FOR_NSN` (e.g. in Germany).\n  // https://github.com/googlei18n/libphonenumber/blob/7e1748645552da39c4e1ba731e47969d97bdb539/resources/phonenumber.proto#L36\n  // Such numbers will just be discarded.\n  //\n\n\n  if (nationalNumber.length > _constants_js__WEBPACK_IMPORTED_MODULE_0__.MAX_LENGTH_FOR_NSN) {\n    if (options.v2) {\n      throw new _ParseError_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"]('TOO_LONG');\n    } // Google's demo just throws an error in this case.\n\n\n    return {};\n  }\n\n  if (options.v2) {\n    var phoneNumber = new _PhoneNumber_js__WEBPACK_IMPORTED_MODULE_3__[\"default\"](countryCallingCode, nationalNumber, metadata.metadata);\n\n    if (country) {\n      phoneNumber.country = country;\n    }\n\n    if (carrierCode) {\n      phoneNumber.carrierCode = carrierCode;\n    }\n\n    if (ext) {\n      phoneNumber.ext = ext;\n    }\n\n    phoneNumber.__countryCallingCodeSource = countryCallingCodeSource;\n    return phoneNumber;\n  } // Check if national phone number pattern matches the number.\n  // National number pattern is different for each country,\n  // even for those ones which are part of the \"NANPA\" group.\n\n\n  var valid = (options.extended ? metadata.hasSelectedNumberingPlan() : country) ? (0,_helpers_matchesEntirely_js__WEBPACK_IMPORTED_MODULE_4__[\"default\"])(nationalNumber, metadata.nationalNumberPattern()) : false;\n\n  if (!options.extended) {\n    return valid ? result(country, nationalNumber, ext) : {};\n  } // isInternational: countryCallingCode !== undefined\n\n\n  return {\n    country: country,\n    countryCallingCode: countryCallingCode,\n    carrierCode: carrierCode,\n    valid: valid,\n    possible: valid ? true : options.extended === true && metadata.possibleLengths() && (0,_isPossible_js__WEBPACK_IMPORTED_MODULE_5__.isPossibleNumber)(nationalNumber, metadata) ? true : false,\n    phone: nationalNumber,\n    ext: ext\n  };\n}\n/**\r\n * Extracts a formatted phone number from text.\r\n * Doesn't guarantee that the extracted phone number\r\n * is a valid phone number (for example, doesn't validate its length).\r\n * @param  {string} text\r\n * @param  {boolean} [extract] — If `false`, then will parse the entire `text` as a phone number.\r\n * @param  {boolean} [throwOnError] — By default, it won't throw if the text is too long.\r\n * @return {string}\r\n * @example\r\n * // Returns \"(213) 373-4253\".\r\n * extractFormattedPhoneNumber(\"Call (213) 373-4253 for assistance.\")\r\n */\n\nfunction _extractFormattedPhoneNumber(text, extract, throwOnError) {\n  if (!text) {\n    return;\n  }\n\n  if (text.length > MAX_INPUT_STRING_LENGTH) {\n    if (throwOnError) {\n      throw new _ParseError_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"]('TOO_LONG');\n    }\n\n    return;\n  }\n\n  if (extract === false) {\n    return text;\n  } // Attempt to extract a possible number from the string passed in\n\n\n  var startsAt = text.search(PHONE_NUMBER_START_PATTERN);\n\n  if (startsAt < 0) {\n    return;\n  }\n\n  return text // Trim everything to the left of the phone number\n  .slice(startsAt) // Remove trailing non-numerical characters\n  .replace(AFTER_PHONE_NUMBER_END_PATTERN, '');\n}\n/**\r\n * @param  {string} text - Input.\r\n * @param  {boolean} v2 - Legacy API functions don't pass `v2: true` flag.\r\n * @param  {boolean} [extract] - Whether to extract a phone number from `text`, or attempt to parse the entire text as a phone number.\r\n * @return {object} `{ ?number, ?ext }`.\r\n */\n\n\nfunction parseInput(text, v2, extract) {\n  // // Parse RFC 3966 phone number URI.\n  // if (text && text.indexOf('tel:') === 0) {\n  // \treturn parseRFC3966(text)\n  // }\n  // let number = extractFormattedPhoneNumber(text, extract, v2)\n  var number = (0,_helpers_extractFormattedPhoneNumberFromPossibleRfc3966NumberUri_js__WEBPACK_IMPORTED_MODULE_6__[\"default\"])(text, {\n    extractFormattedPhoneNumber: function extractFormattedPhoneNumber(text) {\n      return _extractFormattedPhoneNumber(text, extract, v2);\n    }\n  }); // If the phone number is not viable, then abort.\n\n  if (!number) {\n    return {};\n  }\n\n  if (!(0,_helpers_isViablePhoneNumber_js__WEBPACK_IMPORTED_MODULE_7__[\"default\"])(number)) {\n    if ((0,_helpers_isViablePhoneNumber_js__WEBPACK_IMPORTED_MODULE_7__.isViablePhoneNumberStart)(number)) {\n      return {\n        error: 'TOO_SHORT'\n      };\n    }\n\n    return {};\n  } // Attempt to parse extension first, since it doesn't require region-specific\n  // data and we want to have the non-normalised number here.\n\n\n  var withExtensionStripped = (0,_helpers_extension_extractExtension_js__WEBPACK_IMPORTED_MODULE_8__[\"default\"])(number);\n\n  if (withExtensionStripped.ext) {\n    return withExtensionStripped;\n  }\n\n  return {\n    number: number\n  };\n}\n/**\r\n * Creates `parse()` result object.\r\n */\n\n\nfunction result(country, nationalNumber, ext) {\n  var result = {\n    country: country,\n    phone: nationalNumber\n  };\n\n  if (ext) {\n    result.ext = ext;\n  }\n\n  return result;\n}\n/**\r\n * Parses a viable phone number.\r\n * @param {string} formattedPhoneNumber — Example: \"(213) 373-4253\".\r\n * @param {string} [defaultCountry]\r\n * @param {string} [defaultCallingCode]\r\n * @param {Metadata} metadata\r\n * @return {object} Returns `{ country: string?, countryCallingCode: string?, nationalNumber: string? }`.\r\n */\n\n\nfunction parsePhoneNumber(formattedPhoneNumber, defaultCountry, defaultCallingCode, metadata) {\n  // Extract calling code from phone number.\n  var _extractCountryCallin = (0,_helpers_extractCountryCallingCode_js__WEBPACK_IMPORTED_MODULE_9__[\"default\"])((0,_parseIncompletePhoneNumber_js__WEBPACK_IMPORTED_MODULE_10__[\"default\"])(formattedPhoneNumber), defaultCountry, defaultCallingCode, metadata.metadata),\n      countryCallingCodeSource = _extractCountryCallin.countryCallingCodeSource,\n      countryCallingCode = _extractCountryCallin.countryCallingCode,\n      number = _extractCountryCallin.number; // Choose a country by `countryCallingCode`.\n\n\n  var country;\n\n  if (countryCallingCode) {\n    metadata.selectNumberingPlan(countryCallingCode);\n  } // If `formattedPhoneNumber` is passed in \"national\" format\n  // then `number` is defined and `countryCallingCode` is `undefined`.\n  else if (number && (defaultCountry || defaultCallingCode)) {\n    metadata.selectNumberingPlan(defaultCountry, defaultCallingCode);\n\n    if (defaultCountry) {\n      country = defaultCountry;\n    } else {\n      /* istanbul ignore if */\n      if (USE_NON_GEOGRAPHIC_COUNTRY_CODE) {\n        if (metadata.isNonGeographicCallingCode(defaultCallingCode)) {\n          country = '001';\n        }\n      }\n    }\n\n    countryCallingCode = defaultCallingCode || (0,_metadata_js__WEBPACK_IMPORTED_MODULE_1__.getCountryCallingCode)(defaultCountry, metadata.metadata);\n  } else return {};\n\n  if (!number) {\n    return {\n      countryCallingCodeSource: countryCallingCodeSource,\n      countryCallingCode: countryCallingCode\n    };\n  }\n\n  var _extractNationalNumbe = (0,_helpers_extractNationalNumber_js__WEBPACK_IMPORTED_MODULE_11__[\"default\"])((0,_parseIncompletePhoneNumber_js__WEBPACK_IMPORTED_MODULE_10__[\"default\"])(number), metadata),\n      nationalNumber = _extractNationalNumbe.nationalNumber,\n      carrierCode = _extractNationalNumbe.carrierCode; // Sometimes there are several countries\n  // corresponding to the same country phone code\n  // (e.g. NANPA countries all having `1` country phone code).\n  // Therefore, to reliably determine the exact country,\n  // national (significant) number should have been parsed first.\n  //\n  // When `metadata.json` is generated, all \"ambiguous\" country phone codes\n  // get their countries populated with the full set of\n  // \"phone number type\" regular expressions.\n  //\n\n\n  var exactCountry = (0,_helpers_getCountryByCallingCode_js__WEBPACK_IMPORTED_MODULE_12__[\"default\"])(countryCallingCode, {\n    nationalNumber: nationalNumber,\n    defaultCountry: defaultCountry,\n    metadata: metadata\n  });\n\n  if (exactCountry) {\n    country = exactCountry;\n    /* istanbul ignore if */\n\n    if (exactCountry === '001') {// Can't happen with `USE_NON_GEOGRAPHIC_COUNTRY_CODE` being `false`.\n      // If `USE_NON_GEOGRAPHIC_COUNTRY_CODE` is set to `true` for some reason,\n      // then remove the \"istanbul ignore if\".\n    } else {\n      metadata.country(country);\n    }\n  }\n\n  return {\n    country: country,\n    countryCallingCode: countryCallingCode,\n    countryCallingCodeSource: countryCallingCodeSource,\n    nationalNumber: nationalNumber,\n    carrierCode: carrierCode\n  };\n}\n//# sourceMappingURL=parse.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/parse.js\n");

/***/ }),

/***/ "(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/parseIncompletePhoneNumber.js":
/*!****************************************************************************************************************************!*\
  !*** ../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/parseIncompletePhoneNumber.js ***!
  \****************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ parseIncompletePhoneNumber),\n/* harmony export */   parsePhoneNumberCharacter: () => (/* binding */ parsePhoneNumberCharacter)\n/* harmony export */ });\n/* harmony import */ var _helpers_parseDigits_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./helpers/parseDigits.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/helpers/parseDigits.js\");\nfunction _createForOfIteratorHelperLoose(o, allowArrayLike) { var it = typeof Symbol !== \"undefined\" && o[Symbol.iterator] || o[\"@@iterator\"]; if (it) return (it = it.call(o)).next.bind(it); if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === \"number\") { if (it) o = it; var i = 0; return function () { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }; } throw new TypeError(\"Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\n\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\n\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }\n\n\n/**\r\n * Parses phone number characters from a string.\r\n * Drops all punctuation leaving only digits and the leading `+` sign (if any).\r\n * Also converts wide-ascii and arabic-indic numerals to conventional numerals.\r\n * E.g. in Iraq they don't write `+442323234` but rather `+٤٤٢٣٢٣٢٣٤`.\r\n * @param  {string} string\r\n * @return {string}\r\n * @example\r\n * ```js\r\n * // Outputs '8800555'.\r\n * parseIncompletePhoneNumber('8 (800) 555')\r\n * // Outputs '+7800555'.\r\n * parseIncompletePhoneNumber('+7 800 555')\r\n * ```\r\n */\n\nfunction parseIncompletePhoneNumber(string) {\n  var result = ''; // Using `.split('')` here instead of normal `for ... of`\n  // because the importing application doesn't neccessarily include an ES6 polyfill.\n  // The `.split('')` approach discards \"exotic\" UTF-8 characters\n  // (the ones consisting of four bytes) but digits\n  // (including non-European ones) don't fall into that range\n  // so such \"exotic\" characters would be discarded anyway.\n\n  for (var _iterator = _createForOfIteratorHelperLoose(string.split('')), _step; !(_step = _iterator()).done;) {\n    var character = _step.value;\n    result += parsePhoneNumberCharacter(character, result) || '';\n  }\n\n  return result;\n}\n/**\r\n * Parses next character while parsing phone number digits (including a `+`)\r\n * from text: discards everything except `+` and digits, and `+` is only allowed\r\n * at the start of a phone number.\r\n * For example, is used in `react-phone-number-input` where it uses\r\n * [`input-format`](https://gitlab.com/catamphetamine/input-format).\r\n * @param  {string} character - Yet another character from raw input string.\r\n * @param  {string?} prevParsedCharacters - Previous parsed characters.\r\n * @param  {function?} emitEvent - An optional \"emit event\" function.\r\n * @return {string?} The parsed character.\r\n */\n\nfunction parsePhoneNumberCharacter(character, prevParsedCharacters, emitEvent) {\n  // Only allow a leading `+`.\n  if (character === '+') {\n    // If this `+` is not the first parsed character\n    // then discard it.\n    if (prevParsedCharacters) {\n      // `emitEvent` argument was added to this `export`ed function on Dec 26th, 2023.\n      // Any 3rd-party code that used to `import` and call this function before that\n      // won't be passing any `emitEvent` argument.\n      //\n      // The addition of the `emitEvent` argument was to fix the slightly-weird behavior\n      // of parsing an input string when the user inputs something like `\"2+7\"\n      // https://github.com/catamphetamine/react-phone-number-input/issues/437\n      //\n      // If the parser encounters an unexpected `+` in a string being parsed\n      // then it simply discards that out-of-place `+` and any following characters.\n      //\n      if (typeof emitEvent === 'function') {\n        emitEvent('end');\n      }\n\n      return;\n    }\n\n    return '+';\n  } // Allow digits.\n\n\n  return (0,_helpers_parseDigits_js__WEBPACK_IMPORTED_MODULE_0__.parseDigit)(character);\n}\n//# sourceMappingURL=parseIncompletePhoneNumber.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/parseIncompletePhoneNumber.js\n");

/***/ }),

/***/ "(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/parsePhoneNumber.js":
/*!******************************************************************************************************************!*\
  !*** ../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/parsePhoneNumber.js ***!
  \******************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ parsePhoneNumber)\n/* harmony export */ });\n/* harmony import */ var _normalizeArguments_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./normalizeArguments.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/normalizeArguments.js\");\n/* harmony import */ var _parsePhoneNumber_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./parsePhoneNumber_.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/parsePhoneNumber_.js\");\n\n\nfunction parsePhoneNumber() {\n  var _normalizeArguments = (0,_normalizeArguments_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(arguments),\n      text = _normalizeArguments.text,\n      options = _normalizeArguments.options,\n      metadata = _normalizeArguments.metadata;\n\n  return (0,_parsePhoneNumber_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(text, options, metadata);\n}\n//# sourceMappingURL=parsePhoneNumber.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi4vbm9kZXZlbnYvc3RhZ2luZy5hZ2VudGFtYml0aW9uYWNhZGVteS5jb20vMjAvbGliL25vZGVfbW9kdWxlcy9saWJwaG9uZW51bWJlci1qcy9lczYvcGFyc2VQaG9uZU51bWJlci5qcyIsIm1hcHBpbmdzIjoiOzs7Ozs7QUFBeUQ7QUFDRjtBQUN4QztBQUNmLDRCQUE0QixrRUFBa0I7QUFDOUM7QUFDQTtBQUNBOztBQUVBLFNBQVMsZ0VBQWlCO0FBQzFCO0FBQ0EiLCJzb3VyY2VzIjpbIi9ob21lL2FnZW50YW1iaXRpb25hY2Evbm9kZXZlbnYvc3RhZ2luZy5hZ2VudGFtYml0aW9uYWNhZGVteS5jb20vMjAvbGliL25vZGVfbW9kdWxlcy9saWJwaG9uZW51bWJlci1qcy9lczYvcGFyc2VQaG9uZU51bWJlci5qcyJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgbm9ybWFsaXplQXJndW1lbnRzIGZyb20gJy4vbm9ybWFsaXplQXJndW1lbnRzLmpzJztcbmltcG9ydCBwYXJzZVBob25lTnVtYmVyXyBmcm9tICcuL3BhcnNlUGhvbmVOdW1iZXJfLmpzJztcbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIHBhcnNlUGhvbmVOdW1iZXIoKSB7XG4gIHZhciBfbm9ybWFsaXplQXJndW1lbnRzID0gbm9ybWFsaXplQXJndW1lbnRzKGFyZ3VtZW50cyksXG4gICAgICB0ZXh0ID0gX25vcm1hbGl6ZUFyZ3VtZW50cy50ZXh0LFxuICAgICAgb3B0aW9ucyA9IF9ub3JtYWxpemVBcmd1bWVudHMub3B0aW9ucyxcbiAgICAgIG1ldGFkYXRhID0gX25vcm1hbGl6ZUFyZ3VtZW50cy5tZXRhZGF0YTtcblxuICByZXR1cm4gcGFyc2VQaG9uZU51bWJlcl8odGV4dCwgb3B0aW9ucywgbWV0YWRhdGEpO1xufVxuLy8jIHNvdXJjZU1hcHBpbmdVUkw9cGFyc2VQaG9uZU51bWJlci5qcy5tYXAiXSwibmFtZXMiOltdLCJpZ25vcmVMaXN0IjpbMF0sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/parsePhoneNumber.js\n");

/***/ }),

/***/ "(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/parsePhoneNumberWithError_.js":
/*!****************************************************************************************************************************!*\
  !*** ../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/parsePhoneNumberWithError_.js ***!
  \****************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ parsePhoneNumberWithError)\n/* harmony export */ });\n/* harmony import */ var _parse_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./parse.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/parse.js\");\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }\n\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }\n\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\n\nfunction parsePhoneNumberWithError(text, options, metadata) {\n  return (0,_parse_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(text, _objectSpread(_objectSpread({}, options), {}, {\n    v2: true\n  }), metadata);\n}\n//# sourceMappingURL=parsePhoneNumberWithError_.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/parsePhoneNumberWithError_.js\n");

/***/ }),

/***/ "(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/parsePhoneNumber_.js":
/*!*******************************************************************************************************************!*\
  !*** ../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/parsePhoneNumber_.js ***!
  \*******************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ parsePhoneNumber)\n/* harmony export */ });\n/* harmony import */ var _parsePhoneNumberWithError_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./parsePhoneNumberWithError_.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/parsePhoneNumberWithError_.js\");\n/* harmony import */ var _ParseError_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ParseError.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/ParseError.js\");\n/* harmony import */ var _metadata_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./metadata.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/metadata.js\");\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }\n\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }\n\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\n\n\n\nfunction parsePhoneNumber(text, options, metadata) {\n  // Validate `defaultCountry`.\n  if (options && options.defaultCountry && !(0,_metadata_js__WEBPACK_IMPORTED_MODULE_0__.isSupportedCountry)(options.defaultCountry, metadata)) {\n    options = _objectSpread(_objectSpread({}, options), {}, {\n      defaultCountry: undefined\n    });\n  } // Parse phone number.\n\n\n  try {\n    return (0,_parsePhoneNumberWithError_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(text, options, metadata);\n  } catch (error) {\n    /* istanbul ignore else */\n    if (error instanceof _ParseError_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"]) {//\n    } else {\n      throw error;\n    }\n  }\n}\n//# sourceMappingURL=parsePhoneNumber_.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/parsePhoneNumber_.js\n");

/***/ }),

/***/ "(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/tools/semver-compare.js":
/*!**********************************************************************************************************************!*\
  !*** ../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/tools/semver-compare.js ***!
  \**********************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n// Copy-pasted from:\n// https://github.com/substack/semver-compare/blob/master/index.js\n//\n// Inlining this function because some users reported issues with\n// importing from `semver-compare` in a browser with ES6 \"native\" modules.\n//\n// Fixes `semver-compare` not being able to compare versions with alpha/beta/etc \"tags\".\n// https://github.com/catamphetamine/libphonenumber-js/issues/381\n/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(a, b) {\n  a = a.split('-');\n  b = b.split('-');\n  var pa = a[0].split('.');\n  var pb = b[0].split('.');\n\n  for (var i = 0; i < 3; i++) {\n    var na = Number(pa[i]);\n    var nb = Number(pb[i]);\n    if (na > nb) return 1;\n    if (nb > na) return -1;\n    if (!isNaN(na) && isNaN(nb)) return 1;\n    if (isNaN(na) && !isNaN(nb)) return -1;\n  }\n\n  if (a[1] && b[1]) {\n    return a[1] > b[1] ? 1 : a[1] < b[1] ? -1 : 0;\n  }\n\n  return !a[1] && b[1] ? 1 : a[1] && !b[1] ? -1 : 0;\n}\n//# sourceMappingURL=semver-compare.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi4vbm9kZXZlbnYvc3RhZ2luZy5hZ2VudGFtYml0aW9uYWNhZGVteS5jb20vMjAvbGliL25vZGVfbW9kdWxlcy9saWJwaG9uZW51bWJlci1qcy9lczYvdG9vbHMvc2VtdmVyLWNvbXBhcmUuanMiLCJtYXBwaW5ncyI6Ijs7OztBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSw2QkFBZSxvQ0FBVTtBQUN6QjtBQUNBO0FBQ0E7QUFDQTs7QUFFQSxrQkFBa0IsT0FBTztBQUN6QjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBIiwic291cmNlcyI6WyIvaG9tZS9hZ2VudGFtYml0aW9uYWNhL25vZGV2ZW52L3N0YWdpbmcuYWdlbnRhbWJpdGlvbmFjYWRlbXkuY29tLzIwL2xpYi9ub2RlX21vZHVsZXMvbGlicGhvbmVudW1iZXItanMvZXM2L3Rvb2xzL3NlbXZlci1jb21wYXJlLmpzIl0sInNvdXJjZXNDb250ZW50IjpbIi8vIENvcHktcGFzdGVkIGZyb206XG4vLyBodHRwczovL2dpdGh1Yi5jb20vc3Vic3RhY2svc2VtdmVyLWNvbXBhcmUvYmxvYi9tYXN0ZXIvaW5kZXguanNcbi8vXG4vLyBJbmxpbmluZyB0aGlzIGZ1bmN0aW9uIGJlY2F1c2Ugc29tZSB1c2VycyByZXBvcnRlZCBpc3N1ZXMgd2l0aFxuLy8gaW1wb3J0aW5nIGZyb20gYHNlbXZlci1jb21wYXJlYCBpbiBhIGJyb3dzZXIgd2l0aCBFUzYgXCJuYXRpdmVcIiBtb2R1bGVzLlxuLy9cbi8vIEZpeGVzIGBzZW12ZXItY29tcGFyZWAgbm90IGJlaW5nIGFibGUgdG8gY29tcGFyZSB2ZXJzaW9ucyB3aXRoIGFscGhhL2JldGEvZXRjIFwidGFnc1wiLlxuLy8gaHR0cHM6Ly9naXRodWIuY29tL2NhdGFtcGhldGFtaW5lL2xpYnBob25lbnVtYmVyLWpzL2lzc3Vlcy8zODFcbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIChhLCBiKSB7XG4gIGEgPSBhLnNwbGl0KCctJyk7XG4gIGIgPSBiLnNwbGl0KCctJyk7XG4gIHZhciBwYSA9IGFbMF0uc3BsaXQoJy4nKTtcbiAgdmFyIHBiID0gYlswXS5zcGxpdCgnLicpO1xuXG4gIGZvciAodmFyIGkgPSAwOyBpIDwgMzsgaSsrKSB7XG4gICAgdmFyIG5hID0gTnVtYmVyKHBhW2ldKTtcbiAgICB2YXIgbmIgPSBOdW1iZXIocGJbaV0pO1xuICAgIGlmIChuYSA+IG5iKSByZXR1cm4gMTtcbiAgICBpZiAobmIgPiBuYSkgcmV0dXJuIC0xO1xuICAgIGlmICghaXNOYU4obmEpICYmIGlzTmFOKG5iKSkgcmV0dXJuIDE7XG4gICAgaWYgKGlzTmFOKG5hKSAmJiAhaXNOYU4obmIpKSByZXR1cm4gLTE7XG4gIH1cblxuICBpZiAoYVsxXSAmJiBiWzFdKSB7XG4gICAgcmV0dXJuIGFbMV0gPiBiWzFdID8gMSA6IGFbMV0gPCBiWzFdID8gLTEgOiAwO1xuICB9XG5cbiAgcmV0dXJuICFhWzFdICYmIGJbMV0gPyAxIDogYVsxXSAmJiAhYlsxXSA/IC0xIDogMDtcbn1cbi8vIyBzb3VyY2VNYXBwaW5nVVJMPXNlbXZlci1jb21wYXJlLmpzLm1hcCJdLCJuYW1lcyI6W10sImlnbm9yZUxpc3QiOlswXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/es6/tools/semver-compare.js\n");

/***/ }),

/***/ "(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/metadata.min.json.js":
/*!***************************************************************************************************************!*\
  !*** ../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/libphonenumber-js/metadata.min.json.js ***!
  \***************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n// This file is a workaround for a bug in web browsers' \"native\"\n// ES6 importing system which is uncapable of importing \"*.json\" files.\n// https://github.com/catamphetamine/libphonenumber-js/issues/239\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({\"version\":4,\"country_calling_codes\":{\"1\":[\"US\",\"AG\",\"AI\",\"AS\",\"BB\",\"BM\",\"BS\",\"CA\",\"DM\",\"DO\",\"GD\",\"GU\",\"JM\",\"KN\",\"KY\",\"LC\",\"MP\",\"MS\",\"PR\",\"SX\",\"TC\",\"TT\",\"VC\",\"VG\",\"VI\"],\"7\":[\"RU\",\"KZ\"],\"20\":[\"EG\"],\"27\":[\"ZA\"],\"30\":[\"GR\"],\"31\":[\"NL\"],\"32\":[\"BE\"],\"33\":[\"FR\"],\"34\":[\"ES\"],\"36\":[\"HU\"],\"39\":[\"IT\",\"VA\"],\"40\":[\"RO\"],\"41\":[\"CH\"],\"43\":[\"AT\"],\"44\":[\"GB\",\"GG\",\"IM\",\"JE\"],\"45\":[\"DK\"],\"46\":[\"SE\"],\"47\":[\"NO\",\"SJ\"],\"48\":[\"PL\"],\"49\":[\"DE\"],\"51\":[\"PE\"],\"52\":[\"MX\"],\"53\":[\"CU\"],\"54\":[\"AR\"],\"55\":[\"BR\"],\"56\":[\"CL\"],\"57\":[\"CO\"],\"58\":[\"VE\"],\"60\":[\"MY\"],\"61\":[\"AU\",\"CC\",\"CX\"],\"62\":[\"ID\"],\"63\":[\"PH\"],\"64\":[\"NZ\"],\"65\":[\"SG\"],\"66\":[\"TH\"],\"81\":[\"JP\"],\"82\":[\"KR\"],\"84\":[\"VN\"],\"86\":[\"CN\"],\"90\":[\"TR\"],\"91\":[\"IN\"],\"92\":[\"PK\"],\"93\":[\"AF\"],\"94\":[\"LK\"],\"95\":[\"MM\"],\"98\":[\"IR\"],\"211\":[\"SS\"],\"212\":[\"MA\",\"EH\"],\"213\":[\"DZ\"],\"216\":[\"TN\"],\"218\":[\"LY\"],\"220\":[\"GM\"],\"221\":[\"SN\"],\"222\":[\"MR\"],\"223\":[\"ML\"],\"224\":[\"GN\"],\"225\":[\"CI\"],\"226\":[\"BF\"],\"227\":[\"NE\"],\"228\":[\"TG\"],\"229\":[\"BJ\"],\"230\":[\"MU\"],\"231\":[\"LR\"],\"232\":[\"SL\"],\"233\":[\"GH\"],\"234\":[\"NG\"],\"235\":[\"TD\"],\"236\":[\"CF\"],\"237\":[\"CM\"],\"238\":[\"CV\"],\"239\":[\"ST\"],\"240\":[\"GQ\"],\"241\":[\"GA\"],\"242\":[\"CG\"],\"243\":[\"CD\"],\"244\":[\"AO\"],\"245\":[\"GW\"],\"246\":[\"IO\"],\"247\":[\"AC\"],\"248\":[\"SC\"],\"249\":[\"SD\"],\"250\":[\"RW\"],\"251\":[\"ET\"],\"252\":[\"SO\"],\"253\":[\"DJ\"],\"254\":[\"KE\"],\"255\":[\"TZ\"],\"256\":[\"UG\"],\"257\":[\"BI\"],\"258\":[\"MZ\"],\"260\":[\"ZM\"],\"261\":[\"MG\"],\"262\":[\"RE\",\"YT\"],\"263\":[\"ZW\"],\"264\":[\"NA\"],\"265\":[\"MW\"],\"266\":[\"LS\"],\"267\":[\"BW\"],\"268\":[\"SZ\"],\"269\":[\"KM\"],\"290\":[\"SH\",\"TA\"],\"291\":[\"ER\"],\"297\":[\"AW\"],\"298\":[\"FO\"],\"299\":[\"GL\"],\"350\":[\"GI\"],\"351\":[\"PT\"],\"352\":[\"LU\"],\"353\":[\"IE\"],\"354\":[\"IS\"],\"355\":[\"AL\"],\"356\":[\"MT\"],\"357\":[\"CY\"],\"358\":[\"FI\",\"AX\"],\"359\":[\"BG\"],\"370\":[\"LT\"],\"371\":[\"LV\"],\"372\":[\"EE\"],\"373\":[\"MD\"],\"374\":[\"AM\"],\"375\":[\"BY\"],\"376\":[\"AD\"],\"377\":[\"MC\"],\"378\":[\"SM\"],\"380\":[\"UA\"],\"381\":[\"RS\"],\"382\":[\"ME\"],\"383\":[\"XK\"],\"385\":[\"HR\"],\"386\":[\"SI\"],\"387\":[\"BA\"],\"389\":[\"MK\"],\"420\":[\"CZ\"],\"421\":[\"SK\"],\"423\":[\"LI\"],\"500\":[\"FK\"],\"501\":[\"BZ\"],\"502\":[\"GT\"],\"503\":[\"SV\"],\"504\":[\"HN\"],\"505\":[\"NI\"],\"506\":[\"CR\"],\"507\":[\"PA\"],\"508\":[\"PM\"],\"509\":[\"HT\"],\"590\":[\"GP\",\"BL\",\"MF\"],\"591\":[\"BO\"],\"592\":[\"GY\"],\"593\":[\"EC\"],\"594\":[\"GF\"],\"595\":[\"PY\"],\"596\":[\"MQ\"],\"597\":[\"SR\"],\"598\":[\"UY\"],\"599\":[\"CW\",\"BQ\"],\"670\":[\"TL\"],\"672\":[\"NF\"],\"673\":[\"BN\"],\"674\":[\"NR\"],\"675\":[\"PG\"],\"676\":[\"TO\"],\"677\":[\"SB\"],\"678\":[\"VU\"],\"679\":[\"FJ\"],\"680\":[\"PW\"],\"681\":[\"WF\"],\"682\":[\"CK\"],\"683\":[\"NU\"],\"685\":[\"WS\"],\"686\":[\"KI\"],\"687\":[\"NC\"],\"688\":[\"TV\"],\"689\":[\"PF\"],\"690\":[\"TK\"],\"691\":[\"FM\"],\"692\":[\"MH\"],\"850\":[\"KP\"],\"852\":[\"HK\"],\"853\":[\"MO\"],\"855\":[\"KH\"],\"856\":[\"LA\"],\"880\":[\"BD\"],\"886\":[\"TW\"],\"960\":[\"MV\"],\"961\":[\"LB\"],\"962\":[\"JO\"],\"963\":[\"SY\"],\"964\":[\"IQ\"],\"965\":[\"KW\"],\"966\":[\"SA\"],\"967\":[\"YE\"],\"968\":[\"OM\"],\"970\":[\"PS\"],\"971\":[\"AE\"],\"972\":[\"IL\"],\"973\":[\"BH\"],\"974\":[\"QA\"],\"975\":[\"BT\"],\"976\":[\"MN\"],\"977\":[\"NP\"],\"992\":[\"TJ\"],\"993\":[\"TM\"],\"994\":[\"AZ\"],\"995\":[\"GE\"],\"996\":[\"KG\"],\"998\":[\"UZ\"]},\"countries\":{\"AC\":[\"247\",\"00\",\"(?:[01589]\\\\d|[46])\\\\d{4}\",[5,6]],\"AD\":[\"376\",\"00\",\"(?:1|6\\\\d)\\\\d{7}|[135-9]\\\\d{5}\",[6,8,9],[[\"(\\\\d{3})(\\\\d{3})\",\"$1 $2\",[\"[135-9]\"]],[\"(\\\\d{4})(\\\\d{4})\",\"$1 $2\",[\"1\"]],[\"(\\\\d{3})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"6\"]]]],\"AE\":[\"971\",\"00\",\"(?:[4-7]\\\\d|9[0-689])\\\\d{7}|800\\\\d{2,9}|[2-4679]\\\\d{7}\",[5,6,7,8,9,10,11,12],[[\"(\\\\d{3})(\\\\d{2,9})\",\"$1 $2\",[\"60|8\"]],[\"(\\\\d)(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"[236]|[479][2-8]\"],\"0$1\"],[\"(\\\\d{3})(\\\\d)(\\\\d{5})\",\"$1 $2 $3\",[\"[479]\"]],[\"(\\\\d{2})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"5\"],\"0$1\"]],\"0\"],\"AF\":[\"93\",\"00\",\"[2-7]\\\\d{8}\",[9],[[\"(\\\\d{2})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"[2-7]\"],\"0$1\"]],\"0\"],\"AG\":[\"1\",\"011\",\"(?:268|[58]\\\\d\\\\d|900)\\\\d{7}\",[10],0,\"1\",0,\"([457]\\\\d{6})$|1\",\"268$1\",0,\"268\"],\"AI\":[\"1\",\"011\",\"(?:264|[58]\\\\d\\\\d|900)\\\\d{7}\",[10],0,\"1\",0,\"([2457]\\\\d{6})$|1\",\"264$1\",0,\"264\"],\"AL\":[\"355\",\"00\",\"(?:700\\\\d\\\\d|900)\\\\d{3}|8\\\\d{5,7}|(?:[2-5]|6\\\\d)\\\\d{7}\",[6,7,8,9],[[\"(\\\\d{3})(\\\\d{3,4})\",\"$1 $2\",[\"80|9\"],\"0$1\"],[\"(\\\\d)(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"4[2-6]\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"[2358][2-5]|4\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{5})\",\"$1 $2\",[\"[23578]\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"6\"],\"0$1\"]],\"0\"],\"AM\":[\"374\",\"00\",\"(?:[1-489]\\\\d|55|60|77)\\\\d{6}\",[8],[[\"(\\\\d{3})(\\\\d{2})(\\\\d{3})\",\"$1 $2 $3\",[\"[89]0\"],\"0 $1\"],[\"(\\\\d{3})(\\\\d{5})\",\"$1 $2\",[\"2|3[12]\"],\"(0$1)\"],[\"(\\\\d{2})(\\\\d{6})\",\"$1 $2\",[\"1|47\"],\"(0$1)\"],[\"(\\\\d{2})(\\\\d{6})\",\"$1 $2\",[\"[3-9]\"],\"0$1\"]],\"0\"],\"AO\":[\"244\",\"00\",\"[29]\\\\d{8}\",[9],[[\"(\\\\d{3})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"[29]\"]]]],\"AR\":[\"54\",\"00\",\"(?:11|[89]\\\\d\\\\d)\\\\d{8}|[2368]\\\\d{9}\",[10,11],[[\"(\\\\d{4})(\\\\d{2})(\\\\d{4})\",\"$1 $2-$3\",[\"2(?:2[024-9]|3[0-59]|47|6[245]|9[02-8])|3(?:3[28]|4[03-9]|5[2-46-8]|7[1-578]|8[2-9])\",\"2(?:[23]02|6(?:[25]|4[6-8])|9(?:[02356]|4[02568]|72|8[23]))|3(?:3[28]|4(?:[04679]|3[5-8]|5[4-68]|8[2379])|5(?:[2467]|3[237]|8[2-5])|7[1-578]|8(?:[2469]|3[2578]|5[4-8]|7[36-8]|8[5-8]))|2(?:2[24-9]|3[1-59]|47)\",\"2(?:[23]02|6(?:[25]|4(?:64|[78]))|9(?:[02356]|4(?:[0268]|5[2-6])|72|8[23]))|3(?:3[28]|4(?:[04679]|3[78]|5(?:4[46]|8)|8[2379])|5(?:[2467]|3[237]|8[23])|7[1-578]|8(?:[2469]|3[278]|5[56][46]|86[3-6]))|2(?:2[24-9]|3[1-59]|47)|38(?:[58][78]|7[378])|3(?:4[35][56]|58[45]|8(?:[38]5|54|76))[4-6]\",\"2(?:[23]02|6(?:[25]|4(?:64|[78]))|9(?:[02356]|4(?:[0268]|5[2-6])|72|8[23]))|3(?:3[28]|4(?:[04679]|3(?:5(?:4[0-25689]|[56])|[78])|58|8[2379])|5(?:[2467]|3[237]|8(?:[23]|4(?:[45]|60)|5(?:4[0-39]|5|64)))|7[1-578]|8(?:[2469]|3[278]|54(?:4|5[13-7]|6[89])|86[3-6]))|2(?:2[24-9]|3[1-59]|47)|38(?:[58][78]|7[378])|3(?:454|85[56])[46]|3(?:4(?:36|5[56])|8(?:[38]5|76))[4-6]\"],\"0$1\",1],[\"(\\\\d{2})(\\\\d{4})(\\\\d{4})\",\"$1 $2-$3\",[\"1\"],\"0$1\",1],[\"(\\\\d{3})(\\\\d{3})(\\\\d{4})\",\"$1-$2-$3\",[\"[68]\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{3})(\\\\d{4})\",\"$1 $2-$3\",[\"[23]\"],\"0$1\",1],[\"(\\\\d)(\\\\d{4})(\\\\d{2})(\\\\d{4})\",\"$2 15-$3-$4\",[\"9(?:2[2-469]|3[3-578])\",\"9(?:2(?:2[024-9]|3[0-59]|47|6[245]|9[02-8])|3(?:3[28]|4[03-9]|5[2-46-8]|7[1-578]|8[2-9]))\",\"9(?:2(?:[23]02|6(?:[25]|4[6-8])|9(?:[02356]|4[02568]|72|8[23]))|3(?:3[28]|4(?:[04679]|3[5-8]|5[4-68]|8[2379])|5(?:[2467]|3[237]|8[2-5])|7[1-578]|8(?:[2469]|3[2578]|5[4-8]|7[36-8]|8[5-8])))|92(?:2[24-9]|3[1-59]|47)\",\"9(?:2(?:[23]02|6(?:[25]|4(?:64|[78]))|9(?:[02356]|4(?:[0268]|5[2-6])|72|8[23]))|3(?:3[28]|4(?:[04679]|3[78]|5(?:4[46]|8)|8[2379])|5(?:[2467]|3[237]|8[23])|7[1-578]|8(?:[2469]|3[278]|5(?:[56][46]|[78])|7[378]|8(?:6[3-6]|[78]))))|92(?:2[24-9]|3[1-59]|47)|93(?:4[35][56]|58[45]|8(?:[38]5|54|76))[4-6]\",\"9(?:2(?:[23]02|6(?:[25]|4(?:64|[78]))|9(?:[02356]|4(?:[0268]|5[2-6])|72|8[23]))|3(?:3[28]|4(?:[04679]|3(?:5(?:4[0-25689]|[56])|[78])|5(?:4[46]|8)|8[2379])|5(?:[2467]|3[237]|8(?:[23]|4(?:[45]|60)|5(?:4[0-39]|5|64)))|7[1-578]|8(?:[2469]|3[278]|5(?:4(?:4|5[13-7]|6[89])|[56][46]|[78])|7[378]|8(?:6[3-6]|[78]))))|92(?:2[24-9]|3[1-59]|47)|93(?:4(?:36|5[56])|8(?:[38]5|76))[4-6]\"],\"0$1\",0,\"$1 $2 $3-$4\"],[\"(\\\\d)(\\\\d{2})(\\\\d{4})(\\\\d{4})\",\"$2 15-$3-$4\",[\"91\"],\"0$1\",0,\"$1 $2 $3-$4\"],[\"(\\\\d{3})(\\\\d{3})(\\\\d{5})\",\"$1-$2-$3\",[\"8\"],\"0$1\"],[\"(\\\\d)(\\\\d{3})(\\\\d{3})(\\\\d{4})\",\"$2 15-$3-$4\",[\"9\"],\"0$1\",0,\"$1 $2 $3-$4\"]],\"0\",0,\"0?(?:(11|2(?:2(?:02?|[13]|2[13-79]|4[1-6]|5[2457]|6[124-8]|7[1-4]|8[13-6]|9[1267])|3(?:02?|1[467]|2[03-6]|3[13-8]|[49][2-6]|5[2-8]|[67])|4(?:7[3-578]|9)|6(?:[0136]|2[24-6]|4[6-8]?|5[15-8])|80|9(?:0[1-3]|[19]|2\\\\d|3[1-6]|4[02568]?|5[2-4]|6[2-46]|72?|8[23]?))|3(?:3(?:2[79]|6|8[2578])|4(?:0[0-24-9]|[12]|3[5-8]?|4[24-7]|5[4-68]?|6[02-9]|7[126]|8[2379]?|9[1-36-8])|5(?:1|2[1245]|3[237]?|4[1-46-9]|6[2-4]|7[1-6]|8[2-5]?)|6[24]|7(?:[069]|1[1568]|2[15]|3[145]|4[13]|5[14-8]|7[2-57]|8[126])|8(?:[01]|2[15-7]|3[2578]?|4[13-6]|5[4-8]?|6[1-357-9]|7[36-8]?|8[5-8]?|9[124])))15)?\",\"9$1\"],\"AS\":[\"1\",\"011\",\"(?:[58]\\\\d\\\\d|684|900)\\\\d{7}\",[10],0,\"1\",0,\"([267]\\\\d{6})$|1\",\"684$1\",0,\"684\"],\"AT\":[\"43\",\"00\",\"1\\\\d{3,12}|2\\\\d{6,12}|43(?:(?:0\\\\d|5[02-9])\\\\d{3,9}|2\\\\d{4,5}|[3467]\\\\d{4}|8\\\\d{4,6}|9\\\\d{4,7})|5\\\\d{4,12}|8\\\\d{7,12}|9\\\\d{8,12}|(?:[367]\\\\d|4[0-24-9])\\\\d{4,11}\",[4,5,6,7,8,9,10,11,12,13],[[\"(\\\\d)(\\\\d{3,12})\",\"$1 $2\",[\"1(?:11|[2-9])\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{2})\",\"$1 $2\",[\"517\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{3,5})\",\"$1 $2\",[\"5[079]\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{3,10})\",\"$1 $2\",[\"(?:31|4)6|51|6(?:48|5[0-3579]|[6-9])|7(?:20|32|8)|[89]\",\"(?:31|4)6|51|6(?:485|5[0-3579]|[6-9])|7(?:20|32|8)|[89]\"],\"0$1\"],[\"(\\\\d{4})(\\\\d{3,9})\",\"$1 $2\",[\"[2-467]|5[2-6]\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{3,4})\",\"$1 $2 $3\",[\"5\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{4})(\\\\d{4,7})\",\"$1 $2 $3\",[\"5\"],\"0$1\"]],\"0\"],\"AU\":[\"61\",\"001[14-689]|14(?:1[14]|34|4[17]|[56]6|7[47]|88)0011\",\"1(?:[0-79]\\\\d{7}(?:\\\\d(?:\\\\d{2})?)?|8[0-24-9]\\\\d{7})|[2-478]\\\\d{8}|1\\\\d{4,7}\",[5,6,7,8,9,10,12],[[\"(\\\\d{2})(\\\\d{3,4})\",\"$1 $2\",[\"16\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{2,4})\",\"$1 $2 $3\",[\"16\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"14|4\"],\"0$1\"],[\"(\\\\d)(\\\\d{4})(\\\\d{4})\",\"$1 $2 $3\",[\"[2378]\"],\"(0$1)\"],[\"(\\\\d{4})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"1(?:30|[89])\"]]],\"0\",0,\"(183[12])|0\",0,0,0,[[\"(?:(?:(?:2(?:[0-26-9]\\\\d|3[0-8]|4[02-9]|5[0135-9])|7(?:[013-57-9]\\\\d|2[0-8]))\\\\d|3(?:(?:[0-3589]\\\\d|6[1-9]|7[0-35-9])\\\\d|4(?:[0-578]\\\\d|90)))\\\\d\\\\d|8(?:51(?:0(?:0[03-9]|[12479]\\\\d|3[2-9]|5[0-8]|6[1-9]|8[0-7])|1(?:[0235689]\\\\d|1[0-69]|4[0-589]|7[0-47-9])|2(?:0[0-79]|[18][13579]|2[14-9]|3[0-46-9]|[4-6]\\\\d|7[89]|9[0-4])|3\\\\d\\\\d)|(?:6[0-8]|[78]\\\\d)\\\\d{3}|9(?:[02-9]\\\\d{3}|1(?:(?:[0-58]\\\\d|6[0135-9])\\\\d|7(?:0[0-24-9]|[1-9]\\\\d)|9(?:[0-46-9]\\\\d|5[0-79])))))\\\\d{3}\",[9]],[\"4(?:79[01]|83[0-389]|94[0-4])\\\\d{5}|4(?:[0-36]\\\\d|4[047-9]|5[0-25-9]|7[02-8]|8[0-24-9]|9[0-37-9])\\\\d{6}\",[9]],[\"180(?:0\\\\d{3}|2)\\\\d{3}\",[7,10]],[\"190[0-26]\\\\d{6}\",[10]],0,0,0,[\"163\\\\d{2,6}\",[5,6,7,8,9]],[\"14(?:5(?:1[0458]|[23][458])|71\\\\d)\\\\d{4}\",[9]],[\"13(?:00\\\\d{6}(?:\\\\d{2})?|45[0-4]\\\\d{3})|13\\\\d{4}\",[6,8,10,12]]],\"0011\"],\"AW\":[\"297\",\"00\",\"(?:[25-79]\\\\d\\\\d|800)\\\\d{4}\",[7],[[\"(\\\\d{3})(\\\\d{4})\",\"$1 $2\",[\"[25-9]\"]]]],\"AX\":[\"358\",\"00|99(?:[01469]|5(?:[14]1|3[23]|5[59]|77|88|9[09]))\",\"2\\\\d{4,9}|35\\\\d{4,5}|(?:60\\\\d\\\\d|800)\\\\d{4,6}|7\\\\d{5,11}|(?:[14]\\\\d|3[0-46-9]|50)\\\\d{4,8}\",[5,6,7,8,9,10,11,12],0,\"0\",0,0,0,0,\"18\",0,\"00\"],\"AZ\":[\"994\",\"00\",\"365\\\\d{6}|(?:[124579]\\\\d|60|88)\\\\d{7}\",[9],[[\"(\\\\d{3})(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"90\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"1[28]|2|365|46\",\"1[28]|2|365[45]|46\",\"1[28]|2|365(?:4|5[02])|46\"],\"(0$1)\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"[13-9]\"],\"0$1\"]],\"0\"],\"BA\":[\"387\",\"00\",\"6\\\\d{8}|(?:[35689]\\\\d|49|70)\\\\d{6}\",[8,9],[[\"(\\\\d{2})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"6[1-3]|[7-9]\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{3})\",\"$1 $2-$3\",[\"[3-5]|6[56]\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{2})(\\\\d{2})(\\\\d{3})\",\"$1 $2 $3 $4\",[\"6\"],\"0$1\"]],\"0\"],\"BB\":[\"1\",\"011\",\"(?:246|[58]\\\\d\\\\d|900)\\\\d{7}\",[10],0,\"1\",0,\"([2-9]\\\\d{6})$|1\",\"246$1\",0,\"246\"],\"BD\":[\"880\",\"00\",\"[1-469]\\\\d{9}|8[0-79]\\\\d{7,8}|[2-79]\\\\d{8}|[2-9]\\\\d{7}|[3-9]\\\\d{6}|[57-9]\\\\d{5}\",[6,7,8,9,10],[[\"(\\\\d{2})(\\\\d{4,6})\",\"$1-$2\",[\"31[5-8]|[459]1\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{3,7})\",\"$1-$2\",[\"3(?:[67]|8[013-9])|4(?:6[168]|7|[89][18])|5(?:6[128]|9)|6(?:[15]|28|4[14])|7[2-589]|8(?:0[014-9]|[12])|9[358]|(?:3[2-5]|4[235]|5[2-578]|6[0389]|76|8[3-7]|9[24])1|(?:44|66)[01346-9]\"],\"0$1\"],[\"(\\\\d{4})(\\\\d{3,6})\",\"$1-$2\",[\"[13-9]|2[23]\"],\"0$1\"],[\"(\\\\d)(\\\\d{7,8})\",\"$1-$2\",[\"2\"],\"0$1\"]],\"0\"],\"BE\":[\"32\",\"00\",\"4\\\\d{8}|[1-9]\\\\d{7}\",[8,9],[[\"(\\\\d{3})(\\\\d{2})(\\\\d{3})\",\"$1 $2 $3\",[\"(?:80|9)0\"],\"0$1\"],[\"(\\\\d)(\\\\d{3})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"[239]|4[23]\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"[15-8]\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"4\"],\"0$1\"]],\"0\"],\"BF\":[\"226\",\"00\",\"[025-7]\\\\d{7}\",[8],[[\"(\\\\d{2})(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"[025-7]\"]]]],\"BG\":[\"359\",\"00\",\"00800\\\\d{7}|[2-7]\\\\d{6,7}|[89]\\\\d{6,8}|2\\\\d{5}\",[6,7,8,9,12],[[\"(\\\\d)(\\\\d)(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"2\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{4})\",\"$1 $2\",[\"43[1-6]|70[1-9]\"],\"0$1\"],[\"(\\\\d)(\\\\d{3})(\\\\d{3,4})\",\"$1 $2 $3\",[\"2\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{2,3})\",\"$1 $2 $3\",[\"[356]|4[124-7]|7[1-9]|8[1-6]|9[1-7]\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{2})(\\\\d{3})\",\"$1 $2 $3\",[\"(?:70|8)0\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{3})(\\\\d{2})\",\"$1 $2 $3\",[\"43[1-7]|7\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{3,4})\",\"$1 $2 $3\",[\"[48]|9[08]\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"9\"],\"0$1\"]],\"0\"],\"BH\":[\"973\",\"00\",\"[136-9]\\\\d{7}\",[8],[[\"(\\\\d{4})(\\\\d{4})\",\"$1 $2\",[\"[13679]|8[02-4679]\"]]]],\"BI\":[\"257\",\"00\",\"(?:[267]\\\\d|31)\\\\d{6}\",[8],[[\"(\\\\d{2})(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"[2367]\"]]]],\"BJ\":[\"229\",\"00\",\"(?:01\\\\d|[24-689])\\\\d{7}\",[8,10],[[\"(\\\\d{2})(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"[24-689]\"]],[\"(\\\\d{2})(\\\\d{2})(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4 $5\",[\"0\"]]]],\"BL\":[\"590\",\"00\",\"(?:590\\\\d|7090)\\\\d{5}|(?:69|80|9\\\\d)\\\\d{7}\",[9],0,\"0\",0,0,0,0,0,[[\"590(?:2[7-9]|3[3-7]|5[12]|87)\\\\d{4}\"],[\"(?:69(?:0\\\\d\\\\d|1(?:2[2-9]|3[0-5])|4(?:0[89]|1[2-6]|9\\\\d)|6(?:1[016-9]|5[0-4]|[67]\\\\d))|7090[0-4])\\\\d{4}\"],[\"80[0-5]\\\\d{6}\"],0,0,0,0,0,[\"9(?:(?:39[5-7]|76[018])\\\\d|475[0-6])\\\\d{4}\"]]],\"BM\":[\"1\",\"011\",\"(?:441|[58]\\\\d\\\\d|900)\\\\d{7}\",[10],0,\"1\",0,\"([2-9]\\\\d{6})$|1\",\"441$1\",0,\"441\"],\"BN\":[\"673\",\"00\",\"[2-578]\\\\d{6}\",[7],[[\"(\\\\d{3})(\\\\d{4})\",\"$1 $2\",[\"[2-578]\"]]]],\"BO\":[\"591\",\"00(?:1\\\\d)?\",\"8001\\\\d{5}|(?:[2-467]\\\\d|50)\\\\d{6}\",[8,9],[[\"(\\\\d)(\\\\d{7})\",\"$1 $2\",[\"[235]|4[46]\"]],[\"(\\\\d{8})\",\"$1\",[\"[67]\"]],[\"(\\\\d{3})(\\\\d{2})(\\\\d{4})\",\"$1 $2 $3\",[\"8\"]]],\"0\",0,\"0(1\\\\d)?\"],\"BQ\":[\"599\",\"00\",\"(?:[34]1|7\\\\d)\\\\d{5}\",[7],0,0,0,0,0,0,\"[347]\"],\"BR\":[\"55\",\"00(?:1[245]|2[1-35]|31|4[13]|[56]5|99)\",\"(?:[1-46-9]\\\\d\\\\d|5(?:[0-46-9]\\\\d|5[0-46-9]))\\\\d{8}|[1-9]\\\\d{9}|[3589]\\\\d{8}|[34]\\\\d{7}\",[8,9,10,11],[[\"(\\\\d{4})(\\\\d{4})\",\"$1-$2\",[\"300|4(?:0[02]|37)\",\"4(?:02|37)0|[34]00\"]],[\"(\\\\d{3})(\\\\d{2,3})(\\\\d{4})\",\"$1 $2 $3\",[\"(?:[358]|90)0\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{4})(\\\\d{4})\",\"$1 $2-$3\",[\"(?:[14689][1-9]|2[12478]|3[1-578]|5[13-5]|7[13-579])[2-57]\"],\"($1)\"],[\"(\\\\d{2})(\\\\d{5})(\\\\d{4})\",\"$1 $2-$3\",[\"[16][1-9]|[2-57-9]\"],\"($1)\"]],\"0\",0,\"(?:0|90)(?:(1[245]|2[1-35]|31|4[13]|[56]5|99)(\\\\d{10,11}))?\",\"$2\"],\"BS\":[\"1\",\"011\",\"(?:242|[58]\\\\d\\\\d|900)\\\\d{7}\",[10],0,\"1\",0,\"([3-8]\\\\d{6})$|1\",\"242$1\",0,\"242\"],\"BT\":[\"975\",\"00\",\"[17]\\\\d{7}|[2-8]\\\\d{6}\",[7,8],[[\"(\\\\d)(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"[2-68]|7[246]\"]],[\"(\\\\d{2})(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"1[67]|7\"]]]],\"BW\":[\"267\",\"00\",\"(?:0800|(?:[37]|800)\\\\d)\\\\d{6}|(?:[2-6]\\\\d|90)\\\\d{5}\",[7,8,10],[[\"(\\\\d{2})(\\\\d{5})\",\"$1 $2\",[\"90\"]],[\"(\\\\d{3})(\\\\d{4})\",\"$1 $2\",[\"[24-6]|3[15-9]\"]],[\"(\\\\d{2})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"[37]\"]],[\"(\\\\d{4})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"0\"]],[\"(\\\\d{3})(\\\\d{4})(\\\\d{3})\",\"$1 $2 $3\",[\"8\"]]]],\"BY\":[\"375\",\"810\",\"(?:[12]\\\\d|33|44|902)\\\\d{7}|8(?:0[0-79]\\\\d{5,7}|[1-7]\\\\d{9})|8(?:1[0-489]|[5-79]\\\\d)\\\\d{7}|8[1-79]\\\\d{6,7}|8[0-79]\\\\d{5}|8\\\\d{5}\",[6,7,8,9,10,11],[[\"(\\\\d{3})(\\\\d{3})\",\"$1 $2\",[\"800\"],\"8 $1\"],[\"(\\\\d{3})(\\\\d{2})(\\\\d{2,4})\",\"$1 $2 $3\",[\"800\"],\"8 $1\"],[\"(\\\\d{4})(\\\\d{2})(\\\\d{3})\",\"$1 $2-$3\",[\"1(?:5[169]|6[3-5]|7[179])|2(?:1[35]|2[34]|3[3-5])\",\"1(?:5[169]|6(?:3[1-3]|4|5[125])|7(?:1[3-9]|7[0-24-6]|9[2-7]))|2(?:1[35]|2[34]|3[3-5])\"],\"8 0$1\"],[\"(\\\\d{3})(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1 $2-$3-$4\",[\"1(?:[56]|7[467])|2[1-3]\"],\"8 0$1\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{2})(\\\\d{2})\",\"$1 $2-$3-$4\",[\"[1-4]\"],\"8 0$1\"],[\"(\\\\d{3})(\\\\d{3,4})(\\\\d{4})\",\"$1 $2 $3\",[\"[89]\"],\"8 $1\"]],\"8\",0,\"0|80?\",0,0,0,0,\"8~10\"],\"BZ\":[\"501\",\"00\",\"(?:0800\\\\d|[2-8])\\\\d{6}\",[7,11],[[\"(\\\\d{3})(\\\\d{4})\",\"$1-$2\",[\"[2-8]\"]],[\"(\\\\d)(\\\\d{3})(\\\\d{4})(\\\\d{3})\",\"$1-$2-$3-$4\",[\"0\"]]]],\"CA\":[\"1\",\"011\",\"[2-9]\\\\d{9}|3\\\\d{6}\",[7,10],0,\"1\",0,0,0,0,0,[[\"(?:2(?:04|[23]6|[48]9|50|63)|3(?:06|43|54|6[578]|82)|4(?:03|1[68]|[26]8|3[178]|50|74)|5(?:06|1[49]|48|79|8[147])|6(?:04|[18]3|39|47|72)|7(?:0[59]|42|53|78|8[02])|8(?:[06]7|19|25|7[39])|9(?:0[25]|42))[2-9]\\\\d{6}\",[10]],[\"\",[10]],[\"8(?:00|33|44|55|66|77|88)[2-9]\\\\d{6}\",[10]],[\"900[2-9]\\\\d{6}\",[10]],[\"52(?:3(?:[2-46-9][02-9]\\\\d|5(?:[02-46-9]\\\\d|5[0-46-9]))|4(?:[2-478][02-9]\\\\d|5(?:[034]\\\\d|2[024-9]|5[0-46-9])|6(?:0[1-9]|[2-9]\\\\d)|9(?:[05-9]\\\\d|2[0-5]|49)))\\\\d{4}|52[34][2-9]1[02-9]\\\\d{4}|(?:5(?:2[125-9]|33|44|66|77|88)|6(?:22|33))[2-9]\\\\d{6}\",[10]],0,[\"310\\\\d{4}\",[7]],0,[\"600[2-9]\\\\d{6}\",[10]]]],\"CC\":[\"61\",\"001[14-689]|14(?:1[14]|34|4[17]|[56]6|7[47]|88)0011\",\"1(?:[0-79]\\\\d{8}(?:\\\\d{2})?|8[0-24-9]\\\\d{7})|[148]\\\\d{8}|1\\\\d{5,7}\",[6,7,8,9,10,12],0,\"0\",0,\"([59]\\\\d{7})$|0\",\"8$1\",0,0,[[\"8(?:51(?:0(?:02|31|60|89)|1(?:18|76)|223)|91(?:0(?:1[0-2]|29)|1(?:[28]2|50|79)|2(?:10|64)|3(?:[06]8|22)|4[29]8|62\\\\d|70[23]|959))\\\\d{3}\",[9]],[\"4(?:79[01]|83[0-389]|94[0-4])\\\\d{5}|4(?:[0-36]\\\\d|4[047-9]|5[0-25-9]|7[02-8]|8[0-24-9]|9[0-37-9])\\\\d{6}\",[9]],[\"180(?:0\\\\d{3}|2)\\\\d{3}\",[7,10]],[\"190[0-26]\\\\d{6}\",[10]],0,0,0,0,[\"14(?:5(?:1[0458]|[23][458])|71\\\\d)\\\\d{4}\",[9]],[\"13(?:00\\\\d{6}(?:\\\\d{2})?|45[0-4]\\\\d{3})|13\\\\d{4}\",[6,8,10,12]]],\"0011\"],\"CD\":[\"243\",\"00\",\"(?:(?:[189]|5\\\\d)\\\\d|2)\\\\d{7}|[1-68]\\\\d{6}\",[7,8,9,10],[[\"(\\\\d{2})(\\\\d{2})(\\\\d{3})\",\"$1 $2 $3\",[\"88\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{5})\",\"$1 $2\",[\"[1-6]\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{2})(\\\\d{4})\",\"$1 $2 $3\",[\"2\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"1\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"[89]\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{2})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3 $4\",[\"5\"],\"0$1\"]],\"0\"],\"CF\":[\"236\",\"00\",\"(?:[27]\\\\d{3}|8776)\\\\d{4}\",[8],[[\"(\\\\d{2})(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"[278]\"]]]],\"CG\":[\"242\",\"00\",\"222\\\\d{6}|(?:0\\\\d|80)\\\\d{7}\",[9],[[\"(\\\\d)(\\\\d{4})(\\\\d{4})\",\"$1 $2 $3\",[\"8\"]],[\"(\\\\d{2})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"[02]\"]]]],\"CH\":[\"41\",\"00\",\"8\\\\d{11}|[2-9]\\\\d{8}\",[9,12],[[\"(\\\\d{3})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"8[047]|90\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"[2-79]|81\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{2})(\\\\d{3})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4 $5\",[\"8\"],\"0$1\"]],\"0\"],\"CI\":[\"225\",\"00\",\"[02]\\\\d{9}\",[10],[[\"(\\\\d{2})(\\\\d{2})(\\\\d)(\\\\d{5})\",\"$1 $2 $3 $4\",[\"2\"]],[\"(\\\\d{2})(\\\\d{2})(\\\\d{2})(\\\\d{4})\",\"$1 $2 $3 $4\",[\"0\"]]]],\"CK\":[\"682\",\"00\",\"[2-578]\\\\d{4}\",[5],[[\"(\\\\d{2})(\\\\d{3})\",\"$1 $2\",[\"[2-578]\"]]]],\"CL\":[\"56\",\"(?:0|1(?:1[0-69]|2[02-5]|5[13-58]|69|7[0167]|8[018]))0\",\"12300\\\\d{6}|6\\\\d{9,10}|[2-9]\\\\d{8}\",[9,10,11],[[\"(\\\\d{5})(\\\\d{4})\",\"$1 $2\",[\"219\",\"2196\"],\"($1)\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"44\"]],[\"(\\\\d)(\\\\d{4})(\\\\d{4})\",\"$1 $2 $3\",[\"2[1-36]\"],\"($1)\"],[\"(\\\\d)(\\\\d{4})(\\\\d{4})\",\"$1 $2 $3\",[\"9[2-9]\"]],[\"(\\\\d{2})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"3[2-5]|[47]|5[1-3578]|6[13-57]|8(?:0[1-9]|[1-9])\"],\"($1)\"],[\"(\\\\d{3})(\\\\d{3})(\\\\d{3,4})\",\"$1 $2 $3\",[\"60|8\"]],[\"(\\\\d{4})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"1\"]],[\"(\\\\d{3})(\\\\d{3})(\\\\d{2})(\\\\d{3})\",\"$1 $2 $3 $4\",[\"60\"]]]],\"CM\":[\"237\",\"00\",\"[26]\\\\d{8}|88\\\\d{6,7}\",[8,9],[[\"(\\\\d{2})(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"88\"]],[\"(\\\\d)(\\\\d{2})(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4 $5\",[\"[26]|88\"]]]],\"CN\":[\"86\",\"00|1(?:[12]\\\\d|79)\\\\d\\\\d00\",\"(?:(?:1[03-689]|2\\\\d)\\\\d\\\\d|6)\\\\d{8}|1\\\\d{10}|[126]\\\\d{6}(?:\\\\d(?:\\\\d{2})?)?|86\\\\d{5,6}|(?:[3-579]\\\\d|8[0-57-9])\\\\d{5,9}\",[7,8,9,10,11,12],[[\"(\\\\d{2})(\\\\d{5,6})\",\"$1 $2\",[\"(?:10|2[0-57-9])[19]|3(?:[157]|35|49|9[1-68])|4(?:1[124-9]|2[179]|6[47-9]|7|8[23])|5(?:[1357]|2[37]|4[36]|6[1-46]|80)|6(?:3[1-5]|6[0238]|9[12])|7(?:01|[1579]|2[248]|3[014-9]|4[3-6]|6[023689])|8(?:07|1[236-8]|2[5-7]|[37]|8[36-8]|9[1-8])|9(?:0[1-3689]|1[1-79]|3|4[13]|5[1-5]|7[0-79]|9[0-35-9])|(?:4[35]|59|85)[1-9]\",\"(?:10|2[0-57-9])(?:1[02]|9[56])|8078|(?:3(?:[157]\\\\d|35|49|9[1-68])|4(?:1[124-9]|2[179]|[35][1-9]|6[47-9]|7\\\\d|8[23])|5(?:[1357]\\\\d|2[37]|4[36]|6[1-46]|80|9[1-9])|6(?:3[1-5]|6[0238]|9[12])|7(?:01|[1579]\\\\d|2[248]|3[014-9]|4[3-6]|6[023689])|8(?:1[236-8]|2[5-7]|[37]\\\\d|5[1-9]|8[36-8]|9[1-8])|9(?:0[1-3689]|1[1-79]|3\\\\d|4[13]|5[1-5]|7[0-79]|9[0-35-9]))1\",\"10(?:1(?:0|23)|9[56])|2[0-57-9](?:1(?:00|23)|9[56])|80781|(?:3(?:[157]\\\\d|35|49|9[1-68])|4(?:1[124-9]|2[179]|[35][1-9]|6[47-9]|7\\\\d|8[23])|5(?:[1357]\\\\d|2[37]|4[36]|6[1-46]|80|9[1-9])|6(?:3[1-5]|6[0238]|9[12])|7(?:01|[1579]\\\\d|2[248]|3[014-9]|4[3-6]|6[023689])|8(?:1[236-8]|2[5-7]|[37]\\\\d|5[1-9]|8[36-8]|9[1-8])|9(?:0[1-3689]|1[1-79]|3\\\\d|4[13]|5[1-5]|7[0-79]|9[0-35-9]))12\",\"10(?:1(?:0|23)|9[56])|2[0-57-9](?:1(?:00|23)|9[56])|807812|(?:3(?:[157]\\\\d|35|49|9[1-68])|4(?:1[124-9]|2[179]|[35][1-9]|6[47-9]|7\\\\d|8[23])|5(?:[1357]\\\\d|2[37]|4[36]|6[1-46]|80|9[1-9])|6(?:3[1-5]|6[0238]|9[12])|7(?:01|[1579]\\\\d|2[248]|3[014-9]|4[3-6]|6[023689])|8(?:1[236-8]|2[5-7]|[37]\\\\d|5[1-9]|8[36-8]|9[1-8])|9(?:0[1-3689]|1[1-79]|3\\\\d|4[13]|5[1-5]|7[0-79]|9[0-35-9]))123\",\"10(?:1(?:0|23)|9[56])|2[0-57-9](?:1(?:00|23)|9[56])|(?:3(?:[157]\\\\d|35|49|9[1-68])|4(?:1[124-9]|2[179]|[35][1-9]|6[47-9]|7\\\\d|8[23])|5(?:[1357]\\\\d|2[37]|4[36]|6[1-46]|80|9[1-9])|6(?:3[1-5]|6[0238]|9[12])|7(?:01|[1579]\\\\d|2[248]|3[014-9]|4[3-6]|6[023689])|8(?:078|1[236-8]|2[5-7]|[37]\\\\d|5[1-9]|8[36-8]|9[1-8])|9(?:0[1-3689]|1[1-79]|3\\\\d|4[13]|5[1-5]|7[0-79]|9[0-35-9]))123\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{5,6})\",\"$1 $2\",[\"3(?:[157]|35|49|9[1-68])|4(?:[17]|2[179]|6[47-9]|8[23])|5(?:[1357]|2[37]|4[36]|6[1-46]|80)|6(?:3[1-5]|6[0238]|9[12])|7(?:01|[1579]|2[248]|3[014-9]|4[3-6]|6[023689])|8(?:1[236-8]|2[5-7]|[37]|8[36-8]|9[1-8])|9(?:0[1-3689]|1[1-79]|[379]|4[13]|5[1-5])|(?:4[35]|59|85)[1-9]\",\"(?:3(?:[157]\\\\d|35|49|9[1-68])|4(?:[17]\\\\d|2[179]|[35][1-9]|6[47-9]|8[23])|5(?:[1357]\\\\d|2[37]|4[36]|6[1-46]|80|9[1-9])|6(?:3[1-5]|6[0238]|9[12])|7(?:01|[1579]\\\\d|2[248]|3[014-9]|4[3-6]|6[023689])|8(?:1[236-8]|2[5-7]|[37]\\\\d|5[1-9]|8[36-8]|9[1-8])|9(?:0[1-3689]|1[1-79]|[379]\\\\d|4[13]|5[1-5]))[19]\",\"85[23](?:10|95)|(?:3(?:[157]\\\\d|35|49|9[1-68])|4(?:[17]\\\\d|2[179]|[35][1-9]|6[47-9]|8[23])|5(?:[1357]\\\\d|2[37]|4[36]|6[1-46]|80|9[1-9])|6(?:3[1-5]|6[0238]|9[12])|7(?:01|[1579]\\\\d|2[248]|3[014-9]|4[3-6]|6[023689])|8(?:1[236-8]|2[5-7]|[37]\\\\d|5[14-9]|8[36-8]|9[1-8])|9(?:0[1-3689]|1[1-79]|[379]\\\\d|4[13]|5[1-5]))(?:10|9[56])\",\"85[23](?:100|95)|(?:3(?:[157]\\\\d|35|49|9[1-68])|4(?:[17]\\\\d|2[179]|[35][1-9]|6[47-9]|8[23])|5(?:[1357]\\\\d|2[37]|4[36]|6[1-46]|80|9[1-9])|6(?:3[1-5]|6[0238]|9[12])|7(?:01|[1579]\\\\d|2[248]|3[014-9]|4[3-6]|6[023689])|8(?:1[236-8]|2[5-7]|[37]\\\\d|5[14-9]|8[36-8]|9[1-8])|9(?:0[1-3689]|1[1-79]|[379]\\\\d|4[13]|5[1-5]))(?:100|9[56])\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"(?:4|80)0\"]],[\"(\\\\d{2})(\\\\d{4})(\\\\d{4})\",\"$1 $2 $3\",[\"10|2(?:[02-57-9]|1[1-9])\",\"10|2(?:[02-57-9]|1[1-9])\",\"10[0-79]|2(?:[02-57-9]|1[1-79])|(?:10|21)8(?:0[1-9]|[1-9])\"],\"0$1\",1],[\"(\\\\d{3})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"3(?:[3-59]|7[02-68])|4(?:[26-8]|3[3-9]|5[2-9])|5(?:3[03-9]|[468]|7[028]|9[2-46-9])|6|7(?:[0-247]|3[04-9]|5[0-4689]|6[2368])|8(?:[1-358]|9[1-7])|9(?:[013479]|5[1-5])|(?:[34]1|55|79|87)[02-9]\"],\"0$1\",1],[\"(\\\\d{3})(\\\\d{7,8})\",\"$1 $2\",[\"9\"]],[\"(\\\\d{4})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"80\"],\"0$1\",1],[\"(\\\\d{3})(\\\\d{4})(\\\\d{4})\",\"$1 $2 $3\",[\"[3-578]\"],\"0$1\",1],[\"(\\\\d{3})(\\\\d{4})(\\\\d{4})\",\"$1 $2 $3\",[\"1[3-9]\"]],[\"(\\\\d{2})(\\\\d{3})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3 $4\",[\"[12]\"],\"0$1\",1]],\"0\",0,\"(1(?:[12]\\\\d|79)\\\\d\\\\d)|0\",0,0,0,0,\"00\"],\"CO\":[\"57\",\"00(?:4(?:[14]4|56)|[579])\",\"(?:46|60\\\\d\\\\d)\\\\d{6}|(?:1\\\\d|[39])\\\\d{9}\",[8,10,11],[[\"(\\\\d{4})(\\\\d{4})\",\"$1 $2\",[\"46\"]],[\"(\\\\d{3})(\\\\d{7})\",\"$1 $2\",[\"6|90\"],\"($1)\"],[\"(\\\\d{3})(\\\\d{7})\",\"$1 $2\",[\"3[0-357]|91\"]],[\"(\\\\d)(\\\\d{3})(\\\\d{7})\",\"$1-$2-$3\",[\"1\"],\"0$1\",0,\"$1 $2 $3\"]],\"0\",0,\"0([3579]|4(?:[14]4|56))?\"],\"CR\":[\"506\",\"00\",\"(?:8\\\\d|90)\\\\d{8}|(?:[24-8]\\\\d{3}|3005)\\\\d{4}\",[8,10],[[\"(\\\\d{4})(\\\\d{4})\",\"$1 $2\",[\"[2-7]|8[3-9]\"]],[\"(\\\\d{3})(\\\\d{3})(\\\\d{4})\",\"$1-$2-$3\",[\"[89]\"]]],0,0,\"(19(?:0[0-2468]|1[09]|20|66|77|99))\"],\"CU\":[\"53\",\"119\",\"(?:[2-7]|8\\\\d\\\\d)\\\\d{7}|[2-47]\\\\d{6}|[34]\\\\d{5}\",[6,7,8,10],[[\"(\\\\d{2})(\\\\d{4,6})\",\"$1 $2\",[\"2[1-4]|[34]\"],\"(0$1)\"],[\"(\\\\d)(\\\\d{6,7})\",\"$1 $2\",[\"7\"],\"(0$1)\"],[\"(\\\\d)(\\\\d{7})\",\"$1 $2\",[\"[56]\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{7})\",\"$1 $2\",[\"8\"],\"0$1\"]],\"0\"],\"CV\":[\"238\",\"0\",\"(?:[2-59]\\\\d\\\\d|800)\\\\d{4}\",[7],[[\"(\\\\d{3})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3\",[\"[2-589]\"]]]],\"CW\":[\"599\",\"00\",\"(?:[34]1|60|(?:7|9\\\\d)\\\\d)\\\\d{5}\",[7,8],[[\"(\\\\d{3})(\\\\d{4})\",\"$1 $2\",[\"[3467]\"]],[\"(\\\\d)(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"9[4-8]\"]]],0,0,0,0,0,\"[69]\"],\"CX\":[\"61\",\"001[14-689]|14(?:1[14]|34|4[17]|[56]6|7[47]|88)0011\",\"1(?:[0-79]\\\\d{8}(?:\\\\d{2})?|8[0-24-9]\\\\d{7})|[148]\\\\d{8}|1\\\\d{5,7}\",[6,7,8,9,10,12],0,\"0\",0,\"([59]\\\\d{7})$|0\",\"8$1\",0,0,[[\"8(?:51(?:0(?:01|30|59|88)|1(?:17|46|75)|2(?:22|35))|91(?:00[6-9]|1(?:[28]1|49|78)|2(?:09|63)|3(?:12|26|75)|4(?:56|97)|64\\\\d|7(?:0[01]|1[0-2])|958))\\\\d{3}\",[9]],[\"4(?:79[01]|83[0-389]|94[0-4])\\\\d{5}|4(?:[0-36]\\\\d|4[047-9]|5[0-25-9]|7[02-8]|8[0-24-9]|9[0-37-9])\\\\d{6}\",[9]],[\"180(?:0\\\\d{3}|2)\\\\d{3}\",[7,10]],[\"190[0-26]\\\\d{6}\",[10]],0,0,0,0,[\"14(?:5(?:1[0458]|[23][458])|71\\\\d)\\\\d{4}\",[9]],[\"13(?:00\\\\d{6}(?:\\\\d{2})?|45[0-4]\\\\d{3})|13\\\\d{4}\",[6,8,10,12]]],\"0011\"],\"CY\":[\"357\",\"00\",\"(?:[279]\\\\d|[58]0)\\\\d{6}\",[8],[[\"(\\\\d{2})(\\\\d{6})\",\"$1 $2\",[\"[257-9]\"]]]],\"CZ\":[\"420\",\"00\",\"(?:[2-578]\\\\d|60)\\\\d{7}|9\\\\d{8,11}\",[9,10,11,12],[[\"(\\\\d{3})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"[2-8]|9[015-7]\"]],[\"(\\\\d{2})(\\\\d{3})(\\\\d{3})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"96\"]],[\"(\\\\d{2})(\\\\d{3})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3 $4\",[\"9\"]],[\"(\\\\d{3})(\\\\d{3})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3 $4\",[\"9\"]]]],\"DE\":[\"49\",\"00\",\"[2579]\\\\d{5,14}|49(?:[34]0|69|8\\\\d)\\\\d\\\\d?|49(?:37|49|60|7[089]|9\\\\d)\\\\d{1,3}|49(?:2[024-9]|3[2-689]|7[1-7])\\\\d{1,8}|(?:1|[368]\\\\d|4[0-8])\\\\d{3,13}|49(?:[015]\\\\d|2[13]|31|[46][1-8])\\\\d{1,9}\",[4,5,6,7,8,9,10,11,12,13,14,15],[[\"(\\\\d{2})(\\\\d{3,13})\",\"$1 $2\",[\"3[02]|40|[68]9\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{3,12})\",\"$1 $2\",[\"2(?:0[1-389]|1[124]|2[18]|3[14])|3(?:[35-9][15]|4[015])|906|(?:2[4-9]|4[2-9]|[579][1-9]|[68][1-8])1\",\"2(?:0[1-389]|12[0-8])|3(?:[35-9][15]|4[015])|906|2(?:[13][14]|2[18])|(?:2[4-9]|4[2-9]|[579][1-9]|[68][1-8])1\"],\"0$1\"],[\"(\\\\d{4})(\\\\d{2,11})\",\"$1 $2\",[\"[24-6]|3(?:[3569][02-46-9]|4[2-4679]|7[2-467]|8[2-46-8])|70[2-8]|8(?:0[2-9]|[1-8])|90[7-9]|[79][1-9]\",\"[24-6]|3(?:3(?:0[1-467]|2[127-9]|3[124578]|7[1257-9]|8[1256]|9[145])|4(?:2[135]|4[13578]|9[1346])|5(?:0[14]|2[1-3589]|6[1-4]|7[13468]|8[13568])|6(?:2[1-489]|3[124-6]|6[13]|7[12579]|8[1-356]|9[135])|7(?:2[1-7]|4[145]|6[1-5]|7[1-4])|8(?:21|3[1468]|6|7[1467]|8[136])|9(?:0[12479]|2[1358]|4[134679]|6[1-9]|7[136]|8[147]|9[1468]))|70[2-8]|8(?:0[2-9]|[1-8])|90[7-9]|[79][1-9]|3[68]4[1347]|3(?:47|60)[1356]|3(?:3[46]|46|5[49])[1246]|3[4579]3[1357]\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{4})\",\"$1 $2\",[\"138\"],\"0$1\"],[\"(\\\\d{5})(\\\\d{2,10})\",\"$1 $2\",[\"3\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{5,11})\",\"$1 $2\",[\"181\"],\"0$1\"],[\"(\\\\d{3})(\\\\d)(\\\\d{4,10})\",\"$1 $2 $3\",[\"1(?:3|80)|9\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{7,8})\",\"$1 $2\",[\"1[67]\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{7,12})\",\"$1 $2\",[\"8\"],\"0$1\"],[\"(\\\\d{5})(\\\\d{6})\",\"$1 $2\",[\"185\",\"1850\",\"18500\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{4})(\\\\d{4})\",\"$1 $2 $3\",[\"7\"],\"0$1\"],[\"(\\\\d{4})(\\\\d{7})\",\"$1 $2\",[\"18[68]\"],\"0$1\"],[\"(\\\\d{4})(\\\\d{7})\",\"$1 $2\",[\"15[1279]\"],\"0$1\"],[\"(\\\\d{5})(\\\\d{6})\",\"$1 $2\",[\"15[03568]\",\"15(?:[0568]|31)\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{8})\",\"$1 $2\",[\"18\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{2})(\\\\d{7,8})\",\"$1 $2 $3\",[\"1(?:6[023]|7)\"],\"0$1\"],[\"(\\\\d{4})(\\\\d{2})(\\\\d{7})\",\"$1 $2 $3\",[\"15[279]\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{2})(\\\\d{8})\",\"$1 $2 $3\",[\"15\"],\"0$1\"]],\"0\"],\"DJ\":[\"253\",\"00\",\"(?:2\\\\d|77)\\\\d{6}\",[8],[[\"(\\\\d{2})(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"[27]\"]]]],\"DK\":[\"45\",\"00\",\"[2-9]\\\\d{7}\",[8],[[\"(\\\\d{2})(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"[2-9]\"]]]],\"DM\":[\"1\",\"011\",\"(?:[58]\\\\d\\\\d|767|900)\\\\d{7}\",[10],0,\"1\",0,\"([2-7]\\\\d{6})$|1\",\"767$1\",0,\"767\"],\"DO\":[\"1\",\"011\",\"(?:[58]\\\\d\\\\d|900)\\\\d{7}\",[10],0,\"1\",0,0,0,0,\"8001|8[024]9\"],\"DZ\":[\"213\",\"00\",\"(?:[1-4]|[5-79]\\\\d|80)\\\\d{7}\",[8,9],[[\"(\\\\d{2})(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"[1-4]\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"9\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"[5-8]\"],\"0$1\"]],\"0\"],\"EC\":[\"593\",\"00\",\"1\\\\d{9,10}|(?:[2-7]|9\\\\d)\\\\d{7}\",[8,9,10,11],[[\"(\\\\d)(\\\\d{3})(\\\\d{4})\",\"$1 $2-$3\",[\"[2-7]\"],\"(0$1)\",0,\"$1-$2-$3\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"9\"],\"0$1\"],[\"(\\\\d{4})(\\\\d{3})(\\\\d{3,4})\",\"$1 $2 $3\",[\"1\"]]],\"0\"],\"EE\":[\"372\",\"00\",\"8\\\\d{9}|[4578]\\\\d{7}|(?:[3-8]\\\\d|90)\\\\d{5}\",[7,8,10],[[\"(\\\\d{3})(\\\\d{4})\",\"$1 $2\",[\"[369]|4[3-8]|5(?:[0-2]|5[0-478]|6[45])|7[1-9]|88\",\"[369]|4[3-8]|5(?:[02]|1(?:[0-8]|95)|5[0-478]|6(?:4[0-4]|5[1-589]))|7[1-9]|88\"]],[\"(\\\\d{4})(\\\\d{3,4})\",\"$1 $2\",[\"[45]|8(?:00|[1-49])\",\"[45]|8(?:00[1-9]|[1-49])\"]],[\"(\\\\d{2})(\\\\d{2})(\\\\d{4})\",\"$1 $2 $3\",[\"7\"]],[\"(\\\\d{4})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"8\"]]]],\"EG\":[\"20\",\"00\",\"[189]\\\\d{8,9}|[24-6]\\\\d{8}|[135]\\\\d{7}\",[8,9,10],[[\"(\\\\d)(\\\\d{7,8})\",\"$1 $2\",[\"[23]\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{6,7})\",\"$1 $2\",[\"1[35]|[4-6]|8[2468]|9[235-7]\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"[89]\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{8})\",\"$1 $2\",[\"1\"],\"0$1\"]],\"0\"],\"EH\":[\"212\",\"00\",\"[5-8]\\\\d{8}\",[9],0,\"0\",0,0,0,0,\"528[89]\"],\"ER\":[\"291\",\"00\",\"[178]\\\\d{6}\",[7],[[\"(\\\\d)(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"[178]\"],\"0$1\"]],\"0\"],\"ES\":[\"34\",\"00\",\"[5-9]\\\\d{8}\",[9],[[\"(\\\\d{3})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"[89]00\"]],[\"(\\\\d{3})(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"[5-9]\"]]]],\"ET\":[\"251\",\"00\",\"(?:11|[2-579]\\\\d)\\\\d{7}\",[9],[[\"(\\\\d{2})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"[1-579]\"],\"0$1\"]],\"0\"],\"FI\":[\"358\",\"00|99(?:[01469]|5(?:[14]1|3[23]|5[59]|77|88|9[09]))\",\"[1-35689]\\\\d{4}|7\\\\d{10,11}|(?:[124-7]\\\\d|3[0-46-9])\\\\d{8}|[1-9]\\\\d{5,8}\",[5,6,7,8,9,10,11,12],[[\"(\\\\d{5})\",\"$1\",[\"20[2-59]\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{3,7})\",\"$1 $2\",[\"(?:[1-3]0|[68])0|70[07-9]\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{4,8})\",\"$1 $2\",[\"[14]|2[09]|50|7[135]\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{6,10})\",\"$1 $2\",[\"7\"],\"0$1\"],[\"(\\\\d)(\\\\d{4,9})\",\"$1 $2\",[\"(?:19|[2568])[1-8]|3(?:0[1-9]|[1-9])|9\"],\"0$1\"]],\"0\",0,0,0,0,\"1[03-79]|[2-9]\",0,\"00\"],\"FJ\":[\"679\",\"0(?:0|52)\",\"45\\\\d{5}|(?:0800\\\\d|[235-9])\\\\d{6}\",[7,11],[[\"(\\\\d{3})(\\\\d{4})\",\"$1 $2\",[\"[235-9]|45\"]],[\"(\\\\d{4})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"0\"]]],0,0,0,0,0,0,0,\"00\"],\"FK\":[\"500\",\"00\",\"[2-7]\\\\d{4}\",[5]],\"FM\":[\"691\",\"00\",\"(?:[39]\\\\d\\\\d|820)\\\\d{4}\",[7],[[\"(\\\\d{3})(\\\\d{4})\",\"$1 $2\",[\"[389]\"]]]],\"FO\":[\"298\",\"00\",\"[2-9]\\\\d{5}\",[6],[[\"(\\\\d{6})\",\"$1\",[\"[2-9]\"]]],0,0,\"(10(?:01|[12]0|88))\"],\"FR\":[\"33\",\"00\",\"[1-9]\\\\d{8}\",[9],[[\"(\\\\d{3})(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"8\"],\"0 $1\"],[\"(\\\\d)(\\\\d{2})(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4 $5\",[\"[1-79]\"],\"0$1\"]],\"0\"],\"GA\":[\"241\",\"00\",\"(?:[067]\\\\d|11)\\\\d{6}|[2-7]\\\\d{6}\",[7,8],[[\"(\\\\d)(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"[2-7]\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"0\"]],[\"(\\\\d{2})(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"11|[67]\"],\"0$1\"]],0,0,\"0(11\\\\d{6}|60\\\\d{6}|61\\\\d{6}|6[256]\\\\d{6}|7[467]\\\\d{6})\",\"$1\"],\"GB\":[\"44\",\"00\",\"[1-357-9]\\\\d{9}|[18]\\\\d{8}|8\\\\d{6}\",[7,9,10],[[\"(\\\\d{3})(\\\\d{4})\",\"$1 $2\",[\"800\",\"8001\",\"80011\",\"800111\",\"8001111\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3\",[\"845\",\"8454\",\"84546\",\"845464\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{6})\",\"$1 $2\",[\"800\"],\"0$1\"],[\"(\\\\d{5})(\\\\d{4,5})\",\"$1 $2\",[\"1(?:38|5[23]|69|76|94)\",\"1(?:(?:38|69)7|5(?:24|39)|768|946)\",\"1(?:3873|5(?:242|39[4-6])|(?:697|768)[347]|9467)\"],\"0$1\"],[\"(\\\\d{4})(\\\\d{5,6})\",\"$1 $2\",[\"1(?:[2-69][02-9]|[78])\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{4})(\\\\d{4})\",\"$1 $2 $3\",[\"[25]|7(?:0|6[02-9])\",\"[25]|7(?:0|6(?:[03-9]|2[356]))\"],\"0$1\"],[\"(\\\\d{4})(\\\\d{6})\",\"$1 $2\",[\"7\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"[1389]\"],\"0$1\"]],\"0\",0,0,0,0,0,[[\"(?:1(?:1(?:3(?:[0-58]\\\\d\\\\d|73[0-35])|4(?:(?:[0-5]\\\\d|70)\\\\d|69[7-9])|(?:(?:5[0-26-9]|[78][0-49])\\\\d|6(?:[0-4]\\\\d|50))\\\\d)|(?:2(?:(?:0[024-9]|2[3-9]|3[3-79]|4[1-689]|[58][02-9]|6[0-47-9]|7[013-9]|9\\\\d)\\\\d|1(?:[0-7]\\\\d|8[0-3]))|(?:3(?:0\\\\d|1[0-8]|[25][02-9]|3[02-579]|[468][0-46-9]|7[1-35-79]|9[2-578])|4(?:0[03-9]|[137]\\\\d|[28][02-57-9]|4[02-69]|5[0-8]|[69][0-79])|5(?:0[1-35-9]|[16]\\\\d|2[024-9]|3[015689]|4[02-9]|5[03-9]|7[0-35-9]|8[0-468]|9[0-57-9])|6(?:0[034689]|1\\\\d|2[0-35689]|[38][013-9]|4[1-467]|5[0-69]|6[13-9]|7[0-8]|9[0-24578])|7(?:0[0246-9]|2\\\\d|3[0236-8]|4[03-9]|5[0-46-9]|6[013-9]|7[0-35-9]|8[024-9]|9[02-9])|8(?:0[35-9]|2[1-57-9]|3[02-578]|4[0-578]|5[124-9]|6[2-69]|7\\\\d|8[02-9]|9[02569])|9(?:0[02-589]|[18]\\\\d|2[02-689]|3[1-57-9]|4[2-9]|5[0-579]|6[2-47-9]|7[0-24578]|9[2-57]))\\\\d)\\\\d)|2(?:0[013478]|3[0189]|4[017]|8[0-46-9]|9[0-2])\\\\d{3})\\\\d{4}|1(?:2(?:0(?:46[1-4]|87[2-9])|545[1-79]|76(?:2\\\\d|3[1-8]|6[1-6])|9(?:7(?:2[0-4]|3[2-5])|8(?:2[2-8]|7[0-47-9]|8[3-5])))|3(?:6(?:38[2-5]|47[23])|8(?:47[04-9]|64[0157-9]))|4(?:044[1-7]|20(?:2[23]|8\\\\d)|6(?:0(?:30|5[2-57]|6[1-8]|7[2-8])|140)|8(?:052|87[1-3]))|5(?:2(?:4(?:3[2-79]|6\\\\d)|76\\\\d)|6(?:26[06-9]|686))|6(?:06(?:4\\\\d|7[4-79])|295[5-7]|35[34]\\\\d|47(?:24|61)|59(?:5[08]|6[67]|74)|9(?:55[0-4]|77[23]))|7(?:26(?:6[13-9]|7[0-7])|(?:442|688)\\\\d|50(?:2[0-3]|[3-68]2|76))|8(?:27[56]\\\\d|37(?:5[2-5]|8[239])|843[2-58])|9(?:0(?:0(?:6[1-8]|85)|52\\\\d)|3583|4(?:66[1-8]|9(?:2[01]|81))|63(?:23|3[1-4])|9561))\\\\d{3}\",[9,10]],[\"7(?:457[0-57-9]|700[01]|911[028])\\\\d{5}|7(?:[1-3]\\\\d\\\\d|4(?:[0-46-9]\\\\d|5[0-689])|5(?:0[0-8]|[13-9]\\\\d|2[0-35-9])|7(?:0[1-9]|[1-7]\\\\d|8[02-9]|9[0-689])|8(?:[014-9]\\\\d|[23][0-8])|9(?:[024-9]\\\\d|1[02-9]|3[0-689]))\\\\d{6}\",[10]],[\"80[08]\\\\d{7}|800\\\\d{6}|8001111\"],[\"(?:8(?:4[2-5]|7[0-3])|9(?:[01]\\\\d|8[2-49]))\\\\d{7}|845464\\\\d\",[7,10]],[\"70\\\\d{8}\",[10]],0,[\"(?:3[0347]|55)\\\\d{8}\",[10]],[\"76(?:464|652)\\\\d{5}|76(?:0[0-28]|2[356]|34|4[01347]|5[49]|6[0-369]|77|8[14]|9[139])\\\\d{6}\",[10]],[\"56\\\\d{8}\",[10]]],0,\" x\"],\"GD\":[\"1\",\"011\",\"(?:473|[58]\\\\d\\\\d|900)\\\\d{7}\",[10],0,\"1\",0,\"([2-9]\\\\d{6})$|1\",\"473$1\",0,\"473\"],\"GE\":[\"995\",\"00\",\"(?:[3-57]\\\\d\\\\d|800)\\\\d{6}\",[9],[[\"(\\\\d{3})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"70\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"32\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"[57]\"]],[\"(\\\\d{3})(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"[348]\"],\"0$1\"]],\"0\"],\"GF\":[\"594\",\"00\",\"(?:[56]94\\\\d|7093)\\\\d{5}|(?:80|9\\\\d)\\\\d{7}\",[9],[[\"(\\\\d{3})(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"[5-7]|9[47]\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"[89]\"],\"0$1\"]],\"0\"],\"GG\":[\"44\",\"00\",\"(?:1481|[357-9]\\\\d{3})\\\\d{6}|8\\\\d{6}(?:\\\\d{2})?\",[7,9,10],0,\"0\",0,\"([25-9]\\\\d{5})$|0\",\"1481$1\",0,0,[[\"1481[25-9]\\\\d{5}\",[10]],[\"7(?:(?:781|839)\\\\d|911[17])\\\\d{5}\",[10]],[\"80[08]\\\\d{7}|800\\\\d{6}|8001111\"],[\"(?:8(?:4[2-5]|7[0-3])|9(?:[01]\\\\d|8[0-3]))\\\\d{7}|845464\\\\d\",[7,10]],[\"70\\\\d{8}\",[10]],0,[\"(?:3[0347]|55)\\\\d{8}\",[10]],[\"76(?:464|652)\\\\d{5}|76(?:0[0-28]|2[356]|34|4[01347]|5[49]|6[0-369]|77|8[14]|9[139])\\\\d{6}\",[10]],[\"56\\\\d{8}\",[10]]]],\"GH\":[\"233\",\"00\",\"(?:[235]\\\\d{3}|800)\\\\d{5}\",[8,9],[[\"(\\\\d{3})(\\\\d{5})\",\"$1 $2\",[\"8\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"[235]\"],\"0$1\"]],\"0\"],\"GI\":[\"350\",\"00\",\"(?:[25]\\\\d|60)\\\\d{6}\",[8],[[\"(\\\\d{3})(\\\\d{5})\",\"$1 $2\",[\"2\"]]]],\"GL\":[\"299\",\"00\",\"(?:19|[2-689]\\\\d|70)\\\\d{4}\",[6],[[\"(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3\",[\"19|[2-9]\"]]]],\"GM\":[\"220\",\"00\",\"[2-9]\\\\d{6}\",[7],[[\"(\\\\d{3})(\\\\d{4})\",\"$1 $2\",[\"[2-9]\"]]]],\"GN\":[\"224\",\"00\",\"722\\\\d{6}|(?:3|6\\\\d)\\\\d{7}\",[8,9],[[\"(\\\\d{2})(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"3\"]],[\"(\\\\d{3})(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"[67]\"]]]],\"GP\":[\"590\",\"00\",\"(?:590\\\\d|7090)\\\\d{5}|(?:69|80|9\\\\d)\\\\d{7}\",[9],[[\"(\\\\d{3})(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"[5-79]\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"8\"],\"0$1\"]],\"0\",0,0,0,0,0,[[\"590(?:0[1-68]|[14][0-24-9]|2[0-68]|3[1-9]|5[3-579]|[68][0-689]|7[08]|9\\\\d)\\\\d{4}\"],[\"(?:69(?:0\\\\d\\\\d|1(?:2[2-9]|3[0-5])|4(?:0[89]|1[2-6]|9\\\\d)|6(?:1[016-9]|5[0-4]|[67]\\\\d))|7090[0-4])\\\\d{4}\"],[\"80[0-5]\\\\d{6}\"],0,0,0,0,0,[\"9(?:(?:39[5-7]|76[018])\\\\d|475[0-6])\\\\d{4}\"]]],\"GQ\":[\"240\",\"00\",\"222\\\\d{6}|(?:3\\\\d|55|[89]0)\\\\d{7}\",[9],[[\"(\\\\d{3})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"[235]\"]],[\"(\\\\d{3})(\\\\d{6})\",\"$1 $2\",[\"[89]\"]]]],\"GR\":[\"30\",\"00\",\"5005000\\\\d{3}|8\\\\d{9,11}|(?:[269]\\\\d|70)\\\\d{8}\",[10,11,12],[[\"(\\\\d{2})(\\\\d{4})(\\\\d{4})\",\"$1 $2 $3\",[\"21|7\"]],[\"(\\\\d{4})(\\\\d{6})\",\"$1 $2\",[\"2(?:2|3[2-57-9]|4[2-469]|5[2-59]|6[2-9]|7[2-69]|8[2-49])|5\"]],[\"(\\\\d{3})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"[2689]\"]],[\"(\\\\d{3})(\\\\d{3,4})(\\\\d{5})\",\"$1 $2 $3\",[\"8\"]]]],\"GT\":[\"502\",\"00\",\"80\\\\d{6}|(?:1\\\\d{3}|[2-7])\\\\d{7}\",[8,11],[[\"(\\\\d{4})(\\\\d{4})\",\"$1 $2\",[\"[2-8]\"]],[\"(\\\\d{4})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"1\"]]]],\"GU\":[\"1\",\"011\",\"(?:[58]\\\\d\\\\d|671|900)\\\\d{7}\",[10],0,\"1\",0,\"([2-9]\\\\d{6})$|1\",\"671$1\",0,\"671\"],\"GW\":[\"245\",\"00\",\"[49]\\\\d{8}|4\\\\d{6}\",[7,9],[[\"(\\\\d{3})(\\\\d{4})\",\"$1 $2\",[\"40\"]],[\"(\\\\d{3})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"[49]\"]]]],\"GY\":[\"592\",\"001\",\"(?:[2-8]\\\\d{3}|9008)\\\\d{3}\",[7],[[\"(\\\\d{3})(\\\\d{4})\",\"$1 $2\",[\"[2-9]\"]]]],\"HK\":[\"852\",\"00(?:30|5[09]|[126-9]?)\",\"8[0-46-9]\\\\d{6,7}|9\\\\d{4,7}|(?:[2-7]|9\\\\d{3})\\\\d{7}\",[5,6,7,8,9,11],[[\"(\\\\d{3})(\\\\d{2,5})\",\"$1 $2\",[\"900\",\"9003\"]],[\"(\\\\d{4})(\\\\d{4})\",\"$1 $2\",[\"[2-7]|8[1-4]|9(?:0[1-9]|[1-8])\"]],[\"(\\\\d{3})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"8\"]],[\"(\\\\d{3})(\\\\d{2})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3 $4\",[\"9\"]]],0,0,0,0,0,0,0,\"00\"],\"HN\":[\"504\",\"00\",\"8\\\\d{10}|[237-9]\\\\d{7}\",[8,11],[[\"(\\\\d{4})(\\\\d{4})\",\"$1-$2\",[\"[237-9]\"]]]],\"HR\":[\"385\",\"00\",\"[2-69]\\\\d{8}|80\\\\d{5,7}|[1-79]\\\\d{7}|6\\\\d{6}\",[7,8,9],[[\"(\\\\d{2})(\\\\d{2})(\\\\d{3})\",\"$1 $2 $3\",[\"6[01]\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{2})(\\\\d{2,3})\",\"$1 $2 $3\",[\"8\"],\"0$1\"],[\"(\\\\d)(\\\\d{4})(\\\\d{3})\",\"$1 $2 $3\",[\"1\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{3,4})\",\"$1 $2 $3\",[\"6|7[245]\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{3,4})\",\"$1 $2 $3\",[\"9\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{3,4})\",\"$1 $2 $3\",[\"[2-57]\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"8\"],\"0$1\"]],\"0\"],\"HT\":[\"509\",\"00\",\"(?:[2-489]\\\\d|55)\\\\d{6}\",[8],[[\"(\\\\d{2})(\\\\d{2})(\\\\d{4})\",\"$1 $2 $3\",[\"[2-589]\"]]]],\"HU\":[\"36\",\"00\",\"[235-7]\\\\d{8}|[1-9]\\\\d{7}\",[8,9],[[\"(\\\\d)(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"1\"],\"(06 $1)\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"[27][2-9]|3[2-7]|4[24-9]|5[2-79]|6|8[2-57-9]|9[2-69]\"],\"(06 $1)\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{3,4})\",\"$1 $2 $3\",[\"[2-9]\"],\"06 $1\"]],\"06\"],\"ID\":[\"62\",\"00[89]\",\"00[1-9]\\\\d{9,14}|(?:[1-36]|8\\\\d{5})\\\\d{6}|00\\\\d{9}|[1-9]\\\\d{8,10}|[2-9]\\\\d{7}\",[7,8,9,10,11,12,13,14,15,16,17],[[\"(\\\\d)(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"15\"]],[\"(\\\\d{2})(\\\\d{5,9})\",\"$1 $2\",[\"2[124]|[36]1\"],\"(0$1)\"],[\"(\\\\d{3})(\\\\d{5,7})\",\"$1 $2\",[\"800\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{5,8})\",\"$1 $2\",[\"[2-79]\"],\"(0$1)\"],[\"(\\\\d{3})(\\\\d{3,4})(\\\\d{3})\",\"$1-$2-$3\",[\"8[1-35-9]\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{6,8})\",\"$1 $2\",[\"1\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"804\"],\"0$1\"],[\"(\\\\d{3})(\\\\d)(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3 $4\",[\"80\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{4})(\\\\d{4,5})\",\"$1-$2-$3\",[\"8\"],\"0$1\"]],\"0\"],\"IE\":[\"353\",\"00\",\"(?:1\\\\d|[2569])\\\\d{6,8}|4\\\\d{6,9}|7\\\\d{8}|8\\\\d{8,9}\",[7,8,9,10],[[\"(\\\\d{2})(\\\\d{5})\",\"$1 $2\",[\"2[24-9]|47|58|6[237-9]|9[35-9]\"],\"(0$1)\"],[\"(\\\\d{3})(\\\\d{5})\",\"$1 $2\",[\"[45]0\"],\"(0$1)\"],[\"(\\\\d)(\\\\d{3,4})(\\\\d{4})\",\"$1 $2 $3\",[\"1\"],\"(0$1)\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{3,4})\",\"$1 $2 $3\",[\"[2569]|4[1-69]|7[14]\"],\"(0$1)\"],[\"(\\\\d{3})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"70\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"81\"],\"(0$1)\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"[78]\"],\"0$1\"],[\"(\\\\d{4})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"1\"]],[\"(\\\\d{2})(\\\\d{4})(\\\\d{4})\",\"$1 $2 $3\",[\"4\"],\"(0$1)\"],[\"(\\\\d{2})(\\\\d)(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3 $4\",[\"8\"],\"0$1\"]],\"0\"],\"IL\":[\"972\",\"0(?:0|1[2-9])\",\"1\\\\d{6}(?:\\\\d{3,5})?|[57]\\\\d{8}|[1-489]\\\\d{7}\",[7,8,9,10,11,12],[[\"(\\\\d{4})(\\\\d{3})\",\"$1-$2\",[\"125\"]],[\"(\\\\d{4})(\\\\d{2})(\\\\d{2})\",\"$1-$2-$3\",[\"121\"]],[\"(\\\\d)(\\\\d{3})(\\\\d{4})\",\"$1-$2-$3\",[\"[2-489]\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{4})\",\"$1-$2-$3\",[\"[57]\"],\"0$1\"],[\"(\\\\d{4})(\\\\d{3})(\\\\d{3})\",\"$1-$2-$3\",[\"12\"]],[\"(\\\\d{4})(\\\\d{6})\",\"$1-$2\",[\"159\"]],[\"(\\\\d)(\\\\d{3})(\\\\d{3})(\\\\d{3})\",\"$1-$2-$3-$4\",[\"1[7-9]\"]],[\"(\\\\d{3})(\\\\d{1,2})(\\\\d{3})(\\\\d{4})\",\"$1-$2 $3-$4\",[\"15\"]]],\"0\"],\"IM\":[\"44\",\"00\",\"1624\\\\d{6}|(?:[3578]\\\\d|90)\\\\d{8}\",[10],0,\"0\",0,\"([25-8]\\\\d{5})$|0\",\"1624$1\",0,\"74576|(?:16|7[56])24\"],\"IN\":[\"91\",\"00\",\"(?:000800|[2-9]\\\\d\\\\d)\\\\d{7}|1\\\\d{7,12}\",[8,9,10,11,12,13],[[\"(\\\\d{8})\",\"$1\",[\"5(?:0|2[23]|3[03]|[67]1|88)\",\"5(?:0|2(?:21|3)|3(?:0|3[23])|616|717|888)\",\"5(?:0|2(?:21|3)|3(?:0|3[23])|616|717|8888)\"],0,1],[\"(\\\\d{4})(\\\\d{4,5})\",\"$1 $2\",[\"180\",\"1800\"],0,1],[\"(\\\\d{3})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"140\"],0,1],[\"(\\\\d{2})(\\\\d{4})(\\\\d{4})\",\"$1 $2 $3\",[\"11|2[02]|33|4[04]|79[1-7]|80[2-46]\",\"11|2[02]|33|4[04]|79(?:[1-6]|7[19])|80(?:[2-4]|6[0-589])\",\"11|2[02]|33|4[04]|79(?:[124-6]|3(?:[02-9]|1[0-24-9])|7(?:1|9[1-6]))|80(?:[2-4]|6[0-589])\"],\"0$1\",1],[\"(\\\\d{3})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"1(?:2[0-249]|3[0-25]|4[145]|[68]|7[1257])|2(?:1[257]|3[013]|4[01]|5[0137]|6[0158]|78|8[1568])|3(?:26|4[1-3]|5[34]|6[01489]|7[02-46]|8[159])|4(?:1[36]|2[1-47]|5[12]|6[0-26-9]|7[0-24-9]|8[013-57]|9[014-7])|5(?:1[025]|22|[36][25]|4[28]|5[12]|[78]1)|6(?:12|[2-4]1|5[17]|6[13]|80)|7(?:12|3[134]|4[47]|61|88)|8(?:16|2[014]|3[126]|6[136]|7[078]|8[34]|91)|(?:43|59|75)[15]|(?:1[59]|29|67|72)[14]\",\"1(?:2[0-24]|3[0-25]|4[145]|[59][14]|6[1-9]|7[1257]|8[1-57-9])|2(?:1[257]|3[013]|4[01]|5[0137]|6[058]|78|8[1568]|9[14])|3(?:26|4[1-3]|5[34]|6[01489]|7[02-46]|8[159])|4(?:1[36]|2[1-47]|3[15]|5[12]|6[0-26-9]|7[0-24-9]|8[013-57]|9[014-7])|5(?:1[025]|22|[36][25]|4[28]|[578]1|9[15])|674|7(?:(?:2[14]|3[34]|5[15])[2-6]|61[346]|88[0-8])|8(?:70[2-6]|84[235-7]|91[3-7])|(?:1(?:29|60|8[06])|261|552|6(?:12|[2-47]1|5[17]|6[13]|80)|7(?:12|31|4[47])|8(?:16|2[014]|3[126]|6[136]|7[78]|83))[2-7]\",\"1(?:2[0-24]|3[0-25]|4[145]|[59][14]|6[1-9]|7[1257]|8[1-57-9])|2(?:1[257]|3[013]|4[01]|5[0137]|6[058]|78|8[1568]|9[14])|3(?:26|4[1-3]|5[34]|6[01489]|7[02-46]|8[159])|4(?:1[36]|2[1-47]|3[15]|5[12]|6[0-26-9]|7[0-24-9]|8[013-57]|9[014-7])|5(?:1[025]|22|[36][25]|4[28]|[578]1|9[15])|6(?:12(?:[2-6]|7[0-8])|74[2-7])|7(?:(?:2[14]|5[15])[2-6]|3171|61[346]|88(?:[2-7]|82))|8(?:70[2-6]|84(?:[2356]|7[19])|91(?:[3-6]|7[19]))|73[134][2-6]|(?:74[47]|8(?:16|2[014]|3[126]|6[136]|7[78]|83))(?:[2-6]|7[19])|(?:1(?:29|60|8[06])|261|552|6(?:[2-4]1|5[17]|6[13]|7(?:1|4[0189])|80)|7(?:12|88[01]))[2-7]\"],\"0$1\",1],[\"(\\\\d{4})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"1(?:[2-479]|5[0235-9])|[2-5]|6(?:1[1358]|2[2457-9]|3[2-5]|4[235-7]|5[2-689]|6[24578]|7[235689]|8[1-6])|7(?:1[013-9]|28|3[129]|4[1-35689]|5[29]|6[02-5]|70)|807\",\"1(?:[2-479]|5[0235-9])|[2-5]|6(?:1[1358]|2(?:[2457]|84|95)|3(?:[2-4]|55)|4[235-7]|5[2-689]|6[24578]|7[235689]|8[1-6])|7(?:1(?:[013-8]|9[6-9])|28[6-8]|3(?:17|2[0-49]|9[2-57])|4(?:1[2-4]|[29][0-7]|3[0-8]|[56]|8[0-24-7])|5(?:2[1-3]|9[0-6])|6(?:0[5689]|2[5-9]|3[02-8]|4|5[0-367])|70[13-7])|807[19]\",\"1(?:[2-479]|5(?:[0236-9]|5[013-9]))|[2-5]|6(?:2(?:84|95)|355|83)|73179|807(?:1|9[1-3])|(?:1552|6(?:1[1358]|2[2457]|3[2-4]|4[235-7]|5[2-689]|6[24578]|7[235689]|8[124-6])\\\\d|7(?:1(?:[013-8]\\\\d|9[6-9])|28[6-8]|3(?:2[0-49]|9[2-57])|4(?:1[2-4]|[29][0-7]|3[0-8]|[56]\\\\d|8[0-24-7])|5(?:2[1-3]|9[0-6])|6(?:0[5689]|2[5-9]|3[02-8]|4\\\\d|5[0-367])|70[13-7]))[2-7]\"],\"0$1\",1],[\"(\\\\d{5})(\\\\d{5})\",\"$1 $2\",[\"[6-9]\"],\"0$1\",1],[\"(\\\\d{4})(\\\\d{2,4})(\\\\d{4})\",\"$1 $2 $3\",[\"1(?:6|8[06])\",\"1(?:6|8[06]0)\"],0,1],[\"(\\\\d{4})(\\\\d{3})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3 $4\",[\"18\"],0,1]],\"0\"],\"IO\":[\"246\",\"00\",\"3\\\\d{6}\",[7],[[\"(\\\\d{3})(\\\\d{4})\",\"$1 $2\",[\"3\"]]]],\"IQ\":[\"964\",\"00\",\"(?:1|7\\\\d\\\\d)\\\\d{7}|[2-6]\\\\d{7,8}\",[8,9,10],[[\"(\\\\d)(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"1\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{3,4})\",\"$1 $2 $3\",[\"[2-6]\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"7\"],\"0$1\"]],\"0\"],\"IR\":[\"98\",\"00\",\"[1-9]\\\\d{9}|(?:[1-8]\\\\d\\\\d|9)\\\\d{3,4}\",[4,5,6,7,10],[[\"(\\\\d{4,5})\",\"$1\",[\"96\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{4,5})\",\"$1 $2\",[\"(?:1[137]|2[13-68]|3[1458]|4[145]|5[1468]|6[16]|7[1467]|8[13467])[12689]\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{3})(\\\\d{3,4})\",\"$1 $2 $3\",[\"9\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{4})(\\\\d{4})\",\"$1 $2 $3\",[\"[1-8]\"],\"0$1\"]],\"0\"],\"IS\":[\"354\",\"00|1(?:0(?:01|[12]0)|100)\",\"(?:38\\\\d|[4-9])\\\\d{6}\",[7,9],[[\"(\\\\d{3})(\\\\d{4})\",\"$1 $2\",[\"[4-9]\"]],[\"(\\\\d{3})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"3\"]]],0,0,0,0,0,0,0,\"00\"],\"IT\":[\"39\",\"00\",\"0\\\\d{5,10}|1\\\\d{8,10}|3(?:[0-8]\\\\d{7,10}|9\\\\d{7,8})|(?:43|55|70)\\\\d{8}|8\\\\d{5}(?:\\\\d{2,4})?\",[6,7,8,9,10,11,12],[[\"(\\\\d{2})(\\\\d{4,6})\",\"$1 $2\",[\"0[26]\"]],[\"(\\\\d{3})(\\\\d{3,6})\",\"$1 $2\",[\"0[13-57-9][0159]|8(?:03|4[17]|9[2-5])\",\"0[13-57-9][0159]|8(?:03|4[17]|9(?:2|3[04]|[45][0-4]))\"]],[\"(\\\\d{4})(\\\\d{2,6})\",\"$1 $2\",[\"0(?:[13-579][2-46-8]|8[236-8])\"]],[\"(\\\\d{4})(\\\\d{4})\",\"$1 $2\",[\"894\"]],[\"(\\\\d{2})(\\\\d{3,4})(\\\\d{4})\",\"$1 $2 $3\",[\"0[26]|5\"]],[\"(\\\\d{3})(\\\\d{3})(\\\\d{3,4})\",\"$1 $2 $3\",[\"1(?:44|[679])|[378]|43\"]],[\"(\\\\d{3})(\\\\d{3,4})(\\\\d{4})\",\"$1 $2 $3\",[\"0[13-57-9][0159]|14\"]],[\"(\\\\d{2})(\\\\d{4})(\\\\d{5})\",\"$1 $2 $3\",[\"0[26]\"]],[\"(\\\\d{4})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"0\"]],[\"(\\\\d{3})(\\\\d{4})(\\\\d{4,5})\",\"$1 $2 $3\",[\"3\"]]],0,0,0,0,0,0,[[\"0669[0-79]\\\\d{1,6}|0(?:1(?:[0159]\\\\d|[27][1-5]|31|4[1-4]|6[1356]|8[2-57])|2\\\\d\\\\d|3(?:[0159]\\\\d|2[1-4]|3[12]|[48][1-6]|6[2-59]|7[1-7])|4(?:[0159]\\\\d|[23][1-9]|4[245]|6[1-5]|7[1-4]|81)|5(?:[0159]\\\\d|2[1-5]|3[2-6]|4[1-79]|6[4-6]|7[1-578]|8[3-8])|6(?:[0-57-9]\\\\d|6[0-8])|7(?:[0159]\\\\d|2[12]|3[1-7]|4[2-46]|6[13569]|7[13-6]|8[1-59])|8(?:[0159]\\\\d|2[3-578]|3[1-356]|[6-8][1-5])|9(?:[0159]\\\\d|[238][1-5]|4[12]|6[1-8]|7[1-6]))\\\\d{2,7}\",[6,7,8,9,10,11]],[\"3[2-9]\\\\d{7,8}|(?:31|43)\\\\d{8}\",[9,10]],[\"80(?:0\\\\d{3}|3)\\\\d{3}\",[6,9]],[\"(?:0878\\\\d{3}|89(?:2\\\\d|3[04]|4(?:[0-4]|[5-9]\\\\d\\\\d)|5[0-4]))\\\\d\\\\d|(?:1(?:44|6[346])|89(?:38|5[5-9]|9))\\\\d{6}\",[6,8,9,10]],[\"1(?:78\\\\d|99)\\\\d{6}\",[9,10]],[\"3[2-8]\\\\d{9,10}\",[11,12]],0,0,[\"55\\\\d{8}\",[10]],[\"84(?:[08]\\\\d{3}|[17])\\\\d{3}\",[6,9]]]],\"JE\":[\"44\",\"00\",\"1534\\\\d{6}|(?:[3578]\\\\d|90)\\\\d{8}\",[10],0,\"0\",0,\"([0-24-8]\\\\d{5})$|0\",\"1534$1\",0,0,[[\"1534[0-24-8]\\\\d{5}\"],[\"7(?:(?:(?:50|82)9|937)\\\\d|7(?:00[378]|97\\\\d))\\\\d{5}\"],[\"80(?:07(?:35|81)|8901)\\\\d{4}\"],[\"(?:8(?:4(?:4(?:4(?:05|42|69)|703)|5(?:041|800))|7(?:0002|1206))|90(?:066[59]|1810|71(?:07|55)))\\\\d{4}\"],[\"701511\\\\d{4}\"],0,[\"(?:3(?:0(?:07(?:35|81)|8901)|3\\\\d{4}|4(?:4(?:4(?:05|42|69)|703)|5(?:041|800))|7(?:0002|1206))|55\\\\d{4})\\\\d{4}\"],[\"76(?:464|652)\\\\d{5}|76(?:0[0-28]|2[356]|34|4[01347]|5[49]|6[0-369]|77|8[14]|9[139])\\\\d{6}\"],[\"56\\\\d{8}\"]]],\"JM\":[\"1\",\"011\",\"(?:[58]\\\\d\\\\d|658|900)\\\\d{7}\",[10],0,\"1\",0,0,0,0,\"658|876\"],\"JO\":[\"962\",\"00\",\"(?:(?:[2689]|7\\\\d)\\\\d|32|53)\\\\d{6}\",[8,9],[[\"(\\\\d)(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"[2356]|87\"],\"(0$1)\"],[\"(\\\\d{3})(\\\\d{5,6})\",\"$1 $2\",[\"[89]\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{7})\",\"$1 $2\",[\"70\"],\"0$1\"],[\"(\\\\d)(\\\\d{4})(\\\\d{4})\",\"$1 $2 $3\",[\"7\"],\"0$1\"]],\"0\"],\"JP\":[\"81\",\"010\",\"00[1-9]\\\\d{6,14}|[257-9]\\\\d{9}|(?:00|[1-9]\\\\d\\\\d)\\\\d{6}\",[8,9,10,11,12,13,14,15,16,17],[[\"(\\\\d{3})(\\\\d{3})(\\\\d{3})\",\"$1-$2-$3\",[\"(?:12|57|99)0\"],\"0$1\"],[\"(\\\\d{4})(\\\\d)(\\\\d{4})\",\"$1-$2-$3\",[\"1(?:26|3[79]|4[56]|5[4-68]|6[3-5])|499|5(?:76|97)|746|8(?:3[89]|47|51)|9(?:80|9[16])\",\"1(?:267|3(?:7[247]|9[278])|466|5(?:47|58|64)|6(?:3[245]|48|5[4-68]))|499[2468]|5(?:76|97)9|7468|8(?:3(?:8[7-9]|96)|477|51[2-9])|9(?:802|9(?:1[23]|69))|1(?:45|58)[67]\",\"1(?:267|3(?:7[247]|9[278])|466|5(?:47|58|64)|6(?:3[245]|48|5[4-68]))|499[2468]|5(?:769|979[2-69])|7468|8(?:3(?:8[7-9]|96[2457-9])|477|51[2-9])|9(?:802|9(?:1[23]|69))|1(?:45|58)[67]\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{4})\",\"$1-$2-$3\",[\"60\"],\"0$1\"],[\"(\\\\d)(\\\\d{4})(\\\\d{4})\",\"$1-$2-$3\",[\"[36]|4(?:2[09]|7[01])\",\"[36]|4(?:2(?:0|9[02-69])|7(?:0[019]|1))\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{4})\",\"$1-$2-$3\",[\"1(?:1|5[45]|77|88|9[69])|2(?:2[1-37]|3[0-269]|4[59]|5|6[24]|7[1-358]|8[1369]|9[0-38])|4(?:[28][1-9]|3[0-57]|[45]|6[248]|7[2-579]|9[29])|5(?:2|3[0459]|4[0-369]|5[29]|8[02389]|9[0-389])|7(?:2[02-46-9]|34|[58]|6[0249]|7[57]|9[2-6])|8(?:2[124589]|3[26-9]|49|51|6|7[0-468]|8[68]|9[019])|9(?:[23][1-9]|4[15]|5[138]|6[1-3]|7[156]|8[189]|9[1-489])\",\"1(?:1|5(?:4[018]|5[017])|77|88|9[69])|2(?:2(?:[127]|3[014-9])|3[0-269]|4[59]|5(?:[1-3]|5[0-69]|9[19])|62|7(?:[1-35]|8[0189])|8(?:[16]|3[0134]|9[0-5])|9(?:[028]|17))|4(?:2(?:[13-79]|8[014-6])|3[0-57]|[45]|6[248]|7[2-47]|8[1-9]|9[29])|5(?:2|3(?:[045]|9[0-8])|4[0-369]|5[29]|8[02389]|9[0-3])|7(?:2[02-46-9]|34|[58]|6[0249]|7[57]|9(?:[23]|4[0-59]|5[01569]|6[0167]))|8(?:2(?:[1258]|4[0-39]|9[0-2469])|3(?:[29]|60)|49|51|6(?:[0-24]|36|5[0-3589]|7[23]|9[01459])|7[0-468]|8[68])|9(?:[23][1-9]|4[15]|5[138]|6[1-3]|7[156]|8[189]|9(?:[1289]|3[34]|4[0178]))|(?:264|837)[016-9]|2(?:57|93)[015-9]|(?:25[0468]|422|838)[01]|(?:47[59]|59[89]|8(?:6[68]|9))[019]\",\"1(?:1|5(?:4[018]|5[017])|77|88|9[69])|2(?:2[127]|3[0-269]|4[59]|5(?:[1-3]|5[0-69]|9(?:17|99))|6(?:2|4[016-9])|7(?:[1-35]|8[0189])|8(?:[16]|3[0134]|9[0-5])|9(?:[028]|17))|4(?:2(?:[13-79]|8[014-6])|3[0-57]|[45]|6[248]|7[2-47]|9[29])|5(?:2|3(?:[045]|9(?:[0-58]|6[4-9]|7[0-35689]))|4[0-369]|5[29]|8[02389]|9[0-3])|7(?:2[02-46-9]|34|[58]|6[0249]|7[57]|9(?:[23]|4[0-59]|5[01569]|6[0167]))|8(?:2(?:[1258]|4[0-39]|9[0169])|3(?:[29]|60|7(?:[017-9]|6[6-8]))|49|51|6(?:[0-24]|36[2-57-9]|5(?:[0-389]|5[23])|6(?:[01]|9[178])|7(?:2[2-468]|3[78])|9[0145])|7[0-468]|8[68])|9(?:4[15]|5[138]|7[156]|8[189]|9(?:[1289]|3(?:31|4[357])|4[0178]))|(?:8294|96)[1-3]|2(?:57|93)[015-9]|(?:223|8699)[014-9]|(?:25[0468]|422|838)[01]|(?:48|8292|9[23])[1-9]|(?:47[59]|59[89]|8(?:68|9))[019]\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{2})(\\\\d{4})\",\"$1-$2-$3\",[\"[14]|[289][2-9]|5[3-9]|7[2-4679]\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{3})(\\\\d{4})\",\"$1-$2-$3\",[\"800\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{4})(\\\\d{4})\",\"$1-$2-$3\",[\"[257-9]\"],\"0$1\"]],\"0\",0,\"(000[259]\\\\d{6})$|(?:(?:003768)0?)|0\",\"$1\"],\"KE\":[\"254\",\"000\",\"(?:[17]\\\\d\\\\d|900)\\\\d{6}|(?:2|80)0\\\\d{6,7}|[4-6]\\\\d{6,8}\",[7,8,9,10],[[\"(\\\\d{2})(\\\\d{5,7})\",\"$1 $2\",[\"[24-6]\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{6})\",\"$1 $2\",[\"[17]\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{3})(\\\\d{3,4})\",\"$1 $2 $3\",[\"[89]\"],\"0$1\"]],\"0\"],\"KG\":[\"996\",\"00\",\"8\\\\d{9}|[235-9]\\\\d{8}\",[9,10],[[\"(\\\\d{4})(\\\\d{5})\",\"$1 $2\",[\"3(?:1[346]|[24-79])\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"[235-79]|88\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{3})(\\\\d)(\\\\d{2,3})\",\"$1 $2 $3 $4\",[\"8\"],\"0$1\"]],\"0\"],\"KH\":[\"855\",\"00[14-9]\",\"1\\\\d{9}|[1-9]\\\\d{7,8}\",[8,9,10],[[\"(\\\\d{2})(\\\\d{3})(\\\\d{3,4})\",\"$1 $2 $3\",[\"[1-9]\"],\"0$1\"],[\"(\\\\d{4})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"1\"]]],\"0\"],\"KI\":[\"686\",\"00\",\"(?:[37]\\\\d|6[0-79])\\\\d{6}|(?:[2-48]\\\\d|50)\\\\d{3}\",[5,8],0,\"0\"],\"KM\":[\"269\",\"00\",\"[3478]\\\\d{6}\",[7],[[\"(\\\\d{3})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3\",[\"[3478]\"]]]],\"KN\":[\"1\",\"011\",\"(?:[58]\\\\d\\\\d|900)\\\\d{7}\",[10],0,\"1\",0,\"([2-7]\\\\d{6})$|1\",\"869$1\",0,\"869\"],\"KP\":[\"850\",\"00|99\",\"85\\\\d{6}|(?:19\\\\d|[2-7])\\\\d{7}\",[8,10],[[\"(\\\\d{2})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"8\"],\"0$1\"],[\"(\\\\d)(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"[2-7]\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"1\"],\"0$1\"]],\"0\"],\"KR\":[\"82\",\"00(?:[125689]|3(?:[46]5|91)|7(?:00|27|3|55|6[126]))\",\"00[1-9]\\\\d{8,11}|(?:[12]|5\\\\d{3})\\\\d{7}|[13-6]\\\\d{9}|(?:[1-6]\\\\d|80)\\\\d{7}|[3-6]\\\\d{4,5}|(?:00|7)0\\\\d{8}\",[5,6,8,9,10,11,12,13,14],[[\"(\\\\d{2})(\\\\d{3,4})\",\"$1-$2\",[\"(?:3[1-3]|[46][1-4]|5[1-5])1\"],\"0$1\"],[\"(\\\\d{4})(\\\\d{4})\",\"$1-$2\",[\"1\"]],[\"(\\\\d)(\\\\d{3,4})(\\\\d{4})\",\"$1-$2-$3\",[\"2\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{4})\",\"$1-$2-$3\",[\"[36]0|8\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{3,4})(\\\\d{4})\",\"$1-$2-$3\",[\"[1346]|5[1-5]\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{4})(\\\\d{4})\",\"$1-$2-$3\",[\"[57]\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{5})(\\\\d{4})\",\"$1-$2-$3\",[\"5\"],\"0$1\"]],\"0\",0,\"0(8(?:[1-46-8]|5\\\\d\\\\d))?\"],\"KW\":[\"965\",\"00\",\"18\\\\d{5}|(?:[2569]\\\\d|41)\\\\d{6}\",[7,8],[[\"(\\\\d{4})(\\\\d{3,4})\",\"$1 $2\",[\"[169]|2(?:[235]|4[1-35-9])|52\"]],[\"(\\\\d{3})(\\\\d{5})\",\"$1 $2\",[\"[245]\"]]]],\"KY\":[\"1\",\"011\",\"(?:345|[58]\\\\d\\\\d|900)\\\\d{7}\",[10],0,\"1\",0,\"([2-9]\\\\d{6})$|1\",\"345$1\",0,\"345\"],\"KZ\":[\"7\",\"810\",\"(?:33622|8\\\\d{8})\\\\d{5}|[78]\\\\d{9}\",[10,14],0,\"8\",0,0,0,0,\"33|7\",0,\"8~10\"],\"LA\":[\"856\",\"00\",\"[23]\\\\d{9}|3\\\\d{8}|(?:[235-8]\\\\d|41)\\\\d{6}\",[8,9,10],[[\"(\\\\d{2})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"2[13]|3[14]|[4-8]\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{2})(\\\\d{2})(\\\\d{3})\",\"$1 $2 $3 $4\",[\"30[0135-9]\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{2})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3 $4\",[\"[23]\"],\"0$1\"]],\"0\"],\"LB\":[\"961\",\"00\",\"[27-9]\\\\d{7}|[13-9]\\\\d{6}\",[7,8],[[\"(\\\\d)(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"[13-69]|7(?:[2-57]|62|8[0-7]|9[04-9])|8[02-9]\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"[27-9]\"]]],\"0\"],\"LC\":[\"1\",\"011\",\"(?:[58]\\\\d\\\\d|758|900)\\\\d{7}\",[10],0,\"1\",0,\"([2-8]\\\\d{6})$|1\",\"758$1\",0,\"758\"],\"LI\":[\"423\",\"00\",\"[68]\\\\d{8}|(?:[2378]\\\\d|90)\\\\d{5}\",[7,9],[[\"(\\\\d{3})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3\",[\"[2379]|8(?:0[09]|7)\",\"[2379]|8(?:0(?:02|9)|7)\"]],[\"(\\\\d{3})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"8\"]],[\"(\\\\d{2})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"69\"]],[\"(\\\\d{3})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"6\"]]],\"0\",0,\"(1001)|0\"],\"LK\":[\"94\",\"00\",\"[1-9]\\\\d{8}\",[9],[[\"(\\\\d{2})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"7\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"[1-689]\"],\"0$1\"]],\"0\"],\"LR\":[\"231\",\"00\",\"(?:[245]\\\\d|33|77|88)\\\\d{7}|(?:2\\\\d|[4-6])\\\\d{6}\",[7,8,9],[[\"(\\\\d)(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"4[67]|[56]\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"2\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"[2-578]\"],\"0$1\"]],\"0\"],\"LS\":[\"266\",\"00\",\"(?:[256]\\\\d\\\\d|800)\\\\d{5}\",[8],[[\"(\\\\d{4})(\\\\d{4})\",\"$1 $2\",[\"[2568]\"]]]],\"LT\":[\"370\",\"00\",\"(?:[3469]\\\\d|52|[78]0)\\\\d{6}\",[8],[[\"(\\\\d)(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"52[0-7]\"],\"(0-$1)\",1],[\"(\\\\d{3})(\\\\d{2})(\\\\d{3})\",\"$1 $2 $3\",[\"[7-9]\"],\"0 $1\",1],[\"(\\\\d{2})(\\\\d{6})\",\"$1 $2\",[\"37|4(?:[15]|6[1-8])\"],\"(0-$1)\",1],[\"(\\\\d{3})(\\\\d{5})\",\"$1 $2\",[\"[3-6]\"],\"(0-$1)\",1]],\"0\",0,\"[08]\"],\"LU\":[\"352\",\"00\",\"35[013-9]\\\\d{4,8}|6\\\\d{8}|35\\\\d{2,4}|(?:[2457-9]\\\\d|3[0-46-9])\\\\d{2,9}\",[4,5,6,7,8,9,10,11],[[\"(\\\\d{2})(\\\\d{3})\",\"$1 $2\",[\"2(?:0[2-689]|[2-9])|[3-57]|8(?:0[2-9]|[13-9])|9(?:0[89]|[2-579])\"]],[\"(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3\",[\"2(?:0[2-689]|[2-9])|[3-57]|8(?:0[2-9]|[13-9])|9(?:0[89]|[2-579])\"]],[\"(\\\\d{2})(\\\\d{2})(\\\\d{3})\",\"$1 $2 $3\",[\"20[2-689]\"]],[\"(\\\\d{2})(\\\\d{2})(\\\\d{2})(\\\\d{1,2})\",\"$1 $2 $3 $4\",[\"2(?:[0367]|4[3-8])\"]],[\"(\\\\d{3})(\\\\d{2})(\\\\d{3})\",\"$1 $2 $3\",[\"80[01]|90[015]\"]],[\"(\\\\d{2})(\\\\d{2})(\\\\d{2})(\\\\d{3})\",\"$1 $2 $3 $4\",[\"20\"]],[\"(\\\\d{3})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"6\"]],[\"(\\\\d{2})(\\\\d{2})(\\\\d{2})(\\\\d{2})(\\\\d{1,2})\",\"$1 $2 $3 $4 $5\",[\"2(?:[0367]|4[3-8])\"]],[\"(\\\\d{2})(\\\\d{2})(\\\\d{2})(\\\\d{1,5})\",\"$1 $2 $3 $4\",[\"[3-57]|8[13-9]|9(?:0[89]|[2-579])|(?:2|80)[2-9]\"]]],0,0,\"(15(?:0[06]|1[12]|[35]5|4[04]|6[26]|77|88|99)\\\\d)\"],\"LV\":[\"371\",\"00\",\"(?:[268]\\\\d|90)\\\\d{6}\",[8],[[\"(\\\\d{2})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"[269]|8[01]\"]]]],\"LY\":[\"218\",\"00\",\"[2-9]\\\\d{8}\",[9],[[\"(\\\\d{2})(\\\\d{7})\",\"$1-$2\",[\"[2-9]\"],\"0$1\"]],\"0\"],\"MA\":[\"212\",\"00\",\"[5-8]\\\\d{8}\",[9],[[\"(\\\\d{3})(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"5[45]\"],\"0$1\"],[\"(\\\\d{4})(\\\\d{5})\",\"$1-$2\",[\"5(?:2[2-46-9]|3[3-9]|9)|8(?:0[89]|92)\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{7})\",\"$1-$2\",[\"8\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{6})\",\"$1-$2\",[\"[5-7]\"],\"0$1\"]],\"0\",0,0,0,0,0,[[\"5(?:2(?:[0-25-79]\\\\d|3[1-578]|4[02-46-8]|8[0235-7])|3(?:[0-47]\\\\d|5[02-9]|6[02-8]|8[014-9]|9[3-9])|(?:4[067]|5[03])\\\\d)\\\\d{5}\"],[\"(?:6(?:[0-79]\\\\d|8[0-247-9])|7(?:[0167]\\\\d|2[0-467]|5[0-3]|8[0-5]))\\\\d{6}\"],[\"80[0-7]\\\\d{6}\"],[\"89\\\\d{7}\"],0,0,0,0,[\"(?:592(?:4[0-2]|93)|80[89]\\\\d\\\\d)\\\\d{4}\"]]],\"MC\":[\"377\",\"00\",\"(?:[3489]|6\\\\d)\\\\d{7}\",[8,9],[[\"(\\\\d{2})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"4\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"[389]\"]],[\"(\\\\d)(\\\\d{2})(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4 $5\",[\"6\"],\"0$1\"]],\"0\"],\"MD\":[\"373\",\"00\",\"(?:[235-7]\\\\d|[89]0)\\\\d{6}\",[8],[[\"(\\\\d{3})(\\\\d{5})\",\"$1 $2\",[\"[89]\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"22|3\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{2})(\\\\d{3})\",\"$1 $2 $3\",[\"[25-7]\"],\"0$1\"]],\"0\"],\"ME\":[\"382\",\"00\",\"(?:20|[3-79]\\\\d)\\\\d{6}|80\\\\d{6,7}\",[8,9],[[\"(\\\\d{2})(\\\\d{3})(\\\\d{3,4})\",\"$1 $2 $3\",[\"[2-9]\"],\"0$1\"]],\"0\"],\"MF\":[\"590\",\"00\",\"(?:590\\\\d|7090)\\\\d{5}|(?:69|80|9\\\\d)\\\\d{7}\",[9],0,\"0\",0,0,0,0,0,[[\"590(?:0[079]|[14]3|[27][79]|3[03-7]|5[0-268]|87)\\\\d{4}\"],[\"(?:69(?:0\\\\d\\\\d|1(?:2[2-9]|3[0-5])|4(?:0[89]|1[2-6]|9\\\\d)|6(?:1[016-9]|5[0-4]|[67]\\\\d))|7090[0-4])\\\\d{4}\"],[\"80[0-5]\\\\d{6}\"],0,0,0,0,0,[\"9(?:(?:39[5-7]|76[018])\\\\d|475[0-6])\\\\d{4}\"]]],\"MG\":[\"261\",\"00\",\"[23]\\\\d{8}\",[9],[[\"(\\\\d{2})(\\\\d{2})(\\\\d{3})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"[23]\"],\"0$1\"]],\"0\",0,\"([24-9]\\\\d{6})$|0\",\"20$1\"],\"MH\":[\"692\",\"011\",\"329\\\\d{4}|(?:[256]\\\\d|45)\\\\d{5}\",[7],[[\"(\\\\d{3})(\\\\d{4})\",\"$1-$2\",[\"[2-6]\"]]],\"1\"],\"MK\":[\"389\",\"00\",\"[2-578]\\\\d{7}\",[8],[[\"(\\\\d)(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"2|34[47]|4(?:[37]7|5[47]|64)\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"[347]\"],\"0$1\"],[\"(\\\\d{3})(\\\\d)(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"[58]\"],\"0$1\"]],\"0\"],\"ML\":[\"223\",\"00\",\"[24-9]\\\\d{7}\",[8],[[\"(\\\\d{2})(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"[24-9]\"]]]],\"MM\":[\"95\",\"00\",\"1\\\\d{5,7}|95\\\\d{6}|(?:[4-7]|9[0-46-9])\\\\d{6,8}|(?:2|8\\\\d)\\\\d{5,8}\",[6,7,8,9,10],[[\"(\\\\d)(\\\\d{2})(\\\\d{3})\",\"$1 $2 $3\",[\"16|2\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{2})(\\\\d{3})\",\"$1 $2 $3\",[\"4(?:[2-46]|5[3-5])|5|6(?:[1-689]|7[235-7])|7(?:[0-4]|5[2-7])|8[1-5]|(?:60|86)[23]\"],\"0$1\"],[\"(\\\\d)(\\\\d{3})(\\\\d{3,4})\",\"$1 $2 $3\",[\"[12]|452|678|86\",\"[12]|452|6788|86\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{3,4})\",\"$1 $2 $3\",[\"[4-7]|8[1-35]\"],\"0$1\"],[\"(\\\\d)(\\\\d{3})(\\\\d{4,6})\",\"$1 $2 $3\",[\"9(?:2[0-4]|[35-9]|4[137-9])\"],\"0$1\"],[\"(\\\\d)(\\\\d{4})(\\\\d{4})\",\"$1 $2 $3\",[\"2\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"8\"],\"0$1\"],[\"(\\\\d)(\\\\d{3})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3 $4\",[\"92\"],\"0$1\"],[\"(\\\\d)(\\\\d{5})(\\\\d{4})\",\"$1 $2 $3\",[\"9\"],\"0$1\"]],\"0\"],\"MN\":[\"976\",\"001\",\"[12]\\\\d{7,9}|[5-9]\\\\d{7}\",[8,9,10],[[\"(\\\\d{2})(\\\\d{2})(\\\\d{4})\",\"$1 $2 $3\",[\"[12]1\"],\"0$1\"],[\"(\\\\d{4})(\\\\d{4})\",\"$1 $2\",[\"[5-9]\"]],[\"(\\\\d{3})(\\\\d{5,6})\",\"$1 $2\",[\"[12]2[1-3]\"],\"0$1\"],[\"(\\\\d{4})(\\\\d{5,6})\",\"$1 $2\",[\"[12](?:27|3[2-8]|4[2-68]|5[1-4689])\",\"[12](?:27|3[2-8]|4[2-68]|5[1-4689])[0-3]\"],\"0$1\"],[\"(\\\\d{5})(\\\\d{4,5})\",\"$1 $2\",[\"[12]\"],\"0$1\"]],\"0\"],\"MO\":[\"853\",\"00\",\"0800\\\\d{3}|(?:28|[68]\\\\d)\\\\d{6}\",[7,8],[[\"(\\\\d{4})(\\\\d{3})\",\"$1 $2\",[\"0\"]],[\"(\\\\d{4})(\\\\d{4})\",\"$1 $2\",[\"[268]\"]]]],\"MP\":[\"1\",\"011\",\"[58]\\\\d{9}|(?:67|90)0\\\\d{7}\",[10],0,\"1\",0,\"([2-9]\\\\d{6})$|1\",\"670$1\",0,\"670\"],\"MQ\":[\"596\",\"00\",\"(?:596\\\\d|7091)\\\\d{5}|(?:69|[89]\\\\d)\\\\d{7}\",[9],[[\"(\\\\d{3})(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"[5-79]|8(?:0[6-9]|[36])\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"8\"],\"0$1\"]],\"0\"],\"MR\":[\"222\",\"00\",\"(?:[2-4]\\\\d\\\\d|800)\\\\d{5}\",[8],[[\"(\\\\d{2})(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"[2-48]\"]]]],\"MS\":[\"1\",\"011\",\"(?:[58]\\\\d\\\\d|664|900)\\\\d{7}\",[10],0,\"1\",0,\"([34]\\\\d{6})$|1\",\"664$1\",0,\"664\"],\"MT\":[\"356\",\"00\",\"3550\\\\d{4}|(?:[2579]\\\\d\\\\d|800)\\\\d{5}\",[8],[[\"(\\\\d{4})(\\\\d{4})\",\"$1 $2\",[\"[2357-9]\"]]]],\"MU\":[\"230\",\"0(?:0|[24-7]0|3[03])\",\"(?:[57]|8\\\\d\\\\d)\\\\d{7}|[2-468]\\\\d{6}\",[7,8,10],[[\"(\\\\d{3})(\\\\d{4})\",\"$1 $2\",[\"[2-46]|8[013]\"]],[\"(\\\\d{4})(\\\\d{4})\",\"$1 $2\",[\"[57]\"]],[\"(\\\\d{5})(\\\\d{5})\",\"$1 $2\",[\"8\"]]],0,0,0,0,0,0,0,\"020\"],\"MV\":[\"960\",\"0(?:0|19)\",\"(?:800|9[0-57-9]\\\\d)\\\\d{7}|[34679]\\\\d{6}\",[7,10],[[\"(\\\\d{3})(\\\\d{4})\",\"$1-$2\",[\"[34679]\"]],[\"(\\\\d{3})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"[89]\"]]],0,0,0,0,0,0,0,\"00\"],\"MW\":[\"265\",\"00\",\"(?:[1289]\\\\d|31|77)\\\\d{7}|1\\\\d{6}\",[7,9],[[\"(\\\\d)(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"1[2-9]\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"2\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"[137-9]\"],\"0$1\"]],\"0\"],\"MX\":[\"52\",\"0[09]\",\"[2-9]\\\\d{9}\",[10],[[\"(\\\\d{2})(\\\\d{4})(\\\\d{4})\",\"$1 $2 $3\",[\"33|5[56]|81\"]],[\"(\\\\d{3})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"[2-9]\"]]],0,0,0,0,0,0,0,\"00\"],\"MY\":[\"60\",\"00\",\"1\\\\d{8,9}|(?:3\\\\d|[4-9])\\\\d{7}\",[8,9,10],[[\"(\\\\d)(\\\\d{3})(\\\\d{4})\",\"$1-$2 $3\",[\"[4-79]\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{3,4})\",\"$1-$2 $3\",[\"1(?:[02469]|[378][1-9]|53)|8\",\"1(?:[02469]|[37][1-9]|53|8(?:[1-46-9]|5[7-9]))|8\"],\"0$1\"],[\"(\\\\d)(\\\\d{4})(\\\\d{4})\",\"$1-$2 $3\",[\"3\"],\"0$1\"],[\"(\\\\d)(\\\\d{3})(\\\\d{2})(\\\\d{4})\",\"$1-$2-$3-$4\",[\"1(?:[367]|80)\"]],[\"(\\\\d{3})(\\\\d{3})(\\\\d{4})\",\"$1-$2 $3\",[\"15\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{4})(\\\\d{4})\",\"$1-$2 $3\",[\"1\"],\"0$1\"]],\"0\"],\"MZ\":[\"258\",\"00\",\"(?:2|8\\\\d)\\\\d{7}\",[8,9],[[\"(\\\\d{2})(\\\\d{3})(\\\\d{3,4})\",\"$1 $2 $3\",[\"2|8[2-79]\"]],[\"(\\\\d{3})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"8\"]]]],\"NA\":[\"264\",\"00\",\"[68]\\\\d{7,8}\",[8,9],[[\"(\\\\d{2})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"88\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{3,4})\",\"$1 $2 $3\",[\"6\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"87\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"8\"],\"0$1\"]],\"0\"],\"NC\":[\"687\",\"00\",\"(?:050|[2-57-9]\\\\d\\\\d)\\\\d{3}\",[6],[[\"(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1.$2.$3\",[\"[02-57-9]\"]]]],\"NE\":[\"227\",\"00\",\"[027-9]\\\\d{7}\",[8],[[\"(\\\\d{2})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"08\"]],[\"(\\\\d{2})(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"[089]|2[013]|7[0467]\"]]]],\"NF\":[\"672\",\"00\",\"[13]\\\\d{5}\",[6],[[\"(\\\\d{2})(\\\\d{4})\",\"$1 $2\",[\"1[0-3]\"]],[\"(\\\\d)(\\\\d{5})\",\"$1 $2\",[\"[13]\"]]],0,0,\"([0-258]\\\\d{4})$\",\"3$1\"],\"NG\":[\"234\",\"009\",\"38\\\\d{6}|[78]\\\\d{9,13}|(?:20|9\\\\d)\\\\d{8}\",[8,10,11,12,13,14],[[\"(\\\\d{2})(\\\\d{3})(\\\\d{2,3})\",\"$1 $2 $3\",[\"3\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{3})(\\\\d{3,4})\",\"$1 $2 $3\",[\"[7-9]\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"20[129]\"],\"0$1\"],[\"(\\\\d{4})(\\\\d{2})(\\\\d{4})\",\"$1 $2 $3\",[\"2\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{4})(\\\\d{4,5})\",\"$1 $2 $3\",[\"[78]\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{5})(\\\\d{5,6})\",\"$1 $2 $3\",[\"[78]\"],\"0$1\"]],\"0\"],\"NI\":[\"505\",\"00\",\"(?:1800|[25-8]\\\\d{3})\\\\d{4}\",[8],[[\"(\\\\d{4})(\\\\d{4})\",\"$1 $2\",[\"[125-8]\"]]]],\"NL\":[\"31\",\"00\",\"(?:[124-7]\\\\d\\\\d|3(?:[02-9]\\\\d|1[0-8]))\\\\d{6}|8\\\\d{6,9}|9\\\\d{6,10}|1\\\\d{4,5}\",[5,6,7,8,9,10,11],[[\"(\\\\d{3})(\\\\d{4,7})\",\"$1 $2\",[\"[89]0\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{7})\",\"$1 $2\",[\"66\"],\"0$1\"],[\"(\\\\d)(\\\\d{8})\",\"$1 $2\",[\"6\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"1[16-8]|2[259]|3[124]|4[17-9]|5[124679]\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"[1-578]|91\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{3})(\\\\d{5})\",\"$1 $2 $3\",[\"9\"],\"0$1\"]],\"0\"],\"NO\":[\"47\",\"00\",\"(?:0|[2-9]\\\\d{3})\\\\d{4}\",[5,8],[[\"(\\\\d{3})(\\\\d{2})(\\\\d{3})\",\"$1 $2 $3\",[\"8\"]],[\"(\\\\d{2})(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"[2-79]\"]]],0,0,0,0,0,\"[02-689]|7[0-8]\"],\"NP\":[\"977\",\"00\",\"(?:1\\\\d|9)\\\\d{9}|[1-9]\\\\d{7}\",[8,10,11],[[\"(\\\\d)(\\\\d{7})\",\"$1-$2\",[\"1[2-6]\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{6})\",\"$1-$2\",[\"1[01]|[2-8]|9(?:[1-59]|[67][2-6])\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{7})\",\"$1-$2\",[\"9\"]]],\"0\"],\"NR\":[\"674\",\"00\",\"(?:222|444|(?:55|8\\\\d)\\\\d|666|777|999)\\\\d{4}\",[7],[[\"(\\\\d{3})(\\\\d{4})\",\"$1 $2\",[\"[24-9]\"]]]],\"NU\":[\"683\",\"00\",\"(?:[4-7]|888\\\\d)\\\\d{3}\",[4,7],[[\"(\\\\d{3})(\\\\d{4})\",\"$1 $2\",[\"8\"]]]],\"NZ\":[\"64\",\"0(?:0|161)\",\"[1289]\\\\d{9}|50\\\\d{5}(?:\\\\d{2,3})?|[27-9]\\\\d{7,8}|(?:[34]\\\\d|6[0-35-9])\\\\d{6}|8\\\\d{4,6}\",[5,6,7,8,9,10],[[\"(\\\\d{2})(\\\\d{3,8})\",\"$1 $2\",[\"8[1-79]\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{2})(\\\\d{2,3})\",\"$1 $2 $3\",[\"50[036-8]|8|90\",\"50(?:[0367]|88)|8|90\"],\"0$1\"],[\"(\\\\d)(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"24|[346]|7[2-57-9]|9[2-9]\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{3})(\\\\d{3,4})\",\"$1 $2 $3\",[\"2(?:10|74)|[589]\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{3,4})(\\\\d{4})\",\"$1 $2 $3\",[\"1|2[028]\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{3,5})\",\"$1 $2 $3\",[\"2(?:[169]|7[0-35-9])|7\"],\"0$1\"]],\"0\",0,0,0,0,0,0,\"00\"],\"OM\":[\"968\",\"00\",\"(?:1505|[279]\\\\d{3}|500)\\\\d{4}|800\\\\d{5,6}\",[7,8,9],[[\"(\\\\d{3})(\\\\d{4,6})\",\"$1 $2\",[\"[58]\"]],[\"(\\\\d{2})(\\\\d{6})\",\"$1 $2\",[\"2\"]],[\"(\\\\d{4})(\\\\d{4})\",\"$1 $2\",[\"[179]\"]]]],\"PA\":[\"507\",\"00\",\"(?:00800|8\\\\d{3})\\\\d{6}|[68]\\\\d{7}|[1-57-9]\\\\d{6}\",[7,8,10,11],[[\"(\\\\d{3})(\\\\d{4})\",\"$1-$2\",[\"[1-57-9]\"]],[\"(\\\\d{4})(\\\\d{4})\",\"$1-$2\",[\"[68]\"]],[\"(\\\\d{3})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"8\"]]]],\"PE\":[\"51\",\"00|19(?:1[124]|77|90)00\",\"(?:[14-8]|9\\\\d)\\\\d{7}\",[8,9],[[\"(\\\\d{3})(\\\\d{5})\",\"$1 $2\",[\"80\"],\"(0$1)\"],[\"(\\\\d)(\\\\d{7})\",\"$1 $2\",[\"1\"],\"(0$1)\"],[\"(\\\\d{2})(\\\\d{6})\",\"$1 $2\",[\"[4-8]\"],\"(0$1)\"],[\"(\\\\d{3})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"9\"]]],\"0\",0,0,0,0,0,0,\"00\",\" Anexo \"],\"PF\":[\"689\",\"00\",\"4\\\\d{5}(?:\\\\d{2})?|8\\\\d{7,8}\",[6,8,9],[[\"(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3\",[\"44\"]],[\"(\\\\d{2})(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"4|8[7-9]\"]],[\"(\\\\d{3})(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"8\"]]]],\"PG\":[\"675\",\"00|140[1-3]\",\"(?:180|[78]\\\\d{3})\\\\d{4}|(?:[2-589]\\\\d|64)\\\\d{5}\",[7,8],[[\"(\\\\d{3})(\\\\d{4})\",\"$1 $2\",[\"18|[2-69]|85\"]],[\"(\\\\d{4})(\\\\d{4})\",\"$1 $2\",[\"[78]\"]]],0,0,0,0,0,0,0,\"00\"],\"PH\":[\"63\",\"00\",\"(?:[2-7]|9\\\\d)\\\\d{8}|2\\\\d{5}|(?:1800|8)\\\\d{7,9}\",[6,8,9,10,11,12,13],[[\"(\\\\d)(\\\\d{5})\",\"$1 $2\",[\"2\"],\"(0$1)\"],[\"(\\\\d{4})(\\\\d{4,6})\",\"$1 $2\",[\"3(?:23|39|46)|4(?:2[3-6]|[35]9|4[26]|76)|544|88[245]|(?:52|64|86)2\",\"3(?:230|397|461)|4(?:2(?:35|[46]4|51)|396|4(?:22|63)|59[347]|76[15])|5(?:221|446)|642[23]|8(?:622|8(?:[24]2|5[13]))\"],\"(0$1)\"],[\"(\\\\d{5})(\\\\d{4})\",\"$1 $2\",[\"346|4(?:27|9[35])|883\",\"3469|4(?:279|9(?:30|56))|8834\"],\"(0$1)\"],[\"(\\\\d)(\\\\d{4})(\\\\d{4})\",\"$1 $2 $3\",[\"2\"],\"(0$1)\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"[3-7]|8[2-8]\"],\"(0$1)\"],[\"(\\\\d{3})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"[89]\"],\"0$1\"],[\"(\\\\d{4})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"1\"]],[\"(\\\\d{4})(\\\\d{1,2})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3 $4\",[\"1\"]]],\"0\"],\"PK\":[\"92\",\"00\",\"122\\\\d{6}|[24-8]\\\\d{10,11}|9(?:[013-9]\\\\d{8,10}|2(?:[01]\\\\d\\\\d|2(?:[06-8]\\\\d|1[01]))\\\\d{7})|(?:[2-8]\\\\d{3}|92(?:[0-7]\\\\d|8[1-9]))\\\\d{6}|[24-9]\\\\d{8}|[89]\\\\d{7}\",[8,9,10,11,12],[[\"(\\\\d{3})(\\\\d{3})(\\\\d{2,7})\",\"$1 $2 $3\",[\"[89]0\"],\"0$1\"],[\"(\\\\d{4})(\\\\d{5})\",\"$1 $2\",[\"1\"]],[\"(\\\\d{3})(\\\\d{6,7})\",\"$1 $2\",[\"2(?:3[2358]|4[2-4]|9[2-8])|45[3479]|54[2-467]|60[468]|72[236]|8(?:2[2-689]|3[23578]|4[3478]|5[2356])|9(?:2[2-8]|3[27-9]|4[2-6]|6[3569]|9[25-8])\",\"9(?:2[3-8]|98)|(?:2(?:3[2358]|4[2-4]|9[2-8])|45[3479]|54[2-467]|60[468]|72[236]|8(?:2[2-689]|3[23578]|4[3478]|5[2356])|9(?:22|3[27-9]|4[2-6]|6[3569]|9[25-7]))[2-9]\"],\"(0$1)\"],[\"(\\\\d{2})(\\\\d{7,8})\",\"$1 $2\",[\"(?:2[125]|4[0-246-9]|5[1-35-7]|6[1-8]|7[14]|8[16]|91)[2-9]\"],\"(0$1)\"],[\"(\\\\d{5})(\\\\d{5})\",\"$1 $2\",[\"58\"],\"(0$1)\"],[\"(\\\\d{3})(\\\\d{7})\",\"$1 $2\",[\"3\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3 $4\",[\"2[125]|4[0-246-9]|5[1-35-7]|6[1-8]|7[14]|8[16]|91\"],\"(0$1)\"],[\"(\\\\d{3})(\\\\d{3})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3 $4\",[\"[24-9]\"],\"(0$1)\"]],\"0\"],\"PL\":[\"48\",\"00\",\"(?:6|8\\\\d\\\\d)\\\\d{7}|[1-9]\\\\d{6}(?:\\\\d{2})?|[26]\\\\d{5}\",[6,7,8,9,10],[[\"(\\\\d{5})\",\"$1\",[\"19\"]],[\"(\\\\d{3})(\\\\d{3})\",\"$1 $2\",[\"11|20|64\"]],[\"(\\\\d{2})(\\\\d{2})(\\\\d{3})\",\"$1 $2 $3\",[\"(?:1[2-8]|2[2-69]|3[2-4]|4[1-468]|5[24-689]|6[1-3578]|7[14-7]|8[1-79]|9[145])1\",\"(?:1[2-8]|2[2-69]|3[2-4]|4[1-468]|5[24-689]|6[1-3578]|7[14-7]|8[1-79]|9[145])19\"]],[\"(\\\\d{3})(\\\\d{2})(\\\\d{2,3})\",\"$1 $2 $3\",[\"64\"]],[\"(\\\\d{3})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"21|39|45|5[0137]|6[0469]|7[02389]|8(?:0[14]|8)\"]],[\"(\\\\d{2})(\\\\d{3})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"1[2-8]|[2-7]|8[1-79]|9[145]\"]],[\"(\\\\d{3})(\\\\d{3})(\\\\d{3,4})\",\"$1 $2 $3\",[\"8\"]]]],\"PM\":[\"508\",\"00\",\"[45]\\\\d{5}|(?:708|8\\\\d\\\\d)\\\\d{6}\",[6,9],[[\"(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3\",[\"[45]\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"7\"]],[\"(\\\\d{3})(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"8\"],\"0$1\"]],\"0\"],\"PR\":[\"1\",\"011\",\"(?:[589]\\\\d\\\\d|787)\\\\d{7}\",[10],0,\"1\",0,0,0,0,\"787|939\"],\"PS\":[\"970\",\"00\",\"[2489]2\\\\d{6}|(?:1\\\\d|5)\\\\d{8}\",[8,9,10],[[\"(\\\\d)(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"[2489]\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"5\"],\"0$1\"],[\"(\\\\d{4})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"1\"]]],\"0\"],\"PT\":[\"351\",\"00\",\"1693\\\\d{5}|(?:[26-9]\\\\d|30)\\\\d{7}\",[9],[[\"(\\\\d{2})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"2[12]\"]],[\"(\\\\d{3})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"16|[236-9]\"]]]],\"PW\":[\"680\",\"01[12]\",\"(?:[24-8]\\\\d\\\\d|345|900)\\\\d{4}\",[7],[[\"(\\\\d{3})(\\\\d{4})\",\"$1 $2\",[\"[2-9]\"]]]],\"PY\":[\"595\",\"00\",\"59\\\\d{4,6}|9\\\\d{5,10}|(?:[2-46-8]\\\\d|5[0-8])\\\\d{4,7}\",[6,7,8,9,10,11],[[\"(\\\\d{3})(\\\\d{3,6})\",\"$1 $2\",[\"[2-9]0\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{5})\",\"$1 $2\",[\"[26]1|3[289]|4[1246-8]|7[1-3]|8[1-36]\"],\"(0$1)\"],[\"(\\\\d{3})(\\\\d{4,5})\",\"$1 $2\",[\"2[279]|3[13-5]|4[359]|5|6(?:[34]|7[1-46-8])|7[46-8]|85\"],\"(0$1)\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{3,4})\",\"$1 $2 $3\",[\"2[14-68]|3[26-9]|4[1246-8]|6(?:1|75)|7[1-35]|8[1-36]\"],\"(0$1)\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"87\"]],[\"(\\\\d{3})(\\\\d{6})\",\"$1 $2\",[\"9(?:[5-79]|8[1-7])\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"[2-8]\"],\"0$1\"],[\"(\\\\d{4})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"9\"]]],\"0\"],\"QA\":[\"974\",\"00\",\"800\\\\d{4}|(?:2|800)\\\\d{6}|(?:0080|[3-7])\\\\d{7}\",[7,8,9,11],[[\"(\\\\d{3})(\\\\d{4})\",\"$1 $2\",[\"2[16]|8\"]],[\"(\\\\d{4})(\\\\d{4})\",\"$1 $2\",[\"[3-7]\"]]]],\"RE\":[\"262\",\"00\",\"709\\\\d{6}|(?:26|[689]\\\\d)\\\\d{7}\",[9],[[\"(\\\\d{3})(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"[26-9]\"],\"0$1\"]],\"0\",0,0,0,0,0,[[\"26(?:2\\\\d\\\\d|3(?:0\\\\d|1[0-6]))\\\\d{4}\"],[\"(?:69(?:2\\\\d\\\\d|3(?:[06][0-6]|1[0-3]|2[0-2]|3[0-39]|4\\\\d|5[0-5]|7[0-37]|8[0-8]|9[0-479]))|7092[0-3])\\\\d{4}\"],[\"80\\\\d{7}\"],[\"89[1-37-9]\\\\d{6}\"],0,0,0,0,[\"9(?:399[0-3]|479[0-6]|76(?:2[278]|3[0-37]))\\\\d{4}\"],[\"8(?:1[019]|2[0156]|84|90)\\\\d{6}\"]]],\"RO\":[\"40\",\"00\",\"(?:[236-8]\\\\d|90)\\\\d{7}|[23]\\\\d{5}\",[6,9],[[\"(\\\\d{3})(\\\\d{3})\",\"$1 $2\",[\"2[3-6]\",\"2[3-6]\\\\d9\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{4})\",\"$1 $2\",[\"219|31\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"[23]1\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"[236-9]\"],\"0$1\"]],\"0\",0,0,0,0,0,0,0,\" int \"],\"RS\":[\"381\",\"00\",\"38[02-9]\\\\d{6,9}|6\\\\d{7,9}|90\\\\d{4,8}|38\\\\d{5,6}|(?:7\\\\d\\\\d|800)\\\\d{3,9}|(?:[12]\\\\d|3[0-79])\\\\d{5,10}\",[6,7,8,9,10,11,12],[[\"(\\\\d{3})(\\\\d{3,9})\",\"$1 $2\",[\"(?:2[389]|39)0|[7-9]\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{5,10})\",\"$1 $2\",[\"[1-36]\"],\"0$1\"]],\"0\"],\"RU\":[\"7\",\"810\",\"8\\\\d{13}|[347-9]\\\\d{9}\",[10,14],[[\"(\\\\d{4})(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"7(?:1[0-8]|2[1-9])\",\"7(?:1(?:[0-356]2|4[29]|7|8[27])|2(?:1[23]|[2-9]2))\",\"7(?:1(?:[0-356]2|4[29]|7|8[27])|2(?:13[03-69]|62[013-9]))|72[1-57-9]2\"],\"8 ($1)\",1],[\"(\\\\d{5})(\\\\d)(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"7(?:1[0-68]|2[1-9])\",\"7(?:1(?:[06][3-6]|[18]|2[35]|[3-5][3-5])|2(?:[13][3-5]|[24-689]|7[457]))\",\"7(?:1(?:0(?:[356]|4[023])|[18]|2(?:3[013-9]|5)|3[45]|43[013-79]|5(?:3[1-8]|4[1-7]|5)|6(?:3[0-35-9]|[4-6]))|2(?:1(?:3[178]|[45])|[24-689]|3[35]|7[457]))|7(?:14|23)4[0-8]|71(?:33|45)[1-79]\"],\"8 ($1)\",1],[\"(\\\\d{3})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"7\"],\"8 ($1)\",1],[\"(\\\\d{3})(\\\\d{3})(\\\\d{2})(\\\\d{2})\",\"$1 $2-$3-$4\",[\"[349]|8(?:[02-7]|1[1-8])\"],\"8 ($1)\",1],[\"(\\\\d{4})(\\\\d{4})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3 $4\",[\"8\"],\"8 ($1)\"]],\"8\",0,0,0,0,\"3[04-689]|[489]\",0,\"8~10\"],\"RW\":[\"250\",\"00\",\"(?:06|[27]\\\\d\\\\d|[89]00)\\\\d{6}\",[8,9],[[\"(\\\\d{2})(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"0\"]],[\"(\\\\d{3})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"2\"]],[\"(\\\\d{3})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"[7-9]\"],\"0$1\"]],\"0\"],\"SA\":[\"966\",\"00\",\"92\\\\d{7}|(?:[15]|8\\\\d)\\\\d{8}\",[9,10],[[\"(\\\\d{4})(\\\\d{5})\",\"$1 $2\",[\"9\"]],[\"(\\\\d{2})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"1\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"5\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{3})(\\\\d{3,4})\",\"$1 $2 $3\",[\"81\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"8\"]]],\"0\"],\"SB\":[\"677\",\"0[01]\",\"[6-9]\\\\d{6}|[1-6]\\\\d{4}\",[5,7],[[\"(\\\\d{2})(\\\\d{5})\",\"$1 $2\",[\"6[89]|7|8[4-9]|9(?:[1-8]|9[0-8])\"]]]],\"SC\":[\"248\",\"010|0[0-2]\",\"(?:[2489]\\\\d|64)\\\\d{5}\",[7],[[\"(\\\\d)(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"[246]|9[57]\"]]],0,0,0,0,0,0,0,\"00\"],\"SD\":[\"249\",\"00\",\"[19]\\\\d{8}\",[9],[[\"(\\\\d{2})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"[19]\"],\"0$1\"]],\"0\"],\"SE\":[\"46\",\"00\",\"(?:[26]\\\\d\\\\d|9)\\\\d{9}|[1-9]\\\\d{8}|[1-689]\\\\d{7}|[1-4689]\\\\d{6}|2\\\\d{5}\",[6,7,8,9,10,12],[[\"(\\\\d{2})(\\\\d{2,3})(\\\\d{2})\",\"$1-$2 $3\",[\"20\"],\"0$1\",0,\"$1 $2 $3\"],[\"(\\\\d{3})(\\\\d{4})\",\"$1-$2\",[\"9(?:00|39|44|9)\"],\"0$1\",0,\"$1 $2\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{2})\",\"$1-$2 $3\",[\"[12][136]|3[356]|4[0246]|6[03]|90[1-9]\"],\"0$1\",0,\"$1 $2 $3\"],[\"(\\\\d)(\\\\d{2,3})(\\\\d{2})(\\\\d{2})\",\"$1-$2 $3 $4\",[\"8\"],\"0$1\",0,\"$1 $2 $3 $4\"],[\"(\\\\d{3})(\\\\d{2,3})(\\\\d{2})\",\"$1-$2 $3\",[\"1[2457]|2(?:[247-9]|5[0138])|3[0247-9]|4[1357-9]|5[0-35-9]|6(?:[125689]|4[02-57]|7[0-2])|9(?:[125-8]|3[02-5]|4[0-3])\"],\"0$1\",0,\"$1 $2 $3\"],[\"(\\\\d{3})(\\\\d{2,3})(\\\\d{3})\",\"$1-$2 $3\",[\"9(?:00|39|44)\"],\"0$1\",0,\"$1 $2 $3\"],[\"(\\\\d{2})(\\\\d{2,3})(\\\\d{2})(\\\\d{2})\",\"$1-$2 $3 $4\",[\"1[13689]|2[0136]|3[1356]|4[0246]|54|6[03]|90[1-9]\"],\"0$1\",0,\"$1 $2 $3 $4\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{2})(\\\\d{2})\",\"$1-$2 $3 $4\",[\"10|7\"],\"0$1\",0,\"$1 $2 $3 $4\"],[\"(\\\\d)(\\\\d{3})(\\\\d{3})(\\\\d{2})\",\"$1-$2 $3 $4\",[\"8\"],\"0$1\",0,\"$1 $2 $3 $4\"],[\"(\\\\d{3})(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1-$2 $3 $4\",[\"[13-5]|2(?:[247-9]|5[0138])|6(?:[124-689]|7[0-2])|9(?:[125-8]|3[02-5]|4[0-3])\"],\"0$1\",0,\"$1 $2 $3 $4\"],[\"(\\\\d{3})(\\\\d{2})(\\\\d{2})(\\\\d{3})\",\"$1-$2 $3 $4\",[\"9\"],\"0$1\",0,\"$1 $2 $3 $4\"],[\"(\\\\d{3})(\\\\d{2})(\\\\d{3})(\\\\d{2})(\\\\d{2})\",\"$1-$2 $3 $4 $5\",[\"[26]\"],\"0$1\",0,\"$1 $2 $3 $4 $5\"]],\"0\"],\"SG\":[\"65\",\"0[0-3]\\\\d\",\"(?:(?:1\\\\d|8)\\\\d\\\\d|7000)\\\\d{7}|[3689]\\\\d{7}\",[8,10,11],[[\"(\\\\d{4})(\\\\d{4})\",\"$1 $2\",[\"[369]|8(?:0[1-9]|[1-9])\"]],[\"(\\\\d{3})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"8\"]],[\"(\\\\d{4})(\\\\d{4})(\\\\d{3})\",\"$1 $2 $3\",[\"7\"]],[\"(\\\\d{4})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"1\"]]]],\"SH\":[\"290\",\"00\",\"(?:[256]\\\\d|8)\\\\d{3}\",[4,5],0,0,0,0,0,0,\"[256]\"],\"SI\":[\"386\",\"00|10(?:22|66|88|99)\",\"[1-7]\\\\d{7}|8\\\\d{4,7}|90\\\\d{4,6}\",[5,6,7,8],[[\"(\\\\d{2})(\\\\d{3,6})\",\"$1 $2\",[\"8[09]|9\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{5})\",\"$1 $2\",[\"59|8\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"[37][01]|4[0139]|51|6\"],\"0$1\"],[\"(\\\\d)(\\\\d{3})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"[1-57]\"],\"(0$1)\"]],\"0\",0,0,0,0,0,0,\"00\"],\"SJ\":[\"47\",\"00\",\"0\\\\d{4}|(?:[489]\\\\d|79)\\\\d{6}\",[5,8],0,0,0,0,0,0,\"79\"],\"SK\":[\"421\",\"00\",\"[2-689]\\\\d{8}|[2-59]\\\\d{6}|[2-5]\\\\d{5}\",[6,7,9],[[\"(\\\\d)(\\\\d{2})(\\\\d{3,4})\",\"$1 $2 $3\",[\"21\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{2})(\\\\d{2,3})\",\"$1 $2 $3\",[\"[3-5][1-8]1\",\"[3-5][1-8]1[67]\"],\"0$1\"],[\"(\\\\d)(\\\\d{3})(\\\\d{3})(\\\\d{2})\",\"$1/$2 $3 $4\",[\"2\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"[689]\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{2})(\\\\d{2})\",\"$1/$2 $3 $4\",[\"[3-5]\"],\"0$1\"]],\"0\"],\"SL\":[\"232\",\"00\",\"(?:[237-9]\\\\d|66)\\\\d{6}\",[8],[[\"(\\\\d{2})(\\\\d{6})\",\"$1 $2\",[\"[236-9]\"],\"(0$1)\"]],\"0\"],\"SM\":[\"378\",\"00\",\"(?:0549|[5-7]\\\\d)\\\\d{6}\",[8,10],[[\"(\\\\d{2})(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"[5-7]\"]],[\"(\\\\d{4})(\\\\d{6})\",\"$1 $2\",[\"0\"]]],0,0,\"([89]\\\\d{5})$\",\"0549$1\"],\"SN\":[\"221\",\"00\",\"(?:[378]\\\\d|93)\\\\d{7}\",[9],[[\"(\\\\d{3})(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"8\"]],[\"(\\\\d{2})(\\\\d{3})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"[379]\"]]]],\"SO\":[\"252\",\"00\",\"[346-9]\\\\d{8}|[12679]\\\\d{7}|[1-5]\\\\d{6}|[1348]\\\\d{5}\",[6,7,8,9],[[\"(\\\\d{2})(\\\\d{4})\",\"$1 $2\",[\"8[125]\"]],[\"(\\\\d{6})\",\"$1\",[\"[134]\"]],[\"(\\\\d)(\\\\d{6})\",\"$1 $2\",[\"[15]|2[0-79]|3[0-46-8]|4[0-7]\"]],[\"(\\\\d)(\\\\d{7})\",\"$1 $2\",[\"(?:2|90)4|[67]\"]],[\"(\\\\d{3})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"[348]|64|79|90\"]],[\"(\\\\d{2})(\\\\d{5,7})\",\"$1 $2\",[\"1|28|6[0-35-9]|7[67]|9[2-9]\"]]],\"0\"],\"SR\":[\"597\",\"00\",\"(?:[2-5]|68|[78]\\\\d)\\\\d{5}\",[6,7],[[\"(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1-$2-$3\",[\"56\"]],[\"(\\\\d{3})(\\\\d{3})\",\"$1-$2\",[\"[2-5]\"]],[\"(\\\\d{3})(\\\\d{4})\",\"$1-$2\",[\"[6-8]\"]]]],\"SS\":[\"211\",\"00\",\"[19]\\\\d{8}\",[9],[[\"(\\\\d{3})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"[19]\"],\"0$1\"]],\"0\"],\"ST\":[\"239\",\"00\",\"(?:22|9\\\\d)\\\\d{5}\",[7],[[\"(\\\\d{3})(\\\\d{4})\",\"$1 $2\",[\"[29]\"]]]],\"SV\":[\"503\",\"00\",\"[267]\\\\d{7}|(?:80\\\\d|900)\\\\d{4}(?:\\\\d{4})?\",[7,8,11],[[\"(\\\\d{3})(\\\\d{4})\",\"$1 $2\",[\"[89]\"]],[\"(\\\\d{4})(\\\\d{4})\",\"$1 $2\",[\"[267]\"]],[\"(\\\\d{3})(\\\\d{4})(\\\\d{4})\",\"$1 $2 $3\",[\"[89]\"]]]],\"SX\":[\"1\",\"011\",\"7215\\\\d{6}|(?:[58]\\\\d\\\\d|900)\\\\d{7}\",[10],0,\"1\",0,\"(5\\\\d{6})$|1\",\"721$1\",0,\"721\"],\"SY\":[\"963\",\"00\",\"[1-359]\\\\d{8}|[1-5]\\\\d{7}\",[8,9],[[\"(\\\\d{2})(\\\\d{3})(\\\\d{3,4})\",\"$1 $2 $3\",[\"[1-4]|5[1-3]\"],\"0$1\",1],[\"(\\\\d{3})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"[59]\"],\"0$1\",1]],\"0\"],\"SZ\":[\"268\",\"00\",\"0800\\\\d{4}|(?:[237]\\\\d|900)\\\\d{6}\",[8,9],[[\"(\\\\d{4})(\\\\d{4})\",\"$1 $2\",[\"[0237]\"]],[\"(\\\\d{5})(\\\\d{4})\",\"$1 $2\",[\"9\"]]]],\"TA\":[\"290\",\"00\",\"8\\\\d{3}\",[4],0,0,0,0,0,0,\"8\"],\"TC\":[\"1\",\"011\",\"(?:[58]\\\\d\\\\d|649|900)\\\\d{7}\",[10],0,\"1\",0,\"([2-479]\\\\d{6})$|1\",\"649$1\",0,\"649\"],\"TD\":[\"235\",\"00|16\",\"(?:22|[689]\\\\d|77)\\\\d{6}\",[8],[[\"(\\\\d{2})(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"[26-9]\"]]],0,0,0,0,0,0,0,\"00\"],\"TG\":[\"228\",\"00\",\"[279]\\\\d{7}\",[8],[[\"(\\\\d{2})(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"[279]\"]]]],\"TH\":[\"66\",\"00[1-9]\",\"(?:001800|[2-57]|[689]\\\\d)\\\\d{7}|1\\\\d{7,9}\",[8,9,10,13],[[\"(\\\\d)(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"2\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{3,4})\",\"$1 $2 $3\",[\"[13-9]\"],\"0$1\"],[\"(\\\\d{4})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"1\"]]],\"0\"],\"TJ\":[\"992\",\"810\",\"[0-57-9]\\\\d{8}\",[9],[[\"(\\\\d{6})(\\\\d)(\\\\d{2})\",\"$1 $2 $3\",[\"331\",\"3317\"]],[\"(\\\\d{3})(\\\\d{2})(\\\\d{4})\",\"$1 $2 $3\",[\"44[02-479]|[34]7\"]],[\"(\\\\d{4})(\\\\d)(\\\\d{4})\",\"$1 $2 $3\",[\"3(?:[1245]|3[12])\"]],[\"(\\\\d{2})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"[0-57-9]\"]]],0,0,0,0,0,0,0,\"8~10\"],\"TK\":[\"690\",\"00\",\"[2-47]\\\\d{3,6}\",[4,5,6,7]],\"TL\":[\"670\",\"00\",\"7\\\\d{7}|(?:[2-47]\\\\d|[89]0)\\\\d{5}\",[7,8],[[\"(\\\\d{3})(\\\\d{4})\",\"$1 $2\",[\"[2-489]|70\"]],[\"(\\\\d{4})(\\\\d{4})\",\"$1 $2\",[\"7\"]]]],\"TM\":[\"993\",\"810\",\"(?:[1-6]\\\\d|71)\\\\d{6}\",[8],[[\"(\\\\d{2})(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1 $2-$3-$4\",[\"12\"],\"(8 $1)\"],[\"(\\\\d{3})(\\\\d)(\\\\d{2})(\\\\d{2})\",\"$1 $2-$3-$4\",[\"[1-5]\"],\"(8 $1)\"],[\"(\\\\d{2})(\\\\d{6})\",\"$1 $2\",[\"[67]\"],\"8 $1\"]],\"8\",0,0,0,0,0,0,\"8~10\"],\"TN\":[\"216\",\"00\",\"[2-57-9]\\\\d{7}\",[8],[[\"(\\\\d{2})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"[2-57-9]\"]]]],\"TO\":[\"676\",\"00\",\"(?:0800|(?:[5-8]\\\\d\\\\d|999)\\\\d)\\\\d{3}|[2-8]\\\\d{4}\",[5,7],[[\"(\\\\d{2})(\\\\d{3})\",\"$1-$2\",[\"[2-4]|50|6[09]|7[0-24-69]|8[05]\"]],[\"(\\\\d{4})(\\\\d{3})\",\"$1 $2\",[\"0\"]],[\"(\\\\d{3})(\\\\d{4})\",\"$1 $2\",[\"[5-9]\"]]]],\"TR\":[\"90\",\"00\",\"4\\\\d{6}|8\\\\d{11,12}|(?:[2-58]\\\\d\\\\d|900)\\\\d{7}\",[7,10,12,13],[[\"(\\\\d{3})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"512|8[01589]|90\"],\"0$1\",1],[\"(\\\\d{3})(\\\\d{3})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"5(?:[0-59]|61)\",\"5(?:[0-59]|61[06])\",\"5(?:[0-59]|61[06]1)\"],\"0$1\",1],[\"(\\\\d{3})(\\\\d{3})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"[24][1-8]|3[1-9]\"],\"(0$1)\",1],[\"(\\\\d{3})(\\\\d{3})(\\\\d{6,7})\",\"$1 $2 $3\",[\"80\"],\"0$1\",1]],\"0\"],\"TT\":[\"1\",\"011\",\"(?:[58]\\\\d\\\\d|900)\\\\d{7}\",[10],0,\"1\",0,\"([2-46-8]\\\\d{6})$|1\",\"868$1\",0,\"868\"],\"TV\":[\"688\",\"00\",\"(?:2|7\\\\d\\\\d|90)\\\\d{4}\",[5,6,7],[[\"(\\\\d{2})(\\\\d{3})\",\"$1 $2\",[\"2\"]],[\"(\\\\d{2})(\\\\d{4})\",\"$1 $2\",[\"90\"]],[\"(\\\\d{2})(\\\\d{5})\",\"$1 $2\",[\"7\"]]]],\"TW\":[\"886\",\"0(?:0[25-79]|19)\",\"[2-689]\\\\d{8}|7\\\\d{9,10}|[2-8]\\\\d{7}|2\\\\d{6}\",[7,8,9,10,11],[[\"(\\\\d{2})(\\\\d)(\\\\d{4})\",\"$1 $2 $3\",[\"202\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{3,4})\",\"$1 $2 $3\",[\"[258]0\"],\"0$1\"],[\"(\\\\d)(\\\\d{3,4})(\\\\d{4})\",\"$1 $2 $3\",[\"[23568]|4(?:0[02-48]|[1-47-9])|7[1-9]\",\"[23568]|4(?:0[2-48]|[1-47-9])|(?:400|7)[1-9]\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"[49]\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{4})(\\\\d{4,5})\",\"$1 $2 $3\",[\"7\"],\"0$1\"]],\"0\",0,0,0,0,0,0,0,\"#\"],\"TZ\":[\"255\",\"00[056]\",\"(?:[25-8]\\\\d|41|90)\\\\d{7}\",[9],[[\"(\\\\d{3})(\\\\d{2})(\\\\d{4})\",\"$1 $2 $3\",[\"[89]\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"[24]\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{7})\",\"$1 $2\",[\"5\"]],[\"(\\\\d{3})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"[67]\"],\"0$1\"]],\"0\"],\"UA\":[\"380\",\"00\",\"[89]\\\\d{9}|[3-9]\\\\d{8}\",[9,10],[[\"(\\\\d{3})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"6[12][29]|(?:3[1-8]|4[136-8]|5[12457]|6[49])2|(?:56|65)[24]\",\"6[12][29]|(?:35|4[1378]|5[12457]|6[49])2|(?:56|65)[24]|(?:3[1-46-8]|46)2[013-9]\"],\"0$1\"],[\"(\\\\d{4})(\\\\d{5})\",\"$1 $2\",[\"3[1-8]|4(?:[1367]|[45][6-9]|8[4-6])|5(?:[1-5]|6[0135689]|7[4-6])|6(?:[12][3-7]|[459])\",\"3[1-8]|4(?:[1367]|[45][6-9]|8[4-6])|5(?:[1-5]|6(?:[015689]|3[02389])|7[4-6])|6(?:[12][3-7]|[459])\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"[3-7]|89|9[1-9]\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{3})(\\\\d{3,4})\",\"$1 $2 $3\",[\"[89]\"],\"0$1\"]],\"0\",0,0,0,0,0,0,\"0~0\"],\"UG\":[\"256\",\"00[057]\",\"800\\\\d{6}|(?:[29]0|[347]\\\\d)\\\\d{7}\",[9],[[\"(\\\\d{4})(\\\\d{5})\",\"$1 $2\",[\"202\",\"2024\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{6})\",\"$1 $2\",[\"[27-9]|4(?:6[45]|[7-9])\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{7})\",\"$1 $2\",[\"[34]\"],\"0$1\"]],\"0\"],\"US\":[\"1\",\"011\",\"[2-9]\\\\d{9}|3\\\\d{6}\",[10],[[\"(\\\\d{3})(\\\\d{4})\",\"$1-$2\",[\"310\"],0,1],[\"(\\\\d{3})(\\\\d{3})(\\\\d{4})\",\"($1) $2-$3\",[\"[2-9]\"],0,1,\"$1-$2-$3\"]],\"1\",0,0,0,0,0,[[\"(?:3052(?:0[0-8]|[1-9]\\\\d)|5056(?:[0-35-9]\\\\d|4[0-468]))\\\\d{4}|(?:2742|305[3-9]|472[247-9]|505[2-57-9]|983[2-47-9])\\\\d{6}|(?:2(?:0[1-35-9]|1[02-9]|2[03-57-9]|3[1459]|4[08]|5[1-46]|6[0279]|7[0269]|8[13])|3(?:0[1-47-9]|1[02-9]|2[0135-79]|3[0-24679]|4[167]|5[0-2]|6[01349]|8[056])|4(?:0[124-9]|1[02-579]|2[3-5]|3[0245]|4[023578]|58|6[349]|7[0589]|8[04])|5(?:0[1-47-9]|1[0235-8]|20|3[0149]|4[01]|5[179]|6[1-47]|7[0-5]|8[0256])|6(?:0[1-35-9]|1[024-9]|2[03689]|3[016]|4[0156]|5[01679]|6[0-279]|78|8[0-29])|7(?:0[1-46-8]|1[2-9]|2[04-8]|3[0-247]|4[037]|5[47]|6[02359]|7[0-59]|8[156])|8(?:0[1-68]|1[02-8]|2[0168]|3[0-2589]|4[03578]|5[046-9]|6[02-5]|7[028])|9(?:0[1346-9]|1[02-9]|2[0589]|3[0146-8]|4[01357-9]|5[12469]|7[0-389]|8[04-69]))[2-9]\\\\d{6}\"],[\"\"],[\"8(?:00|33|44|55|66|77|88)[2-9]\\\\d{6}\"],[\"900[2-9]\\\\d{6}\"],[\"52(?:3(?:[2-46-9][02-9]\\\\d|5(?:[02-46-9]\\\\d|5[0-46-9]))|4(?:[2-478][02-9]\\\\d|5(?:[034]\\\\d|2[024-9]|5[0-46-9])|6(?:0[1-9]|[2-9]\\\\d)|9(?:[05-9]\\\\d|2[0-5]|49)))\\\\d{4}|52[34][2-9]1[02-9]\\\\d{4}|5(?:00|2[125-9]|33|44|66|77|88)[2-9]\\\\d{6}\"],0,0,0,[\"305209\\\\d{4}\"]]],\"UY\":[\"598\",\"0(?:0|1[3-9]\\\\d)\",\"0004\\\\d{2,9}|[1249]\\\\d{7}|(?:[49]\\\\d|80)\\\\d{5}\",[6,7,8,9,10,11,12,13],[[\"(\\\\d{3})(\\\\d{3,4})\",\"$1 $2\",[\"0\"]],[\"(\\\\d{3})(\\\\d{4})\",\"$1 $2\",[\"[49]0|8\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"9\"],\"0$1\"],[\"(\\\\d{4})(\\\\d{4})\",\"$1 $2\",[\"[124]\"]],[\"(\\\\d{3})(\\\\d{3})(\\\\d{2,4})\",\"$1 $2 $3\",[\"0\"]],[\"(\\\\d{3})(\\\\d{3})(\\\\d{3})(\\\\d{2,4})\",\"$1 $2 $3 $4\",[\"0\"]]],\"0\",0,0,0,0,0,0,\"00\",\" int. \"],\"UZ\":[\"998\",\"00\",\"(?:20|33|[5-9]\\\\d)\\\\d{7}\",[9],[[\"(\\\\d{2})(\\\\d{3})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"[235-9]\"]]]],\"VA\":[\"39\",\"00\",\"0\\\\d{5,10}|3[0-8]\\\\d{7,10}|55\\\\d{8}|8\\\\d{5}(?:\\\\d{2,4})?|(?:1\\\\d|39)\\\\d{7,8}\",[6,7,8,9,10,11,12],0,0,0,0,0,0,\"06698\"],\"VC\":[\"1\",\"011\",\"(?:[58]\\\\d\\\\d|784|900)\\\\d{7}\",[10],0,\"1\",0,\"([2-7]\\\\d{6})$|1\",\"784$1\",0,\"784\"],\"VE\":[\"58\",\"00\",\"[68]00\\\\d{7}|(?:[24]\\\\d|[59]0)\\\\d{8}\",[10],[[\"(\\\\d{3})(\\\\d{7})\",\"$1-$2\",[\"[24-689]\"],\"0$1\"]],\"0\"],\"VG\":[\"1\",\"011\",\"(?:284|[58]\\\\d\\\\d|900)\\\\d{7}\",[10],0,\"1\",0,\"([2-578]\\\\d{6})$|1\",\"284$1\",0,\"284\"],\"VI\":[\"1\",\"011\",\"[58]\\\\d{9}|(?:34|90)0\\\\d{7}\",[10],0,\"1\",0,\"([2-9]\\\\d{6})$|1\",\"340$1\",0,\"340\"],\"VN\":[\"84\",\"00\",\"[12]\\\\d{9}|[135-9]\\\\d{8}|[16]\\\\d{7}|[16-8]\\\\d{6}\",[7,8,9,10],[[\"(\\\\d{2})(\\\\d{5})\",\"$1 $2\",[\"80\"],\"0$1\",1],[\"(\\\\d{4})(\\\\d{4,6})\",\"$1 $2\",[\"1\"],0,1],[\"(\\\\d{2})(\\\\d{3})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"6\"],\"0$1\",1],[\"(\\\\d{3})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"[357-9]\"],\"0$1\",1],[\"(\\\\d{2})(\\\\d{4})(\\\\d{4})\",\"$1 $2 $3\",[\"2[48]\"],\"0$1\",1],[\"(\\\\d{3})(\\\\d{4})(\\\\d{3})\",\"$1 $2 $3\",[\"2\"],\"0$1\",1]],\"0\"],\"VU\":[\"678\",\"00\",\"[57-9]\\\\d{6}|(?:[238]\\\\d|48)\\\\d{3}\",[5,7],[[\"(\\\\d{3})(\\\\d{4})\",\"$1 $2\",[\"[57-9]\"]]]],\"WF\":[\"681\",\"00\",\"(?:40|72|8\\\\d{4})\\\\d{4}|[89]\\\\d{5}\",[6,9],[[\"(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3\",[\"[47-9]\"]],[\"(\\\\d{3})(\\\\d{2})(\\\\d{2})(\\\\d{2})\",\"$1 $2 $3 $4\",[\"8\"]]]],\"WS\":[\"685\",\"0\",\"(?:[2-6]|8\\\\d{5})\\\\d{4}|[78]\\\\d{6}|[68]\\\\d{5}\",[5,6,7,10],[[\"(\\\\d{5})\",\"$1\",[\"[2-5]|6[1-9]\"]],[\"(\\\\d{3})(\\\\d{3,7})\",\"$1 $2\",[\"[68]\"]],[\"(\\\\d{2})(\\\\d{5})\",\"$1 $2\",[\"7\"]]]],\"XK\":[\"383\",\"00\",\"2\\\\d{7,8}|3\\\\d{7,11}|(?:4\\\\d\\\\d|[89]00)\\\\d{5}\",[8,9,10,11,12],[[\"(\\\\d{3})(\\\\d{5})\",\"$1 $2\",[\"[89]\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"[2-4]\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"2|39\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{7,10})\",\"$1 $2\",[\"3\"],\"0$1\"]],\"0\"],\"YE\":[\"967\",\"00\",\"(?:1|7\\\\d)\\\\d{7}|[1-7]\\\\d{6}\",[7,8,9],[[\"(\\\\d)(\\\\d{3})(\\\\d{3,4})\",\"$1 $2 $3\",[\"[1-6]|7(?:[24-6]|8[0-7])\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"7\"],\"0$1\"]],\"0\"],\"YT\":[\"262\",\"00\",\"7093\\\\d{5}|(?:80|9\\\\d)\\\\d{7}|(?:26|63)9\\\\d{6}\",[9],0,\"0\",0,0,0,0,0,[[\"269(?:0[0-467]|15|5[0-4]|6\\\\d|[78]0)\\\\d{4}\"],[\"(?:639(?:0[0-79]|1[019]|[267]\\\\d|3[09]|40|5[05-9]|9[04-79])|7093[5-7])\\\\d{4}\"],[\"80\\\\d{7}\"],0,0,0,0,0,[\"9(?:(?:39|47)8[01]|769\\\\d)\\\\d{4}\"]]],\"ZA\":[\"27\",\"00\",\"[1-79]\\\\d{8}|8\\\\d{4,9}\",[5,6,7,8,9,10],[[\"(\\\\d{2})(\\\\d{3,4})\",\"$1 $2\",[\"8[1-4]\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{2,3})\",\"$1 $2 $3\",[\"8[1-4]\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"860\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"[1-9]\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"8\"],\"0$1\"]],\"0\"],\"ZM\":[\"260\",\"00\",\"800\\\\d{6}|(?:21|[579]\\\\d|63)\\\\d{7}\",[9],[[\"(\\\\d{3})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"[28]\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{7})\",\"$1 $2\",[\"[579]\"],\"0$1\"]],\"0\"],\"ZW\":[\"263\",\"00\",\"2(?:[0-57-9]\\\\d{6,8}|6[0-24-9]\\\\d{6,7})|[38]\\\\d{9}|[35-8]\\\\d{8}|[3-6]\\\\d{7}|[1-689]\\\\d{6}|[1-3569]\\\\d{5}|[1356]\\\\d{4}\",[5,6,7,8,9,10],[[\"(\\\\d{3})(\\\\d{3,5})\",\"$1 $2\",[\"2(?:0[45]|2[278]|[49]8)|3(?:[09]8|17)|6(?:[29]8|37|75)|[23][78]|(?:33|5[15]|6[68])[78]\"],\"0$1\"],[\"(\\\\d)(\\\\d{3})(\\\\d{2,4})\",\"$1 $2 $3\",[\"[49]\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{4})\",\"$1 $2\",[\"80\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{7})\",\"$1 $2\",[\"24|8[13-59]|(?:2[05-79]|39|5[45]|6[15-8])2\",\"2(?:02[014]|4|[56]20|[79]2)|392|5(?:42|525)|6(?:[16-8]21|52[013])|8[13-59]\"],\"(0$1)\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"7\"],\"0$1\"],[\"(\\\\d{3})(\\\\d{3})(\\\\d{3,4})\",\"$1 $2 $3\",[\"2(?:1[39]|2[0157]|[378]|[56][14])|3(?:12|29)\",\"2(?:1[39]|2[0157]|[378]|[56][14])|3(?:123|29)\"],\"0$1\"],[\"(\\\\d{4})(\\\\d{6})\",\"$1 $2\",[\"8\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{3,5})\",\"$1 $2\",[\"1|2(?:0[0-36-9]|12|29|[56])|3(?:1[0-689]|[24-6])|5(?:[0236-9]|1[2-4])|6(?:[013-59]|7[0-46-9])|(?:33|55|6[68])[0-69]|(?:29|3[09]|62)[0-79]\"],\"0$1\"],[\"(\\\\d{2})(\\\\d{3})(\\\\d{3,4})\",\"$1 $2 $3\",[\"29[013-9]|39|54\"],\"0$1\"],[\"(\\\\d{4})(\\\\d{3,5})\",\"$1 $2\",[\"(?:25|54)8\",\"258|5483\"],\"0$1\"]],\"0\"]},\"nonGeographic\":{\"800\":[\"800\",0,\"(?:00|[1-9]\\\\d)\\\\d{6}\",[8],[[\"(\\\\d{4})(\\\\d{4})\",\"$1 $2\",[\"\\\\d\"]]],0,0,0,0,0,0,[0,0,[\"(?:00|[1-9]\\\\d)\\\\d{6}\"]]],\"808\":[\"808\",0,\"[1-9]\\\\d{7}\",[8],[[\"(\\\\d{4})(\\\\d{4})\",\"$1 $2\",[\"[1-9]\"]]],0,0,0,0,0,0,[0,0,0,0,0,0,0,0,0,[\"[1-9]\\\\d{7}\"]]],\"870\":[\"870\",0,\"7\\\\d{11}|[235-7]\\\\d{8}\",[9,12],[[\"(\\\\d{3})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"[235-7]\"]]],0,0,0,0,0,0,[0,[\"(?:[356]|774[45])\\\\d{8}|7[6-8]\\\\d{7}\"],0,0,0,0,0,0,[\"2\\\\d{8}\",[9]]]],\"878\":[\"878\",0,\"10\\\\d{10}\",[12],[[\"(\\\\d{2})(\\\\d{5})(\\\\d{5})\",\"$1 $2 $3\",[\"1\"]]],0,0,0,0,0,0,[0,0,0,0,0,0,0,0,[\"10\\\\d{10}\"]]],\"881\":[\"881\",0,\"6\\\\d{9}|[0-36-9]\\\\d{8}\",[9,10],[[\"(\\\\d)(\\\\d{3})(\\\\d{5})\",\"$1 $2 $3\",[\"[0-37-9]\"]],[\"(\\\\d)(\\\\d{3})(\\\\d{5,6})\",\"$1 $2 $3\",[\"6\"]]],0,0,0,0,0,0,[0,[\"6\\\\d{9}|[0-36-9]\\\\d{8}\"]]],\"882\":[\"882\",0,\"[13]\\\\d{6}(?:\\\\d{2,5})?|[19]\\\\d{7}|(?:[25]\\\\d\\\\d|4)\\\\d{7}(?:\\\\d{2})?\",[7,8,9,10,11,12],[[\"(\\\\d{2})(\\\\d{5})\",\"$1 $2\",[\"16|342\"]],[\"(\\\\d{2})(\\\\d{6})\",\"$1 $2\",[\"49\"]],[\"(\\\\d{2})(\\\\d{2})(\\\\d{4})\",\"$1 $2 $3\",[\"1[36]|9\"]],[\"(\\\\d{2})(\\\\d{4})(\\\\d{3})\",\"$1 $2 $3\",[\"3[23]\"]],[\"(\\\\d{2})(\\\\d{3,4})(\\\\d{4})\",\"$1 $2 $3\",[\"16\"]],[\"(\\\\d{2})(\\\\d{4})(\\\\d{4})\",\"$1 $2 $3\",[\"10|23|3(?:[15]|4[57])|4|51\"]],[\"(\\\\d{3})(\\\\d{4})(\\\\d{4})\",\"$1 $2 $3\",[\"34\"]],[\"(\\\\d{2})(\\\\d{4,5})(\\\\d{5})\",\"$1 $2 $3\",[\"[1-35]\"]]],0,0,0,0,0,0,[0,[\"342\\\\d{4}|(?:337|49)\\\\d{6}|(?:3(?:2|47|7\\\\d{3})|50\\\\d{3})\\\\d{7}\",[7,8,9,10,12]],0,0,0,[\"348[57]\\\\d{7}\",[11]],0,0,[\"1(?:3(?:0[0347]|[13][0139]|2[035]|4[013568]|6[0459]|7[06]|8[15-8]|9[0689])\\\\d{4}|6\\\\d{5,10})|(?:345\\\\d|9[89])\\\\d{6}|(?:10|2(?:3|85\\\\d)|3(?:[15]|[69]\\\\d\\\\d)|4[15-8]|51)\\\\d{8}\"]]],\"883\":[\"883\",0,\"(?:[1-4]\\\\d|51)\\\\d{6,10}\",[8,9,10,11,12],[[\"(\\\\d{3})(\\\\d{3})(\\\\d{2,8})\",\"$1 $2 $3\",[\"[14]|2[24-689]|3[02-689]|51[24-9]\"]],[\"(\\\\d{3})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3\",[\"510\"]],[\"(\\\\d{3})(\\\\d{3})(\\\\d{4})\",\"$1 $2 $3\",[\"21\"]],[\"(\\\\d{4})(\\\\d{4})(\\\\d{4})\",\"$1 $2 $3\",[\"51[13]\"]],[\"(\\\\d{3})(\\\\d{3})(\\\\d{3})(\\\\d{3})\",\"$1 $2 $3 $4\",[\"[235]\"]]],0,0,0,0,0,0,[0,0,0,0,0,0,0,0,[\"(?:2(?:00\\\\d\\\\d|10)|(?:370[1-9]|51\\\\d0)\\\\d)\\\\d{7}|51(?:00\\\\d{5}|[24-9]0\\\\d{4,7})|(?:1[0-79]|2[24-689]|3[02-689]|4[0-4])0\\\\d{5,9}\"]]],\"888\":[\"888\",0,\"\\\\d{11}\",[11],[[\"(\\\\d{3})(\\\\d{3})(\\\\d{5})\",\"$1 $2 $3\"]],0,0,0,0,0,0,[0,0,0,0,0,0,[\"\\\\d{11}\"]]],\"979\":[\"979\",0,\"[1359]\\\\d{8}\",[9],[[\"(\\\\d)(\\\\d{4})(\\\\d{4})\",\"$1 $2 $3\",[\"[1359]\"]]],0,0,0,0,0,0,[0,0,0,[\"[1359]\\\\d{8}\"]]]}});//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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