"use strict";
/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
exports.id = "vendor-chunks/chart.js";
exports.ids = ["vendor-chunks/chart.js"];
exports.modules = {

/***/ "(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/chart.js/dist/chart.js":
/*!***********************************************************************************************!*\
  !*** ../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/chart.js/dist/chart.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Animation: () => (/* binding */ Animation),\n/* harmony export */   Animations: () => (/* binding */ Animations),\n/* harmony export */   ArcElement: () => (/* binding */ ArcElement),\n/* harmony export */   BarController: () => (/* binding */ BarController),\n/* harmony export */   BarElement: () => (/* binding */ BarElement),\n/* harmony export */   BasePlatform: () => (/* binding */ BasePlatform),\n/* harmony export */   BasicPlatform: () => (/* binding */ BasicPlatform),\n/* harmony export */   BubbleController: () => (/* binding */ BubbleController),\n/* harmony export */   CategoryScale: () => (/* binding */ CategoryScale),\n/* harmony export */   Chart: () => (/* binding */ Chart),\n/* harmony export */   Colors: () => (/* binding */ plugin_colors),\n/* harmony export */   DatasetController: () => (/* binding */ DatasetController),\n/* harmony export */   Decimation: () => (/* binding */ plugin_decimation),\n/* harmony export */   DomPlatform: () => (/* binding */ DomPlatform),\n/* harmony export */   DoughnutController: () => (/* binding */ DoughnutController),\n/* harmony export */   Element: () => (/* binding */ Element),\n/* harmony export */   Filler: () => (/* binding */ index),\n/* harmony export */   Interaction: () => (/* binding */ Interaction),\n/* harmony export */   Legend: () => (/* binding */ plugin_legend),\n/* harmony export */   LineController: () => (/* binding */ LineController),\n/* harmony export */   LineElement: () => (/* binding */ LineElement),\n/* harmony export */   LinearScale: () => (/* binding */ LinearScale),\n/* harmony export */   LogarithmicScale: () => (/* binding */ LogarithmicScale),\n/* harmony export */   PieController: () => (/* binding */ PieController),\n/* harmony export */   PointElement: () => (/* binding */ PointElement),\n/* harmony export */   PolarAreaController: () => (/* binding */ PolarAreaController),\n/* harmony export */   RadarController: () => (/* binding */ RadarController),\n/* harmony export */   RadialLinearScale: () => (/* binding */ RadialLinearScale),\n/* harmony export */   Scale: () => (/* binding */ Scale),\n/* harmony export */   ScatterController: () => (/* binding */ ScatterController),\n/* harmony export */   SubTitle: () => (/* binding */ plugin_subtitle),\n/* harmony export */   Ticks: () => (/* reexport safe */ _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.aM),\n/* harmony export */   TimeScale: () => (/* binding */ TimeScale),\n/* harmony export */   TimeSeriesScale: () => (/* binding */ TimeSeriesScale),\n/* harmony export */   Title: () => (/* binding */ plugin_title),\n/* harmony export */   Tooltip: () => (/* binding */ plugin_tooltip),\n/* harmony export */   _adapters: () => (/* binding */ adapters),\n/* harmony export */   _detectPlatform: () => (/* binding */ _detectPlatform),\n/* harmony export */   animator: () => (/* binding */ animator),\n/* harmony export */   controllers: () => (/* binding */ controllers),\n/* harmony export */   defaults: () => (/* reexport safe */ _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.d),\n/* harmony export */   elements: () => (/* binding */ elements),\n/* harmony export */   layouts: () => (/* binding */ layouts),\n/* harmony export */   plugins: () => (/* binding */ plugins),\n/* harmony export */   registerables: () => (/* binding */ registerables),\n/* harmony export */   registry: () => (/* binding */ registry),\n/* harmony export */   scales: () => (/* binding */ scales)\n/* harmony export */ });\n/* harmony import */ var _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./chunks/helpers.dataset.js */ \"(ssr)/../nodevenv/staging.agentambitionacademy.com/20/lib/node_modules/chart.js/dist/chunks/helpers.dataset.js\");\n/*!\n * Chart.js v4.4.9\n * https://www.chartjs.org\n * (c) 2025 Chart.js Contributors\n * Released under the MIT License\n */\n\n\n\nclass Animator {\n    constructor(){\n        this._request = null;\n        this._charts = new Map();\n        this._running = false;\n        this._lastDate = undefined;\n    }\n _notify(chart, anims, date, type) {\n        const callbacks = anims.listeners[type];\n        const numSteps = anims.duration;\n        callbacks.forEach((fn)=>fn({\n                chart,\n                initial: anims.initial,\n                numSteps,\n                currentStep: Math.min(date - anims.start, numSteps)\n            }));\n    }\n _refresh() {\n        if (this._request) {\n            return;\n        }\n        this._running = true;\n        this._request = _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.r.call(window, ()=>{\n            this._update();\n            this._request = null;\n            if (this._running) {\n                this._refresh();\n            }\n        });\n    }\n _update(date = Date.now()) {\n        let remaining = 0;\n        this._charts.forEach((anims, chart)=>{\n            if (!anims.running || !anims.items.length) {\n                return;\n            }\n            const items = anims.items;\n            let i = items.length - 1;\n            let draw = false;\n            let item;\n            for(; i >= 0; --i){\n                item = items[i];\n                if (item._active) {\n                    if (item._total > anims.duration) {\n                        anims.duration = item._total;\n                    }\n                    item.tick(date);\n                    draw = true;\n                } else {\n                    items[i] = items[items.length - 1];\n                    items.pop();\n                }\n            }\n            if (draw) {\n                chart.draw();\n                this._notify(chart, anims, date, 'progress');\n            }\n            if (!items.length) {\n                anims.running = false;\n                this._notify(chart, anims, date, 'complete');\n                anims.initial = false;\n            }\n            remaining += items.length;\n        });\n        this._lastDate = date;\n        if (remaining === 0) {\n            this._running = false;\n        }\n    }\n _getAnims(chart) {\n        const charts = this._charts;\n        let anims = charts.get(chart);\n        if (!anims) {\n            anims = {\n                running: false,\n                initial: true,\n                items: [],\n                listeners: {\n                    complete: [],\n                    progress: []\n                }\n            };\n            charts.set(chart, anims);\n        }\n        return anims;\n    }\n listen(chart, event, cb) {\n        this._getAnims(chart).listeners[event].push(cb);\n    }\n add(chart, items) {\n        if (!items || !items.length) {\n            return;\n        }\n        this._getAnims(chart).items.push(...items);\n    }\n has(chart) {\n        return this._getAnims(chart).items.length > 0;\n    }\n start(chart) {\n        const anims = this._charts.get(chart);\n        if (!anims) {\n            return;\n        }\n        anims.running = true;\n        anims.start = Date.now();\n        anims.duration = anims.items.reduce((acc, cur)=>Math.max(acc, cur._duration), 0);\n        this._refresh();\n    }\n    running(chart) {\n        if (!this._running) {\n            return false;\n        }\n        const anims = this._charts.get(chart);\n        if (!anims || !anims.running || !anims.items.length) {\n            return false;\n        }\n        return true;\n    }\n stop(chart) {\n        const anims = this._charts.get(chart);\n        if (!anims || !anims.items.length) {\n            return;\n        }\n        const items = anims.items;\n        let i = items.length - 1;\n        for(; i >= 0; --i){\n            items[i].cancel();\n        }\n        anims.items = [];\n        this._notify(chart, anims, Date.now(), 'complete');\n    }\n remove(chart) {\n        return this._charts.delete(chart);\n    }\n}\nvar animator = /* #__PURE__ */ new Animator();\n\nconst transparent = 'transparent';\nconst interpolators = {\n    boolean (from, to, factor) {\n        return factor > 0.5 ? to : from;\n    },\n color (from, to, factor) {\n        const c0 = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.c)(from || transparent);\n        const c1 = c0.valid && (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.c)(to || transparent);\n        return c1 && c1.valid ? c1.mix(c0, factor).hexString() : to;\n    },\n    number (from, to, factor) {\n        return from + (to - from) * factor;\n    }\n};\nclass Animation {\n    constructor(cfg, target, prop, to){\n        const currentValue = target[prop];\n        to = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a)([\n            cfg.to,\n            to,\n            currentValue,\n            cfg.from\n        ]);\n        const from = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a)([\n            cfg.from,\n            currentValue,\n            to\n        ]);\n        this._active = true;\n        this._fn = cfg.fn || interpolators[cfg.type || typeof from];\n        this._easing = _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.e[cfg.easing] || _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.e.linear;\n        this._start = Math.floor(Date.now() + (cfg.delay || 0));\n        this._duration = this._total = Math.floor(cfg.duration);\n        this._loop = !!cfg.loop;\n        this._target = target;\n        this._prop = prop;\n        this._from = from;\n        this._to = to;\n        this._promises = undefined;\n    }\n    active() {\n        return this._active;\n    }\n    update(cfg, to, date) {\n        if (this._active) {\n            this._notify(false);\n            const currentValue = this._target[this._prop];\n            const elapsed = date - this._start;\n            const remain = this._duration - elapsed;\n            this._start = date;\n            this._duration = Math.floor(Math.max(remain, cfg.duration));\n            this._total += elapsed;\n            this._loop = !!cfg.loop;\n            this._to = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a)([\n                cfg.to,\n                to,\n                currentValue,\n                cfg.from\n            ]);\n            this._from = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a)([\n                cfg.from,\n                currentValue,\n                to\n            ]);\n        }\n    }\n    cancel() {\n        if (this._active) {\n            this.tick(Date.now());\n            this._active = false;\n            this._notify(false);\n        }\n    }\n    tick(date) {\n        const elapsed = date - this._start;\n        const duration = this._duration;\n        const prop = this._prop;\n        const from = this._from;\n        const loop = this._loop;\n        const to = this._to;\n        let factor;\n        this._active = from !== to && (loop || elapsed < duration);\n        if (!this._active) {\n            this._target[prop] = to;\n            this._notify(true);\n            return;\n        }\n        if (elapsed < 0) {\n            this._target[prop] = from;\n            return;\n        }\n        factor = elapsed / duration % 2;\n        factor = loop && factor > 1 ? 2 - factor : factor;\n        factor = this._easing(Math.min(1, Math.max(0, factor)));\n        this._target[prop] = this._fn(from, to, factor);\n    }\n    wait() {\n        const promises = this._promises || (this._promises = []);\n        return new Promise((res, rej)=>{\n            promises.push({\n                res,\n                rej\n            });\n        });\n    }\n    _notify(resolved) {\n        const method = resolved ? 'res' : 'rej';\n        const promises = this._promises || [];\n        for(let i = 0; i < promises.length; i++){\n            promises[i][method]();\n        }\n    }\n}\n\nclass Animations {\n    constructor(chart, config){\n        this._chart = chart;\n        this._properties = new Map();\n        this.configure(config);\n    }\n    configure(config) {\n        if (!(0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.i)(config)) {\n            return;\n        }\n        const animationOptions = Object.keys(_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.d.animation);\n        const animatedProps = this._properties;\n        Object.getOwnPropertyNames(config).forEach((key)=>{\n            const cfg = config[key];\n            if (!(0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.i)(cfg)) {\n                return;\n            }\n            const resolved = {};\n            for (const option of animationOptions){\n                resolved[option] = cfg[option];\n            }\n            ((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.b)(cfg.properties) && cfg.properties || [\n                key\n            ]).forEach((prop)=>{\n                if (prop === key || !animatedProps.has(prop)) {\n                    animatedProps.set(prop, resolved);\n                }\n            });\n        });\n    }\n _animateOptions(target, values) {\n        const newOptions = values.options;\n        const options = resolveTargetOptions(target, newOptions);\n        if (!options) {\n            return [];\n        }\n        const animations = this._createAnimations(options, newOptions);\n        if (newOptions.$shared) {\n            awaitAll(target.options.$animations, newOptions).then(()=>{\n                target.options = newOptions;\n            }, ()=>{\n            });\n        }\n        return animations;\n    }\n _createAnimations(target, values) {\n        const animatedProps = this._properties;\n        const animations = [];\n        const running = target.$animations || (target.$animations = {});\n        const props = Object.keys(values);\n        const date = Date.now();\n        let i;\n        for(i = props.length - 1; i >= 0; --i){\n            const prop = props[i];\n            if (prop.charAt(0) === '$') {\n                continue;\n            }\n            if (prop === 'options') {\n                animations.push(...this._animateOptions(target, values));\n                continue;\n            }\n            const value = values[prop];\n            let animation = running[prop];\n            const cfg = animatedProps.get(prop);\n            if (animation) {\n                if (cfg && animation.active()) {\n                    animation.update(cfg, value, date);\n                    continue;\n                } else {\n                    animation.cancel();\n                }\n            }\n            if (!cfg || !cfg.duration) {\n                target[prop] = value;\n                continue;\n            }\n            running[prop] = animation = new Animation(cfg, target, prop, value);\n            animations.push(animation);\n        }\n        return animations;\n    }\n update(target, values) {\n        if (this._properties.size === 0) {\n            Object.assign(target, values);\n            return;\n        }\n        const animations = this._createAnimations(target, values);\n        if (animations.length) {\n            animator.add(this._chart, animations);\n            return true;\n        }\n    }\n}\nfunction awaitAll(animations, properties) {\n    const running = [];\n    const keys = Object.keys(properties);\n    for(let i = 0; i < keys.length; i++){\n        const anim = animations[keys[i]];\n        if (anim && anim.active()) {\n            running.push(anim.wait());\n        }\n    }\n    return Promise.all(running);\n}\nfunction resolveTargetOptions(target, newOptions) {\n    if (!newOptions) {\n        return;\n    }\n    let options = target.options;\n    if (!options) {\n        target.options = newOptions;\n        return;\n    }\n    if (options.$shared) {\n        target.options = options = Object.assign({}, options, {\n            $shared: false,\n            $animations: {}\n        });\n    }\n    return options;\n}\n\nfunction scaleClip(scale, allowedOverflow) {\n    const opts = scale && scale.options || {};\n    const reverse = opts.reverse;\n    const min = opts.min === undefined ? allowedOverflow : 0;\n    const max = opts.max === undefined ? allowedOverflow : 0;\n    return {\n        start: reverse ? max : min,\n        end: reverse ? min : max\n    };\n}\nfunction defaultClip(xScale, yScale, allowedOverflow) {\n    if (allowedOverflow === false) {\n        return false;\n    }\n    const x = scaleClip(xScale, allowedOverflow);\n    const y = scaleClip(yScale, allowedOverflow);\n    return {\n        top: y.end,\n        right: x.end,\n        bottom: y.start,\n        left: x.start\n    };\n}\nfunction toClip(value) {\n    let t, r, b, l;\n    if ((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.i)(value)) {\n        t = value.top;\n        r = value.right;\n        b = value.bottom;\n        l = value.left;\n    } else {\n        t = r = b = l = value;\n    }\n    return {\n        top: t,\n        right: r,\n        bottom: b,\n        left: l,\n        disabled: value === false\n    };\n}\nfunction getSortedDatasetIndices(chart, filterVisible) {\n    const keys = [];\n    const metasets = chart._getSortedDatasetMetas(filterVisible);\n    let i, ilen;\n    for(i = 0, ilen = metasets.length; i < ilen; ++i){\n        keys.push(metasets[i].index);\n    }\n    return keys;\n}\nfunction applyStack(stack, value, dsIndex, options = {}) {\n    const keys = stack.keys;\n    const singleMode = options.mode === 'single';\n    let i, ilen, datasetIndex, otherValue;\n    if (value === null) {\n        return;\n    }\n    let found = false;\n    for(i = 0, ilen = keys.length; i < ilen; ++i){\n        datasetIndex = +keys[i];\n        if (datasetIndex === dsIndex) {\n            found = true;\n            if (options.all) {\n                continue;\n            }\n            break;\n        }\n        otherValue = stack.values[datasetIndex];\n        if ((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.g)(otherValue) && (singleMode || value === 0 || (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.s)(value) === (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.s)(otherValue))) {\n            value += otherValue;\n        }\n    }\n    if (!found && !options.all) {\n        return 0;\n    }\n    return value;\n}\nfunction convertObjectDataToArray(data, meta) {\n    const { iScale , vScale  } = meta;\n    const iAxisKey = iScale.axis === 'x' ? 'x' : 'y';\n    const vAxisKey = vScale.axis === 'x' ? 'x' : 'y';\n    const keys = Object.keys(data);\n    const adata = new Array(keys.length);\n    let i, ilen, key;\n    for(i = 0, ilen = keys.length; i < ilen; ++i){\n        key = keys[i];\n        adata[i] = {\n            [iAxisKey]: key,\n            [vAxisKey]: data[key]\n        };\n    }\n    return adata;\n}\nfunction isStacked(scale, meta) {\n    const stacked = scale && scale.options.stacked;\n    return stacked || stacked === undefined && meta.stack !== undefined;\n}\nfunction getStackKey(indexScale, valueScale, meta) {\n    return `${indexScale.id}.${valueScale.id}.${meta.stack || meta.type}`;\n}\nfunction getUserBounds(scale) {\n    const { min , max , minDefined , maxDefined  } = scale.getUserBounds();\n    return {\n        min: minDefined ? min : Number.NEGATIVE_INFINITY,\n        max: maxDefined ? max : Number.POSITIVE_INFINITY\n    };\n}\nfunction getOrCreateStack(stacks, stackKey, indexValue) {\n    const subStack = stacks[stackKey] || (stacks[stackKey] = {});\n    return subStack[indexValue] || (subStack[indexValue] = {});\n}\nfunction getLastIndexInStack(stack, vScale, positive, type) {\n    for (const meta of vScale.getMatchingVisibleMetas(type).reverse()){\n        const value = stack[meta.index];\n        if (positive && value > 0 || !positive && value < 0) {\n            return meta.index;\n        }\n    }\n    return null;\n}\nfunction updateStacks(controller, parsed) {\n    const { chart , _cachedMeta: meta  } = controller;\n    const stacks = chart._stacks || (chart._stacks = {});\n    const { iScale , vScale , index: datasetIndex  } = meta;\n    const iAxis = iScale.axis;\n    const vAxis = vScale.axis;\n    const key = getStackKey(iScale, vScale, meta);\n    const ilen = parsed.length;\n    let stack;\n    for(let i = 0; i < ilen; ++i){\n        const item = parsed[i];\n        const { [iAxis]: index , [vAxis]: value  } = item;\n        const itemStacks = item._stacks || (item._stacks = {});\n        stack = itemStacks[vAxis] = getOrCreateStack(stacks, key, index);\n        stack[datasetIndex] = value;\n        stack._top = getLastIndexInStack(stack, vScale, true, meta.type);\n        stack._bottom = getLastIndexInStack(stack, vScale, false, meta.type);\n        const visualValues = stack._visualValues || (stack._visualValues = {});\n        visualValues[datasetIndex] = value;\n    }\n}\nfunction getFirstScaleId(chart, axis) {\n    const scales = chart.scales;\n    return Object.keys(scales).filter((key)=>scales[key].axis === axis).shift();\n}\nfunction createDatasetContext(parent, index) {\n    return (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.j)(parent, {\n        active: false,\n        dataset: undefined,\n        datasetIndex: index,\n        index,\n        mode: 'default',\n        type: 'dataset'\n    });\n}\nfunction createDataContext(parent, index, element) {\n    return (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.j)(parent, {\n        active: false,\n        dataIndex: index,\n        parsed: undefined,\n        raw: undefined,\n        element,\n        index,\n        mode: 'default',\n        type: 'data'\n    });\n}\nfunction clearStacks(meta, items) {\n    const datasetIndex = meta.controller.index;\n    const axis = meta.vScale && meta.vScale.axis;\n    if (!axis) {\n        return;\n    }\n    items = items || meta._parsed;\n    for (const parsed of items){\n        const stacks = parsed._stacks;\n        if (!stacks || stacks[axis] === undefined || stacks[axis][datasetIndex] === undefined) {\n            return;\n        }\n        delete stacks[axis][datasetIndex];\n        if (stacks[axis]._visualValues !== undefined && stacks[axis]._visualValues[datasetIndex] !== undefined) {\n            delete stacks[axis]._visualValues[datasetIndex];\n        }\n    }\n}\nconst isDirectUpdateMode = (mode)=>mode === 'reset' || mode === 'none';\nconst cloneIfNotShared = (cached, shared)=>shared ? cached : Object.assign({}, cached);\nconst createStack = (canStack, meta, chart)=>canStack && !meta.hidden && meta._stacked && {\n        keys: getSortedDatasetIndices(chart, true),\n        values: null\n    };\nclass DatasetController {\n static defaults = {};\n static datasetElementType = null;\n static dataElementType = null;\n constructor(chart, datasetIndex){\n        this.chart = chart;\n        this._ctx = chart.ctx;\n        this.index = datasetIndex;\n        this._cachedDataOpts = {};\n        this._cachedMeta = this.getMeta();\n        this._type = this._cachedMeta.type;\n        this.options = undefined;\n         this._parsing = false;\n        this._data = undefined;\n        this._objectData = undefined;\n        this._sharedOptions = undefined;\n        this._drawStart = undefined;\n        this._drawCount = undefined;\n        this.enableOptionSharing = false;\n        this.supportsDecimation = false;\n        this.$context = undefined;\n        this._syncList = [];\n        this.datasetElementType = new.target.datasetElementType;\n        this.dataElementType = new.target.dataElementType;\n        this.initialize();\n    }\n    initialize() {\n        const meta = this._cachedMeta;\n        this.configure();\n        this.linkScales();\n        meta._stacked = isStacked(meta.vScale, meta);\n        this.addElements();\n        if (this.options.fill && !this.chart.isPluginEnabled('filler')) {\n            console.warn(\"Tried to use the 'fill' option without the 'Filler' plugin enabled. Please import and register the 'Filler' plugin and make sure it is not disabled in the options\");\n        }\n    }\n    updateIndex(datasetIndex) {\n        if (this.index !== datasetIndex) {\n            clearStacks(this._cachedMeta);\n        }\n        this.index = datasetIndex;\n    }\n    linkScales() {\n        const chart = this.chart;\n        const meta = this._cachedMeta;\n        const dataset = this.getDataset();\n        const chooseId = (axis, x, y, r)=>axis === 'x' ? x : axis === 'r' ? r : y;\n        const xid = meta.xAxisID = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.v)(dataset.xAxisID, getFirstScaleId(chart, 'x'));\n        const yid = meta.yAxisID = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.v)(dataset.yAxisID, getFirstScaleId(chart, 'y'));\n        const rid = meta.rAxisID = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.v)(dataset.rAxisID, getFirstScaleId(chart, 'r'));\n        const indexAxis = meta.indexAxis;\n        const iid = meta.iAxisID = chooseId(indexAxis, xid, yid, rid);\n        const vid = meta.vAxisID = chooseId(indexAxis, yid, xid, rid);\n        meta.xScale = this.getScaleForId(xid);\n        meta.yScale = this.getScaleForId(yid);\n        meta.rScale = this.getScaleForId(rid);\n        meta.iScale = this.getScaleForId(iid);\n        meta.vScale = this.getScaleForId(vid);\n    }\n    getDataset() {\n        return this.chart.data.datasets[this.index];\n    }\n    getMeta() {\n        return this.chart.getDatasetMeta(this.index);\n    }\n getScaleForId(scaleID) {\n        return this.chart.scales[scaleID];\n    }\n _getOtherScale(scale) {\n        const meta = this._cachedMeta;\n        return scale === meta.iScale ? meta.vScale : meta.iScale;\n    }\n    reset() {\n        this._update('reset');\n    }\n _destroy() {\n        const meta = this._cachedMeta;\n        if (this._data) {\n            (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.u)(this._data, this);\n        }\n        if (meta._stacked) {\n            clearStacks(meta);\n        }\n    }\n _dataCheck() {\n        const dataset = this.getDataset();\n        const data = dataset.data || (dataset.data = []);\n        const _data = this._data;\n        if ((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.i)(data)) {\n            const meta = this._cachedMeta;\n            this._data = convertObjectDataToArray(data, meta);\n        } else if (_data !== data) {\n            if (_data) {\n                (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.u)(_data, this);\n                const meta = this._cachedMeta;\n                clearStacks(meta);\n                meta._parsed = [];\n            }\n            if (data && Object.isExtensible(data)) {\n                (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.l)(data, this);\n            }\n            this._syncList = [];\n            this._data = data;\n        }\n    }\n    addElements() {\n        const meta = this._cachedMeta;\n        this._dataCheck();\n        if (this.datasetElementType) {\n            meta.dataset = new this.datasetElementType();\n        }\n    }\n    buildOrUpdateElements(resetNewElements) {\n        const meta = this._cachedMeta;\n        const dataset = this.getDataset();\n        let stackChanged = false;\n        this._dataCheck();\n        const oldStacked = meta._stacked;\n        meta._stacked = isStacked(meta.vScale, meta);\n        if (meta.stack !== dataset.stack) {\n            stackChanged = true;\n            clearStacks(meta);\n            meta.stack = dataset.stack;\n        }\n        this._resyncElements(resetNewElements);\n        if (stackChanged || oldStacked !== meta._stacked) {\n            updateStacks(this, meta._parsed);\n            meta._stacked = isStacked(meta.vScale, meta);\n        }\n    }\n configure() {\n        const config = this.chart.config;\n        const scopeKeys = config.datasetScopeKeys(this._type);\n        const scopes = config.getOptionScopes(this.getDataset(), scopeKeys, true);\n        this.options = config.createResolver(scopes, this.getContext());\n        this._parsing = this.options.parsing;\n        this._cachedDataOpts = {};\n    }\n parse(start, count) {\n        const { _cachedMeta: meta , _data: data  } = this;\n        const { iScale , _stacked  } = meta;\n        const iAxis = iScale.axis;\n        let sorted = start === 0 && count === data.length ? true : meta._sorted;\n        let prev = start > 0 && meta._parsed[start - 1];\n        let i, cur, parsed;\n        if (this._parsing === false) {\n            meta._parsed = data;\n            meta._sorted = true;\n            parsed = data;\n        } else {\n            if ((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.b)(data[start])) {\n                parsed = this.parseArrayData(meta, data, start, count);\n            } else if ((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.i)(data[start])) {\n                parsed = this.parseObjectData(meta, data, start, count);\n            } else {\n                parsed = this.parsePrimitiveData(meta, data, start, count);\n            }\n            const isNotInOrderComparedToPrev = ()=>cur[iAxis] === null || prev && cur[iAxis] < prev[iAxis];\n            for(i = 0; i < count; ++i){\n                meta._parsed[i + start] = cur = parsed[i];\n                if (sorted) {\n                    if (isNotInOrderComparedToPrev()) {\n                        sorted = false;\n                    }\n                    prev = cur;\n                }\n            }\n            meta._sorted = sorted;\n        }\n        if (_stacked) {\n            updateStacks(this, parsed);\n        }\n    }\n parsePrimitiveData(meta, data, start, count) {\n        const { iScale , vScale  } = meta;\n        const iAxis = iScale.axis;\n        const vAxis = vScale.axis;\n        const labels = iScale.getLabels();\n        const singleScale = iScale === vScale;\n        const parsed = new Array(count);\n        let i, ilen, index;\n        for(i = 0, ilen = count; i < ilen; ++i){\n            index = i + start;\n            parsed[i] = {\n                [iAxis]: singleScale || iScale.parse(labels[index], index),\n                [vAxis]: vScale.parse(data[index], index)\n            };\n        }\n        return parsed;\n    }\n parseArrayData(meta, data, start, count) {\n        const { xScale , yScale  } = meta;\n        const parsed = new Array(count);\n        let i, ilen, index, item;\n        for(i = 0, ilen = count; i < ilen; ++i){\n            index = i + start;\n            item = data[index];\n            parsed[i] = {\n                x: xScale.parse(item[0], index),\n                y: yScale.parse(item[1], index)\n            };\n        }\n        return parsed;\n    }\n parseObjectData(meta, data, start, count) {\n        const { xScale , yScale  } = meta;\n        const { xAxisKey ='x' , yAxisKey ='y'  } = this._parsing;\n        const parsed = new Array(count);\n        let i, ilen, index, item;\n        for(i = 0, ilen = count; i < ilen; ++i){\n            index = i + start;\n            item = data[index];\n            parsed[i] = {\n                x: xScale.parse((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.f)(item, xAxisKey), index),\n                y: yScale.parse((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.f)(item, yAxisKey), index)\n            };\n        }\n        return parsed;\n    }\n getParsed(index) {\n        return this._cachedMeta._parsed[index];\n    }\n getDataElement(index) {\n        return this._cachedMeta.data[index];\n    }\n applyStack(scale, parsed, mode) {\n        const chart = this.chart;\n        const meta = this._cachedMeta;\n        const value = parsed[scale.axis];\n        const stack = {\n            keys: getSortedDatasetIndices(chart, true),\n            values: parsed._stacks[scale.axis]._visualValues\n        };\n        return applyStack(stack, value, meta.index, {\n            mode\n        });\n    }\n updateRangeFromParsed(range, scale, parsed, stack) {\n        const parsedValue = parsed[scale.axis];\n        let value = parsedValue === null ? NaN : parsedValue;\n        const values = stack && parsed._stacks[scale.axis];\n        if (stack && values) {\n            stack.values = values;\n            value = applyStack(stack, parsedValue, this._cachedMeta.index);\n        }\n        range.min = Math.min(range.min, value);\n        range.max = Math.max(range.max, value);\n    }\n getMinMax(scale, canStack) {\n        const meta = this._cachedMeta;\n        const _parsed = meta._parsed;\n        const sorted = meta._sorted && scale === meta.iScale;\n        const ilen = _parsed.length;\n        const otherScale = this._getOtherScale(scale);\n        const stack = createStack(canStack, meta, this.chart);\n        const range = {\n            min: Number.POSITIVE_INFINITY,\n            max: Number.NEGATIVE_INFINITY\n        };\n        const { min: otherMin , max: otherMax  } = getUserBounds(otherScale);\n        let i, parsed;\n        function _skip() {\n            parsed = _parsed[i];\n            const otherValue = parsed[otherScale.axis];\n            return !(0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.g)(parsed[scale.axis]) || otherMin > otherValue || otherMax < otherValue;\n        }\n        for(i = 0; i < ilen; ++i){\n            if (_skip()) {\n                continue;\n            }\n            this.updateRangeFromParsed(range, scale, parsed, stack);\n            if (sorted) {\n                break;\n            }\n        }\n        if (sorted) {\n            for(i = ilen - 1; i >= 0; --i){\n                if (_skip()) {\n                    continue;\n                }\n                this.updateRangeFromParsed(range, scale, parsed, stack);\n                break;\n            }\n        }\n        return range;\n    }\n    getAllParsedValues(scale) {\n        const parsed = this._cachedMeta._parsed;\n        const values = [];\n        let i, ilen, value;\n        for(i = 0, ilen = parsed.length; i < ilen; ++i){\n            value = parsed[i][scale.axis];\n            if ((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.g)(value)) {\n                values.push(value);\n            }\n        }\n        return values;\n    }\n getMaxOverflow() {\n        return false;\n    }\n getLabelAndValue(index) {\n        const meta = this._cachedMeta;\n        const iScale = meta.iScale;\n        const vScale = meta.vScale;\n        const parsed = this.getParsed(index);\n        return {\n            label: iScale ? '' + iScale.getLabelForValue(parsed[iScale.axis]) : '',\n            value: vScale ? '' + vScale.getLabelForValue(parsed[vScale.axis]) : ''\n        };\n    }\n _update(mode) {\n        const meta = this._cachedMeta;\n        this.update(mode || 'default');\n        meta._clip = toClip((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.v)(this.options.clip, defaultClip(meta.xScale, meta.yScale, this.getMaxOverflow())));\n    }\n update(mode) {}\n    draw() {\n        const ctx = this._ctx;\n        const chart = this.chart;\n        const meta = this._cachedMeta;\n        const elements = meta.data || [];\n        const area = chart.chartArea;\n        const active = [];\n        const start = this._drawStart || 0;\n        const count = this._drawCount || elements.length - start;\n        const drawActiveElementsOnTop = this.options.drawActiveElementsOnTop;\n        let i;\n        if (meta.dataset) {\n            meta.dataset.draw(ctx, area, start, count);\n        }\n        for(i = start; i < start + count; ++i){\n            const element = elements[i];\n            if (element.hidden) {\n                continue;\n            }\n            if (element.active && drawActiveElementsOnTop) {\n                active.push(element);\n            } else {\n                element.draw(ctx, area);\n            }\n        }\n        for(i = 0; i < active.length; ++i){\n            active[i].draw(ctx, area);\n        }\n    }\n getStyle(index, active) {\n        const mode = active ? 'active' : 'default';\n        return index === undefined && this._cachedMeta.dataset ? this.resolveDatasetElementOptions(mode) : this.resolveDataElementOptions(index || 0, mode);\n    }\n getContext(index, active, mode) {\n        const dataset = this.getDataset();\n        let context;\n        if (index >= 0 && index < this._cachedMeta.data.length) {\n            const element = this._cachedMeta.data[index];\n            context = element.$context || (element.$context = createDataContext(this.getContext(), index, element));\n            context.parsed = this.getParsed(index);\n            context.raw = dataset.data[index];\n            context.index = context.dataIndex = index;\n        } else {\n            context = this.$context || (this.$context = createDatasetContext(this.chart.getContext(), this.index));\n            context.dataset = dataset;\n            context.index = context.datasetIndex = this.index;\n        }\n        context.active = !!active;\n        context.mode = mode;\n        return context;\n    }\n resolveDatasetElementOptions(mode) {\n        return this._resolveElementOptions(this.datasetElementType.id, mode);\n    }\n resolveDataElementOptions(index, mode) {\n        return this._resolveElementOptions(this.dataElementType.id, mode, index);\n    }\n _resolveElementOptions(elementType, mode = 'default', index) {\n        const active = mode === 'active';\n        const cache = this._cachedDataOpts;\n        const cacheKey = elementType + '-' + mode;\n        const cached = cache[cacheKey];\n        const sharing = this.enableOptionSharing && (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.h)(index);\n        if (cached) {\n            return cloneIfNotShared(cached, sharing);\n        }\n        const config = this.chart.config;\n        const scopeKeys = config.datasetElementScopeKeys(this._type, elementType);\n        const prefixes = active ? [\n            `${elementType}Hover`,\n            'hover',\n            elementType,\n            ''\n        ] : [\n            elementType,\n            ''\n        ];\n        const scopes = config.getOptionScopes(this.getDataset(), scopeKeys);\n        const names = Object.keys(_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.d.elements[elementType]);\n        const context = ()=>this.getContext(index, active, mode);\n        const values = config.resolveNamedOptions(scopes, names, context, prefixes);\n        if (values.$shared) {\n            values.$shared = sharing;\n            cache[cacheKey] = Object.freeze(cloneIfNotShared(values, sharing));\n        }\n        return values;\n    }\n _resolveAnimations(index, transition, active) {\n        const chart = this.chart;\n        const cache = this._cachedDataOpts;\n        const cacheKey = `animation-${transition}`;\n        const cached = cache[cacheKey];\n        if (cached) {\n            return cached;\n        }\n        let options;\n        if (chart.options.animation !== false) {\n            const config = this.chart.config;\n            const scopeKeys = config.datasetAnimationScopeKeys(this._type, transition);\n            const scopes = config.getOptionScopes(this.getDataset(), scopeKeys);\n            options = config.createResolver(scopes, this.getContext(index, active, transition));\n        }\n        const animations = new Animations(chart, options && options.animations);\n        if (options && options._cacheable) {\n            cache[cacheKey] = Object.freeze(animations);\n        }\n        return animations;\n    }\n getSharedOptions(options) {\n        if (!options.$shared) {\n            return;\n        }\n        return this._sharedOptions || (this._sharedOptions = Object.assign({}, options));\n    }\n includeOptions(mode, sharedOptions) {\n        return !sharedOptions || isDirectUpdateMode(mode) || this.chart._animationsDisabled;\n    }\n _getSharedOptions(start, mode) {\n        const firstOpts = this.resolveDataElementOptions(start, mode);\n        const previouslySharedOptions = this._sharedOptions;\n        const sharedOptions = this.getSharedOptions(firstOpts);\n        const includeOptions = this.includeOptions(mode, sharedOptions) || sharedOptions !== previouslySharedOptions;\n        this.updateSharedOptions(sharedOptions, mode, firstOpts);\n        return {\n            sharedOptions,\n            includeOptions\n        };\n    }\n updateElement(element, index, properties, mode) {\n        if (isDirectUpdateMode(mode)) {\n            Object.assign(element, properties);\n        } else {\n            this._resolveAnimations(index, mode).update(element, properties);\n        }\n    }\n updateSharedOptions(sharedOptions, mode, newOptions) {\n        if (sharedOptions && !isDirectUpdateMode(mode)) {\n            this._resolveAnimations(undefined, mode).update(sharedOptions, newOptions);\n        }\n    }\n _setStyle(element, index, mode, active) {\n        element.active = active;\n        const options = this.getStyle(index, active);\n        this._resolveAnimations(index, mode, active).update(element, {\n            options: !active && this.getSharedOptions(options) || options\n        });\n    }\n    removeHoverStyle(element, datasetIndex, index) {\n        this._setStyle(element, index, 'active', false);\n    }\n    setHoverStyle(element, datasetIndex, index) {\n        this._setStyle(element, index, 'active', true);\n    }\n _removeDatasetHoverStyle() {\n        const element = this._cachedMeta.dataset;\n        if (element) {\n            this._setStyle(element, undefined, 'active', false);\n        }\n    }\n _setDatasetHoverStyle() {\n        const element = this._cachedMeta.dataset;\n        if (element) {\n            this._setStyle(element, undefined, 'active', true);\n        }\n    }\n _resyncElements(resetNewElements) {\n        const data = this._data;\n        const elements = this._cachedMeta.data;\n        for (const [method, arg1, arg2] of this._syncList){\n            this[method](arg1, arg2);\n        }\n        this._syncList = [];\n        const numMeta = elements.length;\n        const numData = data.length;\n        const count = Math.min(numData, numMeta);\n        if (count) {\n            this.parse(0, count);\n        }\n        if (numData > numMeta) {\n            this._insertElements(numMeta, numData - numMeta, resetNewElements);\n        } else if (numData < numMeta) {\n            this._removeElements(numData, numMeta - numData);\n        }\n    }\n _insertElements(start, count, resetNewElements = true) {\n        const meta = this._cachedMeta;\n        const data = meta.data;\n        const end = start + count;\n        let i;\n        const move = (arr)=>{\n            arr.length += count;\n            for(i = arr.length - 1; i >= end; i--){\n                arr[i] = arr[i - count];\n            }\n        };\n        move(data);\n        for(i = start; i < end; ++i){\n            data[i] = new this.dataElementType();\n        }\n        if (this._parsing) {\n            move(meta._parsed);\n        }\n        this.parse(start, count);\n        if (resetNewElements) {\n            this.updateElements(data, start, count, 'reset');\n        }\n    }\n    updateElements(element, start, count, mode) {}\n _removeElements(start, count) {\n        const meta = this._cachedMeta;\n        if (this._parsing) {\n            const removed = meta._parsed.splice(start, count);\n            if (meta._stacked) {\n                clearStacks(meta, removed);\n            }\n        }\n        meta.data.splice(start, count);\n    }\n _sync(args) {\n        if (this._parsing) {\n            this._syncList.push(args);\n        } else {\n            const [method, arg1, arg2] = args;\n            this[method](arg1, arg2);\n        }\n        this.chart._dataChanges.push([\n            this.index,\n            ...args\n        ]);\n    }\n    _onDataPush() {\n        const count = arguments.length;\n        this._sync([\n            '_insertElements',\n            this.getDataset().data.length - count,\n            count\n        ]);\n    }\n    _onDataPop() {\n        this._sync([\n            '_removeElements',\n            this._cachedMeta.data.length - 1,\n            1\n        ]);\n    }\n    _onDataShift() {\n        this._sync([\n            '_removeElements',\n            0,\n            1\n        ]);\n    }\n    _onDataSplice(start, count) {\n        if (count) {\n            this._sync([\n                '_removeElements',\n                start,\n                count\n            ]);\n        }\n        const newCount = arguments.length - 2;\n        if (newCount) {\n            this._sync([\n                '_insertElements',\n                start,\n                newCount\n            ]);\n        }\n    }\n    _onDataUnshift() {\n        this._sync([\n            '_insertElements',\n            0,\n            arguments.length\n        ]);\n    }\n}\n\nfunction getAllScaleValues(scale, type) {\n    if (!scale._cache.$bar) {\n        const visibleMetas = scale.getMatchingVisibleMetas(type);\n        let values = [];\n        for(let i = 0, ilen = visibleMetas.length; i < ilen; i++){\n            values = values.concat(visibleMetas[i].controller.getAllParsedValues(scale));\n        }\n        scale._cache.$bar = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__._)(values.sort((a, b)=>a - b));\n    }\n    return scale._cache.$bar;\n}\n function computeMinSampleSize(meta) {\n    const scale = meta.iScale;\n    const values = getAllScaleValues(scale, meta.type);\n    let min = scale._length;\n    let i, ilen, curr, prev;\n    const updateMinAndPrev = ()=>{\n        if (curr === 32767 || curr === -32768) {\n            return;\n        }\n        if ((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.h)(prev)) {\n            min = Math.min(min, Math.abs(curr - prev) || min);\n        }\n        prev = curr;\n    };\n    for(i = 0, ilen = values.length; i < ilen; ++i){\n        curr = scale.getPixelForValue(values[i]);\n        updateMinAndPrev();\n    }\n    prev = undefined;\n    for(i = 0, ilen = scale.ticks.length; i < ilen; ++i){\n        curr = scale.getPixelForTick(i);\n        updateMinAndPrev();\n    }\n    return min;\n}\n function computeFitCategoryTraits(index, ruler, options, stackCount) {\n    const thickness = options.barThickness;\n    let size, ratio;\n    if ((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.k)(thickness)) {\n        size = ruler.min * options.categoryPercentage;\n        ratio = options.barPercentage;\n    } else {\n        size = thickness * stackCount;\n        ratio = 1;\n    }\n    return {\n        chunk: size / stackCount,\n        ratio,\n        start: ruler.pixels[index] - size / 2\n    };\n}\n function computeFlexCategoryTraits(index, ruler, options, stackCount) {\n    const pixels = ruler.pixels;\n    const curr = pixels[index];\n    let prev = index > 0 ? pixels[index - 1] : null;\n    let next = index < pixels.length - 1 ? pixels[index + 1] : null;\n    const percent = options.categoryPercentage;\n    if (prev === null) {\n        prev = curr - (next === null ? ruler.end - ruler.start : next - curr);\n    }\n    if (next === null) {\n        next = curr + curr - prev;\n    }\n    const start = curr - (curr - Math.min(prev, next)) / 2 * percent;\n    const size = Math.abs(next - prev) / 2 * percent;\n    return {\n        chunk: size / stackCount,\n        ratio: options.barPercentage,\n        start\n    };\n}\nfunction parseFloatBar(entry, item, vScale, i) {\n    const startValue = vScale.parse(entry[0], i);\n    const endValue = vScale.parse(entry[1], i);\n    const min = Math.min(startValue, endValue);\n    const max = Math.max(startValue, endValue);\n    let barStart = min;\n    let barEnd = max;\n    if (Math.abs(min) > Math.abs(max)) {\n        barStart = max;\n        barEnd = min;\n    }\n    item[vScale.axis] = barEnd;\n    item._custom = {\n        barStart,\n        barEnd,\n        start: startValue,\n        end: endValue,\n        min,\n        max\n    };\n}\nfunction parseValue(entry, item, vScale, i) {\n    if ((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.b)(entry)) {\n        parseFloatBar(entry, item, vScale, i);\n    } else {\n        item[vScale.axis] = vScale.parse(entry, i);\n    }\n    return item;\n}\nfunction parseArrayOrPrimitive(meta, data, start, count) {\n    const iScale = meta.iScale;\n    const vScale = meta.vScale;\n    const labels = iScale.getLabels();\n    const singleScale = iScale === vScale;\n    const parsed = [];\n    let i, ilen, item, entry;\n    for(i = start, ilen = start + count; i < ilen; ++i){\n        entry = data[i];\n        item = {};\n        item[iScale.axis] = singleScale || iScale.parse(labels[i], i);\n        parsed.push(parseValue(entry, item, vScale, i));\n    }\n    return parsed;\n}\nfunction isFloatBar(custom) {\n    return custom && custom.barStart !== undefined && custom.barEnd !== undefined;\n}\nfunction barSign(size, vScale, actualBase) {\n    if (size !== 0) {\n        return (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.s)(size);\n    }\n    return (vScale.isHorizontal() ? 1 : -1) * (vScale.min >= actualBase ? 1 : -1);\n}\nfunction borderProps(properties) {\n    let reverse, start, end, top, bottom;\n    if (properties.horizontal) {\n        reverse = properties.base > properties.x;\n        start = 'left';\n        end = 'right';\n    } else {\n        reverse = properties.base < properties.y;\n        start = 'bottom';\n        end = 'top';\n    }\n    if (reverse) {\n        top = 'end';\n        bottom = 'start';\n    } else {\n        top = 'start';\n        bottom = 'end';\n    }\n    return {\n        start,\n        end,\n        reverse,\n        top,\n        bottom\n    };\n}\nfunction setBorderSkipped(properties, options, stack, index) {\n    let edge = options.borderSkipped;\n    const res = {};\n    if (!edge) {\n        properties.borderSkipped = res;\n        return;\n    }\n    if (edge === true) {\n        properties.borderSkipped = {\n            top: true,\n            right: true,\n            bottom: true,\n            left: true\n        };\n        return;\n    }\n    const { start , end , reverse , top , bottom  } = borderProps(properties);\n    if (edge === 'middle' && stack) {\n        properties.enableBorderRadius = true;\n        if ((stack._top || 0) === index) {\n            edge = top;\n        } else if ((stack._bottom || 0) === index) {\n            edge = bottom;\n        } else {\n            res[parseEdge(bottom, start, end, reverse)] = true;\n            edge = top;\n        }\n    }\n    res[parseEdge(edge, start, end, reverse)] = true;\n    properties.borderSkipped = res;\n}\nfunction parseEdge(edge, a, b, reverse) {\n    if (reverse) {\n        edge = swap(edge, a, b);\n        edge = startEnd(edge, b, a);\n    } else {\n        edge = startEnd(edge, a, b);\n    }\n    return edge;\n}\nfunction swap(orig, v1, v2) {\n    return orig === v1 ? v2 : orig === v2 ? v1 : orig;\n}\nfunction startEnd(v, start, end) {\n    return v === 'start' ? start : v === 'end' ? end : v;\n}\nfunction setInflateAmount(properties, { inflateAmount  }, ratio) {\n    properties.inflateAmount = inflateAmount === 'auto' ? ratio === 1 ? 0.33 : 0 : inflateAmount;\n}\nclass BarController extends DatasetController {\n    static id = 'bar';\n static defaults = {\n        datasetElementType: false,\n        dataElementType: 'bar',\n        categoryPercentage: 0.8,\n        barPercentage: 0.9,\n        grouped: true,\n        animations: {\n            numbers: {\n                type: 'number',\n                properties: [\n                    'x',\n                    'y',\n                    'base',\n                    'width',\n                    'height'\n                ]\n            }\n        }\n    };\n static overrides = {\n        scales: {\n            _index_: {\n                type: 'category',\n                offset: true,\n                grid: {\n                    offset: true\n                }\n            },\n            _value_: {\n                type: 'linear',\n                beginAtZero: true\n            }\n        }\n    };\n parsePrimitiveData(meta, data, start, count) {\n        return parseArrayOrPrimitive(meta, data, start, count);\n    }\n parseArrayData(meta, data, start, count) {\n        return parseArrayOrPrimitive(meta, data, start, count);\n    }\n parseObjectData(meta, data, start, count) {\n        const { iScale , vScale  } = meta;\n        const { xAxisKey ='x' , yAxisKey ='y'  } = this._parsing;\n        const iAxisKey = iScale.axis === 'x' ? xAxisKey : yAxisKey;\n        const vAxisKey = vScale.axis === 'x' ? xAxisKey : yAxisKey;\n        const parsed = [];\n        let i, ilen, item, obj;\n        for(i = start, ilen = start + count; i < ilen; ++i){\n            obj = data[i];\n            item = {};\n            item[iScale.axis] = iScale.parse((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.f)(obj, iAxisKey), i);\n            parsed.push(parseValue((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.f)(obj, vAxisKey), item, vScale, i));\n        }\n        return parsed;\n    }\n updateRangeFromParsed(range, scale, parsed, stack) {\n        super.updateRangeFromParsed(range, scale, parsed, stack);\n        const custom = parsed._custom;\n        if (custom && scale === this._cachedMeta.vScale) {\n            range.min = Math.min(range.min, custom.min);\n            range.max = Math.max(range.max, custom.max);\n        }\n    }\n getMaxOverflow() {\n        return 0;\n    }\n getLabelAndValue(index) {\n        const meta = this._cachedMeta;\n        const { iScale , vScale  } = meta;\n        const parsed = this.getParsed(index);\n        const custom = parsed._custom;\n        const value = isFloatBar(custom) ? '[' + custom.start + ', ' + custom.end + ']' : '' + vScale.getLabelForValue(parsed[vScale.axis]);\n        return {\n            label: '' + iScale.getLabelForValue(parsed[iScale.axis]),\n            value\n        };\n    }\n    initialize() {\n        this.enableOptionSharing = true;\n        super.initialize();\n        const meta = this._cachedMeta;\n        meta.stack = this.getDataset().stack;\n    }\n    update(mode) {\n        const meta = this._cachedMeta;\n        this.updateElements(meta.data, 0, meta.data.length, mode);\n    }\n    updateElements(bars, start, count, mode) {\n        const reset = mode === 'reset';\n        const { index , _cachedMeta: { vScale  }  } = this;\n        const base = vScale.getBasePixel();\n        const horizontal = vScale.isHorizontal();\n        const ruler = this._getRuler();\n        const { sharedOptions , includeOptions  } = this._getSharedOptions(start, mode);\n        for(let i = start; i < start + count; i++){\n            const parsed = this.getParsed(i);\n            const vpixels = reset || (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.k)(parsed[vScale.axis]) ? {\n                base,\n                head: base\n            } : this._calculateBarValuePixels(i);\n            const ipixels = this._calculateBarIndexPixels(i, ruler);\n            const stack = (parsed._stacks || {})[vScale.axis];\n            const properties = {\n                horizontal,\n                base: vpixels.base,\n                enableBorderRadius: !stack || isFloatBar(parsed._custom) || index === stack._top || index === stack._bottom,\n                x: horizontal ? vpixels.head : ipixels.center,\n                y: horizontal ? ipixels.center : vpixels.head,\n                height: horizontal ? ipixels.size : Math.abs(vpixels.size),\n                width: horizontal ? Math.abs(vpixels.size) : ipixels.size\n            };\n            if (includeOptions) {\n                properties.options = sharedOptions || this.resolveDataElementOptions(i, bars[i].active ? 'active' : mode);\n            }\n            const options = properties.options || bars[i].options;\n            setBorderSkipped(properties, options, stack, index);\n            setInflateAmount(properties, options, ruler.ratio);\n            this.updateElement(bars[i], i, properties, mode);\n        }\n    }\n _getStacks(last, dataIndex) {\n        const { iScale  } = this._cachedMeta;\n        const metasets = iScale.getMatchingVisibleMetas(this._type).filter((meta)=>meta.controller.options.grouped);\n        const stacked = iScale.options.stacked;\n        const stacks = [];\n        const currentParsed = this._cachedMeta.controller.getParsed(dataIndex);\n        const iScaleValue = currentParsed && currentParsed[iScale.axis];\n        const skipNull = (meta)=>{\n            const parsed = meta._parsed.find((item)=>item[iScale.axis] === iScaleValue);\n            const val = parsed && parsed[meta.vScale.axis];\n            if ((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.k)(val) || isNaN(val)) {\n                return true;\n            }\n        };\n        for (const meta of metasets){\n            if (dataIndex !== undefined && skipNull(meta)) {\n                continue;\n            }\n            if (stacked === false || stacks.indexOf(meta.stack) === -1 || stacked === undefined && meta.stack === undefined) {\n                stacks.push(meta.stack);\n            }\n            if (meta.index === last) {\n                break;\n            }\n        }\n        if (!stacks.length) {\n            stacks.push(undefined);\n        }\n        return stacks;\n    }\n _getStackCount(index) {\n        return this._getStacks(undefined, index).length;\n    }\n _getStackIndex(datasetIndex, name, dataIndex) {\n        const stacks = this._getStacks(datasetIndex, dataIndex);\n        const index = name !== undefined ? stacks.indexOf(name) : -1;\n        return index === -1 ? stacks.length - 1 : index;\n    }\n _getRuler() {\n        const opts = this.options;\n        const meta = this._cachedMeta;\n        const iScale = meta.iScale;\n        const pixels = [];\n        let i, ilen;\n        for(i = 0, ilen = meta.data.length; i < ilen; ++i){\n            pixels.push(iScale.getPixelForValue(this.getParsed(i)[iScale.axis], i));\n        }\n        const barThickness = opts.barThickness;\n        const min = barThickness || computeMinSampleSize(meta);\n        return {\n            min,\n            pixels,\n            start: iScale._startPixel,\n            end: iScale._endPixel,\n            stackCount: this._getStackCount(),\n            scale: iScale,\n            grouped: opts.grouped,\n            ratio: barThickness ? 1 : opts.categoryPercentage * opts.barPercentage\n        };\n    }\n _calculateBarValuePixels(index) {\n        const { _cachedMeta: { vScale , _stacked , index: datasetIndex  } , options: { base: baseValue , minBarLength  }  } = this;\n        const actualBase = baseValue || 0;\n        const parsed = this.getParsed(index);\n        const custom = parsed._custom;\n        const floating = isFloatBar(custom);\n        let value = parsed[vScale.axis];\n        let start = 0;\n        let length = _stacked ? this.applyStack(vScale, parsed, _stacked) : value;\n        let head, size;\n        if (length !== value) {\n            start = length - value;\n            length = value;\n        }\n        if (floating) {\n            value = custom.barStart;\n            length = custom.barEnd - custom.barStart;\n            if (value !== 0 && (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.s)(value) !== (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.s)(custom.barEnd)) {\n                start = 0;\n            }\n            start += value;\n        }\n        const startValue = !(0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.k)(baseValue) && !floating ? baseValue : start;\n        let base = vScale.getPixelForValue(startValue);\n        if (this.chart.getDataVisibility(index)) {\n            head = vScale.getPixelForValue(start + length);\n        } else {\n            head = base;\n        }\n        size = head - base;\n        if (Math.abs(size) < minBarLength) {\n            size = barSign(size, vScale, actualBase) * minBarLength;\n            if (value === actualBase) {\n                base -= size / 2;\n            }\n            const startPixel = vScale.getPixelForDecimal(0);\n            const endPixel = vScale.getPixelForDecimal(1);\n            const min = Math.min(startPixel, endPixel);\n            const max = Math.max(startPixel, endPixel);\n            base = Math.max(Math.min(base, max), min);\n            head = base + size;\n            if (_stacked && !floating) {\n                parsed._stacks[vScale.axis]._visualValues[datasetIndex] = vScale.getValueForPixel(head) - vScale.getValueForPixel(base);\n            }\n        }\n        if (base === vScale.getPixelForValue(actualBase)) {\n            const halfGrid = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.s)(size) * vScale.getLineWidthForValue(actualBase) / 2;\n            base += halfGrid;\n            size -= halfGrid;\n        }\n        return {\n            size,\n            base,\n            head,\n            center: head + size / 2\n        };\n    }\n _calculateBarIndexPixels(index, ruler) {\n        const scale = ruler.scale;\n        const options = this.options;\n        const skipNull = options.skipNull;\n        const maxBarThickness = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.v)(options.maxBarThickness, Infinity);\n        let center, size;\n        if (ruler.grouped) {\n            const stackCount = skipNull ? this._getStackCount(index) : ruler.stackCount;\n            const range = options.barThickness === 'flex' ? computeFlexCategoryTraits(index, ruler, options, stackCount) : computeFitCategoryTraits(index, ruler, options, stackCount);\n            const stackIndex = this._getStackIndex(this.index, this._cachedMeta.stack, skipNull ? index : undefined);\n            center = range.start + range.chunk * stackIndex + range.chunk / 2;\n            size = Math.min(maxBarThickness, range.chunk * range.ratio);\n        } else {\n            center = scale.getPixelForValue(this.getParsed(index)[scale.axis], index);\n            size = Math.min(maxBarThickness, ruler.min * ruler.ratio);\n        }\n        return {\n            base: center - size / 2,\n            head: center + size / 2,\n            center,\n            size\n        };\n    }\n    draw() {\n        const meta = this._cachedMeta;\n        const vScale = meta.vScale;\n        const rects = meta.data;\n        const ilen = rects.length;\n        let i = 0;\n        for(; i < ilen; ++i){\n            if (this.getParsed(i)[vScale.axis] !== null && !rects[i].hidden) {\n                rects[i].draw(this._ctx);\n            }\n        }\n    }\n}\n\nclass BubbleController extends DatasetController {\n    static id = 'bubble';\n static defaults = {\n        datasetElementType: false,\n        dataElementType: 'point',\n        animations: {\n            numbers: {\n                type: 'number',\n                properties: [\n                    'x',\n                    'y',\n                    'borderWidth',\n                    'radius'\n                ]\n            }\n        }\n    };\n static overrides = {\n        scales: {\n            x: {\n                type: 'linear'\n            },\n            y: {\n                type: 'linear'\n            }\n        }\n    };\n    initialize() {\n        this.enableOptionSharing = true;\n        super.initialize();\n    }\n parsePrimitiveData(meta, data, start, count) {\n        const parsed = super.parsePrimitiveData(meta, data, start, count);\n        for(let i = 0; i < parsed.length; i++){\n            parsed[i]._custom = this.resolveDataElementOptions(i + start).radius;\n        }\n        return parsed;\n    }\n parseArrayData(meta, data, start, count) {\n        const parsed = super.parseArrayData(meta, data, start, count);\n        for(let i = 0; i < parsed.length; i++){\n            const item = data[start + i];\n            parsed[i]._custom = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.v)(item[2], this.resolveDataElementOptions(i + start).radius);\n        }\n        return parsed;\n    }\n parseObjectData(meta, data, start, count) {\n        const parsed = super.parseObjectData(meta, data, start, count);\n        for(let i = 0; i < parsed.length; i++){\n            const item = data[start + i];\n            parsed[i]._custom = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.v)(item && item.r && +item.r, this.resolveDataElementOptions(i + start).radius);\n        }\n        return parsed;\n    }\n getMaxOverflow() {\n        const data = this._cachedMeta.data;\n        let max = 0;\n        for(let i = data.length - 1; i >= 0; --i){\n            max = Math.max(max, data[i].size(this.resolveDataElementOptions(i)) / 2);\n        }\n        return max > 0 && max;\n    }\n getLabelAndValue(index) {\n        const meta = this._cachedMeta;\n        const labels = this.chart.data.labels || [];\n        const { xScale , yScale  } = meta;\n        const parsed = this.getParsed(index);\n        const x = xScale.getLabelForValue(parsed.x);\n        const y = yScale.getLabelForValue(parsed.y);\n        const r = parsed._custom;\n        return {\n            label: labels[index] || '',\n            value: '(' + x + ', ' + y + (r ? ', ' + r : '') + ')'\n        };\n    }\n    update(mode) {\n        const points = this._cachedMeta.data;\n        this.updateElements(points, 0, points.length, mode);\n    }\n    updateElements(points, start, count, mode) {\n        const reset = mode === 'reset';\n        const { iScale , vScale  } = this._cachedMeta;\n        const { sharedOptions , includeOptions  } = this._getSharedOptions(start, mode);\n        const iAxis = iScale.axis;\n        const vAxis = vScale.axis;\n        for(let i = start; i < start + count; i++){\n            const point = points[i];\n            const parsed = !reset && this.getParsed(i);\n            const properties = {};\n            const iPixel = properties[iAxis] = reset ? iScale.getPixelForDecimal(0.5) : iScale.getPixelForValue(parsed[iAxis]);\n            const vPixel = properties[vAxis] = reset ? vScale.getBasePixel() : vScale.getPixelForValue(parsed[vAxis]);\n            properties.skip = isNaN(iPixel) || isNaN(vPixel);\n            if (includeOptions) {\n                properties.options = sharedOptions || this.resolveDataElementOptions(i, point.active ? 'active' : mode);\n                if (reset) {\n                    properties.options.radius = 0;\n                }\n            }\n            this.updateElement(point, i, properties, mode);\n        }\n    }\n resolveDataElementOptions(index, mode) {\n        const parsed = this.getParsed(index);\n        let values = super.resolveDataElementOptions(index, mode);\n        if (values.$shared) {\n            values = Object.assign({}, values, {\n                $shared: false\n            });\n        }\n        const radius = values.radius;\n        if (mode !== 'active') {\n            values.radius = 0;\n        }\n        values.radius += (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.v)(parsed && parsed._custom, radius);\n        return values;\n    }\n}\n\nfunction getRatioAndOffset(rotation, circumference, cutout) {\n    let ratioX = 1;\n    let ratioY = 1;\n    let offsetX = 0;\n    let offsetY = 0;\n    if (circumference < _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.T) {\n        const startAngle = rotation;\n        const endAngle = startAngle + circumference;\n        const startX = Math.cos(startAngle);\n        const startY = Math.sin(startAngle);\n        const endX = Math.cos(endAngle);\n        const endY = Math.sin(endAngle);\n        const calcMax = (angle, a, b)=>(0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.p)(angle, startAngle, endAngle, true) ? 1 : Math.max(a, a * cutout, b, b * cutout);\n        const calcMin = (angle, a, b)=>(0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.p)(angle, startAngle, endAngle, true) ? -1 : Math.min(a, a * cutout, b, b * cutout);\n        const maxX = calcMax(0, startX, endX);\n        const maxY = calcMax(_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.H, startY, endY);\n        const minX = calcMin(_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.P, startX, endX);\n        const minY = calcMin(_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.P + _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.H, startY, endY);\n        ratioX = (maxX - minX) / 2;\n        ratioY = (maxY - minY) / 2;\n        offsetX = -(maxX + minX) / 2;\n        offsetY = -(maxY + minY) / 2;\n    }\n    return {\n        ratioX,\n        ratioY,\n        offsetX,\n        offsetY\n    };\n}\nclass DoughnutController extends DatasetController {\n    static id = 'doughnut';\n static defaults = {\n        datasetElementType: false,\n        dataElementType: 'arc',\n        animation: {\n            animateRotate: true,\n            animateScale: false\n        },\n        animations: {\n            numbers: {\n                type: 'number',\n                properties: [\n                    'circumference',\n                    'endAngle',\n                    'innerRadius',\n                    'outerRadius',\n                    'startAngle',\n                    'x',\n                    'y',\n                    'offset',\n                    'borderWidth',\n                    'spacing'\n                ]\n            }\n        },\n        cutout: '50%',\n        rotation: 0,\n        circumference: 360,\n        radius: '100%',\n        spacing: 0,\n        indexAxis: 'r'\n    };\n    static descriptors = {\n        _scriptable: (name)=>name !== 'spacing',\n        _indexable: (name)=>name !== 'spacing' && !name.startsWith('borderDash') && !name.startsWith('hoverBorderDash')\n    };\n static overrides = {\n        aspectRatio: 1,\n        plugins: {\n            legend: {\n                labels: {\n                    generateLabels (chart) {\n                        const data = chart.data;\n                        if (data.labels.length && data.datasets.length) {\n                            const { labels: { pointStyle , color  }  } = chart.legend.options;\n                            return data.labels.map((label, i)=>{\n                                const meta = chart.getDatasetMeta(0);\n                                const style = meta.controller.getStyle(i);\n                                return {\n                                    text: label,\n                                    fillStyle: style.backgroundColor,\n                                    strokeStyle: style.borderColor,\n                                    fontColor: color,\n                                    lineWidth: style.borderWidth,\n                                    pointStyle: pointStyle,\n                                    hidden: !chart.getDataVisibility(i),\n                                    index: i\n                                };\n                            });\n                        }\n                        return [];\n                    }\n                },\n                onClick (e, legendItem, legend) {\n                    legend.chart.toggleDataVisibility(legendItem.index);\n                    legend.chart.update();\n                }\n            }\n        }\n    };\n    constructor(chart, datasetIndex){\n        super(chart, datasetIndex);\n        this.enableOptionSharing = true;\n        this.innerRadius = undefined;\n        this.outerRadius = undefined;\n        this.offsetX = undefined;\n        this.offsetY = undefined;\n    }\n    linkScales() {}\n parse(start, count) {\n        const data = this.getDataset().data;\n        const meta = this._cachedMeta;\n        if (this._parsing === false) {\n            meta._parsed = data;\n        } else {\n            let getter = (i)=>+data[i];\n            if ((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.i)(data[start])) {\n                const { key ='value'  } = this._parsing;\n                getter = (i)=>+(0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.f)(data[i], key);\n            }\n            let i, ilen;\n            for(i = start, ilen = start + count; i < ilen; ++i){\n                meta._parsed[i] = getter(i);\n            }\n        }\n    }\n _getRotation() {\n        return (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.t)(this.options.rotation - 90);\n    }\n _getCircumference() {\n        return (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.t)(this.options.circumference);\n    }\n _getRotationExtents() {\n        let min = _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.T;\n        let max = -_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.T;\n        for(let i = 0; i < this.chart.data.datasets.length; ++i){\n            if (this.chart.isDatasetVisible(i) && this.chart.getDatasetMeta(i).type === this._type) {\n                const controller = this.chart.getDatasetMeta(i).controller;\n                const rotation = controller._getRotation();\n                const circumference = controller._getCircumference();\n                min = Math.min(min, rotation);\n                max = Math.max(max, rotation + circumference);\n            }\n        }\n        return {\n            rotation: min,\n            circumference: max - min\n        };\n    }\n update(mode) {\n        const chart = this.chart;\n        const { chartArea  } = chart;\n        const meta = this._cachedMeta;\n        const arcs = meta.data;\n        const spacing = this.getMaxBorderWidth() + this.getMaxOffset(arcs) + this.options.spacing;\n        const maxSize = Math.max((Math.min(chartArea.width, chartArea.height) - spacing) / 2, 0);\n        const cutout = Math.min((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.m)(this.options.cutout, maxSize), 1);\n        const chartWeight = this._getRingWeight(this.index);\n        const { circumference , rotation  } = this._getRotationExtents();\n        const { ratioX , ratioY , offsetX , offsetY  } = getRatioAndOffset(rotation, circumference, cutout);\n        const maxWidth = (chartArea.width - spacing) / ratioX;\n        const maxHeight = (chartArea.height - spacing) / ratioY;\n        const maxRadius = Math.max(Math.min(maxWidth, maxHeight) / 2, 0);\n        const outerRadius = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.n)(this.options.radius, maxRadius);\n        const innerRadius = Math.max(outerRadius * cutout, 0);\n        const radiusLength = (outerRadius - innerRadius) / this._getVisibleDatasetWeightTotal();\n        this.offsetX = offsetX * outerRadius;\n        this.offsetY = offsetY * outerRadius;\n        meta.total = this.calculateTotal();\n        this.outerRadius = outerRadius - radiusLength * this._getRingWeightOffset(this.index);\n        this.innerRadius = Math.max(this.outerRadius - radiusLength * chartWeight, 0);\n        this.updateElements(arcs, 0, arcs.length, mode);\n    }\n _circumference(i, reset) {\n        const opts = this.options;\n        const meta = this._cachedMeta;\n        const circumference = this._getCircumference();\n        if (reset && opts.animation.animateRotate || !this.chart.getDataVisibility(i) || meta._parsed[i] === null || meta.data[i].hidden) {\n            return 0;\n        }\n        return this.calculateCircumference(meta._parsed[i] * circumference / _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.T);\n    }\n    updateElements(arcs, start, count, mode) {\n        const reset = mode === 'reset';\n        const chart = this.chart;\n        const chartArea = chart.chartArea;\n        const opts = chart.options;\n        const animationOpts = opts.animation;\n        const centerX = (chartArea.left + chartArea.right) / 2;\n        const centerY = (chartArea.top + chartArea.bottom) / 2;\n        const animateScale = reset && animationOpts.animateScale;\n        const innerRadius = animateScale ? 0 : this.innerRadius;\n        const outerRadius = animateScale ? 0 : this.outerRadius;\n        const { sharedOptions , includeOptions  } = this._getSharedOptions(start, mode);\n        let startAngle = this._getRotation();\n        let i;\n        for(i = 0; i < start; ++i){\n            startAngle += this._circumference(i, reset);\n        }\n        for(i = start; i < start + count; ++i){\n            const circumference = this._circumference(i, reset);\n            const arc = arcs[i];\n            const properties = {\n                x: centerX + this.offsetX,\n                y: centerY + this.offsetY,\n                startAngle,\n                endAngle: startAngle + circumference,\n                circumference,\n                outerRadius,\n                innerRadius\n            };\n            if (includeOptions) {\n                properties.options = sharedOptions || this.resolveDataElementOptions(i, arc.active ? 'active' : mode);\n            }\n            startAngle += circumference;\n            this.updateElement(arc, i, properties, mode);\n        }\n    }\n    calculateTotal() {\n        const meta = this._cachedMeta;\n        const metaData = meta.data;\n        let total = 0;\n        let i;\n        for(i = 0; i < metaData.length; i++){\n            const value = meta._parsed[i];\n            if (value !== null && !isNaN(value) && this.chart.getDataVisibility(i) && !metaData[i].hidden) {\n                total += Math.abs(value);\n            }\n        }\n        return total;\n    }\n    calculateCircumference(value) {\n        const total = this._cachedMeta.total;\n        if (total > 0 && !isNaN(value)) {\n            return _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.T * (Math.abs(value) / total);\n        }\n        return 0;\n    }\n    getLabelAndValue(index) {\n        const meta = this._cachedMeta;\n        const chart = this.chart;\n        const labels = chart.data.labels || [];\n        const value = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.o)(meta._parsed[index], chart.options.locale);\n        return {\n            label: labels[index] || '',\n            value\n        };\n    }\n    getMaxBorderWidth(arcs) {\n        let max = 0;\n        const chart = this.chart;\n        let i, ilen, meta, controller, options;\n        if (!arcs) {\n            for(i = 0, ilen = chart.data.datasets.length; i < ilen; ++i){\n                if (chart.isDatasetVisible(i)) {\n                    meta = chart.getDatasetMeta(i);\n                    arcs = meta.data;\n                    controller = meta.controller;\n                    break;\n                }\n            }\n        }\n        if (!arcs) {\n            return 0;\n        }\n        for(i = 0, ilen = arcs.length; i < ilen; ++i){\n            options = controller.resolveDataElementOptions(i);\n            if (options.borderAlign !== 'inner') {\n                max = Math.max(max, options.borderWidth || 0, options.hoverBorderWidth || 0);\n            }\n        }\n        return max;\n    }\n    getMaxOffset(arcs) {\n        let max = 0;\n        for(let i = 0, ilen = arcs.length; i < ilen; ++i){\n            const options = this.resolveDataElementOptions(i);\n            max = Math.max(max, options.offset || 0, options.hoverOffset || 0);\n        }\n        return max;\n    }\n _getRingWeightOffset(datasetIndex) {\n        let ringWeightOffset = 0;\n        for(let i = 0; i < datasetIndex; ++i){\n            if (this.chart.isDatasetVisible(i)) {\n                ringWeightOffset += this._getRingWeight(i);\n            }\n        }\n        return ringWeightOffset;\n    }\n _getRingWeight(datasetIndex) {\n        return Math.max((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.v)(this.chart.data.datasets[datasetIndex].weight, 1), 0);\n    }\n _getVisibleDatasetWeightTotal() {\n        return this._getRingWeightOffset(this.chart.data.datasets.length) || 1;\n    }\n}\n\nclass LineController extends DatasetController {\n    static id = 'line';\n static defaults = {\n        datasetElementType: 'line',\n        dataElementType: 'point',\n        showLine: true,\n        spanGaps: false\n    };\n static overrides = {\n        scales: {\n            _index_: {\n                type: 'category'\n            },\n            _value_: {\n                type: 'linear'\n            }\n        }\n    };\n    initialize() {\n        this.enableOptionSharing = true;\n        this.supportsDecimation = true;\n        super.initialize();\n    }\n    update(mode) {\n        const meta = this._cachedMeta;\n        const { dataset: line , data: points = [] , _dataset  } = meta;\n        const animationsDisabled = this.chart._animationsDisabled;\n        let { start , count  } = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.q)(meta, points, animationsDisabled);\n        this._drawStart = start;\n        this._drawCount = count;\n        if ((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.w)(meta)) {\n            start = 0;\n            count = points.length;\n        }\n        line._chart = this.chart;\n        line._datasetIndex = this.index;\n        line._decimated = !!_dataset._decimated;\n        line.points = points;\n        const options = this.resolveDatasetElementOptions(mode);\n        if (!this.options.showLine) {\n            options.borderWidth = 0;\n        }\n        options.segment = this.options.segment;\n        this.updateElement(line, undefined, {\n            animated: !animationsDisabled,\n            options\n        }, mode);\n        this.updateElements(points, start, count, mode);\n    }\n    updateElements(points, start, count, mode) {\n        const reset = mode === 'reset';\n        const { iScale , vScale , _stacked , _dataset  } = this._cachedMeta;\n        const { sharedOptions , includeOptions  } = this._getSharedOptions(start, mode);\n        const iAxis = iScale.axis;\n        const vAxis = vScale.axis;\n        const { spanGaps , segment  } = this.options;\n        const maxGapLength = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.x)(spanGaps) ? spanGaps : Number.POSITIVE_INFINITY;\n        const directUpdate = this.chart._animationsDisabled || reset || mode === 'none';\n        const end = start + count;\n        const pointsCount = points.length;\n        let prevParsed = start > 0 && this.getParsed(start - 1);\n        for(let i = 0; i < pointsCount; ++i){\n            const point = points[i];\n            const properties = directUpdate ? point : {};\n            if (i < start || i >= end) {\n                properties.skip = true;\n                continue;\n            }\n            const parsed = this.getParsed(i);\n            const nullData = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.k)(parsed[vAxis]);\n            const iPixel = properties[iAxis] = iScale.getPixelForValue(parsed[iAxis], i);\n            const vPixel = properties[vAxis] = reset || nullData ? vScale.getBasePixel() : vScale.getPixelForValue(_stacked ? this.applyStack(vScale, parsed, _stacked) : parsed[vAxis], i);\n            properties.skip = isNaN(iPixel) || isNaN(vPixel) || nullData;\n            properties.stop = i > 0 && Math.abs(parsed[iAxis] - prevParsed[iAxis]) > maxGapLength;\n            if (segment) {\n                properties.parsed = parsed;\n                properties.raw = _dataset.data[i];\n            }\n            if (includeOptions) {\n                properties.options = sharedOptions || this.resolveDataElementOptions(i, point.active ? 'active' : mode);\n            }\n            if (!directUpdate) {\n                this.updateElement(point, i, properties, mode);\n            }\n            prevParsed = parsed;\n        }\n    }\n getMaxOverflow() {\n        const meta = this._cachedMeta;\n        const dataset = meta.dataset;\n        const border = dataset.options && dataset.options.borderWidth || 0;\n        const data = meta.data || [];\n        if (!data.length) {\n            return border;\n        }\n        const firstPoint = data[0].size(this.resolveDataElementOptions(0));\n        const lastPoint = data[data.length - 1].size(this.resolveDataElementOptions(data.length - 1));\n        return Math.max(border, firstPoint, lastPoint) / 2;\n    }\n    draw() {\n        const meta = this._cachedMeta;\n        meta.dataset.updateControlPoints(this.chart.chartArea, meta.iScale.axis);\n        super.draw();\n    }\n}\n\nclass PolarAreaController extends DatasetController {\n    static id = 'polarArea';\n static defaults = {\n        dataElementType: 'arc',\n        animation: {\n            animateRotate: true,\n            animateScale: true\n        },\n        animations: {\n            numbers: {\n                type: 'number',\n                properties: [\n                    'x',\n                    'y',\n                    'startAngle',\n                    'endAngle',\n                    'innerRadius',\n                    'outerRadius'\n                ]\n            }\n        },\n        indexAxis: 'r',\n        startAngle: 0\n    };\n static overrides = {\n        aspectRatio: 1,\n        plugins: {\n            legend: {\n                labels: {\n                    generateLabels (chart) {\n                        const data = chart.data;\n                        if (data.labels.length && data.datasets.length) {\n                            const { labels: { pointStyle , color  }  } = chart.legend.options;\n                            return data.labels.map((label, i)=>{\n                                const meta = chart.getDatasetMeta(0);\n                                const style = meta.controller.getStyle(i);\n                                return {\n                                    text: label,\n                                    fillStyle: style.backgroundColor,\n                                    strokeStyle: style.borderColor,\n                                    fontColor: color,\n                                    lineWidth: style.borderWidth,\n                                    pointStyle: pointStyle,\n                                    hidden: !chart.getDataVisibility(i),\n                                    index: i\n                                };\n                            });\n                        }\n                        return [];\n                    }\n                },\n                onClick (e, legendItem, legend) {\n                    legend.chart.toggleDataVisibility(legendItem.index);\n                    legend.chart.update();\n                }\n            }\n        },\n        scales: {\n            r: {\n                type: 'radialLinear',\n                angleLines: {\n                    display: false\n                },\n                beginAtZero: true,\n                grid: {\n                    circular: true\n                },\n                pointLabels: {\n                    display: false\n                },\n                startAngle: 0\n            }\n        }\n    };\n    constructor(chart, datasetIndex){\n        super(chart, datasetIndex);\n        this.innerRadius = undefined;\n        this.outerRadius = undefined;\n    }\n    getLabelAndValue(index) {\n        const meta = this._cachedMeta;\n        const chart = this.chart;\n        const labels = chart.data.labels || [];\n        const value = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.o)(meta._parsed[index].r, chart.options.locale);\n        return {\n            label: labels[index] || '',\n            value\n        };\n    }\n    parseObjectData(meta, data, start, count) {\n        return _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.y.bind(this)(meta, data, start, count);\n    }\n    update(mode) {\n        const arcs = this._cachedMeta.data;\n        this._updateRadius();\n        this.updateElements(arcs, 0, arcs.length, mode);\n    }\n getMinMax() {\n        const meta = this._cachedMeta;\n        const range = {\n            min: Number.POSITIVE_INFINITY,\n            max: Number.NEGATIVE_INFINITY\n        };\n        meta.data.forEach((element, index)=>{\n            const parsed = this.getParsed(index).r;\n            if (!isNaN(parsed) && this.chart.getDataVisibility(index)) {\n                if (parsed < range.min) {\n                    range.min = parsed;\n                }\n                if (parsed > range.max) {\n                    range.max = parsed;\n                }\n            }\n        });\n        return range;\n    }\n _updateRadius() {\n        const chart = this.chart;\n        const chartArea = chart.chartArea;\n        const opts = chart.options;\n        const minSize = Math.min(chartArea.right - chartArea.left, chartArea.bottom - chartArea.top);\n        const outerRadius = Math.max(minSize / 2, 0);\n        const innerRadius = Math.max(opts.cutoutPercentage ? outerRadius / 100 * opts.cutoutPercentage : 1, 0);\n        const radiusLength = (outerRadius - innerRadius) / chart.getVisibleDatasetCount();\n        this.outerRadius = outerRadius - radiusLength * this.index;\n        this.innerRadius = this.outerRadius - radiusLength;\n    }\n    updateElements(arcs, start, count, mode) {\n        const reset = mode === 'reset';\n        const chart = this.chart;\n        const opts = chart.options;\n        const animationOpts = opts.animation;\n        const scale = this._cachedMeta.rScale;\n        const centerX = scale.xCenter;\n        const centerY = scale.yCenter;\n        const datasetStartAngle = scale.getIndexAngle(0) - 0.5 * _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.P;\n        let angle = datasetStartAngle;\n        let i;\n        const defaultAngle = 360 / this.countVisibleElements();\n        for(i = 0; i < start; ++i){\n            angle += this._computeAngle(i, mode, defaultAngle);\n        }\n        for(i = start; i < start + count; i++){\n            const arc = arcs[i];\n            let startAngle = angle;\n            let endAngle = angle + this._computeAngle(i, mode, defaultAngle);\n            let outerRadius = chart.getDataVisibility(i) ? scale.getDistanceFromCenterForValue(this.getParsed(i).r) : 0;\n            angle = endAngle;\n            if (reset) {\n                if (animationOpts.animateScale) {\n                    outerRadius = 0;\n                }\n                if (animationOpts.animateRotate) {\n                    startAngle = endAngle = datasetStartAngle;\n                }\n            }\n            const properties = {\n                x: centerX,\n                y: centerY,\n                innerRadius: 0,\n                outerRadius,\n                startAngle,\n                endAngle,\n                options: this.resolveDataElementOptions(i, arc.active ? 'active' : mode)\n            };\n            this.updateElement(arc, i, properties, mode);\n        }\n    }\n    countVisibleElements() {\n        const meta = this._cachedMeta;\n        let count = 0;\n        meta.data.forEach((element, index)=>{\n            if (!isNaN(this.getParsed(index).r) && this.chart.getDataVisibility(index)) {\n                count++;\n            }\n        });\n        return count;\n    }\n _computeAngle(index, mode, defaultAngle) {\n        return this.chart.getDataVisibility(index) ? (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.t)(this.resolveDataElementOptions(index, mode).angle || defaultAngle) : 0;\n    }\n}\n\nclass PieController extends DoughnutController {\n    static id = 'pie';\n static defaults = {\n        cutout: 0,\n        rotation: 0,\n        circumference: 360,\n        radius: '100%'\n    };\n}\n\nclass RadarController extends DatasetController {\n    static id = 'radar';\n static defaults = {\n        datasetElementType: 'line',\n        dataElementType: 'point',\n        indexAxis: 'r',\n        showLine: true,\n        elements: {\n            line: {\n                fill: 'start'\n            }\n        }\n    };\n static overrides = {\n        aspectRatio: 1,\n        scales: {\n            r: {\n                type: 'radialLinear'\n            }\n        }\n    };\n getLabelAndValue(index) {\n        const vScale = this._cachedMeta.vScale;\n        const parsed = this.getParsed(index);\n        return {\n            label: vScale.getLabels()[index],\n            value: '' + vScale.getLabelForValue(parsed[vScale.axis])\n        };\n    }\n    parseObjectData(meta, data, start, count) {\n        return _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.y.bind(this)(meta, data, start, count);\n    }\n    update(mode) {\n        const meta = this._cachedMeta;\n        const line = meta.dataset;\n        const points = meta.data || [];\n        const labels = meta.iScale.getLabels();\n        line.points = points;\n        if (mode !== 'resize') {\n            const options = this.resolveDatasetElementOptions(mode);\n            if (!this.options.showLine) {\n                options.borderWidth = 0;\n            }\n            const properties = {\n                _loop: true,\n                _fullLoop: labels.length === points.length,\n                options\n            };\n            this.updateElement(line, undefined, properties, mode);\n        }\n        this.updateElements(points, 0, points.length, mode);\n    }\n    updateElements(points, start, count, mode) {\n        const scale = this._cachedMeta.rScale;\n        const reset = mode === 'reset';\n        for(let i = start; i < start + count; i++){\n            const point = points[i];\n            const options = this.resolveDataElementOptions(i, point.active ? 'active' : mode);\n            const pointPosition = scale.getPointPositionForValue(i, this.getParsed(i).r);\n            const x = reset ? scale.xCenter : pointPosition.x;\n            const y = reset ? scale.yCenter : pointPosition.y;\n            const properties = {\n                x,\n                y,\n                angle: pointPosition.angle,\n                skip: isNaN(x) || isNaN(y),\n                options\n            };\n            this.updateElement(point, i, properties, mode);\n        }\n    }\n}\n\nclass ScatterController extends DatasetController {\n    static id = 'scatter';\n static defaults = {\n        datasetElementType: false,\n        dataElementType: 'point',\n        showLine: false,\n        fill: false\n    };\n static overrides = {\n        interaction: {\n            mode: 'point'\n        },\n        scales: {\n            x: {\n                type: 'linear'\n            },\n            y: {\n                type: 'linear'\n            }\n        }\n    };\n getLabelAndValue(index) {\n        const meta = this._cachedMeta;\n        const labels = this.chart.data.labels || [];\n        const { xScale , yScale  } = meta;\n        const parsed = this.getParsed(index);\n        const x = xScale.getLabelForValue(parsed.x);\n        const y = yScale.getLabelForValue(parsed.y);\n        return {\n            label: labels[index] || '',\n            value: '(' + x + ', ' + y + ')'\n        };\n    }\n    update(mode) {\n        const meta = this._cachedMeta;\n        const { data: points = []  } = meta;\n        const animationsDisabled = this.chart._animationsDisabled;\n        let { start , count  } = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.q)(meta, points, animationsDisabled);\n        this._drawStart = start;\n        this._drawCount = count;\n        if ((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.w)(meta)) {\n            start = 0;\n            count = points.length;\n        }\n        if (this.options.showLine) {\n            if (!this.datasetElementType) {\n                this.addElements();\n            }\n            const { dataset: line , _dataset  } = meta;\n            line._chart = this.chart;\n            line._datasetIndex = this.index;\n            line._decimated = !!_dataset._decimated;\n            line.points = points;\n            const options = this.resolveDatasetElementOptions(mode);\n            options.segment = this.options.segment;\n            this.updateElement(line, undefined, {\n                animated: !animationsDisabled,\n                options\n            }, mode);\n        } else if (this.datasetElementType) {\n            delete meta.dataset;\n            this.datasetElementType = false;\n        }\n        this.updateElements(points, start, count, mode);\n    }\n    addElements() {\n        const { showLine  } = this.options;\n        if (!this.datasetElementType && showLine) {\n            this.datasetElementType = this.chart.registry.getElement('line');\n        }\n        super.addElements();\n    }\n    updateElements(points, start, count, mode) {\n        const reset = mode === 'reset';\n        const { iScale , vScale , _stacked , _dataset  } = this._cachedMeta;\n        const firstOpts = this.resolveDataElementOptions(start, mode);\n        const sharedOptions = this.getSharedOptions(firstOpts);\n        const includeOptions = this.includeOptions(mode, sharedOptions);\n        const iAxis = iScale.axis;\n        const vAxis = vScale.axis;\n        const { spanGaps , segment  } = this.options;\n        const maxGapLength = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.x)(spanGaps) ? spanGaps : Number.POSITIVE_INFINITY;\n        const directUpdate = this.chart._animationsDisabled || reset || mode === 'none';\n        let prevParsed = start > 0 && this.getParsed(start - 1);\n        for(let i = start; i < start + count; ++i){\n            const point = points[i];\n            const parsed = this.getParsed(i);\n            const properties = directUpdate ? point : {};\n            const nullData = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.k)(parsed[vAxis]);\n            const iPixel = properties[iAxis] = iScale.getPixelForValue(parsed[iAxis], i);\n            const vPixel = properties[vAxis] = reset || nullData ? vScale.getBasePixel() : vScale.getPixelForValue(_stacked ? this.applyStack(vScale, parsed, _stacked) : parsed[vAxis], i);\n            properties.skip = isNaN(iPixel) || isNaN(vPixel) || nullData;\n            properties.stop = i > 0 && Math.abs(parsed[iAxis] - prevParsed[iAxis]) > maxGapLength;\n            if (segment) {\n                properties.parsed = parsed;\n                properties.raw = _dataset.data[i];\n            }\n            if (includeOptions) {\n                properties.options = sharedOptions || this.resolveDataElementOptions(i, point.active ? 'active' : mode);\n            }\n            if (!directUpdate) {\n                this.updateElement(point, i, properties, mode);\n            }\n            prevParsed = parsed;\n        }\n        this.updateSharedOptions(sharedOptions, mode, firstOpts);\n    }\n getMaxOverflow() {\n        const meta = this._cachedMeta;\n        const data = meta.data || [];\n        if (!this.options.showLine) {\n            let max = 0;\n            for(let i = data.length - 1; i >= 0; --i){\n                max = Math.max(max, data[i].size(this.resolveDataElementOptions(i)) / 2);\n            }\n            return max > 0 && max;\n        }\n        const dataset = meta.dataset;\n        const border = dataset.options && dataset.options.borderWidth || 0;\n        if (!data.length) {\n            return border;\n        }\n        const firstPoint = data[0].size(this.resolveDataElementOptions(0));\n        const lastPoint = data[data.length - 1].size(this.resolveDataElementOptions(data.length - 1));\n        return Math.max(border, firstPoint, lastPoint) / 2;\n    }\n}\n\nvar controllers = /*#__PURE__*/Object.freeze({\n__proto__: null,\nBarController: BarController,\nBubbleController: BubbleController,\nDoughnutController: DoughnutController,\nLineController: LineController,\nPieController: PieController,\nPolarAreaController: PolarAreaController,\nRadarController: RadarController,\nScatterController: ScatterController\n});\n\n/**\n * @namespace Chart._adapters\n * @since 2.8.0\n * @private\n */ function abstract() {\n    throw new Error('This method is not implemented: Check that a complete date adapter is provided.');\n}\n/**\n * Date adapter (current used by the time scale)\n * @namespace Chart._adapters._date\n * @memberof Chart._adapters\n * @private\n */ class DateAdapterBase {\n    /**\n   * Override default date adapter methods.\n   * Accepts type parameter to define options type.\n   * @example\n   * Chart._adapters._date.override<{myAdapterOption: string}>({\n   *   init() {\n   *     console.log(this.options.myAdapterOption);\n   *   }\n   * })\n   */ static override(members) {\n        Object.assign(DateAdapterBase.prototype, members);\n    }\n    options;\n    constructor(options){\n        this.options = options || {};\n    }\n    // eslint-disable-next-line @typescript-eslint/no-empty-function\n    init() {}\n    formats() {\n        return abstract();\n    }\n    parse() {\n        return abstract();\n    }\n    format() {\n        return abstract();\n    }\n    add() {\n        return abstract();\n    }\n    diff() {\n        return abstract();\n    }\n    startOf() {\n        return abstract();\n    }\n    endOf() {\n        return abstract();\n    }\n}\nvar adapters = {\n    _date: DateAdapterBase\n};\n\nfunction binarySearch(metaset, axis, value, intersect) {\n    const { controller , data , _sorted  } = metaset;\n    const iScale = controller._cachedMeta.iScale;\n    const spanGaps = metaset.dataset ? metaset.dataset.options ? metaset.dataset.options.spanGaps : null : null;\n    if (iScale && axis === iScale.axis && axis !== 'r' && _sorted && data.length) {\n        const lookupMethod = iScale._reversePixels ? _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.A : _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.B;\n        if (!intersect) {\n            const result = lookupMethod(data, axis, value);\n            if (spanGaps) {\n                const { vScale  } = controller._cachedMeta;\n                const { _parsed  } = metaset;\n                const distanceToDefinedLo = _parsed.slice(0, result.lo + 1).reverse().findIndex((point)=>!(0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.k)(point[vScale.axis]));\n                result.lo -= Math.max(0, distanceToDefinedLo);\n                const distanceToDefinedHi = _parsed.slice(result.hi).findIndex((point)=>!(0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.k)(point[vScale.axis]));\n                result.hi += Math.max(0, distanceToDefinedHi);\n            }\n            return result;\n        } else if (controller._sharedOptions) {\n            const el = data[0];\n            const range = typeof el.getRange === 'function' && el.getRange(axis);\n            if (range) {\n                const start = lookupMethod(data, axis, value - range);\n                const end = lookupMethod(data, axis, value + range);\n                return {\n                    lo: start.lo,\n                    hi: end.hi\n                };\n            }\n        }\n    }\n    return {\n        lo: 0,\n        hi: data.length - 1\n    };\n}\n function evaluateInteractionItems(chart, axis, position, handler, intersect) {\n    const metasets = chart.getSortedVisibleDatasetMetas();\n    const value = position[axis];\n    for(let i = 0, ilen = metasets.length; i < ilen; ++i){\n        const { index , data  } = metasets[i];\n        const { lo , hi  } = binarySearch(metasets[i], axis, value, intersect);\n        for(let j = lo; j <= hi; ++j){\n            const element = data[j];\n            if (!element.skip) {\n                handler(element, index, j);\n            }\n        }\n    }\n}\n function getDistanceMetricForAxis(axis) {\n    const useX = axis.indexOf('x') !== -1;\n    const useY = axis.indexOf('y') !== -1;\n    return function(pt1, pt2) {\n        const deltaX = useX ? Math.abs(pt1.x - pt2.x) : 0;\n        const deltaY = useY ? Math.abs(pt1.y - pt2.y) : 0;\n        return Math.sqrt(Math.pow(deltaX, 2) + Math.pow(deltaY, 2));\n    };\n}\n function getIntersectItems(chart, position, axis, useFinalPosition, includeInvisible) {\n    const items = [];\n    if (!includeInvisible && !chart.isPointInArea(position)) {\n        return items;\n    }\n    const evaluationFunc = function(element, datasetIndex, index) {\n        if (!includeInvisible && !(0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.C)(element, chart.chartArea, 0)) {\n            return;\n        }\n        if (element.inRange(position.x, position.y, useFinalPosition)) {\n            items.push({\n                element,\n                datasetIndex,\n                index\n            });\n        }\n    };\n    evaluateInteractionItems(chart, axis, position, evaluationFunc, true);\n    return items;\n}\n function getNearestRadialItems(chart, position, axis, useFinalPosition) {\n    let items = [];\n    function evaluationFunc(element, datasetIndex, index) {\n        const { startAngle , endAngle  } = element.getProps([\n            'startAngle',\n            'endAngle'\n        ], useFinalPosition);\n        const { angle  } = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.D)(element, {\n            x: position.x,\n            y: position.y\n        });\n        if ((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.p)(angle, startAngle, endAngle)) {\n            items.push({\n                element,\n                datasetIndex,\n                index\n            });\n        }\n    }\n    evaluateInteractionItems(chart, axis, position, evaluationFunc);\n    return items;\n}\n function getNearestCartesianItems(chart, position, axis, intersect, useFinalPosition, includeInvisible) {\n    let items = [];\n    const distanceMetric = getDistanceMetricForAxis(axis);\n    let minDistance = Number.POSITIVE_INFINITY;\n    function evaluationFunc(element, datasetIndex, index) {\n        const inRange = element.inRange(position.x, position.y, useFinalPosition);\n        if (intersect && !inRange) {\n            return;\n        }\n        const center = element.getCenterPoint(useFinalPosition);\n        const pointInArea = !!includeInvisible || chart.isPointInArea(center);\n        if (!pointInArea && !inRange) {\n            return;\n        }\n        const distance = distanceMetric(position, center);\n        if (distance < minDistance) {\n            items = [\n                {\n                    element,\n                    datasetIndex,\n                    index\n                }\n            ];\n            minDistance = distance;\n        } else if (distance === minDistance) {\n            items.push({\n                element,\n                datasetIndex,\n                index\n            });\n        }\n    }\n    evaluateInteractionItems(chart, axis, position, evaluationFunc);\n    return items;\n}\n function getNearestItems(chart, position, axis, intersect, useFinalPosition, includeInvisible) {\n    if (!includeInvisible && !chart.isPointInArea(position)) {\n        return [];\n    }\n    return axis === 'r' && !intersect ? getNearestRadialItems(chart, position, axis, useFinalPosition) : getNearestCartesianItems(chart, position, axis, intersect, useFinalPosition, includeInvisible);\n}\n function getAxisItems(chart, position, axis, intersect, useFinalPosition) {\n    const items = [];\n    const rangeMethod = axis === 'x' ? 'inXRange' : 'inYRange';\n    let intersectsItem = false;\n    evaluateInteractionItems(chart, axis, position, (element, datasetIndex, index)=>{\n        if (element[rangeMethod] && element[rangeMethod](position[axis], useFinalPosition)) {\n            items.push({\n                element,\n                datasetIndex,\n                index\n            });\n            intersectsItem = intersectsItem || element.inRange(position.x, position.y, useFinalPosition);\n        }\n    });\n    if (intersect && !intersectsItem) {\n        return [];\n    }\n    return items;\n}\n var Interaction = {\n    evaluateInteractionItems,\n    modes: {\n index (chart, e, options, useFinalPosition) {\n            const position = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.z)(e, chart);\n            const axis = options.axis || 'x';\n            const includeInvisible = options.includeInvisible || false;\n            const items = options.intersect ? getIntersectItems(chart, position, axis, useFinalPosition, includeInvisible) : getNearestItems(chart, position, axis, false, useFinalPosition, includeInvisible);\n            const elements = [];\n            if (!items.length) {\n                return [];\n            }\n            chart.getSortedVisibleDatasetMetas().forEach((meta)=>{\n                const index = items[0].index;\n                const element = meta.data[index];\n                if (element && !element.skip) {\n                    elements.push({\n                        element,\n                        datasetIndex: meta.index,\n                        index\n                    });\n                }\n            });\n            return elements;\n        },\n dataset (chart, e, options, useFinalPosition) {\n            const position = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.z)(e, chart);\n            const axis = options.axis || 'xy';\n            const includeInvisible = options.includeInvisible || false;\n            let items = options.intersect ? getIntersectItems(chart, position, axis, useFinalPosition, includeInvisible) : getNearestItems(chart, position, axis, false, useFinalPosition, includeInvisible);\n            if (items.length > 0) {\n                const datasetIndex = items[0].datasetIndex;\n                const data = chart.getDatasetMeta(datasetIndex).data;\n                items = [];\n                for(let i = 0; i < data.length; ++i){\n                    items.push({\n                        element: data[i],\n                        datasetIndex,\n                        index: i\n                    });\n                }\n            }\n            return items;\n        },\n point (chart, e, options, useFinalPosition) {\n            const position = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.z)(e, chart);\n            const axis = options.axis || 'xy';\n            const includeInvisible = options.includeInvisible || false;\n            return getIntersectItems(chart, position, axis, useFinalPosition, includeInvisible);\n        },\n nearest (chart, e, options, useFinalPosition) {\n            const position = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.z)(e, chart);\n            const axis = options.axis || 'xy';\n            const includeInvisible = options.includeInvisible || false;\n            return getNearestItems(chart, position, axis, options.intersect, useFinalPosition, includeInvisible);\n        },\n x (chart, e, options, useFinalPosition) {\n            const position = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.z)(e, chart);\n            return getAxisItems(chart, position, 'x', options.intersect, useFinalPosition);\n        },\n y (chart, e, options, useFinalPosition) {\n            const position = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.z)(e, chart);\n            return getAxisItems(chart, position, 'y', options.intersect, useFinalPosition);\n        }\n    }\n};\n\nconst STATIC_POSITIONS = [\n    'left',\n    'top',\n    'right',\n    'bottom'\n];\nfunction filterByPosition(array, position) {\n    return array.filter((v)=>v.pos === position);\n}\nfunction filterDynamicPositionByAxis(array, axis) {\n    return array.filter((v)=>STATIC_POSITIONS.indexOf(v.pos) === -1 && v.box.axis === axis);\n}\nfunction sortByWeight(array, reverse) {\n    return array.sort((a, b)=>{\n        const v0 = reverse ? b : a;\n        const v1 = reverse ? a : b;\n        return v0.weight === v1.weight ? v0.index - v1.index : v0.weight - v1.weight;\n    });\n}\nfunction wrapBoxes(boxes) {\n    const layoutBoxes = [];\n    let i, ilen, box, pos, stack, stackWeight;\n    for(i = 0, ilen = (boxes || []).length; i < ilen; ++i){\n        box = boxes[i];\n        ({ position: pos , options: { stack , stackWeight =1  }  } = box);\n        layoutBoxes.push({\n            index: i,\n            box,\n            pos,\n            horizontal: box.isHorizontal(),\n            weight: box.weight,\n            stack: stack && pos + stack,\n            stackWeight\n        });\n    }\n    return layoutBoxes;\n}\nfunction buildStacks(layouts) {\n    const stacks = {};\n    for (const wrap of layouts){\n        const { stack , pos , stackWeight  } = wrap;\n        if (!stack || !STATIC_POSITIONS.includes(pos)) {\n            continue;\n        }\n        const _stack = stacks[stack] || (stacks[stack] = {\n            count: 0,\n            placed: 0,\n            weight: 0,\n            size: 0\n        });\n        _stack.count++;\n        _stack.weight += stackWeight;\n    }\n    return stacks;\n}\n function setLayoutDims(layouts, params) {\n    const stacks = buildStacks(layouts);\n    const { vBoxMaxWidth , hBoxMaxHeight  } = params;\n    let i, ilen, layout;\n    for(i = 0, ilen = layouts.length; i < ilen; ++i){\n        layout = layouts[i];\n        const { fullSize  } = layout.box;\n        const stack = stacks[layout.stack];\n        const factor = stack && layout.stackWeight / stack.weight;\n        if (layout.horizontal) {\n            layout.width = factor ? factor * vBoxMaxWidth : fullSize && params.availableWidth;\n            layout.height = hBoxMaxHeight;\n        } else {\n            layout.width = vBoxMaxWidth;\n            layout.height = factor ? factor * hBoxMaxHeight : fullSize && params.availableHeight;\n        }\n    }\n    return stacks;\n}\nfunction buildLayoutBoxes(boxes) {\n    const layoutBoxes = wrapBoxes(boxes);\n    const fullSize = sortByWeight(layoutBoxes.filter((wrap)=>wrap.box.fullSize), true);\n    const left = sortByWeight(filterByPosition(layoutBoxes, 'left'), true);\n    const right = sortByWeight(filterByPosition(layoutBoxes, 'right'));\n    const top = sortByWeight(filterByPosition(layoutBoxes, 'top'), true);\n    const bottom = sortByWeight(filterByPosition(layoutBoxes, 'bottom'));\n    const centerHorizontal = filterDynamicPositionByAxis(layoutBoxes, 'x');\n    const centerVertical = filterDynamicPositionByAxis(layoutBoxes, 'y');\n    return {\n        fullSize,\n        leftAndTop: left.concat(top),\n        rightAndBottom: right.concat(centerVertical).concat(bottom).concat(centerHorizontal),\n        chartArea: filterByPosition(layoutBoxes, 'chartArea'),\n        vertical: left.concat(right).concat(centerVertical),\n        horizontal: top.concat(bottom).concat(centerHorizontal)\n    };\n}\nfunction getCombinedMax(maxPadding, chartArea, a, b) {\n    return Math.max(maxPadding[a], chartArea[a]) + Math.max(maxPadding[b], chartArea[b]);\n}\nfunction updateMaxPadding(maxPadding, boxPadding) {\n    maxPadding.top = Math.max(maxPadding.top, boxPadding.top);\n    maxPadding.left = Math.max(maxPadding.left, boxPadding.left);\n    maxPadding.bottom = Math.max(maxPadding.bottom, boxPadding.bottom);\n    maxPadding.right = Math.max(maxPadding.right, boxPadding.right);\n}\nfunction updateDims(chartArea, params, layout, stacks) {\n    const { pos , box  } = layout;\n    const maxPadding = chartArea.maxPadding;\n    if (!(0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.i)(pos)) {\n        if (layout.size) {\n            chartArea[pos] -= layout.size;\n        }\n        const stack = stacks[layout.stack] || {\n            size: 0,\n            count: 1\n        };\n        stack.size = Math.max(stack.size, layout.horizontal ? box.height : box.width);\n        layout.size = stack.size / stack.count;\n        chartArea[pos] += layout.size;\n    }\n    if (box.getPadding) {\n        updateMaxPadding(maxPadding, box.getPadding());\n    }\n    const newWidth = Math.max(0, params.outerWidth - getCombinedMax(maxPadding, chartArea, 'left', 'right'));\n    const newHeight = Math.max(0, params.outerHeight - getCombinedMax(maxPadding, chartArea, 'top', 'bottom'));\n    const widthChanged = newWidth !== chartArea.w;\n    const heightChanged = newHeight !== chartArea.h;\n    chartArea.w = newWidth;\n    chartArea.h = newHeight;\n    return layout.horizontal ? {\n        same: widthChanged,\n        other: heightChanged\n    } : {\n        same: heightChanged,\n        other: widthChanged\n    };\n}\nfunction handleMaxPadding(chartArea) {\n    const maxPadding = chartArea.maxPadding;\n    function updatePos(pos) {\n        const change = Math.max(maxPadding[pos] - chartArea[pos], 0);\n        chartArea[pos] += change;\n        return change;\n    }\n    chartArea.y += updatePos('top');\n    chartArea.x += updatePos('left');\n    updatePos('right');\n    updatePos('bottom');\n}\nfunction getMargins(horizontal, chartArea) {\n    const maxPadding = chartArea.maxPadding;\n    function marginForPositions(positions) {\n        const margin = {\n            left: 0,\n            top: 0,\n            right: 0,\n            bottom: 0\n        };\n        positions.forEach((pos)=>{\n            margin[pos] = Math.max(chartArea[pos], maxPadding[pos]);\n        });\n        return margin;\n    }\n    return horizontal ? marginForPositions([\n        'left',\n        'right'\n    ]) : marginForPositions([\n        'top',\n        'bottom'\n    ]);\n}\nfunction fitBoxes(boxes, chartArea, params, stacks) {\n    const refitBoxes = [];\n    let i, ilen, layout, box, refit, changed;\n    for(i = 0, ilen = boxes.length, refit = 0; i < ilen; ++i){\n        layout = boxes[i];\n        box = layout.box;\n        box.update(layout.width || chartArea.w, layout.height || chartArea.h, getMargins(layout.horizontal, chartArea));\n        const { same , other  } = updateDims(chartArea, params, layout, stacks);\n        refit |= same && refitBoxes.length;\n        changed = changed || other;\n        if (!box.fullSize) {\n            refitBoxes.push(layout);\n        }\n    }\n    return refit && fitBoxes(refitBoxes, chartArea, params, stacks) || changed;\n}\nfunction setBoxDims(box, left, top, width, height) {\n    box.top = top;\n    box.left = left;\n    box.right = left + width;\n    box.bottom = top + height;\n    box.width = width;\n    box.height = height;\n}\nfunction placeBoxes(boxes, chartArea, params, stacks) {\n    const userPadding = params.padding;\n    let { x , y  } = chartArea;\n    for (const layout of boxes){\n        const box = layout.box;\n        const stack = stacks[layout.stack] || {\n            count: 1,\n            placed: 0,\n            weight: 1\n        };\n        const weight = layout.stackWeight / stack.weight || 1;\n        if (layout.horizontal) {\n            const width = chartArea.w * weight;\n            const height = stack.size || box.height;\n            if ((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.h)(stack.start)) {\n                y = stack.start;\n            }\n            if (box.fullSize) {\n                setBoxDims(box, userPadding.left, y, params.outerWidth - userPadding.right - userPadding.left, height);\n            } else {\n                setBoxDims(box, chartArea.left + stack.placed, y, width, height);\n            }\n            stack.start = y;\n            stack.placed += width;\n            y = box.bottom;\n        } else {\n            const height = chartArea.h * weight;\n            const width = stack.size || box.width;\n            if ((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.h)(stack.start)) {\n                x = stack.start;\n            }\n            if (box.fullSize) {\n                setBoxDims(box, x, userPadding.top, width, params.outerHeight - userPadding.bottom - userPadding.top);\n            } else {\n                setBoxDims(box, x, chartArea.top + stack.placed, width, height);\n            }\n            stack.start = x;\n            stack.placed += height;\n            x = box.right;\n        }\n    }\n    chartArea.x = x;\n    chartArea.y = y;\n}\nvar layouts = {\n addBox (chart, item) {\n        if (!chart.boxes) {\n            chart.boxes = [];\n        }\n        item.fullSize = item.fullSize || false;\n        item.position = item.position || 'top';\n        item.weight = item.weight || 0;\n        item._layers = item._layers || function() {\n            return [\n                {\n                    z: 0,\n                    draw (chartArea) {\n                        item.draw(chartArea);\n                    }\n                }\n            ];\n        };\n        chart.boxes.push(item);\n    },\n removeBox (chart, layoutItem) {\n        const index = chart.boxes ? chart.boxes.indexOf(layoutItem) : -1;\n        if (index !== -1) {\n            chart.boxes.splice(index, 1);\n        }\n    },\n configure (chart, item, options) {\n        item.fullSize = options.fullSize;\n        item.position = options.position;\n        item.weight = options.weight;\n    },\n update (chart, width, height, minPadding) {\n        if (!chart) {\n            return;\n        }\n        const padding = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.E)(chart.options.layout.padding);\n        const availableWidth = Math.max(width - padding.width, 0);\n        const availableHeight = Math.max(height - padding.height, 0);\n        const boxes = buildLayoutBoxes(chart.boxes);\n        const verticalBoxes = boxes.vertical;\n        const horizontalBoxes = boxes.horizontal;\n        (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.F)(chart.boxes, (box)=>{\n            if (typeof box.beforeLayout === 'function') {\n                box.beforeLayout();\n            }\n        });\n        const visibleVerticalBoxCount = verticalBoxes.reduce((total, wrap)=>wrap.box.options && wrap.box.options.display === false ? total : total + 1, 0) || 1;\n        const params = Object.freeze({\n            outerWidth: width,\n            outerHeight: height,\n            padding,\n            availableWidth,\n            availableHeight,\n            vBoxMaxWidth: availableWidth / 2 / visibleVerticalBoxCount,\n            hBoxMaxHeight: availableHeight / 2\n        });\n        const maxPadding = Object.assign({}, padding);\n        updateMaxPadding(maxPadding, (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.E)(minPadding));\n        const chartArea = Object.assign({\n            maxPadding,\n            w: availableWidth,\n            h: availableHeight,\n            x: padding.left,\n            y: padding.top\n        }, padding);\n        const stacks = setLayoutDims(verticalBoxes.concat(horizontalBoxes), params);\n        fitBoxes(boxes.fullSize, chartArea, params, stacks);\n        fitBoxes(verticalBoxes, chartArea, params, stacks);\n        if (fitBoxes(horizontalBoxes, chartArea, params, stacks)) {\n            fitBoxes(verticalBoxes, chartArea, params, stacks);\n        }\n        handleMaxPadding(chartArea);\n        placeBoxes(boxes.leftAndTop, chartArea, params, stacks);\n        chartArea.x += chartArea.w;\n        chartArea.y += chartArea.h;\n        placeBoxes(boxes.rightAndBottom, chartArea, params, stacks);\n        chart.chartArea = {\n            left: chartArea.left,\n            top: chartArea.top,\n            right: chartArea.left + chartArea.w,\n            bottom: chartArea.top + chartArea.h,\n            height: chartArea.h,\n            width: chartArea.w\n        };\n        (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.F)(boxes.chartArea, (layout)=>{\n            const box = layout.box;\n            Object.assign(box, chart.chartArea);\n            box.update(chartArea.w, chartArea.h, {\n                left: 0,\n                top: 0,\n                right: 0,\n                bottom: 0\n            });\n        });\n    }\n};\n\nclass BasePlatform {\n acquireContext(canvas, aspectRatio) {}\n releaseContext(context) {\n        return false;\n    }\n addEventListener(chart, type, listener) {}\n removeEventListener(chart, type, listener) {}\n getDevicePixelRatio() {\n        return 1;\n    }\n getMaximumSize(element, width, height, aspectRatio) {\n        width = Math.max(0, width || element.width);\n        height = height || element.height;\n        return {\n            width,\n            height: Math.max(0, aspectRatio ? Math.floor(width / aspectRatio) : height)\n        };\n    }\n isAttached(canvas) {\n        return true;\n    }\n updateConfig(config) {\n    }\n}\n\nclass BasicPlatform extends BasePlatform {\n    acquireContext(item) {\n        return item && item.getContext && item.getContext('2d') || null;\n    }\n    updateConfig(config) {\n        config.options.animation = false;\n    }\n}\n\nconst EXPANDO_KEY = '$chartjs';\n const EVENT_TYPES = {\n    touchstart: 'mousedown',\n    touchmove: 'mousemove',\n    touchend: 'mouseup',\n    pointerenter: 'mouseenter',\n    pointerdown: 'mousedown',\n    pointermove: 'mousemove',\n    pointerup: 'mouseup',\n    pointerleave: 'mouseout',\n    pointerout: 'mouseout'\n};\nconst isNullOrEmpty = (value)=>value === null || value === '';\n function initCanvas(canvas, aspectRatio) {\n    const style = canvas.style;\n    const renderHeight = canvas.getAttribute('height');\n    const renderWidth = canvas.getAttribute('width');\n    canvas[EXPANDO_KEY] = {\n        initial: {\n            height: renderHeight,\n            width: renderWidth,\n            style: {\n                display: style.display,\n                height: style.height,\n                width: style.width\n            }\n        }\n    };\n    style.display = style.display || 'block';\n    style.boxSizing = style.boxSizing || 'border-box';\n    if (isNullOrEmpty(renderWidth)) {\n        const displayWidth = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.J)(canvas, 'width');\n        if (displayWidth !== undefined) {\n            canvas.width = displayWidth;\n        }\n    }\n    if (isNullOrEmpty(renderHeight)) {\n        if (canvas.style.height === '') {\n            canvas.height = canvas.width / (aspectRatio || 2);\n        } else {\n            const displayHeight = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.J)(canvas, 'height');\n            if (displayHeight !== undefined) {\n                canvas.height = displayHeight;\n            }\n        }\n    }\n    return canvas;\n}\nconst eventListenerOptions = _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.K ? {\n    passive: true\n} : false;\nfunction addListener(node, type, listener) {\n    if (node) {\n        node.addEventListener(type, listener, eventListenerOptions);\n    }\n}\nfunction removeListener(chart, type, listener) {\n    if (chart && chart.canvas) {\n        chart.canvas.removeEventListener(type, listener, eventListenerOptions);\n    }\n}\nfunction fromNativeEvent(event, chart) {\n    const type = EVENT_TYPES[event.type] || event.type;\n    const { x , y  } = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.z)(event, chart);\n    return {\n        type,\n        chart,\n        native: event,\n        x: x !== undefined ? x : null,\n        y: y !== undefined ? y : null\n    };\n}\nfunction nodeListContains(nodeList, canvas) {\n    for (const node of nodeList){\n        if (node === canvas || node.contains(canvas)) {\n            return true;\n        }\n    }\n}\nfunction createAttachObserver(chart, type, listener) {\n    const canvas = chart.canvas;\n    const observer = new MutationObserver((entries)=>{\n        let trigger = false;\n        for (const entry of entries){\n            trigger = trigger || nodeListContains(entry.addedNodes, canvas);\n            trigger = trigger && !nodeListContains(entry.removedNodes, canvas);\n        }\n        if (trigger) {\n            listener();\n        }\n    });\n    observer.observe(document, {\n        childList: true,\n        subtree: true\n    });\n    return observer;\n}\nfunction createDetachObserver(chart, type, listener) {\n    const canvas = chart.canvas;\n    const observer = new MutationObserver((entries)=>{\n        let trigger = false;\n        for (const entry of entries){\n            trigger = trigger || nodeListContains(entry.removedNodes, canvas);\n            trigger = trigger && !nodeListContains(entry.addedNodes, canvas);\n        }\n        if (trigger) {\n            listener();\n        }\n    });\n    observer.observe(document, {\n        childList: true,\n        subtree: true\n    });\n    return observer;\n}\nconst drpListeningCharts = new Map();\nlet oldDevicePixelRatio = 0;\nfunction onWindowResize() {\n    const dpr = window.devicePixelRatio;\n    if (dpr === oldDevicePixelRatio) {\n        return;\n    }\n    oldDevicePixelRatio = dpr;\n    drpListeningCharts.forEach((resize, chart)=>{\n        if (chart.currentDevicePixelRatio !== dpr) {\n            resize();\n        }\n    });\n}\nfunction listenDevicePixelRatioChanges(chart, resize) {\n    if (!drpListeningCharts.size) {\n        window.addEventListener('resize', onWindowResize);\n    }\n    drpListeningCharts.set(chart, resize);\n}\nfunction unlistenDevicePixelRatioChanges(chart) {\n    drpListeningCharts.delete(chart);\n    if (!drpListeningCharts.size) {\n        window.removeEventListener('resize', onWindowResize);\n    }\n}\nfunction createResizeObserver(chart, type, listener) {\n    const canvas = chart.canvas;\n    const container = canvas && (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.I)(canvas);\n    if (!container) {\n        return;\n    }\n    const resize = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.L)((width, height)=>{\n        const w = container.clientWidth;\n        listener(width, height);\n        if (w < container.clientWidth) {\n            listener();\n        }\n    }, window);\n    const observer = new ResizeObserver((entries)=>{\n        const entry = entries[0];\n        const width = entry.contentRect.width;\n        const height = entry.contentRect.height;\n        if (width === 0 && height === 0) {\n            return;\n        }\n        resize(width, height);\n    });\n    observer.observe(container);\n    listenDevicePixelRatioChanges(chart, resize);\n    return observer;\n}\nfunction releaseObserver(chart, type, observer) {\n    if (observer) {\n        observer.disconnect();\n    }\n    if (type === 'resize') {\n        unlistenDevicePixelRatioChanges(chart);\n    }\n}\nfunction createProxyAndListen(chart, type, listener) {\n    const canvas = chart.canvas;\n    const proxy = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.L)((event)=>{\n        if (chart.ctx !== null) {\n            listener(fromNativeEvent(event, chart));\n        }\n    }, chart);\n    addListener(canvas, type, proxy);\n    return proxy;\n}\n class DomPlatform extends BasePlatform {\n acquireContext(canvas, aspectRatio) {\n        const context = canvas && canvas.getContext && canvas.getContext('2d');\n        if (context && context.canvas === canvas) {\n            initCanvas(canvas, aspectRatio);\n            return context;\n        }\n        return null;\n    }\n releaseContext(context) {\n        const canvas = context.canvas;\n        if (!canvas[EXPANDO_KEY]) {\n            return false;\n        }\n        const initial = canvas[EXPANDO_KEY].initial;\n        [\n            'height',\n            'width'\n        ].forEach((prop)=>{\n            const value = initial[prop];\n            if ((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.k)(value)) {\n                canvas.removeAttribute(prop);\n            } else {\n                canvas.setAttribute(prop, value);\n            }\n        });\n        const style = initial.style || {};\n        Object.keys(style).forEach((key)=>{\n            canvas.style[key] = style[key];\n        });\n        canvas.width = canvas.width;\n        delete canvas[EXPANDO_KEY];\n        return true;\n    }\n addEventListener(chart, type, listener) {\n        this.removeEventListener(chart, type);\n        const proxies = chart.$proxies || (chart.$proxies = {});\n        const handlers = {\n            attach: createAttachObserver,\n            detach: createDetachObserver,\n            resize: createResizeObserver\n        };\n        const handler = handlers[type] || createProxyAndListen;\n        proxies[type] = handler(chart, type, listener);\n    }\n removeEventListener(chart, type) {\n        const proxies = chart.$proxies || (chart.$proxies = {});\n        const proxy = proxies[type];\n        if (!proxy) {\n            return;\n        }\n        const handlers = {\n            attach: releaseObserver,\n            detach: releaseObserver,\n            resize: releaseObserver\n        };\n        const handler = handlers[type] || removeListener;\n        handler(chart, type, proxy);\n        proxies[type] = undefined;\n    }\n    getDevicePixelRatio() {\n        return window.devicePixelRatio;\n    }\n getMaximumSize(canvas, width, height, aspectRatio) {\n        return (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.G)(canvas, width, height, aspectRatio);\n    }\n isAttached(canvas) {\n        const container = canvas && (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.I)(canvas);\n        return !!(container && container.isConnected);\n    }\n}\n\nfunction _detectPlatform(canvas) {\n    if (!(0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.M)() || typeof OffscreenCanvas !== 'undefined' && canvas instanceof OffscreenCanvas) {\n        return BasicPlatform;\n    }\n    return DomPlatform;\n}\n\nclass Element {\n    static defaults = {};\n    static defaultRoutes = undefined;\n    x;\n    y;\n    active = false;\n    options;\n    $animations;\n    tooltipPosition(useFinalPosition) {\n        const { x , y  } = this.getProps([\n            'x',\n            'y'\n        ], useFinalPosition);\n        return {\n            x,\n            y\n        };\n    }\n    hasValue() {\n        return (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.x)(this.x) && (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.x)(this.y);\n    }\n    getProps(props, final) {\n        const anims = this.$animations;\n        if (!final || !anims) {\n            // let's not create an object, if not needed\n            return this;\n        }\n        const ret = {};\n        props.forEach((prop)=>{\n            ret[prop] = anims[prop] && anims[prop].active() ? anims[prop]._to : this[prop];\n        });\n        return ret;\n    }\n}\n\nfunction autoSkip(scale, ticks) {\n    const tickOpts = scale.options.ticks;\n    const determinedMaxTicks = determineMaxTicks(scale);\n    const ticksLimit = Math.min(tickOpts.maxTicksLimit || determinedMaxTicks, determinedMaxTicks);\n    const majorIndices = tickOpts.major.enabled ? getMajorIndices(ticks) : [];\n    const numMajorIndices = majorIndices.length;\n    const first = majorIndices[0];\n    const last = majorIndices[numMajorIndices - 1];\n    const newTicks = [];\n    if (numMajorIndices > ticksLimit) {\n        skipMajors(ticks, newTicks, majorIndices, numMajorIndices / ticksLimit);\n        return newTicks;\n    }\n    const spacing = calculateSpacing(majorIndices, ticks, ticksLimit);\n    if (numMajorIndices > 0) {\n        let i, ilen;\n        const avgMajorSpacing = numMajorIndices > 1 ? Math.round((last - first) / (numMajorIndices - 1)) : null;\n        skip(ticks, newTicks, spacing, (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.k)(avgMajorSpacing) ? 0 : first - avgMajorSpacing, first);\n        for(i = 0, ilen = numMajorIndices - 1; i < ilen; i++){\n            skip(ticks, newTicks, spacing, majorIndices[i], majorIndices[i + 1]);\n        }\n        skip(ticks, newTicks, spacing, last, (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.k)(avgMajorSpacing) ? ticks.length : last + avgMajorSpacing);\n        return newTicks;\n    }\n    skip(ticks, newTicks, spacing);\n    return newTicks;\n}\nfunction determineMaxTicks(scale) {\n    const offset = scale.options.offset;\n    const tickLength = scale._tickSize();\n    const maxScale = scale._length / tickLength + (offset ? 0 : 1);\n    const maxChart = scale._maxLength / tickLength;\n    return Math.floor(Math.min(maxScale, maxChart));\n}\n function calculateSpacing(majorIndices, ticks, ticksLimit) {\n    const evenMajorSpacing = getEvenSpacing(majorIndices);\n    const spacing = ticks.length / ticksLimit;\n    if (!evenMajorSpacing) {\n        return Math.max(spacing, 1);\n    }\n    const factors = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.N)(evenMajorSpacing);\n    for(let i = 0, ilen = factors.length - 1; i < ilen; i++){\n        const factor = factors[i];\n        if (factor > spacing) {\n            return factor;\n        }\n    }\n    return Math.max(spacing, 1);\n}\n function getMajorIndices(ticks) {\n    const result = [];\n    let i, ilen;\n    for(i = 0, ilen = ticks.length; i < ilen; i++){\n        if (ticks[i].major) {\n            result.push(i);\n        }\n    }\n    return result;\n}\n function skipMajors(ticks, newTicks, majorIndices, spacing) {\n    let count = 0;\n    let next = majorIndices[0];\n    let i;\n    spacing = Math.ceil(spacing);\n    for(i = 0; i < ticks.length; i++){\n        if (i === next) {\n            newTicks.push(ticks[i]);\n            count++;\n            next = majorIndices[count * spacing];\n        }\n    }\n}\n function skip(ticks, newTicks, spacing, majorStart, majorEnd) {\n    const start = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.v)(majorStart, 0);\n    const end = Math.min((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.v)(majorEnd, ticks.length), ticks.length);\n    let count = 0;\n    let length, i, next;\n    spacing = Math.ceil(spacing);\n    if (majorEnd) {\n        length = majorEnd - majorStart;\n        spacing = length / Math.floor(length / spacing);\n    }\n    next = start;\n    while(next < 0){\n        count++;\n        next = Math.round(start + count * spacing);\n    }\n    for(i = Math.max(start, 0); i < end; i++){\n        if (i === next) {\n            newTicks.push(ticks[i]);\n            count++;\n            next = Math.round(start + count * spacing);\n        }\n    }\n}\n function getEvenSpacing(arr) {\n    const len = arr.length;\n    let i, diff;\n    if (len < 2) {\n        return false;\n    }\n    for(diff = arr[0], i = 1; i < len; ++i){\n        if (arr[i] - arr[i - 1] !== diff) {\n            return false;\n        }\n    }\n    return diff;\n}\n\nconst reverseAlign = (align)=>align === 'left' ? 'right' : align === 'right' ? 'left' : align;\nconst offsetFromEdge = (scale, edge, offset)=>edge === 'top' || edge === 'left' ? scale[edge] + offset : scale[edge] - offset;\nconst getTicksLimit = (ticksLength, maxTicksLimit)=>Math.min(maxTicksLimit || ticksLength, ticksLength);\n function sample(arr, numItems) {\n    const result = [];\n    const increment = arr.length / numItems;\n    const len = arr.length;\n    let i = 0;\n    for(; i < len; i += increment){\n        result.push(arr[Math.floor(i)]);\n    }\n    return result;\n}\n function getPixelForGridLine(scale, index, offsetGridLines) {\n    const length = scale.ticks.length;\n    const validIndex = Math.min(index, length - 1);\n    const start = scale._startPixel;\n    const end = scale._endPixel;\n    const epsilon = 1e-6;\n    let lineValue = scale.getPixelForTick(validIndex);\n    let offset;\n    if (offsetGridLines) {\n        if (length === 1) {\n            offset = Math.max(lineValue - start, end - lineValue);\n        } else if (index === 0) {\n            offset = (scale.getPixelForTick(1) - lineValue) / 2;\n        } else {\n            offset = (lineValue - scale.getPixelForTick(validIndex - 1)) / 2;\n        }\n        lineValue += validIndex < index ? offset : -offset;\n        if (lineValue < start - epsilon || lineValue > end + epsilon) {\n            return;\n        }\n    }\n    return lineValue;\n}\n function garbageCollect(caches, length) {\n    (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.F)(caches, (cache)=>{\n        const gc = cache.gc;\n        const gcLen = gc.length / 2;\n        let i;\n        if (gcLen > length) {\n            for(i = 0; i < gcLen; ++i){\n                delete cache.data[gc[i]];\n            }\n            gc.splice(0, gcLen);\n        }\n    });\n}\n function getTickMarkLength(options) {\n    return options.drawTicks ? options.tickLength : 0;\n}\n function getTitleHeight(options, fallback) {\n    if (!options.display) {\n        return 0;\n    }\n    const font = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a0)(options.font, fallback);\n    const padding = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.E)(options.padding);\n    const lines = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.b)(options.text) ? options.text.length : 1;\n    return lines * font.lineHeight + padding.height;\n}\nfunction createScaleContext(parent, scale) {\n    return (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.j)(parent, {\n        scale,\n        type: 'scale'\n    });\n}\nfunction createTickContext(parent, index, tick) {\n    return (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.j)(parent, {\n        tick,\n        index,\n        type: 'tick'\n    });\n}\nfunction titleAlign(align, position, reverse) {\n     let ret = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a1)(align);\n    if (reverse && position !== 'right' || !reverse && position === 'right') {\n        ret = reverseAlign(ret);\n    }\n    return ret;\n}\nfunction titleArgs(scale, offset, position, align) {\n    const { top , left , bottom , right , chart  } = scale;\n    const { chartArea , scales  } = chart;\n    let rotation = 0;\n    let maxWidth, titleX, titleY;\n    const height = bottom - top;\n    const width = right - left;\n    if (scale.isHorizontal()) {\n        titleX = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a2)(align, left, right);\n        if ((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.i)(position)) {\n            const positionAxisID = Object.keys(position)[0];\n            const value = position[positionAxisID];\n            titleY = scales[positionAxisID].getPixelForValue(value) + height - offset;\n        } else if (position === 'center') {\n            titleY = (chartArea.bottom + chartArea.top) / 2 + height - offset;\n        } else {\n            titleY = offsetFromEdge(scale, position, offset);\n        }\n        maxWidth = right - left;\n    } else {\n        if ((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.i)(position)) {\n            const positionAxisID = Object.keys(position)[0];\n            const value = position[positionAxisID];\n            titleX = scales[positionAxisID].getPixelForValue(value) - width + offset;\n        } else if (position === 'center') {\n            titleX = (chartArea.left + chartArea.right) / 2 - width + offset;\n        } else {\n            titleX = offsetFromEdge(scale, position, offset);\n        }\n        titleY = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a2)(align, bottom, top);\n        rotation = position === 'left' ? -_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.H : _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.H;\n    }\n    return {\n        titleX,\n        titleY,\n        maxWidth,\n        rotation\n    };\n}\nclass Scale extends Element {\n    constructor(cfg){\n        super();\n         this.id = cfg.id;\n         this.type = cfg.type;\n         this.options = undefined;\n         this.ctx = cfg.ctx;\n         this.chart = cfg.chart;\n         this.top = undefined;\n         this.bottom = undefined;\n         this.left = undefined;\n         this.right = undefined;\n         this.width = undefined;\n         this.height = undefined;\n        this._margins = {\n            left: 0,\n            right: 0,\n            top: 0,\n            bottom: 0\n        };\n         this.maxWidth = undefined;\n         this.maxHeight = undefined;\n         this.paddingTop = undefined;\n         this.paddingBottom = undefined;\n         this.paddingLeft = undefined;\n         this.paddingRight = undefined;\n         this.axis = undefined;\n         this.labelRotation = undefined;\n        this.min = undefined;\n        this.max = undefined;\n        this._range = undefined;\n         this.ticks = [];\n         this._gridLineItems = null;\n         this._labelItems = null;\n         this._labelSizes = null;\n        this._length = 0;\n        this._maxLength = 0;\n        this._longestTextCache = {};\n         this._startPixel = undefined;\n         this._endPixel = undefined;\n        this._reversePixels = false;\n        this._userMax = undefined;\n        this._userMin = undefined;\n        this._suggestedMax = undefined;\n        this._suggestedMin = undefined;\n        this._ticksLength = 0;\n        this._borderValue = 0;\n        this._cache = {};\n        this._dataLimitsCached = false;\n        this.$context = undefined;\n    }\n init(options) {\n        this.options = options.setContext(this.getContext());\n        this.axis = options.axis;\n        this._userMin = this.parse(options.min);\n        this._userMax = this.parse(options.max);\n        this._suggestedMin = this.parse(options.suggestedMin);\n        this._suggestedMax = this.parse(options.suggestedMax);\n    }\n parse(raw, index) {\n        return raw;\n    }\n getUserBounds() {\n        let { _userMin , _userMax , _suggestedMin , _suggestedMax  } = this;\n        _userMin = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.O)(_userMin, Number.POSITIVE_INFINITY);\n        _userMax = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.O)(_userMax, Number.NEGATIVE_INFINITY);\n        _suggestedMin = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.O)(_suggestedMin, Number.POSITIVE_INFINITY);\n        _suggestedMax = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.O)(_suggestedMax, Number.NEGATIVE_INFINITY);\n        return {\n            min: (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.O)(_userMin, _suggestedMin),\n            max: (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.O)(_userMax, _suggestedMax),\n            minDefined: (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.g)(_userMin),\n            maxDefined: (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.g)(_userMax)\n        };\n    }\n getMinMax(canStack) {\n        let { min , max , minDefined , maxDefined  } = this.getUserBounds();\n        let range;\n        if (minDefined && maxDefined) {\n            return {\n                min,\n                max\n            };\n        }\n        const metas = this.getMatchingVisibleMetas();\n        for(let i = 0, ilen = metas.length; i < ilen; ++i){\n            range = metas[i].controller.getMinMax(this, canStack);\n            if (!minDefined) {\n                min = Math.min(min, range.min);\n            }\n            if (!maxDefined) {\n                max = Math.max(max, range.max);\n            }\n        }\n        min = maxDefined && min > max ? max : min;\n        max = minDefined && min > max ? min : max;\n        return {\n            min: (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.O)(min, (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.O)(max, min)),\n            max: (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.O)(max, (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.O)(min, max))\n        };\n    }\n getPadding() {\n        return {\n            left: this.paddingLeft || 0,\n            top: this.paddingTop || 0,\n            right: this.paddingRight || 0,\n            bottom: this.paddingBottom || 0\n        };\n    }\n getTicks() {\n        return this.ticks;\n    }\n getLabels() {\n        const data = this.chart.data;\n        return this.options.labels || (this.isHorizontal() ? data.xLabels : data.yLabels) || data.labels || [];\n    }\n getLabelItems(chartArea = this.chart.chartArea) {\n        const items = this._labelItems || (this._labelItems = this._computeLabelItems(chartArea));\n        return items;\n    }\n    beforeLayout() {\n        this._cache = {};\n        this._dataLimitsCached = false;\n    }\n    beforeUpdate() {\n        (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.Q)(this.options.beforeUpdate, [\n            this\n        ]);\n    }\n update(maxWidth, maxHeight, margins) {\n        const { beginAtZero , grace , ticks: tickOpts  } = this.options;\n        const sampleSize = tickOpts.sampleSize;\n        this.beforeUpdate();\n        this.maxWidth = maxWidth;\n        this.maxHeight = maxHeight;\n        this._margins = margins = Object.assign({\n            left: 0,\n            right: 0,\n            top: 0,\n            bottom: 0\n        }, margins);\n        this.ticks = null;\n        this._labelSizes = null;\n        this._gridLineItems = null;\n        this._labelItems = null;\n        this.beforeSetDimensions();\n        this.setDimensions();\n        this.afterSetDimensions();\n        this._maxLength = this.isHorizontal() ? this.width + margins.left + margins.right : this.height + margins.top + margins.bottom;\n        if (!this._dataLimitsCached) {\n            this.beforeDataLimits();\n            this.determineDataLimits();\n            this.afterDataLimits();\n            this._range = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.R)(this, grace, beginAtZero);\n            this._dataLimitsCached = true;\n        }\n        this.beforeBuildTicks();\n        this.ticks = this.buildTicks() || [];\n        this.afterBuildTicks();\n        const samplingEnabled = sampleSize < this.ticks.length;\n        this._convertTicksToLabels(samplingEnabled ? sample(this.ticks, sampleSize) : this.ticks);\n        this.configure();\n        this.beforeCalculateLabelRotation();\n        this.calculateLabelRotation();\n        this.afterCalculateLabelRotation();\n        if (tickOpts.display && (tickOpts.autoSkip || tickOpts.source === 'auto')) {\n            this.ticks = autoSkip(this, this.ticks);\n            this._labelSizes = null;\n            this.afterAutoSkip();\n        }\n        if (samplingEnabled) {\n            this._convertTicksToLabels(this.ticks);\n        }\n        this.beforeFit();\n        this.fit();\n        this.afterFit();\n        this.afterUpdate();\n    }\n configure() {\n        let reversePixels = this.options.reverse;\n        let startPixel, endPixel;\n        if (this.isHorizontal()) {\n            startPixel = this.left;\n            endPixel = this.right;\n        } else {\n            startPixel = this.top;\n            endPixel = this.bottom;\n            reversePixels = !reversePixels;\n        }\n        this._startPixel = startPixel;\n        this._endPixel = endPixel;\n        this._reversePixels = reversePixels;\n        this._length = endPixel - startPixel;\n        this._alignToPixels = this.options.alignToPixels;\n    }\n    afterUpdate() {\n        (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.Q)(this.options.afterUpdate, [\n            this\n        ]);\n    }\n    beforeSetDimensions() {\n        (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.Q)(this.options.beforeSetDimensions, [\n            this\n        ]);\n    }\n    setDimensions() {\n        if (this.isHorizontal()) {\n            this.width = this.maxWidth;\n            this.left = 0;\n            this.right = this.width;\n        } else {\n            this.height = this.maxHeight;\n            this.top = 0;\n            this.bottom = this.height;\n        }\n        this.paddingLeft = 0;\n        this.paddingTop = 0;\n        this.paddingRight = 0;\n        this.paddingBottom = 0;\n    }\n    afterSetDimensions() {\n        (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.Q)(this.options.afterSetDimensions, [\n            this\n        ]);\n    }\n    _callHooks(name) {\n        this.chart.notifyPlugins(name, this.getContext());\n        (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.Q)(this.options[name], [\n            this\n        ]);\n    }\n    beforeDataLimits() {\n        this._callHooks('beforeDataLimits');\n    }\n    determineDataLimits() {}\n    afterDataLimits() {\n        this._callHooks('afterDataLimits');\n    }\n    beforeBuildTicks() {\n        this._callHooks('beforeBuildTicks');\n    }\n buildTicks() {\n        return [];\n    }\n    afterBuildTicks() {\n        this._callHooks('afterBuildTicks');\n    }\n    beforeTickToLabelConversion() {\n        (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.Q)(this.options.beforeTickToLabelConversion, [\n            this\n        ]);\n    }\n generateTickLabels(ticks) {\n        const tickOpts = this.options.ticks;\n        let i, ilen, tick;\n        for(i = 0, ilen = ticks.length; i < ilen; i++){\n            tick = ticks[i];\n            tick.label = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.Q)(tickOpts.callback, [\n                tick.value,\n                i,\n                ticks\n            ], this);\n        }\n    }\n    afterTickToLabelConversion() {\n        (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.Q)(this.options.afterTickToLabelConversion, [\n            this\n        ]);\n    }\n    beforeCalculateLabelRotation() {\n        (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.Q)(this.options.beforeCalculateLabelRotation, [\n            this\n        ]);\n    }\n    calculateLabelRotation() {\n        const options = this.options;\n        const tickOpts = options.ticks;\n        const numTicks = getTicksLimit(this.ticks.length, options.ticks.maxTicksLimit);\n        const minRotation = tickOpts.minRotation || 0;\n        const maxRotation = tickOpts.maxRotation;\n        let labelRotation = minRotation;\n        let tickWidth, maxHeight, maxLabelDiagonal;\n        if (!this._isVisible() || !tickOpts.display || minRotation >= maxRotation || numTicks <= 1 || !this.isHorizontal()) {\n            this.labelRotation = minRotation;\n            return;\n        }\n        const labelSizes = this._getLabelSizes();\n        const maxLabelWidth = labelSizes.widest.width;\n        const maxLabelHeight = labelSizes.highest.height;\n        const maxWidth = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.S)(this.chart.width - maxLabelWidth, 0, this.maxWidth);\n        tickWidth = options.offset ? this.maxWidth / numTicks : maxWidth / (numTicks - 1);\n        if (maxLabelWidth + 6 > tickWidth) {\n            tickWidth = maxWidth / (numTicks - (options.offset ? 0.5 : 1));\n            maxHeight = this.maxHeight - getTickMarkLength(options.grid) - tickOpts.padding - getTitleHeight(options.title, this.chart.options.font);\n            maxLabelDiagonal = Math.sqrt(maxLabelWidth * maxLabelWidth + maxLabelHeight * maxLabelHeight);\n            labelRotation = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.U)(Math.min(Math.asin((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.S)((labelSizes.highest.height + 6) / tickWidth, -1, 1)), Math.asin((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.S)(maxHeight / maxLabelDiagonal, -1, 1)) - Math.asin((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.S)(maxLabelHeight / maxLabelDiagonal, -1, 1))));\n            labelRotation = Math.max(minRotation, Math.min(maxRotation, labelRotation));\n        }\n        this.labelRotation = labelRotation;\n    }\n    afterCalculateLabelRotation() {\n        (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.Q)(this.options.afterCalculateLabelRotation, [\n            this\n        ]);\n    }\n    afterAutoSkip() {}\n    beforeFit() {\n        (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.Q)(this.options.beforeFit, [\n            this\n        ]);\n    }\n    fit() {\n        const minSize = {\n            width: 0,\n            height: 0\n        };\n        const { chart , options: { ticks: tickOpts , title: titleOpts , grid: gridOpts  }  } = this;\n        const display = this._isVisible();\n        const isHorizontal = this.isHorizontal();\n        if (display) {\n            const titleHeight = getTitleHeight(titleOpts, chart.options.font);\n            if (isHorizontal) {\n                minSize.width = this.maxWidth;\n                minSize.height = getTickMarkLength(gridOpts) + titleHeight;\n            } else {\n                minSize.height = this.maxHeight;\n                minSize.width = getTickMarkLength(gridOpts) + titleHeight;\n            }\n            if (tickOpts.display && this.ticks.length) {\n                const { first , last , widest , highest  } = this._getLabelSizes();\n                const tickPadding = tickOpts.padding * 2;\n                const angleRadians = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.t)(this.labelRotation);\n                const cos = Math.cos(angleRadians);\n                const sin = Math.sin(angleRadians);\n                if (isHorizontal) {\n                    const labelHeight = tickOpts.mirror ? 0 : sin * widest.width + cos * highest.height;\n                    minSize.height = Math.min(this.maxHeight, minSize.height + labelHeight + tickPadding);\n                } else {\n                    const labelWidth = tickOpts.mirror ? 0 : cos * widest.width + sin * highest.height;\n                    minSize.width = Math.min(this.maxWidth, minSize.width + labelWidth + tickPadding);\n                }\n                this._calculatePadding(first, last, sin, cos);\n            }\n        }\n        this._handleMargins();\n        if (isHorizontal) {\n            this.width = this._length = chart.width - this._margins.left - this._margins.right;\n            this.height = minSize.height;\n        } else {\n            this.width = minSize.width;\n            this.height = this._length = chart.height - this._margins.top - this._margins.bottom;\n        }\n    }\n    _calculatePadding(first, last, sin, cos) {\n        const { ticks: { align , padding  } , position  } = this.options;\n        const isRotated = this.labelRotation !== 0;\n        const labelsBelowTicks = position !== 'top' && this.axis === 'x';\n        if (this.isHorizontal()) {\n            const offsetLeft = this.getPixelForTick(0) - this.left;\n            const offsetRight = this.right - this.getPixelForTick(this.ticks.length - 1);\n            let paddingLeft = 0;\n            let paddingRight = 0;\n            if (isRotated) {\n                if (labelsBelowTicks) {\n                    paddingLeft = cos * first.width;\n                    paddingRight = sin * last.height;\n                } else {\n                    paddingLeft = sin * first.height;\n                    paddingRight = cos * last.width;\n                }\n            } else if (align === 'start') {\n                paddingRight = last.width;\n            } else if (align === 'end') {\n                paddingLeft = first.width;\n            } else if (align !== 'inner') {\n                paddingLeft = first.width / 2;\n                paddingRight = last.width / 2;\n            }\n            this.paddingLeft = Math.max((paddingLeft - offsetLeft + padding) * this.width / (this.width - offsetLeft), 0);\n            this.paddingRight = Math.max((paddingRight - offsetRight + padding) * this.width / (this.width - offsetRight), 0);\n        } else {\n            let paddingTop = last.height / 2;\n            let paddingBottom = first.height / 2;\n            if (align === 'start') {\n                paddingTop = 0;\n                paddingBottom = first.height;\n            } else if (align === 'end') {\n                paddingTop = last.height;\n                paddingBottom = 0;\n            }\n            this.paddingTop = paddingTop + padding;\n            this.paddingBottom = paddingBottom + padding;\n        }\n    }\n _handleMargins() {\n        if (this._margins) {\n            this._margins.left = Math.max(this.paddingLeft, this._margins.left);\n            this._margins.top = Math.max(this.paddingTop, this._margins.top);\n            this._margins.right = Math.max(this.paddingRight, this._margins.right);\n            this._margins.bottom = Math.max(this.paddingBottom, this._margins.bottom);\n        }\n    }\n    afterFit() {\n        (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.Q)(this.options.afterFit, [\n            this\n        ]);\n    }\n isHorizontal() {\n        const { axis , position  } = this.options;\n        return position === 'top' || position === 'bottom' || axis === 'x';\n    }\n isFullSize() {\n        return this.options.fullSize;\n    }\n _convertTicksToLabels(ticks) {\n        this.beforeTickToLabelConversion();\n        this.generateTickLabels(ticks);\n        let i, ilen;\n        for(i = 0, ilen = ticks.length; i < ilen; i++){\n            if ((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.k)(ticks[i].label)) {\n                ticks.splice(i, 1);\n                ilen--;\n                i--;\n            }\n        }\n        this.afterTickToLabelConversion();\n    }\n _getLabelSizes() {\n        let labelSizes = this._labelSizes;\n        if (!labelSizes) {\n            const sampleSize = this.options.ticks.sampleSize;\n            let ticks = this.ticks;\n            if (sampleSize < ticks.length) {\n                ticks = sample(ticks, sampleSize);\n            }\n            this._labelSizes = labelSizes = this._computeLabelSizes(ticks, ticks.length, this.options.ticks.maxTicksLimit);\n        }\n        return labelSizes;\n    }\n _computeLabelSizes(ticks, length, maxTicksLimit) {\n        const { ctx , _longestTextCache: caches  } = this;\n        const widths = [];\n        const heights = [];\n        const increment = Math.floor(length / getTicksLimit(length, maxTicksLimit));\n        let widestLabelSize = 0;\n        let highestLabelSize = 0;\n        let i, j, jlen, label, tickFont, fontString, cache, lineHeight, width, height, nestedLabel;\n        for(i = 0; i < length; i += increment){\n            label = ticks[i].label;\n            tickFont = this._resolveTickFontOptions(i);\n            ctx.font = fontString = tickFont.string;\n            cache = caches[fontString] = caches[fontString] || {\n                data: {},\n                gc: []\n            };\n            lineHeight = tickFont.lineHeight;\n            width = height = 0;\n            if (!(0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.k)(label) && !(0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.b)(label)) {\n                width = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.V)(ctx, cache.data, cache.gc, width, label);\n                height = lineHeight;\n            } else if ((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.b)(label)) {\n                for(j = 0, jlen = label.length; j < jlen; ++j){\n                    nestedLabel =  label[j];\n                    if (!(0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.k)(nestedLabel) && !(0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.b)(nestedLabel)) {\n                        width = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.V)(ctx, cache.data, cache.gc, width, nestedLabel);\n                        height += lineHeight;\n                    }\n                }\n            }\n            widths.push(width);\n            heights.push(height);\n            widestLabelSize = Math.max(width, widestLabelSize);\n            highestLabelSize = Math.max(height, highestLabelSize);\n        }\n        garbageCollect(caches, length);\n        const widest = widths.indexOf(widestLabelSize);\n        const highest = heights.indexOf(highestLabelSize);\n        const valueAt = (idx)=>({\n                width: widths[idx] || 0,\n                height: heights[idx] || 0\n            });\n        return {\n            first: valueAt(0),\n            last: valueAt(length - 1),\n            widest: valueAt(widest),\n            highest: valueAt(highest),\n            widths,\n            heights\n        };\n    }\n getLabelForValue(value) {\n        return value;\n    }\n getPixelForValue(value, index) {\n        return NaN;\n    }\n getValueForPixel(pixel) {}\n getPixelForTick(index) {\n        const ticks = this.ticks;\n        if (index < 0 || index > ticks.length - 1) {\n            return null;\n        }\n        return this.getPixelForValue(ticks[index].value);\n    }\n getPixelForDecimal(decimal) {\n        if (this._reversePixels) {\n            decimal = 1 - decimal;\n        }\n        const pixel = this._startPixel + decimal * this._length;\n        return (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.W)(this._alignToPixels ? (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.X)(this.chart, pixel, 0) : pixel);\n    }\n getDecimalForPixel(pixel) {\n        const decimal = (pixel - this._startPixel) / this._length;\n        return this._reversePixels ? 1 - decimal : decimal;\n    }\n getBasePixel() {\n        return this.getPixelForValue(this.getBaseValue());\n    }\n getBaseValue() {\n        const { min , max  } = this;\n        return min < 0 && max < 0 ? max : min > 0 && max > 0 ? min : 0;\n    }\n getContext(index) {\n        const ticks = this.ticks || [];\n        if (index >= 0 && index < ticks.length) {\n            const tick = ticks[index];\n            return tick.$context || (tick.$context = createTickContext(this.getContext(), index, tick));\n        }\n        return this.$context || (this.$context = createScaleContext(this.chart.getContext(), this));\n    }\n _tickSize() {\n        const optionTicks = this.options.ticks;\n        const rot = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.t)(this.labelRotation);\n        const cos = Math.abs(Math.cos(rot));\n        const sin = Math.abs(Math.sin(rot));\n        const labelSizes = this._getLabelSizes();\n        const padding = optionTicks.autoSkipPadding || 0;\n        const w = labelSizes ? labelSizes.widest.width + padding : 0;\n        const h = labelSizes ? labelSizes.highest.height + padding : 0;\n        return this.isHorizontal() ? h * cos > w * sin ? w / cos : h / sin : h * sin < w * cos ? h / cos : w / sin;\n    }\n _isVisible() {\n        const display = this.options.display;\n        if (display !== 'auto') {\n            return !!display;\n        }\n        return this.getMatchingVisibleMetas().length > 0;\n    }\n _computeGridLineItems(chartArea) {\n        const axis = this.axis;\n        const chart = this.chart;\n        const options = this.options;\n        const { grid , position , border  } = options;\n        const offset = grid.offset;\n        const isHorizontal = this.isHorizontal();\n        const ticks = this.ticks;\n        const ticksLength = ticks.length + (offset ? 1 : 0);\n        const tl = getTickMarkLength(grid);\n        const items = [];\n        const borderOpts = border.setContext(this.getContext());\n        const axisWidth = borderOpts.display ? borderOpts.width : 0;\n        const axisHalfWidth = axisWidth / 2;\n        const alignBorderValue = function(pixel) {\n            return (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.X)(chart, pixel, axisWidth);\n        };\n        let borderValue, i, lineValue, alignedLineValue;\n        let tx1, ty1, tx2, ty2, x1, y1, x2, y2;\n        if (position === 'top') {\n            borderValue = alignBorderValue(this.bottom);\n            ty1 = this.bottom - tl;\n            ty2 = borderValue - axisHalfWidth;\n            y1 = alignBorderValue(chartArea.top) + axisHalfWidth;\n            y2 = chartArea.bottom;\n        } else if (position === 'bottom') {\n            borderValue = alignBorderValue(this.top);\n            y1 = chartArea.top;\n            y2 = alignBorderValue(chartArea.bottom) - axisHalfWidth;\n            ty1 = borderValue + axisHalfWidth;\n            ty2 = this.top + tl;\n        } else if (position === 'left') {\n            borderValue = alignBorderValue(this.right);\n            tx1 = this.right - tl;\n            tx2 = borderValue - axisHalfWidth;\n            x1 = alignBorderValue(chartArea.left) + axisHalfWidth;\n            x2 = chartArea.right;\n        } else if (position === 'right') {\n            borderValue = alignBorderValue(this.left);\n            x1 = chartArea.left;\n            x2 = alignBorderValue(chartArea.right) - axisHalfWidth;\n            tx1 = borderValue + axisHalfWidth;\n            tx2 = this.left + tl;\n        } else if (axis === 'x') {\n            if (position === 'center') {\n                borderValue = alignBorderValue((chartArea.top + chartArea.bottom) / 2 + 0.5);\n            } else if ((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.i)(position)) {\n                const positionAxisID = Object.keys(position)[0];\n                const value = position[positionAxisID];\n                borderValue = alignBorderValue(this.chart.scales[positionAxisID].getPixelForValue(value));\n            }\n            y1 = chartArea.top;\n            y2 = chartArea.bottom;\n            ty1 = borderValue + axisHalfWidth;\n            ty2 = ty1 + tl;\n        } else if (axis === 'y') {\n            if (position === 'center') {\n                borderValue = alignBorderValue((chartArea.left + chartArea.right) / 2);\n            } else if ((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.i)(position)) {\n                const positionAxisID = Object.keys(position)[0];\n                const value = position[positionAxisID];\n                borderValue = alignBorderValue(this.chart.scales[positionAxisID].getPixelForValue(value));\n            }\n            tx1 = borderValue - axisHalfWidth;\n            tx2 = tx1 - tl;\n            x1 = chartArea.left;\n            x2 = chartArea.right;\n        }\n        const limit = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.v)(options.ticks.maxTicksLimit, ticksLength);\n        const step = Math.max(1, Math.ceil(ticksLength / limit));\n        for(i = 0; i < ticksLength; i += step){\n            const context = this.getContext(i);\n            const optsAtIndex = grid.setContext(context);\n            const optsAtIndexBorder = border.setContext(context);\n            const lineWidth = optsAtIndex.lineWidth;\n            const lineColor = optsAtIndex.color;\n            const borderDash = optsAtIndexBorder.dash || [];\n            const borderDashOffset = optsAtIndexBorder.dashOffset;\n            const tickWidth = optsAtIndex.tickWidth;\n            const tickColor = optsAtIndex.tickColor;\n            const tickBorderDash = optsAtIndex.tickBorderDash || [];\n            const tickBorderDashOffset = optsAtIndex.tickBorderDashOffset;\n            lineValue = getPixelForGridLine(this, i, offset);\n            if (lineValue === undefined) {\n                continue;\n            }\n            alignedLineValue = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.X)(chart, lineValue, lineWidth);\n            if (isHorizontal) {\n                tx1 = tx2 = x1 = x2 = alignedLineValue;\n            } else {\n                ty1 = ty2 = y1 = y2 = alignedLineValue;\n            }\n            items.push({\n                tx1,\n                ty1,\n                tx2,\n                ty2,\n                x1,\n                y1,\n                x2,\n                y2,\n                width: lineWidth,\n                color: lineColor,\n                borderDash,\n                borderDashOffset,\n                tickWidth,\n                tickColor,\n                tickBorderDash,\n                tickBorderDashOffset\n            });\n        }\n        this._ticksLength = ticksLength;\n        this._borderValue = borderValue;\n        return items;\n    }\n _computeLabelItems(chartArea) {\n        const axis = this.axis;\n        const options = this.options;\n        const { position , ticks: optionTicks  } = options;\n        const isHorizontal = this.isHorizontal();\n        const ticks = this.ticks;\n        const { align , crossAlign , padding , mirror  } = optionTicks;\n        const tl = getTickMarkLength(options.grid);\n        const tickAndPadding = tl + padding;\n        const hTickAndPadding = mirror ? -padding : tickAndPadding;\n        const rotation = -(0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.t)(this.labelRotation);\n        const items = [];\n        let i, ilen, tick, label, x, y, textAlign, pixel, font, lineHeight, lineCount, textOffset;\n        let textBaseline = 'middle';\n        if (position === 'top') {\n            y = this.bottom - hTickAndPadding;\n            textAlign = this._getXAxisLabelAlignment();\n        } else if (position === 'bottom') {\n            y = this.top + hTickAndPadding;\n            textAlign = this._getXAxisLabelAlignment();\n        } else if (position === 'left') {\n            const ret = this._getYAxisLabelAlignment(tl);\n            textAlign = ret.textAlign;\n            x = ret.x;\n        } else if (position === 'right') {\n            const ret = this._getYAxisLabelAlignment(tl);\n            textAlign = ret.textAlign;\n            x = ret.x;\n        } else if (axis === 'x') {\n            if (position === 'center') {\n                y = (chartArea.top + chartArea.bottom) / 2 + tickAndPadding;\n            } else if ((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.i)(position)) {\n                const positionAxisID = Object.keys(position)[0];\n                const value = position[positionAxisID];\n                y = this.chart.scales[positionAxisID].getPixelForValue(value) + tickAndPadding;\n            }\n            textAlign = this._getXAxisLabelAlignment();\n        } else if (axis === 'y') {\n            if (position === 'center') {\n                x = (chartArea.left + chartArea.right) / 2 - tickAndPadding;\n            } else if ((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.i)(position)) {\n                const positionAxisID = Object.keys(position)[0];\n                const value = position[positionAxisID];\n                x = this.chart.scales[positionAxisID].getPixelForValue(value);\n            }\n            textAlign = this._getYAxisLabelAlignment(tl).textAlign;\n        }\n        if (axis === 'y') {\n            if (align === 'start') {\n                textBaseline = 'top';\n            } else if (align === 'end') {\n                textBaseline = 'bottom';\n            }\n        }\n        const labelSizes = this._getLabelSizes();\n        for(i = 0, ilen = ticks.length; i < ilen; ++i){\n            tick = ticks[i];\n            label = tick.label;\n            const optsAtIndex = optionTicks.setContext(this.getContext(i));\n            pixel = this.getPixelForTick(i) + optionTicks.labelOffset;\n            font = this._resolveTickFontOptions(i);\n            lineHeight = font.lineHeight;\n            lineCount = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.b)(label) ? label.length : 1;\n            const halfCount = lineCount / 2;\n            const color = optsAtIndex.color;\n            const strokeColor = optsAtIndex.textStrokeColor;\n            const strokeWidth = optsAtIndex.textStrokeWidth;\n            let tickTextAlign = textAlign;\n            if (isHorizontal) {\n                x = pixel;\n                if (textAlign === 'inner') {\n                    if (i === ilen - 1) {\n                        tickTextAlign = !this.options.reverse ? 'right' : 'left';\n                    } else if (i === 0) {\n                        tickTextAlign = !this.options.reverse ? 'left' : 'right';\n                    } else {\n                        tickTextAlign = 'center';\n                    }\n                }\n                if (position === 'top') {\n                    if (crossAlign === 'near' || rotation !== 0) {\n                        textOffset = -lineCount * lineHeight + lineHeight / 2;\n                    } else if (crossAlign === 'center') {\n                        textOffset = -labelSizes.highest.height / 2 - halfCount * lineHeight + lineHeight;\n                    } else {\n                        textOffset = -labelSizes.highest.height + lineHeight / 2;\n                    }\n                } else {\n                    if (crossAlign === 'near' || rotation !== 0) {\n                        textOffset = lineHeight / 2;\n                    } else if (crossAlign === 'center') {\n                        textOffset = labelSizes.highest.height / 2 - halfCount * lineHeight;\n                    } else {\n                        textOffset = labelSizes.highest.height - lineCount * lineHeight;\n                    }\n                }\n                if (mirror) {\n                    textOffset *= -1;\n                }\n                if (rotation !== 0 && !optsAtIndex.showLabelBackdrop) {\n                    x += lineHeight / 2 * Math.sin(rotation);\n                }\n            } else {\n                y = pixel;\n                textOffset = (1 - lineCount) * lineHeight / 2;\n            }\n            let backdrop;\n            if (optsAtIndex.showLabelBackdrop) {\n                const labelPadding = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.E)(optsAtIndex.backdropPadding);\n                const height = labelSizes.heights[i];\n                const width = labelSizes.widths[i];\n                let top = textOffset - labelPadding.top;\n                let left = 0 - labelPadding.left;\n                switch(textBaseline){\n                    case 'middle':\n                        top -= height / 2;\n                        break;\n                    case 'bottom':\n                        top -= height;\n                        break;\n                }\n                switch(textAlign){\n                    case 'center':\n                        left -= width / 2;\n                        break;\n                    case 'right':\n                        left -= width;\n                        break;\n                    case 'inner':\n                        if (i === ilen - 1) {\n                            left -= width;\n                        } else if (i > 0) {\n                            left -= width / 2;\n                        }\n                        break;\n                }\n                backdrop = {\n                    left,\n                    top,\n                    width: width + labelPadding.width,\n                    height: height + labelPadding.height,\n                    color: optsAtIndex.backdropColor\n                };\n            }\n            items.push({\n                label,\n                font,\n                textOffset,\n                options: {\n                    rotation,\n                    color,\n                    strokeColor,\n                    strokeWidth,\n                    textAlign: tickTextAlign,\n                    textBaseline,\n                    translation: [\n                        x,\n                        y\n                    ],\n                    backdrop\n                }\n            });\n        }\n        return items;\n    }\n    _getXAxisLabelAlignment() {\n        const { position , ticks  } = this.options;\n        const rotation = -(0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.t)(this.labelRotation);\n        if (rotation) {\n            return position === 'top' ? 'left' : 'right';\n        }\n        let align = 'center';\n        if (ticks.align === 'start') {\n            align = 'left';\n        } else if (ticks.align === 'end') {\n            align = 'right';\n        } else if (ticks.align === 'inner') {\n            align = 'inner';\n        }\n        return align;\n    }\n    _getYAxisLabelAlignment(tl) {\n        const { position , ticks: { crossAlign , mirror , padding  }  } = this.options;\n        const labelSizes = this._getLabelSizes();\n        const tickAndPadding = tl + padding;\n        const widest = labelSizes.widest.width;\n        let textAlign;\n        let x;\n        if (position === 'left') {\n            if (mirror) {\n                x = this.right + padding;\n                if (crossAlign === 'near') {\n                    textAlign = 'left';\n                } else if (crossAlign === 'center') {\n                    textAlign = 'center';\n                    x += widest / 2;\n                } else {\n                    textAlign = 'right';\n                    x += widest;\n                }\n            } else {\n                x = this.right - tickAndPadding;\n                if (crossAlign === 'near') {\n                    textAlign = 'right';\n                } else if (crossAlign === 'center') {\n                    textAlign = 'center';\n                    x -= widest / 2;\n                } else {\n                    textAlign = 'left';\n                    x = this.left;\n                }\n            }\n        } else if (position === 'right') {\n            if (mirror) {\n                x = this.left + padding;\n                if (crossAlign === 'near') {\n                    textAlign = 'right';\n                } else if (crossAlign === 'center') {\n                    textAlign = 'center';\n                    x -= widest / 2;\n                } else {\n                    textAlign = 'left';\n                    x -= widest;\n                }\n            } else {\n                x = this.left + tickAndPadding;\n                if (crossAlign === 'near') {\n                    textAlign = 'left';\n                } else if (crossAlign === 'center') {\n                    textAlign = 'center';\n                    x += widest / 2;\n                } else {\n                    textAlign = 'right';\n                    x = this.right;\n                }\n            }\n        } else {\n            textAlign = 'right';\n        }\n        return {\n            textAlign,\n            x\n        };\n    }\n _computeLabelArea() {\n        if (this.options.ticks.mirror) {\n            return;\n        }\n        const chart = this.chart;\n        const position = this.options.position;\n        if (position === 'left' || position === 'right') {\n            return {\n                top: 0,\n                left: this.left,\n                bottom: chart.height,\n                right: this.right\n            };\n        }\n        if (position === 'top' || position === 'bottom') {\n            return {\n                top: this.top,\n                left: 0,\n                bottom: this.bottom,\n                right: chart.width\n            };\n        }\n    }\n drawBackground() {\n        const { ctx , options: { backgroundColor  } , left , top , width , height  } = this;\n        if (backgroundColor) {\n            ctx.save();\n            ctx.fillStyle = backgroundColor;\n            ctx.fillRect(left, top, width, height);\n            ctx.restore();\n        }\n    }\n    getLineWidthForValue(value) {\n        const grid = this.options.grid;\n        if (!this._isVisible() || !grid.display) {\n            return 0;\n        }\n        const ticks = this.ticks;\n        const index = ticks.findIndex((t)=>t.value === value);\n        if (index >= 0) {\n            const opts = grid.setContext(this.getContext(index));\n            return opts.lineWidth;\n        }\n        return 0;\n    }\n drawGrid(chartArea) {\n        const grid = this.options.grid;\n        const ctx = this.ctx;\n        const items = this._gridLineItems || (this._gridLineItems = this._computeGridLineItems(chartArea));\n        let i, ilen;\n        const drawLine = (p1, p2, style)=>{\n            if (!style.width || !style.color) {\n                return;\n            }\n            ctx.save();\n            ctx.lineWidth = style.width;\n            ctx.strokeStyle = style.color;\n            ctx.setLineDash(style.borderDash || []);\n            ctx.lineDashOffset = style.borderDashOffset;\n            ctx.beginPath();\n            ctx.moveTo(p1.x, p1.y);\n            ctx.lineTo(p2.x, p2.y);\n            ctx.stroke();\n            ctx.restore();\n        };\n        if (grid.display) {\n            for(i = 0, ilen = items.length; i < ilen; ++i){\n                const item = items[i];\n                if (grid.drawOnChartArea) {\n                    drawLine({\n                        x: item.x1,\n                        y: item.y1\n                    }, {\n                        x: item.x2,\n                        y: item.y2\n                    }, item);\n                }\n                if (grid.drawTicks) {\n                    drawLine({\n                        x: item.tx1,\n                        y: item.ty1\n                    }, {\n                        x: item.tx2,\n                        y: item.ty2\n                    }, {\n                        color: item.tickColor,\n                        width: item.tickWidth,\n                        borderDash: item.tickBorderDash,\n                        borderDashOffset: item.tickBorderDashOffset\n                    });\n                }\n            }\n        }\n    }\n drawBorder() {\n        const { chart , ctx , options: { border , grid  }  } = this;\n        const borderOpts = border.setContext(this.getContext());\n        const axisWidth = border.display ? borderOpts.width : 0;\n        if (!axisWidth) {\n            return;\n        }\n        const lastLineWidth = grid.setContext(this.getContext(0)).lineWidth;\n        const borderValue = this._borderValue;\n        let x1, x2, y1, y2;\n        if (this.isHorizontal()) {\n            x1 = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.X)(chart, this.left, axisWidth) - axisWidth / 2;\n            x2 = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.X)(chart, this.right, lastLineWidth) + lastLineWidth / 2;\n            y1 = y2 = borderValue;\n        } else {\n            y1 = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.X)(chart, this.top, axisWidth) - axisWidth / 2;\n            y2 = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.X)(chart, this.bottom, lastLineWidth) + lastLineWidth / 2;\n            x1 = x2 = borderValue;\n        }\n        ctx.save();\n        ctx.lineWidth = borderOpts.width;\n        ctx.strokeStyle = borderOpts.color;\n        ctx.beginPath();\n        ctx.moveTo(x1, y1);\n        ctx.lineTo(x2, y2);\n        ctx.stroke();\n        ctx.restore();\n    }\n drawLabels(chartArea) {\n        const optionTicks = this.options.ticks;\n        if (!optionTicks.display) {\n            return;\n        }\n        const ctx = this.ctx;\n        const area = this._computeLabelArea();\n        if (area) {\n            (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.Y)(ctx, area);\n        }\n        const items = this.getLabelItems(chartArea);\n        for (const item of items){\n            const renderTextOptions = item.options;\n            const tickFont = item.font;\n            const label = item.label;\n            const y = item.textOffset;\n            (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.Z)(ctx, label, 0, y, tickFont, renderTextOptions);\n        }\n        if (area) {\n            (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.$)(ctx);\n        }\n    }\n drawTitle() {\n        const { ctx , options: { position , title , reverse  }  } = this;\n        if (!title.display) {\n            return;\n        }\n        const font = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a0)(title.font);\n        const padding = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.E)(title.padding);\n        const align = title.align;\n        let offset = font.lineHeight / 2;\n        if (position === 'bottom' || position === 'center' || (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.i)(position)) {\n            offset += padding.bottom;\n            if ((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.b)(title.text)) {\n                offset += font.lineHeight * (title.text.length - 1);\n            }\n        } else {\n            offset += padding.top;\n        }\n        const { titleX , titleY , maxWidth , rotation  } = titleArgs(this, offset, position, align);\n        (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.Z)(ctx, title.text, 0, 0, font, {\n            color: title.color,\n            maxWidth,\n            rotation,\n            textAlign: titleAlign(align, position, reverse),\n            textBaseline: 'middle',\n            translation: [\n                titleX,\n                titleY\n            ]\n        });\n    }\n    draw(chartArea) {\n        if (!this._isVisible()) {\n            return;\n        }\n        this.drawBackground();\n        this.drawGrid(chartArea);\n        this.drawBorder();\n        this.drawTitle();\n        this.drawLabels(chartArea);\n    }\n _layers() {\n        const opts = this.options;\n        const tz = opts.ticks && opts.ticks.z || 0;\n        const gz = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.v)(opts.grid && opts.grid.z, -1);\n        const bz = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.v)(opts.border && opts.border.z, 0);\n        if (!this._isVisible() || this.draw !== Scale.prototype.draw) {\n            return [\n                {\n                    z: tz,\n                    draw: (chartArea)=>{\n                        this.draw(chartArea);\n                    }\n                }\n            ];\n        }\n        return [\n            {\n                z: gz,\n                draw: (chartArea)=>{\n                    this.drawBackground();\n                    this.drawGrid(chartArea);\n                    this.drawTitle();\n                }\n            },\n            {\n                z: bz,\n                draw: ()=>{\n                    this.drawBorder();\n                }\n            },\n            {\n                z: tz,\n                draw: (chartArea)=>{\n                    this.drawLabels(chartArea);\n                }\n            }\n        ];\n    }\n getMatchingVisibleMetas(type) {\n        const metas = this.chart.getSortedVisibleDatasetMetas();\n        const axisID = this.axis + 'AxisID';\n        const result = [];\n        let i, ilen;\n        for(i = 0, ilen = metas.length; i < ilen; ++i){\n            const meta = metas[i];\n            if (meta[axisID] === this.id && (!type || meta.type === type)) {\n                result.push(meta);\n            }\n        }\n        return result;\n    }\n _resolveTickFontOptions(index) {\n        const opts = this.options.ticks.setContext(this.getContext(index));\n        return (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a0)(opts.font);\n    }\n _maxDigits() {\n        const fontSize = this._resolveTickFontOptions(0).lineHeight;\n        return (this.isHorizontal() ? this.width : this.height) / fontSize;\n    }\n}\n\nclass TypedRegistry {\n    constructor(type, scope, override){\n        this.type = type;\n        this.scope = scope;\n        this.override = override;\n        this.items = Object.create(null);\n    }\n    isForType(type) {\n        return Object.prototype.isPrototypeOf.call(this.type.prototype, type.prototype);\n    }\n register(item) {\n        const proto = Object.getPrototypeOf(item);\n        let parentScope;\n        if (isIChartComponent(proto)) {\n            parentScope = this.register(proto);\n        }\n        const items = this.items;\n        const id = item.id;\n        const scope = this.scope + '.' + id;\n        if (!id) {\n            throw new Error('class does not have id: ' + item);\n        }\n        if (id in items) {\n            return scope;\n        }\n        items[id] = item;\n        registerDefaults(item, scope, parentScope);\n        if (this.override) {\n            _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.d.override(item.id, item.overrides);\n        }\n        return scope;\n    }\n get(id) {\n        return this.items[id];\n    }\n unregister(item) {\n        const items = this.items;\n        const id = item.id;\n        const scope = this.scope;\n        if (id in items) {\n            delete items[id];\n        }\n        if (scope && id in _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.d[scope]) {\n            delete _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.d[scope][id];\n            if (this.override) {\n                delete _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a3[id];\n            }\n        }\n    }\n}\nfunction registerDefaults(item, scope, parentScope) {\n    const itemDefaults = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a4)(Object.create(null), [\n        parentScope ? _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.d.get(parentScope) : {},\n        _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.d.get(scope),\n        item.defaults\n    ]);\n    _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.d.set(scope, itemDefaults);\n    if (item.defaultRoutes) {\n        routeDefaults(scope, item.defaultRoutes);\n    }\n    if (item.descriptors) {\n        _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.d.describe(scope, item.descriptors);\n    }\n}\nfunction routeDefaults(scope, routes) {\n    Object.keys(routes).forEach((property)=>{\n        const propertyParts = property.split('.');\n        const sourceName = propertyParts.pop();\n        const sourceScope = [\n            scope\n        ].concat(propertyParts).join('.');\n        const parts = routes[property].split('.');\n        const targetName = parts.pop();\n        const targetScope = parts.join('.');\n        _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.d.route(sourceScope, sourceName, targetScope, targetName);\n    });\n}\nfunction isIChartComponent(proto) {\n    return 'id' in proto && 'defaults' in proto;\n}\n\nclass Registry {\n    constructor(){\n        this.controllers = new TypedRegistry(DatasetController, 'datasets', true);\n        this.elements = new TypedRegistry(Element, 'elements');\n        this.plugins = new TypedRegistry(Object, 'plugins');\n        this.scales = new TypedRegistry(Scale, 'scales');\n        this._typedRegistries = [\n            this.controllers,\n            this.scales,\n            this.elements\n        ];\n    }\n add(...args) {\n        this._each('register', args);\n    }\n    remove(...args) {\n        this._each('unregister', args);\n    }\n addControllers(...args) {\n        this._each('register', args, this.controllers);\n    }\n addElements(...args) {\n        this._each('register', args, this.elements);\n    }\n addPlugins(...args) {\n        this._each('register', args, this.plugins);\n    }\n addScales(...args) {\n        this._each('register', args, this.scales);\n    }\n getController(id) {\n        return this._get(id, this.controllers, 'controller');\n    }\n getElement(id) {\n        return this._get(id, this.elements, 'element');\n    }\n getPlugin(id) {\n        return this._get(id, this.plugins, 'plugin');\n    }\n getScale(id) {\n        return this._get(id, this.scales, 'scale');\n    }\n removeControllers(...args) {\n        this._each('unregister', args, this.controllers);\n    }\n removeElements(...args) {\n        this._each('unregister', args, this.elements);\n    }\n removePlugins(...args) {\n        this._each('unregister', args, this.plugins);\n    }\n removeScales(...args) {\n        this._each('unregister', args, this.scales);\n    }\n _each(method, args, typedRegistry) {\n        [\n            ...args\n        ].forEach((arg)=>{\n            const reg = typedRegistry || this._getRegistryForType(arg);\n            if (typedRegistry || reg.isForType(arg) || reg === this.plugins && arg.id) {\n                this._exec(method, reg, arg);\n            } else {\n                (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.F)(arg, (item)=>{\n                    const itemReg = typedRegistry || this._getRegistryForType(item);\n                    this._exec(method, itemReg, item);\n                });\n            }\n        });\n    }\n _exec(method, registry, component) {\n        const camelMethod = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a5)(method);\n        (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.Q)(component['before' + camelMethod], [], component);\n        registry[method](component);\n        (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.Q)(component['after' + camelMethod], [], component);\n    }\n _getRegistryForType(type) {\n        for(let i = 0; i < this._typedRegistries.length; i++){\n            const reg = this._typedRegistries[i];\n            if (reg.isForType(type)) {\n                return reg;\n            }\n        }\n        return this.plugins;\n    }\n _get(id, typedRegistry, type) {\n        const item = typedRegistry.get(id);\n        if (item === undefined) {\n            throw new Error('\"' + id + '\" is not a registered ' + type + '.');\n        }\n        return item;\n    }\n}\nvar registry = /* #__PURE__ */ new Registry();\n\nclass PluginService {\n    constructor(){\n        this._init = [];\n    }\n notify(chart, hook, args, filter) {\n        if (hook === 'beforeInit') {\n            this._init = this._createDescriptors(chart, true);\n            this._notify(this._init, chart, 'install');\n        }\n        const descriptors = filter ? this._descriptors(chart).filter(filter) : this._descriptors(chart);\n        const result = this._notify(descriptors, chart, hook, args);\n        if (hook === 'afterDestroy') {\n            this._notify(descriptors, chart, 'stop');\n            this._notify(this._init, chart, 'uninstall');\n        }\n        return result;\n    }\n _notify(descriptors, chart, hook, args) {\n        args = args || {};\n        for (const descriptor of descriptors){\n            const plugin = descriptor.plugin;\n            const method = plugin[hook];\n            const params = [\n                chart,\n                args,\n                descriptor.options\n            ];\n            if ((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.Q)(method, params, plugin) === false && args.cancelable) {\n                return false;\n            }\n        }\n        return true;\n    }\n    invalidate() {\n        if (!(0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.k)(this._cache)) {\n            this._oldCache = this._cache;\n            this._cache = undefined;\n        }\n    }\n _descriptors(chart) {\n        if (this._cache) {\n            return this._cache;\n        }\n        const descriptors = this._cache = this._createDescriptors(chart);\n        this._notifyStateChanges(chart);\n        return descriptors;\n    }\n    _createDescriptors(chart, all) {\n        const config = chart && chart.config;\n        const options = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.v)(config.options && config.options.plugins, {});\n        const plugins = allPlugins(config);\n        return options === false && !all ? [] : createDescriptors(chart, plugins, options, all);\n    }\n _notifyStateChanges(chart) {\n        const previousDescriptors = this._oldCache || [];\n        const descriptors = this._cache;\n        const diff = (a, b)=>a.filter((x)=>!b.some((y)=>x.plugin.id === y.plugin.id));\n        this._notify(diff(previousDescriptors, descriptors), chart, 'stop');\n        this._notify(diff(descriptors, previousDescriptors), chart, 'start');\n    }\n}\n function allPlugins(config) {\n    const localIds = {};\n    const plugins = [];\n    const keys = Object.keys(registry.plugins.items);\n    for(let i = 0; i < keys.length; i++){\n        plugins.push(registry.getPlugin(keys[i]));\n    }\n    const local = config.plugins || [];\n    for(let i = 0; i < local.length; i++){\n        const plugin = local[i];\n        if (plugins.indexOf(plugin) === -1) {\n            plugins.push(plugin);\n            localIds[plugin.id] = true;\n        }\n    }\n    return {\n        plugins,\n        localIds\n    };\n}\nfunction getOpts(options, all) {\n    if (!all && options === false) {\n        return null;\n    }\n    if (options === true) {\n        return {};\n    }\n    return options;\n}\nfunction createDescriptors(chart, { plugins , localIds  }, options, all) {\n    const result = [];\n    const context = chart.getContext();\n    for (const plugin of plugins){\n        const id = plugin.id;\n        const opts = getOpts(options[id], all);\n        if (opts === null) {\n            continue;\n        }\n        result.push({\n            plugin,\n            options: pluginOpts(chart.config, {\n                plugin,\n                local: localIds[id]\n            }, opts, context)\n        });\n    }\n    return result;\n}\nfunction pluginOpts(config, { plugin , local  }, opts, context) {\n    const keys = config.pluginScopeKeys(plugin);\n    const scopes = config.getOptionScopes(opts, keys);\n    if (local && plugin.defaults) {\n        scopes.push(plugin.defaults);\n    }\n    return config.createResolver(scopes, context, [\n        ''\n    ], {\n        scriptable: false,\n        indexable: false,\n        allKeys: true\n    });\n}\n\nfunction getIndexAxis(type, options) {\n    const datasetDefaults = _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.d.datasets[type] || {};\n    const datasetOptions = (options.datasets || {})[type] || {};\n    return datasetOptions.indexAxis || options.indexAxis || datasetDefaults.indexAxis || 'x';\n}\nfunction getAxisFromDefaultScaleID(id, indexAxis) {\n    let axis = id;\n    if (id === '_index_') {\n        axis = indexAxis;\n    } else if (id === '_value_') {\n        axis = indexAxis === 'x' ? 'y' : 'x';\n    }\n    return axis;\n}\nfunction getDefaultScaleIDFromAxis(axis, indexAxis) {\n    return axis === indexAxis ? '_index_' : '_value_';\n}\nfunction idMatchesAxis(id) {\n    if (id === 'x' || id === 'y' || id === 'r') {\n        return id;\n    }\n}\nfunction axisFromPosition(position) {\n    if (position === 'top' || position === 'bottom') {\n        return 'x';\n    }\n    if (position === 'left' || position === 'right') {\n        return 'y';\n    }\n}\nfunction determineAxis(id, ...scaleOptions) {\n    if (idMatchesAxis(id)) {\n        return id;\n    }\n    for (const opts of scaleOptions){\n        const axis = opts.axis || axisFromPosition(opts.position) || id.length > 1 && idMatchesAxis(id[0].toLowerCase());\n        if (axis) {\n            return axis;\n        }\n    }\n    throw new Error(`Cannot determine type of '${id}' axis. Please provide 'axis' or 'position' option.`);\n}\nfunction getAxisFromDataset(id, axis, dataset) {\n    if (dataset[axis + 'AxisID'] === id) {\n        return {\n            axis\n        };\n    }\n}\nfunction retrieveAxisFromDatasets(id, config) {\n    if (config.data && config.data.datasets) {\n        const boundDs = config.data.datasets.filter((d)=>d.xAxisID === id || d.yAxisID === id);\n        if (boundDs.length) {\n            return getAxisFromDataset(id, 'x', boundDs[0]) || getAxisFromDataset(id, 'y', boundDs[0]);\n        }\n    }\n    return {};\n}\nfunction mergeScaleConfig(config, options) {\n    const chartDefaults = _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a3[config.type] || {\n        scales: {}\n    };\n    const configScales = options.scales || {};\n    const chartIndexAxis = getIndexAxis(config.type, options);\n    const scales = Object.create(null);\n    Object.keys(configScales).forEach((id)=>{\n        const scaleConf = configScales[id];\n        if (!(0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.i)(scaleConf)) {\n            return console.error(`Invalid scale configuration for scale: ${id}`);\n        }\n        if (scaleConf._proxy) {\n            return console.warn(`Ignoring resolver passed as options for scale: ${id}`);\n        }\n        const axis = determineAxis(id, scaleConf, retrieveAxisFromDatasets(id, config), _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.d.scales[scaleConf.type]);\n        const defaultId = getDefaultScaleIDFromAxis(axis, chartIndexAxis);\n        const defaultScaleOptions = chartDefaults.scales || {};\n        scales[id] = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.ab)(Object.create(null), [\n            {\n                axis\n            },\n            scaleConf,\n            defaultScaleOptions[axis],\n            defaultScaleOptions[defaultId]\n        ]);\n    });\n    config.data.datasets.forEach((dataset)=>{\n        const type = dataset.type || config.type;\n        const indexAxis = dataset.indexAxis || getIndexAxis(type, options);\n        const datasetDefaults = _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a3[type] || {};\n        const defaultScaleOptions = datasetDefaults.scales || {};\n        Object.keys(defaultScaleOptions).forEach((defaultID)=>{\n            const axis = getAxisFromDefaultScaleID(defaultID, indexAxis);\n            const id = dataset[axis + 'AxisID'] || axis;\n            scales[id] = scales[id] || Object.create(null);\n            (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.ab)(scales[id], [\n                {\n                    axis\n                },\n                configScales[id],\n                defaultScaleOptions[defaultID]\n            ]);\n        });\n    });\n    Object.keys(scales).forEach((key)=>{\n        const scale = scales[key];\n        (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.ab)(scale, [\n            _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.d.scales[scale.type],\n            _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.d.scale\n        ]);\n    });\n    return scales;\n}\nfunction initOptions(config) {\n    const options = config.options || (config.options = {});\n    options.plugins = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.v)(options.plugins, {});\n    options.scales = mergeScaleConfig(config, options);\n}\nfunction initData(data) {\n    data = data || {};\n    data.datasets = data.datasets || [];\n    data.labels = data.labels || [];\n    return data;\n}\nfunction initConfig(config) {\n    config = config || {};\n    config.data = initData(config.data);\n    initOptions(config);\n    return config;\n}\nconst keyCache = new Map();\nconst keysCached = new Set();\nfunction cachedKeys(cacheKey, generate) {\n    let keys = keyCache.get(cacheKey);\n    if (!keys) {\n        keys = generate();\n        keyCache.set(cacheKey, keys);\n        keysCached.add(keys);\n    }\n    return keys;\n}\nconst addIfFound = (set, obj, key)=>{\n    const opts = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.f)(obj, key);\n    if (opts !== undefined) {\n        set.add(opts);\n    }\n};\nclass Config {\n    constructor(config){\n        this._config = initConfig(config);\n        this._scopeCache = new Map();\n        this._resolverCache = new Map();\n    }\n    get platform() {\n        return this._config.platform;\n    }\n    get type() {\n        return this._config.type;\n    }\n    set type(type) {\n        this._config.type = type;\n    }\n    get data() {\n        return this._config.data;\n    }\n    set data(data) {\n        this._config.data = initData(data);\n    }\n    get options() {\n        return this._config.options;\n    }\n    set options(options) {\n        this._config.options = options;\n    }\n    get plugins() {\n        return this._config.plugins;\n    }\n    update() {\n        const config = this._config;\n        this.clearCache();\n        initOptions(config);\n    }\n    clearCache() {\n        this._scopeCache.clear();\n        this._resolverCache.clear();\n    }\n datasetScopeKeys(datasetType) {\n        return cachedKeys(datasetType, ()=>[\n                [\n                    `datasets.${datasetType}`,\n                    ''\n                ]\n            ]);\n    }\n datasetAnimationScopeKeys(datasetType, transition) {\n        return cachedKeys(`${datasetType}.transition.${transition}`, ()=>[\n                [\n                    `datasets.${datasetType}.transitions.${transition}`,\n                    `transitions.${transition}`\n                ],\n                [\n                    `datasets.${datasetType}`,\n                    ''\n                ]\n            ]);\n    }\n datasetElementScopeKeys(datasetType, elementType) {\n        return cachedKeys(`${datasetType}-${elementType}`, ()=>[\n                [\n                    `datasets.${datasetType}.elements.${elementType}`,\n                    `datasets.${datasetType}`,\n                    `elements.${elementType}`,\n                    ''\n                ]\n            ]);\n    }\n pluginScopeKeys(plugin) {\n        const id = plugin.id;\n        const type = this.type;\n        return cachedKeys(`${type}-plugin-${id}`, ()=>[\n                [\n                    `plugins.${id}`,\n                    ...plugin.additionalOptionScopes || []\n                ]\n            ]);\n    }\n _cachedScopes(mainScope, resetCache) {\n        const _scopeCache = this._scopeCache;\n        let cache = _scopeCache.get(mainScope);\n        if (!cache || resetCache) {\n            cache = new Map();\n            _scopeCache.set(mainScope, cache);\n        }\n        return cache;\n    }\n getOptionScopes(mainScope, keyLists, resetCache) {\n        const { options , type  } = this;\n        const cache = this._cachedScopes(mainScope, resetCache);\n        const cached = cache.get(keyLists);\n        if (cached) {\n            return cached;\n        }\n        const scopes = new Set();\n        keyLists.forEach((keys)=>{\n            if (mainScope) {\n                scopes.add(mainScope);\n                keys.forEach((key)=>addIfFound(scopes, mainScope, key));\n            }\n            keys.forEach((key)=>addIfFound(scopes, options, key));\n            keys.forEach((key)=>addIfFound(scopes, _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a3[type] || {}, key));\n            keys.forEach((key)=>addIfFound(scopes, _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.d, key));\n            keys.forEach((key)=>addIfFound(scopes, _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a6, key));\n        });\n        const array = Array.from(scopes);\n        if (array.length === 0) {\n            array.push(Object.create(null));\n        }\n        if (keysCached.has(keyLists)) {\n            cache.set(keyLists, array);\n        }\n        return array;\n    }\n chartOptionScopes() {\n        const { options , type  } = this;\n        return [\n            options,\n            _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a3[type] || {},\n            _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.d.datasets[type] || {},\n            {\n                type\n            },\n            _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.d,\n            _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a6\n        ];\n    }\n resolveNamedOptions(scopes, names, context, prefixes = [\n        ''\n    ]) {\n        const result = {\n            $shared: true\n        };\n        const { resolver , subPrefixes  } = getResolver(this._resolverCache, scopes, prefixes);\n        let options = resolver;\n        if (needContext(resolver, names)) {\n            result.$shared = false;\n            context = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a7)(context) ? context() : context;\n            const subResolver = this.createResolver(scopes, context, subPrefixes);\n            options = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a8)(resolver, context, subResolver);\n        }\n        for (const prop of names){\n            result[prop] = options[prop];\n        }\n        return result;\n    }\n createResolver(scopes, context, prefixes = [\n        ''\n    ], descriptorDefaults) {\n        const { resolver  } = getResolver(this._resolverCache, scopes, prefixes);\n        return (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.i)(context) ? (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a8)(resolver, context, undefined, descriptorDefaults) : resolver;\n    }\n}\nfunction getResolver(resolverCache, scopes, prefixes) {\n    let cache = resolverCache.get(scopes);\n    if (!cache) {\n        cache = new Map();\n        resolverCache.set(scopes, cache);\n    }\n    const cacheKey = prefixes.join();\n    let cached = cache.get(cacheKey);\n    if (!cached) {\n        const resolver = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a9)(scopes, prefixes);\n        cached = {\n            resolver,\n            subPrefixes: prefixes.filter((p)=>!p.toLowerCase().includes('hover'))\n        };\n        cache.set(cacheKey, cached);\n    }\n    return cached;\n}\nconst hasFunction = (value)=>(0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.i)(value) && Object.getOwnPropertyNames(value).some((key)=>(0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a7)(value[key]));\nfunction needContext(proxy, names) {\n    const { isScriptable , isIndexable  } = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.aa)(proxy);\n    for (const prop of names){\n        const scriptable = isScriptable(prop);\n        const indexable = isIndexable(prop);\n        const value = (indexable || scriptable) && proxy[prop];\n        if (scriptable && ((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a7)(value) || hasFunction(value)) || indexable && (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.b)(value)) {\n            return true;\n        }\n    }\n    return false;\n}\n\nvar version = \"4.4.9\";\n\nconst KNOWN_POSITIONS = [\n    'top',\n    'bottom',\n    'left',\n    'right',\n    'chartArea'\n];\nfunction positionIsHorizontal(position, axis) {\n    return position === 'top' || position === 'bottom' || KNOWN_POSITIONS.indexOf(position) === -1 && axis === 'x';\n}\nfunction compare2Level(l1, l2) {\n    return function(a, b) {\n        return a[l1] === b[l1] ? a[l2] - b[l2] : a[l1] - b[l1];\n    };\n}\nfunction onAnimationsComplete(context) {\n    const chart = context.chart;\n    const animationOptions = chart.options.animation;\n    chart.notifyPlugins('afterRender');\n    (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.Q)(animationOptions && animationOptions.onComplete, [\n        context\n    ], chart);\n}\nfunction onAnimationProgress(context) {\n    const chart = context.chart;\n    const animationOptions = chart.options.animation;\n    (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.Q)(animationOptions && animationOptions.onProgress, [\n        context\n    ], chart);\n}\n function getCanvas(item) {\n    if ((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.M)() && typeof item === 'string') {\n        item = document.getElementById(item);\n    } else if (item && item.length) {\n        item = item[0];\n    }\n    if (item && item.canvas) {\n        item = item.canvas;\n    }\n    return item;\n}\nconst instances = {};\nconst getChart = (key)=>{\n    const canvas = getCanvas(key);\n    return Object.values(instances).filter((c)=>c.canvas === canvas).pop();\n};\nfunction moveNumericKeys(obj, start, move) {\n    const keys = Object.keys(obj);\n    for (const key of keys){\n        const intKey = +key;\n        if (intKey >= start) {\n            const value = obj[key];\n            delete obj[key];\n            if (move > 0 || intKey > start) {\n                obj[intKey + move] = value;\n            }\n        }\n    }\n}\n function determineLastEvent(e, lastEvent, inChartArea, isClick) {\n    if (!inChartArea || e.type === 'mouseout') {\n        return null;\n    }\n    if (isClick) {\n        return lastEvent;\n    }\n    return e;\n}\nclass Chart {\n    static defaults = _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.d;\n    static instances = instances;\n    static overrides = _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a3;\n    static registry = registry;\n    static version = version;\n    static getChart = getChart;\n    static register(...items) {\n        registry.add(...items);\n        invalidatePlugins();\n    }\n    static unregister(...items) {\n        registry.remove(...items);\n        invalidatePlugins();\n    }\n    constructor(item, userConfig){\n        const config = this.config = new Config(userConfig);\n        const initialCanvas = getCanvas(item);\n        const existingChart = getChart(initialCanvas);\n        if (existingChart) {\n            throw new Error('Canvas is already in use. Chart with ID \\'' + existingChart.id + '\\'' + ' must be destroyed before the canvas with ID \\'' + existingChart.canvas.id + '\\' can be reused.');\n        }\n        const options = config.createResolver(config.chartOptionScopes(), this.getContext());\n        this.platform = new (config.platform || _detectPlatform(initialCanvas))();\n        this.platform.updateConfig(config);\n        const context = this.platform.acquireContext(initialCanvas, options.aspectRatio);\n        const canvas = context && context.canvas;\n        const height = canvas && canvas.height;\n        const width = canvas && canvas.width;\n        this.id = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.ac)();\n        this.ctx = context;\n        this.canvas = canvas;\n        this.width = width;\n        this.height = height;\n        this._options = options;\n        this._aspectRatio = this.aspectRatio;\n        this._layers = [];\n        this._metasets = [];\n        this._stacks = undefined;\n        this.boxes = [];\n        this.currentDevicePixelRatio = undefined;\n        this.chartArea = undefined;\n        this._active = [];\n        this._lastEvent = undefined;\n        this._listeners = {};\n         this._responsiveListeners = undefined;\n        this._sortedMetasets = [];\n        this.scales = {};\n        this._plugins = new PluginService();\n        this.$proxies = {};\n        this._hiddenIndices = {};\n        this.attached = false;\n        this._animationsDisabled = undefined;\n        this.$context = undefined;\n        this._doResize = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.ad)((mode)=>this.update(mode), options.resizeDelay || 0);\n        this._dataChanges = [];\n        instances[this.id] = this;\n        if (!context || !canvas) {\n            console.error(\"Failed to create chart: can't acquire context from the given item\");\n            return;\n        }\n        animator.listen(this, 'complete', onAnimationsComplete);\n        animator.listen(this, 'progress', onAnimationProgress);\n        this._initialize();\n        if (this.attached) {\n            this.update();\n        }\n    }\n    get aspectRatio() {\n        const { options: { aspectRatio , maintainAspectRatio  } , width , height , _aspectRatio  } = this;\n        if (!(0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.k)(aspectRatio)) {\n            return aspectRatio;\n        }\n        if (maintainAspectRatio && _aspectRatio) {\n            return _aspectRatio;\n        }\n        return height ? width / height : null;\n    }\n    get data() {\n        return this.config.data;\n    }\n    set data(data) {\n        this.config.data = data;\n    }\n    get options() {\n        return this._options;\n    }\n    set options(options) {\n        this.config.options = options;\n    }\n    get registry() {\n        return registry;\n    }\n _initialize() {\n        this.notifyPlugins('beforeInit');\n        if (this.options.responsive) {\n            this.resize();\n        } else {\n            (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.ae)(this, this.options.devicePixelRatio);\n        }\n        this.bindEvents();\n        this.notifyPlugins('afterInit');\n        return this;\n    }\n    clear() {\n        (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.af)(this.canvas, this.ctx);\n        return this;\n    }\n    stop() {\n        animator.stop(this);\n        return this;\n    }\n resize(width, height) {\n        if (!animator.running(this)) {\n            this._resize(width, height);\n        } else {\n            this._resizeBeforeDraw = {\n                width,\n                height\n            };\n        }\n    }\n    _resize(width, height) {\n        const options = this.options;\n        const canvas = this.canvas;\n        const aspectRatio = options.maintainAspectRatio && this.aspectRatio;\n        const newSize = this.platform.getMaximumSize(canvas, width, height, aspectRatio);\n        const newRatio = options.devicePixelRatio || this.platform.getDevicePixelRatio();\n        const mode = this.width ? 'resize' : 'attach';\n        this.width = newSize.width;\n        this.height = newSize.height;\n        this._aspectRatio = this.aspectRatio;\n        if (!(0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.ae)(this, newRatio, true)) {\n            return;\n        }\n        this.notifyPlugins('resize', {\n            size: newSize\n        });\n        (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.Q)(options.onResize, [\n            this,\n            newSize\n        ], this);\n        if (this.attached) {\n            if (this._doResize(mode)) {\n                this.render();\n            }\n        }\n    }\n    ensureScalesHaveIDs() {\n        const options = this.options;\n        const scalesOptions = options.scales || {};\n        (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.F)(scalesOptions, (axisOptions, axisID)=>{\n            axisOptions.id = axisID;\n        });\n    }\n buildOrUpdateScales() {\n        const options = this.options;\n        const scaleOpts = options.scales;\n        const scales = this.scales;\n        const updated = Object.keys(scales).reduce((obj, id)=>{\n            obj[id] = false;\n            return obj;\n        }, {});\n        let items = [];\n        if (scaleOpts) {\n            items = items.concat(Object.keys(scaleOpts).map((id)=>{\n                const scaleOptions = scaleOpts[id];\n                const axis = determineAxis(id, scaleOptions);\n                const isRadial = axis === 'r';\n                const isHorizontal = axis === 'x';\n                return {\n                    options: scaleOptions,\n                    dposition: isRadial ? 'chartArea' : isHorizontal ? 'bottom' : 'left',\n                    dtype: isRadial ? 'radialLinear' : isHorizontal ? 'category' : 'linear'\n                };\n            }));\n        }\n        (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.F)(items, (item)=>{\n            const scaleOptions = item.options;\n            const id = scaleOptions.id;\n            const axis = determineAxis(id, scaleOptions);\n            const scaleType = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.v)(scaleOptions.type, item.dtype);\n            if (scaleOptions.position === undefined || positionIsHorizontal(scaleOptions.position, axis) !== positionIsHorizontal(item.dposition)) {\n                scaleOptions.position = item.dposition;\n            }\n            updated[id] = true;\n            let scale = null;\n            if (id in scales && scales[id].type === scaleType) {\n                scale = scales[id];\n            } else {\n                const scaleClass = registry.getScale(scaleType);\n                scale = new scaleClass({\n                    id,\n                    type: scaleType,\n                    ctx: this.ctx,\n                    chart: this\n                });\n                scales[scale.id] = scale;\n            }\n            scale.init(scaleOptions, options);\n        });\n        (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.F)(updated, (hasUpdated, id)=>{\n            if (!hasUpdated) {\n                delete scales[id];\n            }\n        });\n        (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.F)(scales, (scale)=>{\n            layouts.configure(this, scale, scale.options);\n            layouts.addBox(this, scale);\n        });\n    }\n _updateMetasets() {\n        const metasets = this._metasets;\n        const numData = this.data.datasets.length;\n        const numMeta = metasets.length;\n        metasets.sort((a, b)=>a.index - b.index);\n        if (numMeta > numData) {\n            for(let i = numData; i < numMeta; ++i){\n                this._destroyDatasetMeta(i);\n            }\n            metasets.splice(numData, numMeta - numData);\n        }\n        this._sortedMetasets = metasets.slice(0).sort(compare2Level('order', 'index'));\n    }\n _removeUnreferencedMetasets() {\n        const { _metasets: metasets , data: { datasets  }  } = this;\n        if (metasets.length > datasets.length) {\n            delete this._stacks;\n        }\n        metasets.forEach((meta, index)=>{\n            if (datasets.filter((x)=>x === meta._dataset).length === 0) {\n                this._destroyDatasetMeta(index);\n            }\n        });\n    }\n    buildOrUpdateControllers() {\n        const newControllers = [];\n        const datasets = this.data.datasets;\n        let i, ilen;\n        this._removeUnreferencedMetasets();\n        for(i = 0, ilen = datasets.length; i < ilen; i++){\n            const dataset = datasets[i];\n            let meta = this.getDatasetMeta(i);\n            const type = dataset.type || this.config.type;\n            if (meta.type && meta.type !== type) {\n                this._destroyDatasetMeta(i);\n                meta = this.getDatasetMeta(i);\n            }\n            meta.type = type;\n            meta.indexAxis = dataset.indexAxis || getIndexAxis(type, this.options);\n            meta.order = dataset.order || 0;\n            meta.index = i;\n            meta.label = '' + dataset.label;\n            meta.visible = this.isDatasetVisible(i);\n            if (meta.controller) {\n                meta.controller.updateIndex(i);\n                meta.controller.linkScales();\n            } else {\n                const ControllerClass = registry.getController(type);\n                const { datasetElementType , dataElementType  } = _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.d.datasets[type];\n                Object.assign(ControllerClass, {\n                    dataElementType: registry.getElement(dataElementType),\n                    datasetElementType: datasetElementType && registry.getElement(datasetElementType)\n                });\n                meta.controller = new ControllerClass(this, i);\n                newControllers.push(meta.controller);\n            }\n        }\n        this._updateMetasets();\n        return newControllers;\n    }\n _resetElements() {\n        (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.F)(this.data.datasets, (dataset, datasetIndex)=>{\n            this.getDatasetMeta(datasetIndex).controller.reset();\n        }, this);\n    }\n reset() {\n        this._resetElements();\n        this.notifyPlugins('reset');\n    }\n    update(mode) {\n        const config = this.config;\n        config.update();\n        const options = this._options = config.createResolver(config.chartOptionScopes(), this.getContext());\n        const animsDisabled = this._animationsDisabled = !options.animation;\n        this._updateScales();\n        this._checkEventBindings();\n        this._updateHiddenIndices();\n        this._plugins.invalidate();\n        if (this.notifyPlugins('beforeUpdate', {\n            mode,\n            cancelable: true\n        }) === false) {\n            return;\n        }\n        const newControllers = this.buildOrUpdateControllers();\n        this.notifyPlugins('beforeElementsUpdate');\n        let minPadding = 0;\n        for(let i = 0, ilen = this.data.datasets.length; i < ilen; i++){\n            const { controller  } = this.getDatasetMeta(i);\n            const reset = !animsDisabled && newControllers.indexOf(controller) === -1;\n            controller.buildOrUpdateElements(reset);\n            minPadding = Math.max(+controller.getMaxOverflow(), minPadding);\n        }\n        minPadding = this._minPadding = options.layout.autoPadding ? minPadding : 0;\n        this._updateLayout(minPadding);\n        if (!animsDisabled) {\n            (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.F)(newControllers, (controller)=>{\n                controller.reset();\n            });\n        }\n        this._updateDatasets(mode);\n        this.notifyPlugins('afterUpdate', {\n            mode\n        });\n        this._layers.sort(compare2Level('z', '_idx'));\n        const { _active , _lastEvent  } = this;\n        if (_lastEvent) {\n            this._eventHandler(_lastEvent, true);\n        } else if (_active.length) {\n            this._updateHoverStyles(_active, _active, true);\n        }\n        this.render();\n    }\n _updateScales() {\n        (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.F)(this.scales, (scale)=>{\n            layouts.removeBox(this, scale);\n        });\n        this.ensureScalesHaveIDs();\n        this.buildOrUpdateScales();\n    }\n _checkEventBindings() {\n        const options = this.options;\n        const existingEvents = new Set(Object.keys(this._listeners));\n        const newEvents = new Set(options.events);\n        if (!(0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.ag)(existingEvents, newEvents) || !!this._responsiveListeners !== options.responsive) {\n            this.unbindEvents();\n            this.bindEvents();\n        }\n    }\n _updateHiddenIndices() {\n        const { _hiddenIndices  } = this;\n        const changes = this._getUniformDataChanges() || [];\n        for (const { method , start , count  } of changes){\n            const move = method === '_removeElements' ? -count : count;\n            moveNumericKeys(_hiddenIndices, start, move);\n        }\n    }\n _getUniformDataChanges() {\n        const _dataChanges = this._dataChanges;\n        if (!_dataChanges || !_dataChanges.length) {\n            return;\n        }\n        this._dataChanges = [];\n        const datasetCount = this.data.datasets.length;\n        const makeSet = (idx)=>new Set(_dataChanges.filter((c)=>c[0] === idx).map((c, i)=>i + ',' + c.splice(1).join(',')));\n        const changeSet = makeSet(0);\n        for(let i = 1; i < datasetCount; i++){\n            if (!(0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.ag)(changeSet, makeSet(i))) {\n                return;\n            }\n        }\n        return Array.from(changeSet).map((c)=>c.split(',')).map((a)=>({\n                method: a[1],\n                start: +a[2],\n                count: +a[3]\n            }));\n    }\n _updateLayout(minPadding) {\n        if (this.notifyPlugins('beforeLayout', {\n            cancelable: true\n        }) === false) {\n            return;\n        }\n        layouts.update(this, this.width, this.height, minPadding);\n        const area = this.chartArea;\n        const noArea = area.width <= 0 || area.height <= 0;\n        this._layers = [];\n        (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.F)(this.boxes, (box)=>{\n            if (noArea && box.position === 'chartArea') {\n                return;\n            }\n            if (box.configure) {\n                box.configure();\n            }\n            this._layers.push(...box._layers());\n        }, this);\n        this._layers.forEach((item, index)=>{\n            item._idx = index;\n        });\n        this.notifyPlugins('afterLayout');\n    }\n _updateDatasets(mode) {\n        if (this.notifyPlugins('beforeDatasetsUpdate', {\n            mode,\n            cancelable: true\n        }) === false) {\n            return;\n        }\n        for(let i = 0, ilen = this.data.datasets.length; i < ilen; ++i){\n            this.getDatasetMeta(i).controller.configure();\n        }\n        for(let i = 0, ilen = this.data.datasets.length; i < ilen; ++i){\n            this._updateDataset(i, (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a7)(mode) ? mode({\n                datasetIndex: i\n            }) : mode);\n        }\n        this.notifyPlugins('afterDatasetsUpdate', {\n            mode\n        });\n    }\n _updateDataset(index, mode) {\n        const meta = this.getDatasetMeta(index);\n        const args = {\n            meta,\n            index,\n            mode,\n            cancelable: true\n        };\n        if (this.notifyPlugins('beforeDatasetUpdate', args) === false) {\n            return;\n        }\n        meta.controller._update(mode);\n        args.cancelable = false;\n        this.notifyPlugins('afterDatasetUpdate', args);\n    }\n    render() {\n        if (this.notifyPlugins('beforeRender', {\n            cancelable: true\n        }) === false) {\n            return;\n        }\n        if (animator.has(this)) {\n            if (this.attached && !animator.running(this)) {\n                animator.start(this);\n            }\n        } else {\n            this.draw();\n            onAnimationsComplete({\n                chart: this\n            });\n        }\n    }\n    draw() {\n        let i;\n        if (this._resizeBeforeDraw) {\n            const { width , height  } = this._resizeBeforeDraw;\n            this._resizeBeforeDraw = null;\n            this._resize(width, height);\n        }\n        this.clear();\n        if (this.width <= 0 || this.height <= 0) {\n            return;\n        }\n        if (this.notifyPlugins('beforeDraw', {\n            cancelable: true\n        }) === false) {\n            return;\n        }\n        const layers = this._layers;\n        for(i = 0; i < layers.length && layers[i].z <= 0; ++i){\n            layers[i].draw(this.chartArea);\n        }\n        this._drawDatasets();\n        for(; i < layers.length; ++i){\n            layers[i].draw(this.chartArea);\n        }\n        this.notifyPlugins('afterDraw');\n    }\n _getSortedDatasetMetas(filterVisible) {\n        const metasets = this._sortedMetasets;\n        const result = [];\n        let i, ilen;\n        for(i = 0, ilen = metasets.length; i < ilen; ++i){\n            const meta = metasets[i];\n            if (!filterVisible || meta.visible) {\n                result.push(meta);\n            }\n        }\n        return result;\n    }\n getSortedVisibleDatasetMetas() {\n        return this._getSortedDatasetMetas(true);\n    }\n _drawDatasets() {\n        if (this.notifyPlugins('beforeDatasetsDraw', {\n            cancelable: true\n        }) === false) {\n            return;\n        }\n        const metasets = this.getSortedVisibleDatasetMetas();\n        for(let i = metasets.length - 1; i >= 0; --i){\n            this._drawDataset(metasets[i]);\n        }\n        this.notifyPlugins('afterDatasetsDraw');\n    }\n _drawDataset(meta) {\n        const ctx = this.ctx;\n        const args = {\n            meta,\n            index: meta.index,\n            cancelable: true\n        };\n        const clip = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.ah)(this, meta);\n        if (this.notifyPlugins('beforeDatasetDraw', args) === false) {\n            return;\n        }\n        if (clip) {\n            (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.Y)(ctx, clip);\n        }\n        meta.controller.draw();\n        if (clip) {\n            (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.$)(ctx);\n        }\n        args.cancelable = false;\n        this.notifyPlugins('afterDatasetDraw', args);\n    }\n isPointInArea(point) {\n        return (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.C)(point, this.chartArea, this._minPadding);\n    }\n    getElementsAtEventForMode(e, mode, options, useFinalPosition) {\n        const method = Interaction.modes[mode];\n        if (typeof method === 'function') {\n            return method(this, e, options, useFinalPosition);\n        }\n        return [];\n    }\n    getDatasetMeta(datasetIndex) {\n        const dataset = this.data.datasets[datasetIndex];\n        const metasets = this._metasets;\n        let meta = metasets.filter((x)=>x && x._dataset === dataset).pop();\n        if (!meta) {\n            meta = {\n                type: null,\n                data: [],\n                dataset: null,\n                controller: null,\n                hidden: null,\n                xAxisID: null,\n                yAxisID: null,\n                order: dataset && dataset.order || 0,\n                index: datasetIndex,\n                _dataset: dataset,\n                _parsed: [],\n                _sorted: false\n            };\n            metasets.push(meta);\n        }\n        return meta;\n    }\n    getContext() {\n        return this.$context || (this.$context = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.j)(null, {\n            chart: this,\n            type: 'chart'\n        }));\n    }\n    getVisibleDatasetCount() {\n        return this.getSortedVisibleDatasetMetas().length;\n    }\n    isDatasetVisible(datasetIndex) {\n        const dataset = this.data.datasets[datasetIndex];\n        if (!dataset) {\n            return false;\n        }\n        const meta = this.getDatasetMeta(datasetIndex);\n        return typeof meta.hidden === 'boolean' ? !meta.hidden : !dataset.hidden;\n    }\n    setDatasetVisibility(datasetIndex, visible) {\n        const meta = this.getDatasetMeta(datasetIndex);\n        meta.hidden = !visible;\n    }\n    toggleDataVisibility(index) {\n        this._hiddenIndices[index] = !this._hiddenIndices[index];\n    }\n    getDataVisibility(index) {\n        return !this._hiddenIndices[index];\n    }\n _updateVisibility(datasetIndex, dataIndex, visible) {\n        const mode = visible ? 'show' : 'hide';\n        const meta = this.getDatasetMeta(datasetIndex);\n        const anims = meta.controller._resolveAnimations(undefined, mode);\n        if ((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.h)(dataIndex)) {\n            meta.data[dataIndex].hidden = !visible;\n            this.update();\n        } else {\n            this.setDatasetVisibility(datasetIndex, visible);\n            anims.update(meta, {\n                visible\n            });\n            this.update((ctx)=>ctx.datasetIndex === datasetIndex ? mode : undefined);\n        }\n    }\n    hide(datasetIndex, dataIndex) {\n        this._updateVisibility(datasetIndex, dataIndex, false);\n    }\n    show(datasetIndex, dataIndex) {\n        this._updateVisibility(datasetIndex, dataIndex, true);\n    }\n _destroyDatasetMeta(datasetIndex) {\n        const meta = this._metasets[datasetIndex];\n        if (meta && meta.controller) {\n            meta.controller._destroy();\n        }\n        delete this._metasets[datasetIndex];\n    }\n    _stop() {\n        let i, ilen;\n        this.stop();\n        animator.remove(this);\n        for(i = 0, ilen = this.data.datasets.length; i < ilen; ++i){\n            this._destroyDatasetMeta(i);\n        }\n    }\n    destroy() {\n        this.notifyPlugins('beforeDestroy');\n        const { canvas , ctx  } = this;\n        this._stop();\n        this.config.clearCache();\n        if (canvas) {\n            this.unbindEvents();\n            (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.af)(canvas, ctx);\n            this.platform.releaseContext(ctx);\n            this.canvas = null;\n            this.ctx = null;\n        }\n        delete instances[this.id];\n        this.notifyPlugins('afterDestroy');\n    }\n    toBase64Image(...args) {\n        return this.canvas.toDataURL(...args);\n    }\n bindEvents() {\n        this.bindUserEvents();\n        if (this.options.responsive) {\n            this.bindResponsiveEvents();\n        } else {\n            this.attached = true;\n        }\n    }\n bindUserEvents() {\n        const listeners = this._listeners;\n        const platform = this.platform;\n        const _add = (type, listener)=>{\n            platform.addEventListener(this, type, listener);\n            listeners[type] = listener;\n        };\n        const listener = (e, x, y)=>{\n            e.offsetX = x;\n            e.offsetY = y;\n            this._eventHandler(e);\n        };\n        (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.F)(this.options.events, (type)=>_add(type, listener));\n    }\n bindResponsiveEvents() {\n        if (!this._responsiveListeners) {\n            this._responsiveListeners = {};\n        }\n        const listeners = this._responsiveListeners;\n        const platform = this.platform;\n        const _add = (type, listener)=>{\n            platform.addEventListener(this, type, listener);\n            listeners[type] = listener;\n        };\n        const _remove = (type, listener)=>{\n            if (listeners[type]) {\n                platform.removeEventListener(this, type, listener);\n                delete listeners[type];\n            }\n        };\n        const listener = (width, height)=>{\n            if (this.canvas) {\n                this.resize(width, height);\n            }\n        };\n        let detached;\n        const attached = ()=>{\n            _remove('attach', attached);\n            this.attached = true;\n            this.resize();\n            _add('resize', listener);\n            _add('detach', detached);\n        };\n        detached = ()=>{\n            this.attached = false;\n            _remove('resize', listener);\n            this._stop();\n            this._resize(0, 0);\n            _add('attach', attached);\n        };\n        if (platform.isAttached(this.canvas)) {\n            attached();\n        } else {\n            detached();\n        }\n    }\n unbindEvents() {\n        (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.F)(this._listeners, (listener, type)=>{\n            this.platform.removeEventListener(this, type, listener);\n        });\n        this._listeners = {};\n        (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.F)(this._responsiveListeners, (listener, type)=>{\n            this.platform.removeEventListener(this, type, listener);\n        });\n        this._responsiveListeners = undefined;\n    }\n    updateHoverStyle(items, mode, enabled) {\n        const prefix = enabled ? 'set' : 'remove';\n        let meta, item, i, ilen;\n        if (mode === 'dataset') {\n            meta = this.getDatasetMeta(items[0].datasetIndex);\n            meta.controller['_' + prefix + 'DatasetHoverStyle']();\n        }\n        for(i = 0, ilen = items.length; i < ilen; ++i){\n            item = items[i];\n            const controller = item && this.getDatasetMeta(item.datasetIndex).controller;\n            if (controller) {\n                controller[prefix + 'HoverStyle'](item.element, item.datasetIndex, item.index);\n            }\n        }\n    }\n getActiveElements() {\n        return this._active || [];\n    }\n setActiveElements(activeElements) {\n        const lastActive = this._active || [];\n        const active = activeElements.map(({ datasetIndex , index  })=>{\n            const meta = this.getDatasetMeta(datasetIndex);\n            if (!meta) {\n                throw new Error('No dataset found at index ' + datasetIndex);\n            }\n            return {\n                datasetIndex,\n                element: meta.data[index],\n                index\n            };\n        });\n        const changed = !(0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.ai)(active, lastActive);\n        if (changed) {\n            this._active = active;\n            this._lastEvent = null;\n            this._updateHoverStyles(active, lastActive);\n        }\n    }\n notifyPlugins(hook, args, filter) {\n        return this._plugins.notify(this, hook, args, filter);\n    }\n isPluginEnabled(pluginId) {\n        return this._plugins._cache.filter((p)=>p.plugin.id === pluginId).length === 1;\n    }\n _updateHoverStyles(active, lastActive, replay) {\n        const hoverOptions = this.options.hover;\n        const diff = (a, b)=>a.filter((x)=>!b.some((y)=>x.datasetIndex === y.datasetIndex && x.index === y.index));\n        const deactivated = diff(lastActive, active);\n        const activated = replay ? active : diff(active, lastActive);\n        if (deactivated.length) {\n            this.updateHoverStyle(deactivated, hoverOptions.mode, false);\n        }\n        if (activated.length && hoverOptions.mode) {\n            this.updateHoverStyle(activated, hoverOptions.mode, true);\n        }\n    }\n _eventHandler(e, replay) {\n        const args = {\n            event: e,\n            replay,\n            cancelable: true,\n            inChartArea: this.isPointInArea(e)\n        };\n        const eventFilter = (plugin)=>(plugin.options.events || this.options.events).includes(e.native.type);\n        if (this.notifyPlugins('beforeEvent', args, eventFilter) === false) {\n            return;\n        }\n        const changed = this._handleEvent(e, replay, args.inChartArea);\n        args.cancelable = false;\n        this.notifyPlugins('afterEvent', args, eventFilter);\n        if (changed || args.changed) {\n            this.render();\n        }\n        return this;\n    }\n _handleEvent(e, replay, inChartArea) {\n        const { _active: lastActive = [] , options  } = this;\n        const useFinalPosition = replay;\n        const active = this._getActiveElements(e, lastActive, inChartArea, useFinalPosition);\n        const isClick = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.aj)(e);\n        const lastEvent = determineLastEvent(e, this._lastEvent, inChartArea, isClick);\n        if (inChartArea) {\n            this._lastEvent = null;\n            (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.Q)(options.onHover, [\n                e,\n                active,\n                this\n            ], this);\n            if (isClick) {\n                (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.Q)(options.onClick, [\n                    e,\n                    active,\n                    this\n                ], this);\n            }\n        }\n        const changed = !(0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.ai)(active, lastActive);\n        if (changed || replay) {\n            this._active = active;\n            this._updateHoverStyles(active, lastActive, replay);\n        }\n        this._lastEvent = lastEvent;\n        return changed;\n    }\n _getActiveElements(e, lastActive, inChartArea, useFinalPosition) {\n        if (e.type === 'mouseout') {\n            return [];\n        }\n        if (!inChartArea) {\n            return lastActive;\n        }\n        const hoverOptions = this.options.hover;\n        return this.getElementsAtEventForMode(e, hoverOptions.mode, hoverOptions, useFinalPosition);\n    }\n}\nfunction invalidatePlugins() {\n    return (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.F)(Chart.instances, (chart)=>chart._plugins.invalidate());\n}\n\nfunction clipArc(ctx, element, endAngle) {\n    const { startAngle , pixelMargin , x , y , outerRadius , innerRadius  } = element;\n    let angleMargin = pixelMargin / outerRadius;\n    // Draw an inner border by clipping the arc and drawing a double-width border\n    // Enlarge the clipping arc by 0.33 pixels to eliminate glitches between borders\n    ctx.beginPath();\n    ctx.arc(x, y, outerRadius, startAngle - angleMargin, endAngle + angleMargin);\n    if (innerRadius > pixelMargin) {\n        angleMargin = pixelMargin / innerRadius;\n        ctx.arc(x, y, innerRadius, endAngle + angleMargin, startAngle - angleMargin, true);\n    } else {\n        ctx.arc(x, y, pixelMargin, endAngle + _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.H, startAngle - _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.H);\n    }\n    ctx.closePath();\n    ctx.clip();\n}\nfunction toRadiusCorners(value) {\n    return (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.al)(value, [\n        'outerStart',\n        'outerEnd',\n        'innerStart',\n        'innerEnd'\n    ]);\n}\n/**\n * Parse border radius from the provided options\n */ function parseBorderRadius$1(arc, innerRadius, outerRadius, angleDelta) {\n    const o = toRadiusCorners(arc.options.borderRadius);\n    const halfThickness = (outerRadius - innerRadius) / 2;\n    const innerLimit = Math.min(halfThickness, angleDelta * innerRadius / 2);\n    // Outer limits are complicated. We want to compute the available angular distance at\n    // a radius of outerRadius - borderRadius because for small angular distances, this term limits.\n    // We compute at r = outerRadius - borderRadius because this circle defines the center of the border corners.\n    //\n    // If the borderRadius is large, that value can become negative.\n    // This causes the outer borders to lose their radius entirely, which is rather unexpected. To solve that, if borderRadius > outerRadius\n    // we know that the thickness term will dominate and compute the limits at that point\n    const computeOuterLimit = (val)=>{\n        const outerArcLimit = (outerRadius - Math.min(halfThickness, val)) * angleDelta / 2;\n        return (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.S)(val, 0, Math.min(halfThickness, outerArcLimit));\n    };\n    return {\n        outerStart: computeOuterLimit(o.outerStart),\n        outerEnd: computeOuterLimit(o.outerEnd),\n        innerStart: (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.S)(o.innerStart, 0, innerLimit),\n        innerEnd: (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.S)(o.innerEnd, 0, innerLimit)\n    };\n}\n/**\n * Convert (r, 𝜃) to (x, y)\n */ function rThetaToXY(r, theta, x, y) {\n    return {\n        x: x + r * Math.cos(theta),\n        y: y + r * Math.sin(theta)\n    };\n}\n/**\n * Path the arc, respecting border radius by separating into left and right halves.\n *\n *   Start      End\n *\n *    1--->a--->2    Outer\n *   /           \\\n *   8           3\n *   |           |\n *   |           |\n *   7           4\n *   \\           /\n *    6<---b<---5    Inner\n */ function pathArc(ctx, element, offset, spacing, end, circular) {\n    const { x , y , startAngle: start , pixelMargin , innerRadius: innerR  } = element;\n    const outerRadius = Math.max(element.outerRadius + spacing + offset - pixelMargin, 0);\n    const innerRadius = innerR > 0 ? innerR + spacing + offset + pixelMargin : 0;\n    let spacingOffset = 0;\n    const alpha = end - start;\n    if (spacing) {\n        // When spacing is present, it is the same for all items\n        // So we adjust the start and end angle of the arc such that\n        // the distance is the same as it would be without the spacing\n        const noSpacingInnerRadius = innerR > 0 ? innerR - spacing : 0;\n        const noSpacingOuterRadius = outerRadius > 0 ? outerRadius - spacing : 0;\n        const avNogSpacingRadius = (noSpacingInnerRadius + noSpacingOuterRadius) / 2;\n        const adjustedAngle = avNogSpacingRadius !== 0 ? alpha * avNogSpacingRadius / (avNogSpacingRadius + spacing) : alpha;\n        spacingOffset = (alpha - adjustedAngle) / 2;\n    }\n    const beta = Math.max(0.001, alpha * outerRadius - offset / _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.P) / outerRadius;\n    const angleOffset = (alpha - beta) / 2;\n    const startAngle = start + angleOffset + spacingOffset;\n    const endAngle = end - angleOffset - spacingOffset;\n    const { outerStart , outerEnd , innerStart , innerEnd  } = parseBorderRadius$1(element, innerRadius, outerRadius, endAngle - startAngle);\n    const outerStartAdjustedRadius = outerRadius - outerStart;\n    const outerEndAdjustedRadius = outerRadius - outerEnd;\n    const outerStartAdjustedAngle = startAngle + outerStart / outerStartAdjustedRadius;\n    const outerEndAdjustedAngle = endAngle - outerEnd / outerEndAdjustedRadius;\n    const innerStartAdjustedRadius = innerRadius + innerStart;\n    const innerEndAdjustedRadius = innerRadius + innerEnd;\n    const innerStartAdjustedAngle = startAngle + innerStart / innerStartAdjustedRadius;\n    const innerEndAdjustedAngle = endAngle - innerEnd / innerEndAdjustedRadius;\n    ctx.beginPath();\n    if (circular) {\n        // The first arc segments from point 1 to point a to point 2\n        const outerMidAdjustedAngle = (outerStartAdjustedAngle + outerEndAdjustedAngle) / 2;\n        ctx.arc(x, y, outerRadius, outerStartAdjustedAngle, outerMidAdjustedAngle);\n        ctx.arc(x, y, outerRadius, outerMidAdjustedAngle, outerEndAdjustedAngle);\n        // The corner segment from point 2 to point 3\n        if (outerEnd > 0) {\n            const pCenter = rThetaToXY(outerEndAdjustedRadius, outerEndAdjustedAngle, x, y);\n            ctx.arc(pCenter.x, pCenter.y, outerEnd, outerEndAdjustedAngle, endAngle + _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.H);\n        }\n        // The line from point 3 to point 4\n        const p4 = rThetaToXY(innerEndAdjustedRadius, endAngle, x, y);\n        ctx.lineTo(p4.x, p4.y);\n        // The corner segment from point 4 to point 5\n        if (innerEnd > 0) {\n            const pCenter = rThetaToXY(innerEndAdjustedRadius, innerEndAdjustedAngle, x, y);\n            ctx.arc(pCenter.x, pCenter.y, innerEnd, endAngle + _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.H, innerEndAdjustedAngle + Math.PI);\n        }\n        // The inner arc from point 5 to point b to point 6\n        const innerMidAdjustedAngle = (endAngle - innerEnd / innerRadius + (startAngle + innerStart / innerRadius)) / 2;\n        ctx.arc(x, y, innerRadius, endAngle - innerEnd / innerRadius, innerMidAdjustedAngle, true);\n        ctx.arc(x, y, innerRadius, innerMidAdjustedAngle, startAngle + innerStart / innerRadius, true);\n        // The corner segment from point 6 to point 7\n        if (innerStart > 0) {\n            const pCenter = rThetaToXY(innerStartAdjustedRadius, innerStartAdjustedAngle, x, y);\n            ctx.arc(pCenter.x, pCenter.y, innerStart, innerStartAdjustedAngle + Math.PI, startAngle - _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.H);\n        }\n        // The line from point 7 to point 8\n        const p8 = rThetaToXY(outerStartAdjustedRadius, startAngle, x, y);\n        ctx.lineTo(p8.x, p8.y);\n        // The corner segment from point 8 to point 1\n        if (outerStart > 0) {\n            const pCenter = rThetaToXY(outerStartAdjustedRadius, outerStartAdjustedAngle, x, y);\n            ctx.arc(pCenter.x, pCenter.y, outerStart, startAngle - _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.H, outerStartAdjustedAngle);\n        }\n    } else {\n        ctx.moveTo(x, y);\n        const outerStartX = Math.cos(outerStartAdjustedAngle) * outerRadius + x;\n        const outerStartY = Math.sin(outerStartAdjustedAngle) * outerRadius + y;\n        ctx.lineTo(outerStartX, outerStartY);\n        const outerEndX = Math.cos(outerEndAdjustedAngle) * outerRadius + x;\n        const outerEndY = Math.sin(outerEndAdjustedAngle) * outerRadius + y;\n        ctx.lineTo(outerEndX, outerEndY);\n    }\n    ctx.closePath();\n}\nfunction drawArc(ctx, element, offset, spacing, circular) {\n    const { fullCircles , startAngle , circumference  } = element;\n    let endAngle = element.endAngle;\n    if (fullCircles) {\n        pathArc(ctx, element, offset, spacing, endAngle, circular);\n        for(let i = 0; i < fullCircles; ++i){\n            ctx.fill();\n        }\n        if (!isNaN(circumference)) {\n            endAngle = startAngle + (circumference % _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.T || _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.T);\n        }\n    }\n    pathArc(ctx, element, offset, spacing, endAngle, circular);\n    ctx.fill();\n    return endAngle;\n}\nfunction drawBorder(ctx, element, offset, spacing, circular) {\n    const { fullCircles , startAngle , circumference , options  } = element;\n    const { borderWidth , borderJoinStyle , borderDash , borderDashOffset  } = options;\n    const inner = options.borderAlign === 'inner';\n    if (!borderWidth) {\n        return;\n    }\n    ctx.setLineDash(borderDash || []);\n    ctx.lineDashOffset = borderDashOffset;\n    if (inner) {\n        ctx.lineWidth = borderWidth * 2;\n        ctx.lineJoin = borderJoinStyle || 'round';\n    } else {\n        ctx.lineWidth = borderWidth;\n        ctx.lineJoin = borderJoinStyle || 'bevel';\n    }\n    let endAngle = element.endAngle;\n    if (fullCircles) {\n        pathArc(ctx, element, offset, spacing, endAngle, circular);\n        for(let i = 0; i < fullCircles; ++i){\n            ctx.stroke();\n        }\n        if (!isNaN(circumference)) {\n            endAngle = startAngle + (circumference % _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.T || _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.T);\n        }\n    }\n    if (inner) {\n        clipArc(ctx, element, endAngle);\n    }\n    if (!fullCircles) {\n        pathArc(ctx, element, offset, spacing, endAngle, circular);\n        ctx.stroke();\n    }\n}\nclass ArcElement extends Element {\n    static id = 'arc';\n    static defaults = {\n        borderAlign: 'center',\n        borderColor: '#fff',\n        borderDash: [],\n        borderDashOffset: 0,\n        borderJoinStyle: undefined,\n        borderRadius: 0,\n        borderWidth: 2,\n        offset: 0,\n        spacing: 0,\n        angle: undefined,\n        circular: true\n    };\n    static defaultRoutes = {\n        backgroundColor: 'backgroundColor'\n    };\n    static descriptors = {\n        _scriptable: true,\n        _indexable: (name)=>name !== 'borderDash'\n    };\n    circumference;\n    endAngle;\n    fullCircles;\n    innerRadius;\n    outerRadius;\n    pixelMargin;\n    startAngle;\n    constructor(cfg){\n        super();\n        this.options = undefined;\n        this.circumference = undefined;\n        this.startAngle = undefined;\n        this.endAngle = undefined;\n        this.innerRadius = undefined;\n        this.outerRadius = undefined;\n        this.pixelMargin = 0;\n        this.fullCircles = 0;\n        if (cfg) {\n            Object.assign(this, cfg);\n        }\n    }\n    inRange(chartX, chartY, useFinalPosition) {\n        const point = this.getProps([\n            'x',\n            'y'\n        ], useFinalPosition);\n        const { angle , distance  } = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.D)(point, {\n            x: chartX,\n            y: chartY\n        });\n        const { startAngle , endAngle , innerRadius , outerRadius , circumference  } = this.getProps([\n            'startAngle',\n            'endAngle',\n            'innerRadius',\n            'outerRadius',\n            'circumference'\n        ], useFinalPosition);\n        const rAdjust = (this.options.spacing + this.options.borderWidth) / 2;\n        const _circumference = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.v)(circumference, endAngle - startAngle);\n        const nonZeroBetween = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.p)(angle, startAngle, endAngle) && startAngle !== endAngle;\n        const betweenAngles = _circumference >= _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.T || nonZeroBetween;\n        const withinRadius = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.ak)(distance, innerRadius + rAdjust, outerRadius + rAdjust);\n        return betweenAngles && withinRadius;\n    }\n    getCenterPoint(useFinalPosition) {\n        const { x , y , startAngle , endAngle , innerRadius , outerRadius  } = this.getProps([\n            'x',\n            'y',\n            'startAngle',\n            'endAngle',\n            'innerRadius',\n            'outerRadius'\n        ], useFinalPosition);\n        const { offset , spacing  } = this.options;\n        const halfAngle = (startAngle + endAngle) / 2;\n        const halfRadius = (innerRadius + outerRadius + spacing + offset) / 2;\n        return {\n            x: x + Math.cos(halfAngle) * halfRadius,\n            y: y + Math.sin(halfAngle) * halfRadius\n        };\n    }\n    tooltipPosition(useFinalPosition) {\n        return this.getCenterPoint(useFinalPosition);\n    }\n    draw(ctx) {\n        const { options , circumference  } = this;\n        const offset = (options.offset || 0) / 4;\n        const spacing = (options.spacing || 0) / 2;\n        const circular = options.circular;\n        this.pixelMargin = options.borderAlign === 'inner' ? 0.33 : 0;\n        this.fullCircles = circumference > _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.T ? Math.floor(circumference / _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.T) : 0;\n        if (circumference === 0 || this.innerRadius < 0 || this.outerRadius < 0) {\n            return;\n        }\n        ctx.save();\n        const halfAngle = (this.startAngle + this.endAngle) / 2;\n        ctx.translate(Math.cos(halfAngle) * offset, Math.sin(halfAngle) * offset);\n        const fix = 1 - Math.sin(Math.min(_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.P, circumference || 0));\n        const radiusOffset = offset * fix;\n        ctx.fillStyle = options.backgroundColor;\n        ctx.strokeStyle = options.borderColor;\n        drawArc(ctx, this, radiusOffset, spacing, circular);\n        drawBorder(ctx, this, radiusOffset, spacing, circular);\n        ctx.restore();\n    }\n}\n\nfunction setStyle(ctx, options, style = options) {\n    ctx.lineCap = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.v)(style.borderCapStyle, options.borderCapStyle);\n    ctx.setLineDash((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.v)(style.borderDash, options.borderDash));\n    ctx.lineDashOffset = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.v)(style.borderDashOffset, options.borderDashOffset);\n    ctx.lineJoin = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.v)(style.borderJoinStyle, options.borderJoinStyle);\n    ctx.lineWidth = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.v)(style.borderWidth, options.borderWidth);\n    ctx.strokeStyle = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.v)(style.borderColor, options.borderColor);\n}\nfunction lineTo(ctx, previous, target) {\n    ctx.lineTo(target.x, target.y);\n}\n function getLineMethod(options) {\n    if (options.stepped) {\n        return _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.as;\n    }\n    if (options.tension || options.cubicInterpolationMode === 'monotone') {\n        return _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.at;\n    }\n    return lineTo;\n}\nfunction pathVars(points, segment, params = {}) {\n    const count = points.length;\n    const { start: paramsStart = 0 , end: paramsEnd = count - 1  } = params;\n    const { start: segmentStart , end: segmentEnd  } = segment;\n    const start = Math.max(paramsStart, segmentStart);\n    const end = Math.min(paramsEnd, segmentEnd);\n    const outside = paramsStart < segmentStart && paramsEnd < segmentStart || paramsStart > segmentEnd && paramsEnd > segmentEnd;\n    return {\n        count,\n        start,\n        loop: segment.loop,\n        ilen: end < start && !outside ? count + end - start : end - start\n    };\n}\n function pathSegment(ctx, line, segment, params) {\n    const { points , options  } = line;\n    const { count , start , loop , ilen  } = pathVars(points, segment, params);\n    const lineMethod = getLineMethod(options);\n    let { move =true , reverse  } = params || {};\n    let i, point, prev;\n    for(i = 0; i <= ilen; ++i){\n        point = points[(start + (reverse ? ilen - i : i)) % count];\n        if (point.skip) {\n            continue;\n        } else if (move) {\n            ctx.moveTo(point.x, point.y);\n            move = false;\n        } else {\n            lineMethod(ctx, prev, point, reverse, options.stepped);\n        }\n        prev = point;\n    }\n    if (loop) {\n        point = points[(start + (reverse ? ilen : 0)) % count];\n        lineMethod(ctx, prev, point, reverse, options.stepped);\n    }\n    return !!loop;\n}\n function fastPathSegment(ctx, line, segment, params) {\n    const points = line.points;\n    const { count , start , ilen  } = pathVars(points, segment, params);\n    const { move =true , reverse  } = params || {};\n    let avgX = 0;\n    let countX = 0;\n    let i, point, prevX, minY, maxY, lastY;\n    const pointIndex = (index)=>(start + (reverse ? ilen - index : index)) % count;\n    const drawX = ()=>{\n        if (minY !== maxY) {\n            ctx.lineTo(avgX, maxY);\n            ctx.lineTo(avgX, minY);\n            ctx.lineTo(avgX, lastY);\n        }\n    };\n    if (move) {\n        point = points[pointIndex(0)];\n        ctx.moveTo(point.x, point.y);\n    }\n    for(i = 0; i <= ilen; ++i){\n        point = points[pointIndex(i)];\n        if (point.skip) {\n            continue;\n        }\n        const x = point.x;\n        const y = point.y;\n        const truncX = x | 0;\n        if (truncX === prevX) {\n            if (y < minY) {\n                minY = y;\n            } else if (y > maxY) {\n                maxY = y;\n            }\n            avgX = (countX * avgX + x) / ++countX;\n        } else {\n            drawX();\n            ctx.lineTo(x, y);\n            prevX = truncX;\n            countX = 0;\n            minY = maxY = y;\n        }\n        lastY = y;\n    }\n    drawX();\n}\n function _getSegmentMethod(line) {\n    const opts = line.options;\n    const borderDash = opts.borderDash && opts.borderDash.length;\n    const useFastPath = !line._decimated && !line._loop && !opts.tension && opts.cubicInterpolationMode !== 'monotone' && !opts.stepped && !borderDash;\n    return useFastPath ? fastPathSegment : pathSegment;\n}\n function _getInterpolationMethod(options) {\n    if (options.stepped) {\n        return _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.ap;\n    }\n    if (options.tension || options.cubicInterpolationMode === 'monotone') {\n        return _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.aq;\n    }\n    return _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.ar;\n}\nfunction strokePathWithCache(ctx, line, start, count) {\n    let path = line._path;\n    if (!path) {\n        path = line._path = new Path2D();\n        if (line.path(path, start, count)) {\n            path.closePath();\n        }\n    }\n    setStyle(ctx, line.options);\n    ctx.stroke(path);\n}\nfunction strokePathDirect(ctx, line, start, count) {\n    const { segments , options  } = line;\n    const segmentMethod = _getSegmentMethod(line);\n    for (const segment of segments){\n        setStyle(ctx, options, segment.style);\n        ctx.beginPath();\n        if (segmentMethod(ctx, line, segment, {\n            start,\n            end: start + count - 1\n        })) {\n            ctx.closePath();\n        }\n        ctx.stroke();\n    }\n}\nconst usePath2D = typeof Path2D === 'function';\nfunction draw(ctx, line, start, count) {\n    if (usePath2D && !line.options.segment) {\n        strokePathWithCache(ctx, line, start, count);\n    } else {\n        strokePathDirect(ctx, line, start, count);\n    }\n}\nclass LineElement extends Element {\n    static id = 'line';\n static defaults = {\n        borderCapStyle: 'butt',\n        borderDash: [],\n        borderDashOffset: 0,\n        borderJoinStyle: 'miter',\n        borderWidth: 3,\n        capBezierPoints: true,\n        cubicInterpolationMode: 'default',\n        fill: false,\n        spanGaps: false,\n        stepped: false,\n        tension: 0\n    };\n static defaultRoutes = {\n        backgroundColor: 'backgroundColor',\n        borderColor: 'borderColor'\n    };\n    static descriptors = {\n        _scriptable: true,\n        _indexable: (name)=>name !== 'borderDash' && name !== 'fill'\n    };\n    constructor(cfg){\n        super();\n        this.animated = true;\n        this.options = undefined;\n        this._chart = undefined;\n        this._loop = undefined;\n        this._fullLoop = undefined;\n        this._path = undefined;\n        this._points = undefined;\n        this._segments = undefined;\n        this._decimated = false;\n        this._pointsUpdated = false;\n        this._datasetIndex = undefined;\n        if (cfg) {\n            Object.assign(this, cfg);\n        }\n    }\n    updateControlPoints(chartArea, indexAxis) {\n        const options = this.options;\n        if ((options.tension || options.cubicInterpolationMode === 'monotone') && !options.stepped && !this._pointsUpdated) {\n            const loop = options.spanGaps ? this._loop : this._fullLoop;\n            (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.am)(this._points, options, chartArea, loop, indexAxis);\n            this._pointsUpdated = true;\n        }\n    }\n    set points(points) {\n        this._points = points;\n        delete this._segments;\n        delete this._path;\n        this._pointsUpdated = false;\n    }\n    get points() {\n        return this._points;\n    }\n    get segments() {\n        return this._segments || (this._segments = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.an)(this, this.options.segment));\n    }\n first() {\n        const segments = this.segments;\n        const points = this.points;\n        return segments.length && points[segments[0].start];\n    }\n last() {\n        const segments = this.segments;\n        const points = this.points;\n        const count = segments.length;\n        return count && points[segments[count - 1].end];\n    }\n interpolate(point, property) {\n        const options = this.options;\n        const value = point[property];\n        const points = this.points;\n        const segments = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.ao)(this, {\n            property,\n            start: value,\n            end: value\n        });\n        if (!segments.length) {\n            return;\n        }\n        const result = [];\n        const _interpolate = _getInterpolationMethod(options);\n        let i, ilen;\n        for(i = 0, ilen = segments.length; i < ilen; ++i){\n            const { start , end  } = segments[i];\n            const p1 = points[start];\n            const p2 = points[end];\n            if (p1 === p2) {\n                result.push(p1);\n                continue;\n            }\n            const t = Math.abs((value - p1[property]) / (p2[property] - p1[property]));\n            const interpolated = _interpolate(p1, p2, t, options.stepped);\n            interpolated[property] = point[property];\n            result.push(interpolated);\n        }\n        return result.length === 1 ? result[0] : result;\n    }\n pathSegment(ctx, segment, params) {\n        const segmentMethod = _getSegmentMethod(this);\n        return segmentMethod(ctx, this, segment, params);\n    }\n path(ctx, start, count) {\n        const segments = this.segments;\n        const segmentMethod = _getSegmentMethod(this);\n        let loop = this._loop;\n        start = start || 0;\n        count = count || this.points.length - start;\n        for (const segment of segments){\n            loop &= segmentMethod(ctx, this, segment, {\n                start,\n                end: start + count - 1\n            });\n        }\n        return !!loop;\n    }\n draw(ctx, chartArea, start, count) {\n        const options = this.options || {};\n        const points = this.points || [];\n        if (points.length && options.borderWidth) {\n            ctx.save();\n            draw(ctx, this, start, count);\n            ctx.restore();\n        }\n        if (this.animated) {\n            this._pointsUpdated = false;\n            this._path = undefined;\n        }\n    }\n}\n\nfunction inRange$1(el, pos, axis, useFinalPosition) {\n    const options = el.options;\n    const { [axis]: value  } = el.getProps([\n        axis\n    ], useFinalPosition);\n    return Math.abs(pos - value) < options.radius + options.hitRadius;\n}\nclass PointElement extends Element {\n    static id = 'point';\n    parsed;\n    skip;\n    stop;\n    /**\n   * @type {any}\n   */ static defaults = {\n        borderWidth: 1,\n        hitRadius: 1,\n        hoverBorderWidth: 1,\n        hoverRadius: 4,\n        pointStyle: 'circle',\n        radius: 3,\n        rotation: 0\n    };\n    /**\n   * @type {any}\n   */ static defaultRoutes = {\n        backgroundColor: 'backgroundColor',\n        borderColor: 'borderColor'\n    };\n    constructor(cfg){\n        super();\n        this.options = undefined;\n        this.parsed = undefined;\n        this.skip = undefined;\n        this.stop = undefined;\n        if (cfg) {\n            Object.assign(this, cfg);\n        }\n    }\n    inRange(mouseX, mouseY, useFinalPosition) {\n        const options = this.options;\n        const { x , y  } = this.getProps([\n            'x',\n            'y'\n        ], useFinalPosition);\n        return Math.pow(mouseX - x, 2) + Math.pow(mouseY - y, 2) < Math.pow(options.hitRadius + options.radius, 2);\n    }\n    inXRange(mouseX, useFinalPosition) {\n        return inRange$1(this, mouseX, 'x', useFinalPosition);\n    }\n    inYRange(mouseY, useFinalPosition) {\n        return inRange$1(this, mouseY, 'y', useFinalPosition);\n    }\n    getCenterPoint(useFinalPosition) {\n        const { x , y  } = this.getProps([\n            'x',\n            'y'\n        ], useFinalPosition);\n        return {\n            x,\n            y\n        };\n    }\n    size(options) {\n        options = options || this.options || {};\n        let radius = options.radius || 0;\n        radius = Math.max(radius, radius && options.hoverRadius || 0);\n        const borderWidth = radius && options.borderWidth || 0;\n        return (radius + borderWidth) * 2;\n    }\n    draw(ctx, area) {\n        const options = this.options;\n        if (this.skip || options.radius < 0.1 || !(0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.C)(this, area, this.size(options) / 2)) {\n            return;\n        }\n        ctx.strokeStyle = options.borderColor;\n        ctx.lineWidth = options.borderWidth;\n        ctx.fillStyle = options.backgroundColor;\n        (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.au)(ctx, options, this.x, this.y);\n    }\n    getRange() {\n        const options = this.options || {};\n        // @ts-expect-error Fallbacks should never be hit in practice\n        return options.radius + options.hitRadius;\n    }\n}\n\nfunction getBarBounds(bar, useFinalPosition) {\n    const { x , y , base , width , height  } =  bar.getProps([\n        'x',\n        'y',\n        'base',\n        'width',\n        'height'\n    ], useFinalPosition);\n    let left, right, top, bottom, half;\n    if (bar.horizontal) {\n        half = height / 2;\n        left = Math.min(x, base);\n        right = Math.max(x, base);\n        top = y - half;\n        bottom = y + half;\n    } else {\n        half = width / 2;\n        left = x - half;\n        right = x + half;\n        top = Math.min(y, base);\n        bottom = Math.max(y, base);\n    }\n    return {\n        left,\n        top,\n        right,\n        bottom\n    };\n}\nfunction skipOrLimit(skip, value, min, max) {\n    return skip ? 0 : (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.S)(value, min, max);\n}\nfunction parseBorderWidth(bar, maxW, maxH) {\n    const value = bar.options.borderWidth;\n    const skip = bar.borderSkipped;\n    const o = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.aw)(value);\n    return {\n        t: skipOrLimit(skip.top, o.top, 0, maxH),\n        r: skipOrLimit(skip.right, o.right, 0, maxW),\n        b: skipOrLimit(skip.bottom, o.bottom, 0, maxH),\n        l: skipOrLimit(skip.left, o.left, 0, maxW)\n    };\n}\nfunction parseBorderRadius(bar, maxW, maxH) {\n    const { enableBorderRadius  } = bar.getProps([\n        'enableBorderRadius'\n    ]);\n    const value = bar.options.borderRadius;\n    const o = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.ax)(value);\n    const maxR = Math.min(maxW, maxH);\n    const skip = bar.borderSkipped;\n    const enableBorder = enableBorderRadius || (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.i)(value);\n    return {\n        topLeft: skipOrLimit(!enableBorder || skip.top || skip.left, o.topLeft, 0, maxR),\n        topRight: skipOrLimit(!enableBorder || skip.top || skip.right, o.topRight, 0, maxR),\n        bottomLeft: skipOrLimit(!enableBorder || skip.bottom || skip.left, o.bottomLeft, 0, maxR),\n        bottomRight: skipOrLimit(!enableBorder || skip.bottom || skip.right, o.bottomRight, 0, maxR)\n    };\n}\nfunction boundingRects(bar) {\n    const bounds = getBarBounds(bar);\n    const width = bounds.right - bounds.left;\n    const height = bounds.bottom - bounds.top;\n    const border = parseBorderWidth(bar, width / 2, height / 2);\n    const radius = parseBorderRadius(bar, width / 2, height / 2);\n    return {\n        outer: {\n            x: bounds.left,\n            y: bounds.top,\n            w: width,\n            h: height,\n            radius\n        },\n        inner: {\n            x: bounds.left + border.l,\n            y: bounds.top + border.t,\n            w: width - border.l - border.r,\n            h: height - border.t - border.b,\n            radius: {\n                topLeft: Math.max(0, radius.topLeft - Math.max(border.t, border.l)),\n                topRight: Math.max(0, radius.topRight - Math.max(border.t, border.r)),\n                bottomLeft: Math.max(0, radius.bottomLeft - Math.max(border.b, border.l)),\n                bottomRight: Math.max(0, radius.bottomRight - Math.max(border.b, border.r))\n            }\n        }\n    };\n}\nfunction inRange(bar, x, y, useFinalPosition) {\n    const skipX = x === null;\n    const skipY = y === null;\n    const skipBoth = skipX && skipY;\n    const bounds = bar && !skipBoth && getBarBounds(bar, useFinalPosition);\n    return bounds && (skipX || (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.ak)(x, bounds.left, bounds.right)) && (skipY || (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.ak)(y, bounds.top, bounds.bottom));\n}\nfunction hasRadius(radius) {\n    return radius.topLeft || radius.topRight || radius.bottomLeft || radius.bottomRight;\n}\n function addNormalRectPath(ctx, rect) {\n    ctx.rect(rect.x, rect.y, rect.w, rect.h);\n}\nfunction inflateRect(rect, amount, refRect = {}) {\n    const x = rect.x !== refRect.x ? -amount : 0;\n    const y = rect.y !== refRect.y ? -amount : 0;\n    const w = (rect.x + rect.w !== refRect.x + refRect.w ? amount : 0) - x;\n    const h = (rect.y + rect.h !== refRect.y + refRect.h ? amount : 0) - y;\n    return {\n        x: rect.x + x,\n        y: rect.y + y,\n        w: rect.w + w,\n        h: rect.h + h,\n        radius: rect.radius\n    };\n}\nclass BarElement extends Element {\n    static id = 'bar';\n static defaults = {\n        borderSkipped: 'start',\n        borderWidth: 0,\n        borderRadius: 0,\n        inflateAmount: 'auto',\n        pointStyle: undefined\n    };\n static defaultRoutes = {\n        backgroundColor: 'backgroundColor',\n        borderColor: 'borderColor'\n    };\n    constructor(cfg){\n        super();\n        this.options = undefined;\n        this.horizontal = undefined;\n        this.base = undefined;\n        this.width = undefined;\n        this.height = undefined;\n        this.inflateAmount = undefined;\n        if (cfg) {\n            Object.assign(this, cfg);\n        }\n    }\n    draw(ctx) {\n        const { inflateAmount , options: { borderColor , backgroundColor  }  } = this;\n        const { inner , outer  } = boundingRects(this);\n        const addRectPath = hasRadius(outer.radius) ? _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.av : addNormalRectPath;\n        ctx.save();\n        if (outer.w !== inner.w || outer.h !== inner.h) {\n            ctx.beginPath();\n            addRectPath(ctx, inflateRect(outer, inflateAmount, inner));\n            ctx.clip();\n            addRectPath(ctx, inflateRect(inner, -inflateAmount, outer));\n            ctx.fillStyle = borderColor;\n            ctx.fill('evenodd');\n        }\n        ctx.beginPath();\n        addRectPath(ctx, inflateRect(inner, inflateAmount));\n        ctx.fillStyle = backgroundColor;\n        ctx.fill();\n        ctx.restore();\n    }\n    inRange(mouseX, mouseY, useFinalPosition) {\n        return inRange(this, mouseX, mouseY, useFinalPosition);\n    }\n    inXRange(mouseX, useFinalPosition) {\n        return inRange(this, mouseX, null, useFinalPosition);\n    }\n    inYRange(mouseY, useFinalPosition) {\n        return inRange(this, null, mouseY, useFinalPosition);\n    }\n    getCenterPoint(useFinalPosition) {\n        const { x , y , base , horizontal  } =  this.getProps([\n            'x',\n            'y',\n            'base',\n            'horizontal'\n        ], useFinalPosition);\n        return {\n            x: horizontal ? (x + base) / 2 : x,\n            y: horizontal ? y : (y + base) / 2\n        };\n    }\n    getRange(axis) {\n        return axis === 'x' ? this.width / 2 : this.height / 2;\n    }\n}\n\nvar elements = /*#__PURE__*/Object.freeze({\n__proto__: null,\nArcElement: ArcElement,\nBarElement: BarElement,\nLineElement: LineElement,\nPointElement: PointElement\n});\n\nconst BORDER_COLORS = [\n    'rgb(54, 162, 235)',\n    'rgb(255, 99, 132)',\n    'rgb(255, 159, 64)',\n    'rgb(255, 205, 86)',\n    'rgb(75, 192, 192)',\n    'rgb(153, 102, 255)',\n    'rgb(201, 203, 207)' // grey\n];\n// Border colors with 50% transparency\nconst BACKGROUND_COLORS = /* #__PURE__ */ BORDER_COLORS.map((color)=>color.replace('rgb(', 'rgba(').replace(')', ', 0.5)'));\nfunction getBorderColor(i) {\n    return BORDER_COLORS[i % BORDER_COLORS.length];\n}\nfunction getBackgroundColor(i) {\n    return BACKGROUND_COLORS[i % BACKGROUND_COLORS.length];\n}\nfunction colorizeDefaultDataset(dataset, i) {\n    dataset.borderColor = getBorderColor(i);\n    dataset.backgroundColor = getBackgroundColor(i);\n    return ++i;\n}\nfunction colorizeDoughnutDataset(dataset, i) {\n    dataset.backgroundColor = dataset.data.map(()=>getBorderColor(i++));\n    return i;\n}\nfunction colorizePolarAreaDataset(dataset, i) {\n    dataset.backgroundColor = dataset.data.map(()=>getBackgroundColor(i++));\n    return i;\n}\nfunction getColorizer(chart) {\n    let i = 0;\n    return (dataset, datasetIndex)=>{\n        const controller = chart.getDatasetMeta(datasetIndex).controller;\n        if (controller instanceof DoughnutController) {\n            i = colorizeDoughnutDataset(dataset, i);\n        } else if (controller instanceof PolarAreaController) {\n            i = colorizePolarAreaDataset(dataset, i);\n        } else if (controller) {\n            i = colorizeDefaultDataset(dataset, i);\n        }\n    };\n}\nfunction containsColorsDefinitions(descriptors) {\n    let k;\n    for(k in descriptors){\n        if (descriptors[k].borderColor || descriptors[k].backgroundColor) {\n            return true;\n        }\n    }\n    return false;\n}\nfunction containsColorsDefinition(descriptor) {\n    return descriptor && (descriptor.borderColor || descriptor.backgroundColor);\n}\nfunction containsDefaultColorsDefenitions() {\n    return _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.d.borderColor !== 'rgba(0,0,0,0.1)' || _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.d.backgroundColor !== 'rgba(0,0,0,0.1)';\n}\nvar plugin_colors = {\n    id: 'colors',\n    defaults: {\n        enabled: true,\n        forceOverride: false\n    },\n    beforeLayout (chart, _args, options) {\n        if (!options.enabled) {\n            return;\n        }\n        const { data: { datasets  } , options: chartOptions  } = chart.config;\n        const { elements  } = chartOptions;\n        const containsColorDefenition = containsColorsDefinitions(datasets) || containsColorsDefinition(chartOptions) || elements && containsColorsDefinitions(elements) || containsDefaultColorsDefenitions();\n        if (!options.forceOverride && containsColorDefenition) {\n            return;\n        }\n        const colorizer = getColorizer(chart);\n        datasets.forEach(colorizer);\n    }\n};\n\nfunction lttbDecimation(data, start, count, availableWidth, options) {\n const samples = options.samples || availableWidth;\n    if (samples >= count) {\n        return data.slice(start, start + count);\n    }\n    const decimated = [];\n    const bucketWidth = (count - 2) / (samples - 2);\n    let sampledIndex = 0;\n    const endIndex = start + count - 1;\n    let a = start;\n    let i, maxAreaPoint, maxArea, area, nextA;\n    decimated[sampledIndex++] = data[a];\n    for(i = 0; i < samples - 2; i++){\n        let avgX = 0;\n        let avgY = 0;\n        let j;\n        const avgRangeStart = Math.floor((i + 1) * bucketWidth) + 1 + start;\n        const avgRangeEnd = Math.min(Math.floor((i + 2) * bucketWidth) + 1, count) + start;\n        const avgRangeLength = avgRangeEnd - avgRangeStart;\n        for(j = avgRangeStart; j < avgRangeEnd; j++){\n            avgX += data[j].x;\n            avgY += data[j].y;\n        }\n        avgX /= avgRangeLength;\n        avgY /= avgRangeLength;\n        const rangeOffs = Math.floor(i * bucketWidth) + 1 + start;\n        const rangeTo = Math.min(Math.floor((i + 1) * bucketWidth) + 1, count) + start;\n        const { x: pointAx , y: pointAy  } = data[a];\n        maxArea = area = -1;\n        for(j = rangeOffs; j < rangeTo; j++){\n            area = 0.5 * Math.abs((pointAx - avgX) * (data[j].y - pointAy) - (pointAx - data[j].x) * (avgY - pointAy));\n            if (area > maxArea) {\n                maxArea = area;\n                maxAreaPoint = data[j];\n                nextA = j;\n            }\n        }\n        decimated[sampledIndex++] = maxAreaPoint;\n        a = nextA;\n    }\n    decimated[sampledIndex++] = data[endIndex];\n    return decimated;\n}\nfunction minMaxDecimation(data, start, count, availableWidth) {\n    let avgX = 0;\n    let countX = 0;\n    let i, point, x, y, prevX, minIndex, maxIndex, startIndex, minY, maxY;\n    const decimated = [];\n    const endIndex = start + count - 1;\n    const xMin = data[start].x;\n    const xMax = data[endIndex].x;\n    const dx = xMax - xMin;\n    for(i = start; i < start + count; ++i){\n        point = data[i];\n        x = (point.x - xMin) / dx * availableWidth;\n        y = point.y;\n        const truncX = x | 0;\n        if (truncX === prevX) {\n            if (y < minY) {\n                minY = y;\n                minIndex = i;\n            } else if (y > maxY) {\n                maxY = y;\n                maxIndex = i;\n            }\n            avgX = (countX * avgX + point.x) / ++countX;\n        } else {\n            const lastIndex = i - 1;\n            if (!(0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.k)(minIndex) && !(0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.k)(maxIndex)) {\n                const intermediateIndex1 = Math.min(minIndex, maxIndex);\n                const intermediateIndex2 = Math.max(minIndex, maxIndex);\n                if (intermediateIndex1 !== startIndex && intermediateIndex1 !== lastIndex) {\n                    decimated.push({\n                        ...data[intermediateIndex1],\n                        x: avgX\n                    });\n                }\n                if (intermediateIndex2 !== startIndex && intermediateIndex2 !== lastIndex) {\n                    decimated.push({\n                        ...data[intermediateIndex2],\n                        x: avgX\n                    });\n                }\n            }\n            if (i > 0 && lastIndex !== startIndex) {\n                decimated.push(data[lastIndex]);\n            }\n            decimated.push(point);\n            prevX = truncX;\n            countX = 0;\n            minY = maxY = y;\n            minIndex = maxIndex = startIndex = i;\n        }\n    }\n    return decimated;\n}\nfunction cleanDecimatedDataset(dataset) {\n    if (dataset._decimated) {\n        const data = dataset._data;\n        delete dataset._decimated;\n        delete dataset._data;\n        Object.defineProperty(dataset, 'data', {\n            configurable: true,\n            enumerable: true,\n            writable: true,\n            value: data\n        });\n    }\n}\nfunction cleanDecimatedData(chart) {\n    chart.data.datasets.forEach((dataset)=>{\n        cleanDecimatedDataset(dataset);\n    });\n}\nfunction getStartAndCountOfVisiblePointsSimplified(meta, points) {\n    const pointCount = points.length;\n    let start = 0;\n    let count;\n    const { iScale  } = meta;\n    const { min , max , minDefined , maxDefined  } = iScale.getUserBounds();\n    if (minDefined) {\n        start = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.S)((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.B)(points, iScale.axis, min).lo, 0, pointCount - 1);\n    }\n    if (maxDefined) {\n        count = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.S)((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.B)(points, iScale.axis, max).hi + 1, start, pointCount) - start;\n    } else {\n        count = pointCount - start;\n    }\n    return {\n        start,\n        count\n    };\n}\nvar plugin_decimation = {\n    id: 'decimation',\n    defaults: {\n        algorithm: 'min-max',\n        enabled: false\n    },\n    beforeElementsUpdate: (chart, args, options)=>{\n        if (!options.enabled) {\n            cleanDecimatedData(chart);\n            return;\n        }\n        const availableWidth = chart.width;\n        chart.data.datasets.forEach((dataset, datasetIndex)=>{\n            const { _data , indexAxis  } = dataset;\n            const meta = chart.getDatasetMeta(datasetIndex);\n            const data = _data || dataset.data;\n            if ((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a)([\n                indexAxis,\n                chart.options.indexAxis\n            ]) === 'y') {\n                return;\n            }\n            if (!meta.controller.supportsDecimation) {\n                return;\n            }\n            const xAxis = chart.scales[meta.xAxisID];\n            if (xAxis.type !== 'linear' && xAxis.type !== 'time') {\n                return;\n            }\n            if (chart.options.parsing) {\n                return;\n            }\n            let { start , count  } = getStartAndCountOfVisiblePointsSimplified(meta, data);\n            const threshold = options.threshold || 4 * availableWidth;\n            if (count <= threshold) {\n                cleanDecimatedDataset(dataset);\n                return;\n            }\n            if ((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.k)(_data)) {\n                dataset._data = data;\n                delete dataset.data;\n                Object.defineProperty(dataset, 'data', {\n                    configurable: true,\n                    enumerable: true,\n                    get: function() {\n                        return this._decimated;\n                    },\n                    set: function(d) {\n                        this._data = d;\n                    }\n                });\n            }\n            let decimated;\n            switch(options.algorithm){\n                case 'lttb':\n                    decimated = lttbDecimation(data, start, count, availableWidth, options);\n                    break;\n                case 'min-max':\n                    decimated = minMaxDecimation(data, start, count, availableWidth);\n                    break;\n                default:\n                    throw new Error(`Unsupported decimation algorithm '${options.algorithm}'`);\n            }\n            dataset._decimated = decimated;\n        });\n    },\n    destroy (chart) {\n        cleanDecimatedData(chart);\n    }\n};\n\nfunction _segments(line, target, property) {\n    const segments = line.segments;\n    const points = line.points;\n    const tpoints = target.points;\n    const parts = [];\n    for (const segment of segments){\n        let { start , end  } = segment;\n        end = _findSegmentEnd(start, end, points);\n        const bounds = _getBounds(property, points[start], points[end], segment.loop);\n        if (!target.segments) {\n            parts.push({\n                source: segment,\n                target: bounds,\n                start: points[start],\n                end: points[end]\n            });\n            continue;\n        }\n        const targetSegments = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.ao)(target, bounds);\n        for (const tgt of targetSegments){\n            const subBounds = _getBounds(property, tpoints[tgt.start], tpoints[tgt.end], tgt.loop);\n            const fillSources = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.ay)(segment, points, subBounds);\n            for (const fillSource of fillSources){\n                parts.push({\n                    source: fillSource,\n                    target: tgt,\n                    start: {\n                        [property]: _getEdge(bounds, subBounds, 'start', Math.max)\n                    },\n                    end: {\n                        [property]: _getEdge(bounds, subBounds, 'end', Math.min)\n                    }\n                });\n            }\n        }\n    }\n    return parts;\n}\nfunction _getBounds(property, first, last, loop) {\n    if (loop) {\n        return;\n    }\n    let start = first[property];\n    let end = last[property];\n    if (property === 'angle') {\n        start = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.az)(start);\n        end = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.az)(end);\n    }\n    return {\n        property,\n        start,\n        end\n    };\n}\nfunction _pointsFromSegments(boundary, line) {\n    const { x =null , y =null  } = boundary || {};\n    const linePoints = line.points;\n    const points = [];\n    line.segments.forEach(({ start , end  })=>{\n        end = _findSegmentEnd(start, end, linePoints);\n        const first = linePoints[start];\n        const last = linePoints[end];\n        if (y !== null) {\n            points.push({\n                x: first.x,\n                y\n            });\n            points.push({\n                x: last.x,\n                y\n            });\n        } else if (x !== null) {\n            points.push({\n                x,\n                y: first.y\n            });\n            points.push({\n                x,\n                y: last.y\n            });\n        }\n    });\n    return points;\n}\nfunction _findSegmentEnd(start, end, points) {\n    for(; end > start; end--){\n        const point = points[end];\n        if (!isNaN(point.x) && !isNaN(point.y)) {\n            break;\n        }\n    }\n    return end;\n}\nfunction _getEdge(a, b, prop, fn) {\n    if (a && b) {\n        return fn(a[prop], b[prop]);\n    }\n    return a ? a[prop] : b ? b[prop] : 0;\n}\n\nfunction _createBoundaryLine(boundary, line) {\n    let points = [];\n    let _loop = false;\n    if ((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.b)(boundary)) {\n        _loop = true;\n        points = boundary;\n    } else {\n        points = _pointsFromSegments(boundary, line);\n    }\n    return points.length ? new LineElement({\n        points,\n        options: {\n            tension: 0\n        },\n        _loop,\n        _fullLoop: _loop\n    }) : null;\n}\nfunction _shouldApplyFill(source) {\n    return source && source.fill !== false;\n}\n\nfunction _resolveTarget(sources, index, propagate) {\n    const source = sources[index];\n    let fill = source.fill;\n    const visited = [\n        index\n    ];\n    let target;\n    if (!propagate) {\n        return fill;\n    }\n    while(fill !== false && visited.indexOf(fill) === -1){\n        if (!(0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.g)(fill)) {\n            return fill;\n        }\n        target = sources[fill];\n        if (!target) {\n            return false;\n        }\n        if (target.visible) {\n            return fill;\n        }\n        visited.push(fill);\n        fill = target.fill;\n    }\n    return false;\n}\n function _decodeFill(line, index, count) {\n     const fill = parseFillOption(line);\n    if ((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.i)(fill)) {\n        return isNaN(fill.value) ? false : fill;\n    }\n    let target = parseFloat(fill);\n    if ((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.g)(target) && Math.floor(target) === target) {\n        return decodeTargetIndex(fill[0], index, target, count);\n    }\n    return [\n        'origin',\n        'start',\n        'end',\n        'stack',\n        'shape'\n    ].indexOf(fill) >= 0 && fill;\n}\nfunction decodeTargetIndex(firstCh, index, target, count) {\n    if (firstCh === '-' || firstCh === '+') {\n        target = index + target;\n    }\n    if (target === index || target < 0 || target >= count) {\n        return false;\n    }\n    return target;\n}\n function _getTargetPixel(fill, scale) {\n    let pixel = null;\n    if (fill === 'start') {\n        pixel = scale.bottom;\n    } else if (fill === 'end') {\n        pixel = scale.top;\n    } else if ((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.i)(fill)) {\n        pixel = scale.getPixelForValue(fill.value);\n    } else if (scale.getBasePixel) {\n        pixel = scale.getBasePixel();\n    }\n    return pixel;\n}\n function _getTargetValue(fill, scale, startValue) {\n    let value;\n    if (fill === 'start') {\n        value = startValue;\n    } else if (fill === 'end') {\n        value = scale.options.reverse ? scale.min : scale.max;\n    } else if ((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.i)(fill)) {\n        value = fill.value;\n    } else {\n        value = scale.getBaseValue();\n    }\n    return value;\n}\n function parseFillOption(line) {\n    const options = line.options;\n    const fillOption = options.fill;\n    let fill = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.v)(fillOption && fillOption.target, fillOption);\n    if (fill === undefined) {\n        fill = !!options.backgroundColor;\n    }\n    if (fill === false || fill === null) {\n        return false;\n    }\n    if (fill === true) {\n        return 'origin';\n    }\n    return fill;\n}\n\nfunction _buildStackLine(source) {\n    const { scale , index , line  } = source;\n    const points = [];\n    const segments = line.segments;\n    const sourcePoints = line.points;\n    const linesBelow = getLinesBelow(scale, index);\n    linesBelow.push(_createBoundaryLine({\n        x: null,\n        y: scale.bottom\n    }, line));\n    for(let i = 0; i < segments.length; i++){\n        const segment = segments[i];\n        for(let j = segment.start; j <= segment.end; j++){\n            addPointsBelow(points, sourcePoints[j], linesBelow);\n        }\n    }\n    return new LineElement({\n        points,\n        options: {}\n    });\n}\n function getLinesBelow(scale, index) {\n    const below = [];\n    const metas = scale.getMatchingVisibleMetas('line');\n    for(let i = 0; i < metas.length; i++){\n        const meta = metas[i];\n        if (meta.index === index) {\n            break;\n        }\n        if (!meta.hidden) {\n            below.unshift(meta.dataset);\n        }\n    }\n    return below;\n}\n function addPointsBelow(points, sourcePoint, linesBelow) {\n    const postponed = [];\n    for(let j = 0; j < linesBelow.length; j++){\n        const line = linesBelow[j];\n        const { first , last , point  } = findPoint(line, sourcePoint, 'x');\n        if (!point || first && last) {\n            continue;\n        }\n        if (first) {\n            postponed.unshift(point);\n        } else {\n            points.push(point);\n            if (!last) {\n                break;\n            }\n        }\n    }\n    points.push(...postponed);\n}\n function findPoint(line, sourcePoint, property) {\n    const point = line.interpolate(sourcePoint, property);\n    if (!point) {\n        return {};\n    }\n    const pointValue = point[property];\n    const segments = line.segments;\n    const linePoints = line.points;\n    let first = false;\n    let last = false;\n    for(let i = 0; i < segments.length; i++){\n        const segment = segments[i];\n        const firstValue = linePoints[segment.start][property];\n        const lastValue = linePoints[segment.end][property];\n        if ((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.ak)(pointValue, firstValue, lastValue)) {\n            first = pointValue === firstValue;\n            last = pointValue === lastValue;\n            break;\n        }\n    }\n    return {\n        first,\n        last,\n        point\n    };\n}\n\nclass simpleArc {\n    constructor(opts){\n        this.x = opts.x;\n        this.y = opts.y;\n        this.radius = opts.radius;\n    }\n    pathSegment(ctx, bounds, opts) {\n        const { x , y , radius  } = this;\n        bounds = bounds || {\n            start: 0,\n            end: _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.T\n        };\n        ctx.arc(x, y, radius, bounds.end, bounds.start, true);\n        return !opts.bounds;\n    }\n    interpolate(point) {\n        const { x , y , radius  } = this;\n        const angle = point.angle;\n        return {\n            x: x + Math.cos(angle) * radius,\n            y: y + Math.sin(angle) * radius,\n            angle\n        };\n    }\n}\n\nfunction _getTarget(source) {\n    const { chart , fill , line  } = source;\n    if ((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.g)(fill)) {\n        return getLineByIndex(chart, fill);\n    }\n    if (fill === 'stack') {\n        return _buildStackLine(source);\n    }\n    if (fill === 'shape') {\n        return true;\n    }\n    const boundary = computeBoundary(source);\n    if (boundary instanceof simpleArc) {\n        return boundary;\n    }\n    return _createBoundaryLine(boundary, line);\n}\n function getLineByIndex(chart, index) {\n    const meta = chart.getDatasetMeta(index);\n    const visible = meta && chart.isDatasetVisible(index);\n    return visible ? meta.dataset : null;\n}\nfunction computeBoundary(source) {\n    const scale = source.scale || {};\n    if (scale.getPointPositionForValue) {\n        return computeCircularBoundary(source);\n    }\n    return computeLinearBoundary(source);\n}\nfunction computeLinearBoundary(source) {\n    const { scale ={} , fill  } = source;\n    const pixel = _getTargetPixel(fill, scale);\n    if ((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.g)(pixel)) {\n        const horizontal = scale.isHorizontal();\n        return {\n            x: horizontal ? pixel : null,\n            y: horizontal ? null : pixel\n        };\n    }\n    return null;\n}\nfunction computeCircularBoundary(source) {\n    const { scale , fill  } = source;\n    const options = scale.options;\n    const length = scale.getLabels().length;\n    const start = options.reverse ? scale.max : scale.min;\n    const value = _getTargetValue(fill, scale, start);\n    const target = [];\n    if (options.grid.circular) {\n        const center = scale.getPointPositionForValue(0, start);\n        return new simpleArc({\n            x: center.x,\n            y: center.y,\n            radius: scale.getDistanceFromCenterForValue(value)\n        });\n    }\n    for(let i = 0; i < length; ++i){\n        target.push(scale.getPointPositionForValue(i, value));\n    }\n    return target;\n}\n\nfunction _drawfill(ctx, source, area) {\n    const target = _getTarget(source);\n    const { chart , index , line , scale , axis  } = source;\n    const lineOpts = line.options;\n    const fillOption = lineOpts.fill;\n    const color = lineOpts.backgroundColor;\n    const { above =color , below =color  } = fillOption || {};\n    const meta = chart.getDatasetMeta(index);\n    const clip = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.ah)(chart, meta);\n    if (target && line.points.length) {\n        (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.Y)(ctx, area);\n        doFill(ctx, {\n            line,\n            target,\n            above,\n            below,\n            area,\n            scale,\n            axis,\n            clip\n        });\n        (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.$)(ctx);\n    }\n}\nfunction doFill(ctx, cfg) {\n    const { line , target , above , below , area , scale , clip  } = cfg;\n    const property = line._loop ? 'angle' : cfg.axis;\n    ctx.save();\n    if (property === 'x' && below !== above) {\n        clipVertical(ctx, target, area.top);\n        fill(ctx, {\n            line,\n            target,\n            color: above,\n            scale,\n            property,\n            clip\n        });\n        ctx.restore();\n        ctx.save();\n        clipVertical(ctx, target, area.bottom);\n    }\n    fill(ctx, {\n        line,\n        target,\n        color: below,\n        scale,\n        property,\n        clip\n    });\n    ctx.restore();\n}\nfunction clipVertical(ctx, target, clipY) {\n    const { segments , points  } = target;\n    let first = true;\n    let lineLoop = false;\n    ctx.beginPath();\n    for (const segment of segments){\n        const { start , end  } = segment;\n        const firstPoint = points[start];\n        const lastPoint = points[_findSegmentEnd(start, end, points)];\n        if (first) {\n            ctx.moveTo(firstPoint.x, firstPoint.y);\n            first = false;\n        } else {\n            ctx.lineTo(firstPoint.x, clipY);\n            ctx.lineTo(firstPoint.x, firstPoint.y);\n        }\n        lineLoop = !!target.pathSegment(ctx, segment, {\n            move: lineLoop\n        });\n        if (lineLoop) {\n            ctx.closePath();\n        } else {\n            ctx.lineTo(lastPoint.x, clipY);\n        }\n    }\n    ctx.lineTo(target.first().x, clipY);\n    ctx.closePath();\n    ctx.clip();\n}\nfunction fill(ctx, cfg) {\n    const { line , target , property , color , scale , clip  } = cfg;\n    const segments = _segments(line, target, property);\n    for (const { source: src , target: tgt , start , end  } of segments){\n        const { style: { backgroundColor =color  } = {}  } = src;\n        const notShape = target !== true;\n        ctx.save();\n        ctx.fillStyle = backgroundColor;\n        clipBounds(ctx, scale, clip, notShape && _getBounds(property, start, end));\n        ctx.beginPath();\n        const lineLoop = !!line.pathSegment(ctx, src);\n        let loop;\n        if (notShape) {\n            if (lineLoop) {\n                ctx.closePath();\n            } else {\n                interpolatedLineTo(ctx, target, end, property);\n            }\n            const targetLoop = !!target.pathSegment(ctx, tgt, {\n                move: lineLoop,\n                reverse: true\n            });\n            loop = lineLoop && targetLoop;\n            if (!loop) {\n                interpolatedLineTo(ctx, target, start, property);\n            }\n        }\n        ctx.closePath();\n        ctx.fill(loop ? 'evenodd' : 'nonzero');\n        ctx.restore();\n    }\n}\nfunction clipBounds(ctx, scale, clip, bounds) {\n    const chartArea = scale.chart.chartArea;\n    const { property , start , end  } = bounds || {};\n    if (property === 'x' || property === 'y') {\n        let left, top, right, bottom;\n        if (property === 'x') {\n            left = start;\n            top = chartArea.top;\n            right = end;\n            bottom = chartArea.bottom;\n        } else {\n            left = chartArea.left;\n            top = start;\n            right = chartArea.right;\n            bottom = end;\n        }\n        ctx.beginPath();\n        if (clip) {\n            left = Math.max(left, clip.left);\n            right = Math.min(right, clip.right);\n            top = Math.max(top, clip.top);\n            bottom = Math.min(bottom, clip.bottom);\n        }\n        ctx.rect(left, top, right - left, bottom - top);\n        ctx.clip();\n    }\n}\nfunction interpolatedLineTo(ctx, target, point, property) {\n    const interpolatedPoint = target.interpolate(point, property);\n    if (interpolatedPoint) {\n        ctx.lineTo(interpolatedPoint.x, interpolatedPoint.y);\n    }\n}\n\nvar index = {\n    id: 'filler',\n    afterDatasetsUpdate (chart, _args, options) {\n        const count = (chart.data.datasets || []).length;\n        const sources = [];\n        let meta, i, line, source;\n        for(i = 0; i < count; ++i){\n            meta = chart.getDatasetMeta(i);\n            line = meta.dataset;\n            source = null;\n            if (line && line.options && line instanceof LineElement) {\n                source = {\n                    visible: chart.isDatasetVisible(i),\n                    index: i,\n                    fill: _decodeFill(line, i, count),\n                    chart,\n                    axis: meta.controller.options.indexAxis,\n                    scale: meta.vScale,\n                    line\n                };\n            }\n            meta.$filler = source;\n            sources.push(source);\n        }\n        for(i = 0; i < count; ++i){\n            source = sources[i];\n            if (!source || source.fill === false) {\n                continue;\n            }\n            source.fill = _resolveTarget(sources, i, options.propagate);\n        }\n    },\n    beforeDraw (chart, _args, options) {\n        const draw = options.drawTime === 'beforeDraw';\n        const metasets = chart.getSortedVisibleDatasetMetas();\n        const area = chart.chartArea;\n        for(let i = metasets.length - 1; i >= 0; --i){\n            const source = metasets[i].$filler;\n            if (!source) {\n                continue;\n            }\n            source.line.updateControlPoints(area, source.axis);\n            if (draw && source.fill) {\n                _drawfill(chart.ctx, source, area);\n            }\n        }\n    },\n    beforeDatasetsDraw (chart, _args, options) {\n        if (options.drawTime !== 'beforeDatasetsDraw') {\n            return;\n        }\n        const metasets = chart.getSortedVisibleDatasetMetas();\n        for(let i = metasets.length - 1; i >= 0; --i){\n            const source = metasets[i].$filler;\n            if (_shouldApplyFill(source)) {\n                _drawfill(chart.ctx, source, chart.chartArea);\n            }\n        }\n    },\n    beforeDatasetDraw (chart, args, options) {\n        const source = args.meta.$filler;\n        if (!_shouldApplyFill(source) || options.drawTime !== 'beforeDatasetDraw') {\n            return;\n        }\n        _drawfill(chart.ctx, source, chart.chartArea);\n    },\n    defaults: {\n        propagate: true,\n        drawTime: 'beforeDatasetDraw'\n    }\n};\n\nconst getBoxSize = (labelOpts, fontSize)=>{\n    let { boxHeight =fontSize , boxWidth =fontSize  } = labelOpts;\n    if (labelOpts.usePointStyle) {\n        boxHeight = Math.min(boxHeight, fontSize);\n        boxWidth = labelOpts.pointStyleWidth || Math.min(boxWidth, fontSize);\n    }\n    return {\n        boxWidth,\n        boxHeight,\n        itemHeight: Math.max(fontSize, boxHeight)\n    };\n};\nconst itemsEqual = (a, b)=>a !== null && b !== null && a.datasetIndex === b.datasetIndex && a.index === b.index;\nclass Legend extends Element {\n constructor(config){\n        super();\n        this._added = false;\n        this.legendHitBoxes = [];\n this._hoveredItem = null;\n        this.doughnutMode = false;\n        this.chart = config.chart;\n        this.options = config.options;\n        this.ctx = config.ctx;\n        this.legendItems = undefined;\n        this.columnSizes = undefined;\n        this.lineWidths = undefined;\n        this.maxHeight = undefined;\n        this.maxWidth = undefined;\n        this.top = undefined;\n        this.bottom = undefined;\n        this.left = undefined;\n        this.right = undefined;\n        this.height = undefined;\n        this.width = undefined;\n        this._margins = undefined;\n        this.position = undefined;\n        this.weight = undefined;\n        this.fullSize = undefined;\n    }\n    update(maxWidth, maxHeight, margins) {\n        this.maxWidth = maxWidth;\n        this.maxHeight = maxHeight;\n        this._margins = margins;\n        this.setDimensions();\n        this.buildLabels();\n        this.fit();\n    }\n    setDimensions() {\n        if (this.isHorizontal()) {\n            this.width = this.maxWidth;\n            this.left = this._margins.left;\n            this.right = this.width;\n        } else {\n            this.height = this.maxHeight;\n            this.top = this._margins.top;\n            this.bottom = this.height;\n        }\n    }\n    buildLabels() {\n        const labelOpts = this.options.labels || {};\n        let legendItems = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.Q)(labelOpts.generateLabels, [\n            this.chart\n        ], this) || [];\n        if (labelOpts.filter) {\n            legendItems = legendItems.filter((item)=>labelOpts.filter(item, this.chart.data));\n        }\n        if (labelOpts.sort) {\n            legendItems = legendItems.sort((a, b)=>labelOpts.sort(a, b, this.chart.data));\n        }\n        if (this.options.reverse) {\n            legendItems.reverse();\n        }\n        this.legendItems = legendItems;\n    }\n    fit() {\n        const { options , ctx  } = this;\n        if (!options.display) {\n            this.width = this.height = 0;\n            return;\n        }\n        const labelOpts = options.labels;\n        const labelFont = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a0)(labelOpts.font);\n        const fontSize = labelFont.size;\n        const titleHeight = this._computeTitleHeight();\n        const { boxWidth , itemHeight  } = getBoxSize(labelOpts, fontSize);\n        let width, height;\n        ctx.font = labelFont.string;\n        if (this.isHorizontal()) {\n            width = this.maxWidth;\n            height = this._fitRows(titleHeight, fontSize, boxWidth, itemHeight) + 10;\n        } else {\n            height = this.maxHeight;\n            width = this._fitCols(titleHeight, labelFont, boxWidth, itemHeight) + 10;\n        }\n        this.width = Math.min(width, options.maxWidth || this.maxWidth);\n        this.height = Math.min(height, options.maxHeight || this.maxHeight);\n    }\n _fitRows(titleHeight, fontSize, boxWidth, itemHeight) {\n        const { ctx , maxWidth , options: { labels: { padding  }  }  } = this;\n        const hitboxes = this.legendHitBoxes = [];\n        const lineWidths = this.lineWidths = [\n            0\n        ];\n        const lineHeight = itemHeight + padding;\n        let totalHeight = titleHeight;\n        ctx.textAlign = 'left';\n        ctx.textBaseline = 'middle';\n        let row = -1;\n        let top = -lineHeight;\n        this.legendItems.forEach((legendItem, i)=>{\n            const itemWidth = boxWidth + fontSize / 2 + ctx.measureText(legendItem.text).width;\n            if (i === 0 || lineWidths[lineWidths.length - 1] + itemWidth + 2 * padding > maxWidth) {\n                totalHeight += lineHeight;\n                lineWidths[lineWidths.length - (i > 0 ? 0 : 1)] = 0;\n                top += lineHeight;\n                row++;\n            }\n            hitboxes[i] = {\n                left: 0,\n                top,\n                row,\n                width: itemWidth,\n                height: itemHeight\n            };\n            lineWidths[lineWidths.length - 1] += itemWidth + padding;\n        });\n        return totalHeight;\n    }\n    _fitCols(titleHeight, labelFont, boxWidth, _itemHeight) {\n        const { ctx , maxHeight , options: { labels: { padding  }  }  } = this;\n        const hitboxes = this.legendHitBoxes = [];\n        const columnSizes = this.columnSizes = [];\n        const heightLimit = maxHeight - titleHeight;\n        let totalWidth = padding;\n        let currentColWidth = 0;\n        let currentColHeight = 0;\n        let left = 0;\n        let col = 0;\n        this.legendItems.forEach((legendItem, i)=>{\n            const { itemWidth , itemHeight  } = calculateItemSize(boxWidth, labelFont, ctx, legendItem, _itemHeight);\n            if (i > 0 && currentColHeight + itemHeight + 2 * padding > heightLimit) {\n                totalWidth += currentColWidth + padding;\n                columnSizes.push({\n                    width: currentColWidth,\n                    height: currentColHeight\n                });\n                left += currentColWidth + padding;\n                col++;\n                currentColWidth = currentColHeight = 0;\n            }\n            hitboxes[i] = {\n                left,\n                top: currentColHeight,\n                col,\n                width: itemWidth,\n                height: itemHeight\n            };\n            currentColWidth = Math.max(currentColWidth, itemWidth);\n            currentColHeight += itemHeight + padding;\n        });\n        totalWidth += currentColWidth;\n        columnSizes.push({\n            width: currentColWidth,\n            height: currentColHeight\n        });\n        return totalWidth;\n    }\n    adjustHitBoxes() {\n        if (!this.options.display) {\n            return;\n        }\n        const titleHeight = this._computeTitleHeight();\n        const { legendHitBoxes: hitboxes , options: { align , labels: { padding  } , rtl  }  } = this;\n        const rtlHelper = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.aA)(rtl, this.left, this.width);\n        if (this.isHorizontal()) {\n            let row = 0;\n            let left = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a2)(align, this.left + padding, this.right - this.lineWidths[row]);\n            for (const hitbox of hitboxes){\n                if (row !== hitbox.row) {\n                    row = hitbox.row;\n                    left = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a2)(align, this.left + padding, this.right - this.lineWidths[row]);\n                }\n                hitbox.top += this.top + titleHeight + padding;\n                hitbox.left = rtlHelper.leftForLtr(rtlHelper.x(left), hitbox.width);\n                left += hitbox.width + padding;\n            }\n        } else {\n            let col = 0;\n            let top = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a2)(align, this.top + titleHeight + padding, this.bottom - this.columnSizes[col].height);\n            for (const hitbox of hitboxes){\n                if (hitbox.col !== col) {\n                    col = hitbox.col;\n                    top = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a2)(align, this.top + titleHeight + padding, this.bottom - this.columnSizes[col].height);\n                }\n                hitbox.top = top;\n                hitbox.left += this.left + padding;\n                hitbox.left = rtlHelper.leftForLtr(rtlHelper.x(hitbox.left), hitbox.width);\n                top += hitbox.height + padding;\n            }\n        }\n    }\n    isHorizontal() {\n        return this.options.position === 'top' || this.options.position === 'bottom';\n    }\n    draw() {\n        if (this.options.display) {\n            const ctx = this.ctx;\n            (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.Y)(ctx, this);\n            this._draw();\n            (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.$)(ctx);\n        }\n    }\n _draw() {\n        const { options: opts , columnSizes , lineWidths , ctx  } = this;\n        const { align , labels: labelOpts  } = opts;\n        const defaultColor = _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.d.color;\n        const rtlHelper = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.aA)(opts.rtl, this.left, this.width);\n        const labelFont = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a0)(labelOpts.font);\n        const { padding  } = labelOpts;\n        const fontSize = labelFont.size;\n        const halfFontSize = fontSize / 2;\n        let cursor;\n        this.drawTitle();\n        ctx.textAlign = rtlHelper.textAlign('left');\n        ctx.textBaseline = 'middle';\n        ctx.lineWidth = 0.5;\n        ctx.font = labelFont.string;\n        const { boxWidth , boxHeight , itemHeight  } = getBoxSize(labelOpts, fontSize);\n        const drawLegendBox = function(x, y, legendItem) {\n            if (isNaN(boxWidth) || boxWidth <= 0 || isNaN(boxHeight) || boxHeight < 0) {\n                return;\n            }\n            ctx.save();\n            const lineWidth = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.v)(legendItem.lineWidth, 1);\n            ctx.fillStyle = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.v)(legendItem.fillStyle, defaultColor);\n            ctx.lineCap = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.v)(legendItem.lineCap, 'butt');\n            ctx.lineDashOffset = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.v)(legendItem.lineDashOffset, 0);\n            ctx.lineJoin = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.v)(legendItem.lineJoin, 'miter');\n            ctx.lineWidth = lineWidth;\n            ctx.strokeStyle = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.v)(legendItem.strokeStyle, defaultColor);\n            ctx.setLineDash((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.v)(legendItem.lineDash, []));\n            if (labelOpts.usePointStyle) {\n                const drawOptions = {\n                    radius: boxHeight * Math.SQRT2 / 2,\n                    pointStyle: legendItem.pointStyle,\n                    rotation: legendItem.rotation,\n                    borderWidth: lineWidth\n                };\n                const centerX = rtlHelper.xPlus(x, boxWidth / 2);\n                const centerY = y + halfFontSize;\n                (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.aE)(ctx, drawOptions, centerX, centerY, labelOpts.pointStyleWidth && boxWidth);\n            } else {\n                const yBoxTop = y + Math.max((fontSize - boxHeight) / 2, 0);\n                const xBoxLeft = rtlHelper.leftForLtr(x, boxWidth);\n                const borderRadius = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.ax)(legendItem.borderRadius);\n                ctx.beginPath();\n                if (Object.values(borderRadius).some((v)=>v !== 0)) {\n                    (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.av)(ctx, {\n                        x: xBoxLeft,\n                        y: yBoxTop,\n                        w: boxWidth,\n                        h: boxHeight,\n                        radius: borderRadius\n                    });\n                } else {\n                    ctx.rect(xBoxLeft, yBoxTop, boxWidth, boxHeight);\n                }\n                ctx.fill();\n                if (lineWidth !== 0) {\n                    ctx.stroke();\n                }\n            }\n            ctx.restore();\n        };\n        const fillText = function(x, y, legendItem) {\n            (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.Z)(ctx, legendItem.text, x, y + itemHeight / 2, labelFont, {\n                strikethrough: legendItem.hidden,\n                textAlign: rtlHelper.textAlign(legendItem.textAlign)\n            });\n        };\n        const isHorizontal = this.isHorizontal();\n        const titleHeight = this._computeTitleHeight();\n        if (isHorizontal) {\n            cursor = {\n                x: (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a2)(align, this.left + padding, this.right - lineWidths[0]),\n                y: this.top + padding + titleHeight,\n                line: 0\n            };\n        } else {\n            cursor = {\n                x: this.left + padding,\n                y: (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a2)(align, this.top + titleHeight + padding, this.bottom - columnSizes[0].height),\n                line: 0\n            };\n        }\n        (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.aB)(this.ctx, opts.textDirection);\n        const lineHeight = itemHeight + padding;\n        this.legendItems.forEach((legendItem, i)=>{\n            ctx.strokeStyle = legendItem.fontColor;\n            ctx.fillStyle = legendItem.fontColor;\n            const textWidth = ctx.measureText(legendItem.text).width;\n            const textAlign = rtlHelper.textAlign(legendItem.textAlign || (legendItem.textAlign = labelOpts.textAlign));\n            const width = boxWidth + halfFontSize + textWidth;\n            let x = cursor.x;\n            let y = cursor.y;\n            rtlHelper.setWidth(this.width);\n            if (isHorizontal) {\n                if (i > 0 && x + width + padding > this.right) {\n                    y = cursor.y += lineHeight;\n                    cursor.line++;\n                    x = cursor.x = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a2)(align, this.left + padding, this.right - lineWidths[cursor.line]);\n                }\n            } else if (i > 0 && y + lineHeight > this.bottom) {\n                x = cursor.x = x + columnSizes[cursor.line].width + padding;\n                cursor.line++;\n                y = cursor.y = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a2)(align, this.top + titleHeight + padding, this.bottom - columnSizes[cursor.line].height);\n            }\n            const realX = rtlHelper.x(x);\n            drawLegendBox(realX, y, legendItem);\n            x = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.aC)(textAlign, x + boxWidth + halfFontSize, isHorizontal ? x + width : this.right, opts.rtl);\n            fillText(rtlHelper.x(x), y, legendItem);\n            if (isHorizontal) {\n                cursor.x += width + padding;\n            } else if (typeof legendItem.text !== 'string') {\n                const fontLineHeight = labelFont.lineHeight;\n                cursor.y += calculateLegendItemHeight(legendItem, fontLineHeight) + padding;\n            } else {\n                cursor.y += lineHeight;\n            }\n        });\n        (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.aD)(this.ctx, opts.textDirection);\n    }\n drawTitle() {\n        const opts = this.options;\n        const titleOpts = opts.title;\n        const titleFont = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a0)(titleOpts.font);\n        const titlePadding = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.E)(titleOpts.padding);\n        if (!titleOpts.display) {\n            return;\n        }\n        const rtlHelper = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.aA)(opts.rtl, this.left, this.width);\n        const ctx = this.ctx;\n        const position = titleOpts.position;\n        const halfFontSize = titleFont.size / 2;\n        const topPaddingPlusHalfFontSize = titlePadding.top + halfFontSize;\n        let y;\n        let left = this.left;\n        let maxWidth = this.width;\n        if (this.isHorizontal()) {\n            maxWidth = Math.max(...this.lineWidths);\n            y = this.top + topPaddingPlusHalfFontSize;\n            left = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a2)(opts.align, left, this.right - maxWidth);\n        } else {\n            const maxHeight = this.columnSizes.reduce((acc, size)=>Math.max(acc, size.height), 0);\n            y = topPaddingPlusHalfFontSize + (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a2)(opts.align, this.top, this.bottom - maxHeight - opts.labels.padding - this._computeTitleHeight());\n        }\n        const x = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a2)(position, left, left + maxWidth);\n        ctx.textAlign = rtlHelper.textAlign((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a1)(position));\n        ctx.textBaseline = 'middle';\n        ctx.strokeStyle = titleOpts.color;\n        ctx.fillStyle = titleOpts.color;\n        ctx.font = titleFont.string;\n        (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.Z)(ctx, titleOpts.text, x, y, titleFont);\n    }\n _computeTitleHeight() {\n        const titleOpts = this.options.title;\n        const titleFont = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a0)(titleOpts.font);\n        const titlePadding = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.E)(titleOpts.padding);\n        return titleOpts.display ? titleFont.lineHeight + titlePadding.height : 0;\n    }\n _getLegendItemAt(x, y) {\n        let i, hitBox, lh;\n        if ((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.ak)(x, this.left, this.right) && (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.ak)(y, this.top, this.bottom)) {\n            lh = this.legendHitBoxes;\n            for(i = 0; i < lh.length; ++i){\n                hitBox = lh[i];\n                if ((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.ak)(x, hitBox.left, hitBox.left + hitBox.width) && (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.ak)(y, hitBox.top, hitBox.top + hitBox.height)) {\n                    return this.legendItems[i];\n                }\n            }\n        }\n        return null;\n    }\n handleEvent(e) {\n        const opts = this.options;\n        if (!isListened(e.type, opts)) {\n            return;\n        }\n        const hoveredItem = this._getLegendItemAt(e.x, e.y);\n        if (e.type === 'mousemove' || e.type === 'mouseout') {\n            const previous = this._hoveredItem;\n            const sameItem = itemsEqual(previous, hoveredItem);\n            if (previous && !sameItem) {\n                (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.Q)(opts.onLeave, [\n                    e,\n                    previous,\n                    this\n                ], this);\n            }\n            this._hoveredItem = hoveredItem;\n            if (hoveredItem && !sameItem) {\n                (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.Q)(opts.onHover, [\n                    e,\n                    hoveredItem,\n                    this\n                ], this);\n            }\n        } else if (hoveredItem) {\n            (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.Q)(opts.onClick, [\n                e,\n                hoveredItem,\n                this\n            ], this);\n        }\n    }\n}\nfunction calculateItemSize(boxWidth, labelFont, ctx, legendItem, _itemHeight) {\n    const itemWidth = calculateItemWidth(legendItem, boxWidth, labelFont, ctx);\n    const itemHeight = calculateItemHeight(_itemHeight, legendItem, labelFont.lineHeight);\n    return {\n        itemWidth,\n        itemHeight\n    };\n}\nfunction calculateItemWidth(legendItem, boxWidth, labelFont, ctx) {\n    let legendItemText = legendItem.text;\n    if (legendItemText && typeof legendItemText !== 'string') {\n        legendItemText = legendItemText.reduce((a, b)=>a.length > b.length ? a : b);\n    }\n    return boxWidth + labelFont.size / 2 + ctx.measureText(legendItemText).width;\n}\nfunction calculateItemHeight(_itemHeight, legendItem, fontLineHeight) {\n    let itemHeight = _itemHeight;\n    if (typeof legendItem.text !== 'string') {\n        itemHeight = calculateLegendItemHeight(legendItem, fontLineHeight);\n    }\n    return itemHeight;\n}\nfunction calculateLegendItemHeight(legendItem, fontLineHeight) {\n    const labelHeight = legendItem.text ? legendItem.text.length : 0;\n    return fontLineHeight * labelHeight;\n}\nfunction isListened(type, opts) {\n    if ((type === 'mousemove' || type === 'mouseout') && (opts.onHover || opts.onLeave)) {\n        return true;\n    }\n    if (opts.onClick && (type === 'click' || type === 'mouseup')) {\n        return true;\n    }\n    return false;\n}\nvar plugin_legend = {\n    id: 'legend',\n _element: Legend,\n    start (chart, _args, options) {\n        const legend = chart.legend = new Legend({\n            ctx: chart.ctx,\n            options,\n            chart\n        });\n        layouts.configure(chart, legend, options);\n        layouts.addBox(chart, legend);\n    },\n    stop (chart) {\n        layouts.removeBox(chart, chart.legend);\n        delete chart.legend;\n    },\n    beforeUpdate (chart, _args, options) {\n        const legend = chart.legend;\n        layouts.configure(chart, legend, options);\n        legend.options = options;\n    },\n    afterUpdate (chart) {\n        const legend = chart.legend;\n        legend.buildLabels();\n        legend.adjustHitBoxes();\n    },\n    afterEvent (chart, args) {\n        if (!args.replay) {\n            chart.legend.handleEvent(args.event);\n        }\n    },\n    defaults: {\n        display: true,\n        position: 'top',\n        align: 'center',\n        fullSize: true,\n        reverse: false,\n        weight: 1000,\n        onClick (e, legendItem, legend) {\n            const index = legendItem.datasetIndex;\n            const ci = legend.chart;\n            if (ci.isDatasetVisible(index)) {\n                ci.hide(index);\n                legendItem.hidden = true;\n            } else {\n                ci.show(index);\n                legendItem.hidden = false;\n            }\n        },\n        onHover: null,\n        onLeave: null,\n        labels: {\n            color: (ctx)=>ctx.chart.options.color,\n            boxWidth: 40,\n            padding: 10,\n            generateLabels (chart) {\n                const datasets = chart.data.datasets;\n                const { labels: { usePointStyle , pointStyle , textAlign , color , useBorderRadius , borderRadius  }  } = chart.legend.options;\n                return chart._getSortedDatasetMetas().map((meta)=>{\n                    const style = meta.controller.getStyle(usePointStyle ? 0 : undefined);\n                    const borderWidth = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.E)(style.borderWidth);\n                    return {\n                        text: datasets[meta.index].label,\n                        fillStyle: style.backgroundColor,\n                        fontColor: color,\n                        hidden: !meta.visible,\n                        lineCap: style.borderCapStyle,\n                        lineDash: style.borderDash,\n                        lineDashOffset: style.borderDashOffset,\n                        lineJoin: style.borderJoinStyle,\n                        lineWidth: (borderWidth.width + borderWidth.height) / 4,\n                        strokeStyle: style.borderColor,\n                        pointStyle: pointStyle || style.pointStyle,\n                        rotation: style.rotation,\n                        textAlign: textAlign || style.textAlign,\n                        borderRadius: useBorderRadius && (borderRadius || style.borderRadius),\n                        datasetIndex: meta.index\n                    };\n                }, this);\n            }\n        },\n        title: {\n            color: (ctx)=>ctx.chart.options.color,\n            display: false,\n            position: 'center',\n            text: ''\n        }\n    },\n    descriptors: {\n        _scriptable: (name)=>!name.startsWith('on'),\n        labels: {\n            _scriptable: (name)=>![\n                    'generateLabels',\n                    'filter',\n                    'sort'\n                ].includes(name)\n        }\n    }\n};\n\nclass Title extends Element {\n constructor(config){\n        super();\n        this.chart = config.chart;\n        this.options = config.options;\n        this.ctx = config.ctx;\n        this._padding = undefined;\n        this.top = undefined;\n        this.bottom = undefined;\n        this.left = undefined;\n        this.right = undefined;\n        this.width = undefined;\n        this.height = undefined;\n        this.position = undefined;\n        this.weight = undefined;\n        this.fullSize = undefined;\n    }\n    update(maxWidth, maxHeight) {\n        const opts = this.options;\n        this.left = 0;\n        this.top = 0;\n        if (!opts.display) {\n            this.width = this.height = this.right = this.bottom = 0;\n            return;\n        }\n        this.width = this.right = maxWidth;\n        this.height = this.bottom = maxHeight;\n        const lineCount = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.b)(opts.text) ? opts.text.length : 1;\n        this._padding = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.E)(opts.padding);\n        const textSize = lineCount * (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a0)(opts.font).lineHeight + this._padding.height;\n        if (this.isHorizontal()) {\n            this.height = textSize;\n        } else {\n            this.width = textSize;\n        }\n    }\n    isHorizontal() {\n        const pos = this.options.position;\n        return pos === 'top' || pos === 'bottom';\n    }\n    _drawArgs(offset) {\n        const { top , left , bottom , right , options  } = this;\n        const align = options.align;\n        let rotation = 0;\n        let maxWidth, titleX, titleY;\n        if (this.isHorizontal()) {\n            titleX = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a2)(align, left, right);\n            titleY = top + offset;\n            maxWidth = right - left;\n        } else {\n            if (options.position === 'left') {\n                titleX = left + offset;\n                titleY = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a2)(align, bottom, top);\n                rotation = _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.P * -0.5;\n            } else {\n                titleX = right - offset;\n                titleY = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a2)(align, top, bottom);\n                rotation = _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.P * 0.5;\n            }\n            maxWidth = bottom - top;\n        }\n        return {\n            titleX,\n            titleY,\n            maxWidth,\n            rotation\n        };\n    }\n    draw() {\n        const ctx = this.ctx;\n        const opts = this.options;\n        if (!opts.display) {\n            return;\n        }\n        const fontOpts = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a0)(opts.font);\n        const lineHeight = fontOpts.lineHeight;\n        const offset = lineHeight / 2 + this._padding.top;\n        const { titleX , titleY , maxWidth , rotation  } = this._drawArgs(offset);\n        (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.Z)(ctx, opts.text, 0, 0, fontOpts, {\n            color: opts.color,\n            maxWidth,\n            rotation,\n            textAlign: (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a1)(opts.align),\n            textBaseline: 'middle',\n            translation: [\n                titleX,\n                titleY\n            ]\n        });\n    }\n}\nfunction createTitle(chart, titleOpts) {\n    const title = new Title({\n        ctx: chart.ctx,\n        options: titleOpts,\n        chart\n    });\n    layouts.configure(chart, title, titleOpts);\n    layouts.addBox(chart, title);\n    chart.titleBlock = title;\n}\nvar plugin_title = {\n    id: 'title',\n _element: Title,\n    start (chart, _args, options) {\n        createTitle(chart, options);\n    },\n    stop (chart) {\n        const titleBlock = chart.titleBlock;\n        layouts.removeBox(chart, titleBlock);\n        delete chart.titleBlock;\n    },\n    beforeUpdate (chart, _args, options) {\n        const title = chart.titleBlock;\n        layouts.configure(chart, title, options);\n        title.options = options;\n    },\n    defaults: {\n        align: 'center',\n        display: false,\n        font: {\n            weight: 'bold'\n        },\n        fullSize: true,\n        padding: 10,\n        position: 'top',\n        text: '',\n        weight: 2000\n    },\n    defaultRoutes: {\n        color: 'color'\n    },\n    descriptors: {\n        _scriptable: true,\n        _indexable: false\n    }\n};\n\nconst map = new WeakMap();\nvar plugin_subtitle = {\n    id: 'subtitle',\n    start (chart, _args, options) {\n        const title = new Title({\n            ctx: chart.ctx,\n            options,\n            chart\n        });\n        layouts.configure(chart, title, options);\n        layouts.addBox(chart, title);\n        map.set(chart, title);\n    },\n    stop (chart) {\n        layouts.removeBox(chart, map.get(chart));\n        map.delete(chart);\n    },\n    beforeUpdate (chart, _args, options) {\n        const title = map.get(chart);\n        layouts.configure(chart, title, options);\n        title.options = options;\n    },\n    defaults: {\n        align: 'center',\n        display: false,\n        font: {\n            weight: 'normal'\n        },\n        fullSize: true,\n        padding: 0,\n        position: 'top',\n        text: '',\n        weight: 1500\n    },\n    defaultRoutes: {\n        color: 'color'\n    },\n    descriptors: {\n        _scriptable: true,\n        _indexable: false\n    }\n};\n\nconst positioners = {\n average (items) {\n        if (!items.length) {\n            return false;\n        }\n        let i, len;\n        let xSet = new Set();\n        let y = 0;\n        let count = 0;\n        for(i = 0, len = items.length; i < len; ++i){\n            const el = items[i].element;\n            if (el && el.hasValue()) {\n                const pos = el.tooltipPosition();\n                xSet.add(pos.x);\n                y += pos.y;\n                ++count;\n            }\n        }\n        if (count === 0 || xSet.size === 0) {\n            return false;\n        }\n        const xAverage = [\n            ...xSet\n        ].reduce((a, b)=>a + b) / xSet.size;\n        return {\n            x: xAverage,\n            y: y / count\n        };\n    },\n nearest (items, eventPosition) {\n        if (!items.length) {\n            return false;\n        }\n        let x = eventPosition.x;\n        let y = eventPosition.y;\n        let minDistance = Number.POSITIVE_INFINITY;\n        let i, len, nearestElement;\n        for(i = 0, len = items.length; i < len; ++i){\n            const el = items[i].element;\n            if (el && el.hasValue()) {\n                const center = el.getCenterPoint();\n                const d = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.aF)(eventPosition, center);\n                if (d < minDistance) {\n                    minDistance = d;\n                    nearestElement = el;\n                }\n            }\n        }\n        if (nearestElement) {\n            const tp = nearestElement.tooltipPosition();\n            x = tp.x;\n            y = tp.y;\n        }\n        return {\n            x,\n            y\n        };\n    }\n};\nfunction pushOrConcat(base, toPush) {\n    if (toPush) {\n        if ((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.b)(toPush)) {\n            Array.prototype.push.apply(base, toPush);\n        } else {\n            base.push(toPush);\n        }\n    }\n    return base;\n}\n function splitNewlines(str) {\n    if ((typeof str === 'string' || str instanceof String) && str.indexOf('\\n') > -1) {\n        return str.split('\\n');\n    }\n    return str;\n}\n function createTooltipItem(chart, item) {\n    const { element , datasetIndex , index  } = item;\n    const controller = chart.getDatasetMeta(datasetIndex).controller;\n    const { label , value  } = controller.getLabelAndValue(index);\n    return {\n        chart,\n        label,\n        parsed: controller.getParsed(index),\n        raw: chart.data.datasets[datasetIndex].data[index],\n        formattedValue: value,\n        dataset: controller.getDataset(),\n        dataIndex: index,\n        datasetIndex,\n        element\n    };\n}\n function getTooltipSize(tooltip, options) {\n    const ctx = tooltip.chart.ctx;\n    const { body , footer , title  } = tooltip;\n    const { boxWidth , boxHeight  } = options;\n    const bodyFont = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a0)(options.bodyFont);\n    const titleFont = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a0)(options.titleFont);\n    const footerFont = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a0)(options.footerFont);\n    const titleLineCount = title.length;\n    const footerLineCount = footer.length;\n    const bodyLineItemCount = body.length;\n    const padding = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.E)(options.padding);\n    let height = padding.height;\n    let width = 0;\n    let combinedBodyLength = body.reduce((count, bodyItem)=>count + bodyItem.before.length + bodyItem.lines.length + bodyItem.after.length, 0);\n    combinedBodyLength += tooltip.beforeBody.length + tooltip.afterBody.length;\n    if (titleLineCount) {\n        height += titleLineCount * titleFont.lineHeight + (titleLineCount - 1) * options.titleSpacing + options.titleMarginBottom;\n    }\n    if (combinedBodyLength) {\n        const bodyLineHeight = options.displayColors ? Math.max(boxHeight, bodyFont.lineHeight) : bodyFont.lineHeight;\n        height += bodyLineItemCount * bodyLineHeight + (combinedBodyLength - bodyLineItemCount) * bodyFont.lineHeight + (combinedBodyLength - 1) * options.bodySpacing;\n    }\n    if (footerLineCount) {\n        height += options.footerMarginTop + footerLineCount * footerFont.lineHeight + (footerLineCount - 1) * options.footerSpacing;\n    }\n    let widthPadding = 0;\n    const maxLineWidth = function(line) {\n        width = Math.max(width, ctx.measureText(line).width + widthPadding);\n    };\n    ctx.save();\n    ctx.font = titleFont.string;\n    (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.F)(tooltip.title, maxLineWidth);\n    ctx.font = bodyFont.string;\n    (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.F)(tooltip.beforeBody.concat(tooltip.afterBody), maxLineWidth);\n    widthPadding = options.displayColors ? boxWidth + 2 + options.boxPadding : 0;\n    (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.F)(body, (bodyItem)=>{\n        (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.F)(bodyItem.before, maxLineWidth);\n        (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.F)(bodyItem.lines, maxLineWidth);\n        (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.F)(bodyItem.after, maxLineWidth);\n    });\n    widthPadding = 0;\n    ctx.font = footerFont.string;\n    (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.F)(tooltip.footer, maxLineWidth);\n    ctx.restore();\n    width += padding.width;\n    return {\n        width,\n        height\n    };\n}\nfunction determineYAlign(chart, size) {\n    const { y , height  } = size;\n    if (y < height / 2) {\n        return 'top';\n    } else if (y > chart.height - height / 2) {\n        return 'bottom';\n    }\n    return 'center';\n}\nfunction doesNotFitWithAlign(xAlign, chart, options, size) {\n    const { x , width  } = size;\n    const caret = options.caretSize + options.caretPadding;\n    if (xAlign === 'left' && x + width + caret > chart.width) {\n        return true;\n    }\n    if (xAlign === 'right' && x - width - caret < 0) {\n        return true;\n    }\n}\nfunction determineXAlign(chart, options, size, yAlign) {\n    const { x , width  } = size;\n    const { width: chartWidth , chartArea: { left , right  }  } = chart;\n    let xAlign = 'center';\n    if (yAlign === 'center') {\n        xAlign = x <= (left + right) / 2 ? 'left' : 'right';\n    } else if (x <= width / 2) {\n        xAlign = 'left';\n    } else if (x >= chartWidth - width / 2) {\n        xAlign = 'right';\n    }\n    if (doesNotFitWithAlign(xAlign, chart, options, size)) {\n        xAlign = 'center';\n    }\n    return xAlign;\n}\n function determineAlignment(chart, options, size) {\n    const yAlign = size.yAlign || options.yAlign || determineYAlign(chart, size);\n    return {\n        xAlign: size.xAlign || options.xAlign || determineXAlign(chart, options, size, yAlign),\n        yAlign\n    };\n}\nfunction alignX(size, xAlign) {\n    let { x , width  } = size;\n    if (xAlign === 'right') {\n        x -= width;\n    } else if (xAlign === 'center') {\n        x -= width / 2;\n    }\n    return x;\n}\nfunction alignY(size, yAlign, paddingAndSize) {\n    let { y , height  } = size;\n    if (yAlign === 'top') {\n        y += paddingAndSize;\n    } else if (yAlign === 'bottom') {\n        y -= height + paddingAndSize;\n    } else {\n        y -= height / 2;\n    }\n    return y;\n}\n function getBackgroundPoint(options, size, alignment, chart) {\n    const { caretSize , caretPadding , cornerRadius  } = options;\n    const { xAlign , yAlign  } = alignment;\n    const paddingAndSize = caretSize + caretPadding;\n    const { topLeft , topRight , bottomLeft , bottomRight  } = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.ax)(cornerRadius);\n    let x = alignX(size, xAlign);\n    const y = alignY(size, yAlign, paddingAndSize);\n    if (yAlign === 'center') {\n        if (xAlign === 'left') {\n            x += paddingAndSize;\n        } else if (xAlign === 'right') {\n            x -= paddingAndSize;\n        }\n    } else if (xAlign === 'left') {\n        x -= Math.max(topLeft, bottomLeft) + caretSize;\n    } else if (xAlign === 'right') {\n        x += Math.max(topRight, bottomRight) + caretSize;\n    }\n    return {\n        x: (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.S)(x, 0, chart.width - size.width),\n        y: (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.S)(y, 0, chart.height - size.height)\n    };\n}\nfunction getAlignedX(tooltip, align, options) {\n    const padding = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.E)(options.padding);\n    return align === 'center' ? tooltip.x + tooltip.width / 2 : align === 'right' ? tooltip.x + tooltip.width - padding.right : tooltip.x + padding.left;\n}\n function getBeforeAfterBodyLines(callback) {\n    return pushOrConcat([], splitNewlines(callback));\n}\nfunction createTooltipContext(parent, tooltip, tooltipItems) {\n    return (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.j)(parent, {\n        tooltip,\n        tooltipItems,\n        type: 'tooltip'\n    });\n}\nfunction overrideCallbacks(callbacks, context) {\n    const override = context && context.dataset && context.dataset.tooltip && context.dataset.tooltip.callbacks;\n    return override ? callbacks.override(override) : callbacks;\n}\nconst defaultCallbacks = {\n    beforeTitle: _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.aG,\n    title (tooltipItems) {\n        if (tooltipItems.length > 0) {\n            const item = tooltipItems[0];\n            const labels = item.chart.data.labels;\n            const labelCount = labels ? labels.length : 0;\n            if (this && this.options && this.options.mode === 'dataset') {\n                return item.dataset.label || '';\n            } else if (item.label) {\n                return item.label;\n            } else if (labelCount > 0 && item.dataIndex < labelCount) {\n                return labels[item.dataIndex];\n            }\n        }\n        return '';\n    },\n    afterTitle: _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.aG,\n    beforeBody: _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.aG,\n    beforeLabel: _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.aG,\n    label (tooltipItem) {\n        if (this && this.options && this.options.mode === 'dataset') {\n            return tooltipItem.label + ': ' + tooltipItem.formattedValue || tooltipItem.formattedValue;\n        }\n        let label = tooltipItem.dataset.label || '';\n        if (label) {\n            label += ': ';\n        }\n        const value = tooltipItem.formattedValue;\n        if (!(0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.k)(value)) {\n            label += value;\n        }\n        return label;\n    },\n    labelColor (tooltipItem) {\n        const meta = tooltipItem.chart.getDatasetMeta(tooltipItem.datasetIndex);\n        const options = meta.controller.getStyle(tooltipItem.dataIndex);\n        return {\n            borderColor: options.borderColor,\n            backgroundColor: options.backgroundColor,\n            borderWidth: options.borderWidth,\n            borderDash: options.borderDash,\n            borderDashOffset: options.borderDashOffset,\n            borderRadius: 0\n        };\n    },\n    labelTextColor () {\n        return this.options.bodyColor;\n    },\n    labelPointStyle (tooltipItem) {\n        const meta = tooltipItem.chart.getDatasetMeta(tooltipItem.datasetIndex);\n        const options = meta.controller.getStyle(tooltipItem.dataIndex);\n        return {\n            pointStyle: options.pointStyle,\n            rotation: options.rotation\n        };\n    },\n    afterLabel: _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.aG,\n    afterBody: _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.aG,\n    beforeFooter: _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.aG,\n    footer: _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.aG,\n    afterFooter: _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.aG\n};\n function invokeCallbackWithFallback(callbacks, name, ctx, arg) {\n    const result = callbacks[name].call(ctx, arg);\n    if (typeof result === 'undefined') {\n        return defaultCallbacks[name].call(ctx, arg);\n    }\n    return result;\n}\nclass Tooltip extends Element {\n static positioners = positioners;\n    constructor(config){\n        super();\n        this.opacity = 0;\n        this._active = [];\n        this._eventPosition = undefined;\n        this._size = undefined;\n        this._cachedAnimations = undefined;\n        this._tooltipItems = [];\n        this.$animations = undefined;\n        this.$context = undefined;\n        this.chart = config.chart;\n        this.options = config.options;\n        this.dataPoints = undefined;\n        this.title = undefined;\n        this.beforeBody = undefined;\n        this.body = undefined;\n        this.afterBody = undefined;\n        this.footer = undefined;\n        this.xAlign = undefined;\n        this.yAlign = undefined;\n        this.x = undefined;\n        this.y = undefined;\n        this.height = undefined;\n        this.width = undefined;\n        this.caretX = undefined;\n        this.caretY = undefined;\n        this.labelColors = undefined;\n        this.labelPointStyles = undefined;\n        this.labelTextColors = undefined;\n    }\n    initialize(options) {\n        this.options = options;\n        this._cachedAnimations = undefined;\n        this.$context = undefined;\n    }\n _resolveAnimations() {\n        const cached = this._cachedAnimations;\n        if (cached) {\n            return cached;\n        }\n        const chart = this.chart;\n        const options = this.options.setContext(this.getContext());\n        const opts = options.enabled && chart.options.animation && options.animations;\n        const animations = new Animations(this.chart, opts);\n        if (opts._cacheable) {\n            this._cachedAnimations = Object.freeze(animations);\n        }\n        return animations;\n    }\n getContext() {\n        return this.$context || (this.$context = createTooltipContext(this.chart.getContext(), this, this._tooltipItems));\n    }\n    getTitle(context, options) {\n        const { callbacks  } = options;\n        const beforeTitle = invokeCallbackWithFallback(callbacks, 'beforeTitle', this, context);\n        const title = invokeCallbackWithFallback(callbacks, 'title', this, context);\n        const afterTitle = invokeCallbackWithFallback(callbacks, 'afterTitle', this, context);\n        let lines = [];\n        lines = pushOrConcat(lines, splitNewlines(beforeTitle));\n        lines = pushOrConcat(lines, splitNewlines(title));\n        lines = pushOrConcat(lines, splitNewlines(afterTitle));\n        return lines;\n    }\n    getBeforeBody(tooltipItems, options) {\n        return getBeforeAfterBodyLines(invokeCallbackWithFallback(options.callbacks, 'beforeBody', this, tooltipItems));\n    }\n    getBody(tooltipItems, options) {\n        const { callbacks  } = options;\n        const bodyItems = [];\n        (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.F)(tooltipItems, (context)=>{\n            const bodyItem = {\n                before: [],\n                lines: [],\n                after: []\n            };\n            const scoped = overrideCallbacks(callbacks, context);\n            pushOrConcat(bodyItem.before, splitNewlines(invokeCallbackWithFallback(scoped, 'beforeLabel', this, context)));\n            pushOrConcat(bodyItem.lines, invokeCallbackWithFallback(scoped, 'label', this, context));\n            pushOrConcat(bodyItem.after, splitNewlines(invokeCallbackWithFallback(scoped, 'afterLabel', this, context)));\n            bodyItems.push(bodyItem);\n        });\n        return bodyItems;\n    }\n    getAfterBody(tooltipItems, options) {\n        return getBeforeAfterBodyLines(invokeCallbackWithFallback(options.callbacks, 'afterBody', this, tooltipItems));\n    }\n    getFooter(tooltipItems, options) {\n        const { callbacks  } = options;\n        const beforeFooter = invokeCallbackWithFallback(callbacks, 'beforeFooter', this, tooltipItems);\n        const footer = invokeCallbackWithFallback(callbacks, 'footer', this, tooltipItems);\n        const afterFooter = invokeCallbackWithFallback(callbacks, 'afterFooter', this, tooltipItems);\n        let lines = [];\n        lines = pushOrConcat(lines, splitNewlines(beforeFooter));\n        lines = pushOrConcat(lines, splitNewlines(footer));\n        lines = pushOrConcat(lines, splitNewlines(afterFooter));\n        return lines;\n    }\n _createItems(options) {\n        const active = this._active;\n        const data = this.chart.data;\n        const labelColors = [];\n        const labelPointStyles = [];\n        const labelTextColors = [];\n        let tooltipItems = [];\n        let i, len;\n        for(i = 0, len = active.length; i < len; ++i){\n            tooltipItems.push(createTooltipItem(this.chart, active[i]));\n        }\n        if (options.filter) {\n            tooltipItems = tooltipItems.filter((element, index, array)=>options.filter(element, index, array, data));\n        }\n        if (options.itemSort) {\n            tooltipItems = tooltipItems.sort((a, b)=>options.itemSort(a, b, data));\n        }\n        (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.F)(tooltipItems, (context)=>{\n            const scoped = overrideCallbacks(options.callbacks, context);\n            labelColors.push(invokeCallbackWithFallback(scoped, 'labelColor', this, context));\n            labelPointStyles.push(invokeCallbackWithFallback(scoped, 'labelPointStyle', this, context));\n            labelTextColors.push(invokeCallbackWithFallback(scoped, 'labelTextColor', this, context));\n        });\n        this.labelColors = labelColors;\n        this.labelPointStyles = labelPointStyles;\n        this.labelTextColors = labelTextColors;\n        this.dataPoints = tooltipItems;\n        return tooltipItems;\n    }\n    update(changed, replay) {\n        const options = this.options.setContext(this.getContext());\n        const active = this._active;\n        let properties;\n        let tooltipItems = [];\n        if (!active.length) {\n            if (this.opacity !== 0) {\n                properties = {\n                    opacity: 0\n                };\n            }\n        } else {\n            const position = positioners[options.position].call(this, active, this._eventPosition);\n            tooltipItems = this._createItems(options);\n            this.title = this.getTitle(tooltipItems, options);\n            this.beforeBody = this.getBeforeBody(tooltipItems, options);\n            this.body = this.getBody(tooltipItems, options);\n            this.afterBody = this.getAfterBody(tooltipItems, options);\n            this.footer = this.getFooter(tooltipItems, options);\n            const size = this._size = getTooltipSize(this, options);\n            const positionAndSize = Object.assign({}, position, size);\n            const alignment = determineAlignment(this.chart, options, positionAndSize);\n            const backgroundPoint = getBackgroundPoint(options, positionAndSize, alignment, this.chart);\n            this.xAlign = alignment.xAlign;\n            this.yAlign = alignment.yAlign;\n            properties = {\n                opacity: 1,\n                x: backgroundPoint.x,\n                y: backgroundPoint.y,\n                width: size.width,\n                height: size.height,\n                caretX: position.x,\n                caretY: position.y\n            };\n        }\n        this._tooltipItems = tooltipItems;\n        this.$context = undefined;\n        if (properties) {\n            this._resolveAnimations().update(this, properties);\n        }\n        if (changed && options.external) {\n            options.external.call(this, {\n                chart: this.chart,\n                tooltip: this,\n                replay\n            });\n        }\n    }\n    drawCaret(tooltipPoint, ctx, size, options) {\n        const caretPosition = this.getCaretPosition(tooltipPoint, size, options);\n        ctx.lineTo(caretPosition.x1, caretPosition.y1);\n        ctx.lineTo(caretPosition.x2, caretPosition.y2);\n        ctx.lineTo(caretPosition.x3, caretPosition.y3);\n    }\n    getCaretPosition(tooltipPoint, size, options) {\n        const { xAlign , yAlign  } = this;\n        const { caretSize , cornerRadius  } = options;\n        const { topLeft , topRight , bottomLeft , bottomRight  } = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.ax)(cornerRadius);\n        const { x: ptX , y: ptY  } = tooltipPoint;\n        const { width , height  } = size;\n        let x1, x2, x3, y1, y2, y3;\n        if (yAlign === 'center') {\n            y2 = ptY + height / 2;\n            if (xAlign === 'left') {\n                x1 = ptX;\n                x2 = x1 - caretSize;\n                y1 = y2 + caretSize;\n                y3 = y2 - caretSize;\n            } else {\n                x1 = ptX + width;\n                x2 = x1 + caretSize;\n                y1 = y2 - caretSize;\n                y3 = y2 + caretSize;\n            }\n            x3 = x1;\n        } else {\n            if (xAlign === 'left') {\n                x2 = ptX + Math.max(topLeft, bottomLeft) + caretSize;\n            } else if (xAlign === 'right') {\n                x2 = ptX + width - Math.max(topRight, bottomRight) - caretSize;\n            } else {\n                x2 = this.caretX;\n            }\n            if (yAlign === 'top') {\n                y1 = ptY;\n                y2 = y1 - caretSize;\n                x1 = x2 - caretSize;\n                x3 = x2 + caretSize;\n            } else {\n                y1 = ptY + height;\n                y2 = y1 + caretSize;\n                x1 = x2 + caretSize;\n                x3 = x2 - caretSize;\n            }\n            y3 = y1;\n        }\n        return {\n            x1,\n            x2,\n            x3,\n            y1,\n            y2,\n            y3\n        };\n    }\n    drawTitle(pt, ctx, options) {\n        const title = this.title;\n        const length = title.length;\n        let titleFont, titleSpacing, i;\n        if (length) {\n            const rtlHelper = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.aA)(options.rtl, this.x, this.width);\n            pt.x = getAlignedX(this, options.titleAlign, options);\n            ctx.textAlign = rtlHelper.textAlign(options.titleAlign);\n            ctx.textBaseline = 'middle';\n            titleFont = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a0)(options.titleFont);\n            titleSpacing = options.titleSpacing;\n            ctx.fillStyle = options.titleColor;\n            ctx.font = titleFont.string;\n            for(i = 0; i < length; ++i){\n                ctx.fillText(title[i], rtlHelper.x(pt.x), pt.y + titleFont.lineHeight / 2);\n                pt.y += titleFont.lineHeight + titleSpacing;\n                if (i + 1 === length) {\n                    pt.y += options.titleMarginBottom - titleSpacing;\n                }\n            }\n        }\n    }\n _drawColorBox(ctx, pt, i, rtlHelper, options) {\n        const labelColor = this.labelColors[i];\n        const labelPointStyle = this.labelPointStyles[i];\n        const { boxHeight , boxWidth  } = options;\n        const bodyFont = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a0)(options.bodyFont);\n        const colorX = getAlignedX(this, 'left', options);\n        const rtlColorX = rtlHelper.x(colorX);\n        const yOffSet = boxHeight < bodyFont.lineHeight ? (bodyFont.lineHeight - boxHeight) / 2 : 0;\n        const colorY = pt.y + yOffSet;\n        if (options.usePointStyle) {\n            const drawOptions = {\n                radius: Math.min(boxWidth, boxHeight) / 2,\n                pointStyle: labelPointStyle.pointStyle,\n                rotation: labelPointStyle.rotation,\n                borderWidth: 1\n            };\n            const centerX = rtlHelper.leftForLtr(rtlColorX, boxWidth) + boxWidth / 2;\n            const centerY = colorY + boxHeight / 2;\n            ctx.strokeStyle = options.multiKeyBackground;\n            ctx.fillStyle = options.multiKeyBackground;\n            (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.au)(ctx, drawOptions, centerX, centerY);\n            ctx.strokeStyle = labelColor.borderColor;\n            ctx.fillStyle = labelColor.backgroundColor;\n            (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.au)(ctx, drawOptions, centerX, centerY);\n        } else {\n            ctx.lineWidth = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.i)(labelColor.borderWidth) ? Math.max(...Object.values(labelColor.borderWidth)) : labelColor.borderWidth || 1;\n            ctx.strokeStyle = labelColor.borderColor;\n            ctx.setLineDash(labelColor.borderDash || []);\n            ctx.lineDashOffset = labelColor.borderDashOffset || 0;\n            const outerX = rtlHelper.leftForLtr(rtlColorX, boxWidth);\n            const innerX = rtlHelper.leftForLtr(rtlHelper.xPlus(rtlColorX, 1), boxWidth - 2);\n            const borderRadius = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.ax)(labelColor.borderRadius);\n            if (Object.values(borderRadius).some((v)=>v !== 0)) {\n                ctx.beginPath();\n                ctx.fillStyle = options.multiKeyBackground;\n                (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.av)(ctx, {\n                    x: outerX,\n                    y: colorY,\n                    w: boxWidth,\n                    h: boxHeight,\n                    radius: borderRadius\n                });\n                ctx.fill();\n                ctx.stroke();\n                ctx.fillStyle = labelColor.backgroundColor;\n                ctx.beginPath();\n                (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.av)(ctx, {\n                    x: innerX,\n                    y: colorY + 1,\n                    w: boxWidth - 2,\n                    h: boxHeight - 2,\n                    radius: borderRadius\n                });\n                ctx.fill();\n            } else {\n                ctx.fillStyle = options.multiKeyBackground;\n                ctx.fillRect(outerX, colorY, boxWidth, boxHeight);\n                ctx.strokeRect(outerX, colorY, boxWidth, boxHeight);\n                ctx.fillStyle = labelColor.backgroundColor;\n                ctx.fillRect(innerX, colorY + 1, boxWidth - 2, boxHeight - 2);\n            }\n        }\n        ctx.fillStyle = this.labelTextColors[i];\n    }\n    drawBody(pt, ctx, options) {\n        const { body  } = this;\n        const { bodySpacing , bodyAlign , displayColors , boxHeight , boxWidth , boxPadding  } = options;\n        const bodyFont = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a0)(options.bodyFont);\n        let bodyLineHeight = bodyFont.lineHeight;\n        let xLinePadding = 0;\n        const rtlHelper = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.aA)(options.rtl, this.x, this.width);\n        const fillLineOfText = function(line) {\n            ctx.fillText(line, rtlHelper.x(pt.x + xLinePadding), pt.y + bodyLineHeight / 2);\n            pt.y += bodyLineHeight + bodySpacing;\n        };\n        const bodyAlignForCalculation = rtlHelper.textAlign(bodyAlign);\n        let bodyItem, textColor, lines, i, j, ilen, jlen;\n        ctx.textAlign = bodyAlign;\n        ctx.textBaseline = 'middle';\n        ctx.font = bodyFont.string;\n        pt.x = getAlignedX(this, bodyAlignForCalculation, options);\n        ctx.fillStyle = options.bodyColor;\n        (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.F)(this.beforeBody, fillLineOfText);\n        xLinePadding = displayColors && bodyAlignForCalculation !== 'right' ? bodyAlign === 'center' ? boxWidth / 2 + boxPadding : boxWidth + 2 + boxPadding : 0;\n        for(i = 0, ilen = body.length; i < ilen; ++i){\n            bodyItem = body[i];\n            textColor = this.labelTextColors[i];\n            ctx.fillStyle = textColor;\n            (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.F)(bodyItem.before, fillLineOfText);\n            lines = bodyItem.lines;\n            if (displayColors && lines.length) {\n                this._drawColorBox(ctx, pt, i, rtlHelper, options);\n                bodyLineHeight = Math.max(bodyFont.lineHeight, boxHeight);\n            }\n            for(j = 0, jlen = lines.length; j < jlen; ++j){\n                fillLineOfText(lines[j]);\n                bodyLineHeight = bodyFont.lineHeight;\n            }\n            (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.F)(bodyItem.after, fillLineOfText);\n        }\n        xLinePadding = 0;\n        bodyLineHeight = bodyFont.lineHeight;\n        (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.F)(this.afterBody, fillLineOfText);\n        pt.y -= bodySpacing;\n    }\n    drawFooter(pt, ctx, options) {\n        const footer = this.footer;\n        const length = footer.length;\n        let footerFont, i;\n        if (length) {\n            const rtlHelper = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.aA)(options.rtl, this.x, this.width);\n            pt.x = getAlignedX(this, options.footerAlign, options);\n            pt.y += options.footerMarginTop;\n            ctx.textAlign = rtlHelper.textAlign(options.footerAlign);\n            ctx.textBaseline = 'middle';\n            footerFont = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a0)(options.footerFont);\n            ctx.fillStyle = options.footerColor;\n            ctx.font = footerFont.string;\n            for(i = 0; i < length; ++i){\n                ctx.fillText(footer[i], rtlHelper.x(pt.x), pt.y + footerFont.lineHeight / 2);\n                pt.y += footerFont.lineHeight + options.footerSpacing;\n            }\n        }\n    }\n    drawBackground(pt, ctx, tooltipSize, options) {\n        const { xAlign , yAlign  } = this;\n        const { x , y  } = pt;\n        const { width , height  } = tooltipSize;\n        const { topLeft , topRight , bottomLeft , bottomRight  } = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.ax)(options.cornerRadius);\n        ctx.fillStyle = options.backgroundColor;\n        ctx.strokeStyle = options.borderColor;\n        ctx.lineWidth = options.borderWidth;\n        ctx.beginPath();\n        ctx.moveTo(x + topLeft, y);\n        if (yAlign === 'top') {\n            this.drawCaret(pt, ctx, tooltipSize, options);\n        }\n        ctx.lineTo(x + width - topRight, y);\n        ctx.quadraticCurveTo(x + width, y, x + width, y + topRight);\n        if (yAlign === 'center' && xAlign === 'right') {\n            this.drawCaret(pt, ctx, tooltipSize, options);\n        }\n        ctx.lineTo(x + width, y + height - bottomRight);\n        ctx.quadraticCurveTo(x + width, y + height, x + width - bottomRight, y + height);\n        if (yAlign === 'bottom') {\n            this.drawCaret(pt, ctx, tooltipSize, options);\n        }\n        ctx.lineTo(x + bottomLeft, y + height);\n        ctx.quadraticCurveTo(x, y + height, x, y + height - bottomLeft);\n        if (yAlign === 'center' && xAlign === 'left') {\n            this.drawCaret(pt, ctx, tooltipSize, options);\n        }\n        ctx.lineTo(x, y + topLeft);\n        ctx.quadraticCurveTo(x, y, x + topLeft, y);\n        ctx.closePath();\n        ctx.fill();\n        if (options.borderWidth > 0) {\n            ctx.stroke();\n        }\n    }\n _updateAnimationTarget(options) {\n        const chart = this.chart;\n        const anims = this.$animations;\n        const animX = anims && anims.x;\n        const animY = anims && anims.y;\n        if (animX || animY) {\n            const position = positioners[options.position].call(this, this._active, this._eventPosition);\n            if (!position) {\n                return;\n            }\n            const size = this._size = getTooltipSize(this, options);\n            const positionAndSize = Object.assign({}, position, this._size);\n            const alignment = determineAlignment(chart, options, positionAndSize);\n            const point = getBackgroundPoint(options, positionAndSize, alignment, chart);\n            if (animX._to !== point.x || animY._to !== point.y) {\n                this.xAlign = alignment.xAlign;\n                this.yAlign = alignment.yAlign;\n                this.width = size.width;\n                this.height = size.height;\n                this.caretX = position.x;\n                this.caretY = position.y;\n                this._resolveAnimations().update(this, point);\n            }\n        }\n    }\n _willRender() {\n        return !!this.opacity;\n    }\n    draw(ctx) {\n        const options = this.options.setContext(this.getContext());\n        let opacity = this.opacity;\n        if (!opacity) {\n            return;\n        }\n        this._updateAnimationTarget(options);\n        const tooltipSize = {\n            width: this.width,\n            height: this.height\n        };\n        const pt = {\n            x: this.x,\n            y: this.y\n        };\n        opacity = Math.abs(opacity) < 1e-3 ? 0 : opacity;\n        const padding = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.E)(options.padding);\n        const hasTooltipContent = this.title.length || this.beforeBody.length || this.body.length || this.afterBody.length || this.footer.length;\n        if (options.enabled && hasTooltipContent) {\n            ctx.save();\n            ctx.globalAlpha = opacity;\n            this.drawBackground(pt, ctx, tooltipSize, options);\n            (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.aB)(ctx, options.textDirection);\n            pt.y += padding.top;\n            this.drawTitle(pt, ctx, options);\n            this.drawBody(pt, ctx, options);\n            this.drawFooter(pt, ctx, options);\n            (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.aD)(ctx, options.textDirection);\n            ctx.restore();\n        }\n    }\n getActiveElements() {\n        return this._active || [];\n    }\n setActiveElements(activeElements, eventPosition) {\n        const lastActive = this._active;\n        const active = activeElements.map(({ datasetIndex , index  })=>{\n            const meta = this.chart.getDatasetMeta(datasetIndex);\n            if (!meta) {\n                throw new Error('Cannot find a dataset at index ' + datasetIndex);\n            }\n            return {\n                datasetIndex,\n                element: meta.data[index],\n                index\n            };\n        });\n        const changed = !(0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.ai)(lastActive, active);\n        const positionChanged = this._positionChanged(active, eventPosition);\n        if (changed || positionChanged) {\n            this._active = active;\n            this._eventPosition = eventPosition;\n            this._ignoreReplayEvents = true;\n            this.update(true);\n        }\n    }\n handleEvent(e, replay, inChartArea = true) {\n        if (replay && this._ignoreReplayEvents) {\n            return false;\n        }\n        this._ignoreReplayEvents = false;\n        const options = this.options;\n        const lastActive = this._active || [];\n        const active = this._getActiveElements(e, lastActive, replay, inChartArea);\n        const positionChanged = this._positionChanged(active, e);\n        const changed = replay || !(0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.ai)(active, lastActive) || positionChanged;\n        if (changed) {\n            this._active = active;\n            if (options.enabled || options.external) {\n                this._eventPosition = {\n                    x: e.x,\n                    y: e.y\n                };\n                this.update(true, replay);\n            }\n        }\n        return changed;\n    }\n _getActiveElements(e, lastActive, replay, inChartArea) {\n        const options = this.options;\n        if (e.type === 'mouseout') {\n            return [];\n        }\n        if (!inChartArea) {\n            return lastActive.filter((i)=>this.chart.data.datasets[i.datasetIndex] && this.chart.getDatasetMeta(i.datasetIndex).controller.getParsed(i.index) !== undefined);\n        }\n        const active = this.chart.getElementsAtEventForMode(e, options.mode, options, replay);\n        if (options.reverse) {\n            active.reverse();\n        }\n        return active;\n    }\n _positionChanged(active, e) {\n        const { caretX , caretY , options  } = this;\n        const position = positioners[options.position].call(this, active, e);\n        return position !== false && (caretX !== position.x || caretY !== position.y);\n    }\n}\nvar plugin_tooltip = {\n    id: 'tooltip',\n    _element: Tooltip,\n    positioners,\n    afterInit (chart, _args, options) {\n        if (options) {\n            chart.tooltip = new Tooltip({\n                chart,\n                options\n            });\n        }\n    },\n    beforeUpdate (chart, _args, options) {\n        if (chart.tooltip) {\n            chart.tooltip.initialize(options);\n        }\n    },\n    reset (chart, _args, options) {\n        if (chart.tooltip) {\n            chart.tooltip.initialize(options);\n        }\n    },\n    afterDraw (chart) {\n        const tooltip = chart.tooltip;\n        if (tooltip && tooltip._willRender()) {\n            const args = {\n                tooltip\n            };\n            if (chart.notifyPlugins('beforeTooltipDraw', {\n                ...args,\n                cancelable: true\n            }) === false) {\n                return;\n            }\n            tooltip.draw(chart.ctx);\n            chart.notifyPlugins('afterTooltipDraw', args);\n        }\n    },\n    afterEvent (chart, args) {\n        if (chart.tooltip) {\n            const useFinalPosition = args.replay;\n            if (chart.tooltip.handleEvent(args.event, useFinalPosition, args.inChartArea)) {\n                args.changed = true;\n            }\n        }\n    },\n    defaults: {\n        enabled: true,\n        external: null,\n        position: 'average',\n        backgroundColor: 'rgba(0,0,0,0.8)',\n        titleColor: '#fff',\n        titleFont: {\n            weight: 'bold'\n        },\n        titleSpacing: 2,\n        titleMarginBottom: 6,\n        titleAlign: 'left',\n        bodyColor: '#fff',\n        bodySpacing: 2,\n        bodyFont: {},\n        bodyAlign: 'left',\n        footerColor: '#fff',\n        footerSpacing: 2,\n        footerMarginTop: 6,\n        footerFont: {\n            weight: 'bold'\n        },\n        footerAlign: 'left',\n        padding: 6,\n        caretPadding: 2,\n        caretSize: 5,\n        cornerRadius: 6,\n        boxHeight: (ctx, opts)=>opts.bodyFont.size,\n        boxWidth: (ctx, opts)=>opts.bodyFont.size,\n        multiKeyBackground: '#fff',\n        displayColors: true,\n        boxPadding: 0,\n        borderColor: 'rgba(0,0,0,0)',\n        borderWidth: 0,\n        animation: {\n            duration: 400,\n            easing: 'easeOutQuart'\n        },\n        animations: {\n            numbers: {\n                type: 'number',\n                properties: [\n                    'x',\n                    'y',\n                    'width',\n                    'height',\n                    'caretX',\n                    'caretY'\n                ]\n            },\n            opacity: {\n                easing: 'linear',\n                duration: 200\n            }\n        },\n        callbacks: defaultCallbacks\n    },\n    defaultRoutes: {\n        bodyFont: 'font',\n        footerFont: 'font',\n        titleFont: 'font'\n    },\n    descriptors: {\n        _scriptable: (name)=>name !== 'filter' && name !== 'itemSort' && name !== 'external',\n        _indexable: false,\n        callbacks: {\n            _scriptable: false,\n            _indexable: false\n        },\n        animation: {\n            _fallback: false\n        },\n        animations: {\n            _fallback: 'animation'\n        }\n    },\n    additionalOptionScopes: [\n        'interaction'\n    ]\n};\n\nvar plugins = /*#__PURE__*/Object.freeze({\n__proto__: null,\nColors: plugin_colors,\nDecimation: plugin_decimation,\nFiller: index,\nLegend: plugin_legend,\nSubTitle: plugin_subtitle,\nTitle: plugin_title,\nTooltip: plugin_tooltip\n});\n\nconst addIfString = (labels, raw, index, addedLabels)=>{\n    if (typeof raw === 'string') {\n        index = labels.push(raw) - 1;\n        addedLabels.unshift({\n            index,\n            label: raw\n        });\n    } else if (isNaN(raw)) {\n        index = null;\n    }\n    return index;\n};\nfunction findOrAddLabel(labels, raw, index, addedLabels) {\n    const first = labels.indexOf(raw);\n    if (first === -1) {\n        return addIfString(labels, raw, index, addedLabels);\n    }\n    const last = labels.lastIndexOf(raw);\n    return first !== last ? index : first;\n}\nconst validIndex = (index, max)=>index === null ? null : (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.S)(Math.round(index), 0, max);\nfunction _getLabelForValue(value) {\n    const labels = this.getLabels();\n    if (value >= 0 && value < labels.length) {\n        return labels[value];\n    }\n    return value;\n}\nclass CategoryScale extends Scale {\n    static id = 'category';\n static defaults = {\n        ticks: {\n            callback: _getLabelForValue\n        }\n    };\n    constructor(cfg){\n        super(cfg);\n         this._startValue = undefined;\n        this._valueRange = 0;\n        this._addedLabels = [];\n    }\n    init(scaleOptions) {\n        const added = this._addedLabels;\n        if (added.length) {\n            const labels = this.getLabels();\n            for (const { index , label  } of added){\n                if (labels[index] === label) {\n                    labels.splice(index, 1);\n                }\n            }\n            this._addedLabels = [];\n        }\n        super.init(scaleOptions);\n    }\n    parse(raw, index) {\n        if ((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.k)(raw)) {\n            return null;\n        }\n        const labels = this.getLabels();\n        index = isFinite(index) && labels[index] === raw ? index : findOrAddLabel(labels, raw, (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.v)(index, raw), this._addedLabels);\n        return validIndex(index, labels.length - 1);\n    }\n    determineDataLimits() {\n        const { minDefined , maxDefined  } = this.getUserBounds();\n        let { min , max  } = this.getMinMax(true);\n        if (this.options.bounds === 'ticks') {\n            if (!minDefined) {\n                min = 0;\n            }\n            if (!maxDefined) {\n                max = this.getLabels().length - 1;\n            }\n        }\n        this.min = min;\n        this.max = max;\n    }\n    buildTicks() {\n        const min = this.min;\n        const max = this.max;\n        const offset = this.options.offset;\n        const ticks = [];\n        let labels = this.getLabels();\n        labels = min === 0 && max === labels.length - 1 ? labels : labels.slice(min, max + 1);\n        this._valueRange = Math.max(labels.length - (offset ? 0 : 1), 1);\n        this._startValue = this.min - (offset ? 0.5 : 0);\n        for(let value = min; value <= max; value++){\n            ticks.push({\n                value\n            });\n        }\n        return ticks;\n    }\n    getLabelForValue(value) {\n        return _getLabelForValue.call(this, value);\n    }\n configure() {\n        super.configure();\n        if (!this.isHorizontal()) {\n            this._reversePixels = !this._reversePixels;\n        }\n    }\n    getPixelForValue(value) {\n        if (typeof value !== 'number') {\n            value = this.parse(value);\n        }\n        return value === null ? NaN : this.getPixelForDecimal((value - this._startValue) / this._valueRange);\n    }\n    getPixelForTick(index) {\n        const ticks = this.ticks;\n        if (index < 0 || index > ticks.length - 1) {\n            return null;\n        }\n        return this.getPixelForValue(ticks[index].value);\n    }\n    getValueForPixel(pixel) {\n        return Math.round(this._startValue + this.getDecimalForPixel(pixel) * this._valueRange);\n    }\n    getBasePixel() {\n        return this.bottom;\n    }\n}\n\nfunction generateTicks$1(generationOptions, dataRange) {\n    const ticks = [];\n    const MIN_SPACING = 1e-14;\n    const { bounds , step , min , max , precision , count , maxTicks , maxDigits , includeBounds  } = generationOptions;\n    const unit = step || 1;\n    const maxSpaces = maxTicks - 1;\n    const { min: rmin , max: rmax  } = dataRange;\n    const minDefined = !(0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.k)(min);\n    const maxDefined = !(0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.k)(max);\n    const countDefined = !(0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.k)(count);\n    const minSpacing = (rmax - rmin) / (maxDigits + 1);\n    let spacing = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.aI)((rmax - rmin) / maxSpaces / unit) * unit;\n    let factor, niceMin, niceMax, numSpaces;\n    if (spacing < MIN_SPACING && !minDefined && !maxDefined) {\n        return [\n            {\n                value: rmin\n            },\n            {\n                value: rmax\n            }\n        ];\n    }\n    numSpaces = Math.ceil(rmax / spacing) - Math.floor(rmin / spacing);\n    if (numSpaces > maxSpaces) {\n        spacing = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.aI)(numSpaces * spacing / maxSpaces / unit) * unit;\n    }\n    if (!(0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.k)(precision)) {\n        factor = Math.pow(10, precision);\n        spacing = Math.ceil(spacing * factor) / factor;\n    }\n    if (bounds === 'ticks') {\n        niceMin = Math.floor(rmin / spacing) * spacing;\n        niceMax = Math.ceil(rmax / spacing) * spacing;\n    } else {\n        niceMin = rmin;\n        niceMax = rmax;\n    }\n    if (minDefined && maxDefined && step && (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.aJ)((max - min) / step, spacing / 1000)) {\n        numSpaces = Math.round(Math.min((max - min) / spacing, maxTicks));\n        spacing = (max - min) / numSpaces;\n        niceMin = min;\n        niceMax = max;\n    } else if (countDefined) {\n        niceMin = minDefined ? min : niceMin;\n        niceMax = maxDefined ? max : niceMax;\n        numSpaces = count - 1;\n        spacing = (niceMax - niceMin) / numSpaces;\n    } else {\n        numSpaces = (niceMax - niceMin) / spacing;\n        if ((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.aK)(numSpaces, Math.round(numSpaces), spacing / 1000)) {\n            numSpaces = Math.round(numSpaces);\n        } else {\n            numSpaces = Math.ceil(numSpaces);\n        }\n    }\n    const decimalPlaces = Math.max((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.aL)(spacing), (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.aL)(niceMin));\n    factor = Math.pow(10, (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.k)(precision) ? decimalPlaces : precision);\n    niceMin = Math.round(niceMin * factor) / factor;\n    niceMax = Math.round(niceMax * factor) / factor;\n    let j = 0;\n    if (minDefined) {\n        if (includeBounds && niceMin !== min) {\n            ticks.push({\n                value: min\n            });\n            if (niceMin < min) {\n                j++;\n            }\n            if ((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.aK)(Math.round((niceMin + j * spacing) * factor) / factor, min, relativeLabelSize(min, minSpacing, generationOptions))) {\n                j++;\n            }\n        } else if (niceMin < min) {\n            j++;\n        }\n    }\n    for(; j < numSpaces; ++j){\n        const tickValue = Math.round((niceMin + j * spacing) * factor) / factor;\n        if (maxDefined && tickValue > max) {\n            break;\n        }\n        ticks.push({\n            value: tickValue\n        });\n    }\n    if (maxDefined && includeBounds && niceMax !== max) {\n        if (ticks.length && (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.aK)(ticks[ticks.length - 1].value, max, relativeLabelSize(max, minSpacing, generationOptions))) {\n            ticks[ticks.length - 1].value = max;\n        } else {\n            ticks.push({\n                value: max\n            });\n        }\n    } else if (!maxDefined || niceMax === max) {\n        ticks.push({\n            value: niceMax\n        });\n    }\n    return ticks;\n}\nfunction relativeLabelSize(value, minSpacing, { horizontal , minRotation  }) {\n    const rad = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.t)(minRotation);\n    const ratio = (horizontal ? Math.sin(rad) : Math.cos(rad)) || 0.001;\n    const length = 0.75 * minSpacing * ('' + value).length;\n    return Math.min(minSpacing / ratio, length);\n}\nclass LinearScaleBase extends Scale {\n    constructor(cfg){\n        super(cfg);\n         this.start = undefined;\n         this.end = undefined;\n         this._startValue = undefined;\n         this._endValue = undefined;\n        this._valueRange = 0;\n    }\n    parse(raw, index) {\n        if ((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.k)(raw)) {\n            return null;\n        }\n        if ((typeof raw === 'number' || raw instanceof Number) && !isFinite(+raw)) {\n            return null;\n        }\n        return +raw;\n    }\n    handleTickRangeOptions() {\n        const { beginAtZero  } = this.options;\n        const { minDefined , maxDefined  } = this.getUserBounds();\n        let { min , max  } = this;\n        const setMin = (v)=>min = minDefined ? min : v;\n        const setMax = (v)=>max = maxDefined ? max : v;\n        if (beginAtZero) {\n            const minSign = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.s)(min);\n            const maxSign = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.s)(max);\n            if (minSign < 0 && maxSign < 0) {\n                setMax(0);\n            } else if (minSign > 0 && maxSign > 0) {\n                setMin(0);\n            }\n        }\n        if (min === max) {\n            let offset = max === 0 ? 1 : Math.abs(max * 0.05);\n            setMax(max + offset);\n            if (!beginAtZero) {\n                setMin(min - offset);\n            }\n        }\n        this.min = min;\n        this.max = max;\n    }\n    getTickLimit() {\n        const tickOpts = this.options.ticks;\n        let { maxTicksLimit , stepSize  } = tickOpts;\n        let maxTicks;\n        if (stepSize) {\n            maxTicks = Math.ceil(this.max / stepSize) - Math.floor(this.min / stepSize) + 1;\n            if (maxTicks > 1000) {\n                console.warn(`scales.${this.id}.ticks.stepSize: ${stepSize} would result generating up to ${maxTicks} ticks. Limiting to 1000.`);\n                maxTicks = 1000;\n            }\n        } else {\n            maxTicks = this.computeTickLimit();\n            maxTicksLimit = maxTicksLimit || 11;\n        }\n        if (maxTicksLimit) {\n            maxTicks = Math.min(maxTicksLimit, maxTicks);\n        }\n        return maxTicks;\n    }\n computeTickLimit() {\n        return Number.POSITIVE_INFINITY;\n    }\n    buildTicks() {\n        const opts = this.options;\n        const tickOpts = opts.ticks;\n        let maxTicks = this.getTickLimit();\n        maxTicks = Math.max(2, maxTicks);\n        const numericGeneratorOptions = {\n            maxTicks,\n            bounds: opts.bounds,\n            min: opts.min,\n            max: opts.max,\n            precision: tickOpts.precision,\n            step: tickOpts.stepSize,\n            count: tickOpts.count,\n            maxDigits: this._maxDigits(),\n            horizontal: this.isHorizontal(),\n            minRotation: tickOpts.minRotation || 0,\n            includeBounds: tickOpts.includeBounds !== false\n        };\n        const dataRange = this._range || this;\n        const ticks = generateTicks$1(numericGeneratorOptions, dataRange);\n        if (opts.bounds === 'ticks') {\n            (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.aH)(ticks, this, 'value');\n        }\n        if (opts.reverse) {\n            ticks.reverse();\n            this.start = this.max;\n            this.end = this.min;\n        } else {\n            this.start = this.min;\n            this.end = this.max;\n        }\n        return ticks;\n    }\n configure() {\n        const ticks = this.ticks;\n        let start = this.min;\n        let end = this.max;\n        super.configure();\n        if (this.options.offset && ticks.length) {\n            const offset = (end - start) / Math.max(ticks.length - 1, 1) / 2;\n            start -= offset;\n            end += offset;\n        }\n        this._startValue = start;\n        this._endValue = end;\n        this._valueRange = end - start;\n    }\n    getLabelForValue(value) {\n        return (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.o)(value, this.chart.options.locale, this.options.ticks.format);\n    }\n}\n\nclass LinearScale extends LinearScaleBase {\n    static id = 'linear';\n static defaults = {\n        ticks: {\n            callback: _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.aM.formatters.numeric\n        }\n    };\n    determineDataLimits() {\n        const { min , max  } = this.getMinMax(true);\n        this.min = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.g)(min) ? min : 0;\n        this.max = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.g)(max) ? max : 1;\n        this.handleTickRangeOptions();\n    }\n computeTickLimit() {\n        const horizontal = this.isHorizontal();\n        const length = horizontal ? this.width : this.height;\n        const minRotation = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.t)(this.options.ticks.minRotation);\n        const ratio = (horizontal ? Math.sin(minRotation) : Math.cos(minRotation)) || 0.001;\n        const tickFont = this._resolveTickFontOptions(0);\n        return Math.ceil(length / Math.min(40, tickFont.lineHeight / ratio));\n    }\n    getPixelForValue(value) {\n        return value === null ? NaN : this.getPixelForDecimal((value - this._startValue) / this._valueRange);\n    }\n    getValueForPixel(pixel) {\n        return this._startValue + this.getDecimalForPixel(pixel) * this._valueRange;\n    }\n}\n\nconst log10Floor = (v)=>Math.floor((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.aN)(v));\nconst changeExponent = (v, m)=>Math.pow(10, log10Floor(v) + m);\nfunction isMajor(tickVal) {\n    const remain = tickVal / Math.pow(10, log10Floor(tickVal));\n    return remain === 1;\n}\nfunction steps(min, max, rangeExp) {\n    const rangeStep = Math.pow(10, rangeExp);\n    const start = Math.floor(min / rangeStep);\n    const end = Math.ceil(max / rangeStep);\n    return end - start;\n}\nfunction startExp(min, max) {\n    const range = max - min;\n    let rangeExp = log10Floor(range);\n    while(steps(min, max, rangeExp) > 10){\n        rangeExp++;\n    }\n    while(steps(min, max, rangeExp) < 10){\n        rangeExp--;\n    }\n    return Math.min(rangeExp, log10Floor(min));\n}\n function generateTicks(generationOptions, { min , max  }) {\n    min = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.O)(generationOptions.min, min);\n    const ticks = [];\n    const minExp = log10Floor(min);\n    let exp = startExp(min, max);\n    let precision = exp < 0 ? Math.pow(10, Math.abs(exp)) : 1;\n    const stepSize = Math.pow(10, exp);\n    const base = minExp > exp ? Math.pow(10, minExp) : 0;\n    const start = Math.round((min - base) * precision) / precision;\n    const offset = Math.floor((min - base) / stepSize / 10) * stepSize * 10;\n    let significand = Math.floor((start - offset) / Math.pow(10, exp));\n    let value = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.O)(generationOptions.min, Math.round((base + offset + significand * Math.pow(10, exp)) * precision) / precision);\n    while(value < max){\n        ticks.push({\n            value,\n            major: isMajor(value),\n            significand\n        });\n        if (significand >= 10) {\n            significand = significand < 15 ? 15 : 20;\n        } else {\n            significand++;\n        }\n        if (significand >= 20) {\n            exp++;\n            significand = 2;\n            precision = exp >= 0 ? 1 : precision;\n        }\n        value = Math.round((base + offset + significand * Math.pow(10, exp)) * precision) / precision;\n    }\n    const lastTick = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.O)(generationOptions.max, value);\n    ticks.push({\n        value: lastTick,\n        major: isMajor(lastTick),\n        significand\n    });\n    return ticks;\n}\nclass LogarithmicScale extends Scale {\n    static id = 'logarithmic';\n static defaults = {\n        ticks: {\n            callback: _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.aM.formatters.logarithmic,\n            major: {\n                enabled: true\n            }\n        }\n    };\n    constructor(cfg){\n        super(cfg);\n         this.start = undefined;\n         this.end = undefined;\n         this._startValue = undefined;\n        this._valueRange = 0;\n    }\n    parse(raw, index) {\n        const value = LinearScaleBase.prototype.parse.apply(this, [\n            raw,\n            index\n        ]);\n        if (value === 0) {\n            this._zero = true;\n            return undefined;\n        }\n        return (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.g)(value) && value > 0 ? value : null;\n    }\n    determineDataLimits() {\n        const { min , max  } = this.getMinMax(true);\n        this.min = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.g)(min) ? Math.max(0, min) : null;\n        this.max = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.g)(max) ? Math.max(0, max) : null;\n        if (this.options.beginAtZero) {\n            this._zero = true;\n        }\n        if (this._zero && this.min !== this._suggestedMin && !(0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.g)(this._userMin)) {\n            this.min = min === changeExponent(this.min, 0) ? changeExponent(this.min, -1) : changeExponent(this.min, 0);\n        }\n        this.handleTickRangeOptions();\n    }\n    handleTickRangeOptions() {\n        const { minDefined , maxDefined  } = this.getUserBounds();\n        let min = this.min;\n        let max = this.max;\n        const setMin = (v)=>min = minDefined ? min : v;\n        const setMax = (v)=>max = maxDefined ? max : v;\n        if (min === max) {\n            if (min <= 0) {\n                setMin(1);\n                setMax(10);\n            } else {\n                setMin(changeExponent(min, -1));\n                setMax(changeExponent(max, +1));\n            }\n        }\n        if (min <= 0) {\n            setMin(changeExponent(max, -1));\n        }\n        if (max <= 0) {\n            setMax(changeExponent(min, +1));\n        }\n        this.min = min;\n        this.max = max;\n    }\n    buildTicks() {\n        const opts = this.options;\n        const generationOptions = {\n            min: this._userMin,\n            max: this._userMax\n        };\n        const ticks = generateTicks(generationOptions, this);\n        if (opts.bounds === 'ticks') {\n            (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.aH)(ticks, this, 'value');\n        }\n        if (opts.reverse) {\n            ticks.reverse();\n            this.start = this.max;\n            this.end = this.min;\n        } else {\n            this.start = this.min;\n            this.end = this.max;\n        }\n        return ticks;\n    }\n getLabelForValue(value) {\n        return value === undefined ? '0' : (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.o)(value, this.chart.options.locale, this.options.ticks.format);\n    }\n configure() {\n        const start = this.min;\n        super.configure();\n        this._startValue = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.aN)(start);\n        this._valueRange = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.aN)(this.max) - (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.aN)(start);\n    }\n    getPixelForValue(value) {\n        if (value === undefined || value === 0) {\n            value = this.min;\n        }\n        if (value === null || isNaN(value)) {\n            return NaN;\n        }\n        return this.getPixelForDecimal(value === this.min ? 0 : ((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.aN)(value) - this._startValue) / this._valueRange);\n    }\n    getValueForPixel(pixel) {\n        const decimal = this.getDecimalForPixel(pixel);\n        return Math.pow(10, this._startValue + decimal * this._valueRange);\n    }\n}\n\nfunction getTickBackdropHeight(opts) {\n    const tickOpts = opts.ticks;\n    if (tickOpts.display && opts.display) {\n        const padding = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.E)(tickOpts.backdropPadding);\n        return (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.v)(tickOpts.font && tickOpts.font.size, _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.d.font.size) + padding.height;\n    }\n    return 0;\n}\nfunction measureLabelSize(ctx, font, label) {\n    label = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.b)(label) ? label : [\n        label\n    ];\n    return {\n        w: (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.aO)(ctx, font.string, label),\n        h: label.length * font.lineHeight\n    };\n}\nfunction determineLimits(angle, pos, size, min, max) {\n    if (angle === min || angle === max) {\n        return {\n            start: pos - size / 2,\n            end: pos + size / 2\n        };\n    } else if (angle < min || angle > max) {\n        return {\n            start: pos - size,\n            end: pos\n        };\n    }\n    return {\n        start: pos,\n        end: pos + size\n    };\n}\n function fitWithPointLabels(scale) {\n    const orig = {\n        l: scale.left + scale._padding.left,\n        r: scale.right - scale._padding.right,\n        t: scale.top + scale._padding.top,\n        b: scale.bottom - scale._padding.bottom\n    };\n    const limits = Object.assign({}, orig);\n    const labelSizes = [];\n    const padding = [];\n    const valueCount = scale._pointLabels.length;\n    const pointLabelOpts = scale.options.pointLabels;\n    const additionalAngle = pointLabelOpts.centerPointLabels ? _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.P / valueCount : 0;\n    for(let i = 0; i < valueCount; i++){\n        const opts = pointLabelOpts.setContext(scale.getPointLabelContext(i));\n        padding[i] = opts.padding;\n        const pointPosition = scale.getPointPosition(i, scale.drawingArea + padding[i], additionalAngle);\n        const plFont = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a0)(opts.font);\n        const textSize = measureLabelSize(scale.ctx, plFont, scale._pointLabels[i]);\n        labelSizes[i] = textSize;\n        const angleRadians = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.az)(scale.getIndexAngle(i) + additionalAngle);\n        const angle = Math.round((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.U)(angleRadians));\n        const hLimits = determineLimits(angle, pointPosition.x, textSize.w, 0, 180);\n        const vLimits = determineLimits(angle, pointPosition.y, textSize.h, 90, 270);\n        updateLimits(limits, orig, angleRadians, hLimits, vLimits);\n    }\n    scale.setCenterPoint(orig.l - limits.l, limits.r - orig.r, orig.t - limits.t, limits.b - orig.b);\n    scale._pointLabelItems = buildPointLabelItems(scale, labelSizes, padding);\n}\nfunction updateLimits(limits, orig, angle, hLimits, vLimits) {\n    const sin = Math.abs(Math.sin(angle));\n    const cos = Math.abs(Math.cos(angle));\n    let x = 0;\n    let y = 0;\n    if (hLimits.start < orig.l) {\n        x = (orig.l - hLimits.start) / sin;\n        limits.l = Math.min(limits.l, orig.l - x);\n    } else if (hLimits.end > orig.r) {\n        x = (hLimits.end - orig.r) / sin;\n        limits.r = Math.max(limits.r, orig.r + x);\n    }\n    if (vLimits.start < orig.t) {\n        y = (orig.t - vLimits.start) / cos;\n        limits.t = Math.min(limits.t, orig.t - y);\n    } else if (vLimits.end > orig.b) {\n        y = (vLimits.end - orig.b) / cos;\n        limits.b = Math.max(limits.b, orig.b + y);\n    }\n}\nfunction createPointLabelItem(scale, index, itemOpts) {\n    const outerDistance = scale.drawingArea;\n    const { extra , additionalAngle , padding , size  } = itemOpts;\n    const pointLabelPosition = scale.getPointPosition(index, outerDistance + extra + padding, additionalAngle);\n    const angle = Math.round((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.U)((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.az)(pointLabelPosition.angle + _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.H)));\n    const y = yForAngle(pointLabelPosition.y, size.h, angle);\n    const textAlign = getTextAlignForAngle(angle);\n    const left = leftForTextAlign(pointLabelPosition.x, size.w, textAlign);\n    return {\n        visible: true,\n        x: pointLabelPosition.x,\n        y,\n        textAlign,\n        left,\n        top: y,\n        right: left + size.w,\n        bottom: y + size.h\n    };\n}\nfunction isNotOverlapped(item, area) {\n    if (!area) {\n        return true;\n    }\n    const { left , top , right , bottom  } = item;\n    const apexesInArea = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.C)({\n        x: left,\n        y: top\n    }, area) || (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.C)({\n        x: left,\n        y: bottom\n    }, area) || (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.C)({\n        x: right,\n        y: top\n    }, area) || (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.C)({\n        x: right,\n        y: bottom\n    }, area);\n    return !apexesInArea;\n}\nfunction buildPointLabelItems(scale, labelSizes, padding) {\n    const items = [];\n    const valueCount = scale._pointLabels.length;\n    const opts = scale.options;\n    const { centerPointLabels , display  } = opts.pointLabels;\n    const itemOpts = {\n        extra: getTickBackdropHeight(opts) / 2,\n        additionalAngle: centerPointLabels ? _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.P / valueCount : 0\n    };\n    let area;\n    for(let i = 0; i < valueCount; i++){\n        itemOpts.padding = padding[i];\n        itemOpts.size = labelSizes[i];\n        const item = createPointLabelItem(scale, i, itemOpts);\n        items.push(item);\n        if (display === 'auto') {\n            item.visible = isNotOverlapped(item, area);\n            if (item.visible) {\n                area = item;\n            }\n        }\n    }\n    return items;\n}\nfunction getTextAlignForAngle(angle) {\n    if (angle === 0 || angle === 180) {\n        return 'center';\n    } else if (angle < 180) {\n        return 'left';\n    }\n    return 'right';\n}\nfunction leftForTextAlign(x, w, align) {\n    if (align === 'right') {\n        x -= w;\n    } else if (align === 'center') {\n        x -= w / 2;\n    }\n    return x;\n}\nfunction yForAngle(y, h, angle) {\n    if (angle === 90 || angle === 270) {\n        y -= h / 2;\n    } else if (angle > 270 || angle < 90) {\n        y -= h;\n    }\n    return y;\n}\nfunction drawPointLabelBox(ctx, opts, item) {\n    const { left , top , right , bottom  } = item;\n    const { backdropColor  } = opts;\n    if (!(0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.k)(backdropColor)) {\n        const borderRadius = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.ax)(opts.borderRadius);\n        const padding = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.E)(opts.backdropPadding);\n        ctx.fillStyle = backdropColor;\n        const backdropLeft = left - padding.left;\n        const backdropTop = top - padding.top;\n        const backdropWidth = right - left + padding.width;\n        const backdropHeight = bottom - top + padding.height;\n        if (Object.values(borderRadius).some((v)=>v !== 0)) {\n            ctx.beginPath();\n            (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.av)(ctx, {\n                x: backdropLeft,\n                y: backdropTop,\n                w: backdropWidth,\n                h: backdropHeight,\n                radius: borderRadius\n            });\n            ctx.fill();\n        } else {\n            ctx.fillRect(backdropLeft, backdropTop, backdropWidth, backdropHeight);\n        }\n    }\n}\nfunction drawPointLabels(scale, labelCount) {\n    const { ctx , options: { pointLabels  }  } = scale;\n    for(let i = labelCount - 1; i >= 0; i--){\n        const item = scale._pointLabelItems[i];\n        if (!item.visible) {\n            continue;\n        }\n        const optsAtIndex = pointLabels.setContext(scale.getPointLabelContext(i));\n        drawPointLabelBox(ctx, optsAtIndex, item);\n        const plFont = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a0)(optsAtIndex.font);\n        const { x , y , textAlign  } = item;\n        (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.Z)(ctx, scale._pointLabels[i], x, y + plFont.lineHeight / 2, plFont, {\n            color: optsAtIndex.color,\n            textAlign: textAlign,\n            textBaseline: 'middle'\n        });\n    }\n}\nfunction pathRadiusLine(scale, radius, circular, labelCount) {\n    const { ctx  } = scale;\n    if (circular) {\n        ctx.arc(scale.xCenter, scale.yCenter, radius, 0, _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.T);\n    } else {\n        let pointPosition = scale.getPointPosition(0, radius);\n        ctx.moveTo(pointPosition.x, pointPosition.y);\n        for(let i = 1; i < labelCount; i++){\n            pointPosition = scale.getPointPosition(i, radius);\n            ctx.lineTo(pointPosition.x, pointPosition.y);\n        }\n    }\n}\nfunction drawRadiusLine(scale, gridLineOpts, radius, labelCount, borderOpts) {\n    const ctx = scale.ctx;\n    const circular = gridLineOpts.circular;\n    const { color , lineWidth  } = gridLineOpts;\n    if (!circular && !labelCount || !color || !lineWidth || radius < 0) {\n        return;\n    }\n    ctx.save();\n    ctx.strokeStyle = color;\n    ctx.lineWidth = lineWidth;\n    ctx.setLineDash(borderOpts.dash || []);\n    ctx.lineDashOffset = borderOpts.dashOffset;\n    ctx.beginPath();\n    pathRadiusLine(scale, radius, circular, labelCount);\n    ctx.closePath();\n    ctx.stroke();\n    ctx.restore();\n}\nfunction createPointLabelContext(parent, index, label) {\n    return (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.j)(parent, {\n        label,\n        index,\n        type: 'pointLabel'\n    });\n}\nclass RadialLinearScale extends LinearScaleBase {\n    static id = 'radialLinear';\n static defaults = {\n        display: true,\n        animate: true,\n        position: 'chartArea',\n        angleLines: {\n            display: true,\n            lineWidth: 1,\n            borderDash: [],\n            borderDashOffset: 0.0\n        },\n        grid: {\n            circular: false\n        },\n        startAngle: 0,\n        ticks: {\n            showLabelBackdrop: true,\n            callback: _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.aM.formatters.numeric\n        },\n        pointLabels: {\n            backdropColor: undefined,\n            backdropPadding: 2,\n            display: true,\n            font: {\n                size: 10\n            },\n            callback (label) {\n                return label;\n            },\n            padding: 5,\n            centerPointLabels: false\n        }\n    };\n    static defaultRoutes = {\n        'angleLines.color': 'borderColor',\n        'pointLabels.color': 'color',\n        'ticks.color': 'color'\n    };\n    static descriptors = {\n        angleLines: {\n            _fallback: 'grid'\n        }\n    };\n    constructor(cfg){\n        super(cfg);\n         this.xCenter = undefined;\n         this.yCenter = undefined;\n         this.drawingArea = undefined;\n         this._pointLabels = [];\n        this._pointLabelItems = [];\n    }\n    setDimensions() {\n        const padding = this._padding = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.E)(getTickBackdropHeight(this.options) / 2);\n        const w = this.width = this.maxWidth - padding.width;\n        const h = this.height = this.maxHeight - padding.height;\n        this.xCenter = Math.floor(this.left + w / 2 + padding.left);\n        this.yCenter = Math.floor(this.top + h / 2 + padding.top);\n        this.drawingArea = Math.floor(Math.min(w, h) / 2);\n    }\n    determineDataLimits() {\n        const { min , max  } = this.getMinMax(false);\n        this.min = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.g)(min) && !isNaN(min) ? min : 0;\n        this.max = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.g)(max) && !isNaN(max) ? max : 0;\n        this.handleTickRangeOptions();\n    }\n computeTickLimit() {\n        return Math.ceil(this.drawingArea / getTickBackdropHeight(this.options));\n    }\n    generateTickLabels(ticks) {\n        LinearScaleBase.prototype.generateTickLabels.call(this, ticks);\n        this._pointLabels = this.getLabels().map((value, index)=>{\n            const label = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.Q)(this.options.pointLabels.callback, [\n                value,\n                index\n            ], this);\n            return label || label === 0 ? label : '';\n        }).filter((v, i)=>this.chart.getDataVisibility(i));\n    }\n    fit() {\n        const opts = this.options;\n        if (opts.display && opts.pointLabels.display) {\n            fitWithPointLabels(this);\n        } else {\n            this.setCenterPoint(0, 0, 0, 0);\n        }\n    }\n    setCenterPoint(leftMovement, rightMovement, topMovement, bottomMovement) {\n        this.xCenter += Math.floor((leftMovement - rightMovement) / 2);\n        this.yCenter += Math.floor((topMovement - bottomMovement) / 2);\n        this.drawingArea -= Math.min(this.drawingArea / 2, Math.max(leftMovement, rightMovement, topMovement, bottomMovement));\n    }\n    getIndexAngle(index) {\n        const angleMultiplier = _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.T / (this._pointLabels.length || 1);\n        const startAngle = this.options.startAngle || 0;\n        return (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.az)(index * angleMultiplier + (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.t)(startAngle));\n    }\n    getDistanceFromCenterForValue(value) {\n        if ((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.k)(value)) {\n            return NaN;\n        }\n        const scalingFactor = this.drawingArea / (this.max - this.min);\n        if (this.options.reverse) {\n            return (this.max - value) * scalingFactor;\n        }\n        return (value - this.min) * scalingFactor;\n    }\n    getValueForDistanceFromCenter(distance) {\n        if ((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.k)(distance)) {\n            return NaN;\n        }\n        const scaledDistance = distance / (this.drawingArea / (this.max - this.min));\n        return this.options.reverse ? this.max - scaledDistance : this.min + scaledDistance;\n    }\n    getPointLabelContext(index) {\n        const pointLabels = this._pointLabels || [];\n        if (index >= 0 && index < pointLabels.length) {\n            const pointLabel = pointLabels[index];\n            return createPointLabelContext(this.getContext(), index, pointLabel);\n        }\n    }\n    getPointPosition(index, distanceFromCenter, additionalAngle = 0) {\n        const angle = this.getIndexAngle(index) - _chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.H + additionalAngle;\n        return {\n            x: Math.cos(angle) * distanceFromCenter + this.xCenter,\n            y: Math.sin(angle) * distanceFromCenter + this.yCenter,\n            angle\n        };\n    }\n    getPointPositionForValue(index, value) {\n        return this.getPointPosition(index, this.getDistanceFromCenterForValue(value));\n    }\n    getBasePosition(index) {\n        return this.getPointPositionForValue(index || 0, this.getBaseValue());\n    }\n    getPointLabelPosition(index) {\n        const { left , top , right , bottom  } = this._pointLabelItems[index];\n        return {\n            left,\n            top,\n            right,\n            bottom\n        };\n    }\n drawBackground() {\n        const { backgroundColor , grid: { circular  }  } = this.options;\n        if (backgroundColor) {\n            const ctx = this.ctx;\n            ctx.save();\n            ctx.beginPath();\n            pathRadiusLine(this, this.getDistanceFromCenterForValue(this._endValue), circular, this._pointLabels.length);\n            ctx.closePath();\n            ctx.fillStyle = backgroundColor;\n            ctx.fill();\n            ctx.restore();\n        }\n    }\n drawGrid() {\n        const ctx = this.ctx;\n        const opts = this.options;\n        const { angleLines , grid , border  } = opts;\n        const labelCount = this._pointLabels.length;\n        let i, offset, position;\n        if (opts.pointLabels.display) {\n            drawPointLabels(this, labelCount);\n        }\n        if (grid.display) {\n            this.ticks.forEach((tick, index)=>{\n                if (index !== 0 || index === 0 && this.min < 0) {\n                    offset = this.getDistanceFromCenterForValue(tick.value);\n                    const context = this.getContext(index);\n                    const optsAtIndex = grid.setContext(context);\n                    const optsAtIndexBorder = border.setContext(context);\n                    drawRadiusLine(this, optsAtIndex, offset, labelCount, optsAtIndexBorder);\n                }\n            });\n        }\n        if (angleLines.display) {\n            ctx.save();\n            for(i = labelCount - 1; i >= 0; i--){\n                const optsAtIndex = angleLines.setContext(this.getPointLabelContext(i));\n                const { color , lineWidth  } = optsAtIndex;\n                if (!lineWidth || !color) {\n                    continue;\n                }\n                ctx.lineWidth = lineWidth;\n                ctx.strokeStyle = color;\n                ctx.setLineDash(optsAtIndex.borderDash);\n                ctx.lineDashOffset = optsAtIndex.borderDashOffset;\n                offset = this.getDistanceFromCenterForValue(opts.reverse ? this.min : this.max);\n                position = this.getPointPosition(i, offset);\n                ctx.beginPath();\n                ctx.moveTo(this.xCenter, this.yCenter);\n                ctx.lineTo(position.x, position.y);\n                ctx.stroke();\n            }\n            ctx.restore();\n        }\n    }\n drawBorder() {}\n drawLabels() {\n        const ctx = this.ctx;\n        const opts = this.options;\n        const tickOpts = opts.ticks;\n        if (!tickOpts.display) {\n            return;\n        }\n        const startAngle = this.getIndexAngle(0);\n        let offset, width;\n        ctx.save();\n        ctx.translate(this.xCenter, this.yCenter);\n        ctx.rotate(startAngle);\n        ctx.textAlign = 'center';\n        ctx.textBaseline = 'middle';\n        this.ticks.forEach((tick, index)=>{\n            if (index === 0 && this.min >= 0 && !opts.reverse) {\n                return;\n            }\n            const optsAtIndex = tickOpts.setContext(this.getContext(index));\n            const tickFont = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.a0)(optsAtIndex.font);\n            offset = this.getDistanceFromCenterForValue(this.ticks[index].value);\n            if (optsAtIndex.showLabelBackdrop) {\n                ctx.font = tickFont.string;\n                width = ctx.measureText(tick.label).width;\n                ctx.fillStyle = optsAtIndex.backdropColor;\n                const padding = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.E)(optsAtIndex.backdropPadding);\n                ctx.fillRect(-width / 2 - padding.left, -offset - tickFont.size / 2 - padding.top, width + padding.width, tickFont.size + padding.height);\n            }\n            (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.Z)(ctx, tick.label, 0, -offset, tickFont, {\n                color: optsAtIndex.color,\n                strokeColor: optsAtIndex.textStrokeColor,\n                strokeWidth: optsAtIndex.textStrokeWidth\n            });\n        });\n        ctx.restore();\n    }\n drawTitle() {}\n}\n\nconst INTERVALS = {\n    millisecond: {\n        common: true,\n        size: 1,\n        steps: 1000\n    },\n    second: {\n        common: true,\n        size: 1000,\n        steps: 60\n    },\n    minute: {\n        common: true,\n        size: 60000,\n        steps: 60\n    },\n    hour: {\n        common: true,\n        size: 3600000,\n        steps: 24\n    },\n    day: {\n        common: true,\n        size: 86400000,\n        steps: 30\n    },\n    week: {\n        common: false,\n        size: 604800000,\n        steps: 4\n    },\n    month: {\n        common: true,\n        size: 2.628e9,\n        steps: 12\n    },\n    quarter: {\n        common: false,\n        size: 7.884e9,\n        steps: 4\n    },\n    year: {\n        common: true,\n        size: 3.154e10\n    }\n};\n const UNITS =  /* #__PURE__ */ Object.keys(INTERVALS);\n function sorter(a, b) {\n    return a - b;\n}\n function parse(scale, input) {\n    if ((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.k)(input)) {\n        return null;\n    }\n    const adapter = scale._adapter;\n    const { parser , round , isoWeekday  } = scale._parseOpts;\n    let value = input;\n    if (typeof parser === 'function') {\n        value = parser(value);\n    }\n    if (!(0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.g)(value)) {\n        value = typeof parser === 'string' ? adapter.parse(value, parser) : adapter.parse(value);\n    }\n    if (value === null) {\n        return null;\n    }\n    if (round) {\n        value = round === 'week' && ((0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.x)(isoWeekday) || isoWeekday === true) ? adapter.startOf(value, 'isoWeek', isoWeekday) : adapter.startOf(value, round);\n    }\n    return +value;\n}\n function determineUnitForAutoTicks(minUnit, min, max, capacity) {\n    const ilen = UNITS.length;\n    for(let i = UNITS.indexOf(minUnit); i < ilen - 1; ++i){\n        const interval = INTERVALS[UNITS[i]];\n        const factor = interval.steps ? interval.steps : Number.MAX_SAFE_INTEGER;\n        if (interval.common && Math.ceil((max - min) / (factor * interval.size)) <= capacity) {\n            return UNITS[i];\n        }\n    }\n    return UNITS[ilen - 1];\n}\n function determineUnitForFormatting(scale, numTicks, minUnit, min, max) {\n    for(let i = UNITS.length - 1; i >= UNITS.indexOf(minUnit); i--){\n        const unit = UNITS[i];\n        if (INTERVALS[unit].common && scale._adapter.diff(max, min, unit) >= numTicks - 1) {\n            return unit;\n        }\n    }\n    return UNITS[minUnit ? UNITS.indexOf(minUnit) : 0];\n}\n function determineMajorUnit(unit) {\n    for(let i = UNITS.indexOf(unit) + 1, ilen = UNITS.length; i < ilen; ++i){\n        if (INTERVALS[UNITS[i]].common) {\n            return UNITS[i];\n        }\n    }\n}\n function addTick(ticks, time, timestamps) {\n    if (!timestamps) {\n        ticks[time] = true;\n    } else if (timestamps.length) {\n        const { lo , hi  } = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.aQ)(timestamps, time);\n        const timestamp = timestamps[lo] >= time ? timestamps[lo] : timestamps[hi];\n        ticks[timestamp] = true;\n    }\n}\n function setMajorTicks(scale, ticks, map, majorUnit) {\n    const adapter = scale._adapter;\n    const first = +adapter.startOf(ticks[0].value, majorUnit);\n    const last = ticks[ticks.length - 1].value;\n    let major, index;\n    for(major = first; major <= last; major = +adapter.add(major, 1, majorUnit)){\n        index = map[major];\n        if (index >= 0) {\n            ticks[index].major = true;\n        }\n    }\n    return ticks;\n}\n function ticksFromTimestamps(scale, values, majorUnit) {\n    const ticks = [];\n     const map = {};\n    const ilen = values.length;\n    let i, value;\n    for(i = 0; i < ilen; ++i){\n        value = values[i];\n        map[value] = i;\n        ticks.push({\n            value,\n            major: false\n        });\n    }\n    return ilen === 0 || !majorUnit ? ticks : setMajorTicks(scale, ticks, map, majorUnit);\n}\nclass TimeScale extends Scale {\n    static id = 'time';\n static defaults = {\n bounds: 'data',\n        adapters: {},\n        time: {\n            parser: false,\n            unit: false,\n            round: false,\n            isoWeekday: false,\n            minUnit: 'millisecond',\n            displayFormats: {}\n        },\n        ticks: {\n source: 'auto',\n            callback: false,\n            major: {\n                enabled: false\n            }\n        }\n    };\n constructor(props){\n        super(props);\n         this._cache = {\n            data: [],\n            labels: [],\n            all: []\n        };\n         this._unit = 'day';\n         this._majorUnit = undefined;\n        this._offsets = {};\n        this._normalized = false;\n        this._parseOpts = undefined;\n    }\n    init(scaleOpts, opts = {}) {\n        const time = scaleOpts.time || (scaleOpts.time = {});\n         const adapter = this._adapter = new adapters._date(scaleOpts.adapters.date);\n        adapter.init(opts);\n        (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.ab)(time.displayFormats, adapter.formats());\n        this._parseOpts = {\n            parser: time.parser,\n            round: time.round,\n            isoWeekday: time.isoWeekday\n        };\n        super.init(scaleOpts);\n        this._normalized = opts.normalized;\n    }\n parse(raw, index) {\n        if (raw === undefined) {\n            return null;\n        }\n        return parse(this, raw);\n    }\n    beforeLayout() {\n        super.beforeLayout();\n        this._cache = {\n            data: [],\n            labels: [],\n            all: []\n        };\n    }\n    determineDataLimits() {\n        const options = this.options;\n        const adapter = this._adapter;\n        const unit = options.time.unit || 'day';\n        let { min , max , minDefined , maxDefined  } = this.getUserBounds();\n function _applyBounds(bounds) {\n            if (!minDefined && !isNaN(bounds.min)) {\n                min = Math.min(min, bounds.min);\n            }\n            if (!maxDefined && !isNaN(bounds.max)) {\n                max = Math.max(max, bounds.max);\n            }\n        }\n        if (!minDefined || !maxDefined) {\n            _applyBounds(this._getLabelBounds());\n            if (options.bounds !== 'ticks' || options.ticks.source !== 'labels') {\n                _applyBounds(this.getMinMax(false));\n            }\n        }\n        min = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.g)(min) && !isNaN(min) ? min : +adapter.startOf(Date.now(), unit);\n        max = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.g)(max) && !isNaN(max) ? max : +adapter.endOf(Date.now(), unit) + 1;\n        this.min = Math.min(min, max - 1);\n        this.max = Math.max(min + 1, max);\n    }\n _getLabelBounds() {\n        const arr = this.getLabelTimestamps();\n        let min = Number.POSITIVE_INFINITY;\n        let max = Number.NEGATIVE_INFINITY;\n        if (arr.length) {\n            min = arr[0];\n            max = arr[arr.length - 1];\n        }\n        return {\n            min,\n            max\n        };\n    }\n buildTicks() {\n        const options = this.options;\n        const timeOpts = options.time;\n        const tickOpts = options.ticks;\n        const timestamps = tickOpts.source === 'labels' ? this.getLabelTimestamps() : this._generate();\n        if (options.bounds === 'ticks' && timestamps.length) {\n            this.min = this._userMin || timestamps[0];\n            this.max = this._userMax || timestamps[timestamps.length - 1];\n        }\n        const min = this.min;\n        const max = this.max;\n        const ticks = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.aP)(timestamps, min, max);\n        this._unit = timeOpts.unit || (tickOpts.autoSkip ? determineUnitForAutoTicks(timeOpts.minUnit, this.min, this.max, this._getLabelCapacity(min)) : determineUnitForFormatting(this, ticks.length, timeOpts.minUnit, this.min, this.max));\n        this._majorUnit = !tickOpts.major.enabled || this._unit === 'year' ? undefined : determineMajorUnit(this._unit);\n        this.initOffsets(timestamps);\n        if (options.reverse) {\n            ticks.reverse();\n        }\n        return ticksFromTimestamps(this, ticks, this._majorUnit);\n    }\n    afterAutoSkip() {\n        if (this.options.offsetAfterAutoskip) {\n            this.initOffsets(this.ticks.map((tick)=>+tick.value));\n        }\n    }\n initOffsets(timestamps = []) {\n        let start = 0;\n        let end = 0;\n        let first, last;\n        if (this.options.offset && timestamps.length) {\n            first = this.getDecimalForValue(timestamps[0]);\n            if (timestamps.length === 1) {\n                start = 1 - first;\n            } else {\n                start = (this.getDecimalForValue(timestamps[1]) - first) / 2;\n            }\n            last = this.getDecimalForValue(timestamps[timestamps.length - 1]);\n            if (timestamps.length === 1) {\n                end = last;\n            } else {\n                end = (last - this.getDecimalForValue(timestamps[timestamps.length - 2])) / 2;\n            }\n        }\n        const limit = timestamps.length < 3 ? 0.5 : 0.25;\n        start = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.S)(start, 0, limit);\n        end = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.S)(end, 0, limit);\n        this._offsets = {\n            start,\n            end,\n            factor: 1 / (start + 1 + end)\n        };\n    }\n _generate() {\n        const adapter = this._adapter;\n        const min = this.min;\n        const max = this.max;\n        const options = this.options;\n        const timeOpts = options.time;\n        const minor = timeOpts.unit || determineUnitForAutoTicks(timeOpts.minUnit, min, max, this._getLabelCapacity(min));\n        const stepSize = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.v)(options.ticks.stepSize, 1);\n        const weekday = minor === 'week' ? timeOpts.isoWeekday : false;\n        const hasWeekday = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.x)(weekday) || weekday === true;\n        const ticks = {};\n        let first = min;\n        let time, count;\n        if (hasWeekday) {\n            first = +adapter.startOf(first, 'isoWeek', weekday);\n        }\n        first = +adapter.startOf(first, hasWeekday ? 'day' : minor);\n        if (adapter.diff(max, min, minor) > 100000 * stepSize) {\n            throw new Error(min + ' and ' + max + ' are too far apart with stepSize of ' + stepSize + ' ' + minor);\n        }\n        const timestamps = options.ticks.source === 'data' && this.getDataTimestamps();\n        for(time = first, count = 0; time < max; time = +adapter.add(time, stepSize, minor), count++){\n            addTick(ticks, time, timestamps);\n        }\n        if (time === max || options.bounds === 'ticks' || count === 1) {\n            addTick(ticks, time, timestamps);\n        }\n        return Object.keys(ticks).sort(sorter).map((x)=>+x);\n    }\n getLabelForValue(value) {\n        const adapter = this._adapter;\n        const timeOpts = this.options.time;\n        if (timeOpts.tooltipFormat) {\n            return adapter.format(value, timeOpts.tooltipFormat);\n        }\n        return adapter.format(value, timeOpts.displayFormats.datetime);\n    }\n format(value, format) {\n        const options = this.options;\n        const formats = options.time.displayFormats;\n        const unit = this._unit;\n        const fmt = format || formats[unit];\n        return this._adapter.format(value, fmt);\n    }\n _tickFormatFunction(time, index, ticks, format) {\n        const options = this.options;\n        const formatter = options.ticks.callback;\n        if (formatter) {\n            return (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.Q)(formatter, [\n                time,\n                index,\n                ticks\n            ], this);\n        }\n        const formats = options.time.displayFormats;\n        const unit = this._unit;\n        const majorUnit = this._majorUnit;\n        const minorFormat = unit && formats[unit];\n        const majorFormat = majorUnit && formats[majorUnit];\n        const tick = ticks[index];\n        const major = majorUnit && majorFormat && tick && tick.major;\n        return this._adapter.format(time, format || (major ? majorFormat : minorFormat));\n    }\n generateTickLabels(ticks) {\n        let i, ilen, tick;\n        for(i = 0, ilen = ticks.length; i < ilen; ++i){\n            tick = ticks[i];\n            tick.label = this._tickFormatFunction(tick.value, i, ticks);\n        }\n    }\n getDecimalForValue(value) {\n        return value === null ? NaN : (value - this.min) / (this.max - this.min);\n    }\n getPixelForValue(value) {\n        const offsets = this._offsets;\n        const pos = this.getDecimalForValue(value);\n        return this.getPixelForDecimal((offsets.start + pos) * offsets.factor);\n    }\n getValueForPixel(pixel) {\n        const offsets = this._offsets;\n        const pos = this.getDecimalForPixel(pixel) / offsets.factor - offsets.end;\n        return this.min + pos * (this.max - this.min);\n    }\n _getLabelSize(label) {\n        const ticksOpts = this.options.ticks;\n        const tickLabelWidth = this.ctx.measureText(label).width;\n        const angle = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.t)(this.isHorizontal() ? ticksOpts.maxRotation : ticksOpts.minRotation);\n        const cosRotation = Math.cos(angle);\n        const sinRotation = Math.sin(angle);\n        const tickFontSize = this._resolveTickFontOptions(0).size;\n        return {\n            w: tickLabelWidth * cosRotation + tickFontSize * sinRotation,\n            h: tickLabelWidth * sinRotation + tickFontSize * cosRotation\n        };\n    }\n _getLabelCapacity(exampleTime) {\n        const timeOpts = this.options.time;\n        const displayFormats = timeOpts.displayFormats;\n        const format = displayFormats[timeOpts.unit] || displayFormats.millisecond;\n        const exampleLabel = this._tickFormatFunction(exampleTime, 0, ticksFromTimestamps(this, [\n            exampleTime\n        ], this._majorUnit), format);\n        const size = this._getLabelSize(exampleLabel);\n        const capacity = Math.floor(this.isHorizontal() ? this.width / size.w : this.height / size.h) - 1;\n        return capacity > 0 ? capacity : 1;\n    }\n getDataTimestamps() {\n        let timestamps = this._cache.data || [];\n        let i, ilen;\n        if (timestamps.length) {\n            return timestamps;\n        }\n        const metas = this.getMatchingVisibleMetas();\n        if (this._normalized && metas.length) {\n            return this._cache.data = metas[0].controller.getAllParsedValues(this);\n        }\n        for(i = 0, ilen = metas.length; i < ilen; ++i){\n            timestamps = timestamps.concat(metas[i].controller.getAllParsedValues(this));\n        }\n        return this._cache.data = this.normalize(timestamps);\n    }\n getLabelTimestamps() {\n        const timestamps = this._cache.labels || [];\n        let i, ilen;\n        if (timestamps.length) {\n            return timestamps;\n        }\n        const labels = this.getLabels();\n        for(i = 0, ilen = labels.length; i < ilen; ++i){\n            timestamps.push(parse(this, labels[i]));\n        }\n        return this._cache.labels = this._normalized ? timestamps : this.normalize(timestamps);\n    }\n normalize(values) {\n        return (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__._)(values.sort(sorter));\n    }\n}\n\nfunction interpolate(table, val, reverse) {\n    let lo = 0;\n    let hi = table.length - 1;\n    let prevSource, nextSource, prevTarget, nextTarget;\n    if (reverse) {\n        if (val >= table[lo].pos && val <= table[hi].pos) {\n            ({ lo , hi  } = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.B)(table, 'pos', val));\n        }\n        ({ pos: prevSource , time: prevTarget  } = table[lo]);\n        ({ pos: nextSource , time: nextTarget  } = table[hi]);\n    } else {\n        if (val >= table[lo].time && val <= table[hi].time) {\n            ({ lo , hi  } = (0,_chunks_helpers_dataset_js__WEBPACK_IMPORTED_MODULE_0__.B)(table, 'time', val));\n        }\n        ({ time: prevSource , pos: prevTarget  } = table[lo]);\n        ({ time: nextSource , pos: nextTarget  } = table[hi]);\n    }\n    const span = nextSource - prevSource;\n    return span ? prevTarget + (nextTarget - prevTarget) * (val - prevSource) / span : prevTarget;\n}\nclass TimeSeriesScale extends TimeScale {\n    static id = 'timeseries';\n static defaults = TimeScale.defaults;\n constructor(props){\n        super(props);\n         this._table = [];\n         this._minPos = undefined;\n         this._tableRange = undefined;\n    }\n initOffsets() {\n        const timestamps = this._getTimestampsForTable();\n        const table = this._table = this.buildLookupTable(timestamps);\n        this._minPos = interpolate(table, this.min);\n        this._tableRange = interpolate(table, this.max) - this._minPos;\n        super.initOffsets(timestamps);\n    }\n buildLookupTable(timestamps) {\n        const { min , max  } = this;\n        const items = [];\n        const table = [];\n        let i, ilen, prev, curr, next;\n        for(i = 0, ilen = timestamps.length; i < ilen; ++i){\n            curr = timestamps[i];\n            if (curr >= min && curr <= max) {\n                items.push(curr);\n            }\n        }\n        if (items.length < 2) {\n            return [\n                {\n                    time: min,\n                    pos: 0\n                },\n                {\n                    time: max,\n                    pos: 1\n                }\n            ];\n        }\n        for(i = 0, ilen = items.length; i < ilen; ++i){\n            next = items[i + 1];\n            prev = items[i - 1];\n            curr = items[i];\n            if (Math.round((next + prev) / 2) !== curr) {\n                table.push({\n                    time: curr,\n                    pos: i / (ilen - 1)\n                });\n            }\n        }\n        return table;\n    }\n _generate() {\n        const min = this.min;\n        const max = this.max;\n        let timestamps = super.getDataTimestamps();\n        if (!timestamps.includes(min) || !timestamps.length) {\n            timestamps.splice(0, 0, min);\n        }\n        if (!timestamps.includes(max) || timestamps.length === 1) {\n            timestamps.push(max);\n        }\n        return timestamps.sort((a, b)=>a - b);\n    }\n _getTimestampsForTable() {\n        let timestamps = this._cache.all || [];\n        if (timestamps.length) {\n            return timestamps;\n        }\n        const data = this.getDataTimestamps();\n        const label = this.getLabelTimestamps();\n        if (data.length && label.length) {\n            timestamps = this.normalize(data.concat(label));\n        } else {\n            timestamps = data.length ? data : label;\n        }\n        timestamps = this._cache.all = timestamps;\n        return timestamps;\n    }\n getDecimalForValue(value) {\n        return (interpolate(this._table, value) - this._minPos) / this._tableRange;\n    }\n getValueForPixel(pixel) {\n        const offsets = this._offsets;\n        const decimal = this.getDecimalForPixel(pixel) / offsets.factor - offsets.end;\n        return interpolate(this._table, decimal * this._tableRange + this._minPos, true);\n    }\n}\n\nvar scales = /*#__PURE__*/Object.freeze({\n__proto__: null,\nCategoryScale: CategoryScale,\nLinearScale: LinearScale,\nLogarithmicScale: LogarithmicScale,\nRadialLinearScale: RadialLinearScale,\nTimeScale: TimeScale,\nTimeSeriesScale: TimeSeriesScale\n});\n\nconst registerables = [\n    controllers,\n    elements,\n    plugins,\n    scales\n];\n\n\n//# sourceMappingURL=chart.js.map\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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